| assoc class |

(Dialog confirm: 'This will uninstall the Refactoring Browser.\You should save your image first to be safe.\Do you wish to proceed?' withCRs)
ifTrue: [

ObjectMemory globalGarbageCollect.
class := Smalltalk at: #BrowserCodeTool ifAbsent: [nil].
class notNil ifTrue: [ChangeSet withAllSubclasses do: [:cls | cls allInstances do: [:inst |
	inst dependents copy do: [:each | each class == class ifTrue: [inst removeDependent: each]]]]].

class := Smalltalk at: #RefactoringBrowser ifAbsent: [nil].
class notNil 
	ifTrue: [
		class allInstances isEmpty 
			ifFalse: [(Dialog confirm: 'You need to close all old browser windows before uninstalling.\Do you wish to proceed?' withCRs) 
					ifFalse: [^false]]].

class := Smalltalk at: #Smalllint ifAbsent: [nil].
class notNil 
	ifTrue: [
		class allInstances isEmpty 
			ifFalse: [(Dialog confirm: 'You need to close all old Smalllint windows before uninstalling.\Do you wish to proceed?' withCRs) 
					ifFalse: [^false]]].

class := Smalltalk at: #RewriteRuleEditor ifAbsent: [nil].
class notNil 
	ifTrue: [
		class allInstances isEmpty 
			ifFalse: [(Dialog confirm: 'You need to close all old rewrite windows before uninstalling.\Do you wish to proceed?' withCRs) 
					ifFalse: [^false]]].


#(#AbstractClassVariableRefactoring #AbstractCondition 
#AbstractInstanceVariableRefactoring #AbstractVariablesRefactoring 
#AddClassChange #AddClassRefactoring #AddClassVariableChange 
#AddClassVariableRefactoring #AddInstanceVariableChange 
#AddInstanceVariableRefactoring #AddMethodChange #AddMethodRefactoring 
#AddParameterRefactoring #AddPoolVariableChange #AndEnvironment 
#BasicLintRule #BlockLintRule #BRAssignmentNode #BRAssignmentToken 
#BRBinarySelectorToken #BRBlockNode #BRBlockReplaceRule #BRCascadeNode 
#BRFormatter #BRIdentifierToken #BRKeywordToken #BRLiteralNode 
#BRLiteralToken #BRMessageNode #BRMetaMessageNode #BRMetaMethodNode 
#BRMetaVariableNode #BRMethodNode #BRMultiSelectionInList 
#BRMultiSelectionView #BROptimizedNode #BROptimizedToken 
#BrowserApplicationModel #BrowserClassTool #BrowserCodeTool 
#BrowserDialog #BrowserEnvironment #BrowserNavigator #BrowserTextTool 
#BRParser #BRParseTreeRule #BRProgramNode #BRProgramNodeVisitor 
#BRReadBeforeWrittenTester #BRReplaceRule #BRReturnNode #BRScanner 
#BRSearchRule #BRSequenceNode #BRSmallDictionary 
#BRSpecialCharacterToken #BRStatementNode #BRStringReplaceRule 
#BRToken #BRValueNode #BRValueToken #BRVariableNode #CanvasViewer 
#CategoryDialog #CategoryEnvironment #ChangeMethodNameRefactoring 
#ChildrenToSiblingsRefactoring #ClassCommentTool #ClassEnvironment 
#ClassNavigatorTool #ClassRefactoring #ClassSelectionDialog 
#ClassSelectorNavigator #CodeModel #CodeModelLockPolicy #CodeTool 
#CompositeLintRule #Condition #ConjunctiveCondition 
#CreateAccessorsForVariableRefactoring #EnvironmentEditor 
#ExtractMethodRefactoring #ExtractToTemporaryRefactoring #IconViewer 
#InlineAllSendersRefactoring #InlineMethodFromComponentRefactoring 
#InlineMethodRefactoring #InlineParameterRefactoring 
#InlineTemporaryRefactoring #InteractiveAddClassChange 
#InteractiveAddMethodChange #LimitedEnvironment #LintRule #MenuViewer 
#MethodNameDialog #MethodRefactoring #MoveMethodRefactoring 
#MoveVariableDefinitionRefactoring #MultiEnvironment #MultiNavigator 
#Navigator #NavigatorState #NegationCondition #NotEnvironment 
#OMTClassController #OMTClassDiagram #OMTClassModel #OMTClassTool 
#OMTClassView #OrganizationEditor #ParseTreeEnvironment 
#ParseTreeLintRule #ParseTreeRewriter #ParseTreeSearcher 
#ProtectInstanceVariableRefactoring #ProtocolEnvironment 
#PullUpClassVariableRefactoring #PullUpInstanceVariableRefactoring 
#PushDownClassVariableRefactoring #PushDownInstanceVariableRefactoring 
#PushDownMethodRefactoring #PushUpMethodRefactoring #Refactoring 
#RefactoringBrowser #RefactoringManager #RefactoryBuilder 
#RefactoryBuilderInspector #RefactoryChange #RefactoryClassChange 
#RefactoryTyper #RefactoryVariableChange #ReferenceFinder 
#RemoveClassChange #RemoveClassRefactoring #RemoveClassVariableChange 
#RemoveClassVariableRefactoring #RemoveInstanceVariableChange 
#RemoveInstanceVariableRefactoring #RemoveMethodChange 
#RemoveMethodRefactoring #RemoveParameterRefactoring 
#RemovePoolVariableChange #RenameClassChange #RenameClassRefactoring 
#RenameClassVariableRefactoring #RenameInstanceVariableRefactoring 
#RenameMethodRefactoring #RenameTempRefactoring #ResourceTool 
#RestoringVariableRefactoring #RestrictedEnvironment 
#RewriteRuleEditor #Smalllint #SmalllintContext #SmalllintResultEditor 
#StateLockPolicy #SystemNavigator #TempToInstVarRefactoring 
#TransformationRule #UnreferencedVariables #ValueHolderRefactoring 
#VariableRefactoring #VariableTypeDialog #WindowLockPolicy)
	do: [:each | | class |
		class := Smalltalk at: each ifAbsent: [nil].
		class notNil 
			ifTrue: [class removeFromSystem]].

#(#'Refactory-Parser' 
#'Refactory-Browser' 
#'Refactory-Environments' 
#'Refactory-Navigator' 
#'Refactory-Support' 
#'Refactory-Refactorings' 
#'Refactory-Conditions' 
#'Refactory-OMT-Diagram' 
#'Refactory-Code Tools' 
#'Refactory-Lint') do: 
	[:each | (Smalltalk organization listAtCategoryNamed: each) isEmpty ifTrue: [
		Smalltalk organization removeCategory: each]].



(Dialog confirm: 'Do you want to remove unreferenced variables from the Undeclared pool?')
	ifTrue: [
assoc :=  WeakArray withAll: Undeclared associations.
Undeclared := Undeclared class new.
ObjectMemory globalGarbageCollect.
assoc do: [:each | each == 0 ifFalse: [Undeclared add: each]]].
true]

ifFalse: [false]
