

!Bitmap class methods !
 
releaseResourcesIfNecessary

    (HALSTVLibrary isGDIResourcesLowEnough)
        ifTrue: [ self purgeUnusedBitmapsQuietly ].

!

purgeUnusedBitmapsQuietly

    CursorManager execute
        changeFor: [ self purgeUnusedBitmaps: false ]
!

purgeUnusedBitmaps: aBoolean
    "Modified by HAL - provide Digitalk fix"
        "Private - Purge unused bitmaps from the system."
    | handles all bitmaps aDialog total number |
    all := BitmapHandleTable keys.
    BitmapHandleTable := Dictionary new.
    bitmaps := Bitmap allInstances.
    handles := bitmaps collect: [ :each | each bitmapHandle ].
    GDILibrary selectObject: MemoryContext with: DefaultBitmap.
    (aBoolean)
        ifTrue: [
            aDialog := ProgressIndicatorDialog new noCancel;
                    open: 'Purging Unused Bitmaps' message: 'Please stand-by...'
        ].
    number := 0.
    [ total := (all size) + (bitmaps size).
        all do: [ :each |
            ( each notNil and: [ ( handles includes: each ) not ] )
                ifTrue: [ ( GDILibrary deleteObject: each ) ifFalse: [ self osWarning ] ].
            (aDialog notNil)
                ifTrue: [ aDialog percent: ((number := number + 1) // total) * 100 ].
        ].
        bitmaps do: [ :each |
            (each bitmapHandle notNil)
                ifTrue: [
                    BitmapHandleTable at: each bitmapHandle put: each.
                    each saveBitmapNoDeselect.
                ].
            (aDialog notNil)
                ifTrue: [ aDialog percent: ((number := number + 1) // total) * 100 ].
        ].
        self allInstancesPrim. "force GC"
    ] ensure: [ (aDialog notNil) ifTrue: [ aDialog close ] ].
!
  
purgeUnusedBitmapsVisually

    CursorManager execute
        changeFor: [ self purgeUnusedBitmaps: true ]

!
  
purgeUnusedBitmapsDiscreetly

    [ self purgeUnusedBitmaps: false ] forkAt: 1.
!    !


!Bitmap methods !    !


!EnvyWindowBuilder class methods !   !


!EnvyWindowBuilder methods !
 
close: ignore

    Bitmap purgeUnusedBitmapsDiscreetly.

    ^super close: ignore
!    !


!HALBitmapManager class methods !    !


!HALBitmapManager methods !
  
open

    Bitmap releaseResourcesIfNecessary.

    ^super open
!
   
save

    super save.

    Bitmap purgeUnusedBitmapsQuietly.
!
 
exit

    Bitmap purgeUnusedBitmapsQuietly.

    ^super exit.

!  !


!HALSTVDLL16 class methods ! !


!HALSTVDLL16 methods !
   
isGDIResourcesLowEnough

    ^((self getFreeGDIResources) < 50)
!    !
