/**********************************************************************/
/*                                                                    */
/* HAL Support Library for Win 3.1 Entry Points             (Windows) */
/*                                                                    */
/* File:  HALSTV.C                                                    */
/*                                                                    */
/**********************************************************************/

#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define	DEBUG_TEXT( h, s)	_lwrite( h, s, strlen( s));

#ifdef	MYDEBUG
	static	OFSTRUCT	ofs;
	static	int			hFile;
	static	char		ioBuf[ 1024];
#endif	// MYDEBUG

int	FAR	PASCAL	LibMain( HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize, LPSTR lpszCmdLine)
{
	if (cbHeapSize != 0)	/* If DLL data seg is MOVABLE */
		UnlockData( 0);

	return( 1);				/* Initialization successful. */
}

#ifdef	MYDEBUG
VOID	DumpDWord( PSTR text, DWORD number)
{
	ultoa( number, ioBuf, 10);
	DEBUG_TEXT( hFile, " ");
	DEBUG_TEXT( hFile, text);
	DEBUG_TEXT( hFile, ioBuf);
}

VOID	DumpWord( PSTR text, WORD number)
{
	DumpDWord( text, (DWORD) number);
}

VOID	DumpAddress( PSTR text, LPVOID address)
{
	ultoa( (DWORD) address, ioBuf, 10);
	DEBUG_TEXT( hFile, " ");
	DEBUG_TEXT( hFile, text);
	DEBUG_TEXT( hFile, ioBuf);
}

VOID	DumpString( PSTR text, LPSTR string)
{
	DEBUG_TEXT( hFile, " ");
	DEBUG_TEXT( hFile, text);
	lstrcpy( (LPSTR) ioBuf, string);
	DEBUG_TEXT( hFile, ioBuf);
}

VOID	DumpPoint( PSTR text, POINT pt)
{
	DEBUG_TEXT( hFile, " ");
	DEBUG_TEXT( hFile, text);
	DEBUG_TEXT( hFile, " (");
	ultoa( (DWORD) pt.x, ioBuf, 10);
	DEBUG_TEXT( hFile, ioBuf);
	DEBUG_TEXT( hFile, "@");
	ultoa( (DWORD) pt.y, ioBuf, 10);
	DEBUG_TEXT( hFile, ioBuf);
	DEBUG_TEXT( hFile, ")");
}

VOID	DumpShort( PSTR text, short number)
{
	itoa( number, ioBuf, 10);
	DEBUG_TEXT( hFile, " ");
	DEBUG_TEXT( hFile, text);
	DEBUG_TEXT( hFile, ioBuf);
}


VOID	DumpResult( DWORD result)
{
	DumpDWord( "result=", result);
	if (result)
		{
		DEBUG_TEXT( hFile, " (Success) ");
		}
	else
		{
		DEBUG_TEXT( hFile, " (Failure) ");
		}
}

VOID	DumpMemoryBlock( int hFile, char *ioBuf, LPSTR lpData)
{
	int					i, j, k, rows;
	WORD				wlpDataSize,
						wCount	= 0;
	unsigned char far	*lpd	= lpData;
	char				*iob	= ioBuf;
	char				*b;
	char				*d;

	static	char		data[ 33];

	wlpDataSize = (WORD) GlobalSize( HIWORD( lpData));
	rows = wlpDataSize / 16;
	DEBUG_TEXT( hFile, "\nMEMORY DUMP:\n");
	DumpWord( "Memory Block Size=", wlpDataSize);
	DumpWord( "rows=", rows);
	DEBUG_TEXT( hFile, "\n");
#if 1
	for (j = 0; j <= rows; j++)				// 16 rows
		{
		b = iob;							// drop anchor at the beginning of a line
		d = b + 16 + 1;						// drop anchor at the beginning of a line (data area)
		for (i = 0;
			 ((i < 16) && (wCount < wlpDataSize));
			 i++, wCount++)					// 16 cols/row = 256 bytes
			{
			*b = (char) ((isprint( (int) *lpd)) ? *lpd : '.');
			b++;
			itoa( *lpd, data, 16);
			strcpy( d, data);
			d += strlen( data);
			strcpy( d, " ");
			d += 1;
			lpd++;
			}
		*(b + 0) = ' ';
		*(d + 0) = '\n';
		*(d + 1) = '\0';

		DEBUG_TEXT( hFile, ioBuf);
		}
#endif
}

/**********************************************************************/
/*  Function:  ConvertStringsToPointers                               */
/*                                                                    */
/*  Functional Description:                                           */
/*  Convert a Smalltalk array of strings into an array of             */
/*  pointers by pulling pointers to each element and placing the      */
/*  pointers into an array.                                           */
/*                                                                    */
/**********************************************************************/

LPSTR	ConvertStringsToPointers( LPSTR lpData, WORD wItems)
{
	WORD	i, j;
	LPSTR	lpd	=	lpData;

	static	LPSTR	lpArray[ 15000];

	j = sizeof( lpArray) / sizeof( lpArray[0]);
	for (i = 0; ((i < wItems) && (i < j)); i++)
		{
		lpArray[ i] = lpd;
		lpd += lstrlen( lpd);
		lpd++;
		}

	return( (LPSTR) lpArray);
}
#endif	// MYDEBUG

/**********************************************************************/
/*  Function:  QueryFreeSystemResources                               */
/*                                                                    */
/*  Functional Description:                                           */
/*  Returns the percentage of free space for system resources.        */
/*                                                                    */
/**********************************************************************/

DWORD FAR PASCAL	QueryFreeSystemResources( WORD fuSysResource)
{
	WORD			result;

	result = GetFreeSystemResources( fuSysResource);

#ifdef	MYDEBUG
	hFile = OpenFile( "api.001", &ofs, OF_CREATE);
	if (hFile != -1)
		{
		DEBUG_TEXT( hFile, "QueryFreeSystemResources: ");
		DumpDWord( "fuSysResource=", fuSysResource);
		DumpResult( result);
		_lclose( hFile);
		}
#endif	// MYDEBUG

	return( result);
}

int	FAR	PASCAL	WEP( int nParameter)
{
	if (nParameter == WEP_SYSTEM_EXIT)
		{
		/* System shutdown in progress. Respond accordingly. */
		return( 1);
		}
	else
		{
		if (nParameter == WEP_FREE_DLL)
			{	/* DLL use count is zero.  Every application that had loaded the DLL has freed it. */
			return( 1);
			}
		else
			{
				/* Undefined value.  Ignore. */
			return( 1);
			}
		}
}

