"
******************************************************************************
Application : Bitmap Fixes (WB-Pro)
Date        : 12/17/94
Time        : 02:20:06 PM

Introduction
============

        NAME            Smalltalk/V Win32s v2.0 WB-Pro Bitmap Manager Fixes
        AUTHOR          rayhorn@mercury.interpath.net
        FUNCTION Fixes the release method.
        ST-VERSIONS     VWin32s 2.0
        PREREQUISITES    WB-Pro 1.0.3 or later
        CONFLICTS        N/A
        DISTRIBUTION    world
        VERSION         1.0
        DATE    12/17/94
SUMMARY Smalltalk/V Win32s v2.0 WB-Pro Bitmap Manager Fixes

This VWin32s File-In fixes a problem with the WindowBuilder-Pro Bitmap Manager.
The WindowBuilder-Pro BitmapManager allows a resource leak to persist when used
with VWin32s. For some unknown reason, Digitalk caches ALL Bitmap handles for later
use however they never release the unused Bitmap handles or Win 3.1 Bitmap resources
until the image is saved, this allows a resource leak to exist that can cause an image
to crash if Win 3.1 runs out of resources. The "fix" is to monitor Win 3.1's GDI
resource levels and then to purge unused Bitmaps whenever the GDI resource level falls
below 5%. This keeps the Digitalk resource leak from becoming too serious for those
applications that are "unaware" of this "problem" that's inherent in VWin32s. The
purging of unused bitmaps is done in a visual manner with a pop-up dialog box that shows
the progress of the operation. The visual-nes of this purging operation could be done
non-visually for machines that are fast enough to complete this operation with out any
user interuptions. The best way to handle bitmaps or any other Windows resource is to
free them as soon as they aren't needed any longer in an intelligent fashion.

The WindowBuilder-Pro BitmapManager was designed to allow the Digitalk resource leak to
persist, however it could have been modified to keep the Digitalk resource leak from
even existing since most applications don't use as many bitmaps as WB-Pro seems to. The
HALBitmapManager effectively purges each bitmap after it has been used by performing a
bitmap save without a deselect.

Ray Horn, HAL




Invoked By:
===========

HALSTVDLL16 startUp.




Description
===========

Classes : 
    HALSTVDLL16 HALBitmapManager 

Methods : 
Bitmap>>monitorAndHandleResources
Bitmap>>createBitmap:
Bitmap>>createBitmap
Bitmap>>saveBitmapNoDeselect
Bitmap>>releaseNoDeselect
ViewManager>>label
WindowBuilder class>>launchBitmapManager
Bitmap class>>purgeUnusedBitmapsVisually
DynamicLinkLibrary class>>startUp

******************************************************************************
"!

DynamicLinkLibrary16 variableByteSubclass: #HALSTVDLL16
  classVariableNames: ''
  poolDictionaries: ''!

CPBitmapManager subclass: #HALBitmapManager
  instanceVariableNames: 
    ' previousBitmap initialLabel '
  classVariableNames: ''
  poolDictionaries: ''!



!HALSTVDLL16 class methods !

fileName

    ^'HALSTV'!
  
startUp
    "Private - initialize the DLL instance"

    Smalltalk at: #HALSTVLibrary put: (HALSTVDLL16 open)! !



!HALSTVDLL16 methods !
   
getFreeGDIResources

    ^self queryFreeSystemResources: 1!
   
getFreeSystemResources

    ^self queryFreeSystemResources: 0!

getFreeUserResources

    ^self queryFreeSystemResources: 2!
  
isGDIResourcesTooLow

    ^((self getFreeGDIResources) < 5)!
  
queryFreeSystemResources: fuSysResource

    <api: QueryFreeSystemResources ushort ushort>
    ^self invalidArgument! !



!HALBitmapManager class methods ! !



!HALBitmapManager methods !

bitmapNamed: aBitmapName

    ^bitmapDictionary at: aBitmapName ifAbsent: [ nil ]!

bitmapSelected: aPane

    bitmapName := aPane selectedItem.
    (previousBitmap isNil)
        ifTrue: [ previousBitmap := bitmapName ]
        ifFalse: [
            "release the previousBitmap here"
            (self bitmapNamed: previousBitmap) saveBitmapNoDeselect.
            self updateLabel.
            previousBitmap := bitmapName.
        ].
    self changed: #graphContents:!
 
updateKeys: aPane

    self updateLabel.
    ^super updateKeys: aPane.!
  
updateLabel

    (initialLabel isNil)
        ifTrue: [ initialLabel := self label ].
    self labelWithoutPrefix: ('*** ', initialLabel, ' GDI=', (HALSTVLibrary getFreeGDIResources asString), '% ***').! !


!Bitmap methods !  
monitorAndHandleResources

    (HALSTVLibrary isGDIResourcesTooLow)
        ifTrue: [ self class purgeUnusedBitmapsVisually ].!  !

!Bitmap methods !
createBitmap: bits
        "Private - Create a Windows bitmap for the receiver and
         initialize the bitmap with bits. Answer the handle of the
         bitmap."
    | handle hdc hPrevious |
    ( hdc := UserLibrary getDC: nil ) = 0
        ifTrue: [ ^self osError ].
    palette := self createDIBPalette.
    palette == nil ifFalse: [
        ( hPrevious := GDILibrary
            selectPalette: hdc
            with: palette asParameter
            forceBackground: false ) = 0
                ifTrue: [ ^self osError ].
            ( GDILibrary realizePalette: hdc ) = 16rFFFFFFFF
                ifTrue: [ ^self osError ] ].
    bitmapInfo bitCount = 1
        ifTrue: [
            handle := self class
                createBitmap: self width
                height: self height
                planes: 1
                bitCount: 1
                bits: nil.
            ( GDILibrary
                setDIBits: hdc
                hBitmap: handle
                startScan: 0
                scans: self height
                bitsStruct: bits asParameter
                bitsInfo: bitmapInfo asParameter
                wUsage: DibRgbColors ) = 0
                    ifTrue: [ ^self osError ] ]
        ifFalse: [
            handle := self class
                createDIBitmap: hdc
                bitmapInfo: bitmapInfo
                init: CbmInit
                bits: bits
                usage: DibRgbColors ].
    palette == nil ifFalse: [
        ( GDILibrary
            selectPalette: hdc
            with: hPrevious
            forceBackground: false ) = 0
                ifTrue: [ ^self osError ] ].
    ( UserLibrary releaseDC: nil with: hdc ) = 0
        ifTrue: [ ^self osError ].
    bitmapHandle := handle.
    self monitorAndHandleResources.
    BitmapHandleTable at: handle put: self!   !

!Bitmap methods !
createBitmap
        "Private - Create a Windows bitmap for the receiver.
         Answer the handle of the bitmap."
    | handle |
    handle := bitmapInfo bitCount = 1
        ifTrue: [
            self class
                createBitmap: self width
                height: self height
                planes: 1
                bitCount: 1
                bits: nil ]
        ifFalse: [
            self class
                createDIBitmap: Display deviceContext
                bitmapInfo: bitmapInfo
                init: nil
                bits: nil
                usage: DibRgbColors ].
    bitmapHandle := handle.
    self monitorAndHandleResources.
    BitmapHandleTable at: handle put: self!    !

!Bitmap methods !
saveBitmapNoDeselect
        "Private - Save the receiver's bits in an archive buffer
        when saving image."
    bitmapHandle isNil ifTrue: [^self].
    archive isArray ifFalse: [  "not from a dll"
        archive := self getDIBits ].
    self releaseNoDeselect!   !

!Bitmap methods !
releaseNoDeselect
        "Delete the receiver from the device context. Freeing
        up all system storage associated with the receiver."
    bitmapHandle isNil ifTrue: [ ^self ].
    deviceContext = MemoryContext
        ifFalse: [ graphicsTool deleteDC ].
    ( GDILibrary deleteObject: bitmapHandle )
        ifFalse: [ self osWarning ].
    self initHandle!    !

!ViewManager methods !   
label
    "Answer aString the label of the first view."

    ^self mainView label!   !

!WindowBuilder class methods !   
launchBitmapManager

    (Smalltalk at: #HALBitmapManager) new open!  !

!Bitmap class methods !  
purgeUnusedBitmapsVisually
    "Modified by HAL - provide Digitalk fix"
        "Private - Purge unused bitmaps from the system."
    | handles all bitmaps aDialog total number |
    all := BitmapHandleTable keys.
    BitmapHandleTable := Dictionary new.
    bitmaps := Bitmap allInstances.
    handles := bitmaps collect: [ :each | each bitmapHandle ].
    GDILibrary selectObject: MemoryContext with: DefaultBitmap.
    aDialog := ProgressIndicatorDialog new noCancel; open: 'Purging Unused Bitmaps' message: 'Please stand-by...'.
    number := 0.
    [ total := (all size) + (bitmaps size).
        all do: [ :each |
            ( each notNil and: [ ( handles includes: each ) not ] )
                ifTrue: [ ( GDILibrary deleteObject: each ) ifFalse: [ self osWarning ] ].
            aDialog percent: ((number := number + 1) // total) * 100.
        ].
        bitmaps do: [ :each |
            (each bitmapHandle notNil)
                ifTrue: [
                    BitmapHandleTable at: each bitmapHandle put: each.
                    each saveBitmapNoDeselect.
                ].
            aDialog percent: ((number := number + 1) // total) * 100.
        ].
        self allInstancesPrim. "force GC"
    ] ensure: [ aDialog close ].!  !

!DynamicLinkLibrary class methods !  
startUp
        "Private - initialize global DLL handles on image startUp."
    KernelLibrary := OperatingSystem kernelHandle.
    KernelLibrary setErrorMode: SemFailcriticalerrors | SemNoopenfileerrorbox.
    UserLibrary := UserDLL getHandle.
    GDILibrary := GDIDLL getHandle.
    HALSTVDLL16 startUp.
    VirtualMachineLibrary := VirtualMachineExe open!    !

"Finalize"
 
HALSTVDLL16 startUp.


Transcript cr; show: 'Bitmap Fixes (WB-Pro) installed.'
!
