
Object subclass: #MinneStoreExamples
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: ''   !
MinneStoreExamples subclass: #Example1
  instanceVariableNames: 
    ' hasChanged '
  classVariableNames: ''
  poolDictionaries: ''  !
Example1 subclass: #Item
  instanceVariableNames: 
    ' number description price '
  classVariableNames: 
    ' instanceCache '
  poolDictionaries: '' !
Example1 subclass: #Order
  instanceVariableNames: 
    ' number lineItems total date '
  classVariableNames: ''
  poolDictionaries: ''  !
Example1 subclass: #OrderLineItem
  instanceVariableNames: 
    ' item quantity order '
  classVariableNames: ''
  poolDictionaries: ''  !
MinneStoreExamples subclass: #Example2
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: ''    !
Example2 subclass: #Person
  instanceVariableNames: 
    ' name age '
  classVariableNames: ''
  poolDictionaries: ''    !


!MinneStoreExamples class methods !
  
MinneStoreExamples
	"This is a dummy method so #fileOutApp: knows to file me out with my subclasses."

	^true!
   
open
	"Public - Open the database after setting it up."

	^MinneStoreDB openOn: self pathName.!
  
pathName
	"Implemented by subclasses."

	self implementedBySubclass!
 
setup
	"Public - Set up the test database and define the ObjectSets."

	| db |
	MinneStore initializePath: self pathName.
	db := MinneStoreDB newOn: self pathName.
	db supportMultipleUsers.
	self allSubclasses do: 
		[:each | each addObjectSetTo: db].
	db save.
	^db!
   
setupAndLoad
	"Public - Execute the setup and load the test data."

	| db |
	db := self setup.
	self storeObjectsTo: db.
	^db!

storeObjectsTo: aMinneStoreDB
	"Implemented by subclasses."

	self implementedBySubclass! !



!Example1 class methods !
 
Comment
"
	This is a grocery product order example with three classes:
		1) Order
		2) OrderLineItem
		3) Item
"!
 
new

	^super new initialize!
  
pathName
	"Private"

	^'C:\MSTest'!
  
read1

	| db |
	db := self open.
	^(db getAll: #Orders)
        where: #number eq: #(1 2);
        execute.
!

read2

	| db |
	db := self open.
	^(db getOne: #Orders)
        where: #number eq: 2;
        execute.!
   
read3

	| db |
	db := self open.
	^(db getAll: #OrderLineItems)
		where: #itemNumber isBetween: 2 and: 4;
		execute!
  
read4

	| db |
	db := self open.
	^(db getAll: #Items) 
		where: #number lt: 3; 
		and: #priceInCents isBetween: 100 and: 299;
		execute!

setup

	Item resetInstanceCache.
	^super setup.!
 
storeObjectsTo: aMinneStoreDB

	aMinneStoreDB 
		storeAll:
			(OrderedCollection 
				with: Order one
				with: Order two
				with: Order three
				with: Order four)
		yourself.! !



!Item class methods !
  
addObjectSetTo: aMinneStoreDB
	"Define where my instances will be stored in aMinneStoreDB"

	^(aMinneStoreDB addObjectSetNamed: #Items)
		objectsPerFile: 5;
		storesClass: self;
		indexOn: #number domain: Integer;
		indexOn: #priceInCents domain: Integer getter: #price;
		hasChangedMethod: #hasChanged;
		beforeStoringMethod: #beforeStoring;
		yourself.!
   
beer
	"Answer an instance of myself."

	^self instanceCache
		at: 8
		ifAbsentPut:
			[self
				new price: 499;
				description: 'Beer';
				number: 8;
				yourself]!

bread
	"Answer an instance of myself."

	^self instanceCache
		at: 3
		ifAbsentPut:
			[self
				new price: 169;
				description: 'Bread';
				number: 3;
				yourself]!
  
butter
	"Answer an instance of myself."

	^self instanceCache
		at: 6
		ifAbsentPut:
			[self
				new price: 189;
				description: 'Butter';
				number: 6;
				yourself]!

cereal
	"Answer an instance of myself."

	^self instanceCache
		at: 2
		ifAbsentPut:
			[self
				new price: 329;
				description: 'Cereal';
				number: 2;
				yourself]!

coffee
	"Answer an instance of myself."

	^self instanceCache
		at: 4
		ifAbsentPut:
			[self
				new price: 389;
				description: 'Coffee';
				number: 4;
				yourself]!

coke
	"Answer an instance of myself."

	^self instanceCache
		at: 5
		ifAbsentPut:
			[self
				new price: 299;
				description: 'Coke';
				number: 5;
				yourself]!

eggs
	"Answer an instance of myself."

	^self instanceCache
		at: 7
		ifAbsentPut:
			[self
				new price: 129;
				description: 'Eggs';
				number: 7;
				yourself]!

instanceCache

	instanceCache == nil
		ifTrue: [instanceCache := Dictionary new].
	^instanceCache.!
 
milk
	"Answer an instance of myself."

	^self instanceCache
		at: 1
		ifAbsentPut:
			[self
				new price: 169;
				description: 'Milk';
				number: 1;
				yourself]!

resetInstanceCache

	instanceCache := nil.!
   
sprite
	"Answer an instance of myself."

	^self instanceCache
		at: 9
		ifAbsentPut:
			[self
				new price: 299;
				description: 'Sprite';
				number: 9;
				yourself]!

storeInstancesTo: aMinneStoreDB

	^aMinneStoreDB
		storeAll:
			(OrderedCollection new
				add: self beer;
				add: self bread;
				add: self butter;
				add: self cereal;
				add: self coffee;
				add: self coke;
				add: self eggs;
				add: self milk;
				add: self sprite;
				yourself)! !



!Order class methods !

addObjectSetTo: aMinneStoreDB
	"Define where my instances will be stored in aMinneStoreDB"

	^(aMinneStoreDB addObjectSetNamed: #Orders)
		objectsPerFile: 3;
		storesClass: self;
		indexOn: #number domain: Integer;
		aspect: #lineItems holdsMany: #OrderLineItems;
		hasChangedMethod: #hasChanged;
		beforeStoringMethod: #markUnchanged;
		yourself.!
  
four
	"Answer a fully instantiated instance of myself."

	^self new
		number: 4;
		date: Date today;
		addLineItem: OrderLineItem oneBeer;
		addLineItem: OrderLineItem oneBread;
		addLineItem: OrderLineItem oneCoffee;
		yourself.!
 
new

	^super new initialize.!
 
one
	"Answer a fully instantiated instance of myself."

	^self new
		number: 1;
		date: Date today;
		addLineItem: OrderLineItem oneBread;
		addLineItem: OrderLineItem oneMilk;
		yourself.!
   
storeInstancesTo: aMinneStoreDB

	^aMinneStoreDB
		storeAll: 
			(OrderedCollection new
				add: self one;
				add: self two;
				add: self three;
				add: self four;
				yourself)!
  
three
	"Answer a fully instantiated instance of myself."

	^self new
		number: 3;
		date: Date today;
		addLineItem: OrderLineItem twoMilks;
		addLineItem: OrderLineItem oneEggs;
		addLineItem: OrderLineItem oneCoffee;
		addLineItem: OrderLineItem threeCereals;
		yourself.!

two
	"Answer a fully instantiated instance of myself."

	^self new
		number: 2;
		date: Date today;
		addLineItem: OrderLineItem oneEggs;
		addLineItem: OrderLineItem threeCereals;
		addLineItem: OrderLineItem oneMilk;
		addLineItem: OrderLineItem oneButter;
		addLineItem: OrderLineItem oneCoffee;
		yourself.! !



!OrderLineItem class methods !
  
addObjectSetTo: aMinneStoreDB
	"Define where my instances will be stored in aMinneStoreDB"

	^(aMinneStoreDB addObjectSetNamed: #OrderLineItems)
		objectsPerFile: 5;
		storesClass: self;
		aspect: #order holdsOne: #Orders;
		aspect: #item holdsOne: #Items;
		hasChangedMethod: #hasChanged;
		beforeStoringMethod: #markUnchanged;
		yourself.!
 
oneBeer

	^self new
		item: Item beer;
		quantity: 1;
		yourself.
		!
 
oneBread

	^self new
		item: Item bread;
		quantity: 1;
		yourself.
		!
   
oneButter

	^self new
		item: Item butter;
		quantity: 1;
		yourself.
		!
 
oneCoffee

	^self new
		item: Item coffee;
		quantity: 1;
		yourself.!
 
oneEggs

	^self new
		item: Item eggs;
		quantity: 1;
		yourself.
		!
 
oneMilk

	^self new
		item: Item milk;
		quantity: 1;
		yourself.
		!
 
threeCereals

	^self new
		item: Item cereal;
		quantity: 3;
		yourself.
		!
  
twoCokes

	^self new
		item: Item coke;
		quantity: 2;
		yourself.
		!

twoMilks

	^self new
		item: Item milk;
		quantity: 2;
		yourself.
		! !



!Example2 class methods !
 
Comment
"
	This is a simple example to test large numbers of objects and the 
	multi-user aspects of this system.
"!

lockName
	
	^'K:\Junk.LOK'!
   
pathName
	
	^'T:\JUNK'!
   
RunTestCommon: aMinneStoreDB

	Transcript nextPutAll: 'Starting RunTestCommon';cr.
	(Person instances copyFrom: 1 to: 10)
		do: 
			[:each |
			self wait.
			aMinneStoreDB store: each.
			Transcript 
				nextPutAll: 'Stored: ';
				print: each;
				cr.
			]!
  
RunTestPC1
	"This code is started on the first PC."

	| temp db |
	db := self setup.
	temp := DOMultiUserPolicy new.
	"Wait until PC2 puts a dummy file out there, then go."
	[(File fromPath: self lockName) exists] whileFalse: [self wait].
	self RunTestCommon: db.
	(File fromPath: self lockName) remove.!
   
RunTestPC2
	"This code is started on the second PC."

	| temp coll |
	temp := DOMultiUserPolicy new.
	temp tryToLock: self lockName times: 10.
	self RunTestCommon: self open.!
   
storeObjectsTo: aMinneStoreDB

	aMinneStoreDB 
		storeAll:
			(OrderedCollection 
				with: Order one
				with: Order two
				with: Order three
				with: Order four)
		yourself.!
 
wait
	"Wait for about 1/10 of a second on a 166 mhz Pentium."

	1 to: 1000000 do: [:x | x + 5].! !



!Person class methods !

addObjectSetTo: aMinneStoreDB
	"Define where my instances will be stored in aMinneStoreDB"

	^(aMinneStoreDB addObjectSetNamed: #Persons)
		objectsPerFile: 3;
		storesClass: self;
		indexOn: #name domain: String;
"		indexOn: #age domain: Integer;"
		yourself.!

instances

	^OrderedCollection new
		add: (Person new age: 22; name: 'Jonathan');
		add: (Person new age: 31; name: 'Debra');
		add: (Person new age: 78; name: 'Julie');
		add: (Person new age: 37; name: 'Brian');
		add: (Person new age: 62; name: 'Jeff');
		add: (Person new age: 19; name: 'Phil');
		add: (Person new age: 31; name: 'Dan');
		add: (Person new age: 32; name: 'Bob');
		add: (Person new age: 33; name: 'Ann');
		add: (Person new age: 43; name: 'Tom');
		add: (Person new age: 45; name: 'Lora');
		add: (Person new age: 54; name: 'Mike');
		add: (Person new age: 39; name: 'Jon');
		add: (Person new age: 91; name: 'John');
		add: (Person new age: 02; name: 'George');
		add: (Person new age: 98; name: 'Jim');
		add: (Person new age: 87; name: 'Sandy');
		add: (Person new age: 72; name: 'Patty');
		add: (Person new age: 23; name: 'Denise');
		add: (Person new age: 55; name: 'Denephew');
		add: (Person new age: 47; name: 'DaBears');
		add: (Person new age: 83; name: 'Jan');
		add: (Person new age: 14; name: 'Jill');
		add: (Person new age: 82; name: 'Christine');
		add: (Person new age: 07; name: 'Peggy');
		add: (Person new age: 59; name: 'Arthur');
		add: (Person new age: 42; name: 'June');
		add: (Person new age: 77; name: 'Betty');
		add: (Person new age: 25; name: 'Davis');
		add: (Person new age: 31; name: 'Rich');
		add: (Person new age: 82; name: 'Jack');
		add: (Person new age: 13; name: 'Jennifer');
		add: (Person new age: 29; name: 'Flora');
		add: (Person new age: 98; name: 'Fauna');
		add: (Person new age: 57; name: 'Diane');
		add: (Person new age: 86; name: 'Doug');
		add: (Person new age: 75; name: 'Ric');
		add: (Person new age: 34; name: 'Suzie');
		add: (Person new age: 43; name: 'Susan');
		add: (Person new age: 52; name: 'Salmon');
		add: (Person new age: 61; name: 'Curt');
		add: (Person new age: 60; name: 'Cliff');
		add: (Person new age: 99; name: 'Calvin');
		add: (Person new age: 58; name: 'Clark');
		add: (Person new age: 77; name: 'Eugene');
		add: (Person new age: 36; name: 'Edward');
		add: (Person new age: 25; name: 'Eddie');
		add: (Person new age: 64; name: 'Joe');
		add: (Person new age: 13; name: 'Guy');
		add: (Person new age: 02; name: 'Gil');
		add: (Person new age: 81; name: 'Howard');
		add: (Person new age: 20; name: 'Hanson');
		add: (Person new age: 89; name: 'Svea');
		add: (Person new age: 68; name: 'Sarah');
		add: (Person new age: 47; name: 'Micah');
		add: (Person new age: 56; name: 'Lisa');
		add: (Person new age: 85; name: 'Lazarus');
		add: (Person new age: 24; name: 'Lucky');
		add: (Person new age: 93; name: 'Ginny');
		add: (Person new age: 02; name: 'Peter');
		add: (Person new age: 11; name: 'Pumpkin');
		add: (Person new age: 30; name: 'Piper');
		add: (Person new age: 49; name: 'Elliot');
		add: (Person new age: 28; name: 'Mae');
		add: (Person new age: 87; name: 'Everett');
		add: (Person new age: 16; name: 'Excellent');
		add: (Person new age: 75; name: 'Frank');
		add: (Person new age: 64; name: 'Frosty');
		add: (Person new age: 93; name: 'Maebelle');
		add: (Person new age: 42; name: 'Marble');
		add: (Person new age: 31; name: 'Margie');
		add: (Person new age: 60; name: 'Mark');
		add: (Person new age: 59; name: 'Matthew');
		add: (Person new age: 78; name: 'Multi');
		add: (Person new age: 87; name: 'Jackson');
		add: (Person new age: 46; name: 'Amanda');
		add: (Person new age: 35; name: 'Annika');
		add: (Person new age: 24; name: 'Britta');
		add: (Person new age: 93; name: 'Breakfast');
		add: (Person new age: 12; name: 'Kendra');
		add: (Person new age: 01; name: 'Keegan');
		add: (Person new age: 21; name: 'Kilroy');
		add: (Person new age: 80; name: 'Har');
		add: (Person new age: 49; name: 'Kathy');
		add: (Person new age: 58; name: 'Heather');
		add: (Person new age: 77; name: 'Heidi');
		add: (Person new age: 96; name: 'Christy');
		add: (Person new age: 15; name: 'Chloe');
		add: (Person new age: 24; name: '');
		yourself.
"
self instancesOne
"! !



!MinneStoreExamples methods ! !



!Example1 methods !
  
beforeStoring

	self markUnchanged.!
  
hasChanged

	^hasChanged == true!
 
initialize

	hasChanged := false.!

markChanged

	hasChanged := true.!

markUnchanged

	hasChanged := false.! !



!Item methods !

description

	^description!
   
description: aString

	description := aString.
	self markChanged.!
   
number

	^number!
 
number: anObject

	number := anObject.
	self markChanged.!
   
price

	^price!
   
price: anObject

	price := anObject.
	self markChanged.!
 
printOn: aStream

	super printOn: aStream.
	self description == nil
		ifFalse: [ 
			aStream 
				nextPut: $(;
				nextPutAll: self description;
				nextPut: $).
			].! !



!Order methods !
 
addLineItem: anOrderLineItem

	anOrderLineItem order: self.
	lineItems add: anOrderLineItem.
	self markChanged.!

date

	^date!
 
date: aDate

	date := aDate.
	self markChanged.!
 
initialize

	lineItems := OrderedCollection new.!
 
lineItems

	^lineItems!
   
lineItems: anOrderedCollection

	lineItems := anOrderedCollection.
	anOrderedCollection isMSProxy
		ifFalse: [self markChanged].!
   
number

	^number!
 
number: anInteger

	number := anInteger.
	self markChanged.! !



!OrderLineItem methods !
   
item

	^item!
 
item: anItem

	item := anItem.
	self markChanged.!
   
itemNumber

	item == nil
		ifTrue: [^nil].
	^item number!
   
order

	^order!
   
order: anOrder

	order := anOrder.
	anOrder isMSProxy
		ifFalse: [self markChanged].!
   
quantity

	^quantity!
 
quantity: anInteger

	quantity := anInteger.
	self markChanged.! !



!Example2 methods ! !



!Person methods !
 
age
	"Getter"

	^age!

age: anInteger
	"Setter"

	age := anInteger!
 
name
	"Getter"

	^name!
  
name: aString
	"Setter"

	name := aString!
   
printOn: aStream

	super printOn: aStream.
	self name == nil
		ifFalse: [ 
			aStream 
				nextPut: $(;
				nextPutAll: self name;
				nextPut: $).
			].! !
