    | path |
    path := Prompter prompt: 'Install from: ' default: 'a:\stateed\'.
    path isNil ifTrue: [^nil].
    (Smalltalk at: #HotDrawLibrary)
        at: #StateBitmap put: (Bitmap fromFile: (path, 'bitmaps\state.bmp'));
        at: #StartStateBitmap put: (Bitmap fromFile: (path, 'bitmaps\start.bmp'));
        at: #StopStateBitmap put: (Bitmap fromFile: (path, 'bitmaps\stop.bmp'))!

DrawingEditor subclass: #StateEditor
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: ''!

CompositeFigure subclass: #State
  instanceVariableNames: 'constraint '
  classVariableNames: ''
  poolDictionaries: ''!

State subclass: #StartState
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: ''!

State subclass: #StopState
  instanceVariableNames: 'ellipseConstraint '
  classVariableNames: ''
  poolDictionaries: ''!

ArrowFigure subclass: #StateConnector
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: 'ColorConstants '!

!StartState class methods !

creationTool
    "Return a creation tool"

    ^CreationTool
        icon: (HotDrawLibrary at: #StartStateBitmap)
        class: self

! !


!StartState methods !

initializeInArea: aRectangle
    "Private - Initialize the receiver"

    super initializeInArea: aRectangle.
    self label: 'start'.
    (figures at: 2) borderWidth: 4.
    constraint update: self

! !


!State class methods !

createNotifying: aPane
    "The user pressed the creation tool in a drawing, create a new figure"

    ^self new initializeInArea: (aPane mouseLocation extent: 100 @ 100)


!

creationTool
    "Return a creation tool"

    ^CreationTool
        icon: (HotDrawLibrary at: #StateBitmap)
        class: self

! !


!State methods !

menuLabel
    "Change the label"

    | newLabel |
    newLabel := Prompter prompt: 'Enter new label: ' default: self label.
    newLabel isNil ifTrue: [^self].
    self label: newLabel.
    self container update
!

updatePositions
    "Private - Maintain relative positions"

    | text ellipse |
    text := figures at: 1.
    ellipse := figures at: 2.
    ellipse setEllipse: ((text center - (text width // 2 * 2 sqrt) rounded) extent: (text width * 2 sqrt) rounded)

!

update: anObject
    "Update the receiver"

    self updatePositions.
    super update: anObject.

!

handles
    "Add a connection handle in the center"

     | handle |
    handle := ConnectionHandle
            on: self
            at: #center
            class: StateConnector.
    ^(super handles) add: handle; yourself



!

label: aString
    "Set the state label"

    (figures at: 1) text: aString
!

radius
    "Return the radius of the state"

    ^self visibleArea width // 2
!

menu
    "Return the composite figure menu"

    ^Menu
        labels: 'label\font' withCrs
        lines: #()
        selectors: #(menuLabel menuFont )

!

label
    "Return the state label"

    ^(figures at: 1) text
!

growBy: aPoint
    "States can't grow"

!

initializeInArea: aRectangle
    "Private - Initialize the receiver"

    | ellipseFigure textFigure textPosition |
    textFigure := TextFigure text: 'state' at: aRectangle origin.
    ellipseFigure := EllipseFigure ellipse: aRectangle.
    self setFigures: (OrderedCollection with: textFigure with: ellipseFigure) visibleArea: aRectangle.
    constraint := MultiheadedConstraint new for: self action: [:sources :sink |
        sink updatePositions.
        sink resetVisibleArea].
    constraint addSource: textFigure
!

menuFont
    "Change the font"

    | textFigure newFont |
    textFigure := figures at: 1.
    newFont := Font chooseAFont: 'Select a font !!'.
    newFont isNil ifTrue: [^self].
    textFigure font: newFont.
    textFigure changed.
    self container update

! !


!StateConnector class methods ! !


!StateConnector methods !

updateArrow
    "Recompute the arrow head"

    | vector unit aPoint stopPoint |
    stopPoint := (self stopPoint - self startPoint) // 2 + self startPoint.
    vector := stopPoint - self startPoint.
    vector = 0
        ifTrue: [
            unit := 0.
            aPoint := stopPoint]
        ifFalse: [
            unit := vector normal unitVector.
            aPoint := stopPoint - (vector unitVector * width * 8)].
    self points at: 3 put: (aPoint + (unit * (width * 4))) rounded.
    self points at: 5 put: (aPoint - (unit * (width * 4))) rounded.
    self points at: 4 put: stopPoint.
    self calculateBoundingBox
!

displayOn: aGraphicsMedium
    "Display the receiver onto aGraphicsMedium"

    | pen |
    pen := aGraphicsMedium pen.
    pen
        foreColor: ClrBlack;
        backColor: ClrBlack;
        setLineWidth: 1;
        place: (self points at: 1);
        goto: (self points at: 2);
        place: (self points at: 3);
        goto: (self points at: 4);
        goto: (self points at: 5)





! !


!StateEditor class methods !

defaultTools
    "   (StateEditor open)   "

     ^OrderedCollection new
                add: SelectionTool new;
                add: ScrollingTool new;
                add: FigureActionTool delete;
                add: State creationTool;
                add: StartState creationTool;
                add: StopState creationTool;
                add: TextFigure creationTool;
                yourself



!

label
    "Return the label of the editor"

    ^'State Editor'
! !


!StateEditor methods ! !


!StopState class methods !

creationTool
    "Return a creation tool"

    ^CreationTool
        icon: (HotDrawLibrary at: #StopStateBitmap)
        class: self

! !


!StopState methods !

initializeInArea: aRectangle
    "Private - Initialize the receiver"

    super initializeInArea: aRectangle.
    self label: 'stop'.
    figures add: (EllipseFigure ellipse: aRectangle).
    self setFigures: figures visibleArea: aRectangle.
    constraint update: self

!

updatePositions
    "Private - Maintain relative positions"

    | innerEllipse outerEllipse |
    super updatePositions.
    figures size = 3 ifFalse: [^nil].
    innerEllipse := figures at: 2.
    outerEllipse := figures at: 3.
    outerEllipse setEllipse: (innerEllipse displayBox insetBy: -4)


! !

    Transcript cr; tab; show: 'HotDraw/V StateEditor R1.1 Sunday 25 September 1994'.
    Transcript cr; tab; show: '(C)Center for Object Oriented Computing, Carleton University'.
    Transcript cr; tab; show: 'StateEditor open'!

