"Initialization code"
 !



!HelpManager methods !
 
displayHelp: anId
        "Display the help panel identified by anId
        anId can be either an Integer or a String."
		"@09.06.95 ch: O/S 2 bug workarround: help manager 
		can modify the string <anId>. Make a copy of it."

    self setHelpLibraryPath.
    anId isNil ifTrue: [ ^self displayExtendedHelp ].
    anId isString ifTrue: [
        ^( PMWindowLibrary 
            sendMsg: helpInstance
            msg: HmDisplayHelp
            mp1Struct: anId copy asParameter
            mp2: HmPanelname ) asExternalLong asBoolean ].
    anId isInteger ifTrue: [
        ^( PMWindowLibrary 
            sendMsg: helpInstance
            msg: HmDisplayHelp
            mp1: anId 
            mp2: HmpaneltypeNumber ) asExternalLong asBoolean ]!

pszTutorialName: tutorialName
    phtHelpTable: tableId
    hmodHelpTableModule: tableModule
    helpWindowTitle: title
    pszHelpLibraryName: libraryPath
    applWindow: window
    aboutDlgClass: aboutClass
    extHelp: extPanelId
    keysHelp: keysPanelId
    dialogs: aCollection
        "Private - Set all info for the receiver."
    helpInit  := SelfDefinedStructure named: 'HELPINIT'.
    helpInit
        cb: helpInit contents size;
        pszTutorialName: tutorialName;
        usShowPanelId: false asParameter;
        hmodAccelActionBarModule: NULL;
        idAccelTable: NULL;
        idActionBar: NULL.
    helpTableId := tableId.
    helpTableModule := tableModule.
    helpWindowTitle := title.
    helpLibraryPath := libraryPath.
    applicationWindow := window.
    aboutDlgClass := aboutClass.
    extHelpPanelId := extPanelId.
    keysHelpPanelId := keysPanelId.

	"Work around for bug in the 3.0.1 release help file."
	libraryPath fileNameLessPath = 'vhlp3ao.hlp' ifTrue: [
		extHelpPanelId := 9].

    dialogs := aCollection isNil ifTrue: [ #() ] ifFalse: [ aCollection ].
    window helpManager: self.! !



!HelpManager class methods ! !



!MenuWindow methods !
 
destroy
		"Private - Destroy the window and release all associated resources."
		"@01.06.95 ch: bug fix: don't destroy the parent window, which could 
		lead to walkbacks and situations where the image cannot be reloaded." 

	PMWindowLibrary destroyWindow: self handle.
	handle := WindowHandle nullValue! !



!MenuWindow class methods ! !



!SubPane methods !
 
helpRequest
		"Private - Notify a help event to any window
        which can handle it following the window chain."
		"@30.04.95 ch: bug fix: didn't set the helpContext" 
	self mainWindow helpContext isNil ifTrue: [
        self mainWindow helpContext: ( Association key: self name value: self ) ].
    ( self handlesEvent: #help )
        ifTrue: [ ^self event: #help ].
    ( self hasActionForEvent: #help )
        ifTrue: [ ^self triggerEvent: #help ].
    ^parent helpRequest
! !



!SubPane class methods ! !
"Finalization code"
    !

 
Transcript cr; nextPutAll: 'Bug fixes VSO 3.0.1 installed.'!
