"Initialization code"
 !

"define class"
WindowDialog subclass: #ChChapManInstallDialog
  instanceVariableNames: 
    ' sourceDir applicationTargetDir helpTargetDir installSLLVersion installBugFixes fullVersion platformLetter programVersion '
  classVariableNames: ''
  poolDictionaries: ''!

ChChapManInstallDialog class instanceVariableNames: ''!



!ChChapManInstallDialog methods !
 
applicationTargetDirectory: aPane
		"Private - Set the default application target directory."
		"@16.06.95 ch: Creation"

	aPane contents: Disk fullDirName, 'ChapApp'
!
   
cancel: aTopPane
		"Private - Cancel the dialog box."
		"@22.05.95 ch: Creation" 

	Transcript cr; nextPutAll: 'Installation aborted.'; cr.
	self close.!
  
copyFile: aString fromDirectory: fromDir toDirectory: toDir
		"Copy a the with name <aString> from the directory 
		<fromDir> to the directory <toDir>. Check if the copy is 
		ok."  
		"@18.06.95 ch: Creation"

	(File copy: fromDir fullDirName, aString to: toDir fullDirName, aString) ifFalse: [
		self error: 'Error copying file ', aString]
!
 
createView
		"Private - Create the view."
		"@10.10.95 ch: alignRelativToScreen causes problem with Windows 95" 
		"@31.08.95 ch: added: 'Install bug fixes' check box"
		"@16.06.95 ch: Creation"

	| charSize realCharSize aPane |
	realCharSize := WindowDialog unitMultiplier.
	charSize := realCharSize * (1 @ (3/2)).

	self
		label: 'ChapMan Installation';
		addSubpane: (StaticText new
			contents: 'Source directory of distribution files:';
			framingBlock: [:box | (box leftTop rightAndDown: (2 @ (1/4+1)) * charSize) 
				extentFromLeftTop: (40 @ 1) * realCharSize]);
		addSubpane: ((aPane := EntryField new)
			setName: #sourceDirectory:;
			when: #needsContents send: #sourceDirectory: to: self with: aPane;
			framingBlock: [:box | (box leftTop rightAndDown: (2 @ 2) * charSize) 
				extentFromLeftTop: (40 @ 1) * charSize]);

		addSubpane: (StaticText new
			contents: 'Target directory for application files:';
			framingBlock: [:box | (box leftTop rightAndDown: (2 @ (1/4+3)) * charSize) 
				extentFromLeftTop: (40 @ 1) * realCharSize]);
		addSubpane: ((aPane := EntryField new)
			setName: #applicationTargetDirectory:;
			when: #needsContents send: #applicationTargetDirectory: to: self with: aPane;
			framingBlock: [:box | (box leftTop rightAndDown: (2 @ 4) * charSize) 
				extentFromLeftTop: (40 @ 1) * charSize]);

		addSubpane: (StaticText new
			contents: 'Target directory for help files:';
			framingBlock: [:box | (box leftTop rightAndDown: (2 @ (1/4+5)) * charSize) 
				extentFromLeftTop: (40 @ 1) * realCharSize]);
		addSubpane: ((aPane := EntryField new)
			setName: #helpTargetDirectory:;
			when: #needsContents send: #helpTargetDirectory: to: self with: aPane;
			framingBlock: [:box | (box leftTop rightAndDown: (2 @ 6) * charSize) 
				extentFromLeftTop: (40 @ 1) * charSize]);

		addSubpane: (GroupBox new
			contents: 'Installation format';
			framingBlock: [:box | (box leftTop rightAndDown: (2 @ (1/6+7)) * charSize)
				extentFromLeftTop: (40 @ 3) * charSize]);
		addSubpane: (RadioButton new
			setName: 'installSLLVersion';
			contents: 'SLL';
			selection: true;
			framingBlock: [:box | (box leftTop rightAndDown: (3 @ 8) * charSize)
				extentFromLeftTop: (38 @ 1) * charSize]);
		addSubpane: (RadioButton new
			contents: 'File-In (not available in the test version)';
			selection: false;
			framingBlock: [:box | (box leftTop rightAndDown: (3 @ 9) * charSize)
				extentFromLeftTop: (38 @ 1) * charSize]);
				
		addSubpane: (aPane := CheckBox new
			setName: 'installBugFixes';
			contents: 'Install bug fixes for VST';
			selection: Smalltalk platformIsOS2;
			framingBlock: [:box | (box leftTop rightAndDown: (2 @ (1/2+10)) * charSize)
				extentFromLeftTop: (38 @ 1) * charSize]).
		Smalltalk platformIsOS2 ifFalse: [aPane disable].

		"Now, the install, cancel buttons."
	self
		addSubpane: (Button new
			defaultPushButton;
			contents: 'Install' replaceEscapeCharacters;
			when: #clicked send: #install to: self;
			framingBlock: [:box | (box leftTop rightAndDown: (2 @ 12) * charSize) 
				extentFromLeftTop: (8 @ 1) * charSize]);

		addSubpane: (Button new
			contents: 'Cancel' replaceEscapeCharacters;
			when: #clicked send: #cancel: to: self with: nil;
			framingBlock: [:box | (box leftTop rightAndDown: (12 @ 12) * charSize) 
				extentFromLeftTop: (8 @ 1) * charSize]).

	"This causes problem with Windows95 so comment it out."
	"self mainView alignRelativeToScreen"


!

doInstall
		"Private - Install ChapMan."
		"@11.12.95 ch: fix: set program version to '2.1'" 
		"@19.11.95 ch: watch for Tensegrity installed"
		"@01.09.95 ch: factored the bug fix files"
		"@21.06.95 ch"
		"@18.06.95 ch: fix"
		"@16.06.95 ch: Creation"

	| answer bugfixFiles file apps app aDirectory edItFiles |

	"Copy the help files."
	Transcript cr; nextPutAll: 'Copying help files...'.
	file := 'Chap', platformLetter, programVersion, '.hlp'.
	self copyFile: file fromDirectory: sourceDir toDirectory: helpTargetDir.

	"Copy the resource DLL."
	Transcript cr; nextPutAll: 'Copying DLLs...'.
	file := 'Chap', platformLetter, programVersion, '.dll'.
	self copyFile: file fromDirectory: sourceDir toDirectory: Disk.

	"Copy the application files."
	Transcript cr; nextPutAll: 'Copying application files...'.
	(sourceDir filesNamed: '*.cha'),
	(sourceDir filesNamed: '*.cls'),
	(sourceDir filesNamed: '*.st') do: [:each |
		self copyFile: each fromDirectory: sourceDir toDirectory: applicationTargetDir].

	"Install the bug fixes."
	Transcript cr; nextPutAll: 'Installing vital bug fixes...'.
	(applicationTargetDir file: 'fixgvst.cls') fileIn; close.
	
	bugfixFiles := OrderedCollection new.
	(self paneAt: 'installBugFixes') selection ifTrue: [
		Smalltalk platformIsOS2 ifTrue: [
			Smalltalk versionNumberString = '3.0.0' ifTrue: [
				bugfixFiles add: 'fixo30'].
			Smalltalk versionNumberString = '3.0.1' ifTrue: [
				bugfixFiles add: 'fixo301'].
			].
		"Smalltalk platformIsWin32 ifTrue: [
			bugfixFiles add: 'fixw30']."
		bugfixFiles do: [:each |
			Transcript cr; nextPutAll: 'Installing bug fixes ', each, '...'.
			(applicationTargetDir file: each, '.cls') fileIn; close.
			]
		].
		
	"Install the registration SLL."
	(Smalltalk includesKey: #ChRegisterDialog) ifFalse: [
		(Smalltalk includesKey: #TensegritySystemBindery) ifTrue: [
			(Smalltalk at: #TensegritySystemBindery) deactivateSystem].
		Transcript cr; nextPutAll: 'Installing the registration SLL...'.
		file := 'ChapR', platformLetter, programVersion, '.sll'.
		self copyFile: file fromDirectory: sourceDir toDirectory: Disk.
		SmalltalkLibraryBinder bindTo: file.
		Transcript nextPutAll: ' Installed.'.
		(Smalltalk includesKey: #TensegritySystemBindery) ifTrue: [
			(Smalltalk at: #TensegritySystemBindery) activateSystem].
		].

	"Install the ChapMan System."
	installSLLVersion ifTrue: [
		Transcript cr; nextPutAll: 'Installing the ChapMan SLL...'.
		file := 'Chap', platformLetter, programVersion.
		self copyFile: file, '.sll' fromDirectory: sourceDir toDirectory: Disk.
		fullVersion ifTrue: [
			self copyFile: file, '.sml' fromDirectory: sourceDir toDirectory: Disk].
		SmalltalkLibraryBinder bindTo: file, '.sll'.
		Transcript nextPutAll: ' Installed.'.
		]
	ifFalse: [
		Smalltalk at: #ChapManInstallationDirectory put: applicationTargetDir fullDirName.
		file := (applicationTargetDir file: 'ChapBas.st').
		file fileIn; close.
		Smalltalk removeKey: #ChapManInstallationDirectory.
		].
	(Smalltalk at: #ChApplicationBrowser) installChapMan.
	
	"Install edIt support if edIt is present."
	(Smalltalk includesKey: #CPEdIt) ifTrue: [
		Transcript cr; nextPutAll: 'Installing edIt support chapEdit...'.
		(applicationTargetDir file: 'chapEDIT.cls') fileIn; close.
		edItFiles := #('chapEDIT').
		]
	ifFalse: [
		edItFiles := #()].

	"Install the Library Builder SLLs."
	(Smalltalk includesKey: #SmalltalkLibraryBuilder) ifFalse: [
		aDirectory := 'extras\slbuild'.
		[aDirectory := Directory pathName: aDirectory. aDirectory exists] whileFalse: [
			aDirectory := Prompter 
				prompt: 'Enter directory of the Smalltalk Library Builder SLLs'
				default: aDirectory pathName.
			aDirectory isNil ifTrue: [
				^self cancel: nil].
			].
		(aDirectory filesNamed: '*.sll') do: [:each |
			self copyFile: each fromDirectory: aDirectory toDirectory: Disk.
			SmalltalkLibraryBinder bindTo: each.
			Transcript cr; nextPutAll: each, ' installed.'.
			].
		].

	"File In all available application definitions."
	(Smalltalk at: #ChApplication) configVariables 
		at: 'DirectoryCHA' put: applicationTargetDir.
	apps := OrderedCollection with: 'ChapMan' with: 'fixgvst'.
	apps 
		addAll: bugfixFiles;
		addAll: edItFiles;
		addAll: #('CompIntf' 'Events' 'FileSys' 'StLibMan' 'WinPolic' 'WinSys').
	Transcript cr; nextPutAll: 'Installing Application definitions...'.
	apps do: [:appName |
		Transcript cr; nextPutAll: '  ', appName.
		app := (Smalltalk at: #ChApplication)
			newFromFile: appName subApplications: true
			installSource: false
			useExisting: false.
		app notNil ifTrue: [
			app addToMainApplications]
		ifFalse: [
			MessageBox message: 'Couldn''t file in application ', appName.
			self cancel: nil].
		].

	Transcript cr; nextPutAll: 'ChapMan System installed.'; cr.

	Cursor reset.
	(MessageBox confirm: 'Confirm the reinitialization of the window system.') ifTrue: [
		Notifier reinitialize]
	
!

helpTargetDirectory: aPane
		"Private - Set the default application target directory."
		"@16.06.95 ch: Creation"

	aPane contents: Disk fullDirName, 'Help'
!
 
initWindowSize
		"Private - Answer the initial window size."

	| aPoint | 
	aPoint := WindowDialog unitMultiplier * (44 @ 21). 
	"^(Display extent / 2 leftAndUp: (aPoint / 2)) extentFromLeftTop: aPoint."
	^aPoint
!
   
install
		"Private - Install ChapMan."
		"@11.12.95 ch: moved the installation code into #doInstall" 
		"@11.12.95 ch: fix: set program version to '2.1'"
		"@19.11.95 ch: watch for Tensegrity installed"
		"@01.09.95 ch: factored the bug fix files"
		"@21.06.95 ch"
		"@18.06.95 ch: fix"
		"@16.06.95 ch: Creation"

	| answer |
	programVersion := '21'.
	Transcript cr.
	
	sourceDir := Directory pathName: 
		(self paneAt: #sourceDirectory:) contents.
	sourceDir exists ifFalse: [
		^MessageBox message: 'Source directory doesn''t exist.'].

	helpTargetDir := Directory pathName: 
		(self paneAt: #helpTargetDirectory:) contents.
	helpTargetDir exists ifFalse: [
		^MessageBox message: 'Help target directory doesn''t exist.'].

	applicationTargetDir := Directory pathName: 
		(self paneAt: #applicationTargetDirectory:) contents.
	applicationTargetDir exists ifFalse: [
		answer := MessageBox confirm: 'Application target directory doesn''t exist. Create it?'.
		answer 
			ifTrue: [applicationTargetDir create]
			ifFalse: [^self].
		].
	installSLLVersion := (self paneAt: 'installSLLVersion') selection.
	platformLetter := String with: SmalltalkLibrary platformLetter.
	fullVersion := (sourceDir existingFileNamed: 
		'Chap', platformLetter, programVersion, '.sml') notNil.
	installSLLVersion not & fullVersion not ifTrue: [
		^MessageBox message: 'File in version not available.'].

	[self doInstall] forkAt: Processor lowUserPriority.
	self close.
!
   
open
		"Open the settings dialog."
		"@22.04.95 ch: Creation"
	self 
		createView;
		openWindow
!
 
sourceDirectory: aPane
		"Private - Set the default source directory."
		"@16.06.95 ch: Creation"

	aPane contents: ''
! !



!ChChapManInstallDialog class methods ! !
"Finalization code"
   
[ChChapManInstallDialog new open] fork!

   
Transcript cr; nextPutAll: 'ChapMan Installation installed.'!
