"Installation file."
| stdDirectory fileDirectory aString files aStream file |
stdDirectory := '?ChapManInstallationDirectory'.

(stdDirectory notEmpty and: [stdDirectory first = $?]) ifTrue: [
	stdDirectory := Smalltalk at: (stdDirectory copyFrom: 2
		to: stdDirectory size) asSymbol ifAbsent: [''].
	].
stdDirectory := Directory pathName: stdDirectory.
files := #(
('ChapMan VST Goodies' 'ChapGood')
('ParcPlace Compatibility' 'ParcPCom')
('System Extensions' 'SysExten')
('Userinterface Extensions Portable' 'UIExPort')
('Userinterface Extensions' 'UIExten?')
('ChapMan Kernel' 'ChapKrnl')
('ChapMan Userinterface Extensions' 'ChapUIE')
('ChapMan System Extensions' 'ChapSysE')
('ChapMan User-Interface' 'ChapUI')
('ChapMan Base' 'ChapBas')
).

files do: [:each |
	Transcript cr; nextPutAll: 'Installing: ', (each at: 1), '...'.
	fileDirectory := stdDirectory.
	[
	file := (each at: 2) collect: [:c | c == $? 
		ifTrue: [SmalltalkLibrary platformLetter] 
		ifFalse: [c]].
	File exists: file, '.cls' in: fileDirectory
	] whileFalse: [
		aString := Prompter 
			title: 'File not found in ', fileDirectory fullDirName
			prompt: 'Enter new directory for file ', file, '.cls'
			default: ''.
		(aString isNil or: [aString isEmpty]) ifTrue: [
			Transcript cr; nextPutAll: 'Installation aborted'; cr.
			^Error signal: 'Installation aborted'].
		fileDirectory := Directory pathName: aString.
		(MessageBox confirm: 'Use this directory for subsequent files also?') ifTrue: [
			stdDirectory := fileDirectory].
		].
	aStream := fileDirectory file: file, '.cls'.
	[aStream fileIn] ensure: [aStream close].
	].

Transcript cr; nextPutAll: 'Done.'.!
