
ViewManager subclass: #GReversi
  instanceVariableNames: 
    'theGame theViewer youBegin '
  classVariableNames: ''
  poolDictionaries: ''   !


!GReversi class methods ! !



!GReversi methods !
   
changeMenuBar: aTopPane
    "Private - Remove Default - Menus and add Game - Menus"

    aTopPane menuWindow removeMenu:
             (aTopPane menuWindow menuTitled: 'File').
    aTopPane menuWindow removeMenu:
             (aTopPane menuWindow menuTitled: 'Edit').
    aTopPane menuWindow removeMenu:
             (aTopPane menuWindow menuTitled: 'Smalltalk').

    aTopPane menuWindow addMenu:
        ((Menu
            labels: 'New ~Game\~Options \E~xit\~About'  withCrs
            lines: #( 2 3)
            selectors:#(gameNew gameOptions gameExit gameAbout))
            owner: self;
            title: '~Game';
            yourself).!
   
close: aPane
    "Private - Close the receiver."

    (MessageBox confirm: 'Exit the game ?')
        ifTrue: [
            self close.
            (Smalltalk isRunTime)
                ifTrue: [
                    Smalltalk exit.
            ]
    ].!
 
drawMove: move
     "Private - Draw changed positions."

     | board |

    board := theGame getBoard.
    theViewer drawCellXY: (board toXY: (move at: 1)).
    (move at: 2) do: [:m |
        theViewer drawCellXY: (board toXY: m)
    ].

    (self paneAt:'info') contents:'My Move ' ,
        (theGame getBoard toXY: (move at: 1)) printString.!
   
gameAbout
      " Private - Diplay About-Information "

      MessageBox message: 'Reversi by J. Bruchi'.!
  
gameExit
     "Private - exit the Game"

    self close: TopPane.!
   
gameNew
    "Private - Start a new game."

    | dim lev |

    (MessageBox confirm:'Start a new game')
    ifTrue:[
        dim := theGame dimension.
        lev := theGame level.
        theGame := (GameReversi new: dim).
        theGame level: lev.
        youBegin ifFalse:[
                theGame doMove: dim // 2 for: theGame player1].
        theViewer game: theGame.
        (self paneAt: 'board') event: #getContents].!
 
gameOptions
    "Private - Call OptionsDialog
      create a new Game if dimension changed  "

    | go dim lev |

    dim := theGame dimension.
    lev := theGame level.
    go := GameOptions new.
    go maxLevel: 6.
    go level:lev dimension:dim youBegin:youBegin.

    (go canceled)  ifFalse:[
        youBegin := go youBegin.
        (go dimension = dim) ifFalse:[
            theGame := (GameReversi new: go dimension).
            theGame level: go level.
            theViewer game: theGame.
            youBegin ifFalse:[
                theGame doMove: (go dimension) // 2 for: theGame player1].
            (self paneAt: 'board') event: #getContents.
        ]
        ifTrue:[
            theGame level: go level.
        ].
    ].!
   
initWindowSize
   "Private - Answer default initial window extent."

   ^Display width * 3 // 10 @ (Display height * 5 // 10)!
   
mouseClicked: pane
     "Private - Determine which square the mouse
       was released on and create a move (linpos,flipped).  "

    | linpos flipped move |

    linpos := theGame getBoard toLinear:( theViewer mousePos).
    flipped := theGame flip: linpos for: theGame player2.
    move:= Array new: 2.
    move at: 1 put: linpos.
    move at: 2 put: flipped.
    self yourMove: move.!
 
open
    "Open GReversi , create the Game "

    | group game |

    youBegin := true.
    theGame := GameReversi new: 10.
    theGame level: 2.

    self
        label: 'Reversi';
        when: #close perform: #close:;
        owner: self.

    self when: #menuBuilt perform: #changeMenuBar: .

    self addSubpane:
        (game := GraphPane new
            owner: self;
            setName: 'board';
            when: #getContents perform: #redrawBoard:;
            when: #display perform: #redrawBoard:;
            style: GraphPane noScrollBarsFrameStyle;
            when: #button1Up perform: #mouseClicked:;
            framingRatio: ( (Rectangle leftTopUnit
                rightAndDown:(1/20) @ (1/20)) extentFromLeftTop: (18/20) @ (16/20) )
       ).

    self addSubpane:
        (StaticText new
            owner: self;
            centered;
            contents:'Reversi by J.Braeuchi';
            setName: 'info';
            framingRatio: ( (Rectangle leftTopUnit
                rightAndDown:(1/20) @ (35/40)) extentFromLeftTop: (18/20) @ (5/40) )
       ).

    theViewer := GameViewer new
            pane: game;
            game: theGame.

    self openWindow.!

redrawBoard: pane
    "Private - Redraw the game board "

    theViewer redraw: pane.!
   
yourMove: move
     "Private - Execute a move on x/y position."

    | mymove |

    (theGame validateMove: move for: nil) ifFalse: [
        MessageBox message: 'not allowed'.
        ^nil
    ].
    theGame doMove: move for: theGame player2.
    self drawMove: move.

    (self paneAt:'info') contents:'Thinking...'.
    CursorManager execute change.
    mymove := theGame getMove: theGame player1.
    ((move at: 2) size = 0) ifTrue: [
        self halt.
        (self paneAt:'info') contents:'Panic !!'.
        (theGame gameOver)
        ifTrue: [ ^nil ]
        ifFalse: [
            self halt.
            mymove := theGame possibleMoves at: 1.]
    ].

    theGame doMove: mymove for: theGame player1.
    self drawMove: mymove.
    CursorManager normal change.! !
