
WindowDialog subclass: #GameOptions
  instanceVariableNames: 
    'level dimension youBegin canceled '
  classVariableNames: ''
  poolDictionaries: 
    'WinConstants ' !


!GameOptions class methods !
 
new
    ^super new initialize.! !



!GameOptions methods !

beginClicked: aButton
    " Private -  Set Beginner "

    (aButton name = 'BeginYou') ifTrue: [youBegin := true].
    (aButton name = 'BeginMe') ifTrue: [youBegin := false].!
 
beginControls
    " Private - Build Controls for Beginner  "

    | lineHeight charSize |

    charSize := WindowDialog unitMultiplier.
    lineHeight := charSize y.

    self addSubpane:
        (RadioButton new
            contents:'You';
            setName:'BeginYou';
            when: #clicked perform: #beginClicked:;
            framingBlock: [:box | (box leftTop
                        rightAndDown: (21 @ 8) * charSize)
                    extentFromLeftTop: (10 @ 1) * charSize ] ).

    self addSubpane:
        (RadioButton new
            contents:'Me';
            setName:'BeginMe';
            when: #clicked perform: #beginClicked:;
            framingBlock: [:box | (box leftTop
                        rightAndDown: (21 @ 9) * charSize)
                    extentFromLeftTop: (10 @ 1) * charSize ] ).

    self addSubpane:
        (GroupBox new
            contents:'Beginner';
            framingBlock: [:box | (box leftTop
                        rightAndDown: (19 @ 6) * charSize)
                    extentFromLeftTop: (15 @ 6) * charSize ] ).!

cancel: aButton
        "Private - The user selected cancel."

    canceled := true.
    self mainView close!
   
canceled
    " True if Dialog aborted ."

    ^canceled.!

dimClicked: aButton
    " Private - Set Dimension "

    (aButton name = 'Dim8') ifTrue: [dimension := 8].
    (aButton name = 'Dim10') ifTrue: [dimension := 10].
    (aButton name = 'Dim16') ifTrue: [dimension := 16].!

dimension
    " Get Dimension "

    ^dimension.!

dimensionControls
    " Private - Build Controls for Dimension "

    | lineHeight charSize |

    charSize := WindowDialog unitMultiplier.
    lineHeight := charSize y.

    self addSubpane:
        (RadioButton new
            setName:'Dim8';
            contents:'8 x 8';
            when: #clicked perform: #dimClicked:;
            framingBlock: [:box | (box leftTop
                        rightAndDown: (4 @ 8) * charSize)
                    extentFromLeftTop: (10 @ 1) * charSize ] ).

    self addSubpane:
        (RadioButton new
            contents:'10 x 10';
            setName:'Dim10';
            when: #clicked perform: #dimClicked:;
            framingBlock: [:box | (box leftTop
                        rightAndDown: (4 @ 9) * charSize)
                    extentFromLeftTop: (10 @ 1) * charSize ] ).

    self addSubpane:
        (RadioButton new
            contents:'16 x 16';
            setName:'Dim16';
            when: #clicked perform: #dimClicked:;
            framingBlock: [:box | (box leftTop
                        rightAndDown: (4 @ 10) * charSize)
                    extentFromLeftTop: (10 @ 1) * charSize ] ).

    self addSubpane:
        (GroupBox new
            contents:'Dimension';
            framingBlock: [:box | (box leftTop
                        rightAndDown: (2 @ 6) * charSize)
                    extentFromLeftTop: (15 @ 6) * charSize ] ).!

initialize
    " Private - Add Controls "

    | lineHeight charSize |

    super initialize.
    self style:DsModalframe |                    " Style for STVWIN 1.1 "
        WsCaption |  WsSysmenu |
        DsNoidlemsg |  "  WsClipchildren |  "
        WsPopup | WsVisible.

    level := 6.
    dimension := 10.
    youBegin := false.

    self labelWithoutPrefix: 'Options';
           levelControls;
           dimensionControls;
           beginControls.

    charSize := WindowDialog unitMultiplier.
    lineHeight := charSize y.

    self addSubpane:
        (Button new
            defaultPushButton;
            contents: 'OK';
            when: #clicked perform: #ok:;
            framingBlock: [:box | (box leftTop
                        rightAndDown: (2 @ 13) * charSize)
                    extentFromLeftTop: (10 @ 2) * charSize ] ).

    self addSubpane:
        (Button new
            pushButton;
            contents: 'Cancel';
            when: #clicked perform: #cancel:;
            framingBlock: [:box | (box leftTop
                        rightAndDown: (24 @ 13) * charSize)
                    extentFromLeftTop: (10 @ 2) * charSize ] ).!
 
initWindowSize
        "Private - Answer the window size."
    ^(36 @ 16) * WindowDialog unitMultiplier!
  
level
    " Get Level "

    ^level.!

level: aLevel dimension: aDim youBegin: aBool
    "Set Variables and open the Dialog"

    canceled := true.
    level := aLevel.
    (self paneAt:'LevelScroll') position: level.
    (self paneAt:'LevelText') contents: level printString.

    dimension := aDim.
    (dimension = 8) ifTrue: [ (self paneAt:'Dim8') selection: true].
    (dimension = 10) ifTrue: [ (self paneAt:'Dim10') selection: true].
    (dimension = 16) ifTrue: [ (self paneAt:'Dim16') selection: true].

    youBegin := aBool.
    youBegin ifTrue: [ (self paneAt:'BeginYou') selection: true].
    youBegin ifFalse: [ (self paneAt:'BeginMe') selection: true].

    self openWindow.!

levelControls
    " Private - Build Controls for Level "

    | lineHeight charSize |

    charSize := WindowDialog unitMultiplier.
    lineHeight := charSize y.

    self addSubpane:
        (ScrollBar new
            setName:'LevelScroll';
            horizontal;
            pageIncrement: 1;
            minimum: 1;
            maximum: level;
            position: 1;
            when: #endScroll perform: #levelScrolled:;
            framingBlock: [:box | (box leftTop
                        rightAndDown: (4 @ 3) * charSize)
                    extentFromLeftTop: (25 @ 1) * charSize ] ).

    self addSubpane:
        (StaticText new
            setName:'LevelText';
            centered;
            contents: level printString;
             framingBlock: [:box | (box leftTop
                        rightAndDown: (30 @ 3) * charSize)
                    extentFromLeftTop: (2 @ 1) * charSize ] ).

    self addSubpane:
        (GroupBox new
            contents: 'Level';
            framingBlock: [:box | (box leftTop
                        rightAndDown: (2 @ 1) * charSize)
                    extentFromLeftTop: (32 @ 4) * charSize ] ).!

levelScrolled: aScrollBar
    " Private - Set Level to Scrollbar value "

    level := aScrollBar position.
    (self paneAt:'LevelText') contents: level printString.!
 
maxLevel: aLevel
    "Set maximum Level"

    (self paneAt:'LevelScroll') maximum: aLevel.!
  
ok: aButton
    "Private - The user selected ok."

    canceled := false.
    self mainView close!
  
youBegin
    " Get beginner "

    ^youBegin.! !
