
Object subclass: #GameViewer
  instanceVariableNames: 
    'theGame thePane color1 color2 colorEmpty '
  classVariableNames: ''
  poolDictionaries: 
    'ColorConstants '   !


!GameViewer class methods !
  
new
    ^super new initialize.! !



!GameViewer methods !
 
drawCellXY: aPoint

    "Draw cell aPoint "

    | cell radius center board  size pen |

    size := thePane extent // (theGame dimension).
    pen := thePane pen.
    board := theGame getBoard.
    center := size // 2.
    radius := center - 1.
    cell := board getPosXY: aPoint.

    pen up;
           goto: ( (pen boundingBox leftBottom)
                    rightAndUp: (aPoint * size - center));
           down.

    cell = board empty
        ifTrue: [pen backColor: colorEmpty].
    cell = theGame player1
        ifTrue: [pen backColor: color1].
    cell = theGame player2
        ifTrue: [pen backColor: color2].

    pen ellipseFilled: (radius x) minor: (radius y).!
 
drawColumn: column
    "Display column "

    1 to: (theGame dimension) do: [ :y |
        self drawCellXY: ( column @ y)
    ].!
  
game: aGame
    " Set Game to display "

    theGame := aGame.!
  
initialize
    " Private - Initialize colors "

    color1 := ClrBlue.
    color2 := ClrRed.
    colorEmpty := ClrBackground.!
 
mousePos
     "convert mouse-position to a point, LeftBottom is 1 @ 1."

    | point  mouse leftBot |

    mouse := thePane mouseLocation.
    leftBot := thePane pen boundingBox leftBottom.
    point :=  leftBot rightAndUp: mouse.     "relative to LeftBottom in Pixels"

    point := point // (thePane pen extent // theGame dimension).
    point := point + (1 @ 1).                         " 0 @0 -> 1 @ 1"

   ^point.!
 
pane: aPane
    " Set Display-Pane "

    thePane := aPane.!
 
redraw: pane
    "Redraw the whole Board "

    thePane erase.
    thePane pen fill: ClrGreen.

    1 to: (theGame dimension) do: [ :x |
        self drawColumn: x
    ].! !
