
GameLogic subclass: #GameReversi
  instanceVariableNames: 
    'value up down '
  classVariableNames: ''
  poolDictionaries: ''   !


!GameReversi class methods ! !



!GameReversi methods !
 
doMove: move for: player
    " Private - Issue move for player
       move is Array of pos, flipped "

    board setPos: (move at: 1) value: player.
    (move at: 2) do: [ :pos |
        board setPos: pos value: player ].           " Flip positions "!
   
evaluate
    "Private - evaluate current situation
      player1 is MINIMIZING, player2 is MAXIMIZING "

    | val pl |

    val := 0.
    1 to: dim do: [:x |
        1 to: dim do: [:y |
            pl := board getPosXY: x @ y.
            (pl = player1) ifTrue: [ val := val - 1].
            (pl = player2) ifTrue: [ val := val + 1].
        ].
    ].
    ^val.!
  
flip: move for: player
    "Return Bag of positions player can flip
      move must be linear !!  "

    | enemy turned tdir search dir pos |

    (player = player1)
        ifTrue:[ enemy := player2]                   " get enemy "
        ifFalse: [enemy := player1].
    search := board directions.
    turned := Bag new.

    1 to: 4 do: [ :i |
           tdir := Bag new.                   " Prepare a temporary bag "
           dir := search at: i.
           pos := move + dir.                  " positive search "
           [( board getPos: pos) = enemy ] whileTrue:[
                tdir add: pos.                     " Save position "
                pos := pos + dir].
           (( board getPos: pos ) = player )          " Last one is mine "
                ifTrue: [ tdir do: [: p | turned add: p ]].

           tdir := Bag new.                   " Prepare a temporary bag "
           dir := search at: i.
           pos := move - dir.                  " negative search "
           [( board getPos: pos) = enemy ] whileTrue:[
                tdir add: pos.                     " Save position "
                pos := pos - dir].
           (( board getPos: pos ) = player )          " Last one is mine "
                ifTrue: [ tdir do: [: p | turned add: p ]].
    ].

    ^turned.!
   
initGame
    " Private - Initialize a the GameVariables
       init variables : player1 player2 maxvalue level "

    | half |

    level := 2.                                            " Superclass variables "
    player1 := 100.
    player2 := 200.
    maxvalue := 11111.

    up := (board directions) at: 1.
    down := up negated.

    half := dim // 2.
    board setPosXY: (half + 0) @ (half + 0) value: player1.
    board setPosXY: (half + 1) @ (half + 1) value: player1.
    board setPosXY: (half + 0) @ (half + 1) value: player2.
    board setPosXY: (half + 1) @ (half + 0) value: player2.!
   
possibleMoves: player
    " Private - Return all possible Moves for player "
    " Move Structure : Array[1] = linear position, Array[2] = flipped "

    | moves val lin empty flipped arr |

    moves := Bag new.
    empty := board empty.                        " Value of empty "

    1 to: dim do: [:x |
        1 to: dim do: [:y |
            val := board getPosXY: x @ y.
            ( val = empty ) ifTrue:[
                lin := board toLinear: x @ y.
                flipped := self flip: lin for: player.
                (flipped size > 0) ifTrue:[
                    arr := Array new: 2.
                    arr at: 1 put: lin.                  " Linear position "
                    arr at: 2 put: flipped.           " Flipped positions "
                    moves add: arr.
                ].
            ].
        ].
    ].
    ^moves.!

undoMove: move for: player
    " Private - undo move,  move is column
       move is Array of pos, flipped "

    | enemy flipped |

    (player = player1)
        ifTrue:[ enemy := player2]                   " get enemy "
        ifFalse: [enemy := player1].
    flipped := move at: 2.
    board resetPos: (move at: 1).                 " Reset position "
    flipped do: [ :pos |
        board setPos: pos value: enemy].     " Reflip positions "!
 
validateMove: move for: player
    " Board at move must be empty,    "

    ((board getPos: (move at: 1)) = board empty) ifFalse:
        [ ^false ].                                            " not empty "

    ((move at: 2) size > 0) ifFalse:
        [ ^false ].                                            " could not flip "

    ^true.! !
