
Object subclass: #GameLogic
  instanceVariableNames: 
    'board dim level player1 player2 maxvalue bestmove '
  classVariableNames: ''
  poolDictionaries: ''    !


!GameLogic class methods !
   
new: dimension
    " Return a generic Board-Game "
    ^super new initialize: dimension! !



!GameLogic methods !

checkWin: move for: player
    " Private - Check winning situation for player
       Default do nothing. "

    ^false.!

dimension
    " Answer current dimension "

    ^dim.!
   
doMove: move for: player
    " Private - Issue move for player"
    self implementedBySubclass.!
  
evaluate
    "Private - evaluate current situation
      player1 is MINIMIZING, player2 is MAXIMIZING "
    self implementedBySubclass.!
 
gameOver
    " Return True if no moves available "

    ^(self possibleMoves size = 0).!
 
getBoard
    " Return the Game Board "
    ^board.!
   
getMove: player
    " Calculate next move for player
       player1 is MINIMIZING, player2 is MAXIMIZING
       bestmove contains nil if no move found  "

    bestmove := nil.
    (player = player1)
        ifTrue:[
            self player1Move: (maxvalue negated) with: maxvalue ]
        ifFalse:[
            self player2Move: (maxvalue negated) with: maxvalue ].
    ^bestmove.!
   
initGame
    " Private-Initialize a the GameVariables
       init variables : player1 player2 maxvalue level "
    self implementedBySubclass.!
  
initialize: dimension
    " Private - Initialize a BoardGame "

    dim := dimension.
    board := GameBoard new: dimension.
    self initGame.!
   
level
    " return Lookahead-Level "
    ^level.!
 
level: anInteger
    " Set Lookahead-Level to anInteger "
    level := anInteger.!

player1
    " Return Value of player1 "
    ^player1!
 
player1Move: alpha with: beta
    "Private - find Best move for player 1
     return the situation value of best move
     player1 is MINIMIZING "

    | col mval movlist move tbeta |

    move := -1.
    tbeta := beta.

    (level = 0) ifTrue:[ ^ self evaluate].                  " evaluate Situation "

    level := level - 1.                                              " go down "

    movlist := self possibleMoves: player1.         " get possible moves "

    movlist do:[ :i |
        self doMove: i for: player1.
        (self checkWin: i for: player1 )                     " immediate check  "
                ifTrue: [                                                     " winner "
                      mval := maxvalue negated ]       " set maximum "
                ifFalse:[
                      mval := self player2Move: alpha with: tbeta].   " recursion "

         self undoMove: i for: player1.                     " reset move "

         (mval < tbeta ) ifTrue:[
                      tbeta := mval.
                      move := i ].                     " best move til now "

         (mval <= alpha) ifTrue: [
                      level := level + 1.      " Go up "
                      bestmove := move.                " Save best move "
                      ^tbeta].                                                 " Quit the loop"


    ].

    level := level + 1.                         " Go up "
    bestmove := move.                                   " Save best move "

    ^tbeta.!
 
player2
    " Return Value of player2 "
    ^player2!
 
player2Move: alpha with: beta
    "Private - find Best move for player 2
      return the situation value of best move
      player2 is MAXIMIZING "

    | col mval move talpha movlist |

    move := -1.
    talpha := alpha.

    (level = 0) ifTrue: [ ^ self evaluate ].                 " evaluate Situation "

    level := level - 1.                                              " go down "

    movlist := self possibleMoves: player2.         " get possible moves "

    movlist do:[ :i |
        self doMove: i for: player2.
        (self checkWin: i for: player2 )                     " immediate check  "
                 ifTrue: [                                                    " winner "
                      mval := maxvalue ]                " set maximum "
                 ifFalse:[
                      mval := self player1Move: talpha with: beta].   " recursion "

         self undoMove: i for: player2 .                             " reset move "

         (mval > talpha ) ifTrue:[
                      talpha := mval.
                      move := i ].                      " best move til now "

         (mval >= beta) ifTrue: [                       " quit the loop  "
                      level := level + 1.                " Go up "
                      bestmove := move.                 " Save best move "
                      ^talpha ].

    ].

    level := level + 1.                                      " Go up "
    bestmove := move.                                    " Save best move "

    ^talpha.!

possibleMoves: player
    " Private - Return all possible Moves for player "
    self implementedBySubclass.!
 
undoMove: move for: player
    " Private - undo move"
    self implementedBySubclass.!

validateMove: move for: player
    " Validate move for player , return true if valid
       Default do nothing. "

    ^false.! !
