
GameLogic subclass: #GameFourWin
  instanceVariableNames: 
    'value top sequence up down '
  classVariableNames: ''
  poolDictionaries: ''  !


!GameFourWin class methods ! !



!GameFourWin methods !
 
checkColumn: column for: player
    "Private - check column in all directions (weighted) "

    | t tot cnt dir pos search |

    ( self validateMove: column for: player) ifFalse:
         [ ^0 ].                                             " Column is full "

    tot := 0.                                               " total number of items "
    t := top at: column.

    search := board directions.
    1 to: 4 do: [ :i |
           cnt := 0.
           dir := search at: i.

           pos := t + dir.                                " positive search "
           [( board getPos: pos) = player] whileTrue:[
                  cnt := cnt + 1.
                  pos := pos + dir].

           pos := t - dir.                                " negative search "
           [( board getPos: pos) = player] whileTrue:[
                  cnt := cnt + 1.
                  pos := pos - dir].

           (cnt > 4 ) ifTrue: [cnt := 4].         " 4 Wins "
           tot := tot + ( value at: (cnt + 1)).   " 1 -> 1 , 2 -> 11, 3 -> 111, 4 -> 1111 "
        ].

        ^tot.!
   
checkWin: move for: player
    " Private - Check winning situation for player
      winner returns true ( after an item was set) "

    | t max cnt dir pos search |

    search := board directions.
    max := 0.                               " max number of items "
    t := (top at: move) + down.     " Start below top "

    1 to: 4 do: [ :i |
           cnt := 1.
           dir := search at: i.

           pos := t + dir.                  " positive search "
           [( board getPos: pos) = player] whileTrue:[
                  cnt := cnt + 1.
                  pos := pos + dir].

           pos := t - dir.                   " negative search "
           [( board getPos: pos) = player] whileTrue:[
                  cnt := cnt + 1.
                  pos := pos - dir].

           (cnt > max) ifTrue: [ max := cnt].

      ].

      (max >= 4) ifTrue:[ ^true]
                        ifFalse:[ ^false].!
   
doMove: move for: player
    " Private - Issue move for player
       move is column "

    | t |

    t := top at: move.
    board setPos: t value: player.
    top at: move put: (t + up).!
   
evaluate
    "Private - evaluate current situation
      player1 is MINIMIZING, player2 is MAXIMIZING "

    | val |

    val := 0.
    1 to: dim do: [ :i |
         val := val + (self checkColumn: i for: player2).
         val := val - (self checkColumn: i for: player1) ].

    ^val.!
   
go: column
    " Test - manual move on column "

    | move |

    self doMove: column for: player2.
    Transcript nextPutAll: 'Your Move : ' , column printString ; cr.
    (self checkWin: column for: player2)
       ifTrue:[ Transcript nextPutAll: '** You win !!' ; cr.
                    ^nil ].

    move := self getMove: player1.
    self doMove: move for: player1.
    Transcript nextPutAll: 'My Move : ' , move printString ; cr.
    (self checkWin: move for: player1)
    ifTrue:[ Transcript nextPutAll: '** You loose !!' ; cr].!

initGame
    " Private - Initialize a the GameVariables
       init variables : player1 player2 maxvalue level "

    level := 2.                                            " Superclass variables "
    player1 := 100.
    player2 := 200.
    maxvalue := 11111.

    up := (board directions) at: 1.
    down := up negated.

    value := #(0 1 11 111 1111).               " For Evaluation "

    top := Array new: dim.

    (dim = 8) ifTrue:[                                  "Search-Sequence "
        sequence := #(4 5 3 6 2 7 1 8) ].
    (dim = 10) ifTrue:[
        sequence := #(5 6 4 7 3 8 2 9 1 10) ].
    (dim = 16) ifTrue:[
        sequence := #(8 9 7 10 6 11 5 12 4 13 3 14 2 15 1 16) ].

    1 to: dim do:[ :i | top at: i put: (board toLinear: (i @ 1)  ) ].!
   
possibleMoves: player
    " Private - Return all possible Moves for player"
    " each move is a column number "

    ^sequence
         select: [:i | (self validateMove: i for: player) ].!
  
undoMove: move for: player
    " Private - undo move,  move is column "

    | t |

    t := (top at: move) + down.
    board resetPos: t.
    top at: move put: t.!
 
validateMove: column for: player
    " return false if column full "

    ((board getPos: (top at:column)) = board empty)
        ifTrue: [ ^true].

    ^false.! !
