
Object subclass: #GameBoard
  instanceVariableNames: 
    'board dim xdim directions vframe vempty '
  classVariableNames: ''
  poolDictionaries: ''  !


!GameBoard class methods !
   
new: anInteger
    "Create a GameBoard with Dimension anInteger"

    ^super new initialize: anInteger.! !



!GameBoard methods !
   
directions
    " Return Search-Directions
       array sequence: VERTICAL HORIZONTAL DIAGONAL\ DIAGONAL/
                | - \ / "
    ^directions.!

empty
    " Return the value for an empty position "
    ^vempty.!

getPos: pos
    " Get Board-Value at pos (linear address)"

    ^board at: pos.!
 
getPosXY: pos
    " Get Board-Value at pos (X/Y-Address)"

    ^board at: (self toLinear: pos).!
 
initialize: anInteger
    "Private - Initialize GameBoard with Dimension anInteger"

    | h |

    dim := anInteger.
    xdim := anInteger + 2.                            " plus frame "
    vempty := 0.                                           " Value of empty place "
    vframe := -1.                                           " Value of frame "

    board := Array new: (xdim * xdim).        " The Board "
    board atAllPut: vempty.

    h := (dim + 1 * xdim).
    1 to: xdim do: [:i |
             board at: i put: vframe.                 " Upper Frame "
             board at: ((i - 1) * xdim + 1) put: vframe.
             board at: (i * xdim) put: vframe.
             board at: (h + i) put: vframe.         " Lower Frame "
                           ] .

    directions := Array new: 4.                     " Search-Directions "
    directions at: 1 put: (dim + 2);                " Vertical Search "
                     at: 2 put: 1;                            " Horizontal Search "
                     at: 3 put: (dim + 3);                " Diagonal Search \ "
                     at: 4 put: (dim + 1).                " Diagonal Search / "!
   
resetPos: pos
    " Board at pos is set to vempty (linear address)"

    board at: pos put: vempty.!
 
resetPosXY: pos
    " Board at pos is set to vempty (X/Y-Address)"

    board at: (self toLinear: pos) put: vempty.!
 
setPos: pos value: val
    " Board at pos is set to val (linear address)"

    board at: pos put: val.!
  
setPosXY: pos value: val
    " Board at pos is set to val (X/Y-Address)"

    board at: (self toLinear: pos) put: val.!
  
toLinear: aPoint
     " Convert X/Y-Address to linear Address"

    ^(xdim * (aPoint y)) + (aPoint x) + 1.!
  
toXY: lin
     " Convert linear Address to X/Y-Address"

    ^ ((lin - 1) \\ xdim) @ ((lin - 1) // xdim).! !
