
ViewManager subclass: #G4Win
  instanceVariableNames: 
    'theGame theViewer youBegin '
  classVariableNames: ''
  poolDictionaries: 
    'ColorConstants ' !


!G4Win class methods ! !



!G4Win methods !
 
buttonClicked: aButton
    "Private - Perform move on clicked column."

    self yourMove: (aButton contents) asInteger.!

changeButtons: aPane
    " Private - Resize the Buttons "

    | dim buttons |

    dim := theGame dimension.

    buttons := aPane children.                          " shrink buttons "
    buttons do:[ :each |
        each framingRatio: ( 0 @ 0   extent: 0 @ 0 );
        hideWindow.
    ].

    buttons := aPane children.                          " resize buttons "
    1 to: dim  do: [ :i |
        (buttons at: i)
            framingRatio: ((Rectangle leftTopUnit
                rightAndDown: (i - 1/ dim) @ 0) extentFromLeftTop: (1/dim) @ 1 );
           showWindow.
     ].!

changeMenuBar: aTopPane
    "Private - Remove Default - Menus and add Game - Menus"

    aTopPane menuWindow removeMenu:
             (aTopPane menuWindow menuTitled: 'File').
    aTopPane menuWindow removeMenu:
             (aTopPane menuWindow menuTitled: 'Edit').
    aTopPane menuWindow removeMenu:
             (aTopPane menuWindow menuTitled: 'Smalltalk').

    aTopPane menuWindow addMenu:
        ((Menu
            labels: 'New ~Game\~Options \E~xit\~About'  withCrs
            lines: #( 2 3)
            selectors:#(gameNew gameOptions gameExit gameAbout))
            owner: self;
            title: '~Game';
            yourself).!
   
close: aPane
    "Private - Close the receiver."

    (MessageBox confirm: 'Exit the game ?')
        ifTrue: [
            self close.
            (Smalltalk isRunTime)
                ifTrue: [
                    Smalltalk exit.
            ]
    ].!
 
doButtons
    " Private - Add a Button for each column "

    | dim buttons group |

    dim := theGame dimension.

    self addSubpane:
        (group := GroupPane new
            owner: self;
            setName: 'buttons';
            when: #getContents perform: #changeButtons: ;
            framingRatio: ((Rectangle leftTopUnit
                rightAndDown: (1/20) @ (35/40)) extentFromLeftTop: (18/20) @ (3/40) )
        ).

    1 to: 16  do: [ :i |
        group addSubpane:
            (Button new
                owner: self;
                when: #clicked perform: #buttonClicked:;
                contents: i printString;
                framingRatio: ((Rectangle leftTopUnit
                    rightAndDown: (i - 1/ dim) @ 0) extentFromLeftTop: (1/dim) @ 1 )
            )
    ].!
 
gameAbout
      " Private - Diplay About-Information "

      MessageBox message: '4Win by J. Bruchi'.!
 
gameExit
     "Private - exit 4Win"

    self close: TopPane.!
   
gameNew
    "Private - Start a new game."

    | dim lev |

    (MessageBox confirm:'Start a new game')
    ifTrue:[
        dim := theGame dimension.
        lev := theGame level.
        theGame := (GameFourWin new: dim).
        theGame level: lev.
        youBegin ifFalse:[
                theGame doMove: dim // 2 for: theGame player1].
        theViewer game: theGame.
        (self paneAt: 'board') event: #getContents].!
 
gameOptions
    "Private - Call OptionsDialog
      create a new Game if dimension changed  "

    | go dim lev |

    dim := theGame dimension.
    lev := theGame level.
    go := GameOptions new.
    go maxLevel: 6.
    go level:lev dimension:dim youBegin:youBegin.

    (go canceled)  ifFalse:[
        youBegin := go youBegin.
        (go dimension = dim) ifFalse:[
            theGame := (GameFourWin new: go dimension).
            theGame level: go level.
            theViewer game: theGame.
            youBegin ifFalse:[
                theGame doMove: (go dimension) // 2 for: theGame player1].
"             self sendInputEvent: #getContents. "
            (self paneAt: 'board') event: #getContents.
            (self paneAt: 'buttons') event: #getContents.
        ]
        ifTrue:[
            theGame level: go level.
        ].
    ].!

initWindowSize
   "Private - Answer default initial window extent."

   ^Display width * 3 // 10 @ (Display height * 6 // 10)!
   
mouseClicked: pane
     "Private - Determine which square the mouse
       was released on."

    | point  |

    point := theViewer mousePos.
    self yourMove: point x.!
  
open
    "Open G4Win , create the Game "

    | group game |

    youBegin := true.
    theGame := GameFourWin new: 10.
    theGame level: 2.

    self
        label: '4Win';
        when: #close perform: #close:;
        owner: self.

    self when: #menuBuilt perform: #changeMenuBar: .

    self addSubpane:
        (game := GraphPane new
            owner: self;
            setName: 'board';
            when: #getContents perform: #redrawBoard:;
            when: #display perform: #redrawBoard:;
            style: GraphPane noScrollBarsFrameStyle;
            when: #button1Up perform: #mouseClicked:;
            framingRatio: ( (Rectangle leftTopUnit
                rightAndDown:(1/20) @ (1/20)) extentFromLeftTop: (18/20) @ (14/20) )
       ).

    self addSubpane:
        (StaticText new
            owner: self;
            centered;
            contents:'4Win by J.Braeuchi';
            setName: 'info';
            framingRatio: ( (Rectangle leftTopUnit
                rightAndDown:(1/20) @ (31/40)) extentFromLeftTop: (18/20) @ (3/40) )
       ).

    self doButtons.
    theViewer := GameViewer new
            pane: game;
            game: theGame.

    self openWindow.!

redrawBoard: pane
    "Private - Redraw the game board "

    theViewer redraw: pane.!
   
yourMove: column
     "Private - Execute a move on column."

    | move |

    ( theGame validateMove: column for: nil)
    ifFalse: [
        MessageBox message:'Column ' , column printString,' is full'.
        ^nil
    ].

    theGame doMove: column for: theGame player2.
    theViewer drawColumn: column.

   (theGame checkWin: column for: theGame player2)
    ifTrue:[
        MessageBox message:'You win'.
        self gameNew.
        ^nil
    ].

    (self paneAt:'info') contents:'Thinking...'.
    CursorManager execute change.
    move := theGame getMove: theGame player1.
    (move isNil) ifTrue: [
        (self paneAt:'info') contents:'Panic !!'.
        (theGame gameOver)
        ifTrue: [ ^nil ]
        ifFalse: [
            move := (theGame possibleMoves: nil) at: 1.]
    ].

    theGame doMove: move for: theGame player1.
    theViewer drawColumn: move.
    (self paneAt:'info') contents:'My Move ' , move printString.
    CursorManager normal change.

    (theGame checkWin: move for: theGame player1)
    ifTrue:[
        MessageBox message:'You loose'.
        self gameNew.
        ^nil
    ].! !
