/* ChapMan installation program */
say "Welcome to the ChapMan installation program!"
say
say "Did you read the readme file?"
pull yn
if yn \= 'Y' Then 
  "@e readme"

say "Please specify a directory for the ChapMan application (*.CHA) and "
say "source (*.CLS) files. You may use for example you Smalltalk directory."
dirname = AskForDirectory()
if dirname \= directory() Then Do
  Say
  Say "Copying *.CLS and *.APP files to" dirname
  '@copy *.cls' dirname
  if rc \=0 Then call Error("Error copying .CLS files")
  '@copy *.cha' dirname
  if rc \=0 Then call Error("Error copying .CHA files")
End   

Say
say "Please specify a directory for the ChapMan help files. This directory "
say "must be included in the HELP statement of your CONFIG.SYS. If you don't"
say "want to modify it, just specify your Smalltalk directory."
dirname = AskForDirectory()
if dirname \= directory() Then Do
  say "Copying .HLP files to" dirname
  '@copy *.hlp' dirname
  if rc \=0 Then call Error("Error copying .HLP files")
End   


Say
if stream("chapman.inf", "c", "query exists") = "" Then
  Call hlp2inf chapman

Say
Say "Please any key to view the chapman documentation and see how to proceed "
say "with the installation."
Pull wait
'@start view chapman introduction'
Exit

/* Ask for a directory */
AskForDirectory: procedure
Do Forever
  say "Enter a directory name (<ENTER> for the current directory): "
  pull dirname
  curdir = directory()
  newdir = directory(dirname)
  call directory(curdir)
  If newdir = "" Then Do
    Say "The directory you specified does not exist. Do you want to create it?"
    pull answer
    if answer = "Y" then Do
      '@mkdir' dirname
       curdir = directory()
       newdir = directory(dirname)
       call directory(curdir)
       return newdir
    End
  end
  Else return newdir
End


Error:
parse arg errmsg
Say
Say errmsg
Say "The installation has been aborted."
Exit
