
"--- Revision History
2.0.0.1.0.1 fixed resource bitmaps not released problem
2.0.0.1.0.3 ScrollBars inside CompositePanes now scroll properly
2.0.0.1.0.4 fixed ViewManager open/close for PARTS
2.0.0.1.0.5 fixed DialogCoordinator launch and sizing problems
2.0.0.1.0.6 fixed MDI parent window client area problem
2.0.0.1.0.7 fixed support for toolbars in MDI
2.0.0.1.0.8 fixed CompositePane validation with child rectangles = nil
2.0.0.1.0.9 fixed base image bug where StatusPanes in Dialogs were way too tall
2.0.0.1.0.10 fixed EnhancedEntryField field validation during losingFocus when window closes
2.0.0.1.0.11 added Window>>iconFile/: methods
2.0.0.1.0.12 preInitWindow no longer called when WBPro opened on AppCoord subclass and added new AppCoord class >> preInitWindow:forModel: method
2.0.0.1.0.13 partsSupportEnabled fix
2.0.0.1.0.14 fixed purgeUnusedBitmaps in base image
2.0.0.1.0.15 fixed right/bottom relative FramingParameters in dialogs
2.0.0.1.0.16 added WsTabstop style in SubPane>>tabStop
2.0.0.1.0.17 fixed Bitmap>>fromSysId:
2.0.0.4 fixed resource bitmaps not released problem
2.0.0.5 added method to convert all module bitmaps (from resource DLL) to bitmaps stored in image
2.0.0.8 fixed ComboBox overlap problem via WBComboBox... problem still exists in ComboBox
2.0.0.12 FramingParameters cache dialog units
2.0.0.16 added old FramingParameter support
2.0.0.23 fixed drag from WB to Parts
2.0.0.27 fixes for Subpanes/V
2.0.0.31 removed WK support
2.0.0.35 fixed parts support for CompositePanes with new wb base runtime method Object>>isPARTSInstalled
2.0.0.37 fixed CompositePane in Parts Workbench
2.0.1.0.0.1 fixed CompositePane>>wbPartEventItems
2.0.1.0.0.9 integrate into 3.0.1
2.0.1.0.0.12 fixed CompositePane horizontal scrolling
--- end of Revision History"  !

"--------- add temporary methods"!

!String methods !  
osiMethods
        "Answer self as the class reader so that errors
            like missing classes and methods referencing globals
            not in the image can failed gracefully."
    ^self! !

!String methods !  
osiMethods: aString
        "Answer self as the class reader so that errors
            like missing classes and methods referencing globals
            not in the image can failed gracefully."
    (aString osiEvaluateIfError: [ false ]
        ) ~= false ifTrue: [ ^self osiMethods ].
    "Answer a string that will not evaluate."
    ^'a ', self! !

!String methods !  
osiEvaluateIfError: aBlock
        "Evaluate the receiver and answer the result.
            Answer aBlock evaluated if an error occurs."
    | compiler result answer |
    compiler := CompilerInterface
        forClass: UndefinedObject
        errorHandler: SilentErrorHandler new.
    [   answer := 
            (result := compiler evaluate: self) wasSuccessful
                ifTrue: [ result value ]
                ifFalse: [ aBlock value ].
    ]   on: Error
        do: [ answer := aBlock value ].
    ^answer! !

!String methods !  
osiRemoveSelector: aString
        "Remove the specified selector from the specified class.
            If the class or selector are not defined,
            then fail gracefully and report an error to the Transcript."
    | aClass aSelector |
    aClass := self osiEvaluateIfError: [ nil ].
    aSelector := aString asExistingSymbolOrNil.
    aClass notNil & aSelector notNil
        ifTrue: [ aClass removeSelector: aSelector ]
        ifFalse: [
            Transcript cr;
                nextPutAll: 'Ignored remove ', self, '>>', aString ].! !

!String methods !  
fileInFrom: aStream
        "File in the method definitions.
            If the class is missing or the method does not compile,
            then fail gracefully and report an error to the Transcript."
    | aClass chunk compiler result assoc mth |
    (aClass := self osiEvaluateIfError: [ nil ]
        ) notNil ifTrue: [
            compiler := CompilerInterface
                   forClass: aClass
                errorHandler: SilentErrorHandler new ].
    [(chunk := aStream nextChunk) isEmpty]
        whileFalse: [
            compiler notNil ifTrue: [
                 (result := compiler compile: chunk) wasSuccessful
                    ifTrue: [
                        assoc := result association.
                        ((mth := aClass compiledMethodAt: assoc key) isNil
                            or: [ mth sourceString ~= chunk ]
                        ) ifTrue: [
                            assoc value
      	                         classField: aClass;
                                selector: result selector;
                                sourceObject: nil;
                                sourceString: chunk.
                            aClass
                                addSelector: assoc key
                                withMethod: assoc value ] ]
                    ifFalse: [
                        result := nil ] ].
            result isNil ifTrue: [
                Transcript cr;
                    nextPutAll: 'Ignored ', self, ' method' ] ].! !

!String methods !  
osisubclass: className
    instanceVariableNames: instVarString
    classVariableNames: classVarString
    poolDictionaries: poolDictString
        "Create or modify the class named <className> to be a
        subclass of the receiver with the specifed instance variables,
        class variables, pool dictionaries."

    | aClass subClass aSelector instVarNames classVarNames poolDictNames |
    aClass := self osiEvaluateIfError: [ nil ].
    aClass isBehavior ifFalse: [ aClass := nil ].
    subClass := className osiEvaluateIfError: [ nil ].
    aClass isNil ifTrue: [
        Transcript cr;
            nextPutAll: 'Ignored ', self, ' subclass: #', className, '...'.
        ^nil ].
    subClass notNil ifTrue: [
        instVarNames := subClass instanceVariableString asArrayOfSubstrings.
        classVarNames := subClass classVariableString asArrayOfSubstrings asSortedCollection.
        poolDictNames := subClass sharedPools asSortedCollection collect: [ :each | each asString ].
        (instVarString asArrayOfSubstrings = instVarNames and: [
            classVarString asArrayOfSubstrings asSortedCollection = classVarNames and: [
                poolDictString asArrayOfSubstrings asSortedCollection = poolDictNames and: [
                    aClass == subClass superclass ] ] ]
        ) ifTrue: [ ^subClass ] ].
    ^[  aClass
            subclass: className asSymbol
            instanceVariableNames: instVarString
            classVariableNames: classVarString
            poolDictionaries: poolDictString
            ] on: Error do: [
                Transcript cr;
                    nextPutAll: 'Ignored ', self, ' subclass: #', className, '...'.
                nil ].
! !

!String methods !  
osisubclass: className
    instanceVariableNames: instVarString
    classVariableNames: classVarString
    poolDictionaries: poolDictString
    ifDefined: ifDefString
        "Create or modify the class named <className> to be a
        subclass of the receiver with the specifed instance variables,
        class variables, pool dictionaries.  If <ifDefString> evaluates
        false, then ignore the class definition."

    ^(ifDefString osiEvaluateIfError: [ false ]) ~= false
        ifTrue: [
            self
                osisubclass: className
                instanceVariableNames: instVarString
                classVariableNames: classVarString
                poolDictionaries: poolDictString ]
        ifFalse: [
            Transcript cr;
                nextPutAll: 'Ignored ', self, ' subclass: #', className, '...'.
            nil ].! !
  
"--------- end temporary methods"!

'EnhancedEntryField' osiRemoveSelector: 'oldLosingFocus' !
'EnhancedEntryField' osiRemoveSelector: 'resetLoseFocus' !
'SexPane' osiRemoveSelector: 'open' !

"WB Run Base Common (WB2ARBW.SLL)"!

'WBObject' osisubclass: 'FramingParameters'
  instanceVariableNames: 
    ' initialExtent bottom top right left bottomRel topRel rightRel leftRel centerX centerY indent clientRect duHeight duWidth '
  classVariableNames: 
    ' InitializationSelector '
  poolDictionaries: 
    ' OperatingSystemConstants ' !

"WB Run Miscellaneous (WB20RM.SLL)"!

'ComboBox' osisubclass: 'WBComboBox'
  instanceVariableNames: 
    ' fullList disabled isListVisible isListSizeDynamic '
  classVariableNames: 
    ' IsListSizeDynamicDefault '
  poolDictionaries: 
    ' OperatingSystemConstants ' !

"WB Run Base Common (WB2ARBW.SLL)"!
!'ApplicationCoordinator' osiMethods !  
views
    #addedByOSI.
    ^Array with: self mainView! !

"WB Run Parts (WB2ARPW.SLL)"!
!'ApplicationCoordinator' osiMethods: 'WBPARTSInterfaceList' !  
wbPartMessages

        "WARNING!! This method was automatically generated by 
        WindowBuilder. Code you add here which does not conform to 
        the WindowBuilder API will probably be lost the next time 
        you save your wb-parts definition."

    ^WBPARTSMessageList new
        items: #(close open openCenteredOnMouse openRelativeTo:offset: openWithParent:)
        separators: #( )
        defaultItem: #open;
        yourself! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'ApplicationCoordinator class' osiMethods !  
constructViewFor: aCoordinator
    "Create a new view of the application <aCoordinator> and define its structure."
    "Modified by OSI to add special event handlers for WB windows"
    | view |
    #modifiedByOSI.
    view := self createViewFor: aCoordinator.
    aCoordinator isWBWindow
        ifTrue: [
            view owner: aCoordinator.
            aCoordinator
                when: #wbNeedsView send: #yourself to: view;
                when: #wbNeedsPaneNamed: send: #paneNamed: to: view;
                when: #wbNeedsMenuNamed: send: #wbMenuTitled: to: view menuWindow].
    self buildView: view forModel: aCoordinator.
    ^view! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'ApplicationCoordinator class' osiMethods !  
open: aCoordinator
    "Build and open a window for <aCoordinator>."

    | view |
    #modifiedByOSI.
    view := self constructViewFor: aCoordinator.
    aCoordinator isWBWindow ifTrue: [
        self preInitWindow: view forModel: aCoordinator.
        aCoordinator preInitWindow ].
    view open! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'ApplicationCoordinator class' osiMethods !  
preInitWindow: aView forModel: aCoordinator
        "Preform any window initialization."
    #addedByOSI.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'ApplicationCoordinator class' osiMethods !  
windowId
        "Private - Answer the default dialog id for any
        DialogTopPane owned or implemented by a
        subclass of ApplicationCoordinator."
    ^1! !

"WB Run Base Win32 (WB2ARBW.SLL)"!
!'ApplicationWindow' osiMethods !  
buildWindow
        "Private - Create the host window for the receiver."
        "Modified by OSI to provide wbOwner support."
    | myRealRectangle focusPane |
    #modifiedByOSI.
    style isNil ifTrue: [ style := self getStyle ].
    NotificationManager newWindow notNil ifTrue: [
        NotificationManager newWindow: nil.
        ^nil ].   "A Walkback came up during creation of window"
    NotificationManager newWindow: self.

    " clear rectangle during build to force sizeChanged: to resize children "
    myRealRectangle := rectangle.
    rectangle := 0@0 extent: 0@0.

    self create: self windowClass
        title: label
        style: ( style bitAnd: ( WsVisible bitXor: 16rFFFFFFFF ) )  "create hidden, show after validate"
        rectangle: rectangle
        parent: parent.
    NotificationManager newWindow: nil.
    self owner isWBWindow ifFalse: [
        parent notNil ifTrue: [
            UserLibrary setParent: self asParameter to: parent asParameter ] ].

    self isHandleOk ifFalse: [ self outOfMemory. ^nil ].

    self systemMenuHandle.

    "menu and subpanes created in the wmCreate message process"

    "Set the size of the frame window."
    self handle
        setWindowPos: nil
        rectangle: myRealRectangle
        fs: SwpNozorder.

    focusPane := self subPaneWithFocus.
    self activeTextPane: self searchForDefaultTextPane.
    focusPane notNil ifTrue: [ focusPane setFocus ].
    self subPaneWithFocus: focusPane! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'ApplicationWindow' osiMethods !  
topParent
        "Answer the top most parent."
    #addedByOSI.
    ^self! !

"WB Run Base Win32 (WB2ARBW.SLL)"!
!'Bitmap' osiMethods !  
fromModule: aModuleName id: bitmapName
        "Private - Load the receiver from the module
        aModuleName with id bitmapName."
    | bitmapStruct hLibrary fileName path |
    #modifiedByOSI.
    aModuleName notNil ifTrue: [
        fileName := aModuleName fileNameLessPath.
        ( hLibrary := KernelLibrary loadLibrary: fileName asParameter ) = 0
            ifTrue: [
                "If load failed, then search the path..."
                ((path := File findFileName: fileName) isNil or: [
                    (hLibrary := KernelLibrary loadLibrary: path asParameter) = 0
                ]) ifTrue: [ ^self osError ] ] ].
    ( bitmapHandle := UserLibrary
        loadBitmap: hLibrary asParameter
        name: bitmapName asParameter ) = 0
            ifTrue: [ ^self osError ].
    BitmapHandleTable at: bitmapHandle put: self.
    hLibrary notNil ifTrue: [
        ( KernelLibrary freeLibrary: hLibrary )
            ifFalse: [ ^self osError ] ].

    "use archive to save dll name and id."
    archive := Array with: fileName with: bitmapName.
    GDILibrary
        getObject: bitmapHandle
        count: WinBitmapStruct sizeInBytes
        lpObject: ( bitmapStruct :=  WinBitmapStruct new ) asParameter.
    bitmapInfo := WinBitmapInfo
        width: bitmapStruct width
        height: bitmapStruct height
        planes: 1
        bitCount: bitmapStruct planes * bitmapStruct bitsPixel.
    deviceContext := self class memoryContext.
    graphicsTool := Pen forDC: deviceContext medium: self.
    graphicsTool
        width: bitmapInfo width;
        height: bitmapInfo height! !

"WB Run Base Win32"!
!'Bitmap' osiMethods !  
moduleNameIfArchived
        "Private - Answer the module name if the receiver
            is not in memory, else nil."
    #addedByOSI.
    ((bitmapHandle isNil or: [bitmapHandle = NullHandle])
        and: [ archive isArray ])
            ifTrue: [ ^archive at: 1 ].
    ^nil! !

"WB Run Base Win32 (WB2ARBW.SLL)"!
!'Bitmap class' osiMethods !  
purgeUnusedBitmaps
    "Modified by OSI - provide Digitalk fix"
        "Private - Purge unused bitmaps from the system."
    | handles all bitmaps |
    #modifiedByOSI.
    all := BitmapHandleTable keys.
    BitmapHandleTable := Dictionary new.
    bitmaps := Bitmap allInstances.
    handles := bitmaps collect: [ :each | each bitmapHandle ].
    GDILibrary selectObject: MemoryContext with: DefaultBitmap.
    all do: [ :each |
        ( each notNil and: [ ( handles includes: each ) not ] ) ifTrue: [
            ( GDILibrary deleteObject: each ) ifFalse: [ self osWarning ] ] ].
    bitmaps do: [ :each |
        each bitmapHandle notNil ifTrue: [
            BitmapHandleTable at: each bitmapHandle put: each ] ]! !

"WB Run Base Win32 (WB2ARBW.SLL)"!
!'Bitmap class' osiMethods !  
validateAll: aCollection
        "Validate all bitmaps in aCollection...
            Faster than validating one bitmap at a time."
    | moduleNames moduleHandles eachModuleName |
    #addedByOSI.
    moduleNames := Set new.
    moduleHandles := OrderedCollection new.
    aCollection do: [ :eachBitmap |
        eachBitmap isBitmap ifTrue: [
            (eachModuleName := eachBitmap moduleNameIfArchived) notNil ifTrue: [
                (moduleNames includes: eachModuleName) ifFalse: [
                    moduleNames add: eachModuleName.
                    moduleHandles add: (KernelLibrary loadLibrary: eachModuleName) ] ].
            eachBitmap validate ] ].
    moduleHandles do: [ :each | KernelLibrary freeLibrary: each ].! !

"WB Run Parts (WB2ARPW.SLL)"!
!'CompositePane' osiMethods: 'WBPARTSInterfaceList' !  
addSubpanesForWBParts
        "Add the subpanes for parts."
        "For PARTS Support."
    super addSubpanesForWBParts.
    self partEvents wbItems do: [ :each | each wbLinkPartEvent ].! !

"WB Run Parts (WB2ARPW.SLL)"!
!'CompositePane' osiMethods: 'WBPARTSInterfaceList' !  
close
        "Private - Close the subpane and reinitialize."
        "For PARTS Support."
    super close.
    self partEvents wbItems do: [ :each | each wbUnlinkPartEvent ].
    self partMessages wbItems do: [ :each | each wbUnlinkPartMessage ].
    children := nil.! !

"WB Run CompositePane Common (WB2ARCPW.SLL)"!
!'CompositePane' osiMethods !  
contents
    "Answer the value of the receiver.
     This should be overriden in subclasses"
    ^nil! !

"WB Run CompositePane Common (WB2ARCPW.SLL)"!
!'CompositePane' osiMethods !  
contents: anObject
    "Set the value of the receiver.
     This should be overriden in subclasses"! !

"WB Run Parts (WB2ARPW.SLL)"!
!'CompositePane' osiMethods: 'WBPARTSInterfaceList' !  
doesNotUnderstand: message
        "Sent to the receiver by the virtual machine when the <message>
        sent to the receiver was not implemented by the receiver."
    ^(self partMessages
            wbItemFor: message selector
            ifAbsent: [^super doesNotUnderstand: message]) 
            evaluateWithArguments: message arguments! !

"WB Run Parts (WB2ARPW.SLL)"!
!'CompositePane' osiMethods: 'WBPARTSInterfaceList' !  
fileName
        "Answer nil indicating that the receiver is not stored elsewhere."
        "For PARTS support."
    ^nil! !

"WB Run CompositePane Common (WB2ARCPW.SLL)"!
!'CompositePane' osiMethods !  
framingBlock: aBlock

    (self framingBlock isNil or: [self framingBlock isContext]) ifTrue: [
        super framingBlock: aBlock
    ].
    aBlock isNil ifTrue: [
        super framingBlock: aBlock
    ] ifFalse: [
        initialSize := (aBlock value: Display boundingBox) extent
    ]! !

"WB Run Parts (WB2ARPW.SLL)"!
!'CompositePane' osiMethods: 'WBPARTSInterfaceList' !  
isLinked
        "Answer true indicating that the receiver is linked."
        "For PARTS support."
    ^true! !

"WB Run CompositePane Common (WB2ARCPW.SLL)"!
!'CompositePane' osiMethods !  
isMDISupportPane
        "Answer true if receiver is a support pane for MDI."
    | cpStyle |
    ^(cpStyle := self cpStyle) == #mdiToolBar or: [
        cpStyle == #mdiToolBarBordered]! !

"WB Run Parts (WB2ARPW.SLL)"!
!'CompositePane' osiMethods: 'WBPARTSInterfaceList' !  
isPARTSNestedPart
        "Answer whether the receiver is a PARTS NestedPart."
    ^true! !

"WB Run CompositePane Common (WB2ARCPW.SLL)"!
!'CompositePane' osiMethods !  
open

    self children isEmpty ifTrue: [ self addSubpanesForWBParts ].
    self wbOldVersionSupport.
    self wbLinkPartEvents.
    self preInitWindow.
    graphicsTool notNil
        ifTrue: [graphicsTool release].
    super open.
    self event: #getContents. "Obsolete"
    self triggerEvent: #needsContents.! !

"WB Run Parts (WB2ARPW.SLL)"!
!'CompositePane' osiMethods: 'WBPARTSInterfaceList' !  
partEvents
        " Answer the PARTS event interface of the receiver. "
    ^self propertyAt: #wbPartEvents ifAbsentPut: [ self wbPartEvents ]! !

"WB Run Parts (WB2ARPW.SLL)"!
!'CompositePane' osiMethods: 'WBPARTSInterfaceList' !  
partHint
        "Answer a string which gives a brief description
        of the receiver part. "
    ^self printString! !

"WB Run Parts (WB2ARPW.SLL)"!
!'CompositePane' osiMethods: 'WBPARTSInterfaceList' !  
partMessages
        " Answer the PARTS message interface of the receiver. "
    ^self propertyAt: #wbPartMessages ifAbsentPut: [ self wbPartMessages ]! !

"WB Run Parts (WB2ARPW.SLL)"!
!'CompositePane' osiMethods: 'WBPARTSInterfaceList' !  
partMirrorCopyChildren: aDictionary to: copy
        " Private - mirror copy the child windows "
    copy children: (
        aDictionary
            at: ( children ifNil: [ ^self ] )
            put: ( children class new )
        ).! !

"WB Run Parts (WB2ARPW.SLL)"!
!'CompositePane' osiMethods: 'WBPARTSInterfaceList' !  
partMirrorCopyPropertiesToExclude
        " Private - answer the names of any properties
        implemented by the receiver which should be excluded
        when its properties dictionary is mirrorCopied. "

   ^super partMirrorCopyPropertiesToExclude, #( wbPartEvents wbPartMessages )! !

"WB Run CompositePane Win32 (WB2ARCPW.SLL)"!
!'CompositePane' osiMethods !  
setScrollRanges
        "Private - Set the ranges for the horizontal and vertical
          scroll bars."
    | rangeRect minHorz maxHorz minVert maxVert |
    rangeRect := self scrollingRectangle.
    minHorz := rangeRect left.
    maxHorz := rangeRect right.
    minVert := rangeRect top.
    maxVert := rangeRect bottom.
    (self style bitAnd: WsHscroll) = 0
        ifTrue: [minHorz := maxHorz := 0].
    (self style bitAnd: WsVscroll) = 0
        ifTrue: [minVert := maxVert := 0].
    ( UserLibrary
        setScrollRange: self asParameter
        bar: SbHorz
        min: minHorz
        max: maxHorz
        redraw: false )
            ifFalse: [ ^self osError ].
    ( UserLibrary
        setScrollRange: self asParameter
        bar: SbVert
        min: minVert
        max: maxVert
        redraw: false )
            ifFalse: [ ^self osError ]! !

"WB Run CompositePane Common (WB2ARCPW.SLL)"!
!'CompositePane' osiMethods !  
setValue: anObject

    self value: anObject! !

"WB Run CompositePane Common (WB2ARCPW.SLL)"!
!'CompositePane' osiMethods !  
updateHorizontalSlider
        "Private - Update the slider box in the horizontal scrollBar."
    self updateHorizontalSliderTo: self topCorner x.! !

"WB Run CompositePane Common (WB2ARCPW.SLL)"!
!'CompositePane' osiMethods !  
validate

    self children do: [:child |
        child resize: self rectangle.
        child isButton ifTrue: [child receiveAllWindowMessages]].
    self setScrollRanges.
    super validate.
    self sendInputEvent: #updateRectangle.
    self initWindow.! !

"WB Run CompositePane Common (WB2ARCPW.SLL)"!
!'CompositePane' osiMethods !  
value
    "Answer the value of the receiver.
     This should be overriden in subclasses"
    ^self contents! !

"WB Run CompositePane Common (WB2ARCPW.SLL)"!
!'CompositePane' osiMethods !  
value: anObject
    "Set the value of the receiver.
     This should be overriden in subclasses"
    self contents: anObject! !

"WB Run Parts (WB2ARPW.SLL)"!
!'CompositePane' osiMethods: 'WBPARTSInterfaceList' !  
wbPartEvents

        "WARNING!! This method was automatically generated by 
        WindowBuilder. Code you add here which does not conform to 
        the WindowBuilder API will probably be lost the next time 
        you save your wb-parts definition."

    ^WBPARTSEventList new
        items: self class wbPartEventItems
        separators: #( )
        defaultItem: nil;
        yourself! !

"WB Run Parts (WB2ARPW.SLL)"!
!'CompositePane' osiMethods: 'WBPARTSInterfaceList' !  
wbPartMessages

        "WARNING!! This method was automatically generated by 
        WindowBuilder. Code you add here which does not conform to 
        the WindowBuilder API will probably be lost the next time 
        you save your wb-parts definition."

    ^WBPARTSMessageList new
        items: #(backColor: disable enable hideWindow inspect setFocus setValue: showWindow value yourself)
        separators: #( )
        defaultItem: #value;
        yourself! !

"WB Run CompositePane Win32 (WB2ARCPW.SLL)"!
!'CompositePane' osiMethods !  
wmHScroll: wordInteger with: longInteger
        "Private - Process a WM_HSCROLL message."
    | type pos w ctrlId |

    "If this is for a child, then pass it along..."
    longInteger = 0 ifFalse: [
        ctrlId := UserLibrary getWindowLong: longInteger index: GwlId.
        ( w := self childAtId: ctrlId ) isNil ifTrue: [ ^nil ].
        w syncControlEvent: wordInteger lowWord with: wordInteger highWord.
        ^nil ].

    type := wordInteger lowWord.

    type = SbLineup ifTrue: [
            (self horizontalScrollPos > self horizontalScrollMinRange) ifTrue:[
                 self scrollHorizontal: self amountToScrollLeft]].
    type = SbLinedown ifTrue: [
            (self horizontalScrollPos < self horizontalScrollMaxRange) ifTrue:[
                self scrollHorizontal: self amountToScrollLeft negated]].
    type = SbPageup ifTrue: [
            self scrollHorizontal: (self amountToPageLeft
                min: (self horizontalScrollPos - self horizontalScrollMinRange)) ].
    type = SbPagedown ifTrue: [
            self scrollHorizontal: (self amountToPageLeft
                min: (self horizontalScrollMaxRange - self horizontalScrollPos)) negated].
    type = SbThumbposition
        ifTrue: ["end of tracking"
            pos := wordInteger highWord.
            self updateHorizontalSliderTo: pos.
            self scrollHorizontal: self topCorner x - pos.
            ^nil].
    type = SbThumbtrack
        ifTrue: [^nil]
        ifFalse: [self updateHorizontalSlider].
    ^nil! !

"WB Run CompositePane Win32 (WB2ARCPW.SLL)"!
!'CompositePane' osiMethods !  
wmVScroll: wordInteger with: longInteger
        "Private - Process a WM_VSCROLL message."
    | type pos w ctrlId |

    "If this is for a child, then pass it along..."
    longInteger = 0 ifFalse: [
        ctrlId := UserLibrary getWindowLong: longInteger index: GwlId.
        ( w := self childAtId: ctrlId ) isNil ifTrue: [ ^nil ].
        w syncControlEvent: wordInteger lowWord with: wordInteger highWord.
        ^nil ].

    type := wordInteger lowWord.
    type = SbLineup ifTrue: [
            (self verticalScrollPos > self verticalScrollMinRange) ifTrue:[
                 self scrollVertical: self amountToScrollUp]].
    type = SbLinedown ifTrue: [
            (self verticalScrollPos < self verticalScrollMaxRange) ifTrue:[
                self scrollVertical: self amountToScrollUp negated]].
    type = SbPageup ifTrue: [
            self scrollVertical: (self amountToPageUp
                min: (self verticalScrollPos - self verticalScrollMinRange)) ].
    type = SbPagedown ifTrue: [
            self scrollVertical: (self amountToPageUp
                min: (self verticalScrollMaxRange - self verticalScrollPos)) negated].
    type = SbThumbposition
        ifTrue: ["end of tracking"
            pos := wordInteger highWord.
            self scrollVertical: self topCorner y - pos.
            self updateVerticalSliderTo: pos.
            ^nil].
    type = SbThumbtrack
        ifTrue: [^nil]
        ifFalse: [self updateVerticalSlider].
   ^nil! !

"WB Run CompositePane Common (WB2ARCPW.SLL)"!
!'CompositePane class' osiMethods !  
defaultBackColor
        "Answer the default background color for the receiver class."
    ^Color windowBackground
! !

"WB Run Parts (WB2ARPW.SLL)"!
!'CompositePane class' osiMethods: 'WBPARTSInterfaceList' !  
eventsTriggered
        "Answer all the events which can be triggered
        by instances of the receiver."
    ^super eventsTriggered
        addAll: self wbPartEventItems;
        yourself! !

"WB Run Parts (WB2ARPW.SLL)"!
!'CompositePane class' osiMethods: 'WBPARTSInterfaceList' !  
wbPartEventItems

    | answer |
    answer := self constructEventsTriggered.
    CompositePane constructEventsTriggered
        do: [ :each | answer remove: each ifAbsent: [ ] ].
    answer addAll: #( rightClicked tabbed ).
    ^answer asArray! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'ControlPane' osiMethods !  
getDefaultDragObjects

    "Private: Added by Objectshare."

    | dragObjects |
    #addedByOSI.
    #obsoleteMethod.
    (dragObjects := self propertyAt: #defaultDragObjects) isNil
        ifTrue: [^nil].
    self renderAsObjects
        ifFalse:
            [dragObjects := dragObjects
                collect:
                    [:each |
                    each asString]].
    ^dragObjects! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'ControlPane' osiMethods !  
isCompatible: anObject

    "Private: Added by Objectshare.
     Is an<Object> compatible with the receiver"

    #addedByOSI.
    self obsoleteMethod.
    ^false! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'ControlPane' osiMethods !  
renderAsObjects

    "Private: Added by Objectshare.
     Should the receiver deliver objects in a drag & drop
     transfer or the string representations of the objects"

    #addedByOSI.
    self obsoleteMethod.
    ^(self propertyAt: #renderAsObjects) ~~ nil! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'Date' osiMethods !  
asDate
    "Answer the receiver as a date."

    #addedByOSI.
    ^self! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'Date' osiMethods !  
monthNameAbbreviated
        "Answer a Symbol representing the
         month name of the receiver."
    ^self class nameOfMonthAbbreviated: self monthIndex! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'Date class' osiMethods !  
nameOfMonthAbbreviated: anInteger
        "Answer the month name as a Symbol corresponding
         to the month index anInteger (January for index
         1, to December for index 12)."
    | aName |
    (anInteger > 12 or: [anInteger < 1])
        ifTrue: [self errorInMonth].
    MonthNames associationsDo: [ :assoc |
        (anInteger = assoc value) ifTrue: [
            aName isNil
                ifTrue: [ aName := assoc key ]
                ifFalse: [
                    ^(aName size < assoc key size)     "answer short name"
                        ifTrue: [ aName ]
                        ifFalse: [ assoc key]]]].
    aName isNil
        ifTrue: [ self errorInMonth]
        ifFalse: [ ^aName ].! !

"WB Run Base Win32 (WB2ARBW.SLL)"!
!'DialogTopPane' osiMethods !  
buildWindow: aParentWindow
        "Private - Create the dialog window for the receiver."
    | result |
    style isNil ifTrue: [ style := self getStyle ].
    framingBlock isNil
        ifTrue: [
            rectangle := self initSize.
            framingBlock := rectangle ]
        ifFalse: [

            #modifiedByOSI.

            "Correctly handle the case when parent is nil."
            rectangle := parent isNil
                ifTrue: [ Display boundingBox ]
                ifFalse: [ parent rectangle ].

            "Return dialog units from framing parameters."
            rectangle :=
                framingBlock isFramingParameters
                    ifTrue: [ framingBlock valueToDU: rectangle ]
                    ifFalse: [ framingBlock value: rectangle ] ].

    NotificationManager newWindow: self.
    result := UserLibrary
        createDialogIndirect: OperatingSystem hInstanceExe
        dialogTemplate: ( WinDialogInfo dialogTemplateFor: self ) asParameter
        parent: parent asParameter
        dialogFunction: DialogProcInstance asParameter.
    NotificationManager newWindow: nil.
    result = 0 ifTrue: [ ^self osError ].
    handle := WindowHandle fromInteger: result.
    self
        receiveMessages;
        buildDialogItems.

    #modifiedByOSI.
    owner initWindow.

    PoppedModelessWindows add: handle.
    self isHidden ifFalse: [ self showWindow ].
    self sendDeferredEvent: #subclassRecursively! !

"WB Run EnhancedEntryField (WB2AREFW.SLL)"!
!'EnhancedEntryField' osiMethods !  
aboutToClose
        "Private - Check field validation before close. "
    self isReadOnly ifFalse: [
        ( self value ~= self previousValue ) ifTrue: [
            self validateField ifFalse: [
                self errorMessage ifTrue: [
                    self sendInputEvent: #contents: with: self contents.
                    self contents: self previousValue.
                    self topParent abortClose ] ] ] ].! !

"WB Run EnhancedEntryField (WB2AREFW.SLL)"!
!'EnhancedEntryField' osiMethods !  
centered
        "Set the receiver's text centered before the control is opened.
            Currently not supported under Windows."
    self justification: #centered.
    self removeStyle: EsRight.
    self addStyle: EsCenter.
    Smalltalk platformIsWin32 ifTrue: [ self addStyle: EsMultiline ].
    ^self style.! !

"WB Run EnhancedEntryField (WB2AREFW.SLL)"!
!'EnhancedEntryField' osiMethods !  
close
        "Private - Close the receiver."
    self topParent removeAllActionsWithReceiver: self.
    ^super close! !

"WB Run EnhancedEntryField (WB2AREFW.SLL)"!
!'EnhancedEntryField' osiMethods !  
errorMessage
        "Private - Report an error to the user."
    | focusPane |
    [ Notifier isButton1Down | Notifier isButton2Down ] whileTrue: [ ].
    focusPane := Notifier getFocusWindow.
    (MessageBox confirm: 'Invalid Input. Retry?')
        ifTrue: [
            self sendInputEvent: #setFocus.
            self subPaneWithFocus: self.
            ^true ].
    focusPane notNil
        ifTrue: [
            focusPane setFocus ].
    ^false! !

"WB Run EnhancedEntryField (WB2AREFW.SLL)"!
!'EnhancedEntryField' osiMethods !  
left
        "Set the receiver's text to the left before the control is opened."
    self justification: #left.
    self removeStyle: EsRight.
    self removeStyle: EsCenter.
    Smalltalk platformIsWin32 ifTrue: [ self removeStyle: EsMultiline ].! !

"WB Run EnhancedEntryField (WB2AREFW.SLL)"!
!'EnhancedEntryField' osiMethods !  
ok20Comma10: aChar

    "Validates whether aChar is a acceptable
        character for a Positive Integer"
    "Courtesy of Cargill"

    ^self
            okFixed: aChar
            leading: 20
            trailing: 10! !

"WB Run EnhancedEntryField (WB2AREFW.SLL)"!
!'EnhancedEntryField' osiMethods !  
ok7Comma2: aChar

    "Validates whether aChar is a acceptable
        character for a Positive Integer"
    "Courtesy of Cargill"

   aChar == $-
        ifTrue: [^false].
    ^self
            okFixed: aChar
            leading: 7
            trailing: 2! !

"WB Run EnhancedEntryField (WB2AREFW.SLL)"!
!'EnhancedEntryField' osiMethods !  
ok7Comma4: aChar

    "Validates whether aChar is a acceptable
        character for a Positive Integer"
    "Courtesy of Cargill"

    ^self
            okFixed: aChar
            leading: 7
            trailing: 4! !

"WB Run EnhancedEntryField (WB2AREFW.SLL)"!
!'EnhancedEntryField' osiMethods !  
okFixed: aChar
leading: leadingInteger
trailing: trailingInteger

    "Private -  is the char valid for the fixed decimal designation"
    "Courtesy of Cargill"

    | aDecimal tmpContents anIndex pos sel |
    tmpContents := self contents.
    pos := self getSelection x.
    sel := self getSelection y - pos.
    aDecimal := tmpContents
        detect:
            [:each |
            each == $.]
        ifNone:
            [aChar = $.
                ifTrue:
                    [nil]
                ifFalse:
                    [tmpContents size = leadingInteger
                        ifTrue: [^false]]].
    aDecimal isNil
        ifFalse:
            [aChar == $.
                ifTrue:
                    [anIndex := tmpContents indexOf: aDecimal.
                    (anIndex between: pos and: self getSelection y)
                        ifTrue: [^true]]].
    (self okNumeric: aChar)
        ifFalse: [^false].
    aDecimal isNil
        ifFalse:
            [sel = -1
                ifTrue:
                    [anIndex := tmpContents indexOf: aDecimal.
                    ((anIndex = (leadingInteger + 1)) & (pos <= anIndex))
                        ifTrue: [^false].
                    (((tmpContents size - anIndex) = trailingInteger) & (pos > anIndex))
                        ifTrue: [^false]]].

    ^true! !

"WB Run EnhancedEntryField (WB2AREFW.SLL)"!
!'EnhancedEntryField' osiMethods !  
okInteger

    "Validates whether aChar is a acceptable character for a
         Integer in input string at position pos"
    "Courtesy of Cargill"

    | answer |
    self contents: (answer :=self contents asInteger printString).
    ^true ! !

"WB Run EnhancedEntryField (WB2AREFW.SLL)"!
!'EnhancedEntryField' osiMethods !  
okNumber

    "Validates whether aChar is a acceptable character for a
         Integer in input string at position pos"
    "Courtesy of Cargill"

    | answer |
    self contents: (answer :=self contents asFloat printString).
    ^true ! !

"WB Run EnhancedEntryField (WB2AREFW.SLL)"!
!'EnhancedEntryField' osiMethods !  
okPositive10Comma10: aChar
    "Validates whether aChar is a acceptable
        character for a Positive Integer"
    "Courtesy of Cargill"

   aChar == $-
        ifTrue: [^false].
    ^self
            okFixed: aChar
            leading: 10
            trailing: 10! !

"WB Run EnhancedEntryField (WB2AREFW.SLL)"!
!'EnhancedEntryField' osiMethods !  
okPositiveNumeric: aChar

    "Validates whether aChar is a acceptable character for a
         Number in input string at position pos"
    "Courtesy of Cargill"

    aChar == $-
        ifTrue: [^false].
     ^self okNumeric: aChar! !

"WB Run EnhancedEntryField (WB2AREFW.SLL)"!
!'EnhancedEntryField' osiMethods !  
right
        "Set the receiver's text to the right before the control is opened."
    self justification: #right.
    self addStyle: EsRight.
    Smalltalk platformIsWin32 ifTrue: [ self addStyle: EsMultiline ].
    ^self style.! !

"WB Run EnhancedEntryField (WB2AREFW.SLL)"!
!'EnhancedEntryField' osiMethods !  
validate
        "Private - The host window for the receiver was
         just created or recreated."
    super validate.
    self topParent when: #aboutToClose send: #aboutToClose to: self.! !

"WB Run EnhancedEntryField (WB20REF.SLL)"!
!'EnhancedEntryField class' osiMethods !  
okCharacterMethods
        "Answer a collection of character validation selectors."
    #osiHack.
    "Move this to development."
    ^((self methodDictionary keys select: [ :selector |
        (selector at: 1) = $o and: [
        (selector at: 2) = $k and: [
        (selector at: selector size) = $:]]])
            collect: [ :selector |
            selector asString copyFrom: 3 to: selector size - 1])  asSortedCollection! !

"WB Run EnhancedEntryField (WB20REF.SLL)"!
!'EnhancedEntryField class' osiMethods !  
okFieldMethods
        "Answer a collection of field validation selectors."
    #osiHack.
    "Move this to development."
    ^((self methodDictionary keys select: [ :selector |
        (selector at: 1) = $o and: [
        (selector at: 2) = $k and: [
        (selector at: selector size) ~= $:]]])
            collect: [ :selector |
            selector asString copyFrom: 3 to: selector size ]) asSortedCollection! !

"WB Run CompositePane Win32"!
!'EntryFieldGroup' osiMethods !  
textChanged: aString pane: aPane
        "Private"
    self contents at: aPane paneName put: aString.
    self event: #textChanged. "Obsolete"
    self triggerEvent: #textChanged:pane: with: aString with: aPane.! !

"WB Run CompositePane Win32"!
!'EntryFieldGroup class' osiMethods !  
constructEventsTriggered
        "Private - answer the set of events that instances of the
        receiver can trigger."
    ^super constructEventsTriggered
        add: #textChanged:pane:;
        yourself! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'File class' osiMethods !  
findOrPromptFileName: fileName filters: filterCollection
       "Answer the full path of the file named fileName.
        filterCollection is a collection of associations whose
        keys are the filter (e.g. '*.*') and values are the filter
        descriptions (e.g. 'All files (*.*)')."

    #addedByOSI.
    ^self
        findOrPromptFileName: fileName
        filters: filterCollection
        in: #( )! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'File class' osiMethods !  
findOrPromptFileName: fileName filters: filterCollection in: aCollectionOfDir
       "Answer the full path of the file named fileName.
       Searching in aCollectionOfDir first, then the current search path,
        then prompt the user.  If the user specifies a directory that is not
        in aCollectionOfDir, then add that directory to aCollectionOfDir.
        filterCollection is a collection of associations whose
        keys are the filter (e.g. '*.*') and values are the filter
        descriptions (e.g. 'All files (*.*)')."

    | dialog answer defFilter allFilters |
    #addedByOSI.
    aCollectionOfDir do: [ :each |
        answer := each drivePathName, '\', fileName.
        (self exists: answer) ifTrue: [ ^answer ] ].
    (answer := self findFileName: fileName) notNil ifTrue: [ ^answer ].

    (defFilter := '*.', fileName fileExtension trimBlanks)
        = '*.' ifTrue: [ defFilter := '*.*' ].
    allFilters := OrderedCollection new
        addAll: filterCollection;
        yourself.
    allFilters
        detect: [ :assoc | assoc key = '*.*' ]
        ifNone: [ allFilters add: '*.*' => 'All files (*.*)' ].
    allFilters
        detect: [ :assoc | assoc key = defFilter ]
        ifNone: [ allFilters add: defFilter => ('Related files (', defFilter, ')') ].
    
    dialog := FileDialog new
        title: 'Where is "', fileName, '" ?';
        fileSpec: fileName;
        hideReadonly.
    allFilters do: [ :assoc |
        dialog addFilter: assoc key description: assoc value ].
    dialog
        defFilter: defFilter;
        open.

    (answer := dialog file) notNil ifTrue: [
        (self exists: answer) ifFalse: [
            MessageBox message: '"', answer fileNameLessPath, '" does not exist'.
            answer := nil ] ].
    ^answer! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'File class' osiMethods !  
findOrPromptFileName: fileName in: aCollectionOfDir
        "Answer the full path of the file named fileName.
        Searching in aCollectionOfDir first, then the current search path,
         then prompt the user.  If the user specifies a directory that is not
         in aCollectionOfDir, then add that directory to aCollectionOfDir."

    #addedByOSI.
    ^self
        findOrPromptFileName: fileName
        filters: #( )
        in: aCollectionOfDir! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'FramingParameters' osiMethods !  
bDU: y r: aSymbol
    "Private"

    bottom := (y * self dialogUnitHeight) rounded.
    aSymbol == #center ifFalse: [ bottom := bottom abs ].
    bottomRel := aSymbol.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'FramingParameters' osiMethods !  
bottomDialogUnits
        "Private - Answer the bottom dialog units"
    ^(bottom / self dialogUnitHeight) rounded! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'FramingParameters' osiMethods !  
cRDU
    "Private"

    ^(self clientRect leftTop / self dialogUnit) rounded
        rightBottom:
            (self clientRect rightBottom / self dialogUnit) rounded.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'FramingParameters' osiMethods !  
cRDU: aRect
    "Private"

    | newRect |

    #osiHack.
    "########## Fixes bug regarding system incompatible client rects in OS/2
    aRect bottom >= 10 ifTrue: [
        newRect := aRect left @ (aRect top - (aRect bottom - 14)) rightBottom: aRect right @ 8.
    ] ifFalse: [
        newRect := aRect.
    ].
    ################################################"

    #osiHack.
    "Should #rightBottom: be changed to rightTop: ?"
    "Something seems incorrect in this equation."
    newRect :=
        (aRect leftBottom * self dialogUnit) rounded
            rightBottom: (aRect rightTop * self dialogUnit) rounded.

    self clientRect: newRect.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'FramingParameters' osiMethods !  
dialogUnit
        "Private - Answer the receiver's dialog units."
    ^self dialogUnitWidth @ self dialogUnitHeight! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'FramingParameters' osiMethods !  
dialogUnitHeight
        "Private - Answer the receiver's dialog unit height."
    ^duHeight ifNil: [
        "If nil then assume old dialog units."
        duHeight := self class oldDialogUnitHeight ]! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'FramingParameters' osiMethods !  
dialogUnitWidth
        "Private - Answer the receiver's dialog unit width."
    ^duWidth ifNil: [
        "If nil then assume old dialog units."
        duWidth := self class oldDialogUnitWidth ]! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'FramingParameters' osiMethods !  
iDUE
    "Private"

    ^(initialExtent / self dialogUnit ) rounded! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'FramingParameters' osiMethods !  
iDUE: e
    "Private"

    initialExtent := (e * self dialogUnit) rounded.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'FramingParameters' osiMethods !  
initialize
        "Private - Initialize the receiver with dialog units."
    centerX := false.
    centerY := false.
    indent := 0@0.
    initialExtent := 0@0.
    duWidth := self class dialogUnitWidth.
    duHeight := self class dialogUnitHeight.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'FramingParameters' osiMethods !  
lDU: x r: aSymbol
    "Private"

    left := (x * self dialogUnitWidth) rounded.
    aSymbol == #center ifFalse: [ left := left abs ].
    leftRel  := aSymbol.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'FramingParameters' osiMethods !  
leftDialogUnits
    "Private"

    ^(left / self dialogUnitWidth) rounded! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'FramingParameters' osiMethods !  
rDU: x r: aSymbol
    "Private"

    right := (x * self dialogUnitWidth) rounded.
    aSymbol == #center ifFalse: [ right := right abs ].
    rightRel := aSymbol.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'FramingParameters' osiMethods !  
rightDialogUnits
    "Private"

    ^(right / self dialogUnitWidth) rounded! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'FramingParameters' osiMethods !  
tDU: y r: aSymbol
    "Private"

    top := (y * self dialogUnitHeight) rounded.
    aSymbol == #center ifFalse: [ top := top abs ].
    topRel := aSymbol.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'FramingParameters' osiMethods !  
topDialogUnits
    "Private"

    ^(top / self dialogUnitHeight) rounded! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'FramingParameters' osiMethods !  
valueDU: containerRect
        "Answer a rectangle based on self's framing parameters
         with a parent rectangle containerRect."

    ^self valueToDU: (
        (containerRect leftTop * FramingParameters newDialogUnit) rounded
            rightBottom:
                (containerRect rightBottom * FramingParameters newDialogUnit) rounded )! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'FramingParameters' osiMethods !  
valueToDU: containerRect
        "Answer a rectangle based on self's framing parameters
         with a parent rectangle containerRect."

    | answer |
    answer := self value: containerRect.
    ^(answer leftTop / FramingParameters newDialogUnit) rounded
        rightBottom:
            (answer rightBottom / FramingParameters newDialogUnit) rounded! !

"WB Run Base Common"!
!'FramingParameters class' osiMethods !  
dialogUnitHeight

    ^SysFont height / 32! !

"WB Run Base Common"!
!'FramingParameters class' osiMethods !  
dialogUnitWidth

    ^SysFont width  / 16! !

"WB Run Base Common"!
!'FramingParameters class' osiMethods !  
newDialogUnitHeight

    ^WindowDialog dialogUnit y / 8! !

"WB Run Base Common"!
!'FramingParameters class' osiMethods !  
newDialogUnitWidth

    ^WindowDialog dialogUnit x  / 4! !

"WB Run Base Win32 (WB2ARBW.SLL)"!
!'FramingParameters class' osiMethods !  
oldDialogUnitHeight

    ^SysFont height / 32! !

"WB Run Base Win32 (WB2ARBW.SLL)"!
!'FramingParameters class' osiMethods !  
oldDialogUnitWidth

    ^SysFont width / 16! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'GroupBox' osiMethods !  
addClipsiblingsStyle
        "Ignore this"
    #addedByOSI.! !

"WB Run CompositePane Common (WB2ARCPW.SLL)"!
!'GroupPane' osiMethods !  
addSubpanesForWBParts
        "Add the subpanes for parts."
        "For PARTS Support."
    #addedByOSI.
    self addSubpanes.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'LargePositiveInteger' osiMethods !  
highHalf

    " ** Added by Objectshare ** "
    "Answer the high half of the receiver."

    #addedByOSI.
    ^(ExternalLong fromInteger: self) highHalf! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'LargePositiveInteger' osiMethods !  
lowHalf

    " ** Added by Objectshare ** "
    "Answer the low half of the receiver."

    #addedByOSI.
    ^(ExternalLong fromInteger: self) lowHalf! !

"WB Run Base Common"!
!'Menu' osiMethods !  
insertItemDynamically: string selector: aSelector atIndex: index
    "Added by OSI"
    | mi |
    #addedByOSI.
    self insertItem: string
        selector: aSelector
        accelKey: nil
        accelBits: nil
        after: index.
    (mi := self getMenuItem: string)
        id: (self menuItem id - 1) + items size.
    window
        insertItem: mi
        label: string.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'Menu' osiMethods !  
removeAllItemsDynamically
        "Delete all menu items."
    #addedByOSI.
     self deleteAll.

     "#### Old Code ####
    items reverseDo: [ :item |
        self removeItemDynamically: item contents ].
    items := OrderedCollection new.
    accel := OrderedCollection new.
     ################"! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'Menu' osiMethods !  
removeItemDynamically: string

    "Added by OSI"

    | pos mi |

    #addedByOSI.
    mi := (items select: [:i | i label = string]) first.
    pos := items indexOf: mi.
    items removeIndex: pos.
    accel removeIndex: pos.
    window notNil ifTrue: [
        window deleteItem: mi ].

    "##### Old Code #####
    UserLibrary
        deleteMenu: window asParameter
        position:  pos - 1
        flag: MfByposition.
    ##### ##### #####"! !

"WB Run Base Win32 (WB2ARBW.SLL)"!
!'Menu' osiMethods !  
selectorOf: id
        "Private - Answer the selector for the item whose id is id."
        "Modified by OSI to prevent walkback when id is out of bounds."
    #modifiedByOSI.
    (id \\ 256 between: 1 and: items size) ifFalse: [ ^nil ].
    ^( items at: ( id \\ 256 ) ) selector! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'Object' osiMethods !  
=> anObject
        "Answer a new instance of an Association
        with key the receiver and value anObject."

    "** Courtesy OTI (added)"

    #addedByOSI.
    ^Association key: self value: anObject! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'Object' osiMethods !  
isPARTSInstalled
        "Answer true if PARTS is installed in the image."
    #addedByOSI.
    ^Smalltalk includesKey: #PARTSApplication! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'Object' osiMethods !  
wbPreOldVersionSupport
        "Private - Support old versions of WB."
    #addedByOSI.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'Object' osiMethods !  
wbUnlinkPartEvents
        "Private - Unlink the parts events from the subpanes to the receiver."
    #addedByOSI.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'Object' osiMethods !  
wbUnlinkPartMessages
        "Private - Unlink the parts messages from the subpanes to the receiver."
    #addedByOSI.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'Pen' osiMethods !  
draw3DRect: aRect
depth: depth
style: style
    "Added by OSI"

    | back fore l r t b |

    #addedByOSI.
    style == #outline
        ifTrue:
            [^self
                foreColor: Color white;
                drawRectangle: (Rectangle leftTop: (aRect leftTop rightAndDown: 1) rightBottom:
aRect rightBottom);
                foreColor: Color buttonShadow;
                lineFrom: (aRect leftTop down: 1) to: aRect leftBottom;
                lineFrom: (aRect leftTop down: 1) to: (aRect rightTop down: 1);
                lineFrom: (aRect rightBottom leftAndUp: 2 @ 1) to: (aRect left right: 2) @ (aRect
bottom up: 1);
                lineFrom: (aRect rightBottom leftAndUp: 2) to: (aRect right left: 2) @ (aRect top
down: 3)].
    style = #in
        ifTrue:
            [back := Color white.
            fore := Color buttonShadow.
            ]
        ifFalse:
            [back := Color buttonShadow.
            fore := Color white.
            ].
    1 to: depth
        do:
            [:i |
            l := aRect left right: i.
            r := aRect right left: i + 1.
            t := aRect top down: i + Rectangle leftTopUnit y.
            b := aRect bottom up: i + Rectangle rightBottomUnit y.
            self
                foreColor: back;
                lineFrom: l @ b to: r @ b;
                lineFrom: r @ t to: r @ b;
                foreColor: fore;
                lineFrom: l @ t to: l @ b;
                lineFrom: l @ t to: r @ t.
            ].! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'Pen' osiMethods !  
draw3DRect: aRect leftTopColor: aLeftTopColor rightBottomColor: aRightBottomColor

    "Added by OSI"
    | theHandle leftRight1 leftRight2 rightLeft2 rightLeft3
    topDown1 topDown2 bottomUp2 bottomUp3 oldColor |
    #addedByOSI.
    theHandle := self handle.
    leftRight1 := aRect left right: 1.
    leftRight2 := aRect left right: 2.
    rightLeft2 := aRect right left: 2.
    rightLeft3 := aRect right left: 3.
    topDown1 := aRect top down: 1 + Rectangle leftTopUnit y.
    topDown2 := topDown1 down: 1.
    bottomUp2 := aRect bottom up: 1 + Rectangle rightBottomUnit y.
    bottomUp3 := bottomUp2 up: 1.
    oldColor := self foreColor.

    self
        foreColor: aLeftTopColor;
        quickLineFrom: leftRight1 @ topDown1 to: rightLeft2 @ topDown1 using: theHandle;
        "quickLineFrom: leftRight1 @ topDown2 to: rightLeft3 @ topDown2 using: theHandle;"
        quickLineFrom: leftRight1 @ topDown1 to: leftRight1 @ bottomUp2 using: theHandle;
        "quickLineFrom: leftRight2 @ topDown1 to: leftRight2 @ bottomUp3 using: theHandle;"
        foreColor: aRightBottomColor;
        quickLineFrom: leftRight1 @ bottomUp2 to: (aRect right left: 1) @ bottomUp2 using: theHandle;
        "quickLineFrom: leftRight2 @ bottomUp3 to: rightLeft2 @ bottomUp3 using: theHandle;"
        quickLineFrom: rightLeft2 @ topDown1 to: rightLeft2 @ (aRect bottom up: 1) using: theHandle;
        "quickLineFrom: rightLeft3 @ topDown2 to: rightLeft3 @ bottomUp2 using: theHandle;"
        foreColor: oldColor.! !

"WB Run Base Common"!
!'Pen' osiMethods !  
drawRect3DLight: aRect
         "Private - WBPro Development."
    #addedByOSI.
    self
        foreColor: Color buttonHighlight;
        lineFrom: (aRect left @ (aRect top down: 1)) to: ((aRect right left: 1) @ (aRect top down: 1));
        lineFrom: ((aRect left right: 1) @ (aRect top down: 1)) to: ((aRect left right: 1)@ (aRect bottom up: 1));
        foreColor: Color buttonShadow;
        lineFrom: (aRect left right: 1) @ (aRect bottom up: 2) to: (aRect rightBottom leftAndUp: 1@2);
        lineFrom: (aRect left right: 2) @ (aRect bottom up: 3) to: ((aRect right left: 1) @ (aRect bottom up: 3));
        lineFrom: (aRect right left: 2) @ (aRect top down: 1) to: (aRect rightBottom leftAndUp: 2@1);
        lineFrom: (aRect right left: 3) @ (aRect top down: 2) to: (aRect right left: 3) @ (aRect bottom up: 1).! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'RadioButton' osiMethods !  
notifyClicked: aParameter
        "Private - the host signaled a clicked event."
    #addedByOSI.
    super notifyClicked: aParameter.
    self selection: true.! !

"WB Run Status Pane Win32 (WB2ARSTW.SLL)"!
!'StatusPane' osiMethods !  
height: anInteger
        "Set the receiver's height."
        "Modified by OSI to fix StatusPane height in Dialogs."
    | font fontSize |
    #modifiedByOSI.
    self framingBlock: [ :box |
        Rectangle leftBottom: box leftBottom extent: box width @ (
            anInteger // (self superWindow isDialog
                ifTrue: [(WindowDialog dialogUnit / WindowDialog unitMultiplier) y]
                ifFalse: [1]))  ].
    fontSize := 0 @ ( anInteger - ( 2 * inset ) ).
    fontSize := fontSize - ( 0 @ ( fontSize y // 3 ) ).  "account for some descender"
    font := Font face: self class defaultFontName size: fontSize fixedWidth: false.
    self font: font! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'SubPane' osiMethods !  
basicKeyboardInput: aKeyboardInputEvent
        "Private - keyboard input was received."
        "Provide support for Escape key"
        "Provide Enter key support for all WB windows including Dialogs."
    | button |
    #modifiedByOSI.
    self owner isWBWindow ifTrue: [
        aKeyboardInputEvent virtualKey == EscapeKey ifTrue: [
            (button := self mainWindow cancelPushButton ) notNil ifTrue: [
                button disabled not ifTrue: [
                    button click ]]].
        "aKeyboardInputEvent character == Cr ifTrue: [
            (button := self mainWindow defaultPushButton) notNil ifTrue: [
                button disabled not ifTrue: [
                    button click ]]]"].
    ^super basicKeyboardInput: aKeyboardInputEvent! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'SubPane' osiMethods !  
contents
    "Added by OSI to speed dialog opening"
    #addedByOSI.
    ^nil! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'SubPane' osiMethods !  
dragTargetFormats
        "Private - answer the formats of drag objects that the receiver will accept."
    #addedByOSI.
    ^super dragTargetFormats ifNil: [ self dragTargetFormatsDefault ]! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'SubPane' osiMethods !  
dragTargetFormatsDefault
        "Private - answer the formats of drag objects that the receiver will accept."
    #addedByOSI.
    ^nil! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'SubPane' osiMethods !  
dragTargetOperations
        "Private - answer the operations that the receiver can accept."
    #addedByOSI.
    ^super dragTargetOperations ifNil: [ self dragTargetOperationsDefault ]! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'SubPane' osiMethods !  
dragTargetOperationsDefault
        "Private - answer the operations that the receiver can accept."
    #addedByOSI.
    ^nil! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'SubPane' osiMethods !  
tabStop
        "Make the dialog item receive the focus when the user
        presses the TAB key.  By default every subpane which
        can be a tabstop is a tabstop"
        "Modified by OSI to store false rather than nil."
    #modifiedByOSI.
    self
        propertyAt: #noTabStop put: false;
        addStyle: WsTabstop.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'Time' osiMethods !  
asTime
    "Answer the receiver as an instance of Time."

    #addedByOSI.
    ^self! !

"WB Run Base Win32 (WB2ARBW.SLL)"!
!'TopPane' osiMethods !  
setOwner: aWindow
      "Set the receiver's owner and parent."
    #addedByOSI.
    self propertyAt: #wbOwner put: aWindow.! !

"WB Run Base Win32 (WB2ARBW.SLL)"!
!'TopPane' osiMethods !  
wbOwner
        "Answer the window builder owner."
    #addedByOSI.
    ^self propertyAt: #wbOwner! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'ViewManager' osiMethods !  
centeredOnMouse
    "Added by OSI - Open the receiver centered over the mouse.
     Call this method from within #preInitWindow"
    | framingBlock mousePos initialExtent |
    #addedByOSI.
    mousePos := CursorManager cursorPosition.
    framingBlock := self mainView framingBlock.
    initialExtent := framingBlock initialExtent.
    framingBlock
        centerX: false; centerY: false;
        left: (((mousePos x left: framingBlock initialExtent x // 2) max: 0) min: (Display width - initialExtent x))
        relativeTo: #left;
        top: (((Display boundingBox top distanceDown: (mousePos y up: framingBlock initialExtent y // 2)) max: 0) min: (Display height - initialExtent y))
        relativeTo: #top.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'ViewManager' osiMethods !  
centeredOnScreen
    "Added by OSI - Open the receiver centered on the screen.
     Call this method from within #preInitWindow"
    | framingBlock center initialExtent |
    #addedByOSI.
    center := Display extent // 2.
    framingBlock := self mainView framingBlock.
    initialExtent := framingBlock initialExtent.
    framingBlock
        centerX: false; centerY: false;
        left: (((center x left: framingBlock initialExtent x // 2) max: 0) min: (Display width - initialExtent x))
        relativeTo: #left;
        top: (((Display boundingBox top distanceDown: (center y up: framingBlock initialExtent y // 2)) max: 0) min: (Display height - initialExtent y))
        relativeTo: #top.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'ViewManager' osiMethods !  
close
        "Close all the views.
            For PARTS support, close views only once."
    #modifiedByOSI.
    self isWBWindow
        ifFalse: [
            views do: [:v | v close ] ]
        ifTrue: [
            views do: [:v |
                v isHandleOk ifTrue: [
                    v close ] ].
            self initializeAgain ].! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'ViewManager' osiMethods !  
createViewsOnce
        "Create the views only if not already created.
            For PARTS support."
    #addedByOSI.
    views notEmpty ifTrue: [ ^self ].
    ^self createViews! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'ViewManager' osiMethods !  
initializeAgain
        "Private - Initialize the receiver after a close.
            For PARTS support."
    #addedByOSI.
    views removeAll.
    self
        wbUnlinkPartEvents;
        wbUnlinkPartMessages.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'ViewManager' osiMethods !  
open
    "Added by OSI - Open the receiver."
    | newInstance |
    self wbPreOldVersionSupport.
    newInstance := self createViewsOnce.
    newInstance notNil ifTrue: [
        newInstance openViewsOnce.
    ] ifFalse: [
        #addedByOSI.
        MessageBox message:
            self class name,' does not have a #createViews method or its own #open method.'
    ].
    ^newInstance! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'ViewManager' osiMethods !  
openAsMDIParent
    "Added by OSI - Open the receiver as an
     MDI parent window."
    | newInstance |
    (Smalltalk includesKey: #MDIChild) ifFalse: [
        MessageBox message: 'Cannot open ',self class name,
            ' because the MDI support is not installed.'.
        ^nil
    ].
    self wbPreOldVersionSupport.
    newInstance := self
        execute: [ self createViews ]
        withTopPane: #MDIFrame.
    newInstance notNil ifTrue: [
        (newInstance menuWindow menus isEmpty and: [
        (newInstance mainView handlesEvent: #menuBuilt) not ]) ifTrue: [
            newInstance menuWindow addMenu:
                (Menu new title: '&MDI'; owner: self; yourself)
        ].
        newInstance openViews.
    ] ifFalse: [
        #addedByOSI.
        MessageBox message:
            self class name,' does not have a #createViews method or its own #open method.'
    ].
    ^newInstance! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'ViewManager' osiMethods !  
openCenteredOnMouse
    "Added by OSI - Open the receiver centered over the mouse."
    | newInstance framingBlock mousePos |
    self wbPreOldVersionSupport.
    newInstance := self createViews.
    newInstance notNil ifTrue: [
        newInstance
            centeredOnMouse;
            openViews.
    ] ifFalse: [
        #addedByOSI.
        MessageBox message:
            self class name,' does not have a #createViews method or its own #open method.'
    ].
    ^newInstance! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'ViewManager' osiMethods !  
openCenteredOnScreen
    "Added by OSI - Open the receiver centered over the mouse."
    | newInstance framingBlock mousePos |
    self wbPreOldVersionSupport.
    newInstance := self createViews.
    newInstance notNil ifTrue: [
        newInstance
            centeredOnScreen;
            openViews.
    ] ifFalse: [
        #addedByOSI.
        MessageBox message:
            self class name,' does not have a #createViews method or its own #open method.'
    ].
    ^newInstance! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'ViewManager' osiMethods !  
openRelativeTo: aViewManager offset: aPoint
    "Added by OSI - Open the receiver relative to <aViewManager>."
    | newInstance framingBlock mousePos |
    self wbPreOldVersionSupport.
    newInstance := self createViews.
    newInstance notNil ifTrue: [
        newInstance
            positionRelativeTo: aViewManager offset: aPoint;
            openViews.
    ] ifFalse: [
        #addedByOSI.
        MessageBox message:
            self class name,' does not have a #createViews method or its own #open method.'
    ].
    ^newInstance! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'ViewManager' osiMethods !  
openViewsOnce
        "Open the window once.
            For PARTS support."
    #addedByOSI.
    self mainView isHandleOk
        ifTrue: [ self mainView bringToTop ]
        ifFalse: [ self openViews ].! !

"WB Run Base Win32 (WB2ARBW.SLL)"!
!'ViewManager' osiMethods !  
openViewsWithOwner: aViewManager
      "Added by OSI"
    #addedByOSI.
    self
        parent: aViewManager;
        openViews;
        setOwner: aViewManager.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'ViewManager' osiMethods !  
openWithMDIParent: aViewManager
    "Added by OSI - Open the receiver with aViewManager as an MDI Parent."
    | newInstance frame |
    (Smalltalk includesKey: #MDIChild) ifFalse: [
        MessageBox message: 'Cannot open ',self class name,
            ' because the MDI support is not installed.'.
        ^nil
    ].
    ((aViewManager respondsTo: #frame)
        and: [ (frame := aViewManager frame) notNil ]
    ) ifFalse: [
        MessageBox message: 'Cannot open ',self class name,
            ' because the parent window does not have an MDI Frame.'.
        ^nil
    ].
    self wbPreOldVersionSupport.
    newInstance := self
        execute: [ self createViews ]
        withTopPane: #MDIChild.
    newInstance notNil ifTrue: [
        self views do: [ :view |
            view frame: frame.
        ].
        newInstance openViews.
    ] ifFalse: [
        #addedByOSI.
        MessageBox message:
            self class name,' does not have a #createViews method.'
    ].
    ^newInstance! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'ViewManager' osiMethods !  
openWithMyParent: aViewManager
    "Added by OSI - Open a the receiver as a child of
     aViewManager's parent (a sibling)."
    aViewManager mainView wbOwner isNil ifTrue: [
        #addedByOSI.
        ^self open
    ] ifFalse: [
        ^self openWithParent: aViewManager mainView wbOwner
    ]! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'ViewManager' osiMethods !  
openWithOwner: aViewManager
    "Added by OSI - Open the receiver with aViewManager as owner of
    all the subpanes (the target of the #when:perform: messages). This
    method can only be used in conjunction with the 'Power Views' Add-In."
    | newInstance |
    newInstance := self createViewsFor: self owner: aViewManager.
    newInstance notNil ifTrue: [
        newInstance openViews; setOwner: aViewManager.
    ] ifFalse: [
        #addedByOSI.
        MessageBox message:
            self class name,' does not have a #createViewsFor:owner: method.'
    ].
    ^newInstance! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'ViewManager' osiMethods !  
openWithOwnerParent: aViewManager
    "Added by OSI - Open the receiver with aViewManager as Parent
    and owner of all the subpanes. This method can only be used in
    conjunction with the 'Power Views' Add-In."
    | newInstance |
    newInstance := self createViewsFor: self owner: aViewManager.
    newInstance notNil ifTrue: [
        newInstance openViewsWithOwner: aViewManager.
    ] ifFalse: [
        #addedByOSI.
        MessageBox message:
            self class name,' does not have a #createViewsFor:owner: method.'
    ].
    ^newInstance! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'ViewManager' osiMethods !  
openWithParent: aViewManager
    "Added by OSI - Open the receiver with aViewManager as Parent."
    | newInstance |
    self wbPreOldVersionSupport.
    newInstance := self createViews.
    newInstance notNil ifTrue: [
        newInstance openViewsWithOwner: aViewManager.
    ] ifFalse: [
        #addedByOSI.
        MessageBox message:
            self class name,' does not have a #createViews method.'
    ].
    ^newInstance! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'ViewManager' osiMethods !  
positionRelativeTo: aViewManager offset: aPoint
    "Added by OSI - Open the receiver relative to <aViewmanager>.
     Call this method from within #preInitWindow"
    | framingBlock leftTop initialExtent |
    #addedByOSI.
    leftTop := aViewManager mainView frameRectangle leftTop.
    framingBlock := self mainView framingBlock.
    initialExtent := framingBlock initialExtent.
    framingBlock
        centerX: false; centerY: false;
        left: (((leftTop x right: aPoint x) max: 0) min: (Display width - initialExtent x))
        relativeTo: #left;
        top: (((Display boundingBox top distanceDown: (leftTop y down: aPoint y)) max: 0) min: (Display height - initialExtent y))
        relativeTo: #top.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'ViewManager' osiMethods !  
setOwner: aWindow

    "Added by OSI"
    #addedByOSI.
    self mainView setOwner: aWindow! !

"WB Run Parts (WB2ARPW.SLL)"!
!'ViewManager' osiMethods: 'WBPARTSInterfaceList' !  
wbPartEvents

        "WARNING!! This method was automatically generated by 
        WindowBuilder. Code you add here which does not conform to 
        the WindowBuilder API will probably be lost the next time 
        you save your wb-parts definition."

    ^WBPARTSEventList new
        items: self class wbPartEventItems
        separators: #( )
        defaultItem: nil;
        addWbItem: (
            WBPartEvent
                sourceName: 'mainView'
                sourceSelector: #aboutToClose
                receiver: self
                triggeredEvent: #aboutToClose );
        addWbItem: (
            WBPartEvent
                sourceName: 'mainView'
                sourceSelector: #closed
                receiver: self
                triggeredEvent: #closed );
        addWbItem: (
            WBPartEvent
                sourceName: 'mainView'
                sourceSelector: #opened
                receiver: self
                triggeredEvent: #opened );
        yourself! !

"WB Run Parts (WB2ARPW.SLL)"!
!'ViewManager' osiMethods: 'WBPARTSInterfaceList' !  
wbPartMessages

        "WARNING!! This method was automatically generated by 
        WindowBuilder. Code you add here which does not conform to 
        the WindowBuilder API will probably be lost the next time 
        you save your wb-parts definition."

    ^WBPARTSMessageList new
        items: #(abortClose close open openCenteredOnMouse openRelativeTo:offset: openWithParent: yourself)
        separators: #( )
        defaultItem: #open;
        addWbItem: (
            WBPartMessage
                source: self
                sourceSelector: #abortClose
                receiverName: 'mainView'
                selector: #abortClose );
        yourself! !

"WB Run Parts (WB2ARPW.SLL)"!
!'ViewManager' osiMethods: 'WBPARTSInterfaceList' !  
wbUnlinkPartEvents
        "Private - Unlink the parts events from the subpanes to the receiver."
    #addedByOSI.
    WBPartEvent.
    self isWBWindow ifTrue: [
        self partEvents wbItems do: [ :each |
            each wbUnlinkPartEvent ] ].! !

"WB Run Parts (WB2ARPW.SLL)"!
!'ViewManager' osiMethods: 'WBPARTSInterfaceList' !  
wbUnlinkPartMessages
        "Private - Unlink the parts messages from the subpanes to the receiver."
    #addedByOSI.
    WBPartMessage.
    self isWBWindow ifTrue: [
        self partMessages wbItems do: [ :each |
            each wbUnlinkPartMessage ] ].! !

"WB Run Parts (WB2ARPW.SLL)"!
!'ViewManager class' osiMethods: 'WBPARTSInterfaceList' !  
wbPartEventItems

        "WARNING!! This method was automatically generated by 
        WindowBuilder. Code you add here which does not conform to 
        the WindowBuilder API will probably be lost the next time 
        you save your wb-parts definition."

    ^#(aboutToClose closed opened)! !

"WB Run BitmapManager (WB20RBM.SLL)"!
!'WBBitmapManager class' osiMethods !  
loadStandardWBBitmaps
        "Load the standard window builder user bitmaps."
    #osiHack.
    "Should break out file name into separate method or global."
    self current
        addBitmapsFromModule: (
            'wb20usr',
            (String with: Smalltalk platform first),
            '.dll' )
        idMap: self standardWBBitmapIDMap.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'WBComboBox' osiMethods !  
addDynamicListSizeStyle
        "Dynamically size the receiver's frame based on the
            number of elements in the receiver's list."
    isListSizeDynamic := true.! !

"WB Run Miscellaneous (WB20RM.SLL)"!
!'WBComboBox' osiMethods !  
buildList

    super contents: (fullList select: [ :el | (disabled includes: el) not ]).
    self selectIndex: value.! !

"WB Run Miscellaneous (WB20RM.SLL)"!
!'WBComboBox' osiMethods !  
contents

    ^fullList! !

"WB Run Miscellaneous (WB20RM.SLL)"!
!'WBComboBox' osiMethods !  
contents: aCollection

    disabled := Set new.
    fullList := aCollection.

    ^super contents: aCollection! !

"WB Run Miscellaneous (WB20RM.SLL)"!
!'WBComboBox' osiMethods !  
disableItem: anItem

    self getSelection.
    ((fullList indexOf: anItem) = value) ifTrue: [
        value := value + 1.
        (value > list size) ifTrue: [
            value := 1.
        ].
        self selectIndex: value.
    ].

    disabled add: anItem.

    self buildList.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'WBComboBox' osiMethods !  
dynamicListBottom
        "Answer the bottom coordinate of the dynamic list."
    ^(rectangle top down: self dynamicListHeight)
        higherOf:
            (Display boundingBox mapScreenToClient: self parent) bottom! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'WBComboBox' osiMethods !  
dynamicListHeight
        "Answer the dynamic list height."
    | ef |
    ^self dynamicListSize * self font height + 10 + (
        (ef := self entryField) notNil
            ifTrue: [ ef rectangle height ]
            ifFalse: [ self font height + 8 ] )! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'WBComboBox' osiMethods !  
dynamicListSize
        "Private - Answer the # of elements in the receiver's list."
    ^super contents size max: 3! !

"WB Run Miscellaneous (WB20RM.SLL)"!
!'WBComboBox' osiMethods !  
enableItem: anItem

    disabled remove: anItem ifAbsent: [].

    self buildList.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'WBComboBox' osiMethods !  
forkListHiddenWatcher
        "Private - OS/2 does not notify us when the the drop down list
            is hidden again, so fork a process to watch for the list being hidden."
    | done oldFrame |
    done := false.
    oldFrame := self rectangle.
    [	[	[	self isHandleOk
                    ifTrue: [
                        self isDropdownVisible ifFalse: [
                            oldFrame = self rectangle ifFalse: [
                                self superWindow invalidateRect: oldFrame ].
                            self resizeWithoutDropDownList.
                            done := true ] ]
                    ifFalse: [ done := true ].
            ] evaluateWithoutInterrupts.
            done
        ] whileFalse: [ Processor yield ].
    ] forkAt: self class forkListHiddenWatcherPriority.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'WBComboBox' osiMethods !  
hasDynamicListSizeStyle
        "Dynamically size the receiver's frame based on the
            number of elements in the receiver's list."
    ^isListSizeDynamic = true! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'WBComboBox' osiMethods !  
heightWithoutDropDownList
        "Answer the height of the receiver when the drop down list is hidden."
    ^self font height + 6! !

"WB Run Miscellaneous (WB20RM.SLL)"!
!'WBComboBox' osiMethods !  
initialize

    super initialize.
    disabled := Set new.
    fullList := list.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'WBComboBox' osiMethods !  
initSize: aRectangle
        "Private - Change the frame of the receiver pane
         to aRectangle."
    super initSize: aRectangle.
    self isSimpleList ifFalse: [
        rectangle := rectangle leftTop extentFromLeftTop:
            rectangle width @ self heightWithoutDropDownList ].! !

"WB Run Base Win32 (WB2ARBW.SLL)"!
!'WBComboBox' osiMethods !  
isDropdownVisible
        "Answer true if the drop down list is visible."
    ^isListVisible! !

"WB Run Base Win32 (WB2ARBW.SLL)"!
!'WBComboBox' osiMethods !  
notifyListHidden: aParameter
        "Private - the host signaled that the list was closed up."
    isListVisible := false.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'WBComboBox' osiMethods !  
notifyListVisible: aParameter
        "Private - the host signaled that the list was dropped down."
    self isSimpleList ifFalse: [
        self resizeWithDropDownList.
        self forkListHiddenWatcher ].
    super notifyListVisible: aParameter.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'WBComboBox' osiMethods !  
removeDynamicListSizeStyle
        "Do not dynamically size the receiver's frame based on the
            number of elements in the receiver's list."
    isListSizeDynamic := false.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'WBComboBox' osiMethods !  
resize: aRectangle
        "Private - Change the frame of the receiver pane
         to aRectangle."
    self isHandleOk ifFalse: [ ^nil ].
    self isSimpleList ifTrue: [ ^super resize: aRectangle ].
    self resizeWithoutDropDownList.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'WBComboBox' osiMethods !  
resizeWithDropDownList
        "Private - Resize the receiver to include the drop down list."
    isListVisible := true.
    rectangle := self framingRectangleFor: self parent rectangle.
    self hasDynamicListSizeStyle ifTrue: [
        rectangle := rectangle leftTop rightBottom: (
            rectangle right @ self dynamicListBottom ) ].
    rectangle extent: (rectangle extent max: 0@0).
    self resizeWindow.
! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'WBComboBox' osiMethods !  
resizeWithoutDropDownList
        "Private - Resize the receiver to exclude the drop down list."
    isListVisible := false.
    rectangle := self framingRectangleFor: self parent rectangle.
    rectangle := rectangle leftTop extentFromLeftTop:
        rectangle width @ (
            self heightWithoutDropDownList min: rectangle height ).
    rectangle extent: (rectangle extent max: 0@0).
    self resizeWindow.! !

"WB Run Miscellaneous (WB20RM.SLL)"!
!'WBComboBox' osiMethods !  
selectedItem
        "Answer the item selected in the receiver."
    ( self getSelection ) isNil
        ifTrue: [ ^nil ]
        ifFalse: [ ^list at: value ]! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'WBComboBox' osiMethods !  
selectItem: anObject
        "Private - Select the item anObject. anObject can
        be an index or a string."
    anObject isInteger
        ifTrue: [ self selectIndex: anObject ]
        ifFalse: [ self selectIndex: ( self indexOf: anObject ) ]! !

"WB Run Miscellaneous (WB20RM.SLL)"!
!'WBComboBox' osiMethods !  
setInitialContents
        "Private - set the receiver's contents and selection."
    self contents: list.
    value notNil ifTrue: [ self setSelection ]! !

"WB Run Base Win32 (WB2ARBW.SLL)"!
!'WBComboBox' osiMethods !  
syncControlEvent: anEvent with: aParameter
        "Private - Process anEvent produced
         by the host system. The default is to
         requeue the operation for deferred handling."

    anEvent = CbnDropdown ifTrue: [
        self resizeWithDropDownList.
        self sendInputEvent: #forkListHiddenWatcher.
        ^1 ].

    ^super syncControlEvent: anEvent with: aParameter! !

"WB Run Base Win32 (WB2ARBW.SLL)"!
!'WBComboBox class' osiMethods !  
constructNotifications
        "Private - answer the mapping between host control
        notification codes and corresponding Smalltalk event
        notifications."
    ^super constructNotifications
        at: CbnCloseup put: #notifyListHidden: ;
        yourself! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'WBComboBox class' osiMethods !  
forkListHiddenWatcherPriority
        "Answer the process priority for the watcher."
    ^Processor backgroundPriority! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'WBComboBox class' osiMethods !  
hasDynamicListSizeStyle
        "Answer the default value for the dynamic list size style."
    ^IsListSizeDynamicDefault = true! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'WBComboBox class' osiMethods !  
hasDynamicListSizeStyle: aBoolean
        "Set the default value for the dynamic list size style."
    IsListSizeDynamicDefault := aBoolean = true.! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'WBDialogTopPane' osiMethods !  
openModal: anOwner
        "Open the dialog box modal to the
         current active window."
    | cursor |

    Processor currentProcessIsRecursive ifTrue: [
        self error: 'Cannot do modal dialog during recursion.'].

    cursor := Cursor.
    CursorManager execute change.
    dialogOwner := anOwner ifNil: [ Notifier activeMainWindow ].

    "Disable parent now to ensure that there are no further activities at parent."
    dialogOwner isWindow ifTrue:[ dialogOwner disable ].
    self setOwner: dialogOwner.

    super openWindow.
    self event: #opened.
    CursorManager normal change.
    Processor currentProcessIsRecursive ifFalse: [ self processInput ].
    cursor change.! !

"WB Run CompositePane Common (WB2ARCPW.SLL)"!
!'WBEntryField' osiMethods !  
setContents: aString
        "Set the receiver's contents without triggering a textChanged event."
    self
        contents: aString;
        removeTextChangedEvent.! !

"WB Run Parts (WB2ARPW.SLL)"!
!'WBPartEvent' osiMethods: 'WBPARTSInterfaceList' !  
wbUnlinkPartEvent
        "Private - Link the source to the receiver."
    source := nil.! !

"WB Run Parts (WB2ARPW.SLL)"!
!'WBPartMessage' osiMethods: 'WBPARTSInterfaceList' !  
wbUnlinkPartMessage
        "Private - Link the source to the receiver."
    receiver := nil.! !

"WB Run Parts (WB2ARPW.SLL)"!
!'WBPARTSInterfaceList class' osiMethods: 'WBPARTSInterfaceList' !  
defaultIcon
        "Answer the window builder parts icon."
    ^Icon fromFile: (
        (File findFileName: self defaultIconFileName)
            ifNil: [ ^nil ] )! !

"WB Run Parts (WB2ARPW.SLL)"!
!'WBPARTSInterfaceList class' osiMethods: 'WBPARTSInterfaceList' !  
defaultIconFileName
        "Answer the window builder parts icon."
    ^'WB.ICO'! !

"WB Run ToolBar Common (WB2ARTBW.SLL)"!
!'WBToolBar' osiMethods !  
button2Down: aPoint
        "Private - Capture mouse input in preparation for
         right button scrolling."
    | index |

    ( self isLocalDragSource and: [ self isDragButton: 2 ] )
        ifTrue: [ self dragOnMove: true location: aPoint. ].

    index := self currentIndex.

    (self isEnabled: index) ifTrue: [
        self rbEventFor: index.
    ].! !

"WB Run ToolBar Common (WB2ARTBW.SLL)"!
!'WBToolBar' osiMethods !  
isMDISupportPane
        "Answer true if receiver is a support pane for MDI."
    ^self tpStyle == #mdiToolBar! !

"WB Run ToolBar Common (WB2ARTBW.SLL)"!
!'WBToolBar' osiMethods !  
rectForKey: key
        "Private"
    | element rect |
    key ifNil: [ ^0@0 extent: 0@0 ].
    element := self elementAt: key.
    element ifNil: [ ^self leftTop extentFromLeftTop: 1@1 ].
    element rectangle ifNil: [
        rect := self rectForKey: key - 1.
        element rectangle: ((self isVertical
            ifTrue: [rect leftBottom down: element numSpaces - 1]
            ifFalse: [rect rightTop right: element numSpaces - 1])
                extentFromLeftTop: self cellSize ) ].
    ^element rectangle! !

"WB Run ToolBar Common (WB2ARTBW.SLL)"!
!'WBToolPalette' osiMethods !  
button1Down: aPoint
        "Private - left button was pressed"
    | index |

    ( self isLocalDragSource and: [ self isDragButton: 1 ] )
        ifTrue: [ self dragOnMove: true location: aPoint ].

    index := self highlight: selection.
    self event: #gettingFocus.

    self captureMouseInput.
    Notifier consumeInputUntil: [:event |
        index := self highlight: index.
        #osiHack.
        "Code for drag/drop from tool bar."
        event selector = #button1Move: ifTrue: [
            ( self isLocalDragSource
                and: [ self dragOnMove
                    and: [ self isDragSourceInitiation: event arguments first ] ] )
                        ifTrue: [
                            "self clearMouseCapture."
                            self unHighlightBitmap: index.
                            ^self ] ].
        (event notNil and: [ event selector == #button1Up: ])
    ].
    self clearMouseCapture.

    (self isEnabled: index) ifTrue: [
        selection := index.
        self isPreAutomatic ifTrue: [self unHighlightBitmap: selection].
        self generateEventFor: selection.
        self eventFor: selection.
        self event: #select. "Obsolete"
        self triggerEvent: #clicked: with: self selector.
        self isPostAutomatic ifTrue: [self unHighlightBitmap: selection].
        self isAutomatic ifTrue: [ selection := nil ].
    ] ifFalse: [
        self highlightBitmap: selection.
    ].! !

"WB Run ToolBar Common (WB2ARTBW.SLL)"!
!'WBToolPalette' osiMethods !  
drawDisabledWith: aPen in: aRect
        "Private"
    | d |
    d := 2 @ (2 + Rectangle rightBottomUnit y).
    aPen
        setLineWidth: 1;
        foreColor: Color paleGray;
        backColor: Color paleGray;
        drawRectangle: (aRect insetBy: 1);
        lineFrom: (aRect leftBottom rightAndUp: d) to: (aRect rightBottom leftAndUp: d);
        lineFrom: (aRect rightTop leftAndDown: 3@2) to: (aRect rightBottom leftAndUp: 3@2).
! !

"WB Run ToolBar Common (WB2ARTBW.SLL)"!
!'WBToolPalette' osiMethods !  
rectForKey: key

    | element |
    element := self elementAt: key.
    element ifNil: [^0@0 extent: 0@0].
    element rectangle isNil ifTrue: [
        element rectangle:
            ((self leftTop x right: (key x - 1) * (self cellWidth - 1)) @
            (self leftTop y down: (key y - 1) * (self cellHeight - 1))
            extentFromLeftTop: cellSize) ].
    ^element rectangle! !

"WB Run ToolBar Common (WB2ARTBW.SLL)"!
!'WBToolPalette' osiMethods !  
scrollHorizontal: anInteger
        "Private - Scroll the pane left by anInteger
         number of pixels (if positive) or right by
         the absolute value of anInteger (if negative)."! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'WBWindowDialog' osiMethods !  
openModalTo: aWindow
        "Open the dialog box modal to ownerTopPane."
    self wbPreOldVersionSupport.
    self createViews.
    self mainView openModal: aWindow mainView! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'Window' osiMethods !  
addSubpane: aPane
        "Add aPane as the child of the receiver."
    | id name getContentsHandler |
    children isNil ifTrue: [ children := IdentityDictionary new ].
    ( id := aPane id ) isNil
        ifTrue: [ aPane id: ( id := self getNextChildId ) ].
    children at: id put: aPane.
    aPane frameWindow parent: self.
    aPane owner isNil
        ifTrue: [ aPane owner: self owner ].
    aPane isControlPane ifTrue: [
        "if being added dynamically, then do subclassing"
        self isValid ifTrue: [ aPane subclassRecursively ] ].
    self mainWindow add: aPane interestIn: aPane name.

    #modifiedByOSI.
    self owner isWBWindow ifTrue: [
        (self mainWindow propertyAt: #subPaneWithFocus) isNil & aPane isATabStop ifTrue: [
            (aPane canTab and: [aPane isRadioButton not or: [aPane selection]]) ifTrue: [
                self mainWindow propertyAt: #subPaneWithFocus put: aPane]]].

    #obsoleteMethod.    "Obsolete modification..."
    name := aPane name.
    (getContentsHandler := aPane getContentsHandler) notNil ifTrue: [
        name ~= getContentsHandler ifTrue: [
            self mainWindow add: aPane interestIn: getContentsHandler]].! !

"WB Run Base Common"!
!'Window' osiMethods !  
addTabInfoFor: aPane
        "Private - Add tabbing information for aPane to
        the receiver."
    aPane canTab
        ifTrue: [ self orderedChildren add: aPane ].
    #modifiedByOSI.
    "Save the child order information."
    self owner isWBWindow ifTrue: [
        (self
            propertyAt: #childrenInBuildOrder
            ifAbsentPut: [ OrderedCollection new ])
                add: aPane ].! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'Window' osiMethods !  
iconFile
    "Supports attatching icons to windows"
    #addedByOSI.
    ^self propertyAt: #iconFile! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'Window' osiMethods !  
iconFile: aString
    "Added by OSI - supports attatching icons to windows"
    | path |
    #addedByOSI.
    self propertyAt: #iconFile put: aString.
    path := (File exists: aString)
        ifTrue: [ aString ]
        ifFalse: [ File findFileName: aString fileNameLessPath ].
    path notNil ifTrue: [
        self icon: (Icon fromFile: path) ].! !

"WB Run Base Common (WB2ARBW.SLL)"!
!'Window' osiMethods !  
topParent
        "Answer the top most parent."
    #addedByOSI.
    ^parent topParent! !

"WB Run Base Win32 (WB2ARBW.SLL)"!
!'Window class' osiMethods !  
wbInitializeBaseRuntimeWin32
        "Initialize the base runtime for Win32."

    OperatingSystemEvents
        at: 13  put: #wmGettext:with: ;
        at: 1123 put: #wmUser99:with: .

    ColorConstants
        at: 'ClrChiseledgray' put: 14737632.

    IndexedColor defaultColors
        at: #paleGray
        put: (
            IndexedColor index: (
                ColorConstants at: 'ClrPalegray')).! !
  
"--------- remove temporary methods"!

String removeSelector: #osiMethods !
String removeSelector: #osiMethods: !
String removeSelector: #osiEvaluateIfError: !
String removeSelector: #osiRemoveSelector: !
String removeSelector: #fileInFrom: !
String removeSelector: #osisubclass:instanceVariableNames:classVariableNames:poolDictionaries: !
String removeSelector: #osisubclass:instanceVariableNames:classVariableNames:poolDictionaries:ifDefined: !

