05/02/95 10:56:40 PM

disable
        "Disable the receiver and all its children.
         A disabled window does not receive user input."
    super disable.
    self disableElements.!
displayBitmap: key
        "Private - Display the specified bitmap."
    | element rect |

    element := self elementAt: key.
    element isNil ifTrue: [ ^nil ].

    self doGraphics: [
        self pen
            copy: element pen
            from: element boundingBox
            to: (rect := self rectForKey: key).
        element isDisabled ifTrue: [ self drawDisabledWith: self pen in: rect ].
    ].! 
isPreAutomatic
		"Private"
    ^super isPreAutomatic or: [ tpStyle = #mdiToolBar ]! 
pen

    ^pen ifNil: [ pen := self bitmap pen ].!   
height
	    "Answer the receiver's height."
    ^self cellSize y!   
mdiToolBar

    tpStyle := #mdiToolBar.
    self framingBlock: (self isVertical
        ifTrue:[ [:box | Rectangle leftTopUnit rightBottom: (self cellSize x @ box height) ] ]
        ifFalse: [ [:box | Rectangle leftTopUnit rightBottom: (box width @ self cellSize y) ] ]).
!  
defaultSelection
		"Private"
    ^1!
pen: aPen

    pen := aPen! 
bitmapFileAt: key
		"Private"
    | element |
    (self validSelection: key) ifFalse: [ ^nil ].

    ^(element := self elementAt: key) isNil
            ifTrue: [ nil ]
            ifFalse: [ element file ]!
rbEventFor: key
		"Private"
    | selector |

    selector := self rbSelectorAt: key.

    (selector notNil and: [ selector isSymbol ])
        ifTrue: [
            (self owner class canUnderstand: selector)
                ifTrue: [
                    (selector includes: $:)
                        ifTrue: [self owner perform: selector with: self]
                        ifFalse: [self owner perform: selector]]].!  
releaseBitmaps

    self file isEmpty ifFalse: [
        self bitmap release.
        self bitmap: nil
    ].!   
up

    self state: #up!
cacheRedraw: aBoolean
		"Private"
    cacheRedraw := aBoolean!  
cachedElements
		"Private"
    ^cachedElements ifNil: [ cachedElements := Set new ]!
numSpaces: anInteger

    numSpaces := anInteger!   
cellSize
		"Answer the size of the buttons."
    ^cellSize ifNil: [ cellSize := self defaultCellSize ].!
aboutToSaveImage
		"Private - Invalidate the pen before saving the image."
    self elements do: [ :tool | tool pen: nil ].!
isPreAutomatic
        "Private"
    ^tpStyle = #preAutomatic!  
rbSelector

    ^rbSelector!
add: aBitmapOrSelector selector: aSelector
		"Add a button to the toolbar.
			Its left button selector is aSelector.
			It will not have a right button selector."
    self add: aBitmapOrSelector selector: aSelector spaces: 0! 
down

    self state: #down!
isUp

    ^self state == #up!   
display
        "Private - The receiver should display its contents."
    self pen blank: self rectangle.
    1 to: self elements size do: [ :i | self displayKey: i ]!
cellWidth
		"Answer the width of the buttons."
    ^self cellSize x!
enableElements
		"Enable all of the buttons."
    1 to: self elements size do: [ :key |
        self enable: key ].!   
cacheRedrawOff
		"Private"
    self cacheRedraw: false.
    self cachedElements do: [ :element |
        self displayKey: element
    ].
    self cachedElements: nil.! 
add: aSelector
		"Add a button to the toolbar.
			It will not have a right button selector."
    ^self add: nil selector: aSelector!   
downBoundingBox

    ^((self bitmap width // self numImages) @ 0 extent: (self bitmap width // self numImages @ self bitmap height))!   
restoreAllBitmaps

    self elements do: [:tool |
        tool bitmap handle].!
rbSelector: aSymbol

    rbSelector := aSymbol! 
unHighlightBitmap: key
        "Private"
    | element |
    element := self elementAt: key.
    (element isNil or: [ element isDisabled ]) ifTrue: [ ^nil ].
    element up.
    self displayKey: key.!
printOn: aStream

    super printOn: aStream.
    aStream nextPut: $>; nextPutAll: self selector asString! 
isAutomatic
        "Private"
    ^(self isPostAutomatic) | (self isPreAutomatic)!  
wbToolClass
		"Private - Answer the receiver's element class."
    ^WBTool! 
add: aBitmapOrSelector selector: aSelector spaces: numSpaces
		"Add a button to the toolbar.
			It will be numSpaces from its neighbor.
			It will have no right button selector."
    ^self add: aBitmapOrSelector selector: aSelector spaces: numSpaces rbSelector: nil!
state

    ^state!  
selectedItem
		"Returns the index of the selected button."
    ^selection!  
add: aBitmapOrSelector selector: aSelector rbSelector: rbSelector
		"Add a button to the toolbar.
			Its right button selector is rbSelector."
    ^self
		add: aBitmapOrSelector
		selector: aSelector
		spaces: 0
		rbSelector: rbSelector!  
selector

    ^selector!
elementAt: key
		"Private"
    ^self elements at: key ifAbsent: [ nil ]!
enable: key
		"Private"
    | element |
    (element := self elementAt: key) isNil ifFalse: [
        element isEnabled ifFalse: [
            element up.
            self handle isValid ifTrue: [ self displayKey: key ]
        ]
    ].! 
leftTop
        "Private"
    ^self extent * Rectangle leftTopUnit! 
postAutomatic
		"Set the postAutomatic style.
			This will cause the buttons to remain pressed
			until the action they initiate finishes."
    tpStyle := #postAutomatic!
size: aPoint
        "Private"
    size := aPoint.! 
disabledBoundingBox

    ^self upBoundingBox!   
isWBInternalClass

    ^true!   
releaseBitmaps
        "Private - Release all bitmaps."
    | aBitmap |
    self elements do: [ :element | element isNil ifFalse: [ element releaseBitmaps ]].
    self elements: nil.!   
close
        "Private - Close the receiver."
    self releaseBitmaps.
    ^super close!   
generateEventFor: aSelection
		"Private"
    ^nil!  
rbSelectorAt: key
		"Returns the right button selector of the button with the index aKey."
    | element |
    (self validSelection: key) ifFalse: [ ^nil ].

    ^(element := self elementAt: key) isNil
            ifTrue: [ nil ]
            ifFalse: [ element rbSelector ]! 
cacheRedraw
		"Private"
    ^cacheRedraw ifNil: [ cacheRedraw := false ].!  
width
        "Answer the receiver's width."
    ^self size x!  
elementAtSelector: aSelector
		"Private"
    ^(1 to: self elements size) detect: [ :key |
        (self selectorAt: key) = aSelector ] ifNone: [ nil ]!
tpStyle: aSymbol
        "Private"
    tpStyle := aSymbol!  
elementAt: key
		"Private"
    ^(key isInteger and: [ key > 0 and: [ key <= self elements size ]])
        ifTrue: [ self elements at: key ]
        ifFalse: [ nil ]!
wbChangesSize
		"Private"
    ^true!
cacheRedrawOn
		"Private"
    self cacheRedraw: true.!  
add: aBitmapOrSelector spaces: numSpaces rbSelector: rbSelector
		"Add a button to the toolbar.
			It will be numSpaces from its neighbor
			and its right button selector is rbSelector."
    ^self
		add: (aBitmapOrSelector isBitmap ifTrue: [ aBitmapOrSelector ] ifFalse: [ nil ])
		selector: (aBitmapOrSelector isBitmap ifTrue: [ nil ] ifFalse: [ aBitmapOrSelector ])
		spaces: numSpaces
		rbSelector: rbSelector! 
collectionType
		"Private - Answer the collection class used to hold the receiver's elements."
    ^Dictionary! 
defaultSelection
		"Private"
    ^1@1!  
bitmapSelector: aSymbol

    bitmapSelector := aSymbol! 
toggle
		"Set the toggle style.
			This will cause the buttons to remain pressed
			until another one is pressed."
    tpStyle := #toggle!
initialize
        "Private"
    super initialize.
    self elements: self newPage.!   
rectangle: aRectangle

    rectangle := aRectangle! 
at: key put: aBitmapOrSelector selector: aSelector
		"Private - Store the bitmap and selector at the specified position."
	| selector bitmap file element bitmapDict |
	(bitmap := aBitmapOrSelector) isBitmap ifFalse: [
		"This block supports the obsolete CPBitmapDict..."
		selector := aBitmapOrSelector isString
			ifTrue: [ aBitmapOrSelector ]
			ifFalse: [ aSelector ].
		bitmapDict := Smalltalk at: #CPBitmapDict ifAbsent: [ ^nil ].
		bitmap := self useSystem
			ifTrue: [ bitmapDict sysAt: selector asString ifAbsent: [ ^nil ] ]
			ifFalse: [ bitmapDict at: selector asString ifAbsent: [ ^nil ] ] ].
	cellSize isNil ifTrue: [ self cellSize: (bitmap width // 2) @ bitmap height ].
	self elements at: key put: (element := self wbToolClass bitmap: bitmap selector: aSelector).
	aBitmapOrSelector isBitmap | aBitmapOrSelector isNil
		ifFalse: [ element bitmapSelector: aBitmapOrSelector ].
	^element!  
cellSize: aPoint
		"Set the size of the buttons."
    cellSize := aPoint!   
numImages

    ^2!  
displayKey: key
        "Private"
    self cacheRedraw ifTrue: [
        self cachedElements add: key
    ] ifFalse: [
        self displayBitmap: key
    ].!  
at: key put: bitmapSelector
		"Private - Obsolete."
	#obsoleteMethod.
    ^self at: key put: bitmapSelector selector: nil! 
selectItem: key
		"Select button with the index aKey."
    self unHighlightBitmap: selection.
    selection := key.
    self highlightBitmap: key.!   
vertical

    self propertyAt: #vertical put: true.
!  
wbSuggestedExtent
		"Private"
    self elements isEmpty ifTrue: [ ^self cellSize ].
    ^self leftTop distanceRightAndDown:
        elements last rectangle rightBottom!  
preAutomatic
		"Set the postAutomatic style.
			This will cause the buttons to return to their unpressed
			states before the action they initiate takes place."
    tpStyle := #preAutomatic!
selector
		"Returns the left button selector of the selected button."
    ^self selectorAt: selection!  
add: aBitmapOrSelector spaces: numSpaces
		"Add a button to the toolbar.
			It will be numSpaces from its neighbor.
			It will have no right button selector."
    ^self
		add: (aBitmapOrSelector isBitmap ifTrue: [ aBitmapOrSelector ] ifFalse: [ nil ])
		selector: (aBitmapOrSelector isBitmap ifTrue: [ nil ] ifFalse: [ aBitmapOrSelector ])
		spaces: numSpaces!   
disabled

    self state: #disabled!
numSpaces

    ^numSpaces ifNil: [ numSpaces := 0 ]!
elementAt: key put: anElementArray
		"Private"
    self elements at: key put: anElementArray!   
button1Down: aPoint
        "Private - left button was pressed"
    | index |

    ( self isLocalDragSource and: [ self isDragButton: 1 ] )
        ifTrue: [ self dragOnMove: true location: aPoint ].

    index := self highlight: selection.
    self event: #gettingFocus.

    self captureMouseInput.
    Notifier consumeInputUntil: [:event |
        index := self highlight: index.
        #osiHack.
        "Code for drag/drop from tool bar."
        event selector = #button1Move: ifTrue: [
            ( self isLocalDragSource
                and: [ self dragOnMove
                    and: [ self isDragSourceInitiation: event arguments first ] ] )
                        ifTrue: [
                            "self clearMouseCapture."
                            self unHighlightBitmap: index.
                            ^self ] ].
        (event notNil and: [ event selector == #button1Up: ])
    ].
    self clearMouseCapture.

    (self isEnabled: index) ifTrue: [
        selection := index.
        self isPreAutomatic ifTrue: [self unHighlightBitmap: selection].
        self generateEventFor: selection.
        self eventFor: selection.
        self event: #select. "Obsolete"
        self triggerEvent: #clicked: with: self selector.
        self isPostAutomatic ifTrue: [self unHighlightBitmap: selection].
        self isAutomatic ifTrue: [ selection := nil ].
    ] ifFalse: [
        self highlightBitmap: selection.
    ].!   
defaultCellSize
		"Private"
    ^25@22! 
bitmap

    ^bitmap!
size
        "Private"
    size isNil ifTrue: [ size := 0@0 ].
    ^size!  
cellHeight
		"Answer the height of the buttons."
    ^self cellSize y!  
elements: aCollection
		"Private"
    elements := aCollection!  
currentIndex
		"Return the number of the button currently touched by the mouse.
			The buttons are number from left to right starting at one."
    | point |
    point := Cursor offset mapToWindow: self.
    1 to: self elements size do: [ :i |
        (((self elementAt: i) rectangle) containsPoint: point)
            ifTrue: [ ^i ]].
    ^nil.! 
fontExtent: aPoint

    ((aPoint ~= FramingParameters dialogUnit) and: [self class autoScale])
        ifTrue: [
            self propertyAt: #creationCellSize put: self cellSize.
            self cellSize: (self cellSize * FramingParameters dialogUnit / aPoint) rounded]! 
bitmap: aBitmap

    bitmap := aBitmap! 
resizeWindow
        "The window has changed size, so invalidate the element rectangles."
    super resizeWindow.
    self elements do: [ :elem | elem rectangle: nil ].!  
elementAtSelector: aSelector
		"Private"
    ^self elements keys detect: [ :key |
        (self selectorAt: key) = aSelector ] ifNone: [ nil ]!
unHighlightSelection
        "Private"
    self unHighlightBitmap: selection.
    selection := nil.!   
enableItem: aSelector
		"Enable the button with the left button selector aSelector."
    self enable: (self elementAtSelector: aSelector)!  
cachedElements: aCollection
		"Private"
    cachedElements := aCollection!  
selector: aSymbol

    selector := aSymbol.
    bitmapSelector ifNil: [ bitmapSelector := selector ].! 
useSystem: aBoolean
		"Private - Obsolete"
	#obsoleteMethod.
    useSystem := aBoolean!
autoScale: aBoolean

    AutoScale := aBoolean! 
newPage
        "Private"
    ^self collectionType new! 
stateAt: key
        "Private"
    | element |
    (self validSelection: key) ifFalse: [ ^nil ].

    ^(element := self elementAt: key) isNil
            ifTrue: [ nil ]
            ifFalse: [ element state ]!  
isEnabled

    ^self isDisabled not!
button1DoubleClick: aPane
        "Private - The user double clicked button 1 at aPoint."
    self event: #doubleClick. "Obsolete"
    self triggerEvent: #doubleClick: with: self selector!   
elements
		"Private"
    ^elements! 
useSystem
		"Private - Obsolete"
	#obsoleteMethod.
    ^useSystem ifNil: [ useSystem := false ].!  
add: aBitmapOrSelector selector: aSelector
		"Add a button to the toolbar.
			Its left button selector is aSelector.
			It will not have a right button selector."
    | key point |
    key := self elements size + 1.
    point := ((key - 1)\\(self size x)+1) @ ((key + (self size x - 1))//(self size x )).
    ^self at: point put: aBitmapOrSelector selector: aSelector.!  
validSelection: key
		"Private"
    ^(self elementAt: key) notNil!  
isPostAutomatic
        "Private"
    ^tpStyle = #postAutomatic!
display
        "Private - The receiver should display its contents."
    self pen blank: self rectangle.
    1 to: self width do: [ :x |
        1 to: self height do: [ :y |
            self displayKey: x@y
        ]
    ]!   
disableElements
		"Disable all of the buttons."
    1 to: self elements size do: [ :key |
        self disable: key ].!
collectionType
		"Private - Answer the collection class used to hold the receiver's elements."
    ^OrderedCollection!  
whenX: anEvent perform: aMessage
        "Private - Obsolete??
         Notify the owner whenever anEvent occurs by
         performing aMessage.  For compatibility,
         aMessage can be a one argument selector."
    | m |
	#obsoleteMethod.
	"Is this an obsolete method?"
    m := aMessage.
    "aMessage isSymbol ifTrue: [m := Message new
        receiver: (self owner notNil ifTrue: [self owner]
            ifFalse: [self sender])
        selector: aMessage
        arguments: (Array with: self)]."
    handlers at: anEvent put: m.! 
isMDISupportPane
        "Answer true if receiver is a support pane for MDI."
    ^self tpStyle == #mdiToolBar! 
enableElements
		"Enable all of the buttons."
    self elements keysDo: [ :key |
        self enable: key ].!  
drawDisabledWith: aPen in: aRect
        "Private"
    | d |
    d := 2 @ (2 + Rectangle rightBottomUnit y).
    aPen
        setLineWidth: 1;
        foreColor: Color paleGray;
        backColor: Color paleGray;
        drawRectangle: (aRect insetBy: 1);
        lineFrom: (aRect leftBottom rightAndUp: d) to: (aRect rightBottom leftAndUp: d);
        lineFrom: (aRect rightTop leftAndDown: 3@2) to: (aRect rightBottom leftAndUp: 3@2).
! 
boundingBox

    boundingBox ifNil: [
        boundingBox := IdentityDictionary new.
        boundingBox
            at: #up put: self upBoundingBox;
            at: #down put: self downBoundingBox;
            at: #disabled put: self disabledBoundingBox.
    ].
    ^boundingBox at: self state ifAbsent: [ 0@0 extent: 0@0 ].!   
height
	    "Answer the receiver's height."
    ^self size y!   
creationCellSize

    ^self propertyAt: #creationCellSize ifAbsent: [self cellSize]!
justFileName: fileName
        "Private"
    ^((File splitPath: fileName in: Disk) at: 3) upTo: $.! 
defaultCellSize
		"Private"
    ^28@28! 
constructEventsTriggered
        "Private - answer the set of events that instances of the
        receiver can trigger."
    ^super constructEventsTriggered
        add: #clicked:;
        add: #selecting:;
        add: #doubleClick:;
        add: #showHelp:;
        yourself!
file

    ^file ifNil: [ file := '' ]!  
defaultStyle
        "Private - Answer an Integer with appropriate styles in it."
    ^WsChild | WsVisible! 
toggleWhite
        "Private"
    tpStyle := #toggleWhite!  
eventFor: key
        "Private"
    | selector |

    selector := self selectorAt: key.

    (selector notNil and: [ selector isSymbol ])
        ifTrue: [
            (self owner class canUnderstand: selector)
                ifTrue: [
                    (selector includes: $:)
                        ifTrue: [self owner perform: selector with: self]
                        ifFalse: [self owner perform: selector]]].!
tpStyle
        "Private"
    ^tpStyle! 
bitmap: aBitmap selector: aSymbol

    ^(self new)
        state: #up;
        selector: aSymbol;
        bitmap: aBitmap;
        yourself!
stateAt: key put: aSymbol
        "Private"
    | element |
    (element := self elementAt: key) isNil ifFalse: [
        element state: aSymbol.
    ].!
rectForKey: key
        "Private"
    | element rect |
    key ifNil: [ ^0@0 extent: 0@0 ].
    element := self elementAt: key.
    element ifNil: [ ^self leftTop extentFromLeftTop: 1@1 ].
    element rectangle ifNil: [
        rect := self rectForKey: key - 1.
        element rectangle: ((self isVertical
            ifTrue: [rect leftBottom down: element numSpaces - 1]
            ifFalse: [rect rightTop right: element numSpaces - 1])
                extentFromLeftTop: self cellSize ) ].
    ^element rectangle! 
scrollHorizontal: anInteger
        "Private - Scroll the pane left by anInteger
         number of pixels (if positive) or right by
         the absolute value of anInteger (if negative)."! 
newBlankBitmap: aBitmap

    ^Bitmap
            width: aBitmap width // self numImages
            height: aBitmap height
            planes: aBitmap planes
            bitCount: aBitmap bitCount.!  
autoScale

    ^AutoScale ifNil: [AutoScale := true]!   
isDisabled

    ^self state == #disabled!   
buttonFrom: anBitmapFile size: aPoint
		"Private"
    | aBitmap |
    anBitmapFile isNil
        ifTrue: [
            aBitmap := Bitmap extent: aPoint.
            aBitmap pen centerText: '?' at: aBitmap boundingBox center.
            ^aBitmap ].
    ^((anBitmapFile includes: $*) not and: [File exists: anBitmapFile])
        ifTrue: [ Bitmap fromFile: anBitmapFile ]
        ifFalse: [
            aBitmap := Bitmap screenExtent: aPoint.
            aBitmap pen
                draw3DButton: (self justFileName: anBitmapFile)
                rect: aBitmap boundingBox
                font: self font.
            aBitmap]!
upBoundingBox

    ^(0 @ 0 extent: (self bitmap width // self numImages @ self bitmap height))! 
bitmapSelector

    ^bitmapSelector!
add: aBitmapOrSelector selector: aSelector spaces: numSpaces rbSelector: rbSelector
		"Add a button to the toolbar.
			Its left button selector is aSelector.
			It will be numSpaces from its neighbor
			and its right button selector is rbSelector."
    | key element |
    key := self elements size + 1.
    self elements add: nil.
    element := self at: key put: aBitmapOrSelector selector: aSelector.
    element isNil ifTrue: [ ^nil ].
    ^element
        numSpaces: numSpaces;
        rbSelector: rbSelector;
        yourself! 
add: aBitmapOrSelector
		"Add a button to the toolbar.
			It will not have a right button selector."
    self add: aBitmapOrSelector spaces: 0!
generateEventFor: aSelection
        "Private"
    self event: (
        'R', aSelection y asString,
        'C', aSelection x asString) asSymbol.!   
isEnabled: key
        "Private"
    | element |
    ^(element := self elementAt: key) isNil
            ifTrue: [ false ]
            ifFalse: [ element isEnabled ]!   
currentIndex
		"Return the number of the button currently touched by the mouse.
			The buttons are number from left to right starting at one."
    | point |
    point := Cursor offset mapToWindow: self.
    point := self leftTop distanceRightAndDown: point.
    ^(point x // self cellWidth + 1)
        @ (point y // self cellHeight + 1)! 
freeClientArea: box
    "Private - Set the client area left over."
    self tpStyle == #mdiToolBar ifFalse: [ ^self ].
    self visible ifFalse: [ ^self ].
    box leftTop: (self isVertical
        ifTrue: [ box leftTop rightAndDown: (self cellSize x @ 0) ]
        ifFalse: [ box leftTop rightAndDown: (0 @ self cellSize y) ]).
! 
add: aBitmapOrSelector rbSelector: rbSelector
		"Add a button to the toolbar.
			Its right button selector is rbSelector."
    ^self
		add: (aBitmapOrSelector isBitmap ifTrue: [ aBitmapOrSelector ] ifFalse: [ nil ])
		selector: (aBitmapOrSelector isBitmap ifTrue: [ nil ] ifFalse: [ aBitmapOrSelector ])
		rbSelector: rbSelector!   
isDown

    ^self state == #down!   
disableElements
		"Disable all of the buttons."
    self elements keysDo: [ :key |
        self disable: key ].!   
at: key selector: aSelector
		"Private - Obsolete"
	#obsoleteMethod.
    ^self at: key put: nil selector: aSelector!   
disable: key
		"Private"
    | element |
    (element := self elementAt: key) isNil ifFalse: [
        element isEnabled ifTrue: [
            element disabled.
            self handle isValid ifTrue: [ self displayKey: key ]
        ]
    ].!   
state: aSymbol

    state := aSymbol!   
boundingBox: aRectangle

    boundingBox := aRectangle! 
button2Down: aPoint
        "Private - Capture mouse input in preparation for
         right button scrolling."
    | index |

    ( self isLocalDragSource and: [ self isDragButton: 2 ] )
        ifTrue: [ self dragOnMove: true location: aPoint. ].

    index := self currentIndex.

    (self isEnabled: index) ifTrue: [
        self rbEventFor: index.
    ].!  
highlight: currentSelection
        "Private"
    | index element |
    index := self currentIndex.
    currentSelection = index ifFalse: [
        self event: #showHelp. "Obsolete"
        self triggerEvent: #showHelp: with: (self selectorAt: index)].
    (self isEnabled: index) ifTrue: [
        (currentSelection = index)
            ifFalse: [
                self unHighlightBitmap: currentSelection.
                self highlightBitmap: index.
                self event: #selecting. "Obsolete"
                self triggerEvent: #selecting: with: (self selectorAt: index)
            ].
    ] ifFalse: [
        self unHighlightBitmap: currentSelection.
        index := nil
    ].
    ^index! 
enable
        "Enable the receiver and all its children."
    super enable.
    self enableElements.! 
rectangle

    ^rectangle!  
isVertical

    ^(self propertyAt: #vertical) == true
!
selectorAt: key
		"Returns the left button selector of the button with the index aKey."
    | element |
    (self validSelection: key) ifFalse: [ ^nil ].

    ^(element := self elementAt: key) isNil
            ifTrue: [ nil ]
            ifFalse: [ element selector ]!  
rectForKey: key

    | element |
    element := self elementAt: key.
    element ifNil: [^0@0 extent: 0@0].
    element rectangle isNil ifTrue: [
        element rectangle:
            ((self leftTop x right: (key x - 1) * (self cellWidth - 1)) @
            (self leftTop y down: (key y - 1) * (self cellHeight - 1))
            extentFromLeftTop: cellSize) ].
    ^element rectangle!   
file: aString

    file := aString! 
disableItem: aSelector
		"Disable the button with the left button selector aSelector."
    self disable: (self elementAtSelector: aSelector)!   
updateSliders
        "Private - Update the slider boxes in the scrollbars."!
supportedEvents

    ^super supportedEvents
        add: #select;
        add: #selecting;
        add: #doubleClick;
        add: #gettingFocus;
        add: #showHelp;
        yourself!   
highlightBitmap: key
        "Private"
    | element |
    element := self elementAt: key.
    (element isNil or: [ element isDisabled ]) ifTrue: [ ^nil ].
    element down.
    self displayKey: key.!