05/02/95 10:57:37 PM

collectArguments: evaluationArguments
		"Private - answer the action arguments with which to evaluate
		the receiver, collecting from the <evaluationArguments>
		and the predefined arguments in the receiver. "
	| answer predefinedArgs size |
	answer := self arguments shallowCopy.
	predefinedArgs := answer at: answer size.
	^answer
		at: answer size put: (
			(evaluationArguments size = predefinedArgs size)
				ifTrue: [ evaluationArguments ]
				ifFalse: [
					size := evaluationArguments size min: predefinedArgs size.
					(evaluationArguments copyFrom: 1 to: size),
					(predefinedArgs copyFrom: size + 1 to: predefinedArgs size) ] );
		yourself!
wbUnlinkPartMessages
        "Private - Unlink the parts messages from the subpanes to the receiver."
    #addedByOSI.
    WBPartMessage.
    self isWBWindow ifTrue: [
        self partMessages wbItems do: [ :each |
            each wbUnlinkPartMessage ] ].!  
partEvents
        " Answer the PARTS event interface of the receiver. "
	#addedByOSI.
	^views wbPartEvents ifNil: [
		"Don't cashe the events if editing..."
		self partIsEditing
			ifTrue: [ self wbPartEvents ]
			ifFalse: [ views wbPartEvents: self wbPartEvents ] ]!   
partWrapper: aWrapper
        " Private - set the PARTS wrapper of the receiver. "
	#addedByOSI.
    self propertyAt: #partsWrapper put: aWrapper.!
triggeredEvent
		"Answer the triggered event selector."
	^self arguments first! 
wbItems: aCollection
		"Private - Set the receiver's wbItems."
	wbItems := aCollection.!
wbPartMessages: aWBPartInterfaceList
		"Private - Set the part events."
	^wbPartMessages := aWBPartInterfaceList!   
source: anObject sourceSelector: sourceSymbol
	receiverName: aString selector: aSymbol
		"Answer a new initialized instance of the receiver."
	^self new
		source: anObject
		sourceSelector: sourceSymbol
		receiverName: aString
		selector: aSymbol!
addWbItem: aWbItem
		"Private - Add a WbItem."
	self clearWbItemTable.
	^super addWbItem: aWbItem! 
wbItemFor: anItem ifAbsent: aBlock
		"Private - Answer the wbItem corresponding with anItem."
	^self wbItemTable
		at: anItem
		ifAbsent: aBlock! 
copy
		"Answer a copy of the receiver."
	^self class new
		items: self items copy;
		defaultItem: self defaultItem;
		separators: self separators copy;
		wbItems: wbItems deepCopy;
		yourself!   
wbPartMessages
		"Private - Answer the part events."
	^wbPartMessages!  
partEvents
        " Answer the PARTS event interface of the receiver. "
	^self propertyAt: #wbPartEvents ifAbsentPut: [ self wbPartEvents ]!   
eventsTriggered
        "Answer all the events which can be triggered
        by instances of the receiver."
    ^super eventsTriggered
		addAll: self wbPartEventItems;
		yourself! 
partHint
        "Answer a string which gives a brief description
        of the receiver part. "
    ^self printString!   
receiverName
		"Answer the receiver's name."
	^receiverName ifNil: [
		(receiver respondsTo: #paneName)
			ifTrue: [ receiver paneName ]
			ifFalse: [ '' ] ]!   
doesNotUnderstand: message
        "Sent to the receiver by the virtual machine when the <message>
        sent to the receiver was not implemented by the receiver."
	#addedByOSI.
	self isWBWindow ifTrue: [
		^(self partMessages
			wbItemFor: message selector
			ifAbsent: [ ^super doesNotUnderstand: message ]
		) evaluateWithArguments: message arguments ].
	^super doesNotUnderstand: message!   
sourceName: aString sourceSelector: sourceSymbol
	receiver: anObject triggeredEvent: aSymbol
		"Initialize the receiver."
	sourceName := aString.
	sourceSelector := sourceSymbol.
	receiver := anObject.
	selector := #triggerEvent:withArguments:.
	arguments :=
		Array with: aSymbol with: (
			Array new: (
				Message numberOfArgumentsFor: aSymbol ) ).!
eventsTriggered
        "Answer all the events which can be triggered
        by instances of the receiver."
    ^super eventsTriggered
		addAll: self wbPartEventItems;
		yourself! 
wbUnlinkPartEvents
        "Private - Unlink the parts events from the subpanes to the receiver."
    #addedByOSI.
    WBPartEvent.
    self isWBWindow ifTrue: [
        self partEvents wbItems do: [ :each |
            each wbUnlinkPartEvent ] ].!
partMirrorCopyChildren: aDictionary to: copy
        " Private - mirror copy the child windows "
    copy children: (
		aDictionary
			at: ( children ifNil: [ ^self ] )
			put: ( children class new )
		).!   
wbPartEvents

		"WARNING!! This method was automatically generated by 
		WindowBuilder. Code you add here which does not conform to 
		the WindowBuilder API will probably be lost the next time 
		you save your wb-parts definition."

	^WBPARTSEventList new
		items: self class wbPartEventItems
		separators: #( )
		defaultItem: nil;
		addWbItem: (
			WBPartEvent
				sourceName: 'mainView'
				sourceSelector: #aboutToClose
				receiver: self
				triggeredEvent: #aboutToClose );
		addWbItem: (
			WBPartEvent
				sourceName: 'mainView'
				sourceSelector: #closed
				receiver: self
				triggeredEvent: #closed );
		addWbItem: (
			WBPartEvent
				sourceName: 'mainView'
				sourceSelector: #opened
				receiver: self
				triggeredEvent: #opened );
		yourself! 
wbPartMessages
		"Answer the window builder part messages."
	#addedByOSI.
	^nil!   
source: anObject sourceSelector: sourceSymbol
	receiverName: aString selector: aSymbol
		"Answer a new initialized instance of the receiver."
	source := anObject.
	sourceSelector := sourceSymbol.
	receiverName := aString.
	selector := aSymbol.
	arguments := Array new: (
		Message numberOfArgumentsFor: aSymbol ).!
partHint
        "Answer a string which gives a brief description
        of the receiver part. "
	#addedByOSI.
    ^self printString!
wbLinkPartEvent
		"Private - Link the source to the receiver."
	(self source ifNil: [ ^self ])
		when: self sourceSelector
		evaluate: self.! 
partAddUnder: parentWindow wrapper: myWrapper
        "Insert the receiver into a PARTS application
        as a child of parentWindow.  Save myWrapper
        if necessary to respond correctly when
        the #partWrapper message is sent. "
	#addedByOSI.
	self partWrapper: myWrapper.
    ^super partAddUnder: parentWindow wrapper: myWrapper.!  
source
        "Answer the source of the message."
    ^source ifNil: [
		receiver notNil & sourceName notNil
			ifTrue: [ source := receiver paneNamed: sourceName ]
			ifFalse: [ receiver ] ]!
wbPartEvents

		"WARNING!! This method was automatically generated by 
		WindowBuilder. Code you add here which does not conform to 
		the WindowBuilder API will probably be lost the next time 
		you save your wb-parts definition."

	^WBPARTSEventList new
		items: self class wbPartEventItems
		separators: #( )
		defaultItem: nil;
		yourself!
owner: anObject name: aString selector: selector
        "Answer an instance of the receiver representing a message."
    ^self new
		owner: anObject
		name: aString
		selector: selector!  
receiver
        "Answer the receiver of the message."
    ^receiver ifNil: [
		source notNil & receiverName notNil
			ifTrue: [ receiver := source paneNamed: receiverName ]
			ifFalse: [ source ] ]!  
wbPartMessages

		"WARNING!! This method was automatically generated by 
		WindowBuilder. Code you add here which does not conform to 
		the WindowBuilder API will probably be lost the next time 
		you save your wb-parts definition."

	^WBPARTSMessageList new
		items: #(backColor: disable enable hideWindow inspect setFocus setValue: showWindow value yourself)
		separators: #( )
		defaultItem: #value;
		yourself!
partMessages
		" Answer the PARTS message interface of the receiver. "
	^self propertyAt: #wbPartMessages ifAbsentPut: [ self wbPartMessages ]! 
partWrapper
        " Answer the PARTS wrapper of the receiver. "
	#addedByOSI.
    ^self propertyAt: #partsWrapper ifAbsent: [ nil ]! 
wbItemsCreate
		"Private - Answer the receiver's new wbItems."
	^OrderedCollection new! 
partAddedTo: anApplication
		" The receiver has just been added to anApplication.
		Create any links or register event handlers if desired. "
	#addedByOSI.
	( anApplication partWrapper hasLinksForEvent:  #open )
		ifFalse: [
			anApplication partEditor
				createLinkFrom: anApplication
				event: #open
				to: self
				message: #open ].! 
partMirrorCopyPropertiesToExclude
        " Private - answer the names of any properties
        implemented by the receiver which should be excluded
        when its properties dictionary is mirrorCopied. "

   ^super partMirrorCopyPropertiesToExclude, #( wbPartEvents wbPartMessages )!  
wbUnlinkPartEvent
        "Private - Link the source to the receiver."
    source := nil.!  
wbItemTable
		"Answer the table."
	^wbItemTable ifNil: [
		wbItemTable := IdentityDictionary new.
		self wbItems do: [ :aWbItem |
			wbItemTable at: aWbItem sourceSelector put: aWbItem ].
		wbItemTable ]!
fileName
		"Answer nil indicating that the receiver is not stored elsewhere."
		"For PARTS support."
	^nil!
wbPartMessages: anObject
		"Set the window builder part messages."
	#addedByOSI.
	^anObject!   
shallowCopy
        "Answer a copy of the receiver which shares
         the receiver instance variables."
	^self class
		source: source
		sourceSelector: sourceSelector
		receiverName: receiverName
		selector: selector!   
clearWbItemTable
		"Clear the lookup table."
	wbItemTable := nil.!  
addWbItem: aWbItem
		"Private - Add a WbItem."
	wbItems isNil ifTrue: [ wbItems := self wbItemsCreate ].
	^wbItems add: aWbItem!   
wbPartEvents
		"Answer the window builder part events."
	#addedByOSI.
	^nil!   
sourceName
		"Answer the source's name."
	^sourceName ifNil: [
		(source respondsTo: #paneName)
			ifTrue: [ source paneName ]
			ifFalse: [ '' ] ]! 
partViews: anOrderedCollection
		"Private - Used by partMirrorCopyReal to set the copy's instance variable."
	#addedByOSI.
	views := anOrderedCollection.! 
partMessages
		" Answer the PARTS message interface of the receiver. "
	#addedByOSI.
	^views wbPartMessages ifNil: [
		"Don't cashe the messages if editing..."
		self partIsEditing
			ifTrue: [ self wbPartMessages ]
			ifFalse: [ views wbPartMessages: self wbPartMessages ] ]!   
sourceName: aString
		"Set the source's name."
	sourceName :=
		(aString isString and: [ aString notEmpty ])
			ifTrue: [ aString ]
			ifFalse: [ nil ].!
wbPartEventItems

		"WARNING!! This method was automatically generated by 
		WindowBuilder. Code you add here which does not conform to 
		the WindowBuilder API will probably be lost the next time 
		you save your wb-parts definition."

	^#()!
wbPartEventItems

	| answer |
	answer := self constructEventsTriggered.
	CompositePane constructEventsTriggered
		do: [ :each | answer remove: each ifAbsent: [ ] ].
	answer addAll: #( rightClicked tabbed ).
	^answer asArray!   
wbUnlinkPartMessage
        "Private - Link the source to the receiver."
    receiver := nil.!  
wbPartMessages

		"WARNING!! This method was automatically generated by 
		WindowBuilder. Code you add here which does not conform to 
		the WindowBuilder API will probably be lost the next time 
		you save your wb-parts definition."

	^WBPARTSMessageList new
		items: #(abortClose close open openCenteredOnMouse openRelativeTo:offset: openWithParent: yourself)
		separators: #( )
		defaultItem: #open;
		addWbItem: (
			WBPartMessage
				source: self
				sourceSelector: #abortClose
				receiverName: 'mainView'
				selector: #abortClose );
		yourself!
wbPartEventItems

		"WARNING!! This method was automatically generated by 
		WindowBuilder. Code you add here which does not conform to 
		the WindowBuilder API will probably be lost the next time 
		you save your wb-parts definition."

	^#(aboutToClose closed opened)!  
concatenateSeparated: anInterfaceList defaultItem: newDefaultItem
        " Answer anInterfaceList appended to the receiver
        with a separator line between the two lists. "
	^(super
		concatenateSeparated: anInterfaceList
		defaultItem: newDefaultItem)
		wbItems: wbItems deepCopy;
		yourself!
triggeredEvent: aSymbol
		"Set the triggered event selector."
	self arguments at: 1 put: aSymbol.!  
isLinked
		"Answer true indicating that the receiver is linked."
		"For PARTS support."
	^true!
sourceName: aString sourceSelector: sourceSymbol
	receiver: anObject triggeredEvent: aSymbol
		"Answer a new initialized instance of the receiver."
	^self new
		sourceName: aString
		sourceSelector: sourceSymbol
		receiver: anObject
		triggeredEvent: aSymbol!
wbPartEvents: aWBPartInterfaceList
		"Private - Set the part events."
	^wbPartEvents := aWBPartInterfaceList!   
addSubpanesForWBParts
		"Add the subpanes for parts."
		"For PARTS Support."
	super addSubpanesForWBParts.
	self partEvents wbItems do: [ :each | each wbLinkPartEvent ].!
wbPartMessages

		"WARNING!! This method was automatically generated by 
		WindowBuilder. Code you add here which does not conform to 
		the WindowBuilder API will probably be lost the next time 
		you save your wb-parts definition."

	^WBPARTSMessageList new
		items: #()
		separators: #( )
		defaultItem: nil;
		yourself!
source: anObject
		"Set the receiver's source."
	source := anObject.!   
sourceSelector: aSymbol
		"Set the receiver's source selector."
	sourceSelector := aSymbol.!
wbPartEvents
		"Private - Answer the part events."
	^wbPartEvents!  
receiverName: aString
		"Set the receiver's name."
	receiverName :=
		(aString isString and: [ aString notEmpty ])
			ifTrue: [ aString ]
			ifFalse: [ nil ].!  
shallowCopy
		"Answer a copy of the receiver which shares
			the receiver instance variables."
	^self class
		sourceName: sourceName
		sourceSelector: sourceSelector
		receiver: receiver
		triggeredEvent: self triggeredEvent!  
wbLinkPartEvents
		"Private - Link the parts events from the subpanes to the receiver."
	#addedByOSI.
	self isWBWindow ifTrue: [
		self partEvents wbItems do: [ :each |
			each wbLinkPartEvent ] ].!   
concatenate: anInterfaceList defaultItem: newDefaultItem
        " Answer anInterfaceList appended to the receiver. "
	^(super
		concatenate: anInterfaceList
		defaultItem: newDefaultItem)
		wbItems: wbItems deepCopy;
		yourself!   
defaultIconFileName
        "Answer the window builder parts icon."
	^'WB.ICO'! 
defaultIcon
        "Answer the window builder parts icon."
	^Icon fromFile: (
		(File findFileName: self defaultIconFileName)
			ifNil: [ ^nil ] )!  
wbPartEvents

		"WARNING!! This method was automatically generated by 
		WindowBuilder. Code you add here which does not conform to 
		the WindowBuilder API will probably be lost the next time 
		you save your wb-parts definition."

	^WBPARTSEventList new
		items: self class wbPartEventItems
		separators: #( )
		defaultItem: nil;
		yourself!
isPARTSNestedPart
        "Answer whether the receiver is a PARTS NestedPart."
    ^true!   
close
        "Private - Close the subpane and reinitialize."
		"For PARTS Support."
	super close.
    self partEvents wbItems do: [ :each | each wbUnlinkPartEvent ].
    self partMessages wbItems do: [ :each | each wbUnlinkPartMessage ].
	children := nil.!   
sourceSelector
		"Answer the receiver's source selector."
	^sourceSelector! 
hash
        "Answer an integer hash value for the receiver. Invariants:
        the hash value of an object must be constant over time;
        two objects that compare equal must have equal hash values."

		"The receiver of WBMessage may change over time
			so the super method would not return a constant value."

	^selector hash! 
wbItems
		"Private - Answer the receiver's wbItems."
	^wbItems ifNil: [ self wbItemsCreate ]!   
doesNotUnderstand: message
        "Sent to the receiver by the virtual machine when the <message>
        sent to the receiver was not implemented by the receiver."
	^(self partMessages
			wbItemFor: message selector
			ifAbsent: [^super doesNotUnderstand: message]) 
			evaluateWithArguments: message arguments!   
source
		"Answer the receiver's source."
	^source!  
wbPartMessages

		"WARNING!! This method was automatically generated by 
		WindowBuilder. Code you add here which does not conform to 
		the WindowBuilder API will probably be lost the next time 
		you save your wb-parts definition."

	^WBPARTSMessageList new
		items: #(close open openCenteredOnMouse openRelativeTo:offset: openWithParent:)
		separators: #( )
		defaultItem: #open;
		yourself! 
wbPartEventItems

        "WARNING!! This method was automatically generated by
        WindowBuilder. Code you add here which does not conform to
        the WindowBuilder API will probably be lost the next time
        you save your wb-parts definition."

    ^#()!
wbPartEvents: anObject
		"Set the window builder part events."
	#addedByOSI.
	^anObject!