05/02/95 10:53:55 PM

topParent
        "Answer the top most parent."
    #addedByOSI.
    ^parent topParent!
createViewsOnce
        "Create the views only if not already created.
            For PARTS support."
    #addedByOSI.
    views notEmpty ifTrue: [ ^self ].
    ^self createViews! 
openWindow

    "Modified by OSI to support preInitWindow"

        "Open the dialog box modal to the
         current active window."

    #modifiedByOSI.
    self wbOldVersionSupport.
	self wbLinkPartEvents.
    self preInitWindow.

    self mainView open!
validateShow
    "Private - Perform validates and show window."

    self performWhenValids.
    children do: [ :each |
        each isApplicationWindow
            ifTrue: [ each validateShow ]
            ifFalse: [ each validate ] ].

    #modifiedByOSI.
    self owner initWindow.

    self zoomed ifTrue: [
        self children do: [ :each | each zoomed ifFalse: [ each hideWindow ] ] ].
    collapsed isNil ifTrue: [ collapsed := 0 ].
    self isHidden ifFalse: [
        collapsed isRectangle
            ifTrue: [ self showMaximizedWindow ]
            ifFalse: [ collapsed < 0
                ifTrue: [ self showIconicWindow ]
                ifFalse: [ self showWindow ] ] ].

    self sendDeferredEvent: #subclassRecursively.
    self sendDeferredEvent: #triggerOpenedEvent! 
isWBWindow
    "Added by OSI"
    #addedByOSI.
    ^self class wbCreated!  
wbMenuTitled: aString

    "Added by OSI - Search through all menus, including
      submenus, for the menu described below."

        "Answer the menu whose title is aString. Case is ignored
         and aString can include $&, $~, or neither."
    | plainString |
    #addedByOSI.
    plainString := aString stripMnemonic.
    allMenus do: [:m |
        (m title stripMnemonic equalsIgnoreCase: plainString)
            ifTrue: [^m]].
    menus do: [:m |
        (m title stripMnemonic equalsIgnoreCase: plainString)
            ifTrue: [^m]].
    ^nil!   
close
        "Close all the views."
    views do: [:v | v close]!  
viewName: aName

    "Added by OSI"

    #addedByOSI.
    self paneName: aName!  
open
	    "Build and open a window for a new instance of the receiver."
    #addedByOSI.
    self class open: self.!   
removeLastCurrentEvent: anEventSelector for: aWindow
		"Private - Remove the last queued event for aWindow
			having the specified event selector."
	#addedByOSI.
	self
		removeLastCurrentEventFor: self
		using: [ :eachEvent | eachEvent selector = anEventSelector ].!  
preInitWindow: aView forModel: aCoordinator
        "Preform any window initialization."
    #addedByOSI.!  
oldMemoryContext
    "Added by OSI - Answers the old bitmap device context."
    #addedByOSI.
    ^OldMemoryContext!   
xCentered
    "Private"

    self xC!  
wbOwner
		"Answer the window builder owner."
	#addedByOSI.
	^self propertyAt: #wbOwner!
processInput
        "Private - Make the receiver modal to its owner window.
         This method doesn't return until close has been
         sent to the receiver.  parent should be disabled before
         calling this method."
    sem := Semaphore new.
    [CurrentProcess makeUserIF. Notifier run] fork.
    sem notNil ifTrue: [sem wait].  "diag may be closed before
        getting here"
    CurrentProcess makeUserIF!  
getContentsHandler
    "Added by OSI"
    #addedByOSI.
    self obsoleteMethod.
	^nil!
addDynamicListSizeStyle
		"Dynamically size the receiver's frame based on the
			number of elements in the receiver's list."
	isListSizeDynamic := true.!  
openCenteredOnMouse
    "Added by OSI - Open a new instance of the receiver centered over the mouse."
    #addedByOSI.
    ^self new openCenteredOnMouse!  
openWithMDIParent: aViewManager
    "Added by OSI - Open a new instance of the receiver
     as an MDI child of aViewManager."
    #addedByOSI.
    ^self new openWithMDIParent: aViewManager!
bDU: y r: aSymbol
    "Private"

    bottom := (y * self dialogUnitHeight) rounded.
    aSymbol == #center ifFalse: [ bottom := bottom abs ].
    bottomRel := aSymbol.! 
isATabStopPrim
        "Private - Answer true if the receiver is a tabstop"
    #addedByOSI.
    ^self isATabStop! 
contents

    ^fullList!
openModalTo: aWindow
        "Open the dialog box modal to ownerTopPane."
	self wbPreOldVersionSupport.
    self createViews.
    self mainView openModal: aWindow mainView!  
topParent
        "Answer the top most parent."
    #addedByOSI.
    ^self!
drawText: hDC text: t length: l rect: r format: f
    "Added by OSI"
    <api: DrawTextA ulong struct long struct ulong long>
    #addedByOSI.
    #osiHack.
    "Use other drawText: instead... should be equivlent."
    ^self invalidArgument!   
rDU: x r: aSymbol
    "Private"

    right := (x * self dialogUnitWidth) rounded.
    aSymbol == #center ifFalse: [ right := right abs ].
    rightRel := aSymbol.!  
maxWindowSize
    "Added by OSI"
    #addedByOSI. "PARTS Support"
    ^nil!
messageNote: aString
    "Added by OSI  to avoid the 'Information' title"
    #addedByOSI.
    ^self new
        title: '';
        message: aString;
        iconInformation;
        ok;
        open!  
itemTemplateStyle: style x: x y: y cx: cx cy: cy id: id
className: className text: text extraData: extraData
    "Added by OSI - Calculate the size of a dialog item template
     and answer a new item template with attributes
     set from the arguments."
    | size dlgItemTemplate extraDataSizeOffset textOffset unicodeClass unicodeText |
    #addedByOSI.
    unicodeClass := className isNil
        ifTrue: [ ByteArray new: 2 ]
        ifFalse: [ className asExternalString asNullTerminatedUnicodeString ].
    unicodeText := text isNil
        ifTrue: [ ByteArray new: 2 ]
        ifFalse: [ text asExternalString asNullTerminatedUnicodeString ].

    size := 18.         "Base DLGITEMTEMPLATE size"
    textOffset := size := size + unicodeClass size.
    extraDataSizeOffset := size := size + unicodeText size.
    size := size + extraData size + 2.
    size := ( size - 1 truncateTo: 4 ) + 4.  "item templates must be DWORD aligned"

    dlgItemTemplate := self new: size.
    dlgItemTemplate uLongAtOffset:  0 put: style.
    dlgItemTemplate uLongAtOffset: 4 put: 0.  "extended style"
    dlgItemTemplate uShortAtOffset: 8 put: x truncated.
    dlgItemTemplate uShortAtOffset: 10 put: y truncated.
    dlgItemTemplate uShortAtOffset: 12 put: cx truncated.
    dlgItemTemplate uShortAtOffset: 14 put: cy truncated.
    dlgItemTemplate uShortAtOffset: 16 put: id.

    dlgItemTemplate bytesAtOffset: 18 put: unicodeClass.
    dlgItemTemplate bytesAtOffset: textOffset put: unicodeText.
    dlgItemTemplate uShortAtOffset: extraDataSizeOffset put: extraData size.
    dlgItemTemplate bytesAtOffset: extraDataSizeOffset + 2 put: extraData contents.

    ^dlgItemTemplate!  
moduleNameIfArchived
		"Private - Answer the module name if the receiver
			is not in memory, else nil."
	#addedByOSI.
	((bitmapHandle isNil or: [bitmapHandle = NullHandle])
        and: [ archive isArray ])
			ifTrue: [ ^archive at: 1 ].
	^nil!  
rightRel
    "Private"

    ^rightRel! 
endsWith: aCollection
	    "Answer true if the receiver ends with aCollection of objects."
	#addedByOSI.
    self size < aCollection size ifTrue: [ ^false ].
    self size = aCollection size ifTrue: [ ^aCollection = self ].
    ^aCollection = (self copyFrom: self size - aCollection size + 1 to: self size)!  
tabStop
        "Make the dialog item recieve the focus when the user
        presses the TAB key."
    self addStyle: WsTabstop.

	"Call super to set the tabStop property."
	#modifiedByOSI.
	super tabStop.
!  
wmGetdlgcode: wparam with: lparam
        "Private - process WM_GETDLGCODE message."
    #modifiedByOSI.
    self owner isWBWindow ifTrue: [ ^DlgcWantallkeys ].
    ^ DlgcWantchars! 
tabStop
        "Make the dialog item receive the focus when the user
        presses the TAB key.  By default every subpane which
        can be a tabstop is a tabstop"
        "Modified by OSI to store false rather than nil."
    #modifiedByOSI.
    self
        propertyAt: #noTabStop put: false;
        addStyle: WsTabstop.! 
wbBasicVersion
        "Private - Answer the window builder version."
    #addedByOSI.
    ^nil!   
top: y relativeTo: aSymbol
    "Private"

    aSymbol == #center
        ifTrue: [ top := y ] ifFalse: [ top := y abs ].
    topRel := aSymbol.! 
basicStyle
        "Private - Answer an Integer with appropriate
         constants combination for basic control style."
    #modifiedByOSI.
    "DT assumes tab stops are on by default,
        OSI assumes tab stops are off by default."
    ^WsChild | WsVisible |
        (self owner isWBWindow
            ifTrue: [ 0 ] ifFalse: [ WsTabstop ])!
storeOnStream: s
        "Private - WBPro Development.
            Saving bitmaps with the WBBitmapManager."
    | file fileHeader bits |
    #addedByOSI.
    bits := self getDIBits.
    bits isNil ifTrue: [^self].
    fileHeader := WinBitmapFileHeader new.
    fileHeader bfType: 'BM';
        bfSize: 14 + bitmapInfo contents size + bits size;
        reserved1: 0;
        reserved2: 0;
        offBits: 14 + bitmapInfo contents size.

    s nextPutAll: fileHeader contents asString.
    bitmapInfo contents do: [: aByte |
        s nextPut: aByte asCharacter].
    bits do: [: aByte |
        s nextPut: aByte asCharacter].!
wbVersion
        "Answer the window builder version (or nil)."
    #addedByOSI.
    ^self wbBasicVersion! 
mainWindow
        "Answer the receiver's main window.  If the DialogTopPane's
          parent is kind of Window then it returns its parent's main
          window else it returns self. (Needed for cases where
          DialogTopPane is a subpane of TopPane.)"
    ^(owner notNil)
        ifTrue: [
			#modifiedByOSI.
			"Avoid asking for a view that hasn't been created."
			(owner views size < 1)
				ifTrue: [ self ]
				ifFalse: [ owner mainView ] ]
        ifFalse: [ self ]! 
indent
    "Private"

    ^indent! 
windowId
        "Private - Answer the default dialog id for any
        DialogTopPane owned or implemented by a
        subclass of ApplicationCoordinator."
    ^1! 
valueDU: containerRect
        "Answer a rectangle based on self's framing parameters
         with a parent rectangle containerRect."

    ^self valueToDU: (
        (containerRect leftTop * FramingParameters newDialogUnit) rounded
            rightBottom:
                (containerRect rightBottom * FramingParameters newDialogUnit) rounded )! 
redraw
    "Added by OSI. Redraw the entire window."
    #addedByOSI.
    self isHandleOk ifTrue: [ self invalidateRect: nil ].!   
top
    "Private"

    ^top!   
syncControlEvent: anEvent with: aParameter
        "Private - Process anEvent produced
         by the host system. The default is to
         requeue the operation for deferred handling."

    anEvent = CbnDropdown ifTrue: [
        self resizeWithDropDownList.
        self sendInputEvent: #forkListHiddenWatcher.
        ^1 ].

    ^super syncControlEvent: anEvent with: aParameter!   
dialogUnitHeight

    ^SysFont height / 32! 
removeItemDynamically: string

    "Added by OSI"

    | pos mi |

    #addedByOSI.
    mi := (items select: [:i | i label = string]) first.
    pos := items indexOf: mi.
    items removeIndex: pos.
    accel removeIndex: pos.
    window notNil ifTrue: [
        window deleteItem: mi ].

    "##### Old Code #####
    UserLibrary
        deleteMenu: window asParameter
        position:  pos - 1
        flag: MfByposition.
    ##### ##### #####"!   
pStyle: s

    "Added by OSI"
    #addedByOSI.
    self propertyAt: #pStyle put: s.!  
add: aWindow interestIn: name
	    "Private"
	#addedByOSI.
	"PARTS implements this in Window,
		so we reimplement it here so that
		CompositePanes work without PARTS installed."!   
contents: aCollection

    disabled := Set new.
    fullList := aCollection.

    ^super contents: aCollection!  
wbStringWidth: aString
        "Answer the width of aString using the receiver font."
    #addedByOSI.
    aString isNil ifTrue: [ ^0 ].
    ^self
        stringWidth: aString stripMnemonic
        graphicsMedium: Display!  
wbReleaseEventTable
    "Private"
    "Break all connections to event handlers."

    wbEventTable := nil!
scaleFrom: aRect
		"Answer a Rectangle as a result of applying the receiver framer to aRect.
		PARTS Support"
    ^self value: aRect!  
wbVersion
		"Answer the window builder version (or nil)."
	#addedByOSI.
	^self wbBasicVersion ifNil: [
		self wbCreated
			ifTrue: [ 1.0 ]
			ifFalse: [ nil ] ]!   
keyDownInput: aKeyboardInputEvent
        "Private - A key down event was received."
    #addedByOSI.!  
bottomRel
    "Private"

    ^bottomRel!   
removeDynamicListSizeStyle
		"Do not dynamically size the receiver's frame based on the
			number of elements in the receiver's list."
	isListSizeDynamic := false.!   
findOrPromptFileName: fileName in: aCollectionOfDir
        "Answer the full path of the file named fileName.
        Searching in aCollectionOfDir first, then the current search path,
		 then prompt the user.  If the user specifies a directory that is not
		 in aCollectionOfDir, then add that directory to aCollectionOfDir."

	#addedByOSI.
	^self
		findOrPromptFileName: fileName
		filters: #( )
		in: aCollectionOfDir!   
isCompatible: anObject

    "Private: Added by Objectshare.
     Is an<Object> compatible with the receiver"

    #addedByOSI.
    self obsoleteMethod.
    ^false!
appendItem: aLabelString
    selector: aSelector
    acceleratorString: aString
        "Append an item with label aLabelString and
         selector aSelector to the receiver menu.  Parse the
         accelerator info from aString.  aString has the following
         syntax:
            One or more of 'Ctrl', 'Alt', or 'Shift'.
            A plus sign (+).
            A single character (indicating Ctrl+S for example)
                or an integer (indicating Ctrl+Del for example).
            Examples:
                'Ctrl+S' means Control key and the S key.
                'AltShift+C' means Alt and Shift keys and the C key.
                'Ctrl+27' means Control and the Del key (VkDelete = 27)."
    | s bits bitsString key keyString |
    #modifiedByOSI.
    aString isEmpty ifTrue: [
        ^self appendItem: aLabelString selector: aSelector
            accelKey: nil accelBits: nil ].
    s := aString asStream.
    bitsString := s upTo: $+.
    keyString := s upTo: $+.
    keyString first isDigit
        ifTrue: [
            key := 0.
            1 to: keyString size do: [:i |
                key := key * 10 + ( keyString at: i ) digitValue ].
            key := PMToWinKeyMap at: key. "OSI Mod - map from PM Codes"
            bits := AfVirtualkey ]
        ifFalse: [
            key := keyString first.
            bits := AfChar ].
    ( bitsString includes: $C ) ifTrue: [ bits := bits | AfControl ].
    ( bitsString includes: $A ) ifTrue: [ bits := bits | AfAlt ].
    ( bitsString includes: $S ) ifTrue: [ bits := bits | AfShift ].
    ^self appendItem: aLabelString selector: aSelector
           accelKey: key accelBits: bits!
keyUpFromWmKeyup: wparam with: lparam
        "Private - answer an instance of the receiver class corresponding to
        the host WM_CHAR message described by the arguments."
    #addedByOSI.
    ^self fromWmChar: wparam with: lparam!  
dragTargetOperationsDefault
        "Private - answer the operations that the receiver can accept."
    #addedByOSI.
    ^nil! 
wbUnlinkPartMessages
        "Private - Unlink the parts messages from the subpanes to the receiver."
    #addedByOSI.! 
initSize
        "Private - Answer the initial size of the receiver."
    | size |
    size := self initWindowSize.
    ^(size isRectangle
            ifTrue: [size]
            ifFalse: [
                size isPoint
                    ifTrue: [self boxOfSize: size]
                    ifFalse: [0 @ 0 extent: 100@100]]).!
wmGettext: wParam
with: lParam
    "Added by OSI"

    #addedByOSI.
    ^nil!
closeView

    dialogOwner isWindow
        ifTrue: [
            dialogOwner enable.
            dialogOwner makeActive ].
    super closeView.
    Processor currentProcessIsRecursive ifTrue: [
        ^self].   "no semaphore wait"
   sem notNil ifTrue: [
        sem signal.
        sem := nil.
        Processor terminateActive.]! 
hasDynamicListSizeStyle
		"Answer the default value for the dynamic list size style."
	^IsListSizeDynamicDefault = true!
hasDynamicListSizeStyle: aBoolean
		"Set the default value for the dynamic list size style."
	IsListSizeDynamicDefault := aBoolean = true.! 
invisible: ignore
	    "Private - Draw the invisible button"
    #addedByOSI.!  
isPARTSInstalled
		"Answer true if PARTS is installed in the image."
    #addedByOSI.
	^Smalltalk includesKey: #PARTSApplication!  
defaultStyle
        "Private - Answer the default frame style for the receiver."
    | dialogStyle |
    #modifiedByOSI.
    (dialogStyle := self frameStyleFromPStyle) ifNil: [
	    dialogStyle := WsCaption | WsSysmenu | WsPopup | WsVisible.
	    dialogStyle := dialogStyle | ( parent isNil ifTrue: [ WsBorder ] ifFalse: [ DsModalframe ] ) ].
    ^dialogStyle!  
removeLastCurrentEventFor: aWindow using: aBlock
		"Private - Remove the last queued event for aWindow
			for which aBlock evaluated with the event returns true."
	| found |
	#addedByOSI.
	found := false.
	self
		removeLastEventsFor: aWindow
		in: CurrentEvents
		using: [ :eachEvent |
			found not and: [
				found := aBlock value: eachEvent ] ].
	^found!  
chiseledGray
        "Answer the chiseledGray color."
    #addedByOSI.
    ^RGBColorChiseledGray!  
stripMnemonic

    "Added by OSI"
    #addedByOSI.
    ^self reject: [ :c | (c = $~) | (c = $&) ]!
lDU: x r: aSymbol
    "Private"

    left := (x * self dialogUnitWidth) rounded.
    aSymbol == #center ifFalse: [ left := left abs ].
    leftRel  := aSymbol.! 
openAsMDIParent
    "Added by OSI - Open a new instance of the receiver
     as an MDI parent."
    #addedByOSI.
    ^self new openAsMDIParent!   
renderAsObjects

    "Private: Added by Objectshare.
     Should the receiver deliver objects in a drag & drop
     transfer or the string representations of the objects"

    #addedByOSI.
    self obsoleteMethod.
    ^(self propertyAt: #renderAsObjects) ~~ nil!
clientRect
    "Private"

    ^clientRect! 
isModal
    "Added by OSI - is the receiver modal or not"
    #addedByOSI.
    ^(self mainView pStyle includes: #modal) | (self mainView pStyle includes: #sysmodal)!  
contents
    "Added by OSI to speed dialog opening"
    #addedByOSI.
    ^nil! 
basicStyle
        "Private - Answer an Integer with appropriate
         bits for basic control style."
        "Added by OSI: added the WsClipsiblings style
        to support overlapping panes."
    #addedByOSI.
    ^super basicStyle | WsClipsiblings!  
cRDU
    "Private"

    ^(self clientRect leftTop / self dialogUnit) rounded
        rightBottom:
            (self clientRect rightBottom / self dialogUnit) rounded.!  
wbOldVersionSupport
        "Private - Support old versions of WB."
    #addedByOSI.!   
notifyClicked: aParameter
        "Private - the host signaled a clicked event."
	#addedByOSI.
	super notifyClicked: aParameter.
	self selection: true.!  
openWithMyParent: aViewManager
    "Added by OSI - Open a the receiver as a child of
     aViewManager's parent (a sibling)."
    aViewManager mainView wbOwner isNil ifTrue: [
        #addedByOSI.
        ^self open
    ] ifFalse: [
        ^self openWithParent: aViewManager mainView wbOwner
    ]!   
openWithOwnerParent: aViewManager
    "Added by OSI - Open the receiver with aViewManager as Parent
    and owner of all the subpanes. This method can only be used in
    conjunction with the 'Power Views' Add-In."
    | newInstance |
    newInstance := self createViewsFor: self owner: aViewManager.
    newInstance notNil ifTrue: [
        newInstance openViewsWithOwner: aViewManager.
    ] ifFalse: [
        #addedByOSI.
        MessageBox message:
            self class name,' does not have a #createViewsFor:owner: method.'
    ].
    ^newInstance! 
xC
    "Private"

    centerX := true.!
menuNamed: menuName
    "Added by OSI to return the menu named <menuName>"
    #addedByOSI.
    ^self isWBWindow
        ifTrue: [self triggerEvent: #wbNeedsMenuNamed: with: menuName]
        ifFalse: [nil]!  
centerWinText: aString at: aPoint

    "Added by OSI"
    #addedByOSI.
    self winDrawText: aString
        at: aPoint -
            ((font wbStringWidth: aString)
                @ font height // 2)!  
platformIndent
    "Private - Answer the indent for this platform."

    ^0@0! 
drawRectangle: aRectangle

    "Added by OSI since rectangle: fills."

    #addedByOSI.
    self place: aRectangle origin.
    self box: aRectangle corner.!
initWindow
    "Added by OSI"
    #addedByOSI.! 
dragTargetOperations
        "Private - answer the operations that the receiver can accept."
    #addedByOSI.
    ^super dragTargetOperations ifNil: [ self dragTargetOperationsDefault ]! 
initialExtent: e
    "Private"

    initialExtent := e!
fromBytes: aLogFontByteArray
        "Logical fonts from V/Win do not translate. Use the
        System font instead. V/Win32 uses #fromByteArray: instead."
    #addedByOSI.
    ^SysFont!   
left: x relativeTo: aSymbol
    "Private"

    aSymbol == #center
        ifTrue: [ left := x ] ifFalse: [ left := x abs ].
    leftRel  := aSymbol.!
buildWindow: aParentWindow
        "Private - Create the dialog window for the receiver."
    | result |
    style isNil ifTrue: [ style := self getStyle ].
    framingBlock isNil
        ifTrue: [
            rectangle := self initSize.
            framingBlock := rectangle ]
        ifFalse: [

            #modifiedByOSI.

            "Correctly handle the case when parent is nil."
            rectangle := parent isNil
                ifTrue: [ Display boundingBox ]
                ifFalse: [ parent rectangle ].

            "Return dialog units from framing parameters."
            rectangle :=
                framingBlock isFramingParameters
                    ifTrue: [ framingBlock valueToDU: rectangle ]
                    ifFalse: [ framingBlock value: rectangle ] ].

    NotificationManager newWindow: self.
    result := UserLibrary
        createDialogIndirect: OperatingSystem hInstanceExe
        dialogTemplate: ( WinDialogInfo dialogTemplateFor: self ) asParameter
        parent: parent asParameter
        dialogFunction: DialogProcInstance asParameter.
    NotificationManager newWindow: nil.
    result = 0 ifTrue: [ ^self osError ].
    handle := WindowHandle fromInteger: result.
    self
        receiveMessages;
        buildDialogItems.

    #modifiedByOSI.
    owner initWindow.

    PoppedModelessWindows add: handle.
    self isHidden ifFalse: [ self showWindow ].
    self sendDeferredEvent: #subclassRecursively! 
pStyle

    | pStyle |
    pStyle := super pStyle.
    (pStyle includes: #modal) ifFalse: [
        pStyle := (pStyle asSet add: #modal; yourself) asArray.
    ].
    ^pStyle!
createViews
    "Added by OSI - Default #createViews method."
    #addedByOSI.
    ^self createViewsFor: self owner: self! 
wbAddToBack
    "Private - Answer true if the receiver should be added to the back."

    #addedByOSI.
    ^true! 
open: aCoordinator
    "Build and open a window for <aCoordinator>."

    | view |
    #modifiedByOSI.
    view := self constructViewFor: aCoordinator.
    aCoordinator isWBWindow ifTrue: [
        self preInitWindow: view forModel: aCoordinator.
        aCoordinator preInitWindow ].
    view open!  
tDU: y r: aSymbol
    "Private"

    top := (y * self dialogUnitHeight) rounded.
    aSymbol == #center ifFalse: [ top := top abs ].
    topRel := aSymbol.! 
rP: x
    "Private"

    x = 1
        ifTrue: [
            right := 0.
            rightRel := #right ]
        ifFalse: [
            right := x.
            rightRel := #left ].!   
removeSubpaneDynamically: aSubPane
    "Remove a subpane from a window dynamically."
	| id |
    #addedByOSI.
	(id := self children keyAtValue: aSubPane ifAbsent: [nil])
		notNil ifTrue: [ self children removeKey: id ].
    self orderedChildren remove: aSubPane ifAbsent: [ ].
    aSubPane closeDynamically.!   
cRDU: aRect
    "Private"

    | newRect |

    #osiHack.
    "########## Fixes bug regarding system incompatible client rects in OS/2
    aRect bottom >= 10 ifTrue: [
        newRect := aRect left @ (aRect top - (aRect bottom - 14)) rightBottom: aRect right @ 8.
    ] ifFalse: [
        newRect := aRect.
    ].
    ################################################"

	#osiHack.
	"Should #rightBottom: be changed to rightTop: ?"
	"Something seems incorrect in this equation."
    newRect :=
		(aRect leftBottom * self dialogUnit) rounded
			rightBottom: (aRect rightTop * self dialogUnit) rounded.

    self clientRect: newRect.!   
clientRect: e
    "Private"

    clientRect :=  e! 
hasDynamicListSizeStyle
		"Dynamically size the receiver's frame based on the
			number of elements in the receiver's list."
	^isListSizeDynamic = true!   
keyUpInput: aKeyboardInputEvent
        "Private - A key up event was received."
    #addedByOSI.!  
iconFile: aString
    "Added by OSI - supports attatching icons to windows"
    | path |
    #addedByOSI.
    self propertyAt: #iconFile put: aString.
	path := (File exists: aString)
		ifTrue: [ aString ]
		ifFalse: [ File findFileName: aString fileNameLessPath ].
	path notNil ifTrue: [
        self icon: (Icon fromFile: path) ].! 
pStyle

    "Added by OSI"
    #addedByOSI.
    ^self propertyAt: #pStyle!
wmUser99: wparam
with: lparam
    "Added by OSI"

    #addedByOSI.
    ^nil! 
propertyAt: key put: aValue
        "Set the value associated with key
        in the properties dictionary."
	#addedByOSI.
	^views wbPropertyAt: key put: aValue!
when: eventName send: selector to: anObject withArgument: anArgument
    "Added by OSI - Form an action with <anObject> as the receiver, a
     <selector> as the message selector, and <anArgumente> as the last argument
     and append it to the actions list for the event named <eventName>."
    | arguments size |
    #addedByOSI.
    selector isSymbol
        ifFalse: [^self errorBadSelector: selector].
    arguments := Array new: (size := Message numberOfArgumentsFor: selector).
    arguments at: size put: anArgument.
    self
        when: eventName
        evaluate:
            (Message
                receiver: anObject
                selector: selector
                arguments: arguments)! 
initialize
		"Private - Initialize the receiver."
    super initialize.
    disabled := Set new.
    fullList := list.
	isListVisible := false.
	isListSizeDynamic := self class hasDynamicListSizeStyle.!  
wbAddToBack
    "Private - Answer true if the receiver should be added to the back."

    #addedByOSI.
    ^false!
wbProperties: anIdentityDictionary
		"Private - Set the receiver's property dictionary."
	wbProperties := anIdentityDictionary.!
setInitialContents
        "Private - set the receiver's contents and selection."
    self contents: list.
    value notNil ifTrue: [ self setSelection ]! 
initializeAgain
        "Private - Initialize the receiver after a close.
            For PARTS support."
    #addedByOSI.
    views removeAll.
    self
        wbUnlinkPartEvents;
        wbUnlinkPartMessages.!
draw3DButton: aString rect: aRect font: aFont foreColor: fore backColor: back
    "Added by OSI - draw a 3D button"
    | bottom right top left region |
    #addedByOSI.
    bottom := aRect bottom up: 1.
    right := aRect right left: 1.
    top := aRect top down: 1.
    left := aRect left right: 1.
    self
        setBackgroundModeOpaque;
        fill: (aRect insetBy: 3) color: back;
        draw3DButtonRect: aRect;
        foreColor: Color black;
        lineFrom: aRect left @ top to: aRect left @ bottom;
        lineFrom: right @ top to: right @ bottom;
        lineFrom: left @ aRect top to: right @  aRect top;
        lineFrom: left @ bottom to: right @ bottom.
    region := self setClipRect: (aRect insetBy: 4).
    self
        setBackgroundModeTransparent;
        font: (aFont ifNil: [ SysFont "Font fromFont: ButtonFont" ]);
        setTextAlign: TaTop;
        foreColor: fore;
        centerWinText: aString at: aRect center;
        setBackgroundModeOpaque;
        destroyRegion: region.!  
wbPropertyAt: key ifAbsent: aBlock
        "Private - Answer the value associated with key
	        in the properties dictionary; if absent, 
	        answer the result of evaluating aBlock."
    wbProperties isNil ifTrue: [ ^aBlock value ].
    ^wbProperties at: key ifAbsent: aBlock!
bitIsOn: n

    "Added by OSI"

    #addedByOSI.
    ^(self bitAnd: n) = n!  
paneName: aName

    "Added by OSI"
    #addedByOSI.

    ^self setName: aName

    "For compatibility with V/Win, use the following instead:"

    "^self propertyAt: #paneName put: aName"!
wbCreated
		"Answer whether this viewmanager is WindowBuilder generated."
	#addedByOSI.
	^self wbBasicVersion notNil!  
initSize: aRectangle
        "Private - Change the frame of the receiver pane
         to aRectangle."
    super initSize: aRectangle.
    self isSimpleList ifFalse: [
        rectangle := rectangle leftTop extentFromLeftTop:
            rectangle width @ self heightWithoutDropDownList ].!  
Dictionary new
	at: 'jan' put: #Jan;
	at: 'january' put: #Jan;
	at: 'feb' put: #Feb;
	at: 'february' put: #Feb;
	at: 'mar' put: #Mar;
	at: 'march' put: #Mar;
	at: 'apr' put: #Apr;
	at: 'april' put: #Apr;
	at: 'may' put: #May;
	at: 'jun' put: #Jun;
	at: 'june' put: #Jun;
	at: 'jul' put: #Jul;
	at: 'july' put: #Jul;
	at: 'aug' put: #Aug;
	at: 'august' put: #Aug;
	at: 'sep' put: #Sep;
	at: 'september' put: #Sep;
	at: 'oct' put: #Oct;
	at: 'october' put: #Oct;
	at: 'nov' put: #Nov;
	at: 'november' put: #Nov;
	at: 'dec' put: #Dec;
	at: 'december' put: #Dec;
	yourself! 
wbEventTable: anObject
		"Set the window builder event table."
	#addedByOSI.
	^anObject!   
winDrawText: str in: aRect format: f

    "Added by OSI"
    #addedByOSI.
    self allHandles do: [:h |
        UserLibrary
            drawText: h
            text: str asParameter
            length: str size
            rect: (WinRectangle fromRectangle: aRect) asParameter
            format: f asParameter
    ].! 
	"Win32 <--> OS/2 virtual key mapping"

    IdentityDictionary new
        at: 5 put: 8;    "VkBack"
        at: 6 put: 9;    "VkTab"
        at: 9 put: 16;    "VkShift"
        at: 13 put: 19;    "VkPause"
        at: 15 put: 27;    "VkEscape"
        at: 16 put: 32;    "VkSpace"
        at: 17 put: 33;    "VkPrior"
        at: 18 put: 34;    "VkNext"
        at: 19 put: 35;    "VkEnd"
        at: 20 put: 36;    "VkHome"
        at: 21 put: 37;    "VkLeft"
        at: 22 put: 38;    "VkUp"
        at: 23 put: 39;    "VkRight"
        at: 24 put: 40;    "VkDown"
        at: 26 put: 45;    "VkInsert"
        at: 27 put: 46;    "VkDelete"
        at: 29 put: 144;    "VkNumlock"
        at: 32 put: 112;    "VkF1"
        at: 33 put: 113;    "VkF2"
        at: 34 put: 114;    "VkF3"
        at: 35 put: 115;    "VkF4"
        at: 36 put: 116;    "VkF5"
        at: 37 put: 117;    "VkF6"
        at: 38 put: 118;    "VkF7"
        at: 39 put: 119;    "VkF8"
        at: 40 put: 120;    "VkF9"
        at: 41 put: 121;    "VkF10"
        at: 42 put: 122;    "VkF11"
        at: 43 put: 123;    "VkF12"
        at: 44 put: 124;    "VkF13"
        at: 45 put: 125;    "VkF14"
        at: 46 put: 126;    "VkF15"
        at: 47 put: 127;    "VkF16"
        yourself.!
wbEventTable
		"Answer the window builder event table."
	#addedByOSI.
	^nil!   
openRelativeTo: aViewManager offset: aPoint
    "Added by OSI - Open the receiver relative to <aViewManager>."
    | newInstance framingBlock mousePos |
	self wbPreOldVersionSupport.
    newInstance := self createViews.
    newInstance notNil ifTrue: [
        newInstance
            positionRelativeTo: aViewManager offset: aPoint;
            openViews.
    ] ifFalse: [
        #addedByOSI.
        MessageBox message:
            self class name,' does not have a #createViews method or its own #open method.'
    ].
    ^newInstance! 
cancelPushButton
        "Private - Answer the subpane which is the cancel
        push button."
    #addedByOSI.
    ^self propertyAt: #cancelPushButton!
openWithMyParent: aViewManager
    "Added by OSI - Open a new instance of the receiver
     as a child of aViewManager's parent (a sibling)."
    #addedByOSI.
    ^self new openWithMyParent: aViewManager!  
removeView: aView
        "Remove aView from the view manager."
    #addedByOSI.
    views remove: aView ifAbsent: []! 
positionRelativeTo: aViewManager offset: aPoint
    "Added by OSI - Open the receiver relative to <aViewmanager>.
     Call this method from within #preInitWindow"
    | framingBlock leftTop initialExtent |
    #addedByOSI.
    leftTop := aViewManager mainView frameRectangle leftTop.
    framingBlock := self mainView framingBlock.
    initialExtent := framingBlock initialExtent.
    framingBlock
        centerX: false; centerY: false;
        left: (((leftTop x right: aPoint x) max: 0) min: (Display width - initialExtent x))
        relativeTo: #left;
        top: (((Display boundingBox top distanceDown: (leftTop y down: aPoint y)) max: 0) min: (Display height - initialExtent y))
        relativeTo: #top.!  
isDropdownVisible
        "Answer true if the drop down list is visible."
    ^isListVisible!   
cpContents: labelOrFileName
		"Obsolete - Set the contents of the button. If aString is a valid bitmap file name (.BMP),
			the button will display the bitmap. If not, the button will look like a simple
			Button with aString as its label.  Use contents: instead."
    #addedByOSI.
    labelOrFileName isString ifTrue: [
        self propertyAt: #fileName put: labelOrFileName.
        (File exists: labelOrFileName)
            ifTrue: [ bitmap := Bitmap fromFile: labelOrFileName ]
            ifFalse: [
                self removeStyle: self defaultStyle.
                self pushButton.
                super contents: labelOrFileName.
            ]
    ] ifFalse: [
        self contents: labelOrFileName
    ].!   
dialogUnit

    ^self dialogUnitWidth @ self dialogUnitHeight!  
isWBFramingContext
    "Added by OSI - Answer true if the receiver is WB
     framing parameters or a framing context."
    #addedByOSI. "PARTS Support"
    ^true!   
centerText: aString at: aPoint
    "Modified by OSI to ensure that text alignmnent is TaBottom"
        "Display aString centered at aPoint."
    | offset pt alignment |
    #modifiedByOSI.
    "Cache the current alignment"
    (alignment := self getTextAlign) == TaBottom
        ifFalse: [ self setTextAlign: TaBottom ].

    offset := ( ( font stringWidth: aString ) @ ( font height - font descender ) ) // 2.
    pt := aPoint leftAndDown: offset.
    self displayText: aString at: pt.

    "Reset the alignment"
    alignment == TaBottom
        ifFalse: [ self setTextAlign: alignment ].!  
openWithParent: aViewManager
    "Added by OSI - Open the receiver with aViewManager as Parent."
    | newInstance |
    self wbPreOldVersionSupport.
    newInstance := self createViews.
    newInstance notNil ifTrue: [
        newInstance openViewsWithOwner: aViewManager.
    ] ifFalse: [
        #addedByOSI.
        MessageBox message:
            self class name,' does not have a #createViews method.'
    ].
    ^newInstance!  
definedIn
        "Answer the selector of the creation method."
	#addedByOSI.
    ^self propertyAt: #definedIn!
wbBasicVersion
		"Private - Answer the window builder version."
	#addedByOSI.
	^nil!   
wbCreated
    "Added by OSI - Was the receiver created by WindowBuilder Pro?"
    #addedByOSI.
    ^false! 
dynamicListSize
		"Private - Answer the # of elements in the receiver's list."
	^super contents size max: 3!
open
    "Open the dialog box modal to the
     current active window."
    ^ self openModal: nil! 
eventTableForEdit
        "Private - answer the table of event handlers for the receiver.
        Allocate if necessary so that updates can be stored."
	#addedByOSI.
	^views wbEventTable ifNil: [
		views wbEventTable: self eventTableCreate ]!   
basicKeyboardInput: aKeyboardInputEvent
        "Private - keyboard input was received."
        "Provide support for Escape key"
        "Provide Enter key support for all WB windows including Dialogs."
    | button |
    #modifiedByOSI.
    self owner isWBWindow ifTrue: [
        aKeyboardInputEvent virtualKey == EscapeKey ifTrue: [
            (button := self mainWindow cancelPushButton ) notNil ifTrue: [
                button disabled not ifTrue: [
                    button click ]]].
        "aKeyboardInputEvent character == Cr ifTrue: [
            (button := self mainWindow defaultPushButton) notNil ifTrue: [
                button disabled not ifTrue: [
                    button click ]]]"].
    ^super basicKeyboardInput: aKeyboardInputEvent!
initialExtent
    "Private"

    ^initialExtent!   
forkListHiddenWatcherPriority
		"Answer the process priority for the watcher."
	^Processor backgroundPriority!  
wbPropertyAt: key put: aValue
        "Private - Set the value associated with key
	        in the properties dictionary."
    wbProperties isNil ifTrue: [ wbProperties := IdentityDictionary new ].
    aValue isNil ifTrue: [ ^wbProperties removeKey: key ifAbsent: [ ] ].
    ^wbProperties at: key put: aValue!
cpContents
    	"Obsolete - Return the label of the button or the file name in which its bitmap is stored.
			Use contents instead."
    | contents |
    #addedByOSI.
    contents := self propertyAt: #fileName.
    ^contents isNil
        ifTrue: [ self contents ]
        ifFalse: [ contents ]!   
setBackgroundModeOpaque
		"Set the background mode."
	#addedByOSI.
	self setBackgroundMode:  2. "(GraphicsConstants at: 'BackgroundMixOpaque')"
! 
oldDialogUnitHeight

    ^SysFont height / 32!  
propertyAt: key
        "Answer the value associated with key
        in the properties dictionary."
	#addedByOSI.
	^views wbPropertyAt: key! 
forkListHiddenWatcher
		"Private - OS/2 does not notify us when the the drop down list
			is hidden again, so fork a process to watch for the list being hidden."
	| done oldFrame |
	done := false.
	oldFrame := self rectangle.
	[	[	[	self isHandleOk
					ifTrue: [
						self isDropdownVisible ifFalse: [
							oldFrame = self rectangle ifFalse: [
								self superWindow invalidateRect: oldFrame ].
							self resizeWithoutDropDownList.
							done := true ] ]
					ifFalse: [ done := true ].
			] evaluateWithoutInterrupts.
			done
		] whileFalse: [ Processor yield ].
	] forkAt: self class forkListHiddenWatcherPriority.!   
maxWindowSize
    "Added by OSI"
    #addedByOSI.
    ^nil!
activeWindow

    "Added by OSI to support keyboard translation for MDI windows"
        "Answer the active toppane."

    | win newWin |
    #addedByOSI.
    (win := self activeMainWindow) isMDIFrame ifTrue: [
        (newWin := win mdiGetActive) notNil ifTrue: [
            ^newWin
        ].
    ].

    ^win!
getPopupMenu

    "Added by OSI"
    #addedByOSI.
    ^popup! 
buildWindow
        "Private - Create the host window for the receiver."
		"Modified by OSI to provide wbOwner support."
    | myRealRectangle focusPane |
	#modifiedByOSI.
    style isNil ifTrue: [ style := self getStyle ].
    NotificationManager newWindow notNil ifTrue: [
        NotificationManager newWindow: nil.
        ^nil ].   "A Walkback came up during creation of window"
    NotificationManager newWindow: self.

    " clear rectangle during build to force sizeChanged: to resize children "
    myRealRectangle := rectangle.
    rectangle := 0@0 extent: 0@0.

    self create: self windowClass
        title: label
        style: ( style bitAnd: ( WsVisible bitXor: 16rFFFFFFFF ) )  "create hidden, show after validate"
        rectangle: rectangle
        parent: parent.
    NotificationManager newWindow: nil.
	self owner isWBWindow ifFalse: [
	    parent notNil ifTrue: [
			UserLibrary setParent: self asParameter to: parent asParameter ] ].

    self isHandleOk ifFalse: [ self outOfMemory. ^nil ].

    self systemMenuHandle.

    "menu and subpanes created in the wmCreate message process"

    "Set the size of the frame window."
    self handle
        setWindowPos: nil
        rectangle: myRealRectangle
        fs: SwpNozorder.

    focusPane := self subPaneWithFocus.
    self activeTextPane: self searchForDefaultTextPane.
    focusPane notNil ifTrue: [ focusPane setFocus ].
    self subPaneWithFocus: focusPane! 
open
    "Added by OSI - Open the receiver."
    | newInstance |
	self wbPreOldVersionSupport.
    newInstance := self createViewsOnce.
    newInstance notNil ifTrue: [
        newInstance openViewsOnce.
    ] ifFalse: [
        #addedByOSI.
        MessageBox message:
            self class name,' does not have a #createViews method or its own #open method.'
    ].
    ^newInstance!
horizontalScrollMaxRange
        "Private - Answer the horizontal scrollbar's max range"
    | maxPos |
    #addedByOSI.
    ( UserLibrary
        getScrollRange: self handle asParameter
        bar: SbHorz
        lpMinPos: ( ExternalBuffer new: 2 ) asParameter
        lpMaxPos: ( maxPos := ExternalBuffer new: 2 ) asParameter )
            ifFalse: [ ^self osError ].
    ^maxPos shortAtOffset: 0!
addTabInfoFor: aPane
        "Private - Add tabbing information for aPane to
        the receiver."
    aPane canTab
        ifTrue: [self orderedChildren add: aPane].
    #modifiedByOSI.
    "Save the child order information."
    self owner isWBWindow ifTrue: [
        (self
            propertyAt: #childrenInBuildOrder
            ifAbsentPut: [self childrenInBuildOrder select: [:child |
                child isMDIClient]]) add: aPane].!   
topBottomUnit
        "Answer the signed unit from top to bottom."
	#addedByOSI.
    ^1!   
open
    "Added by OSI - Open a new instance of the receiver."
    #addedByOSI.
    ^self new open!
dateArray: aString
        "Added by OSI - Answer an array containg the
         the elements of Date specified by aString.  aString
         must represent a date in one of three formats:
         'Dec 31, 1989' or '31 Dec 1989' or '12/31/89'
         but the delimiters between the month, day and
         year can be any sequence of non-alphanumeric
         characters. The array is ordered #( day Month Year )"
    | aStream word1 word2 month year |
    #addedByOSI.
    aStream := aString asStream.
    word1 := aStream nextWord.
    word1 isNil ifTrue: [ ^#(0 0 0)].
    word1 := word1 asLowerCase.
    word2 := aStream nextWord.
    word2 isNil ifTrue: [ ^#(0 0 0)].
    word2 := word2 asLowerCase.
    year := aStream nextWord.
    year isNil ifTrue: [ ^#(0 0 0)].
    year := year asLowerCase asInteger.
    year < 100 ifTrue: [
        year < 60 ifTrue: [
            year := year + 2000
        ] ifFalse: [
            year := year + 1900
        ].
    ].

    word1 first isLetter ifTrue: [ " 'jan 1 1990' style"
        month := MonthNames at: (self monthStrings at: word1 ifAbsent: [ 0 ]) ifAbsent: [ 0 ].
        ^Array
            with: word2 asInteger
            with: month
            with: year
    ].

    word2 first isLetter ifTrue: [ " '1 jan 1990' style"
        month := MonthNames at: (self monthStrings at: word2 ifAbsent: [ 0 ]) ifAbsent: [ 0 ].
        ^Array
            with: word1 asInteger
            with: month
            with: year
    ].

    " must be '1/20/90' or 1/20/1990' style"
    ^Array
        with: word2 asInteger
        with: word1 asInteger
        with: year!
isATabStopPrim
        "Private - Answer true if the receiver is a tabstop"
    #addedByOSI.
    ^self hasStyle: WsTabstop!
notifyListHidden: aParameter
        "Private - the host signaled that the list was closed up."
    isListVisible := false.!
isFramingParameters
    "Answer true if the receiver is FramingParameters."
		#addedByOSI.
    ^false! 
centeredOnMouse
    "Added by OSI - Open the receiver centered over the mouse.
     Call this method from within #preInitWindow"
    | framingBlock mousePos initialExtent |
    #addedByOSI.
    mousePos := CursorManager cursorPosition.
    framingBlock := self mainView framingBlock.
    initialExtent := framingBlock initialExtent.
    framingBlock
        centerX: false; centerY: false;
        left: (((mousePos x left: framingBlock initialExtent x // 2) max: 0) min: (Display width - initialExtent x))
        relativeTo: #left;
        top: (((Display boundingBox top distanceDown: (mousePos y up: framingBlock initialExtent y // 2)) max: 0) min: (Display height - initialExtent y))
        relativeTo: #top.!  
close
        "Close all the views.
            For PARTS support, close views only once."
    #modifiedByOSI.
    self isWBWindow
        ifFalse: [
            views do: [:v | v close ] ]
        ifTrue: [
            views do: [:v |
                v isHandleOk ifTrue: [
                    v close ] ].
            self initializeAgain ].!   
asProperNoun
    "Added by OSI. Answer a String containing the receiver
     with alphabetic characters in mixed proper case."
    | answer size index aCharacter |
    #addedByOSI.
    size := self size.
    answer := String new: size.
    index := 1.
    [index <= size]
        whileTrue: [
            aCharacter := self at: index.
            (index == 1 or: [
            (self at: index - 1) isWhitespace and: [
            aCharacter isLowerCase ]])
                ifTrue: [aCharacter := aCharacter asUpperCase].
            answer at: index put: aCharacter.
            index := index + 1].
    ^answer! 
setOwner: aWindow

	"Added by OSI"
	#addedByOSI.
	self mainView setOwner: aWindow!
monthNameAbbreviated
        "Answer a Symbol representing the
         month name of the receiver."
    ^self class nameOfMonthAbbreviated: self monthIndex!  
paneNamed: paneName
    "Added by OSI to return the pane named <paneName>"
    #addedByOSI.
    ^self isWBWindow
        ifTrue: [self triggerEvent: #wbNeedsPaneNamed: with: paneName]
        ifFalse: [nil]!  
validate
        "Private - The host window for the receiver was
         just created or recreated."
    self isDefaultPushButton
        ifTrue: [ self mainWindow defaultPushButton: self ].

    #modifiedByOSI.
    self isCancelPushButton
        ifTrue: [ self mainWindow cancelPushButton: self ].

    super validate!   
wbEventTable: anIdentityDictionary
		"Private - Set the event table."
	^wbEventTable := anIdentityDictionary!   
wbAddToBack
    "Private - Answer true if the receiver should be added to the back."

    #addedByOSI.
    ^true! 
topDialogUnits
    "Private"

    ^(top / self dialogUnitHeight) rounded!  
centerY
    "Private"

    ^centerY!   
=> anObject
        "Answer a new instance of an Association
        with key the receiver and value anObject."

    "** Courtesy OTI (added)"

	#addedByOSI.
    ^Association key: self value: anObject!  
openCenteredOnMouse
    "Added by OSI - Open the receiver centered over the mouse."
    | newInstance framingBlock mousePos |
	self wbPreOldVersionSupport.
    newInstance := self createViews.
    newInstance notNil ifTrue: [
        newInstance
            centeredOnMouse;
            openViews.
    ] ifFalse: [
        #addedByOSI.
        MessageBox message:
            self class name,' does not have a #createViews method or its own #open method.'
    ].
    ^newInstance!
setScrollRanges
        "Private - Set the ranges for the horizontal and vertical
          scroll bars."
    | rangeRect minHorz maxHorz minVert maxVert |
    #addedByOSI.
    rangeRect := self scrollingRectangle
        insetBy: (self rectangle extent // 2).
    minHorz := rangeRect left.
    maxHorz := rangeRect right.
    minVert := rangeRect top.
    maxVert := rangeRect bottom.
    (self style bitAnd: WsHscroll) = 0
        ifTrue: [minHorz := maxHorz := 0].
    (self style bitAnd: WsVscroll) = 0
        ifTrue: [minVert := maxVert := 0].
    ( UserLibrary
        setScrollRange: self asParameter
        bar: SbHorz
        min: minHorz
        max: maxHorz
        redraw: false )
            ifFalse: [ ^self osError ].
    ( UserLibrary
        setScrollRange: self asParameter
        bar: SbVert
        min: minVert
        max: maxVert
        redraw: false )
            ifFalse: [ ^self osError ]!  
asByteArray
        "Added by OSI - Answer a ByteArray whose contents are the
         bytes of the receiver."
    | byteArray index |
    #addedByOSI.
    index := 0.
    byteArray := ByteArray new: self size.
    self do: [ :each | byteArray at: (index := index + 1) put: each ].
    ^byteArray! 
validateAll: aCollection
        "Validate all bitmaps in aCollection...
            Faster than validating one bitmap at a time."
    | moduleNames moduleHandles eachModuleName |
    #addedByOSI.
    moduleNames := Set new.
    moduleHandles := OrderedCollection new.
    aCollection do: [ :eachBitmap |
        eachBitmap isBitmap ifTrue: [
            (eachModuleName := eachBitmap moduleNameIfArchived) notNil ifTrue: [
                (moduleNames includes: eachModuleName) ifFalse: [
                    moduleNames add: eachModuleName.
                    moduleHandles add: (KernelLibrary loadLibrary: eachModuleName) ] ].
            eachBitmap validate ] ].
    moduleHandles do: [ :each | KernelLibrary freeLibrary: each ].! 
frameStyleFromPStyle
    "Added by OSI - Reimplemented by subclasses"
    #addedByOSI.
    ^nil!   
fill: aRectangle bitmap: aBitmap

    "Added by OSI"

    | oldBrush newBrush |
    #addedByOSI.
    newBrush := GDILibrary createPatternBrush: aBitmap handle.

    oldBrush := self selectObject: newBrush.
    self patternFill: aRectangle
        rule: Patcopy.
    self selectObject: oldBrush.
    self deleteObject: newBrush!   
openViews
    "Added by OSI"
    #addedByOSI.
    ^self openWindow!
winDrawText: str at: aPoint

    "Added by OSI"
    #addedByOSI.
    self winDrawText: str in: (aPoint extentFromLeftTop: 30000@30000) format: 0.!
wbLinkPartEvents
		"Private - Link the parts events from the subpanes to the receiver."
	#addedByOSI.!  
bitmapHandle
    "Added by OSI - Answer the handle of the receiver without
     bringing it to life. This fix was provided by Digitalk"
    #addedByOSI.
    ^bitmapHandle!   
isPARTSRectangle
		"Answer true because the receiver will sort-of act like a parts rectangle.
			PARTS Support - allows SubPane>>initialRectangleFor: to work because Parts overwrites it"
	^true! 
rightDialogUnits
    "Private"

    ^(right / self dialogUnitWidth) rounded!   
draw3DRect: aRect
depth: depth
style: style
    "Added by OSI"

    | back fore l r t b |

    #addedByOSI.
    style == #outline
        ifTrue:
            [^self
                foreColor: Color white;
                drawRectangle: (Rectangle leftTop: (aRect leftTop rightAndDown: 1) rightBottom:
aRect rightBottom);
                foreColor: Color buttonShadow;
                lineFrom: (aRect leftTop down: 1) to: aRect leftBottom;
                lineFrom: (aRect leftTop down: 1) to: (aRect rightTop down: 1);
                lineFrom: (aRect rightBottom leftAndUp: 2 @ 1) to: (aRect left right: 2) @ (aRect
bottom up: 1);
                lineFrom: (aRect rightBottom leftAndUp: 2) to: (aRect right left: 2) @ (aRect top
down: 3)].
    style = #in
        ifTrue:
            [back := Color white.
            fore := Color buttonShadow.
            ]
        ifFalse:
            [back := Color buttonShadow.
            fore := Color white.
            ].
    1 to: depth
        do:
            [:i |
			l := aRect left right: i.
			r := aRect right left: i + 1.
			t := aRect top down: i + Rectangle leftTopUnit y.
			b := aRect bottom up: i + Rectangle rightBottomUnit y.
			self
                foreColor: back;
                lineFrom: l @ b to: r @ b;
                lineFrom: r @ t to: r @ b;
                foreColor: fore;
                lineFrom: l @ t to: l @ b;
                lineFrom: l @ t to: r @ t.
			].!   
openViewsWithOwner: aViewManager
      "Added by OSI"
    #addedByOSI.
    self
        parent: aViewManager;
        openViews;
        setOwner: aViewManager.!   
openWindow
    "Added by OSI"
    #addedByOSI.! 
winDrawText: aString in: aRect justification: just
        "Added by OSI"
    #addedByOSI.
    ^self winDrawText: aString in: aRect format: just!  
verticalScrollMaxRange
        "Private - Answer the vertical scrollbar's max range"
    | maxPos |
    #addedByOSI.
    ( UserLibrary
        getScrollRange: self handle asParameter
        bar: SbVert
        lpMinPos: ( ExternalBuffer new: 2 ) asParameter
        lpMaxPos: ( maxPos := ExternalBuffer new: 2 ) asParameter )
            ifFalse: [ ^self osError ].
    ^maxPos shortAtOffset: 0!
removeDynamically
    "Added by OSI - Remove a subpane from a window dynamically"
    #addedByOSI.
    self superWindow removeSubpaneDynamically: self.!   
distanceDown: aNumber
        "Answer the distance between the receiver and aNumber
            where right and down are positive."
    #addedByOSI.
    ^(aNumber - self) * Rectangle topBottomUnit! 
	"Win32 <--> OS/2 virtual key mapping"

	| answer |
	answer := IdentityDictionary new.
	PMToWinKeyMap
		associationsDo: [ :each |
			answer
				at: each value
				put: each key ].
	answer! 
removeTextChangedEvent
		"Remove the #textChanged event from the event queue."
	#addedByOSI.
	Notifier removeLastCurrentEventFor: self using: [ :eachEvent |
		eachEvent selector == #asyncControlEvent:with:
			and: [ eachEvent arguments first = EnChange ] ].!   
cancelPushButton: aButton
        "Private - Set the subpane which is the cancel push button."
    #addedByOSI.
    ^self propertyAt: #cancelPushButton put: aButton!  
removeFirstEventsFor: aWindow in: aQueue using: aBlock
		"Private - Remove queued events for aWindow.
			Use aBlock to determine which events to remove."
	| eachEventIndex eachEvent |
	#addedByOSI.
	[	eachEventIndex := 1.
		[ eachEventIndex <= aQueue size ] whileTrue: [
			((eachEvent := aQueue at: eachEventIndex) receiver == aWindow | aWindow isNil
				and: [ aBlock value: eachEvent ])
					ifTrue: [ aQueue removeIndex: eachEventIndex ]
					ifFalse: [ eachEventIndex := eachEventIndex + 1 ] ].
	] evaluateWithoutInterrupts!  
topPaneClass
    "Private - Answer the defalut top pane class."
    ^WBDialogTopPane!   
wbCreated
        "Answer whether this viewmanager is WindowBuilder generated."
    #addedByOSI.
    ^self wbBasicVersion notNil!  
purgeUnusedBitmaps
    "Modified by OSI - provide Digitalk fix"
        "Private - Purge unused bitmaps from the system."
    | handles all bitmaps |
    #modifiedByOSI.
    all := BitmapHandleTable keys.
    BitmapHandleTable := Dictionary new.
    bitmaps := Bitmap allInstances.
    handles := bitmaps collect: [ :each | each bitmapHandle ].
    GDILibrary selectObject: MemoryContext with: DefaultBitmap.
    all do: [ :each |
        ( each notNil and: [ ( handles includes: each ) not ] ) ifTrue: [
            ( GDILibrary deleteObject: each ) ifFalse: [ self osWarning ] ] ].
    bitmaps do: [ :each |
        each bitmapHandle notNil ifTrue: [
            BitmapHandleTable at: each bitmapHandle put: each ] ]!
yCentered
    "Private"

    self yC!  
frameStyleFromPStyle

    "Added by OSI."

    | s pStyle |

    (pStyle := self pStyle) isNil ifTrue: [
        #addedByOSI.
        ^nil
    ].
    s := DsNoidlemsg  | WsPopup.

    (pStyle includes: #sysmenu) ifTrue: [
        s := s | WsSysmenu.
    ].
    (pStyle includes: #titlebar) ifTrue: [
        s := s | WsCaption.
    ].
    (pStyle includes: #sysmodal) ifTrue: [
        s := s | DsSysmodal | DsModalframe.
    ].
    (pStyle includes: #modal) ifTrue: [
        s := s | DsModalframe.
    ] ifFalse: [
        s := s | WsBorder.
    ].

    ^s!
openModal: anOwner
        "Open the dialog box modal to the
         current active window."
    | cursor |

    Processor currentProcessIsRecursive ifTrue: [
        self error: 'Cannot do modal dialog during recursion.'].

    cursor := Cursor.
    CursorManager execute change.
    dialogOwner := anOwner ifNil: [ Notifier activeMainWindow ].

    "Disable parent now to ensure that there are no further activities at parent."
    dialogOwner isWindow ifTrue:[ dialogOwner disable ].
	self setOwner: dialogOwner.

    super openWindow.
    self event: #opened.
    CursorManager normal change.
    Processor currentProcessIsRecursive ifFalse: [ self processInput ].
    cursor change.! 
leftDialogUnits
    "Private"

    ^(left / self dialogUnitWidth) rounded! 
rightProportional: x
    "Private"

    self rP: x!
execute: aBlock withTopPane: aTopPaneClass
    "Added by OSI to support openning windows as MDI
     parents and children. MDI support must be loaded."
    | result |
    #addedByOSI.
    Smalltalk at: #TopPaneClass put: aTopPaneClass.
    result := aBlock value.
    Smalltalk removeKey: #TopPaneClass.
    ^result!  
wmKeydown: wordInteger with: longInteger
        "Private - Process the key down message.  WM_KEYDOWN is generated when
        a key is pressed while the ALT key IS NOT DOWN."
    | event |
    self needsKeyDownInput ifTrue: [
        #addedByOSI.
        (event := KeyboardInputEvent keyDownFromWmKeydown: wordInteger with: longInteger) notNil ifTrue: [
            self sendInputEvent: #keyDownInput: with: event ] ].
    ^super wmKeydown: wordInteger with: longInteger! 
bottomProportional: y
    "Private"

    self bP: y!   
resizeWithDropDownList
        "Private - Resize the receiver to include the drop down list."
    isListVisible := true.
    rectangle := self framingRectangleFor: self parent rectangle.
    self hasDynamicListSizeStyle ifTrue: [
        rectangle := rectangle leftTop rightBottom: (
            rectangle right @ self dynamicListBottom ) ].
    rectangle extent: (rectangle extent max: 0@0).
    self resizeWindow.
!
isWBFramingContext
    "Added by OSI - Answer true if the receiver is WB
     framing parameters or a framing context."
    #addedByOSI. "PARTS Support"
    ^false!  
yC
    "Private"

    centerY := true.!
isWBFramingContext
		"Answer true if the receiver is WB framing parameters or a framing context.
		PARTS Support"
    ^true!   
wbReleaseEventTable
	    "Private"
	    "Break all connections to event handlers."
	#addedByOSI.!  
paneName

    "Added by OSI"
    #addedByOSI.

    ^self propertyAt: #myOwnName ifAbsent: [ '' ].

    "For compatibility with V/Win, use the following instead:"

    "^self propertyAt: #paneName"!
getDefaultDragObjects

    "Private: Added by Objectshare."

    | dragObjects |
    #addedByOSI.
    #obsoleteMethod.
    (dragObjects := self propertyAt: #defaultDragObjects) isNil
        ifTrue: [^nil].
    self renderAsObjects
        ifFalse:
            [dragObjects := dragObjects
                collect:
                    [:each |
                    each asString]].
    ^dragObjects!  
dynamicListHeight
        "Answer the dynamic list height."
    | ef |
    ^self dynamicListSize * self font height + 10 + (
        (ef := self entryField) notNil
            ifTrue: [ ef rectangle height ]
            ifFalse: [ self font height + 8 ] )!
defaultStyle
        "Private - Answer the default frame style for the receiver."
    #modifiedByOSI.
    ^self frameStyleFromPStyle
        ifNil: [
    		WsMaximizebox |
	        WsMinimizebox |
	        WsThickframe |
	        WsSysmenu |
	        WsCaption |
	        WsVisible ]!
indent: anIndent
    "Private"

    indent := anIndent.!   
leftRel
    "Private"

    ^leftRel!   
enableItem: anItem

    disabled remove: anItem ifAbsent: [].

    self buildList.!   
newDialogUnitWidth

    ^WindowDialog dialogUnit x  / 4!
removeAllItemsDynamically
		"Delete all menu items."
    #addedByOSI.
     self deleteAll.

     "#### Old Code ####
    items reverseDo: [ :item |
        self removeItemDynamically: item contents ].
    items := OrderedCollection new.
    accel := OrderedCollection new.
     ################"!
stringExtent: aString
        "Answer the extent of aString using the receiver font."
    #addedByOSI.
    ^(self wbStringWidth: aString) @ self height!   
displayHelp: ignore
    #addedByOSI.!
asTime
    "Answer the receiver as an instance of Time."

	#addedByOSI.
    ^self!
centerX
    "Private"

    ^centerX!   
findOrPromptFileName: fileName filters: filterCollection
       "Answer the full path of the file named fileName.
		filterCollection is a collection of associations whose
		keys are the filter (e.g. '*.*') and values are the filter
		descriptions (e.g. 'All files (*.*)')."

	#addedByOSI.
	^self
		findOrPromptFileName: fileName
		filters: filterCollection
		in: #( )!
openWithOwner: aViewManager
    "Added by OSI - Open the receiver with aViewManager as owner of
    all the subpanes (the target of the #when:perform: messages). This
    method can only be used in conjunction with the 'Power Views' Add-In."
    | newInstance |
    newInstance := self createViewsFor: self owner: aViewManager.
    newInstance notNil ifTrue: [
        newInstance openViews; setOwner: aViewManager.
    ] ifFalse: [
        #addedByOSI.
        MessageBox message:
            self class name,' does not have a #createViewsFor:owner: method.'
    ].
    ^newInstance! 
selectorOf: id
        "Private - Answer the selector for the item whose id is id."
        "Modified by OSI to prevent walkback when id is out of bounds."
    #modifiedByOSI.
    (id \\ 256 between: 1 and: items size) ifFalse: [ ^nil ].
    ^( items at: ( id \\ 256 ) ) selector! 
wbPreOldVersionSupport
        "Private - Support old versions of WB."
    #addedByOSI.!
dragTargetFormats
        "Private - answer the formats of drag objects that the receiver will accept."
    #addedByOSI.
    ^super dragTargetFormats ifNil: [ self dragTargetFormatsDefault ]!
hasTransparentStyle
        "Answer whether the receiver has the transparent style."
    #addedByOSI.
    ^(self propertyAt: #transparent) = true! 
distanceRight: aNumber
        "Answer the distance between the receiver and aNumber
            where right and down are positive."
    #addedByOSI.
    ^(aNumber - self) * Rectangle leftRightUnit!
selectedItem
        "Answer the item selected in the receiver."
    ( self getSelection ) isNil
        ifTrue: [ ^nil ]
        ifFalse: [ ^list at: value ]!   
invisible
    "Makes the button invisible (no label or bitmap). This is useful
		for creating 'sense regions' on top of other visual objects.
		For this to work properly, exclude the widget from the tab order."
    #addedByOSI.
    drawSelector := #invisible:.!
wbPaneNamed: aPaneName

    "Added by OSI"

    | pane |

    #addedByOSI.
    self paneName = aPaneName ifTrue: [ ^self ].

    children notNil ifTrue: [
        children do: [ :c |
            (pane := c wbPaneNamed: aPaneName) notNil ifTrue: [
                ^pane ] ] ].

    ^nil!  
childrenInBuildOrder
        "Private - answer the child panes in the order they should be built."
	#modifiedByOSI.
	"If there is a build order defined then answer it,
		else answer the default ordering."
	^self propertyAt: #childrenInBuildOrder ifAbsent: [
	    self orderedChildren , self unorderedChildren ]! 
synchronousNotifications
        "Private - answer a Dictionary mapping between host control
        notification codes and corresponding Smalltalk event notifications."
	^Dictionary new!
distanceRightAndDown: aPoint
        "Answer the distance between the receiver and aPoint
            where right and down are positive."
    #addedByOSI.
    ^(x distanceRight: aPoint x) @ (y distanceDown: aPoint y)! 
isATabStop
        "Private - Answer true if the receiver is a tabstop"

    "Modified by OSI - Digitalk assumes that tabStops are default on,
        while OSI assumes that tabStops are default off."
    #modifiedByOSI.
    ^true ~= (
        self
            propertyAt: #noTabStop
            ifAbsent: [ self owner isWBWindow ] )!   
wbUnlinkPartEvents
        "Private - Unlink the parts events from the subpanes to the receiver."
    #addedByOSI.! 
printOn: aStream
        "Append a representation of the receiver to aStream."

    centerX ifTrue: [
        aStream nextPutAll: '<xCentered>'; cr.
    ] ifFalse: [
        aStream nextPutAll: 'L:  <', left asString, ',', leftRel asString, '>'; cr.
        aStream nextPutAll: 'R: <', right asString, ',', rightRel asString, '>'; cr.
    ].

    centerY ifTrue: [
        aStream nextPutAll: '<yCentered>'; cr.
    ] ifFalse: [
        aStream nextPutAll: 'T: <', top asString, ',', topRel asString, '>'; cr.
        aStream nextPutAll: 'B: <', bottom asString, ',', bottomRel asString, '>'; cr.
    ].

    aStream nextPutAll: 'indent: ', indent asString; cr.
    aStream nextPutAll: 'clientRect: ', clientRect asString; cr.
    aStream nextPutAll: 'initialExtent: ', initialExtent asString; cr.! 
dialogUnit
		"Private - Answer the receiver's dialog units."
    ^self dialogUnitWidth @ self dialogUnitHeight! 
needsKeyDownInput
        "Private - Answer true if the receiver processes key-down events."
    #addedByOSI.
    ^false!  
draw3DButton: aString rect: aRect font: aFont
    "Added by OSI - draw a 3D button"
    #addedByOSI.
    self draw3DButton: aString rect: aRect font: aFont
        foreColor: Color black
        backColor: Color buttonFace!  
openWindow
    "Open the dialog box modal to the
     current active window."
    ^ self openModal: nil!   
topRel
    "Private"

    ^topRel! 
removeFirstCurrentEvent: anEventSelector for: aWindow
		"Private - Remove the first queued event for aWindow
			having the specified event selector."
	#addedByOSI.
	self
		removeFirstCurrentEventFor: self
		using: [ :eachEvent | eachEvent selector = anEventSelector ].!   
tabStop
		"Modified by OSI to set the tabstop style. Use #getTabStop to
			retrieve the tabStop without setting the tabstop style"
    #modifiedByOSI.
    super tabStop.

		"Answer tabInterval in number of pels."
    ^self propertyAt: #tabStop!   
tP: y
    "Private"

    y = 1
        ifTrue: [
            top := 0.
            topRel := #bottom ]
        ifFalse: [
        top := y.
        topRel := #top ].!   
isFramingParameters
		"Answer true if the receiver is FramingParameters."
    ^true!
wmCommand: wordInteger with: longInteger
        "Private - Process the command message."
    | control answer |
    ( self helpModeCommand: wordInteger ) notNil ifTrue: [ ^0 ].
    ( longInteger > 0 or: [ self isDialogTopPane ] )
        ifTrue: [                    "= 0 for 'enter' key"
            ( wordInteger == Idcancel and: [ longInteger == 0 ] ) ifTrue: [ self sendInputEvent: #close. ^nil ].  "cancel"
            control :=  self childAtId: wordInteger lowWord.
            control notNil
                ifTrue: [

                    "Modified by OSI to return an integer if desired."
                    #modifiedByOSI.
                    answer := control syncControlEvent: wordInteger highWord with: longInteger.
                    answer isInteger ifFalse: [ answer := nil ].

                ] ]
        ifFalse: [
            self sendInputEvent: #performMenuItem:
                with: wordInteger lowWord ].
    ^answer!  
bottom
    "Private"

    ^bottom! 
iconFile
    "Supports attatching icons to windows"
    #addedByOSI.
    ^self propertyAt: #iconFile!  
mainView
    "Added by OSI to return the receiver's view"
    #addedByOSI.
    ^self isWBWindow
        ifTrue: [self triggerEvent: #wbNeedsView]
        ifFalse: [nil]!
bottomDialogUnits
	    "Private - Answer the bottom dialog units"
    ^(bottom / self dialogUnitHeight) rounded!
wbPropertyAt: key 
        "Private - Answer the value associated with key
	        in the properties dictionary."
    wbProperties isNil ifTrue: [ ^nil ].
    ^wbProperties at: key ifAbsent: [ nil ]!  
draw3DRect: aRect leftTopColor: aLeftTopColor rightBottomColor: aRightBottomColor

    "Added by OSI"
    | theHandle leftRight1 leftRight2 rightLeft2 rightLeft3
	topDown1 topDown2 bottomUp2 bottomUp3 oldColor |
    #addedByOSI.
    theHandle := self handle.
    leftRight1 := aRect left right: 1.
    leftRight2 := aRect left right: 2.
    rightLeft2 := aRect right left: 2.
    rightLeft3 := aRect right left: 3.
    topDown1 := aRect top down: 1 + Rectangle leftTopUnit y.
    topDown2 := topDown1 down: 1.
    bottomUp2 := aRect bottom up: 1 + Rectangle rightBottomUnit y.
    bottomUp3 := bottomUp2 up: 1.
	oldColor := self foreColor.

    self
        foreColor: aLeftTopColor;
        quickLineFrom: leftRight1 @ topDown1 to: rightLeft2 @ topDown1 using: theHandle;
        "quickLineFrom: leftRight1 @ topDown2 to: rightLeft3 @ topDown2 using: theHandle;"
        quickLineFrom: leftRight1 @ topDown1 to: leftRight1 @ bottomUp2 using: theHandle;
        "quickLineFrom: leftRight2 @ topDown1 to: leftRight2 @ bottomUp3 using: theHandle;"
        foreColor: aRightBottomColor;
        quickLineFrom: leftRight1 @ bottomUp2 to: (aRect right left: 1) @ bottomUp2 using: theHandle;
        "quickLineFrom: leftRight2 @ bottomUp3 to: rightLeft2 @ bottomUp3 using: theHandle;"
        quickLineFrom: rightLeft2 @ topDown1 to: rightLeft2 @ (aRect bottom up: 1) using: theHandle;
        "quickLineFrom: rightLeft3 @ topDown2 to: rightLeft3 @ bottomUp2 using: theHandle;"
        foreColor: oldColor.! 
drawFocusRect: aRect

    "Added by OSI"
    #addedByOSI.
    self allHandles do: [: h |
        UserLibrary
            drawFocusRect: h
            rectangle: aRect asParameter
    ].!
bottom: y relativeTo: aSymbol
    "Private"

    aSymbol == #center
        ifTrue: [ bottom := y ] ifFalse: [ bottom := y abs ].
    bottomRel := aSymbol.! 
resize: aRectangle
        "Private - Change the frame of the receiver pane
         to aRectangle."
    self isHandleOk ifFalse: [ ^nil ].
    self isSimpleList ifTrue: [ ^super resize: aRectangle ].
    self resizeWithoutDropDownList.!
wbPropertyAt: key 
        "Private - Answer the value associated with key
	        in the properties dictionary."
	#addedByOSI.
	^nil!   
convertBytesToString
        "Added by OSI - Answer a String whose contents are the
         bytes of the receiver."
    #addedByOSI.
    ^self asByteArray asString! 
addTransparentStyle
    "Add a style that allows mouse clicks to pass through
        the receiver to panes below it."

    #addedByOSI.
    self propertyAt: #transparent put: true.!   
openWithParent: aViewManager
    "Added by OSI - Open a new instance of the receiver
     as a child of aViewManager."
    #addedByOSI.
    ^self new openWithParent: aViewManager!   
resizeWithoutDropDownList
        "Private - Resize the receiver to exclude the drop down list."
    isListVisible := false.
    rectangle := self framingRectangleFor: self parent rectangle.
    rectangle := rectangle leftTop extentFromLeftTop:
        rectangle width @ (
            self heightWithoutDropDownList min: rectangle height ).
    rectangle extent: (rectangle extent max: 0@0).
    self resizeWindow.!   
isCompositePane

    "Added by OSI"
    #addedByOSI.
    ^false!  
lineFrom: p1 to: p2

    "Added by OSI"
    #addedByOSI.
    self place: p1;
        line: p2.!  
isModal

    "Added by OSI"
    #addedByOSI.
    ^false!  
wbSpecialEvents
    "Added by OSI to support special needs"
    #addedByOSI.
    ^#(wbNeedsView wbNeedsPaneNamed: wbNeedsMenuNamed:)!  
oldDialogUnitWidth

    ^SysFont width / 16!
buildItemsFor: aDialogTopPane
        "Modified by OSI to support framing parameters
            and support extra dialog item template data."
        "Private - Build the control items within the dialog box.  Answer
         an array of item templates."
    | answer subpaneStyle rect text template style extraData |
    #modifiedByOSI.
    answer := OrderedCollection new.
    aDialogTopPane childrenInBuildOrder do: [ :subpane |
        subpane isSubPane ifTrue: [
            ( rect := subpane framingBlock ) isRectangle
                ifFalse: [ rect := rect isFramingParameters
                    ifTrue: [ rect valueDU: ( 0@0 extent: aDialogTopPane rectangleAttribute extent ) ]
                    ifFalse: [ rect value: ( 0@0 extent: aDialogTopPane rectangleAttribute extent ) ] ].
            ( text := subpane initialText ) isString ifFalse: [ text := nil ].
            ( style := subpane style ) isNil
                ifTrue: [ style := subpane getStyle ].
            template :=
                (extraData := subpane extraDialogItemData) isNil
                    ifTrue: [
                        WinDialogInfo
                            itemTemplateStyle: style
                            x: rect left
                            y: rect top
                            cx: rect extent x
                            cy: rect extent y
                            id: subpane id
                            className: subpane windowClass
                            text: text ]
                    ifFalse: [
                        WinDialogInfo
                            itemTemplateStyle: style
                            x: rect left
                            y: rect top
                            cx: rect extent x
                            cy: rect extent y
                            id: subpane id
                            className: subpane windowClass
                            text: text
                            extraData: extraData ].
            answer add: template.
            subpane style: style.
            subpane initSize: rect ] ].
    ^answer! 
selectItem: anObject
        "Private - Select the item anObject. anObject can
        be an index or a string."
    anObject isInteger
        ifTrue: [ self selectIndex: anObject ]
        ifFalse: [ self selectIndex: ( self indexOf: anObject ) ]!
openViews
    "Added by OSI"
    #addedByOSI.
    ^ self isModal
        ifTrue: [ self openWindow ]
        ifFalse: [ self openModeless ].!
disableItem: anItem

    self getSelection.
    ((fullList indexOf: anItem) = value) ifTrue: [
        value := value + 1.
        (value > list size) ifTrue: [
            value := 1.
        ].
        self selectIndex: value.
    ].

    disabled add: anItem.

    self buildList.! 
openAsMDIParent
    "Added by OSI - Open the receiver as an
     MDI parent window."
    | newInstance |
    (Smalltalk includesKey: #MDIChild) ifFalse: [
        MessageBox message: 'Cannot open ',self class name,
            ' because the MDI support is not installed.'.
        ^nil
    ].
	self wbPreOldVersionSupport.
    newInstance := self
        execute: [ self createViews ]
        withTopPane: #MDIFrame.
    newInstance notNil ifTrue: [
        (newInstance menuWindow menus isEmpty and: [
        (newInstance mainView handlesEvent: #menuBuilt) not ]) ifTrue: [
            newInstance menuWindow addMenu:
                (Menu new title: '&MDI'; owner: self; yourself)
        ].
        newInstance openViews.
    ] ifFalse: [
        #addedByOSI.
        MessageBox message:
            self class name,' does not have a #createViews method or its own #open method.'
    ].
    ^newInstance! 
setOwner: aWindow
      "Set the receiver's owner and parent."
    #addedByOSI.
    self propertyAt: #wbOwner put: aWindow.!   
views
    #addedByOSI.
    ^Array with: self mainView!  
needsKeyUpInput
        "Private - Answer true if the receiver processes key-up events."
    #addedByOSI.
    ^false!  
horizontalScrollMinRange
        "Private - Answer the horizontal scrollbar's max range"
    | minPos |
    #addedByOSI.
    ( UserLibrary
        getScrollRange: self handle asParameter
        bar: SbHorz
        lpMinPos: ( minPos := ExternalBuffer new: 2 ) asParameter
        lpMaxPos: ( ExternalBuffer new: 2 ) asParameter )
            ifFalse: [ ^self osError ].
    ^minPos shortAtOffset: 0!
wbInitializeBaseRuntimeWin32
        "Initialize the base runtime for Win32."

    OperatingSystemEvents
        at: 13  put: #wmGettext:with: ;
        at: 1123 put: #wmUser99:with: .

    ColorConstants
        at: 'ClrChiseledgray' put: 14737632.

    IndexedColor defaultColors
        at: #paleGray
        put: (
            IndexedColor index: (
                ColorConstants at: 'ClrPalegray')).!   
isWBWindow

    "Added by OSI"
    #addedByOSI.
    ^self class wbCreated!
iDUE: e
    "Private"

    initialExtent := (e * self dialogUnit) rounded.!
removeLastEventsFor: aWindow in: aQueue using: aBlock
		"Private - Remove queued events for aWindow.
			Use aBlock to determine which events to remove."
	| eachEvent |
	#addedByOSI.
	[	aQueue size to: 1 by: -1 do: [ :eachEventIndex |
			((eachEvent := aQueue at: eachEventIndex) receiver == aWindow | aWindow isNil
				and: [ aBlock value: eachEvent ])
					ifTrue: [ aQueue removeIndex: eachEventIndex ] ].
	] evaluateWithoutInterrupts!
openWindow
    "Open all the views."
    "Modified by OSI to support preInitWindow
        and remove #respondsTo: message"

    #modifiedByOSI.
    self wbOldVersionSupport.
	self wbLinkPartEvents.
    self preInitWindow.

    views do: [:each | each openWindow ]!   
clearPopup
    "Added by OSI"
    #addedByOSI.
    popup := nil.!  
wmKeyup: wordInteger with: longInteger
        "Private - Process the character input message."
    | event |
    self needsKeyUpInput ifTrue: [
        #addedByOSI.
        (event := KeyboardInputEvent keyUpFromWmKeyup: wordInteger with: longInteger) notNil ifTrue: [
            self sendInputEvent: #keyUpInput: with: event ] ].
    ^super wmKeyup: wordInteger with: longInteger! 
rightAndDown: aPoint
        "Answer a rectangle right and down of the receiver by aPoint."
    #addedByOSI.
    ^(self topLeft rightAndDown: aPoint)
        rightBottom: (self rightBottom rightAndDown: aPoint)!   
dialogUnitHeight
        "Private - Answer the receiver's dialog unit height."
    ^duHeight ifNil: [
        "If nil then assume old dialog units."
        duHeight := self class oldDialogUnitHeight ]!
uncheckAll
    "Added by OSI - Uncheck all items for the receiver."
    #addedByOSI.
    items do: [ :mi |
        mi hasSubmenu ifTrue: [ mi submenu uncheckAll ].
        self uncheckItem: mi selector ]! 
drawRect3DLight: aRect
      "Added by OSI."
    #addedByOSI.
    self
        foreColor: Color buttonHighlight;
        lineFrom: (aRect left @ (aRect top down: 1)) to: ((aRect right left: 1) @ (aRect top down: 1));
        lineFrom: ((aRect left right: 1) @ (aRect top down: 1)) to: ((aRect left right: 1)@ (aRect bottom up: 1));
        foreColor: Color buttonShadow;
        lineFrom: (aRect left right: 1) @ (aRect bottom up: 2) to: (aRect rightBottom leftAndUp: 1@2);
        lineFrom: (aRect left right: 2) @ (aRect bottom up: 3) to: ((aRect right left: 1) @ (aRect bottom up: 3));
        lineFrom: (aRect right left: 2) @ (aRect top down: 1) to: (aRect rightBottom leftAndUp: 2@1);
        lineFrom: (aRect right left: 3) @ (aRect top down: 2) to: (aRect right left: 3) @ (aRect bottom up: 1).!
basicStyle
        "Private - Answer an Integer with appropriate
         bits for basic control style."
        "Modified by OSI: added the WsClipsiblings style
        to support overlapping panes."
    #modifiedByOSI.
    ^ WsChild | WsVisible | WsGroup | WsClipsiblings!  
highHalf

    " ** Added by Objectshare ** "
    "Answer the high half of the receiver."

    #addedByOSI.
    ^(ExternalLong fromInteger: self) highHalf!  
right: x relativeTo: aSymbol
    "Private"

    aSymbol == #center
        ifTrue: [ right := x ] ifFalse: [ right := x abs ].
    rightRel := aSymbol.! 
tabGroupMembers
        "Answer the members of the tab group
        that the receiver belongs to."
    | orderedChildren radioGroupLeader index groupLeader group size |

    "Moved this method from RadioButton to SubPane so others can use it..."
    #addedByOSI.

    self tabScope isNil   "New window initializing controls (no parent yet)."
        ifTrue: [ ^OrderedCollection new.].
    orderedChildren := self tabScope orderedChildren.
    orderedChildren size = 0
        ifTrue: [ ^orderedChildren ].  " shouldn't happen... "
    radioGroupLeader := 1.
    groupLeader := 1.
    index := 0.
    orderedChildren do: [ :child |
        index := index + 1.
        child isAGroupLeader
            ifTrue: [ groupLeader := index ].
        child == self
            ifTrue: [ radioGroupLeader := groupLeader ] ].

    group := OrderedCollection new.
    group add: ( orderedChildren at: radioGroupLeader ).
    index := radioGroupLeader + 1.
    size := orderedChildren size.
    [  index <= size and:
        [ ( orderedChildren at: index ) isAGroupLeader not ] ]
    whileTrue: [
        group add: ( orderedChildren at: index ).
        index := index + 1 ].

    ^group!   
ifNil: aBlock

    "Added by OSI. This replaces the construct 'isNil ifTrue: []'.
     In the case self IS nil"

    #addedByOSI.
    ^aBlock value!
notifyListVisible: aParameter
        "Private - the host signaled that the list was dropped down."
    self isSimpleList ifFalse: [
        self resizeWithDropDownList.
        self forkListHiddenWatcher ].
    super notifyListVisible: aParameter.!
isWBAction

    "Added by OSI"
    #addedByOSI.
	self obsoleteMethod.
    ^false!
dialogUnitWidth
        "Private - Answer the receiver's dialog unit width."
    ^duWidth ifNil: [
        "If nil then assume old dialog units."
        duWidth := self class oldDialogUnitWidth ]! 
dialogUnitWidth

    ^SysFont width / 16!   
chiseledGray
        "Answer the chiseledGray color."
    #addedByOSI.
    ^RGBColor chiseledGray! 
wbPropertyAt: key ifAbsent: aBlock
        "Private - Answer the value associated with key
	        in the properties dictionary; if absent, 
	        answer the result of evaluating aBlock."
	#addedByOSI.
    ^aBlock value! 
iDUE
    "Private"

    ^(initialExtent / self dialogUnit ) rounded!   
findOrPromptFileName: fileName filters: filterCollection in: aCollectionOfDir
       "Answer the full path of the file named fileName.
       Searching in aCollectionOfDir first, then the current search path,
		then prompt the user.  If the user specifies a directory that is not
		in aCollectionOfDir, then add that directory to aCollectionOfDir.
		filterCollection is a collection of associations whose
		keys are the filter (e.g. '*.*') and values are the filter
		descriptions (e.g. 'All files (*.*)')."

	| dialog answer defFilter allFilters |
	#addedByOSI.
	aCollectionOfDir do: [ :each |
		answer := each drivePathName, '\', fileName.
		(self exists: answer) ifTrue: [ ^answer ] ].
	(answer := self findFileName: fileName) notNil ifTrue: [ ^answer ].

	(defFilter := '*.', fileName fileExtension trimBlanks)
		= '*.' ifTrue: [ defFilter := '*.*' ].
	allFilters := OrderedCollection new
		addAll: filterCollection;
		yourself.
	allFilters
		detect: [ :assoc | assoc key = '*.*' ]
		ifNone: [ allFilters add: '*.*' => 'All files (*.*)' ].
	allFilters
		detect: [ :assoc | assoc key = defFilter ]
		ifNone: [ allFilters add: defFilter => ('Related files (', defFilter, ')') ].
	
	dialog := FileDialog new
		title: 'Where is "', fileName, '" ?';
		fileSpec: fileName;
		hideReadonly.
	allFilters do: [ :assoc |
		dialog addFilter: assoc key description: assoc value ].
	dialog
		defFilter: defFilter;
		open.

	(answer := dialog file) notNil ifTrue: [
		(self exists: answer) ifFalse: [
			MessageBox message: '"', answer fileNameLessPath, '" does not exist'.
			answer := nil ] ].
	^answer!  
wbPropertyAt: key put: aValue
        "Private - Set the value associated with key
	        in the properties dictionary."
	#addedByOSI.
   ^aValue!  
paneNamed: aPaneName

    "Added by OSI"

    | pane string |

    views do: [ :v |
        ( pane := v wbPaneNamed: aPaneName ) notNil
            ifTrue: [ ^pane ] ].

    #addedByOSI.
    string := aPaneName asString.

    views do: [ :v |
        ( pane := v wbPaneNamed: string ) notNil
            ifTrue: [ ^pane ] ].

    ^nil!  
constructSynchronousNotifications
        "Private - answer the mapping between host control
        notification codes and corresponding Smalltalk event
        notifications."
    ^Dictionary new!
eventTable
        "Private - answer a Dictionary mapping event names to actions
        for the receiver."
	#addedByOSI.
	^views wbEventTable ifNil: [
		self eventTableCreate ]!   
extraDialogItemData
    "Added by OSI - Answer the extra dialog item data as a
     WinStructure or nil if there is none."
    #addedByOSI.
    ^nil! 
left
    "Private"

    ^left! 
centerX: aBoolean
    "Private"

    centerX := aBoolean!  
beginsWith: aCollection

    #addedByOSI.
    self size < aCollection size ifTrue: [ ^false ].
    self size = aCollection size ifTrue: [ ^aCollection = self ].
    ^aCollection = (self copyFrom: 1 to: aCollection size)! 
right
    "Private"

    ^right!   
constructNotifications
        "Private - answer the mapping between host control
        notification codes and corresponding Smalltalk event
        notifications."
    ^super constructNotifications
        at: CbnCloseup put: #notifyListHidden: ;
        yourself! 
draw3DRectReversed: aRect
	    "Added by OSI"
	#addedByOSI.
	self
		draw3DRect: aRect
		leftTopColor: Color buttonShadow
		rightBottomColor: Color buttonHighlight.!
subclassRecursively
        "Private - subclass the children."
	#modifiedByOSI.
	self owner isWBWindow
		ifTrue: [ super subclassRecursively ]
		ifFalse: [
			children size > 0 ifTrue: [
				children do: [ :child | child subclassRecursively ] ] ].!   
wmErasebkgnd: wordInteger with: longInteger
        "Private - Added by OSI.  Process the erase background message."
    #addedByOSI.
    "If the button is invisible, then don't erase its background."
    drawSelector = #invisible ifTrue: [ ^1 ].
    ^super wmErasebkgnd: wordInteger with: longInteger!   
quickLineFrom: p1 to: p2 using: aHandle

    "Added by OSI for 3D rects."
    #addedByOSI.
    GDILibrary moveToEx: aHandle x: p1 x y: p1 y oldPosition: nil.
    GDILibrary lineTo: aHandle x: p2 x y: p2 y.!   
createViewsFor: target owner: owner
    "Added by OSI - Dummy method that returns nil."
    #addedByOSI.
    ^nil! 
newDialogUnit

    ^self newDialogUnitWidth @ self newDialogUnitHeight! 
views

    "Added by OSI"
    #addedByOSI.
    ^views!
openViewsOnce
        "Open the window once.
            For PARTS support."
    #addedByOSI.
    self mainView isHandleOk
        ifTrue: [ self mainView bringToTop ]
        ifFalse: [ self openViews ].!   
definedIn: aSelector
        "Set the selector of the creation method."
	#addedByOSI.
    self propertyAt: #definedIn put: aSelector!  
dynamicListBottom
        "Answer the bottom coordinate of the dynamic list."
    ^(rectangle top down: self dynamicListHeight)
        higherOf:
            (Display boundingBox mapScreenToClient: self parent) bottom!
monthStrings
    "Added by OSI"
    #addedByOSI.
	^WBMonthStrings! 
valueToDU: containerRect
        "Answer a rectangle based on self's framing parameters
		 with a parent rectangle containerRect."

	| answer |
	answer := self value: containerRect.
	^(answer leftTop / FramingParameters newDialogUnit) rounded
		rightBottom:
			(answer rightBottom / FramingParameters newDialogUnit) rounded!  
canTriggerEvent: eventName
        "Answer <true> if the receiver can trigger an event
        named <eventName>."
    #addedByOSI.
    ^(super canTriggerEvent: eventName)
        or: [self class wbSpecialEvents includes: eventName asSymbol]!   
closeInnerWindows
        "Private - close the inner windows in the view.
        Answer whether successful."
    | inner |
    inner := OrderedCollection new.
    Notifier windows do: [:w|
        ((w == self) not and: [
        w isApplicationWindow and: [
            w isHandleOk and:[

					"Modified by OSI to fix problem with closing children"
					#modifiedByOSI.
                (self hasDescendant: w) or: [self owner == w parent and: [self owner notNil]]]]])
                    ifTrue: [inner add: w]].

    inner do: [:w| w textModified ifTrue: [^false] ifFalse: [w clearTextModified]].
    inner do: [:w| w close].
    self textModified ifTrue: [^false].
    ^true! 
findOrPromptFileName: fileName
        "Answer the full path of the file named fileName.
		 Search the current search path, and if not found
		 then prompt the user."
	^self findOrPromptFileName: fileName in: OrderedCollection new!   
removeFirstCurrentEventFor: aWindow using: aBlock
		"Private - Remove the first queued event for aWindow
			for which aBlock evaluated with the event returns true."
	| found |
	#addedByOSI.
	found := false.
	self
		removeFirstEventsFor: aWindow
		in: CurrentEvents
		using: [ :eachEvent |
			found not and: [
				found := aBlock value: eachEvent ] ].
	^found!   
openCenteredOnScreen
    "Added by OSI - Open the receiver centered over the mouse."
    | newInstance framingBlock mousePos |
	self wbPreOldVersionSupport.
    newInstance := self createViews.
    newInstance notNil ifTrue: [
        newInstance
            centeredOnScreen;
            openViews.
    ] ifFalse: [
        #addedByOSI.
        MessageBox message:
            self class name,' does not have a #createViews method or its own #open method.'
    ].
    ^newInstance!  
leftProportional: x
    "Private"

    self lP: x! 
leftRightUnit
        "Answer the signed unit from left to right."
	#addedByOSI.
    ^1!   
value: containerRect
		"Answer a rectangle based on self's framing parameters
		with a parent rectangle containerRect."

    | realTop realBottom realRight realLeft distance |

    centerX ifTrue: [
        distance := (containerRect extent x - initialExtent x) // 2.
        realLeft := containerRect left right: distance.
        realRight := containerRect right left: distance.
    ] ifFalse: [
        left isNil ifFalse: [
            left isInteger ifFalse: [
                realLeft := containerRect left right: (containerRect width * left) rounded.
            ] ifTrue: [
                (leftRel = #left) ifTrue: [
                    realLeft  := containerRect left right: left.
                ] ifFalse: [ (leftRel = #center) ifTrue: [
                    realLeft  := containerRect center x right: left.
                ] ifFalse: [
                    realLeft := containerRect right left: left.
                ]].
            ].
        ].

        right isNil ifFalse: [
            right isInteger ifFalse: [
                realRight := containerRect left right: (containerRect width * right) rounded.
            ] ifTrue: [
                (rightRel = #left) ifTrue: [
                    realRight  := containerRect left right: right.
                ] ifFalse: [ (rightRel = #center) ifTrue: [
                    realRight  := containerRect center x right: right.
                ] ifFalse: [
                    realRight := containerRect right left: right.
                ]].
            ].
        ] ifTrue: [
            realRight := realLeft right: initialExtent x.
        ].

        left isNil ifTrue: [
            realLeft := realRight left: initialExtent x.
        ].

    ].

    centerY ifTrue: [
        distance := (containerRect extent y - initialExtent y) // 2.
        realTop := containerRect top down: distance.
        realBottom := containerRect bottom up: distance.
    ] ifFalse: [

        top isNil ifFalse: [
            top isInteger ifFalse: [
                realTop := containerRect top down: (containerRect height * top) rounded.
            ] ifTrue: [
                (topRel = #top) ifTrue: [
                    realTop  := containerRect top down: top.
                ] ifFalse: [ (topRel = #center) ifTrue: [
                    realTop  := containerRect center y down: top.
                ] ifFalse: [
                    realTop := containerRect bottom up: top.
                ]].
            ].
        ].

        bottom isNil ifFalse: [
            bottom isInteger ifFalse: [
                realBottom := containerRect top down: (containerRect height * bottom) rounded.
            ] ifTrue: [
                (bottomRel = #top) ifTrue: [
                    realBottom  := containerRect top down: bottom.
                ] ifFalse: [ (bottomRel = #center) ifTrue: [
                    realBottom  := containerRect center y down: bottom.
                ] ifFalse: [
                    realBottom := containerRect bottom up: bottom.
                ]].
            ].
        ] ifTrue: [
            realBottom := realTop down: initialExtent y.
        ].

        top isNil ifTrue: [
            realTop := realBottom up: initialExtent y.
        ].
    ].

    ^(realLeft @ realTop rightBottom: realRight @ realBottom) insetBy: self platformIndent!   
selectAll
        "Select the entire text of the  receiver."

	#modifiedByOSI.
	"This stupid line causes cascading focus changes!!"
    "self mainWindow activeTextPane: self."

    self isHandleOk
        ifTrue: [ self selectFrom: 1 to: self windowTextLength + 1 ]
        ifFalse: [ self whenValid: #selectAll ]!   
insertItemDynamically: string selector: aSelector atIndex: index
    "Added by OSI"
    | mi |
    #addedByOSI.
    self insertItem: string
        selector: aSelector
        accelKey: nil
        accelBits: nil
        after: index.
    (mi := self getMenuItem: string)
        id: (self menuItem id - 1) + items size.
    window
        insertItem: mi
        label: string.!   
viewNamed: aSymbol

    "Added by OSI"

    | string |

    #addedByOSI.
    views do: [ :v |
        v paneName = aSymbol ifTrue: [
            ^v
        ].
    ].

    string := aSymbol asString.
    views do: [ :v |
        v paneName = string ifTrue: [
            ^v
        ].
    ].

    ^nil! 
yesNoCancelTitled: title text: text
        "Added by OSI - Answer #yes, #no, or nil"
    | answer |
    #addedByOSI.
    answer := self threeStateNotify: title withText: text.
    answer = true ifTrue: [ answer := #yes ].
    answer = false ifTrue: [ answer := #no ].
    ^answer!  
lowHalf

    " ** Added by Objectshare ** "
    "Answer the low half of the receiver."

    #addedByOSI.
    ^(ExternalLong fromInteger: self) lowHalf! 
bP: y
    "Private"

    y = 1
        ifTrue: [
            bottom := 0.
            bottomRel := #bottom ]
        ifFalse: [
            bottom := y.
            bottomRel := #top ].!   
nameOfMonthAbbreviated: anInteger
        "Answer the month name as a Symbol corresponding
         to the month index anInteger (January for index
         1, to December for index 12)."
    | aName |
    (anInteger > 12 or: [anInteger < 1])
        ifTrue: [self errorInMonth].
    MonthNames associationsDo: [ :assoc |
        (anInteger = assoc value) ifTrue: [
            aName isNil
                ifTrue: [ aName := assoc key ]
                ifFalse: [
                    ^(aName size < assoc key size)     "answer short name"
                        ifTrue: [ aName ]
                        ifFalse: [ assoc key]]]].
    aName isNil
        ifTrue: [ self errorInMonth]
        ifFalse: [ ^aName ].!
dragTargetFormatsDefault
        "Private - answer the formats of drag objects that the receiver will accept."
    #addedByOSI.
    ^nil!  
"bindAction:
	Message
		receiver: Window
		selector: #wbInitializeBaseRuntimeWin32"

	Window wbInitializeBaseRuntimeWin32.!  
RGBColor fromInteger: 16rE0E0E0.! 
buildList

    super contents: (fullList select: [ :el | (disabled includes: el) not ]).
    self selectIndex: value.! 
dialogTemplate
    "Added by OSI"
    #addedByOSI.
    ^nil!   
minWindowSize
    "Added by OSI"
    #addedByOSI. "PARTS Support"
    ^nil!
newDialogUnitHeight

    ^WindowDialog dialogUnit y / 8!
paleGray
        "Answer an instance of the receiver representing the color paleGray."
    #addedByOSI.
    ^self defaultColorNamed: #paleGray!
initialize
        "Private - Initialize the receiver."
	#modifiedByOSI.
	"Modified to add properties to ViewManagers
		via instances of WBOrderedCollection ."
    views := WBOrderedCollection new: 1! 
verticalScrollPos
        "Private - Answer the vertical scrollbar's position"
    | pos |
    #addedByOSI.
    ( pos := UserLibrary getScrollPos: self handle asParameter bar: SbVert ) = 0
        ifTrue: [ self osWarning ].
    ^pos!  
closeDynamically
        "Private - Close the subpane dynamically."
    #addedByOSI.
    self close.
    self destroy.
    owner := parent := handlers := properties := nil.!
heightWithoutDropDownList
        "Answer the height of the receiver when the drop down list is hidden."
    ^self font height + 6! 
mnemonicChar

    "Added by OSI.  Scan for the mnenomic character (& or ~), and
     answer the character following it.  If no mnemonic, answer nil."

    | index size ch |
    #addedByOSI.
    index := 1.
    size := self size.
    [ index < size ] whileTrue: [
        (ch := self at: index) = $& | (ch = $~) ifTrue: [
            ^(self at: index + 1) asUpperCase ].
        index := index + 1 ].
    ^nil!
verticalScrollMinRange
        "Private - Answer the vertical scrollbar's min range"
    | minPos |
    #addedByOSI.
    ( UserLibrary
        getScrollRange: self handle asParameter
        bar: SbVert
        lpMinPos: ( minPos := ExternalBuffer new: 2 ) asParameter
        lpMaxPos: ( ExternalBuffer new: 2 ) asParameter )
            ifFalse: [ ^self osError ].
    ^minPos shortAtOffset: 0!
draw3DButtonRect: aRect leftTopColor: aLeftTopColor rightBottomColor: aRightBottomColor

    "Added by OSI"
    | theHandle leftRight1 leftRight2 rightLeft2 rightLeft3
	topDown1 topDown2 bottomUp2 bottomUp3 oldColor |
    #addedByOSI.
    theHandle := self handle.
    leftRight1 := aRect left right: 1.
    leftRight2 := aRect left right: 2.
    rightLeft2 := aRect right left: 2.
    rightLeft3 := aRect right left: 3.
    topDown1 := aRect top down: 1.
    topDown2 := aRect top down: 2.
    bottomUp2 := aRect bottom up: 2.
    bottomUp3 := aRect bottom up: 3.
	oldColor := self foreColor.

    self
        foreColor: aLeftTopColor;
        quickLineFrom: leftRight1 @ topDown1 to: rightLeft2 @ topDown1 using: theHandle;
        quickLineFrom: leftRight1 @ topDown2 to: rightLeft3 @ topDown2 using: theHandle;
        quickLineFrom: leftRight1 @ topDown1 to: leftRight1 @ bottomUp2 using: theHandle;
        quickLineFrom: leftRight2 @ topDown1 to: leftRight2 @ bottomUp3 using: theHandle;
        foreColor: aRightBottomColor;
        quickLineFrom: leftRight1 @ bottomUp2 to: (aRect right left: 1) @ bottomUp2 using: theHandle;
        quickLineFrom: leftRight2 @ bottomUp3 to: rightLeft2 @ bottomUp3 using: theHandle;
        quickLineFrom: rightLeft2 @ topDown1 to: rightLeft2 @ (aRect bottom up: 1) using: theHandle;
        quickLineFrom: rightLeft3 @ topDown2 to: rightLeft3 @ bottomUp2 using: theHandle;
        foreColor: oldColor.!   
setBackgroundModeTransparent
		"Set the background mode."
	#addedByOSI.
	self setBackgroundMode: 1. "(GraphicsConstants at: 'BackgroundMixTransparent')"
!
cancelPushButton
    "Set the cancel push button style so that this button
		is 'clicked' when the escape key is pressed."
    #addedByOSI.
    self propertyAt: #cancelPushButton put: true.!
releaseEventTable
		"Release the receiver's event table."
	#addedByOSI.
	^views wbReleaseEventTable!   
validateDay: dInteger month: mInteger year: yInteger
    "Added by OSI - Check the validity of the day number
     dInteger for the month aSymbol in the year yInteger.
     If the date is invalid, report the error."

    #addedByOSI.
    ^(mInteger < 1 or: [
        mInteger > 12 or: [
        dInteger < 1 or: [
        dInteger > (self
            daysInMonth: (self nameOfMonth: mInteger)
            forYear: yInteger)]]]) not!   
asDate
    "Answer the receiver as a date."

	#addedByOSI.
    ^self! 
topProportional: y
    "Private"

    self tP: y!  
topPaneClass
		"Answer the receiver's top pane class."
    #addedByOSI.
    ^self class windowClass!   
horizontalScrollPos
        "Private - Answer the horizontal scrollbar's position"
    | pos |
    #addedByOSI.
    ( pos := UserLibrary getScrollPos: self handle asParameter bar: SbHorz ) = 0
        ifTrue: [ self osWarning ].
    ^pos!  
wbEventTable
		"Private - Answer the event table."
	^wbEventTable!  
fromByteArray: aLogFontByteArray

    "Added by OSI - Create a font from the bytes of a logical font"
    | contents |

    #addedByOSI.
    contents := ByteArray new: aLogFontByteArray size.
    1 to: aLogFontByteArray size do: [ :i |
        contents at: i put: (aLogFontByteArray at: i).
    ].

    logicalFont := WinLogFont fromBytes: contents.
    "changed := true."
    self makeFont.! 
getTabStop
    	"Answer tabInterval in number of pels."
    #addedByOSI.
    ^self propertyAt: #tabStop!   
openModeless

    "Modified by OSI to support preInitWindow"

        "Open the dialog box as a modeless window."

    #modifiedByOSI.
    self wbOldVersionSupport.
	self wbLinkPartEvents.
    self preInitWindow.

    self mainView openModeless!  
initialize
	    "Private - Initialize the receiver with dialog units."
    centerX := false.
    centerY := false.
    indent := 0@0.
    initialExtent := 0@0.
	duWidth := self class dialogUnitWidth.
	duHeight := self class dialogUnitHeight.! 
preInitWindow
    "Added by OSI"
    #addedByOSI.!  
propertyAt: key ifAbsent: aBlock
        "Answer the value associated with key
        in the properties dictionary; if absent, 
        answer the result of evaluating aBlock."
	#addedByOSI.
    ^views wbPropertyAt: key ifAbsent: aBlock!   
lP: x
    "Private"

    x = 1
        ifTrue: [
            left := 0.
            leftRel := #right ]
        ifFalse: [
        left := x.
        leftRel := #left ].!   
addClipsiblingsStyle
		"Ignore this"
	#addedByOSI.! 
wmNchittest: wParam with: lParam
        "Private - Process Non-client mouse hit test message."

    #addedByOSI.
    ( self propertyAt: #transparent ) = true ifTrue: [ ^Httransparent ].
    ^super wmNchittest: wParam with: lParam!  
fromStream: s
         "Private - WBPro Development."

    | bfh bih bi bits rgbColor bytes bitmap |

    #addedByOSI.
    bfh := self readFileHeader: s.
    bih := self readBitmapHeader: s.
    bih bitCount = 24 ifFalse: [
        rgbColor := ByteArray new: ((1 bitShift: bih bitCount) * 4).
        1 to: rgbColor size do: [: i |
            rgbColor at: i put: s nextByte
        ]
    ].
    bih sizeImage = 0 ifTrue: [
        bytes := (((
            bih width * bih bitCount) + 31) // 32 * 4) * bih height
    ] ifFalse: [
        bytes := bih sizeImage.
    ].
    bits := ByteArray new:  bytes.
    s getBytesFor: bits.

    bitmap := self new.
    bitmap bitmapInfo: (
        rgbColor isNil
            ifTrue: [WinBitmapInfo new contents: bih contents]
             ifFalse: [
                WinBitmapInfo new contents: bih contents, rgbColor]).
    bitmap createBitmap: bits.
    bitmap
        deviceContext: MemoryContext;
        graphicsTool: (
            Pen forDC: MemoryContext medium: bitmap).
    ^bitmap!   
addSubpaneDynamically: aSubPane
    "Added by OSI - Add a subpane to a window dynamically"
    #addedByOSI.
    self addSubpane: aSubPane.
    aSubPane open;
        initSize: self rectangle;
        buildWindow: self;
        resize: self rectangle;
        validate.! 
constructViewFor: aCoordinator
    "Create a new view of the application <aCoordinator> and define its structure."
    "Modified by OSI to add special event handlers for WB windows"
    | view |
    #modifiedByOSI.
    view := self createViewFor: aCoordinator.
    aCoordinator isWBWindow
        ifTrue: [
            view owner: aCoordinator.
            aCoordinator
                when: #wbNeedsView send: #yourself to: view;
                when: #wbNeedsPaneNamed: send: #paneNamed: to: view;
                when: #wbNeedsMenuNamed: send: #wbMenuTitled: to: view menuWindow].
    self buildView: view forModel: aCoordinator.
    ^view! 
draw3DRect: aRect
	    "Added by OSI"
	#addedByOSI.
	self
		draw3DRect: aRect
		leftTopColor: Color buttonHighlight
		rightBottomColor: Color buttonShadow.!
restoreDefaultPushButton
        "Private - If the button was not the original default
        push button, then restore the default push button style
        to the original."
    | originalDefaultButton |
    originalDefaultButton := self mainWindow defaultPushButton.
    originalDefaultButton ~~ self
        ifTrue: [ self pushButton; setDefault: false ].
    originalDefaultButton notNil
        ifTrue: [

            "Modified by OSI to fix problem with disabled buttons becoming enabled"
            #modifiedByOSI.
            originalDefaultButton disabled not
                ifTrue: [

					 originalDefaultButton defaultPushButton; setDefault: true ] ]!   
validateString: aString
    "Added by OSI - Validate whether aString represents
     a valid date"

    | array |
    #addedByOSI.
    array := self dateArray: aString.
    ^self validateDay: (array at: 1) month: (array at: 2) year: (array at: 3)!
contents: aString
		"Set the label of the button to the string specified by aString.
			Allow '~' mnemonics from V/OS2."
    #addedByOSI.
    super contents: (
        aString collect: [ :each |
            each = $~
                ifTrue: [ $& ]
                ifFalse: [ each ] ] ).!   
readFileHeader: bitmapFile
        "Private - Read the bitmap file header of a bitmapFile.
         Answer an instance WinBitmapFileHeader."
    | bmpFileHdr |
    #addedByOSI.
    bmpFileHdr := WinBitmapFileHeader new.
    bmpFileHdr bfType: bitmapFile nextUShort.
    bmpFileHdr bfSize: bitmapFile nextULong.
    bitmapFile nextUShort; nextUShort.
    bmpFileHdr offBits: bitmapFile nextULong.
    ^bmpFileHdr!
paneNamed: aPaneName

    "Added by OSI"

    #addedByOSI.
    ^( self wbPaneNamed: aPaneName ) ifNil: [
        self wbPaneNamed: aPaneName asString ]!
draw3DButtonRectReversed: aRect
	    "Added by OSI"
	#addedByOSI.
	self
		draw3DButtonRect: aRect
		leftTopColor: Color buttonShadow
		rightBottomColor: Color buttonHighlight.!
fromModule: aModuleName id: bitmapName
        "Private - Load the receiver from the module
        aModuleName with id bitmapName."
    | bitmapStruct hLibrary fileName path |
    #modifiedByOSI.
    aModuleName notNil ifTrue: [
        fileName := aModuleName fileNameLessPath.
        ( hLibrary := KernelLibrary loadLibrary: fileName asParameter ) = 0
            ifTrue: [
                "If load failed, then search the path..."
                ((path := File findFileName: fileName) isNil or: [
                    (hLibrary := KernelLibrary loadLibrary: path asParameter) = 0
                ]) ifTrue: [ ^self osError ] ] ].
    ( bitmapHandle := UserLibrary
        loadBitmap: hLibrary asParameter
        name: bitmapName asParameter ) = 0
            ifTrue: [ ^self osError ].
    BitmapHandleTable at: bitmapHandle put: self.
    hLibrary notNil ifTrue: [
        ( KernelLibrary freeLibrary: hLibrary )
            ifFalse: [ ^self osError ] ].

    "use archive to save dll name and id."
    archive := Array with: fileName with: bitmapName.
    GDILibrary
        getObject: bitmapHandle
        count: WinBitmapStruct sizeInBytes
        lpObject: ( bitmapStruct :=  WinBitmapStruct new ) asParameter.
    bitmapInfo := WinBitmapInfo
        width: bitmapStruct width
        height: bitmapStruct height
        planes: 1
        bitCount: bitmapStruct planes * bitmapStruct bitsPixel.
    deviceContext := self class memoryContext.
    graphicsTool := Pen forDC: deviceContext medium: self.
    graphicsTool
        width: bitmapInfo width;
        height: bitmapInfo height! 
isWBWindow

    "Added by OSI."
    #addedByOSI.
    ^false!  
centerY: aBoolean
    "Private"

    centerY := aBoolean!  
openWithMDIParent: aViewManager
    "Added by OSI - Open the receiver with aViewManager as an MDI Parent."
    | newInstance frame |
    (Smalltalk includesKey: #MDIChild) ifFalse: [
        MessageBox message: 'Cannot open ',self class name,
            ' because the MDI support is not installed.'.
        ^nil
    ].
	((aViewManager respondsTo: #frame)
		and: [ (frame := aViewManager frame) notNil ]
	) ifFalse: [
        MessageBox message: 'Cannot open ',self class name,
            ' because the parent window does not have an MDI Frame.'.
        ^nil
    ].
	self wbPreOldVersionSupport.
    newInstance := self
        execute: [ self createViews ]
        withTopPane: #MDIChild.
    newInstance notNil ifTrue: [
        self views do: [ :view |
            view frame: frame.
        ].
        newInstance openViews.
    ] ifFalse: [
        #addedByOSI.
        MessageBox message:
            self class name,' does not have a #createViews method.'
    ].
    ^newInstance!   
frameStyleFromPStyle

    "Added by OSI"

    | s pStyle |

    (pStyle := self pStyle) isNil ifTrue: [
        #addedByOSI.
        ^nil
    ].

    s := 0.

    (pStyle includes: #maximize) ifTrue: [
        s := s | WsMaximizebox.
    ].
    (pStyle includes: #minimize) ifTrue: [
        s := s | WsMinimizebox.
    ].
    (pStyle includes: #sizable) ifTrue: [
        s := s | WsThickframe.
    ] ifFalse: [
        s := s | WsBorder.
    ].
    (pStyle includes: #sysmenu) ifTrue: [
        s := s | WsSysmenu.
    ].
    (pStyle includes: #titlebar) ifTrue: [
        s := s | WsCaption.
    ] ifFalse: [
        s := s | WsPopup.
    ].
    "Support for secondary views as children"
    (self ~~ self owner and: [self == self owner mainView]) ifFalse: [
        (pStyle includes: #mainViewChild) ifTrue: [
            self parent: self owner mainView
        ].
    ].

    ^s!  
isCancelPushButton
        "Private - Answer true if the receiver is the
        cancel pushbutton."
    #addedByOSI.
    ^(self propertyAt: #cancelPushButton) = true!   
draw3DButtonRect: aRect
	    "Added by OSI"
	#addedByOSI.
	self
		draw3DButtonRect: aRect
		leftTopColor: Color buttonHighlight
		rightBottomColor: Color buttonShadow.!
centeredOnScreen
    "Added by OSI - Open the receiver centered on the screen.
     Call this method from within #preInitWindow"
    | framingBlock center initialExtent |
    #addedByOSI.
    center := Display extent // 2.
    framingBlock := self mainView framingBlock.
    initialExtent := framingBlock initialExtent.
    framingBlock
        centerX: false; centerY: false;
        left: (((center x left: framingBlock initialExtent x // 2) max: 0) min: (Display width - initialExtent x))
        relativeTo: #left;
        top: (((Display boundingBox top distanceDown: (center y up: framingBlock initialExtent y // 2)) max: 0) min: (Display height - initialExtent y))
        relativeTo: #top.!   
keyDownFromWmKeydown: wparam with: lparam
        "Private - answer an instance of the receiver class corresponding to
        the host WM_CHAR message described by the arguments."
    #addedByOSI.
    ^self fromWmChar: wparam with: lparam!  
addSubpane: aPane
        "Add aPane as the child of the receiver."
    | id name getContentsHandler |
    children isNil ifTrue: [ children := IdentityDictionary new ].
    ( id := aPane id ) isNil
        ifTrue: [ aPane id: ( id := self getNextChildId ) ].
    children at: id put: aPane.
    aPane frameWindow parent: self.
    aPane owner isNil
        ifTrue: [ aPane owner: self owner ].
    aPane isControlPane ifTrue: [
        "if being added dynamically, then do subclassing"
        self isValid ifTrue: [ aPane subclassRecursively ] ].
    self mainWindow add: aPane interestIn: aPane name.

    #modifiedByOSI.
    self owner isWBWindow ifTrue: [
        (self mainWindow propertyAt: #subPaneWithFocus) isNil & aPane isATabStop ifTrue: [
            (aPane canTab and: [aPane isRadioButton not or: [aPane selection]]) ifTrue: [
                self mainWindow propertyAt: #subPaneWithFocus put: aPane]]].

    #obsoleteMethod.    "Obsolete modification..."
    name := aPane name.
    (getContentsHandler := aPane getContentsHandler) notNil ifTrue: [
        name ~= getContentsHandler ifTrue: [
            self mainWindow add: aPane interestIn: getContentsHandler]].!  
minWindowSize
    "Added by OSI"
    #addedByOSI.
    ^nil!
ifNil: aBlock

    "Added by OSI. This replaces the construct 'isNil ifTrue: []'.
     In this case self is NOT nil"

    #addedByOSI.
    ^self!   
dialogTemplate: ignore
    "Added by OSI"
    #addedByOSI.
    ^self!