05/02/95 10:53:35 PM

errorBitmapNotFound: aString
		"Private - Report an error to the user."
	^self error: 'bitmap not found: "', aString, '"'!  
on: aDictionary
		"Answer a new initialized instance."
	^self new initBitmaps: aDictionary! 
isFixedGroup
		"Answer true if the receiver is a fixed group."
	^false! 
keys
		"Answer a collection of bitmap keys."
	^self flat keys!  
addBitmapsFromModule: moduleName idMap: idMap
		"Load the bitmaps in the file moduleName.
			Answer a dictionary containing the bitmaps loaded
			or nil if not found.  The module (DLL) must be on the PATH."
	| dict |
	(File findFileName: moduleName) notNil ifTrue: [
		(dict := WBBitmapGroup fromModule: moduleName idMap: idMap) notNil ifTrue: [
			self addBitmaps: dict.
			^dict ] ].
	^nil! 
fromModule: moduleName idMap: idMap
		"Private - Answer a new initialized instance loaded from the specified module.
			Answer nil if there is no such file."
	| answer |
    answer := self new.
	idMap associationsDo: [ :eachAssoc |
		answer at: eachAssoc key put: (
			Bitmap fromModule: moduleName id: eachAssoc value ) ].
	answer name: moduleName asLowerCase.
    ^answer!   
validBitmapName: aString
		"Answer a valid bitmap name."
	| answer |
	(answer := aString ifNil: [ '' ]
		) isEmpty ifTrue: [ answer := 'NoName' ].
	answer first isLowerCase ifTrue: [
		answer :=
			(String with: answer first asUpperCase),
			(answer copyFrom: 2 to: answer size) ].
	^answer!  
initialize
		"Initialize the receiver."
	super initialize.
	bitmaps := Dictionary new.
	name := ''.!  
keys
		"Answer the receiver's keys."
	^self bitmaps keys!   
wbOutputToFile: aFileName
        "Private - WB Development.
			Output the receiver in DIB format to aFileName.
			Work around digitalks problem not being able to output
			bitmaps loaded from a resource DLL."
    #addedByOSI.
	self archive isArray
		ifTrue: [
			self cpCopy
				outputToFile: aFileName;
				release ]
		ifFalse: [
			self
				outputToFile: aFileName ].!  
size
		"Answer the # of elements in the receiver."
	^self flat size!
invalidBitmap: aBitmap
		"Private - Report an error to the user."
	^self error: 'invalid bitmap: ', aBitmap printString!
validateSystem
		"Validate all the system bitmaps in on operation."
	Bitmap validateAll: self system flat.! 
removeAll
		"Remove all bitmaps from the receiver."
	self flat removeAll.
	groups := Dictionary new.!  
flatName
		"Answer the receiver's flat name (global pool name)."
	^flatName!
groupNames
		"Answer a collection of group names."
	^self groups keys!  
addAll: aCollection
		"Add all of the elements in aCollection to the receiver."
	self bitmaps addAll: aCollection.! 
at: key
        "Answer the element associated with the key."
	^self bitmaps at: key!   
anyBitmap
        "Answer any bitmap or nil if none loaded."
    self flat do: [ :each | ^each ].
    ^nil!
includesKey: aString
		"Answer true if the receiver includes the specified key."
	^self bitmaps includesKey: aString!   
removeKey: aString
		"Remove the specified bitmap from the receiver."
	self flat removeKey: aString.
	self groups do: [ :eachGroup |
		eachGroup removeKey: aString ifAbsent: [ ] ].! 
current
		"Answer the current bitmap manager."
	^Current ifNil: [
		Current := self new
			initialize: #WBBitmaps
			name: #current ]!   
flat
		"Answer the flat representation of the receiver."
	^flat!
at: aString ifAbsent: aBlock
		"Answer the bitmap at aString.
			Answer aBlock evaluated if no bitmap is found."
	^self flat at: aString ifAbsent: aBlock! 
fromPath: aString
		"Private - Answer a new initialized instance loaded from the specified file.
			Answer nil if there is no such file."
    | stream answer |
    stream := File pathName: aString.
    stream nextLine = 'BITMAPS' ifFalse: [
        stream close.
        MessageBox message: 'The file named "', aString fileNameLessPath, '" is not a valid bitmap dictionary file.'.
        ^nil ].
    answer := self new.
	[ [ stream atEnd ] whileFalse: [
       answer
			at: (answer validNewBitmapName: stream nextLine)
			put: (Bitmap fromStream: stream) ].
	] ensure: [ stream close ].
	answer name: aString fileNameLessPath asLowerCase.
    ^answer! 
isFixedGroup
		"Answer true if the receiver is a fixed group."
	^true!  
invalidBitmapName: aString
		"Private - Report an error to the user."
	^self error: 'invalid bitmap name: ', aString printString!   
removeKey: aString ifAbsent: aBlock
		"Remove the key and the associated value.
			If no such key, then answer aBlock evaluated."
	^self bitmaps removeKey: aString ifAbsent: aBlock!  
standardWBBitmapIDMap
		"Answer the standard window builder bitmap id map."
	^Dictionary new
		at: 'WBCalculatorBitmap' put: 101;
		at: 'WBCameraBitmap' put: 102;
		at: 'WBCheckBoxBitmap' put: 103;
		at: 'WBCheckBoxOnBitmap' put: 104;
		at: 'WBClearBitmap' put: 105;
		at: 'WBCopyBitmap' put: 106;
		at: 'WBCrayonsBitmap' put: 107;
		at: 'WBCutBitmap' put: 108;
		at: 'WBCutCopyPasteBitmap' put: 109;
		at: 'WBDateTimeBitmap' put: 110;
		at: 'WBDiscBitmap' put: 111;
		at: 'WBDivideBitmap' put: 112;
		at: 'WBGraphBitmap' put: 113;
		at: 'WBGreaterThan10Bitmap' put: 114;
		at: 'WBHandshakeBitmap' put: 115;
		at: 'WBLetterBitmap' put: 116;
		at: 'WBMinusBitmap' put: 117;
		at: 'WBMonaLisaBitmap' put: 118;
		at: 'WBMovieBitmap' put: 119;
		at: 'WBOpenNewBitmap' put: 120;
		at: 'WBOrgChartBitmap' put: 121;
		at: 'WBPasteBitmap' put: 122;
		at: 'WBPlusBitmap' put: 123;
		at: 'WBRadioButtonBitmap' put: 124;
		at: 'WBRadioButtonOnBitmap' put: 125;
		at: 'WBSaveBitmap' put: 126;
		at: 'WBTimesBitmap' put: 127;
		at: 'WBToolPaneExampleBitmap' put: 128;
		yourself.
!  
at: key put: element
        "Associate the element with the key."
	^self bitmaps at: key put: element! 
initialize: aSymbol
		"Initialize the receiver on the specified pool."
	bitmaps := Smalltalk at: aSymbol.
	name := aSymbol.!   
name
		"Answer the receiver's name."
	^name ifNil: [ '<unnamed>' ]! 
addFixedBitmapPoolNamed: aSymbol
		"Add a fixed bitmap pool to the receiver."
	self addBitmaps: (
		WBFixedBitmapGroup
			onPoolNamed: aSymbol ).!
addBitmaps: aWBBitmapGroup
		"Add the bitmaps in aWBBitmapGroup."
	| dict |
	(dict := self groups
		at: aWBBitmapGroup name
		ifAbsent: [
			self groups
				at: aWBBitmapGroup name
				put: aWBBitmapGroup ]
		) == aWBBitmapGroup ifFalse: [
			dict bitmaps == aWBBitmapGroup bitmaps ifFalse: [
				dict addAll: aWBBitmapGroup bitmaps ] ].
	self flat addAll: aWBBitmapGroup bitmaps.! 
validBitmapName: aString
		"Answer a valid bitmap name."
	^WBBitmapGroup validBitmapName: aString!  
addBitmapsFromFile: aFileName
		"Load the bitmaps in aFileName. Answer a dictionary
			containing the bitmaps loaded or nil."
	| path dict |
	(path := File findOrPromptFileName: aFileName) notNil ifTrue: [
		(dict := WBBitmapGroup fromPath: path) notNil ifTrue: [
			self addBitmaps: dict.
			^dict ] ].
	^nil!
readConversionsFrom: aFileName
		"Private - Load the receiver's bitmaps."

    | file bitmapFile key |

    self isEmpty ifFalse: [
        self values do: [ :bitmap | bitmap release ].
        self keys do: [ :k | self removeKey: k ].
    ].
    file := File pathName: aFileName.
    [ file atEnd ] whileFalse: [
        key := file nextLine asSymbol.
        bitmapFile := file nextLine.
        self at: key put: (Bitmap fromFile: bitmapFile).
    ].
    file close.
!   
saveConversionsOn: aFileName in: dir
		"Private - Save the receiver's bitmaps."

    | file bitmapFile count |

    file := File newFile: dir, aFileName.
    count := 0.
    self keysDo: [:k |
        count := count + 1.
        bitmapFile := 'B', count asString, '.BMP'.
        file nextPutAll: k; cr; nextPutAll: dir, bitmapFile; cr.
        (self at: k) wbOutputToFile: dir, bitmapFile.
    ].
    file close.!   
validBitmapName: aString
		"Answer a valid bitmap name."
	^self class validBitmapName: aString! 
associationAt: aKey
        "Answer the Association whose key equals aKey
         from the receiver.  If not found, report an error."
	^self flat associationAt: aKey!
wbOutputToFileStream: aFileStream
        "Private - WB Development.
			Output the receiver in DIB format to aFileName.
			Work around digitalks problem not being able to output
			bitmaps loaded from a resource DLL."
    #addedByOSI.
	self archive isArray
		ifTrue: [
			self cpCopy
				outputToFileStream: aFileStream;
				release ]
		ifFalse: [
			self
				outputToFileStream: aFileStream ].!  
system
		"Answer the system bitmap manager."
	^System ifNil: [
		System := self new
			initialize: #WBSystemBitmaps
			name: #system ]!  
rename: oldBitmapName to: newBitmapName
		"Rename the specified bitmap."
	| dict bitmap old new |
	old := self validBitmapName: oldBitmapName.
	new := self validBitmapName: newBitmapName.
	dict := self groups
		detect: [ :each | each includesKey: old ]
		ifNone: [ ^self ].
	bitmap := dict at: old.
	dict
		removeKey: old;
		at: new put: bitmap.
	self flat
		removeKey: old;
		at: new put: bitmap.!  
keysFor: aGroupName
		"Answer a collection of bitmap keys."
	^(self groups at: aGroupName) keys!
name: aString
		"Private - Set the receiver's name."
	name := aString.! 
groups
		"Private - Answer a collection of groups."
	^groups!   
initBitmaps: aDictionary
		"Private - Initialize the receiver's bitmaps."
	bitmaps := aDictionary.! 
at: aString
		"Answer the bitmap at aString.
			Report an error if no bitmap is found."
	^self at: aString ifAbsent: [ self errorBitmapNotFound: aString ]!
addBitmapPoolNamed: aSymbol
		"Add a bitmap pool to the receiver."
	self addBitmaps: (
		WBBitmapGroup
			onPoolNamed: aSymbol ).!
associationsDo: iterationBlock
		"Evaluate the <iterationBlock> once for each key/value pair,
		represented as an Association, in the receiver.
		If the receiver is empty, the block will not be evaluated."
	self flat associationsDo: iterationBlock.! 
validNewBitmapName: aString
		"Answer a new valid bitmap name."
	^self class validBitmapName: aString!  
initialize: aPoolName name: aSymbol
		"Private - Initialize the receiver."
	flat := Smalltalk at: aPoolName ifAbsent: [
		Smalltalk at: aPoolName put: Dictionary new ].
	groups := Dictionary new.
	name := aSymbol.
	flatName := aPoolName.!  
keyAtValue: anObject ifAbsent: aBlock
		"Answer the key for anObject.
			If not found then answer aBlock evaluated."
	^self flat
		keyAtValue: anObject
		ifAbsent: aBlock!  
managers
		"Answer a collection of known bitmap managers."
	^Array
		with: self current
		with: self system!  
isGlobalPool
		"Answer true if the receiver represents a global bitmap pool."
	^self name isSymbol and: [
		self bitmaps notNil and: [
			(Smalltalk at: self name ifAbsent: [ nil ]
				) == self bitmaps ] ]!  
isEmpty
        "Answer true if the receiver collection
         contains no elements, else answer false."
    ^self flat isEmpty! 
at: aString put: aBitmap
		"Set the bitmap at aString."
	aString = (self validBitmapName: aString) ifFalse: [
		^self invalidBitmapName: aString ].
	aBitmap isBitmap ifFalse: [
		^self invalidBitmap: aBitmap ].
	self groups do: [ :eachGroup |
		(eachGroup includesKey: aString) ifTrue: [
			eachGroup at: aString put: aBitmap ] ].
	^self flat at: aString put: aBitmap! 
at: key ifAbsent: aBlock
        "Answer the element associated with the key.
			If not found, then answer aBlock evaluated."
	^self bitmaps at: key ifAbsent: aBlock! 
name
		"Answer the receiver's name."
	^name!
associationsDo: iterationBlock
    "Evaluate the <iterationBlock> once for each key/value pair, represented as an Association, in the receiver. If the receiver is empty, the block will not be evaluated."

    ^self bitmaps associationsDo: iterationBlock! 
bitmaps
		"Answer the receiver's bitmaps."
	^bitmaps!   
saveOn: aFileName
		"Private - Save the receiver's bitmaps."

    | file |

    file := File newFile: aFileName.
    file nextPutAll: 'BITMAPS'; cr.
    self keys do: [:k |
        file nextPutAll: k; cr.
        (self at: k) wbOutputToFileStream: file.
    ].
    file close.!  
onPoolNamed: aSymbol
		"Answer an instance of the receiver on the specified pool."
	^self new initialize: aSymbol!