05/02/95 10:57:19 PM

wbAction
    "Added by OSI"
    #addedByOSI.
	#obsoleteMethod.
    ^WBAction! 
appendItem: aLabelString link: aViewManagerClassName type: linkType
    "Added by OSI - create a menu item that links to another window"
    #addedByOSI.
    self obsoleteMethod.
    ^self appendItem: aLabelString link: aViewManagerClassName type: linkType acceleratorString: ''!   
receiver: firstObject originator: secondObject script: aCollection

    ^(self new)
        receiver: firstObject;
        originator: secondObject;
        script: aCollection!
appendItem: aLabelString link: aViewManagerClassName type: linkType acceleratorString: aString
    "Added by OSI - create a menu item that links to another window"
    | aMessage |
    #addedByOSI.
    self obsoleteMethod.
    (Smalltalk includesKey: aViewManagerClassName asSymbol) ifFalse: [
        aMessage := (Message new)
            receiver: MessageBox selector: #message:
                arguments: #('Link Menu Error!!');
            yourself.
    ] ifTrue: [
        aMessage := Message new.
        aMessage receiver: (Smalltalk at: aViewManagerClassName asSymbol).
        linkType asSymbol == #Child ifTrue: [
            aMessage selector: #openWithParent:; arguments: (Array with: self owner).
        ] ifFalse: [ linkType asSymbol == #Sibling ifTrue: [
            aMessage selector: #openWithMyParent:; arguments: (Array with: self owner).
        ] ifFalse: [ linkType asSymbol == #MDIChild ifTrue: [
            aMessage selector: #openWithMDIParent:; arguments: (Array with: self owner).
        ] ifFalse: [
            aMessage selector: #open; arguments: #().
        ]]].
    ].
    self appendItem: aLabelString selector: aMessage acceleratorString: aString!  
perform: aSymbol on: aViewManager

    ^(self window: aViewManager action: aSymbol) perform!
supportedEvents
        "Private - Answer the Set of events that LinkButtons can notify
         their owners about."
    ^super supportedEvents
        remove: #clicked;
        yourself! 
window: aViewManager button: anActionButton

    ^(self new)
        receiver: aViewManager;
        originator: anActionButton!  
Sibling
    "Private - Open the link as an sibling window."

    ^self linkClass new openWithMyParent: self owner! 
receiver: anObject

    ^self new receiver: anObject!   
missingAction: aSymbol
    ^MessageBox message: 'Missing action: ',aSymbol,'!!'! 
window

    ^receiver!  
button

    ^originator!
linkClass
    "Private - Answer the link class of the receiver."

    ^Smalltalk at: self link ifAbsent: [ nil ]!  
link
		"Answer the ViewManager subclass to which the button should link."
    ^link!
actionCancel
"
Created by OSI - Jan 26, 1993
"
"Close the window"
    ^self window close!
isWBAction

    ^true!  
receiver: firstObject originator: secondObject

    ^(self new)
        receiver: firstObject;
        originator: secondObject!  
performAction
        "Private - Deferred control message handling routine."

    [ self perform: self type ]
        on: Error
        do: [ :error |
            self linkClass isNil ifTrue: [
                ^MessageBox message: 'Missing Link [',self link asString,']!!'. ].
            (self respondsTo: self type) ifFalse: [
                ^MessageBox message: 'Invalid link type [',self type asString,']!!!!' ].
            error defaultAction ]!
notifyDoubleClicked: aParameter
        "Private - Deferred control message handling routine."

    self performAction.!   
Independent
    "Private - Open the link as an independent window."

    ^self linkClass new open! 
perform

    self receiver isNil ifTrue: [ self halt.
        ^MessageBox message: 'Receiver not defined!!'
    ] ifFalse: [self script isString ifTrue: [
        (self class listActions includes: self script asString) ifTrue: [
            ^self perform: ('action',self script) asSymbol
        ] ifFalse: [
            ^self missingAction: self script
        ]
    ] ifFalse: [ self script isCollection ifTrue: [
        self script do: [ :action |
            (self class listActions includes: action asString) ifTrue: [
                self perform: ('action',action) asSymbol
            ] ifFalse: [
                ^self missingAction: action
            ]
        ].
    ]]].!   
script: aCollection

    script := aCollection.
    ^self! 
Child
    "Private - Open the link as an child window."

    ^self linkClass new openWithParent: self owner!   
menuItem

    ^originator!  
notifyClicked: aParameter
        "Private - Deferred control message handling routine."

    self performAction.! 
link: aSymbol
		"Specify the ViewManager subclass to which the button should link.
			The argument should be specified as a Symbol."
    link := aSymbol!  
type
		"Answer the type of link that should be performed."
    ^type!   
script

    ^script!
receiver

    ^receiver!
originator: anObject

    originator := anObject.
    ^self!   
MDIChild
    "Private - Open the link as an MDI child window."

    ^self linkClass new openWithMDIParent: self owner! 
originator

    ^originator!
window: aViewManager

    ^self new receiver: aViewManager! 
performAction
        "Private - Deferred control message handling routine."

    self action notNil ifTrue: [
        WBAction
            perform: self action
            on: self topParent owner
            with: self ].!   
listActions
    | list class stream |
    list := OrderedCollection new.
    class := self.
    [ class name = 'Object' ] whileFalse: [
        list addAll:
            ((class methodDictionary keys asSortedCollection select: [ :selector |
                selector beginsWith: 'action' ]) collect: [ :method |
                    method copyFrom: 7 to: method size ]).
        class := class superclass
    ].
    ^list!   
missingAction
    ^MessageBox message: 'Missing action: ',self script!   
performAction: aSymbol

    ^(self new script: aSymbol) perform!
window: aViewManager action: aSymbol

    ^(self new)
        receiver: aViewManager;
        script: aSymbol!
notifyClicked: aParameter
        "Private - Deferred control message handling routine."

    self performAction.! 
actionInspect
"
Created by OSI - Jan 26, 1993
"
"Inspect the window"
    ^self window inspect!   
target

    ^receiver!  
appendItem: aLabelString action: aSymbol acceleratorString: aString
    "Added by OSI - create a menu item that performs an action"
    | aMessage |
    #addedByOSI.
	self obsoleteMethod.
    aMessage := (Message new)
            receiver: (self wbAction window: self owner action: aSymbol)
            selector: #perform
            arguments: #()
            yourself.

    self appendItem: aLabelString selector: aMessage acceleratorString: aString!   
supportedEvents
        "Private - Answer the Set of events that ActionButtons can notify
         their owners about."
    ^super supportedEvents
        remove: #clicked;
        yourself!   
receiver: anObject

    receiver := anObject.
    ^self!   
action
		"Answer the action to be performed by the button when it is clicked."
    ^action! 
notifyDoubleClicked: aParameter
        "Private - Deferred control message handling routine."

    self performAction.!   
type: aSymbol
		"Specify the type of link that should be performed.
			The allowable choices are: #Independent, #Child, and #Sibling."
    type := aSymbol!
action: aSymbol
		"Specify the action to be performed by the button when it is clicked.
			To get a list of available actions do the following:
			WBAction listActions inspect. New actions may be created with
			the ActionButton attribute editor."
    action := aSymbol!   
window: aViewManager button: anActionButton action: aSymbol

    ^(self new)
        receiver: aViewManager;
        originator: anActionButton;
        script: aSymbol!
perform: aSymbol on: aViewManager with: anActionButton

    ^(self window: aViewManager button: anActionButton action: aSymbol) perform!