05/02/95 11:07:17 PM

updateFields

    "Update the fields with the current person's data.
     Then set the changed flag to false"

    (self paneNamed: 'firstName') setContents: currentPerson firstName.
    (self paneNamed: 'lastName') setContents: currentPerson lastName.
    (self paneNamed: 'title') setContents: currentPerson title.
    (self paneNamed: 'company') setContents: currentPerson company.
    changed := false.!  
menuExit

    "Callback for the menu item titled 'Exit'.
     (Generated by WindowBuilder)"

    self saveChanges ifFalse: [^self].
    self close! 
title: aString

    title := aString!   
initPersonList

    "Initialize the list of people"
    " PersonEditor initPersonList "

    PersonList := (SortedCollection sortBlock: [:a :b | a lastName <= b lastName])
        add: (Person
            new firstName: 'Eric';
            lastName: 'Clayberg';
            company: 'Objectshare Systems';
            title: 'Exec. Vice President');
        add: (Person
            new firstName: 'S.';
            lastName: 'Sridhar';
            company: 'Objectshare Systems';
            title: 'Director Product Development');
        add: (Person
            new firstName: 'Robert';
            lastName: 'Yerex';
            company: 'Objectshare Systems';
            title: 'President');
        add: (Person
            new firstName: 'Dina';
            lastName: 'Fischer';
            company: 'Objectshare Systems';
            title: 'Chief Financial Officer');
        add: (Person
            new firstName: 'Dan';
            lastName: 'Rubel';
            company: 'Objectshare Systems';
            title: 'Project Manager');
        add: (Person
            new firstName: 'James';
            lastName: 'Chan';
            company: 'Objectshare Systems';
            title: 'Director of Operations');
        yourself!
lastName: aString

    lastName := aString! 
initWindow

    "Initialize the window to be initially unchanged with
     a new empty person to be edited"

    changed := false.
    self menuNew.
    self mainView children do: [:child |
        child font: SysFont].!  
firstName

    ^firstName!  
menuSave

    "Callback for the menu item titled 'Save'.
     (Generated by WindowBuilder)"

    "Update the person's data and set the changed flag to false"

    self updatePerson.
    changed := false.

    "If the person is not in the list (e.g., a new person),
     add them to the list"

    (self class personList includes: currentPerson)
        ifFalse: [self class personList add: currentPerson].!  
previous

    "Callback for the #clicked event in the Button named 'previous'.
     (Generated by WindowBuilder)"

    | index |
    self saveChanges ifFalse: [^self].

    "Find the previous person in the list based on the index of
     the current person. Make sure that the list wraps correctly"

    index := self class personList indexOf: currentPerson.
    index <= 1 ifTrue: [index := self class personList size + 1].
    currentPerson := self class personList at: index - 1.
    self updateFields.!  
printOn: aStream

    aStream nextPutAll: self name!
menuNew

    "Callback for the menu item titled 'New'.
     (Generated by WindowBuilder)"

    self saveChanges ifFalse: [^self].
    currentPerson := Person new.
    self updateFields.! 
next

    "Callback for the #clicked event in the Button named 'next'.
     (Generated by WindowBuilder)"

    | index |
    self saveChanges ifFalse: [^self].

    "Find the next person in the list based on the index of
     the current person. Make sure that the list wraps correctly"

    index := self class personList indexOf: currentPerson.
    index == self class personList size ifTrue: [index := 0].
    currentPerson := self class personList at: index + 1.
    self updateFields.!  
personList

    "Return the list of people"

    PersonList isNil ifTrue: [self initPersonList].
    ^PersonList!
company

    ^company!  
loadList: aPane

    "Callback for the #needsContents event in the ListBox named 'personList'.
     (Generated by WindowBuilder)"

    aPane contents: self personList!  
firstName: aString

    firstName := aString!   
saveChanges

    "If the current person's data has changed, ask whether the user
     would like to save the data. Return false if the user requests to
     cancel, true otherwise. Any operation that will load a new person
     in the editor should call this first."

    | answer |

    "If nothing has changed, return immediately"
    changed ifFalse: [^true].

    "Ask the question"
    answer := MessageBox
        threeStateNotify: 'Save Changes?'
        withText: 'Do you want to save changes to "', self currentName, '"?'.

    "If the user selected 'Cancel', return false"
    answer isNil ifTrue: [^false].

    "If the user selected 'Yes', do the save"
    answer ifTrue: [self menuSave].

    ^true!   
createMenus: aPane

		"WARNING!! This method was automatically generated by 
		WindowBuilder. Code you add here which does not conform to 
		the WindowBuilder API will probably be lost the next time 
		you save your layout definition."

	aPane menuWindow
	    yourself;
	    addMenu: (
	        Menu new
	            title: '&File';
	            owner: self;
	            appendItem: '&New	Ctrl+N' selector: #menuNew acceleratorString: 'Ctrl+N';
	            appendItem: '&Open	Ctrl+O' selector: #menuOpen acceleratorString: 'Ctrl+O';
	            appendSeparator;
	            appendItem: '&Save	Ctrl+S' selector: #menuSave acceleratorString: 'Ctrl+S';
	            appendItem: '&Revert	Ctrl+R' selector: #menuRevert acceleratorString: 'Ctrl+R';
	            appendSeparator;
	            appendItem: '&Delete	Ctrl+D' selector: #menuDelete acceleratorString: 'Ctrl+D';
	            appendSeparator;
	            appendItem: 'E&xit	Alt+F4' selector: #menuExit acceleratorString: 'Alt+35'
	    )! 
currentName

    "Return the name based on the first and last name fields"

    ^(self paneNamed: 'firstName') contents, ' ', (self paneNamed: 'lastName') contents!  
updatePerson

    "Update the current person with the data from the fields"

    currentPerson
        firstName: (self paneNamed: 'firstName') contents;
        lastName: (self paneNamed: 'lastName') contents;
        title: (self paneNamed: 'title') contents;
        company: (self paneNamed: 'company') contents.! 
initialize

    firstName := ''.
    lastName := ''.
    company := ''.
    title := ''.!
aboutToClose

    "Callback for the #aboutToClose event in the TopPane 'mainView'.
     (Generated by WindowBuilder)"

    "To abort t eclose operation, use 'self mainView abortClose'."

    self saveChanges ifFalse: [^self mainView abortClose].

    "For the close operation to proceed normally, just
      return normally."

    ^self! 
title

    ^title!  
createViews

		"WARNING!! This method was automatically generated by 
		WindowBuilder. Code you add here which does not conform to 
		the WindowBuilder API will probably be lost the next time 
		you save your layout definition."

	| company companyLabel employmentGroup firstLabel firstName 
	lastLabel lastName mainView nameGroup next previous title 
	titlelable |
	
	mainView := self topPaneClass new.
	
		"Temporary Variables"
	company := WBEntryField new.
	companyLabel := StaticText new.
	employmentGroup := GroupBox new.
	firstLabel := StaticText new.
	firstName := WBEntryField new.
	lastLabel := StaticText new.
	lastName := WBEntryField new.
	nameGroup := GroupBox new.
	next := Button new.
	previous := Button new.
	title := WBEntryField new.
	titlelable := StaticText new.
	
	mainView "PersonEditor"
		owner: self;
		paneName: 'mainView';
		when: #aboutToClose send: #aboutToClose to: self;
		labelWithoutPrefix: 'Person Editor';
		noSmalltalkMenuBar;
		pStyle: #(sysmenu sizable titlebar minimize maximize);
		framingBlock:
			(FramingParameters new
				iDUE: 878 @ 440;
				xC; yC; cRDU: (9 @ 84 rightBottom: 869 @ 432)).
	self addView: mainView.
	
	firstName "WBEntryField"
		owner: self;
		paneName: 'firstName';
		when: #textChanged: send: #textChanged: to: self;
		framingBlock:
			(FramingParameters new
				iDUE: 302 @ 48;
				lP: 2/47; rP: 37/94;
				tDU: 96 r: #top; bDU: 144 r: #top; 
				indent: 3 @ 4);
		startGroup;
		tabStop.
	mainView addSubpane: firstName.
	
	lastName "WBEntryField"
		owner: self;
		paneName: 'lastName';
		when: #textChanged: send: #textChanged: to: self;
		framingBlock:
			(FramingParameters new
				iDUE: 466 @ 48;
				lP: 39/94; rP: 45/47;
				tDU: 96 r: #top; bDU: 144 r: #top; 
				indent: 3 @ 4);
		startGroup;
		tabStop.
	mainView addSubpane: lastName.
	
	title "WBEntryField"
		owner: self;
		paneName: 'title';
		when: #textChanged: send: #textChanged: to: self;
		framingBlock:
			(FramingParameters new
				iDUE: 421 @ 48;
				lP: 11/47; rP: 34/47;
				tDU: 216 r: #top; bDU: 264 r: #top; 
				indent: 3 @ 4);
		startGroup;
		tabStop.
	mainView addSubpane: title.
	
	company "WBEntryField"
		owner: self;
		paneName: 'company';
		when: #textChanged: send: #textChanged: to: self;
		framingBlock:
			(FramingParameters new
				iDUE: 421 @ 48;
				lP: 11/47; rP: 34/47;
				tDU: 272 r: #top; bDU: 320 r: #top; 
				indent: 3 @ 4);
		startGroup;
		tabStop.
	mainView addSubpane: company.
	
	next "Button"
		owner: self;
		paneName: 'next';
		when: #clicked send: #next to: self;
		framingBlock:
			(FramingParameters new
				iDUE: 183 @ 72;
				lP: 36/47; rP: 46/47;
				tDU: 184 r: #top; bDU: 256 r: #top);
		contents: '&Next';
		startGroup;
		tabStop.
	mainView addSubpane: next.
	
	previous "Button"
		owner: self;
		paneName: 'previous';
		when: #clicked send: #previous to: self;
		framingBlock:
			(FramingParameters new
				iDUE: 183 @ 72;
				lP: 36/47; rP: 46/47;
				tDU: 264 r: #top; bDU: 336 r: #top);
		contents: '&Previous';
		startGroup;
		tabStop.
	mainView addSubpane: previous.
	
	firstLabel "StaticText"
		owner: self;
		paneName: 'firstLabel';
		framingBlock:
			(FramingParameters new
				iDUE: 302 @ 32;
				lP: 2/47; rP: 37/94;
				tDU: 64 r: #top; bDU: 96 r: #top);
		contents: 'First';
		startGroup.
	mainView addSubpane: firstLabel.
	
	lastLabel "StaticText"
		owner: self;
		paneName: 'lastLabel';
		framingBlock:
			(FramingParameters new
				iDUE: 466 @ 32;
				lP: 39/94; rP: 45/47;
				tDU: 64 r: #top; bDU: 96 r: #top);
		contents: 'Last';
		startGroup.
	mainView addSubpane: lastLabel.
	
	titlelable "StaticText"
		owner: self;
		paneName: 'titlelable';
		framingBlock:
			(FramingParameters new
				iDUE: 165 @ 32;
				lP: 3/94; rP: 21/94;
				tDU: 224 r: #top; bDU: 256 r: #top);
		rightJustified;
		contents: 'Title:';
		startGroup.
	mainView addSubpane: titlelable.
	
	companyLabel "StaticText"
		owner: self;
		paneName: 'companyLabel';
		framingBlock:
			(FramingParameters new
				iDUE: 165 @ 32;
				lP: 3/94; rP: 21/94;
				tDU: 280 r: #top; bDU: 312 r: #top);
		rightJustified;
		contents: 'Company:';
		startGroup.
	mainView addSubpane: companyLabel.
	
	employmentGroup "GroupBox"
		owner: self;
		paneName: 'employmentGroup';
		framingBlock:
			(FramingParameters new
				iDUE: 622 @ 168;
				lP: 1/47; rP: 35/47;
				tDU: 168 r: #top; bDU: 336 r: #top);
		contents: 'Employment';
		startGroup.
	mainView addSubpane: employmentGroup.
	
	nameGroup "GroupBox"
		owner: self;
		paneName: 'nameGroup';
		framingBlock:
			(FramingParameters new
				iDUE: 823 @ 144;
				lP: 1/47; rP: 46/47;
				tDU: 16 r: #top; bDU: 160 r: #top);
		contents: 'Name';
		startGroup.
	mainView addSubpane: nameGroup.
	
	self createMenus: mainView!
cancel

    "Callback for the #clicked event in an unnamed Button (contents is 'Cancel').
     (Generated by WindowBuilder)"

    selectedPerson := nil.
    self close.!   
select: ignore

    "Callback for the #clicked event in an unnamed Button (contents is 'Select').
     (Generated by WindowBuilder)"

    selectedPerson := (self paneNamed: 'personListBox') selectedItem.
    self close.!
company: aString

    company := aString!   
menuRevert

    "Callback for the menu item titled 'Revert'.
     (Generated by WindowBuilder)"

    "If nothing has changed, there is no need to revert"
    changed ifFalse: [^self].

    (MessageBox confirm: 'Are you sure you want to revert "', self currentName, '" to their orginal data?')
        ifTrue: [self updateFields]!
new

    ^super new initialize! 
textChanged: aString

    "Callback for the #textChanged event in the EntryField named 'firstName'.
     (Generated by WindowBuilder)"

    "The user has typed something. This will trigger a 'Save Changes?'
     dialog when the user attempts to load a different person"

    changed := true!   
lastName

    ^lastName!
menuOpen

    "Callback for the menu item titled 'Open'.
     (Generated by WindowBuilder)"

    | selectedPerson |
    self saveChanges ifFalse: [^self].

    "Select a person via the selection dialog. If a person is selected
     load that person into the editor"

    selectedPerson := SelectPersonDialog new open selectedPerson.
    selectedPerson isNil
        ifFalse: [
            currentPerson := selectedPerson.
            self updateFields].! 
menuDelete

    "Callback for the menu item titled 'Delete'.
     (Generated by WindowBuilder)"

    (MessageBox confirm: 'Are you sure you want to delete "', self currentName, '"?')
        ifTrue: [
            "Remove the current person and load a new empty person in the editor"
            self class personList remove: currentPerson ifAbsent: [nil].
            changed := false.
            self menuNew]!
selectedPerson

    "Return the selected person from the dialog"

    ^selectedPerson!
wbBasicVersion
		"Private - Answer the window builder version."
	^2.0!  
name

    ^firstName , ' ' , lastName!  
createViews

		"WARNING!! This method was automatically generated by 
		WindowBuilder. Code you add here which does not conform to 
		the WindowBuilder API will probably be lost the next time 
		you save your layout definition."

	| cancel mainView personListBox select |
	
	mainView := self topPaneClass new.
	
		"Temporary Variables"
	cancel := Button new.
	personListBox := ListBox new.
	select := Button new.
	
	mainView "SelectPersonDialog"
		owner: self;
		paneName: 'mainView';
		labelWithoutPrefix: 'Select Person';
		noSmalltalkMenuBar;
		pStyle: #(sysmenu modal titlebar);
		framingBlock:
			(FramingParameters new
				iDUE: 649 @ 432;
				xC; yC; cRDU: (0 @ 0 rightBottom: 649 @ 432)).
	self addView: mainView.
	
	personListBox "ListBox"
		owner: self;
		paneName: 'personListBox';
		when: #needsContents send: #loadList: to: self withArgument: personListBox;
		when: #doubleClicked: send: #select: to: self;
		framingBlock:
			(FramingParameters new
				iDUE: 613 @ 320;
				lDU: 18 r: #left; rDU: 631 r: #left;
				tDU: 16 r: #top; bDU: 336 r: #top);
		startGroup;
		tabStop.
	mainView addSubpane: personListBox.
	
	select "Button"
		owner: self;
		paneName: 'select';
		when: #clicked send: #select: to: self withArgument: select;
		framingBlock:
			(FramingParameters new
				iDUE: 137 @ 64;
				lDU: 18 r: #left; rDU: 155 r: #left;
				tDU: 352 r: #top; bDU: 416 r: #top);
		defaultPushButton;
		contents: '&Select';
		startGroup;
		tabStop.
	mainView addSubpane: select.
	
	cancel "Button"
		owner: self;
		paneName: 'cancel';
		when: #clicked send: #cancel to: self;
		framingBlock:
			(FramingParameters new
				iDUE: 146 @ 64;
				lDU: 174 r: #left; rDU: 320 r: #left;
				tDU: 352 r: #top; bDU: 416 r: #top);
		cancelPushButton;
		contents: 'Cancel';
		startGroup;
		tabStop.
	mainView addSubpane: cancel!  
personList

    "Return the list of people"

    ^PersonEditor personList!
wbBasicVersion
		"Private - Answer the window builder version."
	^2.0!