
"--- Revision History
2.0.0.1.0.1 fixed opening window w/ menu causing walkback
2.0.0.1.0.2 fixed 'when: #none send:' problem
2.0.0.1.0.3 fixed EnhancedEntryField maxSize walkback
2.0.0.1.0.4 fixed event code gen for mainView
2.0.0.1.0.5 fixed DrawnButton styles - no longer uses cpStyle method
2.0.0.1.0.6 fixed wbBasicVersion code generation
2.0.0.1.0.7 fixed DialogCoordinator launch and sizing problems
2.0.0.1.0.8 fixed multi-view manager support in VST (worked fine in VSE)
2.0.0.1.0.9 fixed GraphPane code gen to no longer generate 'receiveAllWindowMessages'
2.0.0.1.0.10 fixed class recompilation to prevent msg to Transcript
2.0.0.1.0.11 fixed FramingParameter code generation
2.0.0.1.0.12 added Window>>iconFile/: methods
2.0.0.1.0.13 fixed PMultiSelListBox>>importantEvents
2.0.0.1.0.15 partsSupportEnabled fix
2.0.0.1.0.16 storeColorOn: methods for Integer and String
2.0.0.1.0.17 fixed prepareAppWindowsForSave: to remove old pools such as WinConstants, PMConstants, WBConstants and replace with OperatingSystemConstants
2.0.0.1.0.18 code generation fix for messageSelector
2.0.0.1.0.19 added WsTabstop style in SubPane>>tabStop
2.0.0.1.0.20 fixed Bitmap>>fromSysId:
2.0.0.2 fixed 'when: #none send:' problem
2.0.0.3 fixed opening window w/ menu causing walkback
2.0.0.4 fixed WBBitmapManagerViewer walkback on open
2.0.0.7 made menus platform independent
2.0.0.8 added method to convert all module bitmaps (from resource DLL) to bitmaps stored in image
2.0.0.11 fixed ComboBox overlap problem via WBComboBox... problem still exists in ComboBox
2.0.0.15 FramingParameters cache dialog units
2.0.0.17 changed FramingParameters new to FramingParameters newDU
2.0.0.19 added old FramingParameter support
2.0.0.26 changed colors in WBPartsInterfaceEditor
2.0.0.28 fixed drag from WB to Parts
2.0.0.32 fixes for Subpanes/V
2.0.0.35 os/2 beta - fixes for Subpanes and WKCUA
2.0.0.41 added 4 bit and 8 bit bitmap methods
2.0.0.44 fixed parts support for CompositePanes with new wb base runtime method Object>>isPARTSInstalled
2.0.0.46 fixed CompositePane in Parts Workbench
2.0.1.0.0.5 changed SLL names (libraryFileName annotation) from WB20 -> WB2A and fixed installer
2.0.1.0.0.7 integrate into 3.0.1
--- end of Revision History"  !

"--------- add temporary methods"!

!String methods !  
osiMethods
        "Answer self as the class reader so that errors
            like missing classes and methods referencing globals
            not in the image can failed gracefully."
    ^self! !

!String methods !  
osiMethods: aString
        "Answer self as the class reader so that errors
            like missing classes and methods referencing globals
            not in the image can failed gracefully."
    (aString osiEvaluateIfError: [ false ]
        ) ~= false ifTrue: [ ^self osiMethods ].
    "Answer a string that will not evaluate."
    ^'a ', self! !

!String methods !  
osiEvaluateIfError: aBlock
        "Evaluate the receiver and answer the result.
            Answer aBlock evaluated if an error occurs."
    | compiler result answer |
    compiler := CompilerInterface
        forClass: UndefinedObject
        errorHandler: SilentErrorHandler new.
    [   answer := 
            (result := compiler evaluate: self) wasSuccessful
                ifTrue: [ result value ]
                ifFalse: [ aBlock value ].
    ]   on: Error
        do: [ answer := aBlock value ].
    ^answer! !

!String methods !  
osiRemoveSelector: aString
        "Remove the specified selector from the specified class.
            If the class or selector are not defined,
            then fail gracefully and report an error to the Transcript."
    | aClass aSelector |
    aClass := self osiEvaluateIfError: [ nil ].
    aSelector := aString asExistingSymbolOrNil.
    aClass notNil & aSelector notNil
        ifTrue: [ aClass removeSelector: aSelector ]
        ifFalse: [
            Transcript cr;
                nextPutAll: 'Ignored remove ', self, '>>', aString ].! !

!String methods !  
fileInFrom: aStream
        "File in the method definitions.
            If the class is missing or the method does not compile,
            then fail gracefully and report an error to the Transcript."
    | aClass chunk compiler result assoc mth |
    (aClass := self osiEvaluateIfError: [ nil ]
        ) notNil ifTrue: [
            compiler := CompilerInterface
                   forClass: aClass
                errorHandler: SilentErrorHandler new ].
    [(chunk := aStream nextChunk) isEmpty]
        whileFalse: [
            compiler notNil ifTrue: [
                 (result := compiler compile: chunk) wasSuccessful
                    ifTrue: [
                        assoc := result association.
                        ((mth := aClass compiledMethodAt: assoc key) isNil
                            or: [ mth sourceString ~= chunk ]
                        ) ifTrue: [
                            assoc value
      	                         classField: aClass;
                                selector: result selector;
                                sourceObject: nil;
                                sourceString: chunk.
                            aClass
                                addSelector: assoc key
                                withMethod: assoc value ] ]
                    ifFalse: [
                        result := nil ] ].
            result isNil ifTrue: [
                Transcript cr;
                    nextPutAll: 'Ignored ', self, ' method' ] ].! !

!String methods !  
osisubclass: className
    instanceVariableNames: instVarString
    classVariableNames: classVarString
    poolDictionaries: poolDictString
        "Create or modify the class named <className> to be a
        subclass of the receiver with the specifed instance variables,
        class variables, pool dictionaries."

    | aClass subClass aSelector instVarNames classVarNames poolDictNames |
    aClass := self osiEvaluateIfError: [ nil ].
    aClass isBehavior ifFalse: [ aClass := nil ].
    subClass := className osiEvaluateIfError: [ nil ].
    aClass isNil ifTrue: [
        Transcript cr;
            nextPutAll: 'Ignored ', self, ' subclass: #', className, '...'.
        ^nil ].
    subClass notNil ifTrue: [
        instVarNames := subClass instanceVariableString asArrayOfSubstrings.
        classVarNames := subClass classVariableString asArrayOfSubstrings asSortedCollection.
        poolDictNames := subClass sharedPools asSortedCollection collect: [ :each | each asString ].
        (instVarString asArrayOfSubstrings = instVarNames and: [
            classVarString asArrayOfSubstrings asSortedCollection = classVarNames and: [
                poolDictString asArrayOfSubstrings asSortedCollection = poolDictNames and: [
                    aClass == subClass superclass ] ] ]
        ) ifTrue: [ ^subClass ] ].
    ^[  aClass
            subclass: className asSymbol
            instanceVariableNames: instVarString
            classVariableNames: classVarString
            poolDictionaries: poolDictString
            ] on: Error do: [
                Transcript cr;
                    nextPutAll: 'Ignored ', self, ' subclass: #', className, '...'.
                nil ].
! !

!String methods !  
osisubclass: className
    instanceVariableNames: instVarString
    classVariableNames: classVarString
    poolDictionaries: poolDictString
    ifDefined: ifDefString
        "Create or modify the class named <className> to be a
        subclass of the receiver with the specifed instance variables,
        class variables, pool dictionaries.  If <ifDefString> evaluates
        false, then ignore the class definition."

    ^(ifDefString osiEvaluateIfError: [ false ]) ~= false
        ifTrue: [
            self
                osisubclass: className
                instanceVariableNames: instVarString
                classVariableNames: classVarString
                poolDictionaries: poolDictString ]
        ifFalse: [
            Transcript cr;
                nextPutAll: 'Ignored ', self, ' subclass: #', className, '...'.
            nil ].! !
  
"--------- end temporary methods"!

'WBMiniBrowserExample' osiRemoveSelector: 'close' !
'WBCompositePaneScratchWindow' osiRemoveSelector: 'addSubpanes' !
'WBRealLayoutPane class' osiRemoveSelector: 'initWinConstants' !
'WBScratchWindow class' osiRemoveSelector: 'wbBasicVersion' !

"WB Dev Base Common (WB2ADEVW.SLL)"!

'WBDevelopmentWindow' osisubclass: 'WindowBuilder'
  instanceVariableNames: 
    ' name toolPalette toolBar attributePalette editPalette groupPalette cleanedOutCode mainPane customSubMenu editedClass autoSave changed titleText styleText titleEditor when perform styleEditor thePane currentWhen sizePane positionPane statusPane '
  classVariableNames: 
    ' CustomPanes DevBitmapFileName Extras HelpDict Properties Scrapbook ToolbarTool UserBitmapFileName WBClasses WBIcon '
  poolDictionaries: 
    ' CharacterConstants ColorConstants CommonDialogConstants OperatingSystemConstants VirtualKeyConstants WBDevelopmentBitmaps '
  ifDefined: 'WindowBuilder' !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!

'PToggle' osisubclass: 'PRadioButton'
  instanceVariableNames: ''
  classVariableNames: 
    ' RadioBitmapCircle '
  poolDictionaries: 
    ' OperatingSystemConstants '
  ifDefined: 'WindowBuilder' !

"WB Dev Base Common (WB2ADEVW.SLL)"!

'ViewManager' osisubclass: 'WBCompositePaneTester'
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: 
    ' OperatingSystemConstants '
  ifDefined: 'WindowBuilder' !

"WB Dev Base Common (WB2ADEVW.SLL)"!

'WBDevelopmentWindow' osisubclass: 'WBBitmapManagerViewer'
  instanceVariableNames: 
    ' bitmapDictionary bitmapName myFile myEdit list references bitmapGraphPane updateKeys '
  classVariableNames: 
    ' BMIcon HelpDict ToolbarTool '
  poolDictionaries: 
    ' ColorConstants OperatingSystemConstants VirtualKeyConstants '
  ifDefined: 'WindowBuilder' !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!

'PGraphPane' osisubclass: 'PTextPane'
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: 
    ' OperatingSystemConstants '
  ifDefined: 'WindowBuilder' !

"WB Dev Base Common (WB2ADEVW.SLL)"!

'WBDevelopmentDialog' osisubclass: 'WBAboutDialog'
  instanceVariableNames: ''
  classVariableNames: 
    ' InitTranscript '
  poolDictionaries: 
    ' ColorConstants OperatingSystemConstants WBDevelopmentBitmaps '
  ifDefined: 'WindowBuilder' !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'BitEditor' osiMethods: 'WindowBuilder' !  
addAdjacentCells: cell to: queue with: cellMatrix
    "Add adjacent cells to queue and record filled cell to
     cellMatrix."
    | adjacent |
    (cellMatrix at: cell x + 1) at: (cell y + 1) put: cell.
    adjacent := cell + (0 @ 1).
    ((copy boundingBox containsPoint: adjacent) and: [
        ((cellMatrix at: adjacent x + 1) at: adjacent y + 1) isNil])
            ifTrue: [
                queue add: adjacent].
    adjacent := cell - (1 @ 0).
    ((copy boundingBox containsPoint: adjacent) and: [
        ((cellMatrix at: adjacent x + 1) at: adjacent y + 1) isNil])
            ifTrue: [
                queue add: adjacent].
    adjacent := cell - (0 @ 1).
    ((copy boundingBox containsPoint: adjacent) and: [
        ((cellMatrix at: adjacent x + 1) at: adjacent y + 1) isNil])
            ifTrue: [
                queue add: adjacent].
    adjacent := cell + (1 @ 0).
    ((copy boundingBox containsPoint: adjacent) and: [
        ((cellMatrix at: adjacent x + 1) at: adjacent y + 1) isNil])
            ifTrue: [
                queue add: adjacent]! !

"WB Dev Base Win32 (WB2ADEVW.SLL)"!
!'Bitmap' osiMethods: 'WindowBuilder' !  
fromSysID: id
        "Private - WBPro Development."
    ^self fromModule: nil id: id! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'Bitmap' osiMethods: 'WindowBuilder' !  
wbCopy4

    "Added by OSI"

    | newBitmap |

    #addedByOSI.
    newBitmap := Bitmap new
            screenWidth4: self width
            height: self height.
    self displayIn: newBitmap boundingBox with: newBitmap pen.

    ^newBitmap! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'Bitmap' osiMethods: 'WindowBuilder' !  
wbCopy8

    "Added by OSI"

    | newBitmap |

    #addedByOSI.
    newBitmap := Bitmap new
            screenWidth8: self width
            height: self height.
    self displayIn: newBitmap boundingBox with: newBitmap pen.

    ^newBitmap! !

"WB Dev Base Common"!
!'Bitmap class' osiMethods !  
buttonWidth: w height: h
         "Private - WBPro Development.
            Create a new tool bar button bitmap template"
    | button |
    #addedByOSI.
    button := self screenWidth: w * 2 height: h.
    button pen
        fill: (ColorConstants at: 'ClrPalegray');
        foreColor: (ColorConstants at: 'ClrBlack');
        lineFrom: 1@0 to: (w - 1)@0;
        lineFrom: (w + 1)@0 to: (2 * w - 1)@0;
        lineFrom: (2 * w - 1)@1 to: (2 * w - 1)@(h - 1);
        lineFrom: 1@(h - 1) to: (w - 1)@(h - 1);
        lineFrom: (w + 1)@(h - 1) to: (2 * w - 1)@(h - 1);
        lineFrom: 0@1 to: 0@(h - 1);
        lineFrom: (w - 1)@1 to: (w - 1)@(h - 1);
        lineFrom: w@1 to: w@(h - 1);
        foreColor: (ColorConstants at: 'ClrWhite');
        lineFrom: 1@1 to: 1@(h - 2);
        lineFrom: 2@1 to: (w - 2)@1;
        foreColor: (ColorConstants at: 'ClrDarkgray');
        lineFrom: 1@(h - 2) to: (w - 1)@(h - 2);
        lineFrom: 2@(h - 3) to: (w - 1)@(h - 3);
        lineFrom: (w - 2)@1 to: (w - 2)@(h - 2);
        lineFrom: (w - 3)@2 to: (w - 3)@(h - 2);
        lineFrom: (w + 1)@1 to: (w + 1)@(h - 1);
        lineFrom: (w + 2)@1 to: (2 * w - 1)@1;
        lineFrom: (w + 2)@2 to: (w + 2)@(h - 1);
        lineFrom: (w + 3)@2 to: (2 * w - 1)@2.
    ^button! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'Bitmap class' osiMethods: 'WindowBuilder' !  
fromWBSysModuleID: anInteger
        "Answer a new instance loaded from the wb system bitmap module."
    #addedByOSI.
    ^self fromModule: self wbSysModuleName id: anInteger! !

"WB Dev Base Win32 (WB2ADEVW.SLL)"!
!'Bitmap class' osiMethods: 'WindowBuilder' !  
wbSysModuleName
        "Answer the wb system bitmap module name."
    ^PWindowBuilder devBitmapFileName! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'ButtonEditor' osiMethods: 'WindowBuilder' !  
offset
    "OS/2 Version"
    ^(imageForm width // 2)+2
        @ (2 * Rectangle topBottomUnit)! !

"WB Dev Parts (WB2ADPW.SLL)"!
!'CompositePane' osiMethods: 'WBPARTSInterfaceEditor' !  
partEditDirect
        " Open an editor on the PARTS properties of the receiver. "
    ^super partEditProperties! !

"WB Dev Parts (WB2ADPW.SLL)"!
!'CompositePane' osiMethods: 'WBPARTSInterfaceEditor' !  
partEditProperties
        " Open WindowBuilder on the receiver's window definition. "
    WindowBuilder new openOn: self class.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'CompositePane class' osiMethods: 'WindowBuilder' !  
openWithParent: aViewManager

    WBCompositePaneTester new openOn: self parent: aViewManager! !

"WB Dev Base Win32 (WB2ADEVW.SLL)"!
!'CursorManager class' osiMethods: 'WindowBuilder' !  
initializeWBCursors
        "Private - WB Development."
! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'DrawnButton' osiMethods: 'WindowBuilder' !  
drawSelector
        "Private - WB Development"
    #addedByOSI.
    ^drawSelector! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'EnhancedEntryField class' osiMethods: 'WindowBuilder' !  
okCharacterMethods
        "Answer a collection of character validation selectors."
    ^((self methodDictionary keys select: [ :selector |
        (selector at: 1) = $o and: [
        (selector at: 2) = $k and: [
        (selector at: selector size) = $:]]])
            collect: [ :selector |
            selector asString copyFrom: 3 to: selector size - 1])  asSortedCollection! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'EnhancedEntryField class' osiMethods: 'WindowBuilder' !  
okFieldMethods
        "Answer a collection of field validation selectors."
    ^((self methodDictionary keys select: [ :selector |
        (selector at: 1) = $o and: [
        (selector at: 2) = $k and: [
        (selector at: selector size) ~= $:]]])
            collect: [ :selector |
            selector asString copyFrom: 3 to: selector size ]) asSortedCollection! !

"WB Dev Base Common"!
!'Font' osiMethods !  
nonPortableStoreOn: aStream indentString: indentString
        "Private - WBPro Development."
    #addedByOSI.
    aStream
        nextPutAll: indentString, 'Font new';
        cr; nextPutAll: indentString, 'fromByteArray: ', self logicalBytes.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'FramingParameters' osiMethods: 'WindowBuilder' !  
cacheDUDuring: aBlock
        "Make sure that new dialog units are used during evaluation of aBlock."
    | w h answer |
    w := duWidth.
    h := duHeight.
    [	duWidth := self	 class dialogUnitWidth.
        duHeight := self class dialogUnitHeight.
        answer := aBlock value.
    ] ensure: [
        duWidth := w.
        duHeight := h.
    ].
    ^answer! !

"WB Dev Base Common"!
!'FramingParameters' osiMethods !  
newFramerFromNewRect: newRect parentRect: containerRect

    "Create a new framing parameters for this pane, based on the
     values of self (i.e. update the relative values). "

    | newFramer |

    "Easy cases are left and bottom, vs. left and top for windows."

    newFramer := FramingParameters new.

    centerX ifTrue: [
        newFramer xCentered.
    ] ifFalse: [
        left notNil ifTrue: [
           left isInteger ifTrue: [
                (leftRel = #left) ifTrue: [
                    newFramer left: newRect left relativeTo: #left.
                ] ifFalse: [ (leftRel = #center) ifTrue: [
                    newFramer left: newRect left - (containerRect width // 2) relativeTo: #center.
                ] ifFalse: [
                    newFramer left: containerRect width - newRect left relativeTo: #right.
                ]].
            ] ifFalse: [
                newFramer leftProportional: (newRect left / containerRect width).
            ].
        ].

        right notNil ifTrue: [
           right isInteger ifTrue: [
                (rightRel = #left) ifTrue: [
                    newFramer right: newRect right relativeTo: #left.
                ] ifFalse: [ (rightRel = #center) ifTrue: [
                    newFramer right: newRect right - (containerRect width // 2) relativeTo: #center.
                ] ifFalse: [
                    newFramer right: containerRect width - newRect right relativeTo: #right.
                ]].
            ] ifFalse: [
                newFramer rightProportional: (newRect right / containerRect width).
            ].
        ].
    ].

    centerY ifTrue: [
        newFramer yCentered.
    ] ifFalse: [
        top notNil ifTrue: [
           top isInteger ifTrue: [
                (topRel = #top) ifTrue: [
                    newFramer top: newRect top relativeTo: #top.
                ] ifFalse: [ (topRel = #center) ifTrue: [
                    newFramer top: newRect top - (containerRect height // 2) relativeTo: #center.
                ] ifFalse: [
                    newFramer top: containerRect height - newRect top relativeTo: #bottom.
                ]].
            ] ifFalse: [
                newFramer topProportional: (newRect top / containerRect height).
            ].
        ].

        bottom notNil ifTrue: [
           bottom isInteger ifTrue: [
                (bottomRel = #top) ifTrue: [
                    newFramer bottom: newRect bottom relativeTo: #top.
                ] ifFalse: [ (bottomRel = #center) ifTrue: [
                    newFramer bottom: newRect bottom - (containerRect height // 2) relativeTo: #center.
                ] ifFalse: [
                    newFramer bottom: containerRect height - newRect bottom relativeTo: #bottom.
                ]].
            ] ifFalse: [
                newFramer bottomProportional: (newRect bottom / containerRect height).
            ].
        ].
    ].

    newFramer initialExtent: newRect extent.

    ^newFramer! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'FramingParameters' osiMethods: 'WindowBuilder' !  
storeOn: aStream indentString: indentString

    aStream
        nextPutAll: 'FramingParameters new';
        indentBy: 1;
        cr; nextPutAll: 'iDUE: ', (initialExtent / self class dialogUnit ) rounded asString;
        endMessage;
        cr.

    centerX
        ifTrue: [aStream nextPutAll: 'xC;'; space]
        ifFalse: [
            left notNil
                ifTrue: [
                    left isFraction
                        ifTrue: [aStream nextPutAll: 'lP: ', left asString]
                        ifFalse: [
                            aStream nextPutAll: 'lDU: ', self leftDialogUnits asString, ' '.
                            aStream nextPutAll: 'r: #',leftRel asString].
                    aStream nextPut: $;; space].
            right notNil
                ifTrue: [
                    right isFraction
                        ifTrue: [aStream nextPutAll: 'rP: ', right asString]
                        ifFalse: [
                            aStream nextPutAll: 'rDU: ', self rightDialogUnits asString, ' '.
                            aStream nextPutAll: 'r: #',rightRel asString].
                    aStream nextPut: $;; space]].

    centerY
        ifTrue: [aStream nextPutAll: 'yC;'; space]
        ifFalse: [
            aStream cr.
            top notNil
                ifTrue: [
                    top isFraction
                        ifTrue: [aStream nextPutAll: 'tP: ', top asString]
                        ifFalse: [
                            aStream nextPutAll: 'tDU: ', self topDialogUnits asString, ' '.
                            aStream nextPutAll: 'r: #',topRel asString].
                    aStream nextPut: $;; space].
            bottom notNil
                ifTrue: [
                    bottom isFraction
                        ifTrue: [aStream nextPutAll: 'bP: ', bottom asString]
                        ifFalse: [
                            aStream nextPutAll: 'bDU: ', self bottomDialogUnits asString, ' '.
                            aStream nextPutAll: 'r: #',bottomRel asString].
                    aStream nextPut: $;; space]].

    clientRect notNil
        ifTrue: [
            centerY ifFalse: [aStream cr].
            aStream nextPutAll: 'cRDU: (',  self cRDU asString, ')']
        ifFalse: [
            indent = (0@0)
                ifTrue: [aStream backup: 2]
                ifFalse: [
                    centerY ifFalse: [aStream cr].
                    aStream nextPutAll: 'indent: ', indent asString]].

    aStream indentBy: -1.! !

"WB Dev Code Gen (WB2ADEVW.SLL)"!
!'Integer' osiMethods: 'WindowBuilder' !  
storeColorOn: aStream
        "Store the color definition."
    #addedByOSI.
    self asColor storeColorOn: aStream! !

"WB Dev Base Win32 (WB2ADEVW.SLL)"!
!'Menu' osiMethods: 'WindowBuilder' !  
asPMenuItem
         "Private - WBPro Development."
    | item pMenu subMenu accelArray |
    #addedByOSI.
    pMenu := WBPMenuItem new.
    pMenu title: (title upTo: Tab).
    (selector isMessage and: [
        selector receiver isKindOf: WBAction]) ifTrue: [
        selector receiver receiver: nil
    ].
    pMenu selector: selector.

    1 to: self numberOfItems do: [ :i |
        item := items at: i.
        item isSubmenu ifTrue: [
            subMenu := item submenu asPMenuItem.
        ] ifFalse: [
            subMenu := WBPMenuItem new.
        ].
        subMenu isSeparator: (item style = MfSeparator).
        item label notNil ifTrue: [
            subMenu title: (item label upTo: Tab).
        ] ifFalse: [
            subMenu title: '--------'
        ].
        (item selector isMessage and: [
            item selector receiver isKindOf: WBAction]) ifTrue: [
            item selector receiver receiver: nil
        ].
        subMenu selector: item selector.

        accelArray := accel at: i.
        accelArray notNil ifTrue: [
            subMenu accelerator: (
                WBKeyAccel new
                    accelArray: accelArray;
                    yourself
            ).
        ].
        pMenu addChild: subMenu.
     ].

    ^pMenu! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'PButton' osiMethods: 'WindowBuilder' !  
usesColor

    ^Smalltalk platformIsOS2! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'PComboBox' osiMethods: 'WindowBuilder' !  
readSpecificsFrom: c

    super readSpecificsFrom: c.
    (c isKindOf: WBComboBox) ifTrue: [
        c hasDynamicListSizeStyle ifTrue: [
            style = #dropDown ifTrue: [
                style := #dynamicDropDown ].
            style = #dropDownList ifTrue: [
                style := #dynamicDropDownList ] ] ].! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'PComboBox' osiMethods: 'WindowBuilder' !  
styleMap

    ^super styleMap
        at: #dynamicDropDown put: #(dropDown addDynamicListSizeStyle);
        at: #dynamicDropDownList put: #(dropDownList addDynamicListSizeStyle);
        yourself.! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'PComboBox' osiMethods: 'WindowBuilder' !  
styles

    ^((self realClass ifNil: [ComboBox]) inheritsFrom: WBComboBox)
        ifTrue: [
            #( dropDown simpleList dropDownList dynamicDropDown dynamicDropDownList ) ]
        ifFalse: [
            #( dropDown simpleList dropDownList ) ]! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'PComboBox' osiMethods: 'WindowBuilder' !  
wbSuggestedTempName
        "Answer the suggested temporary variable name used in code generation."
    ^'ComboBox'! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'PCompositePane' osiMethods: 'WindowBuilder' !  
backColor

    self parent isCompositePane ifTrue: [
        ^super backColor
    ] ifFalse: [
        backColor = super defaultBackColor ifTrue: [
            ^super backColor
        ] ifFalse: [
            ^backColor
        ].
    ].! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'PCompositePane' osiMethods: 'WindowBuilder' !  
readSpecificsFrom: aPane

    self style: (aPane hasBorderStyle 
        ifFalse: [#defaultStyle]
        ifTrue: [
            aPane hasVerticalScrollBarStyle
                ifFalse: [#borders]
                ifTrue: [
                    aPane hasHorizontalScrollBarStyle
                        ifFalse: [#verticalScrollBar]
                        ifTrue: [#scrollbars]]])! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'PCompositePane' osiMethods: 'WindowBuilder' !  
styles

    ^Smalltalk platformIsWin32
        ifTrue: [
            #(defaultStyle borders scrollbars verticalScrollBar mdiToolBar mdiToolBarBordered) ]
        ifFalse: [
            #(defaultStyle borders scrollbars verticalScrollBar) ]
! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'PDrawnButton' osiMethods: 'WindowBuilder' !  
backColor

    ^(self parent notNil and: [
        self parent isNonWindowParent | 
        (self parent backColor = self parent defaultBackColor)])
        ifTrue: [self realBackColor]
        ifFalse: [super backColor].! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'PDrawnButton' osiMethods: 'WindowBuilder' !  
readSpecificsFrom: c
    "OSI 12/31/92"
    contents := c cpContents.
    contents isString ifFalse: [ contents := '' ].
    c drawSelector = #isotropic: ifTrue: [ style := #fixedSize ].
    c drawSelector = #anisotropic: ifTrue: [ style := #stretchToFit ].
    c drawSelector = #invisible: ifTrue: [ style := #invisible ].
    style isNil ifTrue: [
        style := self styles first.
    ].! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'PDrawnButton' osiMethods: 'WindowBuilder' !  
usesColor

    ^Smalltalk platformIsOS2! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'PEnhancedEntryField' osiMethods: 'WindowBuilder' !  
readSpecificsFrom: c

    super readSpecificsFrom: c.
    self
        autoTab: c isAutoTab;
        maximumSize: c textLimit;
        getFocus: c getFocus;
        case: c case;
        justification: c justification;
        character: c character;
        field: c field.! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'PEntryFieldGroup' osiMethods: 'WindowBuilder' !  
backColor: aColor

    super backColor: aColor.
    aColor = self defaultForeColor ifTrue: [
        self children do: [ :child | child foreColor: child defaultForeColor ]
    ] ifFalse: [
        self children do: [ :child | child backColor: aColor ]
    ].! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'PEntryFieldGroup' osiMethods: 'WindowBuilder' !  
foreColor: aColor

    super foreColor: aColor.
    aColor = self defaultForeColor ifTrue: [
        self children do: [ :child | child foreColor: child defaultForeColor ]
    ] ifFalse: [
        self children do: [ :child | child foreColor: aColor ]
    ].! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'PGraphPane' osiMethods: 'WindowBuilder' !  
genReceiveWindowMessagesOn: aStream indentString: spaceString
    "Don't generate method for GraphPanes"! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'PGraphPane' osiMethods: 'WindowBuilder' !  
readSpecificsFrom: aPane

    self style: (aPane hasBorderStyle 
        ifFalse: [#noBorders]
        ifTrue: [
            aPane hasHorizontalScrollBarStyle
                ifFalse: [#noScrollBars]
                ifTrue: [#defaultStyle]])! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'PMultipleSelectListBox' osiMethods: 'WindowBuilder' !  
importantEvents

    ^super importantEvents
        remove: #clicked:;
        addFirst: #changed:;
        yourself! !

"WB Dev P Widgets Common"!
!'PMultipleSelectListBox class' osiMethods !  
styleFrom: s

    (s bitIsOn: LbsExtendedsel) ifTrue: [
        ^#extendedSelect
    ].
    (s bitIsOn: LbsOwnerdrawfixed) ifTrue: [
        ^#ownerDrawFixed
    ].
    (s bitIsOn: LbsOwnerdrawvariable) ifTrue: [
        ^#ownerDrawVariable
    ].

    ^#defaultStyle! !

"WB Dev P Widgets Common"!
!'PRadioButton class' osiMethods !  
purgeCache

    RadioBitmap notNil ifTrue: [
        RadioBitmap release.
    ].
    RadioBitmap := nil.! !

"WB Dev P Widgets Common"!
!'PStaticBox' osiMethods !  
defaultForeColor

    ^nil! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'PStaticText' osiMethods: 'WindowBuilder' !  
defaultForeColor

    ^Color staticText! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'PStatusPane' osiMethods: 'WindowBuilder' !  
defaultFont

    "^Font face:'Helv' size:(0 @ (self height - (2 * self inset))) fixedWidth:false"
    ^PWindowBuilder wbDefaultFont! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'PStatusPane' osiMethods: 'WindowBuilder' !  
updateBoxesLeftJustified

    | xPos aRect box |
    xPos := self updateBoxesLeftJustifiedFixed.
    self statusBoxes isEmpty ifTrue: [^self].

    box := self statusBoxes last.
    xPos := xPos left: box width + 6.
    aRect := Rectangle leftTop: xPos @ rect top bottomRight: (rect width left: self height - 12) @ (rect bottom down: 2).
    aRect := aRect insetBy: (0 @ self inset).
    box rectangle: aRect.! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'PStatusPane' osiMethods: 'WindowBuilder' !  
updateBoxesLeftJustifiedFixed

    |xPos aRect|

    xPos := rect left.
    self statusBoxes do: [ :box |
        xPos := xPos right: box space.
        aRect := Rectangle leftTop: xPos @ rect top rightBottom: (xPos + box width + 6) @ (rect bottom down: 2).
        aRect := aRect insetBy: (0 @ self inset).
        box rectangle: aRect.
        xPos := xPos right: box width + 6].
    ^xPos! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'PStatusPane' osiMethods: 'WindowBuilder' !  
updateBoxesRightJustified

    | xPos aRect box |
    xPos := self updateBoxesRightJustifiedFixed.
    self statusBoxes isEmpty ifTrue:[^self].

    box := self statusBoxes first.
    xPos := xPos right: box space.
    xPos := xPos right: box width + 6.
    aRect := Rectangle leftTop: (12 + box space @ rect top) rightBottom: xPos @ (rect bottom down: 2).
    aRect := aRect insetBy: (0 @ self inset).
    box rectangle: aRect.! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'PStatusPane' osiMethods: 'WindowBuilder' !  
updateBoxesRightJustifiedFixed

    |xPos aRect|

    xPos := rect right - self height.
    self statusBoxes reverseDo: [ :box |
        xPos := xPos left: box width + 6.
        aRect := Rectangle leftTop: xPos @ rect top rightBottom: (xPos + box width + 6) @ (rect bottom down: 2).
        aRect := aRect insetBy: (0 @ self inset).
        box rectangle: aRect.
        xPos := xPos left: box space].
    ^xPos! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'PWBToolBar' osiMethods: 'WindowBuilder' !  
suggestedSize

    self elements isEmpty ifTrue: [
        ^self cellSize
    ] ifFalse: [ self vertical ifTrue: [
        ^(self cellSize x + 1) @ (elements first rectangle top + 2)
    ] ifFalse: [
        ^((elements at: elements size) rectangle right + 2) @ (self cellSize y + 1)
    ]]
! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'Rectangle' osiMethods: 'WindowBuilder' !  
offsetFromLeftTop: aRect
        "Private - WBPro Development.
     Answer a Point that is the offset difference between self's leftTop
     and aRect's leftTop, where positive values indicate aRect is below and
     to the right of self."
    #addedByOSI.
    ^self leftTop distanceRightAndDown: aRect leftTop! !

"WB Dev Code Gen (WB2ADEVW.SLL)"!
!'String' osiMethods: 'WindowBuilder' !  
asColor
        "Answer the color definition."
        
    #addedByOSI.
    ^Color
        red:    (self at: 1) asciiValue
        green:  (self at: 2) asciiValue
        blue:   (self at: 3) asciiValue! !

"WB Dev Code Gen (WB2ADEVW.SLL)"!
!'String' osiMethods: 'WindowBuilder' !  
storeColorOn: aStream
        "Store the color definition."
    #addedByOSI.
    self asColor storeColorOn: aStream! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'SystemDictionary' osiMethods: 'WindowBuilder' !  
allNLSDictionaries
    "Added by OSI to answer all NLS dictionaries"
    #addedByOSI.
    ^self select: [:val |
        val isDictionary and: [
        val isEmpty not and: [
        val isValidNLSDictionary]]].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBAboutDialog' osiMethods: 'WindowBuilder' !  
createViews

        "WARNING!! This method was automatically generated by 
        WindowBuilder. Code you add here which does not conform to 
        the WindowBuilder API will probably be lost the next time 
        you save your layout definition."

    | address copyright mainView ok osilogo registeredTo user 
    version wbpro window |
    
    mainView := self topPaneClass new.
    
        "Temporary Variables"
    address := WBDrawnButton new.
    copyright := StaticText new.
    ok := Button new.
    osilogo := WBDrawnButton new.
    registeredTo := StaticText new.
    user := StaticText new.
    version := StaticText new.
    wbpro := WBStaticGraphic new.
    window := WBStaticGraphic new.
    
    mainView
        owner: self;
        paneName: 'mainView';
        labelWithoutPrefix: 'New Window';
        noSmalltalkMenuBar;
        backColor: Color paleGray;
        pStyle: #();
        framingBlock:
            (FramingParameters new
                iDUE: 992 @ 512;
                xC; yC; cRDU: (0 @ 512 rightBottom: 992 @ 0)).
    self addView: mainView.
    
    copyright "StaticText"
        owner: self;
        paneName: 'copyright';
        framingBlock:
            (FramingParameters new
                iDUE: 978 @ 64;
                lDU: 7 r: #left; rDU: 985 r: #left; 
                tDU: 296 r: #top; bDU: 360 r: #top);
        centered;
        contents: '(c) Copyright Objectshare Systems, Inc. 1993, 1994, 1995\n(c) Copyright Cooper & Peters, Inc. 1991, 1992' replaceEscapeCharacters;
        foreColor: Color black;
        backColor: Color paleGray;
        startGroup.
    mainView addSubpane: copyright.
    
    version "StaticText"
        owner: self;
        paneName: 'version';
        when: #needsContents send: #getVersion: to: self withArgument: version;
        framingBlock:
            (FramingParameters new
                iDUE: 265 @ 64;
                lDU: 366 r: #left; rDU: 631 r: #left; 
                tDU: 232 r: #top; bDU: 296 r: #top);
        centered;
        contents: '';
        foreColor: Color black;
        backColor: Color paleGray;
        startGroup.
    mainView addSubpane: version.
    
    user "StaticText"
        owner: self;
        paneName: 'user';
        when: #needsContents send: #getUser: to: self withArgument: user;
        framingBlock:
            (FramingParameters new
                iDUE: 487 @ 68;
                lDU: 281 r: #left; rDU: 768 r: #left; 
                tDU: 440 r: #top; bDU: 508 r: #top);
        contents: '';
        foreColor: Color black;
        backColor: Color paleGray;
        startGroup.
    mainView addSubpane: user.
    
    registeredTo "StaticText"
        owner: self;
        paneName: 'registeredTo';
        when: #needsContents send: #getSerialNumber: to: self withArgument: registeredTo;
        framingBlock:
            (FramingParameters new
                iDUE: 251 @ 68;
                lDU: 9 r: #left; rDU: 261 r: #left; 
                tDU: 440 r: #top; bDU: 508 r: #top);
        rightJustified;
        foreColor: Color black;
        backColor: Color paleGray;
        startGroup.
    mainView addSubpane: registeredTo.
    
    ok "Button"
        owner: self;
        paneName: 'ok';
        when: #clicked send: #ok to: self;
        framingBlock:
            (FramingParameters new
                iDUE: 197 @ 56;
                lDU: 777 r: #left; rDU: 974 r: #left; 
                tDU: 440 r: #top; bDU: 496 r: #top);
        defaultPushButton;
        contents: 'OK';
        startGroup;
        tabStop.
    mainView addSubpane: ok.
    
    address "WBDrawnButton"
        owner: self;
        paneName: 'address';
        when: #clicked send: #showAddress to: self;
        framingBlock:
            (FramingParameters new
                iDUE: 745 @ 44;
                lDU: 137 r: #left; rDU: 882 r: #left; 
                tDU: 376 r: #top; bDU: 420 r: #top);
        stretchToFit;
        startGroup;
        tabStop.
    mainView addSubpane: address.
    
    wbpro "WBStaticGraphic"
        owner: self;
        paneName: 'wbpro';
        framingBlock:
            (FramingParameters new
                iDUE: 329 @ 192;
                lDU: 329 r: #left; rDU: 658 r: #left; 
                tDU: 24 r: #top; bDU: 216 r: #top);
        stretchToFit;
        startGroup.
    mainView addSubpane: wbpro.
    
    osilogo "WBDrawnButton"
        owner: self;
        paneName: 'osilogo';
        when: #clicked send: #thanks to: self;
        framingBlock:
            (FramingParameters new
                iDUE: 329 @ 288;
                lDU: 663 r: #left; rDU: 992 r: #left; 
                tDU: 0 r: #top; bDU: 288 r: #top);
        stretchToFit;
        startGroup;
        tabStop.
    mainView addSubpane: osilogo.
    
    window "WBStaticGraphic"
        owner: self;
        paneName: 'window';
        framingBlock:
            (FramingParameters new
                iDUE: 329 @ 288;
                lDU: 0 r: #left; rDU: 329 r: #left; 
                tDU: 0 r: #top; bDU: 288 r: #top);
        stretchToFit;
        startGroup.
    mainView addSubpane: window! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBAboutDialog' osiMethods: 'WindowBuilder' !  
getVersion: aPane
        "Display the version number."
    aPane contents: PWindowBuilder versionNumberString.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBAboutDialog' osiMethods: 'WindowBuilder' !  
initWindow
    | font |
    font := SysFont.
    (self paneNamed: 'version') font: font.
    (self paneNamed: 'registeredTo') font: font.
    (self paneNamed: 'user') font: font.
    (self paneNamed: 'copyright') font: font.
    (self paneNamed: 'window') contents: WBWindowSysBitmap.
    (self paneNamed: 'osilogo') contents: WBOsilogoSysBitmap.
    (self paneNamed: 'wbpro') contents: WBWbproSysBitmap.
    (self paneNamed: 'address') contents: WBAddressSysBitmap.
    (Message
        receiver: self mainView 
        selector: #bringToTop
            ) performDeferred.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBAboutDialog' osiMethods: 'WindowBuilder' !  
ok
    "If the property is set, then reinitalize the Notifier."
  self shouldInitTranscript ifTrue: [
    ( Message
      receiver: PWindowBuilder
      selector: #initTranscriptMenuDelayed
    ) performDeferred ].
  self close.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBAboutDialog' osiMethods: 'WindowBuilder' !  
shouldInitTranscript
        "Answer true if the transcript should be initialized."
    ^InitTranscript = true! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBAboutDialog' osiMethods: 'WindowBuilder' !  
thanks
    | user |
    user := PWindowBuilder userName.
    user = '???' ifTrue: [ user := '' ] ifFalse: [ user := user, ',' ].
    MessageBox message: 'Special Thanks to:

Ken Cooper, Ted Peters, Dan Shafer,
Scott Herndon, Tom Murphy, 
James Chan, Eric Clayberg, 
Bob Yerex, Dina Fischer, Jim Howe,
Ron Jeffries, Darrow Kirkpatrick, 
Ed Shirk, S. Sridhar, Dan Rubel,
Roxie Rochat, David Zeleznik, 
',user,'
American Management Systems, Inc.
Knowledge Systems Corporation, Inc.
Object Technology International, Inc.'! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBAboutDialog class' osiMethods: 'WindowBuilder' !  
initTranscriptAfterClose
        "Initialize the Transcript after an instance of the receiver
            has been opened and closed."
    InitTranscript := true.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBAboutDialog class' osiMethods: 'WindowBuilder' !  
initTranscriptAfterClose: aBoolean
    "Initialize the Transcript after an instance of the receiver
      has been opened and closed."
  InitTranscript := aBoolean.! !

"WB Dev Code Gen (WB2ADEVW.SLL)"!
!'WBAbstractCodeModule' osiMethods: 'WindowBuilder' !  
constructMessageSelector: aSymbol index: anInteger
        "Answer the view message selector."
    | answer index |
    answer := aSymbol.
    index := answer indexOf: $: ifAbsent: [ answer size + 1 ].
    ^(    (answer copyFrom: 1 to: index - 1),
            anInteger printString,
            (answer copyFrom: index to: answer size)
        ) asSymbol! !

"WB Dev Code Gen (WB2ADEVW.SLL)"!
!'WBAbstractCodeModule' osiMethods: 'WindowBuilder' !  
defaultShouldLogMethodSource
        "Answer true if the receiver's source should be logged."
    ^self targetClass isScratchWindow not! !

"WB Dev Code Gen (WB2ADEVW.SLL)"!
!'WBAbstractCodeModule' osiMethods: 'WindowBuilder' !  
messageSelector
    "Private - Answer the message selector."
  ^selector ifNil: [
        (self defaultMessageSelector
            ifNil: [ ^nil ]
         ) asSymbol ]! !

"WB Dev Code Gen (WB2ADEVW.SLL)"!
!'WBAbstractCodeModule' osiMethods: 'WindowBuilder' !  
messageSelector: aSymbol
    "Private - Set the message selector."
  selector := aSymbol notNil
        ifTrue: [ aSymbol asSymbol ]
        ifFalse: [ nil ].! !

"WB Dev Code Gen (WB2ADEVW.SLL)"!
!'WBAbstractCodeModule' osiMethods: 'WindowBuilder' !  
shouldLogMethodSource
        "Answer true if the receiver's source should be logged."
    ^self defaultShouldLogMethodSource! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBAttributeEditor' osiMethods: 'WindowBuilder' !  
bitmapFromString: aStringOrBitmap

    ^WBBitmaps 
        at: aStringOrBitmap 
        ifAbsent: [aStringOrBitmap]! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBAttributeEditor' osiMethods: 'WindowBuilder' !  
nlsKeyFor: aString

    | nlsKey nlsText |
    nlsText := aString.
    thePane parent nlsPools notEmpty
        ifTrue: [
            thePane parent nlsPools detect: [:sym |
               (nlsKey := (Smalltalk at: sym)
                    keyAtValue: aString
                    ifAbsent: [nil]) ~~ nil] ifNone: [].
            nlsKey notNil
                ifTrue: [nlsText := '#', nlsKey]].
    ^nlsText! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBAttributeEditor' osiMethods: 'WindowBuilder' !  
nlsStringFor: aString
    | nlsString nlsKey nlsPool |
    nlsString := aString.
    (aString notEmpty and: [aString first == $#])
        ifTrue: [
            nlsKey := aString copyFrom: 2 to: aString size.
            thePane parent nlsPools detect: [:sym |
                (nlsString := (nlsPool := Smalltalk at: sym) at: nlsKey
                    ifAbsent: [nlsString := nlsPool at: nlsKey asSymbol
                    ifAbsent: [aString]]) ~= aString]
                    ifNone: []].
    ^nlsString! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBAttributeEditor' osiMethods: 'WindowBuilder' !  
popupBitmapMenu: aPane
    | menu array answer |
    menu := Menu new
        owner: aPane;
        selector: #contents:;
        yourself.
    ((array := WBBitmaps keys asSortedCollection asArray) 
        copyFrom: 1 to: (array size min: 24)) do: [:key |
            menu appendItem: key selector: key].
    array size > 24
        ifTrue: [
            menu appendSeparator;
                appendItem: 'Other...' action:
                    (Message receiver: [
                        (answer := WBListChooser fromList: array prompt: 'Select Bitmap') isNil
                            ifFalse: [aPane contents: answer]] selector: #value)].
    menu checkItem: aPane contents.
    aPane setPopupMenu: menu.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBAttributeEditor' osiMethods: 'WindowBuilder' !  
popupNlsMenu: aPane

    | menu subMenu subMenus nlsPool nlsPools checkItem assoc array answer |

    (nlsPools := thePane parent nlsPools asArray) isEmpty
        ifTrue: [^aPane setPopupMenu: nil].

    menu := Menu new
        owner: aPane;
        selector: #contents:;
        yourself.

    nlsPools size == 1
        ifTrue: [
            ((array := (nlsPool := Smalltalk at: nlsPools first) keys asSortedCollection asArray) 
                copyFrom: 1 to: (array size min: 24)) do: [:key |
                assoc := nlsPool associationAt: key.
                menu appendItem: ('#',assoc key, ' - ', assoc value printString) selector: ('#', assoc key) asSymbol].
            array size > 24
                ifTrue: [
                    menu appendSeparator;
                        appendItem: 'Other...' action:
                            (Message receiver: [
                                (answer := WBListChooser 
                                    fromList: (array collect: [:key |
                                        assoc := nlsPool associationAt: key.
                                        ('#',assoc key, ' - ', assoc value printString)])
                                    prompt: 'Select NLS Key') isNil
                                    ifFalse: [aPane contents: (answer upTo: $ )]] selector: #value)]]
        ifFalse: [
            subMenus := OrderedCollection new: nlsPools size.
            nlsPools do: [:sym |
                menu appendSubMenu:
                    (subMenu := Menu new
                        title: sym;
                        owner: aPane;
                        selector: #contents:;
                        yourself).
                subMenus add: subMenu.
                ((array := (nlsPool := Smalltalk at: sym) keys asSortedCollection asArray) 
                    copyFrom: 1 to: (array size min: 24)) do: [:key |
                    assoc := nlsPool associationAt: key.
                    subMenu appendItem: ('#',assoc key, ' - ', assoc value printString) selector: ('#', assoc key) asSymbol].
                array size > 24
                    ifTrue: [
                        subMenu appendSeparator;
                            appendItem: 'Other...' action:
                                (Message receiver: [
                                    (answer := WBListChooser 
                                        fromList: (array collect: [:key |
                                            assoc := nlsPool associationAt: key.
                                            ('#',assoc key, ' - ', assoc value printString)])
                                        prompt: 'Select NLS Key') isNil
                                        ifFalse: [aPane contents: (answer upTo: $ )]] selector: #value)]]].
    checkItem := ((self nlsKeyFor: aPane contents) ifNil: ['']) asSymbol.
    subMenus isNil
        ifTrue: [menu checkItem: checkItem]
        ifFalse: [
            subMenus do: [:sub |
                sub checkItem: checkItem]].

    aPane setPopupMenu: menu.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBAttributeEditor' osiMethods: 'WindowBuilder' !  
stringFromBitmap: aStringOrBitmap

    ^WBBitmaps 
        keyAtValue: aStringOrBitmap 
        ifAbsent: [aStringOrBitmap].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBBitmapManager' osiMethods: 'WindowBuilder' !  
convertBitmapsFromModuleToImage
        "Convert all bitmaps that are loaded from a module (resource DLL)
            to bitmaps that are stored in the image."
        "
        To convert the window builder SYSTEM bitmaps, evaluate
            WBBitmapManager system convertBitmapsFromModuleToImage.

        To convert the window builder USER bitmaps, evaluate
            WBBitmapManager current convertBitmapsFromModuleToImage.
        "
    | newBitmap |
    self flat do: [ :eachBitmap |
        eachBitmap archive isArray ifTrue: [
            newBitmap := eachBitmap cpCopy.
            eachBitmap release.
            eachBitmap become: newBitmap ] ].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBBitmapManager class' osiMethods: 'WindowBuilder' !  
loadStandardWBBitmaps
        "Load the standard window builder user bitmaps."
    self current
        addBitmapsFromModule: 	PWindowBuilder userBitmapFileName
        idMap: self standardWBBitmapIDMap.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBBitmapManagerViewer' osiMethods: 'WindowBuilder' !  
bitmapSelected: aString

    bitmapName := aString.
    bitmapGraphPane update.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBBitmapManagerViewer' osiMethods: 'WindowBuilder' !  
createMenus: aPane

        "WARNING!! This method was automatically generated by 
        WindowBuilder. Code you add here which does not conform to 
        the WindowBuilder API will probably be lost the next time 
        you save your layout definition."

    aPane menuWindow
        yourself;
        addMenu: (
            Menu new
                title: '~File';
                owner: self;
                appendItem: '~New...	Ctrl+N' selector: #create acceleratorString: 'Ctrl+n';
                appendItem: 'New Button...' selector: #createNewButton acceleratorString: '';
                appendItem: 'From ~Screen...' selector: #fromScreen acceleratorString: '';
                appendItem: 'From ~File...' selector: #fromFile acceleratorString: '';
                appendItem: 'Save ~To File...' selector: #saveToFile acceleratorString: '';
                appendSeparator;
                appendItem: '~Open Bitmap File...	Ctrl+O' selector: #load acceleratorString: 'Ctrl+o';
                appendItem: 'Save Bitmaps ~As...	Ctrl+S' selector: #save acceleratorString: 'Ctrl+s';
                appendSeparator;
                appendItem: 'E~xit' selector: #exit acceleratorString: ''
        );
        addMenu: (
            Menu new
                title: '~Edit';
                owner: self;
                appendItem: '~Copy To Clipboard	Ctrl+C' selector: #copyToClipboard acceleratorString: 'Ctrl+c';
                appendItem: '~Paste From Clipboard...	Ctrl+V' selector: #fromClipboard acceleratorString: 'Ctrl+v';
                appendItem: 'De~lete' selector: #delete acceleratorString: '';
                appendItem: '~Duplicate' selector: #duplicate acceleratorString: '';
                appendItem: '~Rename...' selector: #rename acceleratorString: '';
                appendSeparator;
                appendItem: '~Bit Edit...	Ctrl+E' selector: #edit acceleratorString: 'Ctrl+e';
                appendItem: '~Button Edit...	Ctrl+B' selector: #editButton acceleratorString: 'Ctrl+b';
                appendItem: '~Resize Button...	Ctrl+R' selector: #resizeButton acceleratorString: 'Ctrl+r'
        )! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBBitmapManagerViewer' osiMethods: 'WindowBuilder' !  
createViews

        "WARNING!! This method was automatically generated by 
        WindowBuilder. Code you add here which does not conform to 
        the WindowBuilder API will probably be lost the next time 
        you save your layout definition."

    | wbbitmapManagerViewer1 |
    
    wbbitmapManagerViewer1 := self topPaneClass new.
    
        "Instance Variables"
    list := ListBox new.
    
        "Temporary Variables"
    bitmapGraphPane := GraphPane new.
    
    wbbitmapManagerViewer1
        owner: self;
        when: #activated send: #updateKeys to: self;
        labelWithoutPrefix: 'Bitmap Manager';
        noSmalltalkMenuBar;
        pStyle: #(sysmenu maximize titlebar minimize sizable);
        framingBlock:
            (FramingParameters new
                iDUE: 878 @ 576;
                xC; yC; cRDU: (9 @ 496 rightBottom: 869 @ 8)).
    self addView: wbbitmapManagerViewer1.
    
    bitmapGraphPane "GraphPane"
        owner: self;
        paneName: 'bitmapGraphPane';
        when: #needsContents send: #graphContents: to: self withArgument: bitmapGraphPane;
        when: #doubleClicked send: #edit to: self;
        framingBlock:
            (FramingParameters new
                iDUE: 574 @ 488;
                lDU: 286 r: #left; rDU: 859 r: #left;
                tDU: 0 r: #top; bDU: 488 r: #top).
    wbbitmapManagerViewer1 addSubpane: bitmapGraphPane.
    
    list "ListBox"
        owner: self;
        paneName: 'list';
        when: #changed: send: #bitmapSelected: to: self;
        when: #needsContents send: #listContents: to: self withArgument: list;
        when: #doubleClicked: send: #edit: to: self;
        framingBlock:
            (FramingParameters new
                iDUE: 286 @ 488;
                lDU: 0 r: #left; rDU: 286 r: #left;
                tDU: 0 r: #top; bDU: 488 r: #top).
    wbbitmapManagerViewer1 addSubpane: list.
    
    self createMenus: wbbitmapManagerViewer1! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBBitmapManagerViewer' osiMethods: 'WindowBuilder' !  
preInitWindow
        "Initialize the receiver."
    | system |
    updateKeys := 1.
    system := Notifier isControlKeyDown.
    bitmapDictionary isNil
        ifTrue: [
            self bitmapDictionary: (system
                ifTrue: [WBBitmapManager system]
                ifFalse: [WBBitmapManager current])].
    system
        ifTrue: [
            (self menuWindow wbMenuTitled: 'Edit')
                appendSeparator;
                appendItem: 'Copy to Current (User) Bitmap Manager' selector: #copyToDefault].
    self icon: self class screenIcon.
    bitmapName notNil
        ifTrue: [list selection: bitmapName].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBBitmapManagerViewer' osiMethods: 'WindowBuilder' !  
saveToFile

    | file s bm release |

    bitmapName isNil ifTrue: [ ^nil ].

    release := false.
    bm := self bitmap.
    Notifier isControlKeyDown & Notifier isShiftKeyDown ifTrue: [
        Notifier isAltKeyDown
            ifTrue: [
                (MessageBox confirm: 'Save as 8 bit bitmap?')
                    ifTrue: [
                        bm := bm wbCopy8.
                        release := true ] ]
            ifFalse: [
                (MessageBox confirm: 'Save as 4 bit bitmap?')
                    ifTrue: [
                        bm := bm wbCopy4.
                        release := true ] ] ].

    file := self getFile: 'Save Bitmap To:'
        fileSpec: '*.bmp'
        type: #file.

    file notNil ifTrue: [
        CursorManager execute change.
        bm wbOutputToFile: file.
        CursorManager normal change.
    ].

    release ifTrue: [ bm release ].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBBitmapManagerViewer' osiMethods: 'WindowBuilder' !  
updateKeys

    "On Window Activation."

    | keys |

    updateKeys > 0 ifTrue: [
        updateKeys := updateKeys - 1.
        bitmapGraphPane doGraphics: [
            bitmapGraphPane update ].
        ^self ].

    references := nil.

    Clipboard getBitmap isNil ifTrue: [
        (self menuWindow menuTitled: 'Edit')
            disableItem: #fromClipboard.
    ] ifFalse: [
        (self menuWindow menuTitled: 'Edit')
            enableItem: #fromClipboard.
    ].

    list contents = (keys := bitmapDictionary keys asSortedCollection) ifFalse: [
        bitmapDictionary isEmpty ifTrue: [
            bitmapName := nil.
        ] ifFalse: [
            (keys includes: bitmapName) ifFalse: [
                bitmapName := keys first.
            ].
        ].
        self updateMenus.
            list update.
    ].
    bitmapGraphPane doGraphics: [
        bitmapGraphPane update ].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBBitmapManagerViewer class' osiMethods: 'WindowBuilder' !  
wbBasicVersion
        "Private - Answer the window builder version."
    ^2.0! !

"WB Dev Code Gen (WB2ADEVW.SLL)"!
!'WBCallOutModule' osiMethods: 'WindowBuilder' !  
defaultOwnerName
        "Answer the default owner name."
    ^'aModel'! !

"WB Dev Code Gen (WB2ADEVW.SLL)"!
!'WBCodePolicy' osiMethods: 'WindowBuilder' !  
createClassFor: aWBClassDefinition
        "Define and answer a new class.
        Answer nil if one could not be created."
    | transcript |
    self removeScratchSelectorsFor: aWBClassDefinition.
    transcript := Transcript.
    Transcript := WriteStream on: String new.
    ^[self basicCreateClassFor: aWBClassDefinition]
        ensure: [Transcript := transcript]! !

"WB Dev Code Gen (WB2ADEVW.SLL)"!
!'WBCodePolicy' osiMethods: 'WindowBuilder' !  
logMethodFor: aCodeModule
        "Private - Log the specified method source."
    | hook |
    aCodeModule shouldLogMethodSource ifFalse: [ ^self ].
    ( hook := PWindowBuilder codeGenerationHook ) notNil ifTrue: [
        ( self respondsTo: hook ) ifTrue: [
            ^self
                perform: hook asSymbol
                with: aCodeModule sourceString
                with: aCodeModule messageSelector
                with: aCodeModule targetClass ].
        ( PWindowBuilder respondsTo: hook ) ifTrue: [
            ^PWindowBuilder
                perform: hook asSymbol
                with: aCodeModule sourceString
                with: aCodeModule messageSelector
                with: aCodeModule targetClass ] ].
    self basicLogMethodFor: aCodeModule.! !

"WB Dev Code Gen (WB2ADEVW.SLL)"!
!'WBCodeStream' osiMethods: 'WindowBuilder' !  
backup: numberOfCharacters
        "Backup the specified numer of characters"
    stream position: (stream position - numberOfCharacters max: 0)! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBColorDialog' osiMethods: 'WindowBuilder' !  
highlightItem: index pane: aPane

    aPane pen 
        reverse: 
            (Rectangle 
                leftTop: (aPane drawBox leftTop + ((self colorBarWidth + 2) @ 0))
                rightBottom: aPane drawBox rightBottom)! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBCompositePaneTester' osiMethods: 'WindowBuilder' !  
isWBWindow

    ^true! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBCompositePaneTester' osiMethods: 'WindowBuilder' !  
openOn: aCompositePaneClass

    self openOn: aCompositePaneClass parent: nil! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBCompositePaneTester' osiMethods: 'WindowBuilder' !  
openOn: aCompositePaneClass parent: aViewManager
    | composite iDUE |
    composite := (aCompositePaneClass new)
        addSubpanes;
        yourself.
    iDUE := composite framingBlock iDUE.
    composite
        framingBlock: nil;
        children: nil;
        propertyAt: #subpaneOrder put: nil.
    self addView: (
        self topPaneClass new
            owner: self;
            labelWithoutPrefix: aCompositePaneClass name,' Tester';
            noSmalltalkMenuBar;
            viewName: 'mainView';
            framingBlock: ( FramingParameters new iDUE: (iDUE + (15@54)); xC; yC; cRDU: (0@0 rightBottom: iDUE));
            pStyle: #(sysmenu titlebar sizable);
            addSubpane: (
                composite
                    owner: self;
                    framingBlock: ( FramingParameters new iDUE: iDUE; lDU: 0 r: #left; rDU: 0 r: #right; tDU: 0 r: #top; bDU: 0 r: #bottom);
                    addSubpanes;
                    "scrollbars;"
                    startGroup;
                    yourself
            );
        yourself
    ).
    aViewManager isNil ifFalse: [ self parent: aViewManager ].
    self openWindow.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBCompositePaneTester class' osiMethods: 'WindowBuilder' !  
isWBInternalClass

    ^true! !

"WB Dev Code Gen (WB2ADEVW.SLL)"!
!'WBCreateMenuModule' osiMethods: 'WindowBuilder' !  
defaultShouldLogMethodSource
        "Answer true if the receiver's source should be logged."
    ^super defaultShouldLogMethodSource
        and: [ PWindowBuilder licensed ]! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBDevelopmentDialog' osiMethods: 'WindowBuilder' !  
openWindow

    self mainView children do: [:each |
        each font: SysFont].
    ^super openWindow! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBEditClassDialog' osiMethods: 'WindowBuilder' !  
clearMostFrequent

    "Callback for the #clicked event triggered in the Button named 'clearMostFrequent'.
     (Generated by WindowBuilder)"

    Notifier isAltKeyDown
        ifTrue: [
            self class frequentClasses elements removeKey: 
                (Smalltalk at: (mostFrequent selectedItem ifNil: [^nil]) asSymbol ifAbsent: [^nil]).
            mostFrequent text: '']
        ifFalse: [self class clearFrequentClasses].
    self loadMostFrequent.
    selectedClass := nil.
    self setWindowTitle.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBEditClassDialog' osiMethods: 'WindowBuilder' !  
clearMostRecent

    "Callback for the #clicked event triggered in the Button named 'clearMostRecent'.
     (Generated by WindowBuilder)"

    Notifier isAltKeyDown
        ifTrue: [
            self class recentClasses remove: 
                (Smalltalk at: (mostRecent selectedItem ifNil: [^nil]) asSymbol ifAbsent: [^nil]).
            mostRecent text: '']
        ifFalse: [self class clearRecentClasses].
    self loadMostRecent.
    selectedClass := self mostRecentList isEmpty
        ifTrue: [nil]
        ifFalse: [Smalltalk at: (mostRecent selectedItem ifNil: [^nil]) asSymbol ifAbsent: [^nil]].
    self setWindowTitle.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBEditClassDialog' osiMethods: 'WindowBuilder' !  
createViews

        "WARNING!! This method was automatically generated by
        WindowBuilder. Code you add here which does not conform to
        the WindowBuilder API will probably be lost the next time
        you save your layout definition."

    | addFilter anyFilter anyPackage cancel clearMostFrequent
    clearMostRecent filterGroup mainView mostFrequentLabel
    mostRecentLabel packageLabel removeFilter |

    mainView := self topPaneClass new.

        "Instance Variables"
    filter := WBComboBox new.
    list := ListBox new.
    mostFrequent := WBComboBox new.
    mostRecent := WBComboBox new.
    ok := Button new.
    package := WBComboBox new.

        "Temporary Variables"
    addFilter := Button new.
    anyFilter := Button new.
    anyPackage := Button new.
    cancel := Button new.
    clearMostFrequent := Button new.
    clearMostRecent := Button new.
    filterGroup := GroupBox new.
    mostFrequentLabel := StaticText new.
    mostRecentLabel := StaticText new.
    packageLabel := StaticText new.
    removeFilter := Button new.

    mainView "WBEditClassDialog"
        owner: self;
        paneName: 'mainView';
        labelWithoutPrefix:  'Edit Class';
        noSmalltalkMenuBar;
        framingBlock: ( FramingParameters new iDUE: 777 @ 760; xC; yC; cRDU: (0 @ 0 rightBottom: 777 @ 760));
        pStyle: #(sysmenu modal titlebar).
    self addView: mainView.

    mostRecent "WBComboBox"
        owner: self;
        paneName: 'mostRecent';
        framingBlock: ( FramingParameters new iDUE: 366 @ 312; lDU: 274 r: #left; rDU: 640 r: #left; tDU: 16 r: #top; bDU: 328 r: #top);
        dropDownList;
        startGroup;
        tabStop;
        when: #changed: send: #mostRecentSelect: to: self.
    mainView addSubpane: mostRecent.

    clearMostRecent "Button"
        owner: self;
        paneName: 'clearMostRecent';
        framingBlock: ( FramingParameters new iDUE: 119 @ 48; lDU: 649 r: #left; rDU: 768 r: #left; tDU: 16 r: #top; bDU: 64 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #clearMostRecent to: self;
        contents: 'Clear'.
    mainView addSubpane: clearMostRecent.

    mostFrequent "WBComboBox"
        owner: self;
        paneName: 'mostFrequent';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 366 @ 312; lDU: 274 r: #left; rDU: 640 r: #left; tDU: 72 r: #top; bDU: 384 r: #top);
        dropDownList;
        startGroup;
        tabStop;
        when: #changed: send: #mostFrequentSelect: to: self.
    mainView addSubpane: mostFrequent.

    clearMostFrequent "Button"
        owner: self;
        paneName: 'clearMostFrequent';
        framingBlock: ( FramingParameters new iDUE: 119 @ 48; lDU: 649 r: #left; rDU: 768 r: #left; tDU: 72 r: #top; bDU: 120 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #clearMostFrequent to: self;
        contents: 'Clear'.
    mainView addSubpane: clearMostFrequent.

    package "WBComboBox"
        owner: self;
        paneName: 'package';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 366 @ 312; lDU: 274 r: #left; rDU: 640 r: #left; tDU: 128 r: #top; bDU: 440 r: #top);
        dropDownList;
        startGroup;
        tabStop;
        when: #changed: send: #packageSelect: to: self.
    mainView addSubpane: package.

    anyPackage "Button"
        owner: self;
        paneName: 'anyPackage';
        framingBlock: ( FramingParameters new iDUE: 119 @ 48; lDU: 649 r: #left; rDU: 768 r: #left; tDU: 128 r: #top; bDU: 176 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #anyPackage to: self;
        contents: 'Any'.
    mainView addSubpane: anyPackage.

    list "ListBox"
        owner: self;
        paneName: 'list';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 759 @ 416; lDU: 9 r: #left; rDU: 768 r: #left; tDU: 184 r: #top; bDU: 600 r: #top);
        startGroup;
        tabStop;
        when: #clicked: send: #listSelect: to: self;
        when: #doubleClicked: send: #ok: to: self.
    mainView addSubpane: list.

    filter "WBComboBox"
        owner: self;
        paneName: 'filter';
        framingBlock: ( FramingParameters new iDUE: 539 @ 312; lDU: 27 r: #left; rDU: 567 r: #left; tDU: 640 r: #top; bDU: 832 r: #top);
        dropDownList;
        startGroup;
        tabStop;
        when: #changed: send: #filterSelect: to: self.
    mainView addSubpane: filter.

    anyFilter "Button"
        owner: self;
        paneName: 'anyFilter';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 165 @ 48; lDU: 27 r: #left; rDU: 192 r: #left; tDU: 696 r: #top; bDU: 744 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #anyFilter to: self;
        contents: 'Any'.
    mainView addSubpane: anyFilter.

    addFilter "Button"
        owner: self;
        paneName: 'addFilter';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 165 @ 48; lDU: 210 r: #left; rDU: 375 r: #left; tDU: 696 r: #top; bDU: 744 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #addFilter to: self;
        contents: 'Add'.
    mainView addSubpane: addFilter.

    removeFilter "Button"
        owner: self;
        paneName: 'removeFilter';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 174 @ 48; lDU: 393 r: #left; rDU: 567 r: #left; tDU: 696 r: #top; bDU: 744 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #removeFilter to: self;
        contents: 'Remove'.
    mainView addSubpane: removeFilter.

    ok "Button"
        owner: self;
        paneName: 'ok';
        framingBlock: ( FramingParameters new iDUE: 165 @ 64; lDU: 603 r: #left; rDU: 768 r: #left; tDU: 616 r: #top; bDU: 680 r: #top);
        defaultPushButton;
        startGroup;
        tabStop;
        when: #clicked send: #ok to: self;
        contents: 'OK'.
    mainView addSubpane: ok.

    cancel "Button"
        owner: self;
        paneName: 'cancel';
        framingBlock: ( FramingParameters new iDUE: 165 @ 64; lDU: 603 r: #left; rDU: 768 r: #left; tDU: 688 r: #top; bDU: 752 r: #top);
        cancelPushButton;
        startGroup;
        tabStop;
        when: #clicked send: #cancel to: self;
        contents: 'Cancel'.
    mainView addSubpane: cancel.

    mostRecentLabel "StaticText"
        owner: self;
        paneName: 'mostRecentLabel';
        framingBlock: ( FramingParameters new iDUE: 238 @ 32; lDU: 27 r: #left; rDU: 265 r: #left; tDU: 24 r: #top; bDU: 56 r: #top);
        rightJustified;
        startGroup;
        contents: 'Most Recent:'.
    mainView addSubpane: mostRecentLabel.

    mostFrequentLabel "StaticText"
        owner: self;
        paneName: 'mostFrequentLabel';
        framingBlock: ( FramingParameters new iDUE: 238 @ 32; lDU: 27 r: #left; rDU: 265 r: #left; tDU: 80 r: #top; bDU: 112 r: #top);
        rightJustified;
        startGroup;
        contents: 'Most Frequent:'.
    mainView addSubpane: mostFrequentLabel.

    packageLabel "StaticText"
        owner: self;
        paneName: 'packageLabel';
        framingBlock: ( FramingParameters new iDUE: 238 @ 32; lDU: 27 r: #left; rDU: 265 r: #left; tDU: 136 r: #top; bDU: 168 r: #top);
        rightJustified;
        startGroup;
        contents: 'Package:'.
    mainView addSubpane: packageLabel.

    filterGroup "GroupBox"
        owner: self;
        paneName: 'filterGroup';
        framingBlock: ( FramingParameters new iDUE: 576 @ 152; lDU: 9 r: #left; rDU: 585 r: #left; tDU: 600 r: #top; bDU: 752 r: #top);
        startGroup;
        contents: 'Filter'.
    mainView addSubpane: filterGroup! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBEditClassDialog' osiMethods: 'WindowBuilder' !  
initWindow

    | filterChoice |

    alt := Notifier isAltKeyDown.
    self class cleanClassLists.
    self
        loadMostRecent;
        loadMostFrequent.

    self inTeamV
        ifTrue: [
            package
                contents: self packageList;
                selectItem: self class packageChoice]
        ifFalse: [
            package disable.
            (self paneNamed: 'packageLabel') disable.
            (self paneNamed: 'anyPackage') disable].

    filter
        contents: self class filterList;
        selectItem: (filterChoice := self class filter).

    self updateListContents.
    
    selectedClass := self class recentClasses notEmpty
        ifTrue: [ self class recentClasses first ]
        ifFalse: [ nil ].

    self setWindowTitle.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBEditClassDialog' osiMethods: 'WindowBuilder' !  
listSelect: selectedItem

    "Callback for the #clicked: event triggered in the ListBox named 'list'.
     (Generated by WindowBuilder)"

    selectedItem ifNil: [ ^self ].
    selectedClass := Smalltalk at: selectedItem asSymbol ifAbsent: [^nil].
    self setWindowTitle.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBEditClassDialog' osiMethods: 'WindowBuilder' !  
mostFrequentSelect: selectedItem

    "Callback for the #clicked: event triggered in the WBComboBox named 'mostFrequent'.
     (Generated by WindowBuilder)"

    selectedClass := Smalltalk at: (selectedItem ifNil: [^nil]) asSymbol ifAbsent: [^nil].
    list clearSelection.
    self setWindowTitle.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBEditClassDialog' osiMethods: 'WindowBuilder' !  
mostRecentSelect: selectedItem

    "Callback for the #clicked: event triggered in the WBComboBox named 'mostRecent'.
     (Generated by WindowBuilder)"

    selectedClass := Smalltalk at: (selectedItem ifNil: [^nil]) asSymbol ifAbsent: [^nil].
    list clearSelection.
    self setWindowTitle.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBEditClassDialog' osiMethods: 'WindowBuilder' !  
updateListContents

    self loadClassList.
    list hideWindow; showWindow.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBEditClassDialog class' osiMethods: 'WindowBuilder' !  
cleanClassLists

    FrequentClasses := self frequentClasses reject: [:class |
        [class isDeletedClass] on: MessageNotUnderstood do: [false]].
    RecentClasses := self recentClasses reject: [:class | 
        [class isDeletedClass] on: MessageNotUnderstood do: [false]].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBEnhancedEntryFieldEditor' osiMethods: 'WindowBuilder' !  
supportsJustification

    ^true! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBFramerExample' osiMethods: 'WindowBuilder' !  
clientRectangle

    ^0@0 extent: self rectangle extent - 2! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBFramerExample' osiMethods: 'WindowBuilder' !  
display

    frameRect notNil ifTrue: [
        self pen
            drawRectangle: frameRect;
            fill: (frameRect insetBy: 1) color: Color white.
    ].
    paneRect notNil ifTrue: [
        self pen 
            fill: (Rectangle 
                leftTop: paneRect leftTop 
                rightBottom: (paneRect rightBottom leftMostAndHighest: (frameRect rightBottom leftAndUp:  1))) 
            color: Color blue
    ].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBFramingEditor' osiMethods: 'WindowBuilder' !  
createViews

        "WARNING!! This method was automatically generated by
        WindowBuilder. Code you add here which does not conform to
        the WindowBuilder API will probably be lost the next time
        you save your layout definition."

    | afterResizeLabel beforeResizeLabel bottomGroup cancel
    centeringGroup exampleGroup leftGroup mainView ok
    rightGroup topGroup |

    mainView := self topPaneClass new.

        "Instance Variables"
    afterRect := WBFramerExample new.
    beforeRect := WBFramerExample new.
    bottomRelative := StaticText new.
    cornerXAnchor := WBComboBox new.
    cornerXStyleFixed := RadioButton new.
    cornerXStyleScaled := RadioButton new.
    cornerYAnchor := WBComboBox new.
    cornerYStyleFixed := RadioButton new.
    cornerYStyleScaled := RadioButton new.
    leftRelative := StaticText new.
    originXAnchor := WBComboBox new.
    originXStyleFixed := RadioButton new.
    originXStyleScaled := RadioButton new.
    originYAnchor := WBComboBox new.
    originYStyleFixed := RadioButton new.
    originYStyleScaled := RadioButton new.
    rightRelative := StaticText new.
    topRelative := StaticText new.
    xCenteredCheckBox := CheckBox new.
    yCenteredCheckBox := CheckBox new.

        "Temporary Variables"
    afterResizeLabel := StaticText new.
    beforeResizeLabel := StaticText new.
    bottomGroup := GroupBox new.
    cancel := Button new.
    centeringGroup := GroupBox new.
    exampleGroup := GroupBox new.
    leftGroup := GroupBox new.
    ok := Button new.
    rightGroup := GroupBox new.
    topGroup := GroupBox new.

    mainView "WBFramingEditor"
        owner: self;
        paneName: 'mainView';
        labelWithoutPrefix:  'Set Framing Parameters';
        noSmalltalkMenuBar;
        framingBlock: ( FramingParameters new iDUE: 987 @ 644; xC; yC; cRDU: (0 @ 0 rightBottom: 987 @ 644));
        pStyle: #(sysmenu modal titlebar).
    self addView: mainView.

    originXStyleFixed "RadioButton"
        owner: self;
        paneName: 'originXStyleFixed';
        framingBlock: ( FramingParameters new iDUE: 174 @ 40; lDU: 37 r: #left; rDU: 210 r: #left; tDU: 40 r: #top; bDU: 80 r: #top);
        startGroup;
        tabStop;
        when: #turnedOn send: #originXStyleChanged: to: self withArgument: originXStyleFixed;
        contents: 'Fixed'.
    mainView addSubpane: originXStyleFixed.

    originXStyleScaled "RadioButton"
        owner: self;
        paneName: 'originXStyleScaled';
        framingBlock: ( FramingParameters new iDUE: 174 @ 40; lDU: 37 r: #left; rDU: 210 r: #left; tDU: 80 r: #top; bDU: 120 r: #top);
        when: #turnedOn send: #originXStyleChanged: to: self withArgument: originXStyleScaled;
        contents: 'Scaled'.
    mainView addSubpane: originXStyleScaled.

    originXAnchor "WBComboBox"
        owner: self;
        paneName: 'originXAnchor';
        framingBlock: ( FramingParameters new iDUE: 352 @ 190; lDU: 210 r: #left; rDU: 562 r: #left; tDU: 76 r: #top; bDU: 266 r: #top);
        dropDownList;
        startGroup;
        tabStop;
        when: #changed: send: #originXAnchorChanged: to: self.
    mainView addSubpane: originXAnchor.

    cornerXStyleFixed "RadioButton"
        owner: self;
        paneName: 'cornerXStyleFixed';
        framingBlock: ( FramingParameters new iDUE: 174 @ 40; lDU: 37 r: #left; rDU: 210 r: #left; tDU: 176 r: #top; bDU: 216 r: #top);
        startGroup;
        tabStop;
        when: #turnedOn send: #cornerXStyleChanged: to: self withArgument: cornerXStyleFixed;
        contents: 'Fixed'.
    mainView addSubpane: cornerXStyleFixed.

    cornerXStyleScaled "RadioButton"
        owner: self;
        paneName: 'cornerXStyleScaled';
        framingBlock: ( FramingParameters new iDUE: 174 @ 40; lDU: 37 r: #left; rDU: 210 r: #left; tDU: 216 r: #top; bDU: 256 r: #top);
        when: #turnedOn send: #cornerXStyleChanged: to: self withArgument: cornerXStyleScaled;
        contents: 'Scaled'.
    mainView addSubpane: cornerXStyleScaled.

    cornerXAnchor "WBComboBox"
        owner: self;
        paneName: 'cornerXAnchor';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 352 @ 190; lDU: 210 r: #left; rDU: 562 r: #left; tDU: 212 r: #top; bDU: 402 r: #top);
        dropDownList;
        startGroup;
        tabStop;
        when: #changed: send: #cornerXAnchorChanged: to: self.
    mainView addSubpane: cornerXAnchor.

    originYStyleFixed "RadioButton"
        owner: self;
        paneName: 'originYStyleFixed';
        framingBlock: ( FramingParameters new iDUE: 174 @ 40; lDU: 37 r: #left; rDU: 210 r: #left; tDU: 312 r: #top; bDU: 352 r: #top);
        startGroup;
        tabStop;
        when: #turnedOn send: #originYStyleChanged: to: self withArgument: originYStyleFixed;
        contents: 'Fixed'.
    mainView addSubpane: originYStyleFixed.

    originYStyleScaled "RadioButton"
        owner: self;
        paneName: 'originYStyleScaled';
        framingBlock: ( FramingParameters new iDUE: 174 @ 40; lDU: 37 r: #left; rDU: 210 r: #left; tDU: 352 r: #top; bDU: 392 r: #top);
        when: #turnedOn send: #originYStyleChanged: to: self withArgument: originYStyleScaled;
        contents: 'Scaled'.
    mainView addSubpane: originYStyleScaled.

    originYAnchor "WBComboBox"
        owner: self;
        paneName: 'originYAnchor';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 352 @ 190; lDU: 210 r: #left; rDU: 562 r: #left; tDU: 348 r: #top; bDU: 538 r: #top);
        dropDownList;
        startGroup;
        tabStop;
        when: #changed: send: #originYAnchorChanged: to: self.
    mainView addSubpane: originYAnchor.

    cornerYStyleFixed "RadioButton"
        owner: self;
        paneName: 'cornerYStyleFixed';
        framingBlock: ( FramingParameters new iDUE: 174 @ 40; lDU: 37 r: #left; rDU: 210 r: #left; tDU: 448 r: #top; bDU: 488 r: #top);
        startGroup;
        tabStop;
        when: #turnedOn send: #cornerYStyleChanged: to: self withArgument: cornerYStyleFixed;
        contents: 'Fixed'.
    mainView addSubpane: cornerYStyleFixed.

    cornerYStyleScaled "RadioButton"
        owner: self;
        paneName: 'cornerYStyleScaled';
        framingBlock: ( FramingParameters new iDUE: 174 @ 40; lDU: 37 r: #left; rDU: 210 r: #left; tDU: 488 r: #top; bDU: 528 r: #top);
        when: #turnedOn send: #cornerYStyleChanged: to: self withArgument: cornerYStyleScaled;
        contents: 'Scaled'.
    mainView addSubpane: cornerYStyleScaled.

    cornerYAnchor "WBComboBox"
        owner: self;
        paneName: 'cornerYAnchor';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 352 @ 190; lDU: 210 r: #left; rDU: 562 r: #left; tDU: 484 r: #top; bDU: 674 r: #top);
        dropDownList;
        startGroup;
        tabStop;
        when: #changed: send: #cornerYAnchorChanged: to: self.
    mainView addSubpane: cornerYAnchor.

    xCenteredCheckBox "CheckBox"
        owner: self;
        paneName: 'xCenteredCheckBox';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 229 @ 40; lDU: 37 r: #left; rDU: 265 r: #left; tDU: 584 r: #top; bDU: 624 r: #top);
        startGroup;
        tabStop;
        when: #clicked: send: #xCenteredToggled: to: self;
        contents: '&Horizontally'.
    mainView addSubpane: xCenteredCheckBox.

    yCenteredCheckBox "CheckBox"
        owner: self;
        paneName: 'yCenteredCheckBox';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 183 @ 40; lDU: 329 r: #left; rDU: 512 r: #left; tDU: 584 r: #top; bDU: 624 r: #top);
        startGroup;
        tabStop;
        when: #clicked: send: #yCenteredToggled: to: self;
        contents: '&Vertically'.
    mainView addSubpane: yCenteredCheckBox.

    ok "Button"
        owner: self;
        paneName: 'ok';
        framingBlock: ( FramingParameters new iDUE: 183 @ 72; lDU: 594 r: #left; rDU: 777 r: #left; tDU: 560 r: #top; bDU: 632 r: #top);
        defaultPushButton;
        startGroup;
        tabStop;
        when: #clicked send: #ok to: self;
        contents: '&OK'.
    mainView addSubpane: ok.

    cancel "Button"
        owner: self;
        paneName: 'cancel';
        framingBlock: ( FramingParameters new iDUE: 183 @ 72; lDU: 786 r: #left; rDU: 969 r: #left; tDU: 560 r: #top; bDU: 632 r: #top);
        cancelPushButton;
        startGroup;
        tabStop;
        when: #clicked send: #cancel to: self;
        contents: '&Cancel'.
    mainView addSubpane: cancel.

    afterRect "WBFramerExample"
        owner: self;
        paneName: 'afterRect';
        framingBlock: ( FramingParameters new iDUE: 338 @ 208; lDU: 613 r: #left; rDU: 951 r: #left; tDU: 320 r: #top; bDU: 528 r: #top);
        startGroup.
    mainView addSubpane: afterRect.

    beforeRect "WBFramerExample"
        owner: self;
        paneName: 'beforeRect';
        framingBlock: ( FramingParameters new iDUE: 256 @ 176; lDU: 613 r: #left; rDU: 869 r: #left; tDU: 80 r: #top; bDU: 256 r: #top);
        startGroup.
    mainView addSubpane: beforeRect.

    afterResizeLabel "StaticText"
        owner: self;
        paneName: 'afterResizeLabel';
        framingBlock: ( FramingParameters new iDUE: 338 @ 32; lDU: 613 r: #left; rDU: 951 r: #left; tDU: 288 r: #top; bDU: 320 r: #top);
        startGroup;
        contents: 'After Resizing:'.
    mainView addSubpane: afterResizeLabel.

    beforeResizeLabel "StaticText"
        owner: self;
        paneName: 'beforeResizeLabel';
        framingBlock: ( FramingParameters new iDUE: 256 @ 32; lDU: 613 r: #left; rDU: 869 r: #left; tDU: 48 r: #top; bDU: 80 r: #top);
        startGroup;
        contents: 'Before Resizing:'.
    mainView addSubpane: beforeResizeLabel.

    topRelative "StaticText"
        owner: self;
        paneName: 'topRelative';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 352 @ 32; lDU: 210 r: #left; rDU: 562 r: #left; tDU: 316 r: #top; bDU: 348 r: #top);
        startGroup;
        contents: 'Relative to:'.
    mainView addSubpane: topRelative.

    rightRelative "StaticText"
        owner: self;
        paneName: 'rightRelative';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 352 @ 32; lDU: 210 r: #left; rDU: 562 r: #left; tDU: 180 r: #top; bDU: 212 r: #top);
        startGroup;
        contents: 'Relative to:'.
    mainView addSubpane: rightRelative.

    leftRelative "StaticText"
        owner: self;
        paneName: 'leftRelative';
        framingBlock: ( FramingParameters new iDUE: 352 @ 32; lDU: 210 r: #left; rDU: 562 r: #left; tDU: 44 r: #top; bDU: 76 r: #top);
        startGroup;
        contents: 'Relative to:'.
    mainView addSubpane: leftRelative.

    bottomRelative "StaticText"
        owner: self;
        paneName: 'bottomRelative';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 352 @ 32; lDU: 210 r: #left; rDU: 562 r: #left; tDU: 452 r: #top; bDU: 484 r: #top);
        startGroup;
        contents: 'Relative to:'.
    mainView addSubpane: bottomRelative.

    centeringGroup "GroupBox"
        owner: self;
        paneName: 'centeringGroup';
        framingBlock: ( FramingParameters new iDUE: 558 @ 88; lDU: 18 r: #left; rDU: 576 r: #left; tDU: 544 r: #top; bDU: 632 r: #top);
        startGroup;
        contents: 'Centering'.
    mainView addSubpane: centeringGroup.

    leftGroup "GroupBox"
        owner: self;
        paneName: 'leftGroup';
        framingBlock: ( FramingParameters new iDUE: 558 @ 136; lDU: 18 r: #left; rDU: 576 r: #left; tDU: 0 r: #top; bDU: 136 r: #top);
        startGroup;
        contents: 'Left'.
    mainView addSubpane: leftGroup.

    rightGroup "GroupBox"
        owner: self;
        paneName: 'rightGroup';
        framingBlock: ( FramingParameters new iDUE: 558 @ 136; lDU: 18 r: #left; rDU: 576 r: #left; tDU: 136 r: #top; bDU: 272 r: #top);
        startGroup;
        contents: 'Right'.
    mainView addSubpane: rightGroup.

    topGroup "GroupBox"
        owner: self;
        paneName: 'topGroup';
        framingBlock: ( FramingParameters new iDUE: 558 @ 136; lDU: 18 r: #left; rDU: 576 r: #left; tDU: 272 r: #top; bDU: 408 r: #top);
        startGroup;
        contents: 'Top'.
    mainView addSubpane: topGroup.

    bottomGroup "GroupBox"
        owner: self;
        paneName: 'bottomGroup';
        framingBlock: ( FramingParameters new iDUE: 558 @ 136; lDU: 18 r: #left; rDU: 576 r: #left; tDU: 408 r: #top; bDU: 544 r: #top);
        startGroup;
        contents: 'Bottom'.
    mainView addSubpane: bottomGroup.

    exampleGroup "GroupBox"
        owner: self;
        paneName: 'exampleGroup';
        framingBlock: ( FramingParameters new iDUE: 375 @ 544; lDU: 594 r: #left; rDU: 969 r: #left; tDU: 0 r: #top; bDU: 544 r: #top);
        startGroup;
        contents: 'Example'.
    mainView addSubpane: exampleGroup! !

"WB Dev Base Common"!
!'WBFramingEditor' osiMethods !  
initializeExampleRects

    (parentRect width > parentRect height)
        ifTrue:
            [beforeScaleFactor := (beforeRect extent x / WBFramingParameters newDialogUnit x) / parentRect width.
            ]
        ifFalse:
            [beforeScaleFactor := (beforeRect extent y / WBFramingParameters newDialogUnit y) / parentRect height.
            ].
    beforeRect frameRect: (0 @ 0 extent: (parentRect extent * beforeScaleFactor) rounded * 2).
    afterRect frameRect: (0 @ 0 extent: (afterRect extent / WBFramingParameters newDialogUnit) rounded * 2).
    largeParentRect := parentRect leftBottom extentFromLeftBottom: ((afterRect frameRect extent / beforeRect frameRect extent) * parentRect extent) rounded.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBFramingEditor' osiMethods: 'WindowBuilder' !  
initializeOnFramer: aFramer
rects: thePanesRects
parentRect: theParentsRect

    framingParameters := aFramer.
    currentRectList := thePanesRects.
    parentRect := theParentsRect.
    hasFramed := false.
    "Initialize all uninitialized combo boxes"
    originXAnchor
        contents: #('Window left' 'Window right' 'Window center' 'Pane right');
        enable.
    originYAnchor
        contents: #('Window top' 'Window bottom' 'Window center' 'Pane bottom');
        enable.
    cornerXAnchor
        contents: #('Window left' 'Window right' 'Window center' 'Pane left');
        enable.
    cornerYAnchor
        contents: #('Window top' 'Window bottom' 'Window center' 'Pane top');
        enable.
    originXAnchor selectIndex: 1.
    originYAnchor selectIndex: 1.
    cornerXAnchor selectIndex: 1.
    cornerYAnchor selectIndex: 1.
    originXStyleFixed
        selection: false;
        enable.
    originXStyleScaled
        selection: false;
        enable.
    originYStyleFixed
        selection: false;
        enable.
    originYStyleScaled
        selection: false;
        enable.
    cornerXStyleFixed
        selection: false;
        enable.
    cornerXStyleScaled
        selection: false;
        enable.
    cornerYStyleFixed
        selection: false;
        enable.
    cornerYStyleScaled
        selection: false;
        enable.
    bottomRelative enable.
    topRelative enable.
    rightRelative enable.
    leftRelative enable.
    "For initialization only - the y coordinate needs to be configured
     to a legal value for setExampleRects to work"
    yCenteredCheckBox selection: true.
    framingParameters isNil
        ifTrue:
            [originXStyleFixed selection: true.
            originXAnchor selectItem: 'Window left'.
            originXAnchor disableItem: 'Pane right'.
            originYStyleFixed selection: true.
            originYAnchor selectItem: 'Window top'.
            originYAnchor disableItem: 'Pane bottom'.
            cornerXStyleFixed selection: true.
            cornerXAnchor selectItem: 'Pane left'.
            cornerYStyleFixed selection: true.
            cornerYAnchor selectItem: 'Pane top'.
            xCenteredCheckBox selection: false.
            yCenteredCheckBox selection: false.
            ]
        ifFalse:
            [framingParameters centerX
                ifTrue:
                    [xCenteredCheckBox selection: true.
                    self xCenteredToggled: true "xCenteredCheckBox".
                    ]
                ifFalse:
                    [xCenteredCheckBox selection: false.
                    framingParameters left isNil
                        ifTrue:
                            [originXStyleFixed selection: true.
                            originXAnchor selectItem: 'Pane right'.
                            cornerXAnchor disableItem: 'Pane left'.
                            ]
                        ifFalse:
                            [framingParameters left isInteger
                                ifFalse:
                                    [originXStyleScaled selection: true.
                                    self originXStyleChanged: originXStyleScaled.
                                    ]
                                ifTrue:
                                    [originXStyleFixed selection: true.
                                    originXAnchor selectItem: 'Window ' , framingParameters leftRel asCUAPresentableString.
                                    self originXStyleChanged: originXStyleScaled.
                                    ].
                            ].
                    framingParameters right isNil
                        ifTrue:
                            [cornerXStyleFixed selection: true.
                            cornerXAnchor selectItem: 'Pane left'.
                            originXAnchor disableItem: 'Pane right'.
                            ]
                        ifFalse:
                            [framingParameters right isInteger
                                ifFalse:
                                    [cornerXStyleScaled selection: true.
                                    self cornerXStyleChanged: cornerXStyleScaled.
                                    ]
                                ifTrue:
                                    [cornerXStyleFixed selection: true.
                                    cornerXAnchor selectItem: 'Window ' , framingParameters rightRel asCUAPresentableString.
                                    self cornerXStyleChanged: cornerXStyleFixed.
                                    ].
                            ].
                    ].
            framingParameters centerY
                ifTrue:
                    [yCenteredCheckBox selection: true.
                    self yCenteredToggled: true "yCenteredCheckBox".
                    ]
                ifFalse:
                    [yCenteredCheckBox selection: false.
                    framingParameters top isNil
                        ifTrue:
                            [originYStyleFixed selection: true.
                            originYAnchor selectItem: 'Pane bottom'.
                            cornerYAnchor disableItem: 'Pane top'.
                            ]
                        ifFalse:
                            [framingParameters top isInteger
                                ifFalse:
                                    [originYStyleScaled selection: true.
                                    self originYStyleChanged: originYStyleScaled.
                                    ]
                                ifTrue:
                                    [originYStyleFixed selection: true.
                                    originYAnchor selectItem: 'Window ' , framingParameters topRel asCUAPresentableString.
                                    self originYStyleChanged: originYStyleFixed.
                                    ].
                            ].
                    framingParameters bottom isNil
                        ifTrue:
                            [cornerYStyleFixed selection: true.
                            cornerYAnchor selectItem: 'Pane top'.
                            originYAnchor disableItem: 'Pane bottom'.
                            ]
                        ifFalse:
                            [framingParameters bottom isInteger
                                ifFalse:
                                    [cornerYStyleScaled selection: true.
                                    self cornerYStyleChanged: cornerYStyleScaled.
                                    ]
                                ifTrue:
                                    [cornerYStyleFixed selection: true.
                                    cornerYAnchor selectItem: 'Window ' , framingParameters bottomRel asCUAPresentableString.
                                    self cornerYStyleChanged: cornerYStyleFixed.
                                    ].
                            ].
                    ].
            ].
    "Since several PM events will have been queued up at this point,
     we have to flush them out before continuing..."
    Smalltalk platformIsOS2 ifTrue: [
        Notifier empty ].
    hasFramed := true.
    self initializeExampleRects.
    self setExampleRects.! !

"WB Dev Base Common"!
!'WBFramingEditor' osiMethods !  
newFramerForRect: aRect
parentRect: parentsRect

    | anchor coord framer |
    framer := FramingParameters new.
    framer initialExtent: framingParameters initialExtent.
    (xCenteredCheckBox selection)
        ifTrue:
            [framer xCentered.
            ]
        ifFalse:
            [anchor := originXAnchor selectedItem.
            coord := aRect left.
            (originXStyleFixed selection) & (anchor ~= 'Pane right')
                ifTrue:
                    [(anchor = 'Window right')
                        ifTrue:
                            [coord := parentsRect width - coord.
                            framer left: coord relativeTo: #right.
                            ]
                        ifFalse:
                            [(anchor = 'Window center')
                                ifTrue:
                                    [coord := coord - (parentsRect width // 2).
                                    framer left: coord relativeTo: #center.
                                    ]
                                ifFalse:
                                    [framer left: coord relativeTo: #left.
                                    ]].
                    ].
            (originXStyleScaled selection)
                ifTrue:
                    [coord := coord / parentsRect extent x.
                    framer leftProportional: coord.
                    ].
            anchor := cornerXAnchor selectedItem.
            coord := aRect right.
            (cornerXStyleFixed selection) & (anchor ~= 'Pane left')
                ifTrue:
                    [(anchor = 'Window right')
                        ifTrue:
                            [coord := parentsRect width - coord.
                            framer right: coord relativeTo: #right.
                            ]
                        ifFalse:
                            [(anchor = 'Window center')
                                ifTrue:
                                    [coord := coord - (parentsRect width // 2).
                                    framer right: coord relativeTo: #center.
                                    ]
                                ifFalse:
                                    [framer right: coord relativeTo: #left.
                                    ]].
                    ].
            (cornerXStyleScaled selection)
                ifTrue:
                    [coord := coord / parentsRect extent x.
                    framer rightProportional: coord.
                    ].
            ].
    (yCenteredCheckBox selection)
        ifTrue:
            [framer yCentered.
            ]
        ifFalse:
            [anchor := originYAnchor selectedItem.
            coord := aRect top.
            (originYStyleFixed selection) & (anchor ~= 'Pane bottom')
                ifTrue:
                    [(anchor = 'Window top')
                        ifTrue:
                            [framer top: coord relativeTo: #top.
                            ]
                        ifFalse:
                            [(anchor = 'Window center')
                                ifTrue:
                                    [framer top: coord - (parentsRect height // 2) relativeTo: #center.
                                    ]
                                ifFalse:
                                    [framer top: parentsRect height - coord relativeTo: #bottom.
                                    ]].
                    ].
            (originYStyleScaled selection)
                ifTrue:
                    [coord := coord / parentsRect extent y.
                    framer topProportional: coord.
                    ].
            anchor := cornerYAnchor selectedItem.
            coord := aRect bottom.
            (cornerYStyleFixed selection) & (anchor ~= 'Pane top')
                ifTrue:
                    [(anchor = 'Window top')
                        ifTrue:
                            [framer bottom: coord relativeTo: #top.
                            ]
                        ifFalse:
                            [(anchor = 'Window center')
                                ifTrue:
                                    [framer bottom: coord - (parentsRect height // 2) relativeTo: #center.
                                    ]
                                ifFalse:
                                    [framer bottom: parentsRect height - coord relativeTo: #bottom.
                                    ]].
                    ].
            (cornerYStyleScaled selection)
                ifTrue:
                    [coord := coord / parentsRect extent y.
                    framer bottomProportional: coord.
                    ].
            ].
    framer left isNil & framer right isNil
        ifTrue:
            [framer left: aRect left relativeTo: #left.
            ].
    framer top isNil & framer bottom isNil
        ifTrue:
            [framer bottom: aRect bottom relativeTo: #bottom.
            ].
    ^framer! !

"WB Dev Base Common"!
!'WBFramingEditor' osiMethods !  
setExampleRects

    | pRect framer |
    hasFramed
        ifFalse: [^self].
    framer := self newFramerForRect: currentRectList first parentRect: parentRect.
    pRect := framer value: parentRect.
    pRect := ((parentRect offsetFromLeftTop: pRect) * beforeScaleFactor) rounded * 2 + (1 @ 1) extentFromLeftTop: (pRect extent * beforeScaleFactor) rounded * 2.
    beforeRect paneRect: pRect.
    pRect := framer value: largeParentRect.
    pRect := ((largeParentRect offsetFromLeftTop: pRect) * beforeScaleFactor) rounded * 2 + (1 @ 1) extentFromLeftTop: (pRect extent * beforeScaleFactor) rounded * 2.
    afterRect paneRect: pRect.
    ! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'WBInterfaceObject' osiMethods: 'WindowBuilder' !  
mutateTo: aClassName
    "Mutate a pane into another type"
    | class mutation supportedEvents triggeredEvents size |

    (Smalltalk includesKey: aClassName asSymbol)
        ifTrue: [
            class := WBRealLayoutPane basicNew pseudoClassFor: aClassName.
            mutation := class new.
            mutation
                initialize;
                realClass: (Smalltalk at: aClassName asSymbol);
                handlers: IdentityDictionary new;
                eventHandlers: IdentityDictionary new.
            supportedEvents := mutation supportedEvents.
            self handlers keysDo: [:key |
                (supportedEvents includes: key)
                    ifTrue: [mutation handlers at: key put: (self handlers at: key)]].
            triggeredEvents := mutation eventsTriggered.
            self eventHandlers keysDo: [:key |
                (triggeredEvents includes: key)
                    ifTrue: [
                        mutation eventHandlers at: key put: (self eventHandlers at: key).
                        mutation eventHandlerTargets at: key put: (self eventHandlerTargets at: key)]].
            self eventHandlersReferencingSelf do: [:assoc |
                assoc value: mutation].
            (mutation styles notNil and: [mutation styles includes: self style])
                ifTrue: [mutation style: self style]
                ifFalse: [mutation style: mutation defaultStyle].
            mutation usesMenu & self usesMenu
                ifTrue: [
                    mutation menu: (self menu notNil
                        ifTrue: [self menu fullCopy]
                        ifFalse: [nil])].
            mutation usesColor & self usesColor
                ifTrue: [
                    (self foreColor = self defaultForeColor)
                        ifFalse: [mutation foreColor: self foreColor]
                        ifTrue: [mutation foreColor: mutation defaultForeColor].
                    (self realBackColor = self defaultBackColor)
                        ifFalse: [mutation backColor: self realBackColor]
                        ifTrue: [mutation backColor: mutation defaultBackColor]].
            mutation usesFont & self usesFont
                ifTrue: [mutation font: self font].
            mutation usesTitle & self usesTitle
                ifTrue: [
                    self contents isNil
                        ifTrue: [mutation text: '']
                        ifFalse: [mutation text: self text]].
            mutation
                parent: self parent;
                paneName: self paneName;
                framingBlock: self framingBlock;
                tabPosition: self tabPosition;
                rect: self rect deepCopy.
            (mutation changesSize and: [(size := mutation suggestedSize) notNil])
                ifTrue: [mutation rect: (mutation rect extent: size)].
            self mutationRotationList isEmpty
                ifFalse: [
                    (self mutationRotationList includes: aClassName asSymbol)
                        ifTrue: [mutation rect: (mutation rect extent: mutation rect extent transpose)]].
            mutation mutateSpecificsFrom: self.
            ^mutation]
    ifFalse: [^nil].! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'WBInterfaceObject' osiMethods: 'WindowBuilder' !  
supportedEvents
    | answer |
    (answer := self realClass supportedEvents) isNil ifTrue: [^#( )].
    ^answer asSortedCollection! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBKeyAccel' osiMethods: 'WindowBuilder' !  
printAccelOn: aStream

    | pmCode |

    aStream nextPut: $'.

    self isAlt ifTrue: [
        aStream nextPutAll: 'Alt'.
    ].
    self isShift ifTrue: [
        aStream nextPutAll: 'Shift'.
    ].
    self isCtrl ifTrue: [
        aStream nextPutAll: 'Ctrl'.
    ].

    keyCode notNil ifTrue: [
        aStream nextPut: $+.
    ].

    keyCode isCharacter ifTrue: [
        aStream nextPut: keyCode.
    ] ifFalse: [
        pmCode := Smalltalk platformIsWin32
            ifTrue: [ self pmKeyCodeFor: keyCode ]
            ifFalse: [ keyCode ].

        pmCode notNil ifTrue: [
            aStream nextPutAll: pmCode asString
        ].
    ].

    aStream nextPut: $'.! !

"WB Dev Code Gen (WB2ADEVW.SLL)"!
!'WBLayoutCodeModule' osiMethods: 'WindowBuilder' !  
defaultShouldLogMethodSource
        "Answer true if the receiver's source should be logged."
    ^super defaultShouldLogMethodSource
        and: [ PWindowBuilder licensed ]! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBLayoutPane' osiMethods: 'WindowBuilder' !  
bringToFront

    self
        triggerEvent: #changed;
        hideSelectionDots.
    Notifier isControlKeyDown
        ifTrue: [
            self bringPaneToFront: selectedPanes first ]
        ifFalse: [
            (panes select: [ :each | selectedPanes includes: each ])
                reverseDo: [ :each | self bringPaneToFront: each ] ].
    self showSelectionDots.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBLayoutPane' osiMethods: 'WindowBuilder' !  
button1Down: aPoint

    "Dragging the window via the title bar to the PARTS workbench?"
    "If yes, then allow the normal drag/drop mechanism to work."
    (self isLocalDragSource and: [ self isDragButton: 1 ]) ifTrue: [
        (self inTitle: aPoint)
            & PWindowBuilder partsSupportEnabled
                ifTrue: [ ^super button1Down: aPoint ] ].

    self button1Down: aPoint shifted: Notifier isControlKeyDown.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBLayoutPane' osiMethods: 'WindowBuilder' !  
button2Down: aPoint

    "Dragging the window via the title bar to the PARTS workbench?"
    "If yes, then allow the normal drag/drop mechanism to work."
    (self isLocalDragSource and: [ self isDragButton: 2 ]) ifTrue: [
        (self inTitle: aPoint)
            & PWindowBuilder partsSupportEnabled
                ifTrue: [ ^super button2Down: aPoint ] ].

    self triggerEvent: #gettingFocus.

    loadedPanes isNil ifTrue: [
        ^self triggerEvent: #rightButtonDown: with: self

    ] ifFalse: [
        self placeLoadedPanesAt: aPoint resetCursor: false.

        "They may place again, so copy the loaded subpanes."
        loadedPanes := Array
            with: ((loadedPanes at: 1) collect: [ :aPane | aPane fullCopy ])
            with: (loadedPanes at: 2).
    ].

    self checkSelectionChanged.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBLayoutPane' osiMethods: 'WindowBuilder' !  
doSizeWindow: newExtent

    self lastOperation: #sizeWindow savedInfo: self editedPaneFrameRect extent.
    editedPane frameRectExtent: newExtent.
    self scrollPane windowHasSized.
    panes do: [:pane |
        pane reframe: self editedPaneContentRect].
    self hideWindow; showWindow.
    self setFocus.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBLayoutPane' osiMethods: 'WindowBuilder' !  
dragRect: aRect from: aPoint constrainedBy: constrainRect gridSize: aGridSize withMethod: method

    | mouseLoc  moveRect  newPoint delta region minMove movedEnough |

    minMove := 3@3.
    movedEnough := false.

    self captureMouseInput.
    moveRect := aRect.

    mouseLoc := aPoint.

    delta := aPoint - moveRect leftTop.
    region := self pen setClipRect: self clipRect.

    self pen drawFocusRect: moveRect.

    Notifier consumeInputUntil: [ :e |
        (e selector = #button1Move:) | (e selector = #button2Move:)  ifTrue: [
            mouseLoc := e arguments first.
         ].

        newPoint := (mouseLoc - constrainRect leftTop) - delta.

        newPoint := (newPoint // aGridSize * aGridSize) + constrainRect leftTop.

        newPoint x: ((newPoint x rightMost: constrainRect left) leftMost: (constrainRect right left: moveRect width)).
        newPoint y: ((newPoint y lowerOf: constrainRect top) higherOf: (constrainRect bottom up: moveRect height)).

        (movedEnough or: [ (newPoint + delta - aPoint) x abs > minMove x or: [ (newPoint + delta - aPoint) y abs > minMove y ]]) ifTrue: [
            movedEnough := true.
            (newPoint = moveRect leftTop) ifFalse: [
                self pen drawFocusRect: moveRect.
                moveRect moveToLeftTop: newPoint.
                method isNil ifFalse: [
                    self perform: method withArguments: (Array with: moveRect).
                ].
                self pen drawFocusRect: moveRect.
            ].
        ].
        (e selector = #button1Up:) | (e selector = #button2Up:)
    ].

    self pen drawFocusRect: moveRect.
    self clearMouseCapture.

    self pen destroyRegion: region.

     ^moveRect leftTop! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBLayoutPane' osiMethods: 'WindowBuilder' !  
drawGridWithin: aRect

        | contentRect left right top bottom p gridSize |

        gridSize := self gridSize.
        self drawGrid ifFalse: [ ^self ].

        contentRect := self editedPaneContentRect.

        left := contentRect left right: ((contentRect left distanceRight: aRect left) truncateTo: gridSize x).
        right := aRect right.
        top := contentRect top down: ((contentRect top distanceDown: aRect top) truncateTo: gridSize y).
        bottom := aRect bottom.

        editedPane backColor == Color paleGray ifTrue: [
            self pen foreColor: Color darkGray
        ] ifFalse: [
             self pen foreColor: Color paleGray
       ].

        p := self pen.
        (left min: right) to: (left max: right) by: gridSize x do: [ :curX |
            p lineFrom: curX @ top to: curX @ bottom.
        ].
        (top min: bottom) to: (top max: bottom) by: gridSize y do: [:curY |
            p lineFrom: left @ curY to: right @ curY.
        ].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBLayoutPane' osiMethods: 'WindowBuilder' !  
exportedPanes

    ^panes! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBLayoutPane' osiMethods: 'WindowBuilder' !  
importPanes: paneList

   ^paneList! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBLayoutPane' osiMethods: 'WindowBuilder' !  
isPM

    ^Smalltalk platformIsOS2! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBLayoutPane' osiMethods: 'WindowBuilder' !  
placeDeletedPanesAt: p resetCursor: resetCursor

    | aPane paneList paneOrigins  |

    self unselectAll.

    paneList := loadedPanes at: 1.
    paneOrigins := loadedPanes at: 2.

    PWindowBuilder licensed ifFalse: [
        paneList size + panes size > 10 ifTrue: [
            PWindowBuilder buyACopy.
            ^self ] ].

    1 to: paneList size do: [ :paneIndex |
        aPane := paneList at: paneIndex.
        aPane rect moveToLeftTop: (p + (paneOrigins at: paneIndex)).
        panes addFirst: aPane.
    ].

    panes do: [ :aPane |
        self recalcFramerFor: aPane.
    ].

    self triggerEvent: #changed.

    selectedPanes := paneList asOrderedCollection.
    self updateRect: self selectedRect.
    self select: paneList.

    self showSelectionDots.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBLayoutPane' osiMethods: 'WindowBuilder' !  
placeLoadedPanesAt: p resetCursor: resetCursor  interactive: isInteractive

    | aPane paneList paneOrigins aPoint mouseStillDown e topStaysToBack gridSize |

    gridSize := self gridSize.
    self unselectAll.

    paneList := loadedPanes at: 1.
    paneOrigins := loadedPanes at: 2.

    PWindowBuilder licensed ifFalse: [
        paneList size + panes size > 10 ifTrue: [
            PWindowBuilder buyACopy.
            ^self ] ].

    aPoint := self roundPointToGrid: p.

    "If there's more than one pane, we can't set the size by dragging."
    paneList size = 1 & isInteractive ifTrue: [
        mouseStillDown := true.
        Notifier consumeInputUntil: [ :event |
            (event selector = #button1Up:) | (event selector = #button2Up:)  ifTrue: [
                mouseStillDown := false.
            ].
            (event selector = #button1Move:) |  (event selector = #button2Move:) |
            (event selector = #button1Up:) | (event selector = #button2Up:)
        ].
        mouseStillDown ifTrue: [
            e := (self
                rubberBandRect: (aPoint extent: 1@1)
                from: aPoint
                inDirection: #downRight
                constrainedBy: (self editedPaneContentLeftTop extentFromLeftTop: editedPane contentRect extent)
                minimumSize: paneList first minSize
                maximumSize: paneList first maxSize
                foldOver: false
                gridSize: gridSize
                withMethod: nil) extent.
        ].
    ].

    resetCursor ifTrue: [
        CursorManager normal change.
    ].

    paneList := paneList collect: [:w | w fullCopy ].

    (e notNil and: [ (e y > 3) & (e x > 3) ]) ifTrue: [
        paneList first rect extent: e.
    ].

    panes reverseDo: [ :pane |
        pane staysToBack ifTrue: [
            topStaysToBack  := pane.
        ].
    ].

    1 to: paneList size do: [ :paneIndex |
        aPane := paneList at: paneIndex.
        aPane rect moveToLeftTop: (aPoint + (paneOrigins at: paneIndex)).
        aPane parent: editedPane.
        aPane staysToBack ifTrue: [
            topStaysToBack notNil ifTrue: [
                panes add: aPane before: topStaysToBack.
            ] ifFalse: [
                panes addLast: aPane.
            ].
            topStaysToBack := aPane.
        ] ifFalse: [
            panes addFirst: aPane.
        ].
        aPane tabPosition: nil.
    ].

    panes do: [ :aPane |
        self recalcFramerFor: aPane.
    ].

    self triggerEvent: #changed.

    selectedPanes := paneList asOrderedCollection.
    self updateRect: self selectedRect.
    self select: paneList.

    self showSelectionDots.
    self lastOperation: #place savedInfo: #notUndoable.! !

"WB Dev Base Common"!
!'WBLayoutPane' osiMethods !  
rubberBandRect: aRect from: aPoint inDirection: direction constrainedBy: constrainer minimumSize: minSize maximumSize:  maxSize  foldOver: foldOver gridSize: aGridSize withMethod: method

    | region mouseLoc sizeRect constrainRect delta anchor sizer minExtent maxExtent xPositive yPositive  |

    mouseLoc := aPoint.

    minExtent := minSize.
    minSize isNil ifTrue: [
        minExtent := 1@1.
    ].

    maxExtent := maxSize.
    maxSize isNil ifTrue: [
        maxExtent := 30000@30000.
    ].

    sizeRect := aRect.
    constrainRect := constrainer.

    "------- Set up anchor and sizer -------"

    ( #( upLeft up left ) includes: direction) ifTrue: [
        anchor := sizeRect rightBottom.
        sizer := sizeRect leftTop.
    ].

    (#( downRight down right) includes: direction) ifTrue: [
        anchor := sizeRect leftTop.
        sizer := sizeRect rightBottom.
    ].

    (direction == #upRight) ifTrue: [
        anchor := sizeRect left @ sizeRect bottom.
        sizer := sizeRect right @ sizeRect top
    ].

    (direction == #downLeft) ifTrue: [
        anchor := sizeRect right @ sizeRect top.
        sizer := sizeRect left @ sizeRect bottom
    ].

    "------- Set up constrain rect and min extent -------"

    (direction == #up) | (direction == #down) ifTrue: [
        constrainRect := sizeRect left @ constrainRect top rightBottom: sizeRect right @ constrainRect bottom.
        minExtent := sizeRect width @ minExtent y.
    ].
    (direction = #right) | (direction = #left) ifTrue: [
        constrainRect := constrainRect left @ sizeRect top rightBottom: constrainRect right @ sizeRect bottom.
        minExtent := minExtent x @ sizeRect height.
    ].
    constrainRect extent: (constrainRect extent min: maxExtent).

    delta   := aPoint - sizer.
    xPositive := (sizer x isRightOf: anchor x).
    yPositive := (sizer y isBelow: anchor y).

    self captureMouseInput.

    region := self pen setClipRect: self clipRect.
    self pen  drawFocusRect: sizeRect.

    KeepDotsHidden := true. "avoid redraw on drag scroll"
    Notifier consumeInputUntil: [ :e |

        (e selector = #button1Move:) | (e selector = #button2Move:)  ifTrue: [
            mouseLoc :=  e arguments first.
         ] ifFalse: [
            e perform.
        ].

        sizer := ((mouseLoc - delta) leftAndUp:  constrainRect leftTop) // aGridSize * aGridSize rightAndDown: constrainRect leftTop.

        (sizer x isLeftOf: constrainRect left) ifTrue: [ sizer x: constrainRect left ].
        (sizer x isRightOf: constrainRect right) ifTrue: [ sizer x: constrainRect right ].
        (sizer y isAbove: constrainRect top) ifTrue: [ sizer y: constrainRect top ].
        (sizer y isBelow: constrainRect bottom) ifTrue: [ sizer y: constrainRect bottom ].

        xPositive ifTrue: [
            foldOver ifFalse: [
                ((sizer x left: anchor x) isLeftOf: minExtent x) ifTrue: [ sizer x: (anchor x right: minExtent x) ].
            ].
            ((sizer x left: anchor x) isRightOf: constrainRect width) ifTrue: [ sizer x: (anchor x right: constrainRect width) ].
        ] ifFalse: [
            foldOver ifFalse: [
                ((anchor x left: sizer x) isLeftOf: minExtent x) ifTrue: [ sizer x: (anchor x left: minExtent x) ].
            ].
            ((anchor x left: sizer x) isRightOf: constrainRect width) ifTrue: [ sizer x: (anchor x left: constrainRect width) ].
        ].

        yPositive ifTrue: [
            foldOver ifFalse: [
                ((sizer y - anchor y) < minExtent y) ifTrue: [ sizer y: (anchor y + minExtent y) ].
            ].
            ((sizer y - anchor y) > constrainRect height) ifTrue: [ sizer y: (anchor y + constrainRect height) ].
        ] ifFalse: [
            foldOver ifFalse: [
                ((anchor y - sizer y) < minExtent y) ifTrue: [  sizer y: (anchor y - minExtent y) ].
            ].
            ((anchor y - sizer y) > constrainRect height) ifTrue: [ sizer y: (anchor y - constrainRect height) ].
        ].

        (sizer = sizeRect leftTop) | (sizer = sizeRect rightBottom)
         | (sizer = (sizeRect left @ sizeRect bottom))
         | (sizer = (sizeRect right @ sizeRect top)) ifFalse: [

            self pen drawFocusRect: sizeRect.
            (anchor x < sizer x)  ifTrue:  [
                (anchor y < sizer y) ifTrue:  [
                    sizeRect := anchor corner: sizer
                ] ifFalse: [
                    sizeRect := (anchor x)@(sizer y) corner: (sizer x)@(anchor y)
                ]
            ] ifFalse: [
                (anchor y < sizer y) ifTrue: [
                    sizeRect := (sizer x)@(anchor y) corner: (anchor x)@(sizer y)
                ] ifFalse: [
                    sizeRect := sizer corner: anchor
                ]
            ].
            method isNil ifFalse: [
                self perform: method withArguments: (Array with: sizeRect)
            ].
            self pen drawFocusRect: sizeRect.
        ].

         (e selector = #button1Up:) | (e selector = #button2Up:)
    ].

    self pen drawFocusRect: sizeRect.

    KeepDotsHidden := false.
    self clearMouseCapture.
    self pen destroyRegion: region.

     ^sizeRect! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBLayoutPane' osiMethods: 'WindowBuilder' !  
sendPaneToBack: aPane

    | firstBackPane |
    panes remove: aPane.

    firstBackPane := panes detect: [ :pane | pane staysToBack ] ifNone: [ nil ].
    (aPane staysToBack or: [ firstBackPane isNil ]) ifTrue: [
        panes addLast: aPane
    ] ifFalse: [
        panes add: aPane before: firstBackPane
    ].

    self updateRect: aPane rect.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBLayoutPane' osiMethods: 'WindowBuilder' !  
sendToBack

    | firstBackPane |
    self
        triggerEvent: #changed;
        hideSelectionDots.
    Notifier isControlKeyDown
        ifTrue: [
            self sendPaneToBack: selectedPanes first ]
        ifFalse: [
            (panes select: [ :each | selectedPanes includes: each ])
                do: [ :each | self sendPaneToBack: each ] ].
    self showSelectionDots.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBLayoutPane' osiMethods: 'WindowBuilder' !  
sizeWindowExternal: aPoint

    self triggerEvent: #changed.
    self hideSelectionDots.
    self hideSizeDot.
    self doSizeWindow: aPoint + (
        editedPane isDialog
            ifTrue: [
                (0 @ (editedPane titleHeight + editedPane menuHeight))
                    + (editedPane borderWidth * 2) ]
            ifFalse: [ 0 ] ).! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBListEntryField' osiMethods: 'WindowBuilder' !  
setContents: aString
        "Set the receiver's contents without triggering a textChanged event."
    self
        setPopupMenu: nil;
        contents: aString;
        removeTextChangedEvent;
        selectAll.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBListEntryField' osiMethods: 'WindowBuilder' !  
textChanged
        "Private - handle the changing of text contents."
    super textChanged.
    self setPopupMenu: nil.
    owningListBox editBoxTextChanged.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBMenubarEditor' osiMethods: 'WindowBuilder' !  
testMenu

    | tester list |
    self updateItem: menuItemsEditor selection.
    tester := WBMenuTester new.
    (list := menuItemsEditor listAttribute asFlatList) do: [:each |
        each title: (self nlsStringFor: each title)].
    tester menubar: menuItemsEditor contents asMenu.
    list do: [:each | 	each title: (self nlsKeyFor: each title)].
    tester open.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBMenuEditor' osiMethods: 'WindowBuilder' !  
createViews

        " WARNING!! This method was automatically generated by
        WindowBuilder. Code you add here which does not conform to
        the WindowBuilder API will probably be lost the next time
        you save your layout definition."

    | actionButton cancelButton deleteItemButton
    insertItemButton itemAttributesGroupbox linkButton
    listEntryField mainView okButton selectorLabel separator |

    mainView := self topPaneClass new.

        " Instance Variables"
    dividerState := CheckBox new.
    hasAccelCheckBox := CheckBox new.
    isAlt := CheckBox new.
    isCtrl := CheckBox new.
    isShift := CheckBox new.
    keyShortCutEditor := WBComboBox new.
    menuItemsEditor := WBTreeListBox new.
    selectorEditor := WBEntryField new.
    shiftDownButton := Button new.
    shiftLeftButton := Button new.
    shiftRightButton := Button new.
    shiftUpButton := Button new.
    testItButton := Button new.

        " Temporary Variables"
    actionButton := Button new.
    cancelButton := Button new.
    deleteItemButton := Button new.
    insertItemButton := Button new.
    itemAttributesGroupbox := GroupBox new.
    linkButton := Button new.
    listEntryField := WBListEntryField new.
    okButton := Button new.
    selectorLabel := StaticText new.
    separator := StaticBox new.

    mainView "WBMenuEditor"
        owner: self;
        paneName: 'mainView';
        labelWithoutPrefix:  'Menu Editor';
        noSmalltalkMenuBar;
        framingBlock: ( FramingParameters new iDUE: 1399 @ 504; xC; yC; cRDU: (0 @ 0 rightBottom: 1399 @ 504));
        pStyle: #(sysmenu modal titlebar).
    self addView: mainView.

    selectorLabel "StaticText"
        owner: self;
        paneName: 'selectorLabel';
        framingBlock: ( FramingParameters new iDUE: 135 @ 32; lDU: 896 r: #left; rDU: 1031 r: #left; tDU: 120 r: #top; bDU: 152 r: #top);
        startGroup;
        contents: 'Selector:'.
    mainView addSubpane: selectorLabel.

    listEntryField "WBListEntryField"
        owner: self;
        paneName: 'listEntryField';
        framingBlock: ( FramingParameters new iDUE: 585 @ 48; lDU: 21 r: #left; rDU: 606 r: #left; tDU: 18 r: #top; bDU: 66 r: #top; indent: 3 @ 4);
        startGroup;
        tabStop;
        when: #needsPopupMenu send: #popupNlsMenu: to: self withArgument: listEntryField.
    mainView addSubpane: listEntryField.

    selectorEditor "WBEntryField"
        owner: self;
        paneName: 'selectorEditor';
        framingBlock: ( FramingParameters new iDUE: 329 @ 48; lDU: 1038 r: #left; rDU: 1367 r: #left; tDU: 112 r: #top; bDU: 160 r: #top; indent: 3 @ 4);
        startGroup;
        tabStop;
        when: #textChanged: send: #selectorEditorChanged: to: self.
    mainView addSubpane: selectorEditor.

    keyShortCutEditor "ComboBox"
        owner: self;
        paneName: 'keyShortCutEditor';
        framingBlock: ( FramingParameters new iDUE: 263 @ 336; lDU: 1104 r: #left; rDU: 1367 r: #left; tDU: 264 r: #top; bDU: 600 r: #top);
        dropDown;
        startGroup;
        tabStop;
        when: #textChanged: send: #newAccelerator: to: self;
        when: #changed: send: #newAccelerator: to: self;
        when: #needsContents send: #loadKeyList: to: self withArgument: keyShortCutEditor.
    mainView addSubpane: keyShortCutEditor.

    insertItemButton "Button"
        owner: self;
        paneName: 'insertItemButton';
        framingBlock: ( FramingParameters new iDUE: 222 @ 60; lDU: 626 r: #left; rDU: 848 r: #left; tDU: 76 r: #top; bDU: 136 r: #top);
        defaultPushButton;
        startGroup;
        tabStop;
        when: #clicked send: #insertItem to: self;
        contents: '&Insert'.
    mainView addSubpane: insertItemButton.

    deleteItemButton "Button"
        owner: self;
        paneName: 'deleteItemButton';
        framingBlock: ( FramingParameters new iDUE: 222 @ 60; lDU: 626 r: #left; rDU: 848 r: #left; tDU: 140 r: #top; bDU: 200 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #deleteItem to: self;
        contents: 'De&lete'.
    mainView addSubpane: deleteItemButton.

    shiftUpButton "Button"
        owner: self;
        paneName: 'shiftUpButton';
        framingBlock: ( FramingParameters new iDUE: 222 @ 60; lDU: 626 r: #left; rDU: 848 r: #left; tDU: 208 r: #top; bDU: 268 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #shiftUp to: self;
        contents: 'Shift &up'.
    mainView addSubpane: shiftUpButton.

    shiftDownButton "Button"
        owner: self;
        paneName: 'shiftDownButton';
        framingBlock: ( FramingParameters new iDUE: 222 @ 60; lDU: 626 r: #left; rDU: 848 r: #left; tDU: 272 r: #top; bDU: 332 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #shiftDown to: self;
        contents: 'Shift do&wn'.
    mainView addSubpane: shiftDownButton.

    testItButton "Button"
        owner: self;
        paneName: 'testItButton';
        framingBlock: ( FramingParameters new iDUE: 222 @ 62; lDU: 626 r: #left; rDU: 848 r: #left; tDU: 340 r: #top; bDU: 402 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #testMenu to: self;
        when: #needsPopupMenu send: #getTestItMenu: to: self withArgument: testItButton;
        contents: '&Test menu'.
    mainView addSubpane: testItButton.

    dividerState "CheckBox"
        owner: self;
        paneName: 'dividerState';
        framingBlock: ( FramingParameters new iDUE: 155 @ 40; lDU: 901 r: #left; rDU: 1056 r: #left; tDU: 176 r: #top; bDU: 216 r: #top);
        startGroup;
        tabStop;
        when: #clicked: send: #newDividerState: to: self;
        contents: 'Di&vider'.
    mainView addSubpane: dividerState.

    actionButton "Button"
        owner: self;
        paneName: 'actionButton';
        framingBlock: ( FramingParameters new iDUE: 155 @ 60; lDU: 1074 r: #left; rDU: 1230 r: #left; tDU: 168 r: #top; bDU: 228 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #action to: self;
        contents: 'Action...'.
    mainView addSubpane: actionButton.

    linkButton "Button"
        owner: self;
        paneName: 'linkButton';
        framingBlock: ( FramingParameters new iDUE: 128 @ 60; lDU: 1239 r: #left; rDU: 1367 r: #left; tDU: 168 r: #top; bDU: 228 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #link to: self;
        contents: 'Li&nk...'.
    mainView addSubpane: linkButton.

    hasAccelCheckBox "CheckBox"
        owner: self;
        paneName: 'hasAccelCheckBox';
        framingBlock: ( FramingParameters new iDUE: 201 @ 40; lDU: 901 r: #left; rDU: 1102 r: #left; tDU: 268 r: #top; bDU: 308 r: #top);
        startGroup;
        tabStop;
        when: #clicked: send: #accelCheckBoxChanged: to: self;
        contents: '&Key accel:'.
    mainView addSubpane: hasAccelCheckBox.

    isShift "CheckBox"
        owner: self;
        paneName: 'isShift';
        framingBlock: ( FramingParameters new iDUE: 123 @ 40; lDU: 933 r: #left; rDU: 1056 r: #left; tDU: 340 r: #top; bDU: 380 r: #top);
        startGroup;
        tabStop;
        contents: '&Shift'.
    mainView addSubpane: isShift.

    isAlt "CheckBox"
        owner: self;
        paneName: 'isAlt';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 80 @ 40; lDU: 1083 r: #left; rDU: 1163 r: #left; tDU: 340 r: #top; bDU: 380 r: #top);
        startGroup;
        tabStop;
        contents: '&Alt'.
    mainView addSubpane: isAlt.

    isCtrl "CheckBox"
        owner: self;
        paneName: 'isCtrl';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 183 @ 40; lDU: 1189 r: #left; rDU: 1371 r: #left; tDU: 340 r: #top; bDU: 380 r: #top);
        startGroup;
        tabStop;
        contents: 'Cont&rol'.
    mainView addSubpane: isCtrl.

    shiftLeftButton "Button"
        owner: self;
        paneName: 'shiftLeftButton';
        framingBlock: ( FramingParameters new iDUE: 290 @ 60; lDU: 21 r: #left; rDU: 311 r: #left; tDU: 424 r: #top; bDU: 484 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #shiftLeft to: self;
        contents: '<< &Demote item'.
    mainView addSubpane: shiftLeftButton.

    shiftRightButton "Button"
        owner: self;
        paneName: 'shiftRightButton';
        framingBlock: ( FramingParameters new iDUE: 290 @ 60; lDU: 318 r: #left; rDU: 608 r: #left; tDU: 424 r: #top; bDU: 484 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #shiftRight to: self;
        contents: '&Promote item >>'.
    mainView addSubpane: shiftRightButton.

    okButton "Button"
        owner: self;
        paneName: 'okButton';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 231 @ 60; lDU: 878 r: #left; rDU: 1109 r: #left; tDU: 424 r: #top; bDU: 484 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #ok to: self;
        contents: '&OK'.
    mainView addSubpane: okButton.

    cancelButton "Button"
        owner: self;
        paneName: 'cancelButton';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 233 @ 60; lDU: 1147 r: #left; rDU: 1381 r: #left; tDU: 424 r: #top; bDU: 484 r: #top);
        cancelPushButton;
        startGroup;
        tabStop;
        when: #clicked send: #cancel to: self;
        contents: '&Cancel'.
    mainView addSubpane: cancelButton.

    menuItemsEditor "WBTreeListBox"
        owner: self;
        paneName: 'menuItemsEditor';
        framingBlock: ( FramingParameters new iDUE: 585 @ 326; lDU: 21 r: #left; rDU: 606 r: #left; tDU: 76 r: #top; bDU: 402 r: #top);
        "ownerDrawFixed;"
        startGroup;
        tabStop;
        when: #clicked: send: #selectedItem: to: self;
        when: #textChanged: send: #menuItemNameChanged: to: self;
        when: #preSelect: send: #commitSelection: to: self.
    mainView addSubpane: menuItemsEditor.

    separator "StaticBox"
        owner: self;
        paneName: 'separator';
        framingBlock: ( FramingParameters new iDUE: 462 @ 4; lDU: 901 r: #left; rDU: 1362 r: #left; tDU: 236 r: #top; bDU: 240 r: #top);
        blackRectangle;
        startGroup.
    mainView addSubpane: separator.

    itemAttributesGroupbox "GroupBox"
        owner: self;
        paneName: 'itemAttributesGroupbox';
        framingBlock: ( FramingParameters new iDUE: 503 @ 340; lDU: 878 r: #left; rDU: 1381 r: #left; tDU: 60 r: #top; bDU: 400 r: #top);
        startGroup;
        contents: 'Item attributes'.
    mainView addSubpane: itemAttributesGroupbox! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBMenuEditor' osiMethods: 'WindowBuilder' !  
fillInCurrentItem

    | currentItem |

    currentItem := menuItemsEditor selectedItem
        ifNil: [ ^self ].

    self updateTestButton.

    currentItem selector isMessage ifTrue: [
        currentItem selector receiver isWBAction ifTrue: [
            selectorEditor contents: '<Action: ',currentItem selector receiver script asString,'>'
        ] ifFalse: [
            selectorEditor contents: '<Link: ',currentItem selector receiver asString,'>'
        ].
    ] ifFalse: [ currentItem selector notNil ifTrue: [
        selectorEditor contents: currentItem selector asString.
    ] ifFalse: [
        selectorEditor contents: ''.
    ]].

    dividerState selection: currentItem isSeparator & currentItem hasChildren not.

    self disableAttributes: (self allowAttributesFor: currentItem) not.
    (self allowDividerFor: currentItem) ifTrue: [
        dividerState enable.
    ] ifFalse: [
        dividerState disable.
    ].

    keyShortCutEditor
        text: (currentItem accelerator isNil
            ifTrue: [''] ifFalse: [currentItem accelerator keyName]).

    (self allowAttributesFor: currentItem) ifFalse: [
        keyShortCutEditor text: ''.
    ].

    isShift selection: (currentItem hasChildren not & currentItem accelerator notNil and: [ currentItem accelerator isShift ]).
    isCtrl selection: (currentItem hasChildren not & currentItem accelerator notNil and: [ currentItem accelerator isCtrl ]).
    isAlt selection: (currentItem hasChildren not & currentItem accelerator notNil and: [ currentItem accelerator isAlt ]).
    hasAccelCheckBox selection: currentItem hasChildren not & keyShortCutEditor text notEmpty.

    currentItem canExdent not ifTrue: [
        shiftLeftButton disable.
    ] ifFalse: [
        shiftLeftButton enable.
    ].
    currentItem canIndent not ifTrue: [
        shiftRightButton disable
    ] ifFalse: [
        shiftRightButton enable.
    ].

    currentItem canMoveUp not ifTrue: [
        shiftUpButton disable.
    ] ifFalse: [
        shiftUpButton enable.
    ].

    currentItem canMoveDown not ifTrue: [
        shiftDownButton disable.
    ] ifFalse: [
        shiftDownButton enable.
    ].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBMenuEditor' osiMethods: 'WindowBuilder' !  
getTestItMenu: button

    | m list |

    self updateItem: menuItemsEditor selection.
    (list := menuItemsEditor listAttribute asFlatList) do: [:each |
        each title: (self nlsStringFor: each title)].
    (m :=  menuItemsEditor contents asMenu) isCollection ifTrue: [^self].
    list do: [:each | 	each title: (self nlsKeyFor: each title)].
    m owner: self.
    button setPopupMenu: m.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBMenuEditor' osiMethods: 'WindowBuilder' !  
initializeOn: aPMenu

    (aPMenu hasChildren) ifFalse: [
        aPMenu addChild: WBPMenuItem new.
    ].

    aPMenu asFlatList do: [:each |
        each title: (self nlsKeyFor: each title)].
    aPMenu updateListStrings.
    menuItemsEditor contents: aPMenu.
    (self paneNamed: 'listEntryField')
        contents: aPMenu firstChild title;
        selectAll.
    menuItemsEditor selectIndex: 1.

    self fillInCurrentItem.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBMenuEditor' osiMethods: 'WindowBuilder' !  
newAccelerator: text

    | accel |

    self warnOfAccelerators.

    self checkKeyAccels.

    (accel := WBKeyAccel new keyName: text) notNil ifTrue: [
        keyShortCutEditor text = accel keyName ifFalse: [
            keyShortCutEditor text: accel keyName ].
    ] ifFalse: [
        isAlt selection: false.
        isCtrl selection: false.
        isShift selection: false.
    ].

    hasAccelCheckBox selection:  accel notNil.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBMenuEditor' osiMethods: 'WindowBuilder' !  
nlsKeyFor: aString
    | nlsKey nlsText nlsPools |
    nlsText := aString.
    (nlsPools := self nlsPools) notEmpty
        ifTrue: [
            nlsPools detect: [:sym |
               (nlsKey := (Smalltalk at: sym)
                    keyAtValue: aString
                    ifAbsent: [nil]) ~~ nil] ifNone: [].
            nlsKey notNil
                ifTrue: [nlsText := '#', nlsKey]].
    ^nlsText! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBMenuEditor' osiMethods: 'WindowBuilder' !  
nlsPools

    ^[(Smalltalk platformIsOS2
        ifTrue: [self mainView pmOwner]
        ifFalse: [self mainView parent]) 
        owner editedCoordinator editedPane nlsPools asArray]
        on: Error do: [#()].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBMenuEditor' osiMethods: 'WindowBuilder' !  
nlsStringFor: aString
    | nlsString nlsKey nlsPool |
    nlsString := aString.
    (aString notEmpty and: [aString first == $#])
        ifTrue: [
            nlsKey := aString copyFrom: 2 to: aString size.
            self nlsPools detect: [:sym |
                (nlsString := (nlsPool := Smalltalk at: sym) at: nlsKey
                    ifAbsent: [nlsString := nlsPool at: nlsKey asSymbol
                    ifAbsent: [aString]]) ~= aString]
                    ifNone: []].
    ^nlsString! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBMenuEditor' osiMethods: 'WindowBuilder' !  
ok

    self updateItem: menuItemsEditor selection.
    menuItemsEditor listAttribute asFlatList do: [:each |
        each title: (self nlsStringFor: each title)].
    result := self pMenu.
    super close! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBMenuEditor' osiMethods: 'WindowBuilder' !  
popupNlsMenu: aPane

    | menu subMenu subMenus nlsPool nlsPools checkItem assoc array answer |

    (nlsPools := self nlsPools) isEmpty
        ifTrue: [^aPane setPopupMenu: nil].

    menu := Menu new
        owner: aPane;
        selector: #contents:;
        yourself.

    nlsPools size == 1
        ifTrue: [
            ((array := (nlsPool := Smalltalk at: nlsPools first) keys asSortedCollection asArray) 
                copyFrom: 1 to: (array size min: 24)) do: [:key |
                assoc := nlsPool associationAt: key.
                menu appendItem: ('#',assoc key, ' - ', assoc value printString) selector: ('#', assoc key) asSymbol].
            array size > 24
                ifTrue: [
                    menu appendSeparator;
                        appendItem: 'Other...' action:
                            (Message receiver: [
                                (answer := WBListChooser 
                                    fromList: (array collect: [:key |
                                        assoc := nlsPool associationAt: key.
                                        ('#',assoc key, ' - ', assoc value printString)])
                                    prompt: 'Select NLS Key') isNil
                                    ifFalse: [aPane contents: (answer upTo: $ )]] selector: #value)]]
        ifFalse: [
            subMenus := OrderedCollection new: nlsPools size.
            nlsPools do: [:sym |
                menu appendSubMenu:
                    (subMenu := Menu new
                        title: sym;
                        owner: aPane;
                        selector: #contents:;
                        yourself).
                subMenus add: subMenu.
                ((array := (nlsPool := Smalltalk at: sym) keys asSortedCollection asArray) 
                    copyFrom: 1 to: (array size min: 24)) do: [:key |
                    assoc := nlsPool associationAt: key.
                    subMenu appendItem: ('#',assoc key, ' - ', assoc value printString) selector: ('#', assoc key) asSymbol].
                array size > 24
                    ifTrue: [
                        subMenu appendSeparator;
                            appendItem: 'Other...' action:
                                (Message receiver: [
                                    (answer := WBListChooser 
                                        fromList: (array collect: [:key |
                                            assoc := nlsPool associationAt: key.
                                            ('#',assoc key, ' - ', assoc value printString)])
                                        prompt: 'Select NLS Key') isNil
                                        ifFalse: [aPane contents: (answer upTo: $ )]] selector: #value)]]].
    checkItem := ((self nlsKeyFor: aPane contents) ifNil: ['']) asSymbol.
    subMenus isNil
        ifTrue: [menu checkItem: checkItem]
        ifFalse: [
            subMenus do: [:sub |
                sub checkItem: checkItem]].

    aPane setPopupMenu: menu.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBMenuEditor' osiMethods: 'WindowBuilder' !  
updateItem: itemIndex

    | item accel list |

    itemIndex isNil ifTrue: [ ^self ].
    list := menuItemsEditor contents asFlatList.
    list size < itemIndex ifTrue: [
        ^self
    ].

    item := list at: itemIndex.

    item isSeparator: dividerState selection.

    hasAccelCheckBox selection  ifTrue: [
        accel := WBKeyAccel new keyName: keyShortCutEditor text.
        accel isAlt: isAlt selection.
        accel isShift: isShift selection.
        accel isCtrl: isCtrl selection.
        item accelerator: accel.
     ] ifFalse: [
        item accelerator: nil.
    ].

    selectorEditor contents trimBlanks notEmpty ifTrue: [
        (selectorEditor contents first == $<) ifFalse: [
            item selector: selectorEditor contents trimBlanks asSymbol.
        ].
    ] ifFalse: [
         item selector: nil.
    ].! !

"WB Dev Parts (WB2ADPW.SLL)"!
!'WBPARTSInterfaceEditor' osiMethods: 'WBPARTSInterfaceEditor' !  
createViews

        "WARNING!! This method was automatically generated by 
        WindowBuilder. Code you add here which does not conform to 
        the WindowBuilder API will probably be lost the next time 
        you save your layout definition."

    | mainView staticText1 staticText2 |
    
    mainView := self topPaneClass new.
    
        "Instance Variables"
    closeButton := Button new.
    eventsRadioButton := RadioButton new.
    itemFilterPane := WBComboBox new.
    itemListPane := ListBox new.
    messagesRadioButton := RadioButton new.
    saveButton := Button new.
    selectorFilterPane := WBComboBox new.
    selectorListPane := ListBox new.
    sourceSelectorPane := EntryField new.
    targetSelectorPane := EntryField new.
    
        "Temporary Variables"
    staticText1 := StaticText new.
    staticText2 := StaticText new.
    
    mainView "WBPARTSInterfaceEditor"
        owner: self;
        paneName: 'mainView';
        labelWithoutPrefix:  'WB-PARTS Interface';
        backColor: Color paleGray;
        noSmalltalkMenuBar;
        framingBlock: ( FramingParameters new iDUE: 1051 @ 504; xC; yC; cRDU: (9 @ 46 rightBottom: 1042 @ 496));
        pStyle: #(sysmenu sizable titlebar minimize maximize);
        when: #aboutToClose send: #aboutToClose to: self.
    self addView: mainView.
    
    eventsRadioButton "RadioButton"
        owner: self;
        paneName: 'eventsRadioButton';
        framingBlock: ( FramingParameters new iDUE: 283 @ 40; lDU: 18 r: #left; rP: 33/113; tDU: 8 r: #top; bDU: 48 r: #top);
        startGroup;
        tabStop;
        when: #clicked: send: #eventsSelected: to: self;
        contents: 'Events'.
    mainView addSubpane: eventsRadioButton.
    
    messagesRadioButton "RadioButton"
        owner: self;
        paneName: 'messagesRadioButton';
        framingBlock: ( FramingParameters new iDUE: 283 @ 40; lDU: 18 r: #left; rP: 33/113; tDU: 48 r: #top; bDU: 88 r: #top);
        when: #clicked: send: #messagesSelected: to: self;
        contents: 'Messages'.
    mainView addSubpane: messagesRadioButton.
    
    itemFilterPane "WBComboBox"
        owner: self;
        paneName: 'itemFilterPane';
        framingBlock: ( FramingParameters new iDUE: 288 @ 296; lDU: 9 r: #left; rP: 65/226; tDU: 96 r: #top; bDU: 392 r: #top);
        dropDownList;
        startGroup;
        tabStop;
        when: #changed: send: #itemFilter: to: self;
        when: #needsContents send: #updateItemFilters to: self.
    mainView addSubpane: itemFilterPane.
    
    itemListPane "ListBox"
        owner: self;
        paneName: 'itemListPane';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 288 @ 290; lDU: 9 r: #left; rP: 65/226; tDU: 152 r: #top; bDU: 8 r: #bottom);
        startGroup;
        tabStop;
        when: #needsContents send: #updateItemList to: self;
        when: #changedIndex: send: #itemSelected: to: self.
    mainView addSubpane: itemListPane.
    
    selectorFilterPane "WBComboBox"
        owner: self;
        paneName: 'selectorFilterPane';
        framingBlock: ( FramingParameters new iDUE: 718 @ 344; lP: 67/226; rDU: 9 r: #right; tDU: 8 r: #top; bDU: 352 r: #top);
        dropDownList;
        startGroup;
        tabStop;
        when: #changed: send: #selectorFilter: to: self;
        when: #needsContents send: #updateSelectorFilters to: self.
    mainView addSubpane: selectorFilterPane.
    
    selectorListPane "ListBox"
        owner: self;
        paneName: 'selectorListPane';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 718 @ 256; lP: 67/226; rDU: 9 r: #right; tDU: 64 r: #top; bDU: 130 r: #bottom);
        ownerDrawFixed;
        startGroup;
        tabStop;
        when: #needsContents send: #updateSelectorList to: self;
        when: #changedIndex: send: #selector: to: self;
        when: #drawItem: send: #drawSelector: to: self;
        when: #drawSelection: send: #drawSelectorReversed: to: self.
    mainView addSubpane: selectorListPane.
    
    sourceSelectorPane "EntryField"
        owner: self;
        paneName: 'sourceSelectorPane';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 421 @ 48; lP: 48/113; rDU: 174 r: #right; tDU: 114 r: #bottom; bDU: 66 r: #bottom; indent: 3 @ 4);
        startGroup;
        tabStop;
        when: #needsContents send: #updateSourceSelector to: self.
    mainView addSubpane: sourceSelectorPane.
    
    targetSelectorPane "EntryField"
        owner: self;
        paneName: 'targetSelectorPane';
        framingBlock: ( FramingParameters new iDUE: 421 @ 48; lP: 48/113; rDU: 174 r: #right; tDU: 58 r: #bottom; bDU: 10 r: #bottom; indent: 3 @ 4);
        startGroup;
        tabStop;
        when: #textChanged: send: #targetSelectorChanged: to: self;
        when: #needsContents send: #updateTargetSelector to: self.
    mainView addSubpane: targetSelectorPane.
    
    saveButton "Button"
        owner: self;
        paneName: 'saveButton';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 142 @ 48; lDU: 155 r: #right; rDU: 14 r: #right; tDU: 114 r: #bottom; bDU: 66 r: #bottom);
        startGroup;
        tabStop;
        when: #clicked send: #save to: self;
        contents: 'Save'.
    mainView addSubpane: saveButton.
    
    closeButton "Button"
        owner: self;
        paneName: 'closeButton';
        framingBlock: ( FramingParameters new iDUE: 142 @ 48; lDU: 155 r: #right; rDU: 14 r: #right; tDU: 58 r: #bottom; bDU: 10 r: #bottom);
        startGroup;
        tabStop;
        when: #clicked send: #cancel to: self;
        contents: 'Close'.
    mainView addSubpane: closeButton.
    
    staticText1
        owner: self;
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 128 @ 32; lP: 33/113; rP: 47/113; tDU: 106 r: #bottom; bDU: 74 r: #bottom);
        rightJustified;
        startGroup;
        contents: 'Export:'.
    mainView addSubpane: staticText1.
    
    staticText2
        owner: self;
        framingBlock: ( FramingParameters new iDUE: 128 @ 32; lP: 33/113; rP: 47/113; tDU: 50 r: #bottom; bDU: 18 r: #bottom);
        rightJustified;
        startGroup;
        contents: 'as:'.
    mainView addSubpane: staticText2! !

"WB Dev Parts (WB2ADPW.SLL)"!
!'WBPARTSInterfaceEditor' osiMethods: 'WBPARTSInterfaceEditor' !  
drawSelector: anIndex

    "Callback for the #drawItem: event triggered in the WBListBox named 'selectorListPane'.
     (Generated by WindowBuilder)"

    self
        drawSelector: anIndex
        foreColor: Color black
        backColor: selectorListPane backColor
        targetColor: Color blue.! !

"WB Dev Parts (WB2ADPW.SLL)"!
!'WBPARTSInterfaceEditor' osiMethods: 'WBPARTSInterfaceEditor' !  
drawSelector: anIndex foreColor: fColor backColor: bColor targetColor: tColor
        "Draw the selector in the WBListBox named 'selectorListPane'."
    | index symbol targetSymbol box textOffset |
    textOffset := 1 @ (Rectangle leftTopUnit y * 4).
    index := selectorListPane drawIndex.
    symbol :=  selectorListPane list at: index.
    box := selectorListPane drawBox.
    selectorListPane ownerDrawPen
        foreColor: fColor;
        backColor: bColor;
        blank: box;
        setTextAlign: TaTop;
        place: (box origin + textOffset);
        displayText: symbol.
    ((targetSymbol := self showEvents
        ifTrue: [ self eventTargetFor: symbol pane: self itemSelected ]
        ifFalse: [ self messageTargetFor: symbol pane: self itemSelected ]
    ) isString and: [ targetSymbol notEmpty ]) ifTrue: [
        selectorListPane ownerDrawPen
            foreColor: tColor;
            backColor: bColor;
            blank: ((box leftTop right: box width // 2 - 15) rightBottom: box rightBottom) ;
            place: (box origin rightAndUp: (box width // 2 @ 0) + textOffset);
            displayText: targetSymbol ].! !

"WB Dev Parts (WB2ADPW.SLL)"!
!'WBPARTSInterfaceEditor' osiMethods: 'WBPARTSInterfaceEditor' !  
drawSelectorReversed: anIndex

    "Callback for the #drawSelection: event triggered in the WBListBox named 'selectorListPane'.
     (Generated by WindowBuilder)"

    self
        drawSelector: anIndex
        foreColor: Color white
        backColor: Color black
        targetColor: Color red.! !

"WB Dev Parts (WB2ADPW.SLL)"!
!'WBPARTSInterfaceEditor' osiMethods: 'WBPARTSInterfaceEditor' !  
itemSelected: anIntegerOrObjectOrNil

    "Callback for the #changedIndex: event triggered in the ListBox named 'itemListPane'.
     (Generated by WindowBuilder)"

    | newItemSelected |
    (newItemSelected := anIntegerOrObjectOrNil) isInteger ifTrue: [
        newItemSelected := items at: anIntegerOrObjectOrNil ].
    itemSelected == newItemSelected ifFalse: [
        itemSelected := newItemSelected.
        self updateSelectorFilters.
        self updateSelectorList: true ].! !

"WB Dev Parts (WB2ADPW.SLL)"!
!'WBPARTSInterfaceEditor' osiMethods: 'WBPARTSInterfaceEditor' !  
preInitWindow
        "Private - Initialize the receiver."
    super preInitWindow.
    itemFilterPane addDynamicListSizeStyle.
    selectorFilterPane addDynamicListSizeStyle.
    Smalltalk platformIsOS2 ifTrue: [
        selectorListPane backColor: Color entryFieldBackground ].
    wbEventList := self editedCoordinator wbPartEvents fullCopy.
    wbMessageList := self editedCoordinator wbPartMessages fullCopy.
    showEvents := true.
    eventsRadioButton selection: true.
    saveButton disable.! !

"WB Dev Parts (WB2ADPW.SLL)"!
!'WBPARTSInterfaceEditor' osiMethods: 'WBPARTSInterfaceEditor' !  
updateSelectorList

    "Callback for the #needsContents event triggered in the ListBox named 'selectorListPane'.
     (Generated by WindowBuilder)"

    self updateSelectorList: false.! !

"WB Dev Parts (WB2ADPW.SLL)"!
!'WBPARTSInterfaceEditor' osiMethods: 'WBPARTSInterfaceEditor' !  
updateSelectorList: aBoolean

    "Callback for the #needsContents event triggered in the ListBox named 'selectorListPane'.
     (Generated by WindowBuilder)"
    "If aBoolean, then force a repaint."

    | sel newSelectors |
    newSelectors := self showEvents
        ifTrue: [ self eventSelectors ]
        ifFalse: [ self messageSelectors ].
    selectors = newSelectors & aBoolean not ifFalse: [
        selectorListPane
            contents: (selectors := newSelectors);
            hideWindow;	"<---------- Force a repaint this way."
            showWindow ].
    sel := (selectors includes: self selector)
        ifTrue: [ self selector ] ifFalse: [ nil ].
    selectorListPane selection: sel.
    self selector: sel.
    self updateTargetSelector.! !

"WB Dev Parts (WB2ADPW.SLL)"!
!'WBPartsModule' osiMethods: 'WBPARTSInterfaceEditor' !  
defaultShouldLogMethodSource
        "Answer true if the receiver's source should be logged."
    ^super defaultShouldLogMethodSource
        and: [ PWindowBuilder licensed ]! !

"WB Dev Parts (WB2ADPW.SLL)"!
!'WBPartsModule class' osiMethods: 'WBPARTSInterfaceEditor' !  
codeModulesFor: anObject
        "Answer a collection of code modules for anObject."
    PWindowBuilder partsSupportEnabled ifFalse: [ ^#( ) ].
    ^(Array
        with: WBPartEventsModule
        with: WBPartMessagesModule
        with: WBPartEventsTriggeredModule
            ) collect: [ :each | each new ]! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBPMenuItem' osiMethods: 'WindowBuilder' !  
storeOn: aStream indentString: indentString

    | spaceString |

    spaceString := indentString.
    aStream nextPutAll: spaceString, 'Menu new'; cr.

    spaceString := spaceString, '    '.

    aStream nextPutAll: spaceString, 'title: '; nextPutStringConstant: self title.
    aStream nextPutAll: ';'; cr; nextPutAll: spaceString, 'owner: ',(aStream owner varNameFor: #owner).
    (self realSelector notNil and: [self realSelector isString]) ifTrue: [
        aStream nextPutAll: ';'; cr; nextPutAll: spaceString, 'selector: #'.
        self realSelector printOn: aStream.
    ].
    children do: [ :c |
        c isLeaf ifTrue: [
            c isSeparator ifTrue: [
                aStream nextPutAll: ';'; cr; nextPutAll: spaceString, 'appendSeparator'.
            ] ifFalse: [
                aStream nextPutAll: ';'; cr; nextPutAll: spaceString, 'appendItem: ';
                    nextPutStringConstant: c fullTitle.
                "Support for link menus"
                c action notNil ifTrue: [
                    aStream nextPutAll:  ' action: #', c action
                ] ifFalse: [ c link isNil ifTrue: [
                    aStream nextPutAll:  ' selector: '.
                    (c realSelector notNil) ifTrue: [
                        aStream nextPut: $#.
                        #osiHack.
                        "In the future, spin off method stubs here...
                        aStream addModule: (
                            WBMenuItemStub new
                                messageSelector: c realSelector;
                                title: self fullTitle;
                                yourself )."
                    ].
                    c realSelector printOn: aStream.
                ] ifFalse: [
                    aStream nextPutAll:  ' link: #',c link,' type: #',c type
                ]].
                c accelerator notNil ifTrue: [
                    aStream nextPutAll: ' acceleratorString: '.
                    c accelerator printAccelOn: aStream.
                ].
            ].
        ] ifFalse: [
            aStream nextPutAll: ';'; cr; nextPutAll: spaceString, 'appendSubMenu: ('; cr.
            c storeOn: aStream indentString: spaceString, '    '.
            aStream cr; nextPutAll: spaceString,  ')'.
        ].
    ].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBRealLayoutPane' osiMethods: 'WindowBuilder' !  
convertView: view realClass: aViewClass

    | stayingToBack theChildren viewExtent newView newChildren
      newChild lastNonGroupTabPos lastGroupTabPos wbVer validTargets |

    validTargets := self validTargets.
    wbVer := (view owner ifNil: [view]) class wbVersion.
    newView := WindowFrameObject newForClass: aViewClass.
    newView realClass: aViewClass.
    newView isCompositePane
        ifTrue: [validTargets at: view put: #self]
        ifFalse: [validTargets at: view put: newView].

    view framingBlock notNil
        ifTrue: [viewExtent := (view framingBlock value: Display boundingBox) extent]
        ifFalse: [
            (view respondsTo: #initWindowSize)
                ifTrue: [viewExtent := view initWindowSize]
                ifFalse: [viewExtent := view topPaneClass basicNew initWindowSize].
            (view isKindOf: WindowDialog)
                ifTrue: [viewExtent := viewExtent // WindowDialog dialogUnit]].

    newView
        framingBlock: view framingBlock;
        handlers: view handlers;
        extent: viewExtent;
        contents: view label;
        style: view pStyle.
    [ newView createdBy: view createdBy ] on: Error do: [ ].
    [ newView modifiedBy: view modifiedBy ] on: Error do: [ ].
    [ newView iconFile: view iconFile ] on: Error do: [ ].

    view backColor notNil
        ifTrue: [newView backColor: view backColor].
    newView paneName:
        (view paneName notNil
            ifTrue: [view paneName]
            ifFalse: ['mainView']).
    newView style isNil
        ifTrue: [newView style: newView defaultStyle].

    newView menu:
        (view menuWindow menus notEmpty
            ifTrue: [view menuWindow asWBPMenuBar]
            ifFalse: [nil]).

    "Needed to have children represented as OrderedCollection,
      since ordering relevant.  Digitalk stores them as an identity dictionary,
      which loses ordering."
    newChildren := OrderedCollection new.
    theChildren := view childrenInBuildOrder reject: [:child | child isMDIClient].
    stayingToBack := OrderedCollection new.
    lastNonGroupTabPos := WBTabPosition new.
    lastGroupTabPos := lastNonGroupTabPos.

    theChildren do: [:child |
        newChild :=  self convertChild: child inView: newView.
        validTargets at: child put: newChild.
        (self child: child isInstVarIn: (view owner ifNil: [view]))
            ifTrue: [newChild isInstVar: true].
        child isAGroupLeader
            ifTrue: [
                child isATabStopPrim
                    ifTrue: [
                        newChild tabPosition: lastNonGroupTabPos nextBasicTabPosition.
                        lastNonGroupTabPos := newChild tabPosition.
                        lastGroupTabPos := lastNonGroupTabPos]]
            ifFalse: [
                lastGroupTabPos notNil
                    ifTrue: [
                        lastGroupTabPos withinGroup
                            ifFalse: [lastGroupTabPos makeFirstInGroup].
                        newChild tabPosition: lastGroupTabPos nextTabPosition.
                        lastGroupTabPos := newChild tabPosition]].
        #osiHack.
        "Keep this for old version support
            but disable it for new version windows?"
        (newChild staysToBack and: [wbVer = 1.0])
            ifTrue: [stayingToBack addLast: newChild]
            ifFalse: [newChildren addLast: newChild]].
    newView children: (newChildren addAllLast: stayingToBack; yourself).

    theChildren do: [:child |
        (validTargets at: child)
            eventHandlers: child eventTable
            view: child
            targets: validTargets].
    newView
        eventHandlers: view eventTable
        view: view
        targets: validTargets.
    (views isNil or: [view == (views at: views size)])
        ifTrue: [
            self validTargets: (validTargets values asArray select: [:val |
                val isSymbol and: [val ~~ #self]])].

    ^newView! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBRealLayoutPane' osiMethods: 'WindowBuilder' !  
editClass: aViewClass

    | holdEditedPane tempInstance oldOpenWindow oldOpenModeless
    openMethodType numArgs args isAC useAll avoidName |

    self outmostWindow hideWindow.
    useAll := true.
    (isAC := aViewClass inheritsFrom: ApplicationCoordinator)
        ifTrue: [
            openMethodType := #buildView:forModel:.
            avoidName := 'handlers']
        ifFalse: [
            (aViewClass inheritsFrom: CompositePane)
                ifTrue: [
                    openMethodType := #addSubpanes.
                    useAll := false]
                ifFalse: [
                    openMethodType := PWindowBuilder openMethodType.
                    avoidName := 'views']].

    openMethodType notNil
        ifTrue: [
            self propertyAt: #keepOpenMethod put: (aViewClass includesSelector: #open).
            tempInstance := aViewClass new.
            self initializeInstVarsFor: tempInstance useAll: useAll avoiding: avoidName.
            isAC
                ifTrue: [views := Array with: (tempInstance class constructViewFor: tempInstance)]
                ifFalse: [
                    numArgs := openMethodType occurrencesOf: $:.
                    args := (Array new: numArgs) atAllPut: tempInstance.
                    tempInstance wbPreOldVersionSupport.
                    tempInstance := tempInstance perform: openMethodType withArguments: args.
                    self wbPreOldVersionSupport.
                    tempInstance wbOldVersionSupport]].

    tempInstance isNil
        ifTrue: [
            self propertyAt: #keepOpenMethod put: nil.
            oldOpenWindow := aViewClass sourceCodeAt: #openWindow.
            PWindowBuilder createMethod: '' titled: 'openWindow' in: aViewClass loggingSource: false.
            oldOpenModeless := aViewClass sourceCodeAt: #openModeless.
            PWindowBuilder createMethod: '' titled: 'openModeless' in: aViewClass loggingSource: false.
            tempInstance := aViewClass new.
            self initializeInstVarsFor: tempInstance useAll: useAll avoiding: avoidName.
            [tempInstance open] ensure: [
                oldOpenWindow == #openWindow
                    ifFalse: [PWindowBuilder createMethod: oldOpenWindow titled: '' in: aViewClass loggingSource: true]
                    ifTrue: [aViewClass removeSelector: #openWindow].
                oldOpenModeless == #openModeless
                    ifFalse: [PWindowBuilder createMethod: oldOpenModeless titled: '' in: aViewClass loggingSource: true]
                    ifTrue: [aViewClass removeSelector: #openModeless]]].
    tempInstance isNil ifTrue: [^nil].

    isAC ifFalse: [views := tempInstance views].
    self validTargets: Dictionary new.
    self validIVarTargetsFor: tempInstance avoiding: avoidName.

    views := (views collect: [:view |
        self convertView: view realClass: (aViewClass isScratchWindow
            ifTrue: [aViewClass defaultClass]
            ifFalse: [aViewClass])]) reject: [:vi | vi isNil].
    self propertyAt: #tempInstance put: nil.

    views first nlsPools: (aViewClass sharedPools select: [:sym |
        (Smalltalk at: sym) isValidNLSDictionary]).

    "PARTS Support"
    PWindowBuilder partsSupportIsInstalled
        ifTrue: [
            self wbPartEvents:
                (tempInstance wbPartEvents
                    updatePanes: views;
                    updateReceiver: self;
                    yourself).
            self wbPartMessages:
                (tempInstance wbPartMessages
                    updatePanes: views;
                    updateSource: self;
                    yourself)].

    holdEditedPane := editedPane.
    views do: [:view |
        view == views first
            ifFalse: [
                view nlsPools: views first nlsPools.
                editedPane := view.
                view children do: [ :pane | pane reframe: self editedPaneContentRect]]].

    self switchToView: views first.

    ^views first! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBRGBColorDialog' osiMethods: 'WindowBuilder' !  
createViews

        "WARNING!! This method was automatically generated by
        WindowBuilder. Code you add here which does not conform to
        the WindowBuilder API will probably be lost the next time
        you save your layout definition."

    | backColorLabel blue blueLabel cancel chooseRGBColor color
    colorList elementsLabel elementsList green greenLabel
    mainView ok red redLabel |

    mainView := self topPaneClass new.

        "Temporary Variables"
    backColorLabel := StaticText new.
    blue := WBEntryField new.
    blueLabel := StaticText new.
    cancel := Button new.
    chooseRGBColor := Button new.
    color := StaticText new.
    colorList := WBListBox new.
    elementsLabel := StaticText new.
    elementsList := WBListBox new.
    green := WBEntryField new.
    greenLabel := StaticText new.
    ok := Button new.
    red := WBEntryField new.
    redLabel := StaticText new.

    mainView "WBRGBColorDialog"
        owner: self;
        paneName: 'mainView';
        labelWithoutPrefix:  'Set Pane Colors';
        noSmalltalkMenuBar;
        framingBlock: ( FramingParameters new iDUE: 855 @ 468; xC; yC; cRDU: (0 @ 0 rightBottom: 855 @ 468));
        pStyle: #(sysmenu modal titlebar).
    self addView: mainView.

    elementsList "WBListBox"
        owner: self;
        paneName: 'elementsList';
        framingBlock: ( FramingParameters new iDUE: 402 @ 168; lDU: 18 r: #left; rDU: 421 r: #left; tDU: 48 r: #top; bDU: 216 r: #top);
        startGroup;
        tabStop;
        when: #clicked: send: #elementSelected: to: self.
    mainView addSubpane: elementsList.

    colorList "WBListBox"
        owner: self;
        paneName: 'colorList';
        framingBlock: ( FramingParameters new iDUE: 402 @ 336; lDU: 439 r: #left; rDU: 841 r: #left; tDU: 48 r: #top; bDU: 384 r: #top);
        ownerDrawFixed;
        startGroup;
        tabStop;
        when: #clicked: send: #colorSelected: to: self;
        when: #drawSelection: send: #highlightItem:pane: to: self withArgument: colorList;
        when: #drawItem: send: #drawItem:pane: to: self withArgument: colorList.
    mainView addSubpane: colorList.

    red "WBEntryField"
        owner: self;
        paneName: 'red';
        framingBlock: ( FramingParameters new iDUE: 110 @ 48; lDU: 137 r: #left; rDU: 247 r: #left; tDU: 224 r: #top; bDU: 272 r: #top; indent: 3 @ 4);
        startGroup;
        tabStop;
        when: #textChanged: send: #rgbChanged: to: self.
    mainView addSubpane: red.

    green "WBEntryField"
        owner: self;
        paneName: 'green';
        framingBlock: ( FramingParameters new iDUE: 110 @ 48; lDU: 137 r: #left; rDU: 247 r: #left; tDU: 280 r: #top; bDU: 328 r: #top; indent: 3 @ 4);
        startGroup;
        tabStop;
        when: #textChanged: send: #rgbChanged: to: self.
    mainView addSubpane: green.

    blue "WBEntryField"
        owner: self;
        paneName: 'blue';
        framingBlock: ( FramingParameters new iDUE: 110 @ 48; lDU: 137 r: #left; rDU: 247 r: #left; tDU: 336 r: #top; bDU: 384 r: #top; indent: 3 @ 4);
        startGroup;
        tabStop;
        when: #textChanged: send: #rgbChanged: to: self.
    mainView addSubpane: blue.

    chooseRGBColor "Button"
        owner: self;
        paneName: 'chooseRGBColor';
        framingBlock: ( FramingParameters new iDUE: 402 @ 64; lDU: 18 r: #left; rDU: 421 r: #left; tDU: 392 r: #top; bDU: 456 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #chooseRGBColor to: self;
        contents: 'Choose RGB Color...'.
    mainView addSubpane: chooseRGBColor.

    ok "Button"
        owner: self;
        paneName: 'ok';
        framingBlock: ( FramingParameters new iDUE: 192 @ 64; lDU: 439 r: #left; rDU: 631 r: #left; tDU: 392 r: #top; bDU: 456 r: #top);
        defaultPushButton;
        startGroup;
        tabStop;
        when: #clicked send: #ok to: self;
        contents: '&OK'.
    mainView addSubpane: ok.

    cancel "Button"
        owner: self;
        paneName: 'cancel';
        framingBlock: ( FramingParameters new iDUE: 192 @ 64; lDU: 649 r: #left; rDU: 841 r: #left; tDU: 392 r: #top; bDU: 456 r: #top);
        cancelPushButton;
        startGroup;
        tabStop;
        when: #clicked send: #cancel to: self;
        contents: '&Cancel'.
    mainView addSubpane: cancel.

    color "StaticText"
        owner: self;
        paneName: 'color';
        framingBlock: ( FramingParameters new iDUE: 155 @ 160; lDU: 265 r: #left; rDU: 421 r: #left; tDU: 224 r: #top; bDU: 384 r: #top);
        startGroup.
    mainView addSubpane: color.

    blueLabel "StaticText"
        owner: self;
        paneName: 'blueLabel';
        framingBlock: ( FramingParameters new iDUE: 110 @ 32; lDU: 18 r: #left; rDU: 128 r: #left; tDU: 344 r: #top; bDU: 376 r: #top);
        rightJustified;
        startGroup;
        contents: 'Blue:'.
    mainView addSubpane: blueLabel.

    greenLabel "StaticText"
        owner: self;
        paneName: 'greenLabel';
        framingBlock: ( FramingParameters new iDUE: 110 @ 32; lDU: 18 r: #left; rDU: 128 r: #left; tDU: 288 r: #top; bDU: 320 r: #top);
        rightJustified;
        startGroup;
        contents: 'Green:'.
    mainView addSubpane: greenLabel.

    redLabel "StaticText"
        owner: self;
        paneName: 'redLabel';
        framingBlock: ( FramingParameters new iDUE: 110 @ 32; lDU: 18 r: #left; rDU: 128 r: #left; tDU: 232 r: #top; bDU: 264 r: #top);
        rightJustified;
        startGroup;
        contents: 'Red:'.
    mainView addSubpane: redLabel.

    elementsLabel "StaticText"
        owner: self;
        paneName: 'elementsLabel';
        framingBlock: ( FramingParameters new iDUE: 402 @ 32; lDU: 18 r: #left; rDU: 421 r: #left; tDU: 8 r: #top; bDU: 40 r: #top);
        startGroup;
        contents: 'Elements:'.
    mainView addSubpane: elementsLabel.

    backColorLabel "StaticText"
        owner: self;
        paneName: 'backColorLabel';
        framingBlock: ( FramingParameters new iDUE: 393 @ 32; lDU: 439 r: #left; rDU: 832 r: #left; tDU: 8 r: #top; bDU: 40 r: #top);
        startGroup;
        contents: 'Color:'.
    mainView addSubpane: backColorLabel! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBRGBColorDialog' osiMethods: 'WindowBuilder' !  
drawItem: index pane: aPane

    | color string |

    (string := tempColors at: index) = #default
        ifTrue: [ color :=  defaults at: self selectedElement ifAbsent: [ Color black ] ]
        ifFalse: [ color := Color perform: string ].

    aPane pen
        fill: aPane drawBox color: Color white;
        fill: (
            (aPane drawBox leftTop extentFromLeftTop:
                self colorBarWidth @ aPane drawBox height
                    ) insetBy: 1) color: color;
        setTextAlign: TaTop;
        font: ListFont;
        displayText: string at: (
            aPane drawBox leftTop rightAndDown: (
                (self colorBarWidth + 5)
                    @ ((aPane drawBox height - 2) * Rectangle leftTopUnit y) ) )! !

"WB Dev Base Common"!
!'WBRGBColorDialog' osiMethods !  
fillColorPaneWith: anRGBColor

    | colorPane |
    (colorPane := (self paneNamed: 'color'))
        doGraphics: [
            colorPane pen isNil
                ifFalse: [
                    colorPane pen fill: colorPane rectangle color: anRGBColor]]! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBRGBColorDialog' osiMethods: 'WindowBuilder' !  
initWindow

    | keys indexedColor rgbColor |

    defaults associationsDo: [:assoc |
        indexedColor := assoc value asIndexedColor.
        indexedColor index = 7 ifTrue: [indexedColor := Color black]. "Black"
        indexedColor index = 0 ifTrue: [indexedColor := Color white]. "White"
        rgbColor := [indexedColor asRGBColor]
            on: Error
            do: [RGBColor fromInteger: indexedColor asInteger].
        rgbColor = assoc value
            ifTrue: [defaults at: assoc key put: indexedColor]].
    elements associationsDo: [:assoc |
        indexedColor := assoc value asIndexedColor.
        rgbColor := [indexedColor asRGBColor]
            on: Error
            do: [RGBColor fromInteger: indexedColor asInteger].
        rgbColor = assoc value
            ifTrue: [elements at: assoc key put: indexedColor]].

    colors := Color defaultColorClass defaultColors
        keys asSortedCollection asOrderedCollection.
    colors addFirst: #default.

    (self paneNamed: 'elementsList')
        contents: (keys := elements keys asSortedCollection);
        selectItem: keys first.

    (self paneNamed: 'colorList') contents: colors.
    self elementSelected: keys first.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBRGBColorDialog' osiMethods: 'WindowBuilder' !  
updateColorList: selectedItem

    | color theColor defaultColor |
    (theColor := elements at: selectedItem) = (defaults at: selectedItem)
        ifTrue: [color := #default]
        ifFalse: [
            color := theColor isRGBColor
                ifTrue: [nil]
                ifFalse: [
                    Color defaultColorClass defaultColors
                        keyAtValue: theColor
                        ifAbsent: [#default]]].

    defaultColor := Color defaultColorClass defaultColors
        keyAtValue: (defaults at: selectedItem)
        ifAbsent: [nil].

    (self paneNamed: 'colorList')
        contents: (tempColors := colors reject: [:sym | sym = defaultColor]);
        selection: color.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBScrapbookRetrieve' osiMethods: 'WindowBuilder' !  
displayImage: aPane

    | aPen aPage mergeRect centerPoint offset |
    aPane doGraphics: [
        aPane
            backColor: aPane class defaultBackColor;
            erase].
    chapter isNil | page isNil ifTrue: [^nil].
    aPage := (scrapbook at: self owner chapter) at: page.
    centerPoint := aPane rectangle center.
    mergeRect := aPage first first rect.
    aPage first do: [:pObject | mergeRect := mergeRect merge: pObject rect].
    offset := centerPoint leftAndUp: mergeRect center.
    aPage first do: [:pObject | pObject rect moveBy: offset].
    aPane doGraphics: [
        aPage first do: [:pObject |
            aPane
                backColor: aPane class defaultBackColor;
                foreColor: aPane class defaultForeColor.
            pObject isNil
                ifFalse: [
                    pObject isCompositePane ifTrue: [pObject realClass: pObject realClass].
                    pObject displayWith: aPane pen clipRect: aPane rectangle]]].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBStaticTextEditor' osiMethods: 'WindowBuilder' !  
ok
    | contents |
    contents := (self paneNamed: 'text') contents.
    thePane
        "contents:  (contents copyFrom: 1 to: contents size - 2)."
        contents: contents.

    self close! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBTabEditor' osiMethods: 'WindowBuilder' !  
cancel

    panes size to: 1 by: -1 do: [ :index |
        (panes at: index) isGrouper ifTrue: [
            panes removeIndex: index ] ].
    panes do: [:pane | pane tabPosition: (pane propertyAt: #oldTabPosition)].
    result := nil.
    self close! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBTabEditor' osiMethods: 'WindowBuilder' !  
createViews

        "WARNING!! This method was automatically generated by 
        WindowBuilder. Code you add here which does not conform to 
        the WindowBuilder API will probably be lost the next time 
        you save your layout definition."

    | cancelButton mainView scrollingPane |
    
    mainView := self topPaneClass new.
    
        "Instance Variables"
    addGroupButton := Button new.
    okButton := Button new.
    removeGroupButton := Button new.
    setTabbingButton := Button new.
    statusLine := StaticText new.
    
        "Temporary Variables"
    cancelButton := Button new.
    scrollingPane := WBScrollingPane new.
    
    mainView
        owner: self;
        paneName: 'mainView';
        labelWithoutPrefix: 'Tab Order Editor';
        noSmalltalkMenuBar;
        pStyle: #(sysmenu titlebar modal);
        framingBlock:
            (FramingParameters new
                iDUE: 1333 @ 852;
                xC; yC; cRDU: (11 @ 808 rightBottom: 1323 @ 8));
        backColor: Color paleGray.
    self addView: mainView.
    
    setTabbingButton "Button"
        owner: self;
        paneName: 'setTabbingButton';
        when: #clicked send: #setTabbingOrder to: self;
        framingBlock:
            (FramingParameters new
                iDUE: 413 @ 68;
                lDU: 19 r: #left; rDU: 432 r: #left;
                tDU: 642 r: #top; bDU: 710 r: #top);
        contents: '~Set tabbing order';
        startGroup;
        tabStop.
    mainView addSubpane: setTabbingButton.
    
    addGroupButton "Button"
        owner: self;
        paneName: 'addGroupButton';
        when: #clicked send: #addTabGroup to: self;
        framingBlock:
            (FramingParameters new
                iDUE: 413 @ 68;
                lDU: 448 r: #left; rDU: 861 r: #left;
                tDU: 642 r: #top; bDU: 710 r: #top);
        contents: '~Add group';
        startGroup;
        tabStop.
    mainView addSubpane: addGroupButton.
    
    removeGroupButton "Button"
        owner: self;
        paneName: 'removeGroupButton';
        when: #clicked send: #removeTabGroup to: self;
        framingBlock:
            (FramingParameters new
                iDUE: 413 @ 68;
                lDU: 877 r: #left; rDU: 1291 r: #left;
                tDU: 642 r: #top; bDU: 710 r: #top);
        contents: '~Remove group';
        startGroup;
        tabStop.
    mainView addSubpane: removeGroupButton.
    
    okButton "Button"
        owner: self;
        paneName: 'okButton';
        when: #clicked send: #ok to: self;
        framingBlock:
            (FramingParameters new
                iDUE: 200 @ 56;
                lDU: 19 r: #left; rDU: 219 r: #left;
                tDU: 730 r: #top; bDU: 786 r: #top);
        defaultPushButton;
        contents: '~OK';
        startGroup;
        tabStop.
    mainView addSubpane: okButton.
    
    cancelButton "Button"
        owner: self;
        paneName: 'cancelButton';
        when: #clicked send: #cancel to: self;
        framingBlock:
            (FramingParameters new
                iDUE: 200 @ 56;
                lDU: 229 r: #left; rDU: 429 r: #left;
                tDU: 730 r: #top; bDU: 786 r: #top);
        cancelPushButton;
        contents: '~Cancel';
        startGroup;
        tabStop.
    mainView addSubpane: cancelButton.
    
    statusLine "StaticText"
        owner: self;
        paneName: 'statusLine';
        framingBlock:
            (FramingParameters new
                iDUE: 840 @ 48;
                lDU: 448 r: #left; rDU: 1288 r: #left;
                tDU: 738 r: #top; bDU: 786 r: #top);
        contents: 'StaticText';
        startGroup.
    mainView addSubpane: statusLine.
    
    scrollingPane "WBScrollingPane"
        owner: self;
        paneName: 'scrollingPane';
        framingBlock:
            (FramingParameters new
                iDUE: 1272 @ 610;
                lDU: 19 r: #left; rDU: 1291 r: #left;
                tDU: 14 r: #top; bDU: 624 r: #top);
        foreColor: Color white;
        startGroup.
    mainView addSubpane: scrollingPane! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBTabEditor' osiMethods: 'WindowBuilder' !  
initWindow

    | scroller |
    (scroller := self paneNamed: 'scrollingPane')
        resize: self mainView rectangle.

    statusLine contents: ''.
    panes isEmpty
        ifTrue: [
            setTabbingButton disable.
            addGroupButton sendInputEvent: #setFocus]
        ifFalse: [
            panes do: [:pane | pane propertyAt: #oldTabPosition put: pane tabPosition].
            setTabbingButton sendInputEvent: #setFocus].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBTabEditor' osiMethods: 'WindowBuilder' !  
preInitWindow

    (self paneNamed: 'scrollingPane') addSubpane: self newLayoutPane.
    layoutPane editedPane: editedPane subpanes: panes.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBTabOrderLayoutPane' osiMethods: 'WindowBuilder' !  
display

    | savedFont |
    super display.
    savedFont := self font.
    self pen down.
    panes do: [ :pane | self displayTabPositionFor: pane].
    self pen font: savedFont.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBTabOrderLayoutPane' osiMethods: 'WindowBuilder' !  
editedPaneFrameLeftTop

    ^self extent * Rectangle leftTopUnit rightAndDown: self margin! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBTabOrderLayoutPane' osiMethods: 'WindowBuilder' !  
importPanes: paneList

   ^paneList! !

"WB Dev Code Gen (WB2ADEVW.SLL)"!
!'WBTeamVCodePolicy' osiMethods: 'WindowBuilder' !  
basicCompileMethodFor: aCodeModule
        "Private - Compile and store the method."
    aCodeModule shouldLogMethodSource ifFalse: [
        ^aCodeModule targetClass compile: aCodeModule sourceString ].
    (((self packageFor: aCodeModule)
        addMethodInClassNamed: aCodeModule targetClass instanceClass symbol
        meta: aCodeModule targetClass isMetaClass
        sourceString: aCodeModule sourceString
        notifying: nil) ifNil: [^self])
            annotationNamed: self categoriesLabel
                put: (self categoryFor: aCodeModule);
            annotationNamed: self versionLabel
                put: (self versionFor: aCodeModule).! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBToolBarEditor' osiMethods: 'WindowBuilder' !  
createViews

        " WARNING!! This method was automatically generated by
        WindowBuilder. Code you add here which does not conform to
        the WindowBuilder API will probably be lost the next time
        you save your layout definition."

    | bitmapLabel bitmaps buttonGroup buttons buttonsGroup
    cancel cellSize cellSizeLabel copy default down editBitmaps
    help insert leftButtonLabel mainView numSpaces
    numSpacesLabel ok paste rbSelector remove rightButtonLabel
    selector selectorGroup system up vertical |

    mainView := self topPaneClass new.

        " Temporary Variables"
    bitmapLabel := StaticText new.
    bitmaps := WBComboBox new.
    buttonGroup := GroupBox new.
    buttons := WBListBox new.
    buttonsGroup := GroupBox new.
    cancel := Button new.
    cellSize := WBEntryField new.
    cellSizeLabel := StaticText new.
    copy := Button new.
    default := CheckBox new.
    down := Button new.
    editBitmaps := Button new.
    help := Button new.
    insert := Button new.
    leftButtonLabel := StaticText new.
    numSpaces := WBEntryField new.
    numSpacesLabel := StaticText new.
    ok := Button new.
    paste := Button new.
    rbSelector := WBEntryField new.
    remove := Button new.
    rightButtonLabel := StaticText new.
    selector := WBEntryField new.
    selectorGroup := GroupBox new.
    system := CheckBox new.
    up := Button new.
    vertical := CheckBox new.

    mainView "WBToolBarEditor"
        owner: self;
        paneName: 'mainView';
        labelWithoutPrefix:  'WBToolBar Attributes';
        noSmalltalkMenuBar;
        framingBlock: ( FramingParameters new iDUE: 1280 @ 496; xC; yC; cRDU: (0 @ 0 rightBottom: 1280 @ 496));
        pStyle: #(sysmenu modal titlebar);
        when: #activated send: #activated to: self.
    self addView: mainView.

    cellSizeLabel "StaticText"
        owner: self;
        paneName: 'cellSizeLabel';
        framingBlock: ( FramingParameters new iDUE: 155 @ 32; lDU: 18 r: #left; rDU: 174 r: #left; tDU: 424 r: #top; bDU: 456 r: #top);
        rightJustified;
        startGroup;
        contents: 'Cell Size:'.
    mainView addSubpane: cellSizeLabel.

    bitmapLabel "StaticText"
        owner: self;
        paneName: 'bitmapLabel';
        framingBlock: ( FramingParameters new iDUE: 128 @ 32; lDU: 731 r: #left; rDU: 859 r: #left; tDU: 64 r: #top; bDU: 96 r: #top);
        rightJustified;
        startGroup;
        contents: 'Bitmap:'.
    mainView addSubpane: bitmapLabel.

    leftButtonLabel "StaticText"
        owner: self;
        paneName: 'leftButtonLabel';
        framingBlock: ( FramingParameters new iDUE: 183 @ 32; lDU: 759 r: #left; rDU: 942 r: #left; tDU: 152 r: #top; bDU: 184 r: #top);
        startGroup;
        contents: 'Left Button:'.
    mainView addSubpane: leftButtonLabel.

    rightButtonLabel "StaticText"
        owner: self;
        paneName: 'rightButtonLabel';
        framingBlock: ( FramingParameters new iDUE: 201 @ 32; lDU: 759 r: #left; rDU: 960 r: #left; tDU: 240 r: #top; bDU: 272 r: #top);
        startGroup;
        contents: 'Right Button:'.
    mainView addSubpane: rightButtonLabel.

    numSpacesLabel "StaticText"
        owner: self;
        paneName: 'numSpacesLabel';
        framingBlock: ( FramingParameters new iDUE: 210 @ 32; lDU: 731 r: #left; rDU: 942 r: #left; tDU: 360 r: #top; bDU: 392 r: #top);
        rightJustified;
        startGroup;
        contents: 'Num Spaces:'.
    mainView addSubpane: numSpacesLabel.

    vertical "CheckBox"
        owner: self;
        paneName: 'vertical';
        framingBlock: ( FramingParameters new iDUE: 155 @ 40; lDU: 1088 r: #left; rDU: 1243 r: #left; tDU: 360 r: #top; bDU: 400 r: #top);
        startGroup;
        contents: 'Vertical'.
    mainView addSubpane: vertical.

    system "CheckBox"
        owner: self;
        paneName: 'system';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 155 @ 40; lDU: 1088 r: #left; rDU: 1243 r: #left; tDU: 360 r: #top; bDU: 400 r: #top);
        startGroup;
        when: #clicked: send: #toggleSystem: to: self;
        contents: 'System'.
    mainView addSubpane: system.

    editBitmaps "Button"
        owner: self;
        paneName: 'editBitmaps';
        framingBlock: ( FramingParameters new iDUE: 238 @ 64; lDU: 722 r: #left; rDU: 960 r: #left; tDU: 424 r: #top; bDU: 488 r: #top);
        startGroup;
        when: #clicked send: #editBitmaps to: self;
        contents: 'Edit Bitmaps'.
    mainView addSubpane: editBitmaps.

    help "Button"
        owner: self;
        paneName: 'help';
        framingBlock: ( FramingParameters new iDUE: 46 @ 48; lDU: 1198 r: #left; rDU: 1243 r: #left; tDU: 56 r: #top; bDU: 104 r: #top);
        startGroup;
        when: #clicked send: #help to: self;
        contents: '?'.
    mainView addSubpane: help.

    buttons "WBListBox"
        owner: self;
        paneName: 'buttons';
        framingBlock: ( FramingParameters new iDUE: 466 @ 352; lDU: 27 r: #left; rDU: 494 r: #left; tDU: 48 r: #top; bDU: 400 r: #top);
        ownerDrawFixed;
        startGroup;
        tabStop;
        when: #drawSelection: send: #highlightItem:pane: to: self withArgument: buttons;
        when: #changedIndex: send: #selectButton: to: self;
        when: #drawItem: send: #drawItem:pane: to: self withArgument: buttons.
    mainView addSubpane: buttons.

    cellSize "WBEntryField"
        owner: self;
        paneName: 'cellSize';
        framingBlock: ( FramingParameters new iDUE: 155 @ 48; lDU: 183 r: #left; rDU: 338 r: #left; tDU: 416 r: #top; bDU: 464 r: #top; indent: 3 @ 4);
        startGroup;
        tabStop;
        when: #textChanged: send: #setCellSize: to: self;
        contents: '25 @ 22'.
    mainView addSubpane: cellSize.

    default "CheckBox"
        owner: self;
        paneName: 'default';
        framingBlock: ( FramingParameters new iDUE: 155 @ 40; lDU: 352 r: #left; rDU: 507 r: #left; tDU: 420 r: #top; bDU: 460 r: #top);
        startGroup;
        tabStop;
        when: #clicked: send: #toggleDefault: to: self;
        contents: 'Default'.
    mainView addSubpane: default.

    insert "Button"
        owner: self;
        paneName: 'insert';
        framingBlock: ( FramingParameters new iDUE: 174 @ 64; lDU: 512 r: #left; rDU: 686 r: #left; tDU: 48 r: #top; bDU: 112 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #insert to: self;
        contents: '&Insert'.
    mainView addSubpane: insert.

    copy "Button"
        owner: self;
        paneName: 'copy';
        framingBlock: ( FramingParameters new iDUE: 174 @ 64; lDU: 512 r: #left; rDU: 686 r: #left; tDU: 120 r: #top; bDU: 184 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #copy to: self;
        contents: '&Copy'.
    mainView addSubpane: copy.

    paste "Button"
        owner: self;
        paneName: 'paste';
        framingBlock: ( FramingParameters new iDUE: 174 @ 64; lDU: 512 r: #left; rDU: 686 r: #left; tDU: 192 r: #top; bDU: 256 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #paste to: self;
        contents: '&Paste'.
    mainView addSubpane: paste.

    up "Button"
        owner: self;
        paneName: 'up';
        framingBlock: ( FramingParameters new iDUE: 174 @ 64; lDU: 512 r: #left; rDU: 686 r: #left; tDU: 264 r: #top; bDU: 328 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #up to: self;
        contents: '&Up'.
    mainView addSubpane: up.

    down "Button"
        owner: self;
        paneName: 'down';
        framingBlock: ( FramingParameters new iDUE: 174 @ 64; lDU: 512 r: #left; rDU: 686 r: #left; tDU: 336 r: #top; bDU: 400 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #down to: self;
        contents: '&Down'.
    mainView addSubpane: down.

    remove "Button"
        owner: self;
        paneName: 'remove';
        framingBlock: ( FramingParameters new iDUE: 174 @ 64; lDU: 512 r: #left; rDU: 686 r: #left; tDU: 408 r: #top; bDU: 472 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #remove to: self;
        contents: '&Remove'.
    mainView addSubpane: remove.

    bitmaps "WBComboBox"
        owner: self;
        paneName: 'bitmaps';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 320 @ 344; lDU: 869 r: #left; rDU: 1189 r: #left; tDU: 56 r: #top; bDU: 400 r: #top);
        dropDownList;
        startGroup;
        tabStop;
        when: #changed: send: #selectBitmap: to: self;
        when: #needsContents send: #getBitmaps: to: self withArgument: bitmaps.
    mainView addSubpane: bitmaps.

    selector "WBEntryField"
        owner: self;
        paneName: 'selector';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 466 @ 48; lDU: 759 r: #left; rDU: 1225 r: #left; tDU: 184 r: #top; bDU: 232 r: #top; indent: 3 @ 4);
        startGroup;
        tabStop;
        when: #textChanged: send: #setSelector: to: self.
    mainView addSubpane: selector.

    rbSelector "WBEntryField"
        owner: self;
        paneName: 'rbSelector';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 466 @ 48; lDU: 759 r: #left; rDU: 1225 r: #left; tDU: 272 r: #top; bDU: 320 r: #top; indent: 3 @ 4);
        startGroup;
        tabStop;
        when: #textChanged: send: #setRBSelector: to: self.
    mainView addSubpane: rbSelector.

    numSpaces "WBEntryField"
        owner: self;
        paneName: 'numSpaces';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 119 @ 48; lDU: 951 r: #left; rDU: 1070 r: #left; tDU: 352 r: #top; bDU: 400 r: #top; indent: 3 @ 4);
        startGroup;
        tabStop;
        when: #textChanged: send: #setNumSpaces: to: self.
    mainView addSubpane: numSpaces.

    ok "Button"
        owner: self;
        paneName: 'ok';
        framingBlock: ( FramingParameters new iDUE: 128 @ 64; lDU: 978 r: #left; rDU: 1106 r: #left; tDU: 424 r: #top; bDU: 488 r: #top);
        defaultPushButton;
        defaultPushButton;
        startGroup;
        tabStop;
        when: #clicked send: #ok to: self;
        contents: '&OK'.
    mainView addSubpane: ok.

    cancel "Button"
        owner: self;
        paneName: 'cancel';
        framingBlock: ( FramingParameters new iDUE: 146 @ 64; lDU: 1115 r: #left; rDU: 1262 r: #left; tDU: 424 r: #top; bDU: 488 r: #top);
        cancelPushButton;
        cancelPushButton;
        startGroup;
        tabStop;
        when: #clicked send: #cancel to: self;
        contents: 'Cancel'.
    mainView addSubpane: cancel.

    buttonsGroup "GroupBox"
        owner: self;
        paneName: 'buttonsGroup';
        framingBlock: ( FramingParameters new iDUE: 695 @ 480; lDU: 9 r: #left; rDU: 704 r: #left; tDU: 8 r: #top; bDU: 488 r: #top);
        startGroup;
        contents: 'Buttons'.
    mainView addSubpane: buttonsGroup.

    selectorGroup "GroupBox"
        owner: self;
        paneName: 'selectorGroup';
        framingBlock: ( FramingParameters new iDUE: 503 @ 224; lDU: 741 r: #left; rDU: 1243 r: #left; tDU: 112 r: #top; bDU: 336 r: #top);
        startGroup;
        contents: 'Selectors'.
    mainView addSubpane: selectorGroup.

    buttonGroup "GroupBox"
        owner: self;
        paneName: 'buttonGroup';
        framingBlock: ( FramingParameters new iDUE: 539 @ 408; lDU: 722 r: #left; rDU: 1262 r: #left; tDU: 8 r: #top; bDU: 416 r: #top);
        startGroup;
        contents: 'Button'.
    mainView addSubpane: buttonGroup! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBToolBarEditor' osiMethods: 'WindowBuilder' !  
drawItem: drawIndex pane: aPane

    | element |

    element := elements at: drawIndex.
    element pen: nil.
    aPane pen
        fill: aPane drawBox color: Color white;
        copy: element pen
        from: element boundingBox
        to: ((aPane drawBox origin + 2) extent: element rectangle extent);
        setTextAlign: TaTop;
        font: SysFont;
        displayText: (element selector asString)
            at: aPane drawBox origin
                + ((element rectangle width + 6)
                    @ (3 * Rectangle leftTopUnit y + 2))! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBToolBarEditor' osiMethods: 'WindowBuilder' !  
highlightItem: drawIndex pane: aPane

    | element |

    element := elements at: drawIndex.
    aPane pen 
        reverse: 
            (Rectangle
                leftTop: (aPane drawBox leftTop + ((element rectangle width + 4) @ 0))
                rightBottom: aPane drawBox rightBottom)! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBToolBarEditor' osiMethods: 'WindowBuilder' !  
initWindow

    Notifier isAltKeyDown
        ifFalse: [(self paneNamed: 'system') hideWindow].

    list contents: (elements collect: [:element |
        (element selector isNil or: [element selector == #nil]) ifTrue: [element selector: ''].
        element selector asString]).

    (self paneNamed: 'system') selection: thePane useSystem.
    (self paneNamed: 'vertical') selection: thePane vertical.
    (self paneNamed: 'cellSize') contents: thePane cellSize asString.
    (self paneNamed: 'paste') disable.

    elements isEmpty
        ifFalse: [
            list selection: 1.
            self sendInputEvent: #selectButton: with: 1]
       ifTrue: [self updateButtons].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBToolBarEditor' osiMethods: 'WindowBuilder' !  
insert

    | index element |
    index := list selection.

    element := WBTool
        bitmap: WBToolPaneExampleSysBitmap
        selector: ''.
    element rectangle: (0@0 extent: thePane cellSize).

    index isNil ifTrue: [
        elements add: element.
        index := elements size.
    ] ifFalse: [
        elements add: element afterIndex: index.
        index := index + 1.
    ].
    list
        contents: (elements collect: [ :element | element selector asString ]);
        selection: index.

    (self paneNamed: 'bitmaps') selectItem: ''.
    (self paneNamed: 'selector') setContents: ''.
    (self paneNamed: 'rbSelector') setContents: ''.
    (self paneNamed: 'numSpaces') setContents: '0'.

    self updateButtons.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBToolBarEditor' osiMethods: 'WindowBuilder' !  
ok

    | rect vertical changed theOwner |

    vertical := (self paneNamed: 'vertical') selection.
    changed := vertical ~~ thePane vertical.
    thePane
        cellSize: self cellSize;
        vertical: vertical.

    elements := elements select: [ :element |
        element bitmapSelector notNil and: [ element bitmapSelector notEmpty ]].
    elements isEmpty ifFalse: [
        elements first rectangle:
            (Rectangle
                origin: (vertical
                    ifTrue: [0 @ (elements first numSpaces - 1
                        + (Rectangle leftTopUnit y *
                            ((elements size - 1) * thePane cellSize y)))]
                    ifFalse: [elements first numSpaces @ 0])
                extent: thePane cellSize).

        2 to: elements size do: [ :i |
            (elements at: i) rectangle: (Rectangle
                origin: (vertical
                    ifTrue: [ ((elements at: i - 1) rectangle) leftBottom down: (elements at: i) numSpaces - 1
                        + (Rectangle leftTopUnit y * thePane cellSize y) ]
                    ifFalse: [ (((elements at: i - 1) rectangle)
                        perform: (
                            Smalltalk platformIsWin32
                                ifTrue: [ #rightTop ]
                                ifFalse: [ #rightBottom ])) right: (elements at: i) numSpaces - 1 ])
                extent: thePane cellSize)
        ].
    ].
    thePane elements: elements.
    thePane useSystem: useSystem.

    changed ifTrue: [
        theOwner := Smalltalk platformIsWin32
            ifTrue: [ self mainView parent owner ]
            ifFalse: [ self mainView pmOwner owner ]
        theOwner
            sendInputEvent: #drawGrid:
            with: theOwner drawGrid ].

    self close! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBToolBarEditor' osiMethods: 'WindowBuilder' !  
setRBSelector: aString

    list selection isNil ifTrue: [ ^self ].
    (elements at: list selection) rbSelector: aString.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBToolBarEditor' osiMethods: 'WindowBuilder' !  
setSelector: aString

    list selection isNil ifTrue: [ ^self ].
    (elements at: list selection) selector: aString.
    list invalidateRect: nil! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WBTopPane' osiMethods: 'WindowBuilder' !  
partOverlappedWindowOS2: aPoint
        "Private - Answer the receiver's sibling window that
          contains aPoint."
    ^nil! !

"WB Dev Base Win32 (WB2ADEVW.SLL)"!
!'WBTreeListBox' osiMethods: 'WindowBuilder' !  
drawItem: aDrawStruct

    "Private - Draw the requested control item."

    | backColor foreColor |

    aDrawStruct itemState & OdsSelected = OdsSelected ifTrue:[
        backColor := Color highlightBackground.
        foreColor := Color highlightText.
    ] ifFalse: [
        backColor := self backColor.
        foreColor := self foreColor.
    ].

    graphicsTool
        fill: self drawBox color:  backColor;
        backColor: backColor;
        foreColor: foreColor;
        setTextAlign: TaTop;
        displayText: (self flatList at: self drawIndex) listString at: self drawBox leftTop.! !

"WB Dev Code Gen (WB2ADEVW.SLL)"!
!'WBVersionCodeModule' osiMethods: 'WindowBuilder' !  
wbVersionString
        "Answer the version string."
    | aStream |
    aStream := WriteStream on: String new.
    PWindowBuilder versionNumber printOn: aStream decimalSeparator: '.'.
    ^aStream contents
! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
add: paneName
    | addPane className message |
    className := paneName reject: [ :c | c = $~ ].
    className = 'ArrowTool' ifTrue: [
        ^mainPane loadCursor: nil
    ].
    #osiHack. "Substitute WBComboBox for ComboBox because ComboBox has problems..."
    className = 'ComboBox' ifTrue: [
        self class useWBComboBox ifTrue: [
            className := 'WBComboBox'.
        ].
    ].
    (Smalltalk includesKey: className asSymbol) ifFalse: [
        ^MessageBox warning: 'The class ', className, ' is not in this image.  You must load it in first.'
    ].
    className = editedClass name ifTrue: [
        ^MessageBox warning: 'You cannot add ',className,' to itself. This would result in infinite recursion.'
    ].
    addPane := (mainPane pseudoClassFor: className) exampleFrom: className.
    addPane supportedInDialogs not & mainPane editedPane isDialog ifTrue: [
        ^MessageBox warning:
        'Sorry. ', className,' widgets are not supported in WindowDialogs due to base image limitations. Create your window as a subclass of WBWindowDialog instead.'
    ].
    addPane isComposite & mainPane editedPane isDialog ifTrue: [
        MessageBox messageNote:
        'Sorry. WindowDialogs do not support nested tabbing within children (including GroupPanes and CompositePanes). Create your window as a subclass of WBWindowDialog instead.'
    ].
    mainPane loadCursor: addPane.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
close

    (self checkIfSaveChanges: 'Exiting WindowBuilder') ifFalse: [
        ^self
    ].
    Smalltalk platformIsWin32 ifTrue: [
        self mainView parent isNil ifFalse: [
            self mainView parent mainView bringToTop ] ].
    self mainView propertyAt: #parentWB put: nil.
    super close.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
createViews

        "WARNING!! This method was automatically generated by
        WindowBuilder. Code you add here which does not conform to
        the WindowBuilder API will probably be lost the next time
        you save your layout definition."

    | instVar instVarCheckBox mainView nameText performText
    position positionButton scrollingPane size sizeButton
    staticBox1 staticBox2 staticBox3 status styleButton
    wb3DFrame1 wb3DFrame2 wb3DFrame3 whenText |

    mainView := self topPaneClass new.

        "Instance Variables"
    attributePalette := WBToolBar new.
    editPalette := WBToolBar new.
    groupPalette := WBToolPalette new.
    perform := WBEntryField new.
    styleEditor := WBComboBox new.
    styleText := StaticText new.
    titleEditor := WBEntryField new.
    titleText := StaticText new.
    toolBar := WBToolBar new.
    toolPalette := WBMultiToolPalette new.
    when := WBComboBox new.

        "Temporary Variables"
    instVar := WBEntryField new.
    instVarCheckBox := CheckBox new.
    nameText := StaticText new.
    performText := StaticText new.
    position := StaticText new.
    positionButton := DrawnButton new.
    scrollingPane := WBScrollingPane new.
    size := StaticText new.
    sizeButton := DrawnButton new.
    staticBox1 := StaticBox new.
    staticBox2 := StaticBox new.
    staticBox3 := StaticBox new.
    status := StaticText new.
    styleButton := Button new.
    wb3DFrame1 := StaticBox new.
    wb3DFrame2 := StaticBox new.
    wb3DFrame3 := StaticBox new.
    whenText := StaticText new.

    mainView "WindowBuilder"
        owner: self;
        paneName: 'mainView';
        labelWithoutPrefix:  'WindowBuilder: [Untitled]';
        noSmalltalkMenuBar;
        framingBlock: ( FramingParameters new iDUE: 1426 @ 904; xC; yC; cRDU: (9 @ 46 rightBottom: 1417 @ 896));
        pStyle: #(sysmenu minimize maximize sizable titlebar);
        when: #activated send: #activated: to: self withArgument: mainView;
        when: #aboutToClose send: #aboutToClose to: self;
        when: #closed send: #closed to: self;
        backColor: Color paleGray.
    self addView: mainView.

    status "StaticText"
        owner: self;
        paneName: 'status';
        "addClipsiblingsStyle;"
        framingBlock: ( FramingParameters new iDUE: 1390 @ 28; lDU: 9 r: #left; rDU: 9 r: #right; tDU: 32 r: #bottom; bDU: 4 r: #bottom);
        contents: '';
        foreColor: Color black;
        backColor: Color paleGray.
    mainView addSubpane: status.

    wb3DFrame3
        owner: self;
        framingBlock: ( FramingParameters new iDUE: 1408 @ 36; lDU: 0 r: #left; rDU: 0 r: #right; tDU: 36 r: #bottom; bDU: 0 r: #bottom);
        blackFrame.
    mainView addSubpane: wb3DFrame3.

    titleEditor "WBEntryField"
        owner: self;
        paneName: 'titleEditor';
        framingBlock: ( FramingParameters new iDUE: 450 @ 48; lDU: 261 r: #left; rDU: 697 r: #right; tDU: 194 r: #bottom; bDU: 146 r: #bottom; indent: 3 @ 4);
        startGroup;
        tabStop;
        when: #textChanged: send: #textChanged: to: self;
        when: #needsPopupMenu send: #popupTitleMenu: to: self withArgument: titleEditor;
        foreColor: Color black;
        backColor: Color white.
    mainView addSubpane: titleEditor.

    styleEditor "WBComboBox"
        owner: self;
        paneName: 'styleEditor';
        framingBlock: ( FramingParameters new iDUE: 450 @ 188; lDU: 261 r: #left; rDU: 697 r: #right; tDU: 142 r: #bottom);
        dropDownList;
        addDynamicListSizeStyle;
        startGroup;
        tabStop;
        when: #changed: send: #setStyle: to: self;
        backColor: Color white.
    mainView addSubpane: styleEditor.

    instVar "WBEntryField"
        owner: self;
        paneName: 'instVar';
        "addClipsiblingsStyle;"
        framingBlock: ( FramingParameters new iDUE: 450 @ 48; lDU: 261 r: #left; rDU: 697 r: #right; tDU: 90 r: #bottom; bDU: 42 r: #bottom; indent: 3 @ 4);
        startGroup;
        tabStop;
        when: #textChanged: send: #symbolNameChanged: to: self;
        when: #needsPopupMenu send: #popupInstVarMenu: to: self withArgument: instVar;
        backColor: Color white.
    mainView addSubpane: instVar.

    when "WBComboBox"
        owner: self;
        paneName: 'when';
        framingBlock: ( FramingParameters new iDUE: 471 @ 188; lDU: 480 r: #right; rDU: 9 r: #right; tDU: 142 r: #bottom);
        dropDownList;
        addDynamicListSizeStyle;
        startGroup;
        tabStop;
        when: #changed: send: #when: to: self;
        backColor: Color white.
    mainView addSubpane: when.

    perform "WBEntryField"
        owner: self;
        paneName: 'perform';
        "addClipsiblingsStyle;"
        framingBlock: ( FramingParameters new iDUE: 471 @ 48; lDU: 480 r: #right; rDU: 9 r: #right; tDU: 90 r: #bottom; bDU: 42 r: #bottom; indent: 3 @ 4);
        startGroup;
        tabStop;
        when: #textChanged: send: #performTextChanged:pane: to: self withArgument: perform;
        when: #needsPopupMenu send: #popupTargetMenu: to: self withArgument: perform;
        backColor: Color white.
    mainView addSubpane: perform.

    styleText "StaticText"
        owner: self;
        paneName: 'styleText';
        framingBlock: ( FramingParameters new iDUE: 101 @ 32; lDU: 151 r: #left; rDU: 251 r: #left; tDU: 134 r: #bottom; bDU: 102 r: #bottom);
        rightJustified;
        contents: 'Style:';
        backColor: Color paleGray.
    mainView addSubpane: styleText.

    size "StaticText"
        owner: self;
        paneName: 'size';
        framingBlock: ( FramingParameters new iDUE: 110 @ 28; lDU: 128 r: #right; rDU: 18 r: #right; tDU: 182 r: #bottom; bDU: 154 r: #bottom);
        contents: '0 x 0';
        foreColor: Color black;
        backColor: Color paleGray.
    mainView addSubpane: size.

    position "StaticText"
        owner: self;
        paneName: 'position';
        framingBlock: ( FramingParameters new iDUE: 110 @ 28; lDU: 302 r: #right; rDU: 192 r: #right; tDU: 182 r: #bottom; bDU: 154 r: #bottom);
        contents: '0, 0';
        foreColor: Color black;
        backColor: Color paleGray.
    mainView addSubpane: position.

    scrollingPane "WBScrollingPane"
        owner: self;
        paneName: 'scrollingPane';
        framingBlock: ( FramingParameters new iDUE: 1266 @ 600; lDU: 142 r: #left; rDU: 0 r: #right; tDU: 52 r: #top; bDU: 198 r: #bottom);
        startGroup;
        foreColor: Color white;
        backColor: Color white.
    mainView addSubpane: scrollingPane.

    editPalette "WBToolBar"
        owner: self;
        paneName: 'editPalette';
        framingBlock: ( FramingParameters new iDUE: 133 @ 56; lDU: 5 r: #left; rDU: 137 r: #left; tDU: 98 r: #bottom; bDU: 42 r: #bottom);
        useSystem: true;
        add: WBEditAppCodeSysBitmap selector: #editAppCode;
        add: WBEditTabbingSysBitmap selector: #editTabbing spaces: 3;
        postAutomatic;
        when: #showHelp: send: #paletteHelp:pane: to: self withArgument: editPalette;
        backColor: Color paleGray.
    mainView addSubpane: editPalette.

    toolBar "WBToolBar"
        owner: self;
        paneName: 'toolBar';
        framingBlock: ( FramingParameters new iDUE: 1408 @ 44; lDU: 0 r: #left; rDU: 0 r: #right; tDU: 4 r: #top);
        useSystem: true;
        add: WBTestWindowSysBitmap selector: #testWindow spaces: 3;
        add: WBCreateNewSysBitmap selector: #createNew spaces: 4;
        add: WBCreateNewDialogSysBitmap selector: #createNewDialog;
        add: WBOpenNewSysBitmap selector: #openNew;
        add: WBSaveSysBitmap selector: #save;
        add: WBCutSysBitmap selector: #cut spaces: 4;
        add: WBCopySysBitmap selector: #copy;
        add: WBPasteSysBitmap selector: #paste;
        add: WBClearSysBitmap selector: #clear;
        add: WBSendToBackSysBitmap selector: #sendToBack spaces: 4;
        add: WBBringToFrontSysBitmap selector: #bringToFront;
        add: WBDuplicateSysBitmap selector: #duplicate;
        add: WBAutosizeSysBitmap selector: #autosize spaces: 4;
        add: WBReplicateWidthSysBitmap selector: #replicateWidth;
        add: WBReplicateHeightSysBitmap selector: #replicateHeight;
        add: WBAlignLeftSysBitmap selector: #alignLeft spaces: 4;
        add: WBAlignCenterHorizontalSysBitmap selector: #alignCenterHorizontal;
        add: WBAlignRightSysBitmap selector: #alignRight;
        add: WBAlignTopSysBitmap selector: #alignTop spaces: 2;
        add: WBAlignCenterVerticalSysBitmap selector: #alignCenterVertical;
        add: WBAlignBottomSysBitmap selector: #alignBottom;
        add: WBAlignDistributeVerticalSysBitmap selector: #alignDistributeVertical spaces: 2;
        add: WBAlignDistributeHorizontalSysBitmap selector: #alignDistributeHorizontal;
        add: WBSetDrawGridSysBitmap selector: #setDrawGrid spaces: 4 rbSelector: #popupGridSize:;
        postAutomatic;
        when: #showHelp: send: #paletteHelp:pane: to: self withArgument: toolBar;
        backColor: Color paleGray.
    mainView addSubpane: toolBar.

    groupPalette "WBToolPalette"
        owner: self;
        paneName: 'groupPalette';
        framingBlock: ( FramingParameters new iDUE: 69 @ 688; lDU: 5 r: #left; rDU: 73 r: #left; tDU: 60 r: #top; bDU: 102 r: #bottom);
        when: #gettingFocus send: #resetFocus to: self;
        when: #selecting: send: #newPaneType:pane: to: self withArgument: groupPalette;
        backColor: Color paleGray.
    mainView addSubpane: groupPalette.

    toolPalette "WBMultiToolPalette"
        owner: self;
        paneName: 'toolPalette';
        framingBlock: ( FramingParameters new iDUE: 69 @ 688; lDU: 73 r: #left; rDU: 142 r: #left; tDU: 60 r: #top; bDU: 102 r: #bottom);
        when: #selecting: send: #newToolMessage:pane:  to: self withArgument: toolPalette;
        when: #doubleClick: send: #placeCentered:  to: self;
        "when: #gettingFocus send: #resetFocus: to: self withArgument: toolPalette;"
        when: #clicked: send: #newTool:pane: to: self withArgument: toolPalette;
        backColor: Color paleGray.
    mainView addSubpane: toolPalette.

    attributePalette "WBToolBar"
        owner: self;
        paneName: 'attributePalette';
        framingBlock: ( FramingParameters new iDUE: 338 @ 44; lDU: 690 r: #right; rDU: 352 r: #right; tDU: 194 r: #bottom; bDU: 150 r: #bottom);
        useSystem: true;
        add: WBSetFontSysBitmap selector: #setFont:;
        add: WBSetColorSysBitmap selector: #setColor:;
        add: WBSetFramingSysBitmap selector: #setFraming:;
        add: WBSetMenuSysBitmap selector: #setMenu:;
        add: WBPartsButtonSysBitmap selector: #setParts:;
        add: WBOtherSysBitmap selector: #other:;
        postAutomatic;
        when: #showHelp: send: #paletteHelp:pane: to: self withArgument: attributePalette;
        backColor: Color paleGray.
    mainView addSubpane: attributePalette.

    sizeButton "DrawnButton"
        owner: self;
        paneName: 'sizeButton';
        framingBlock: ( FramingParameters new iDUE: 37 @ 32; lDU: 174 r: #right; rDU: 137 r: #right; tDU: 190 r: #bottom; bDU: 158 r: #bottom);
        when: #clicked send: #setWindowSize to: self;
        backColor: Color paleGray.
    mainView addSubpane: sizeButton.

    positionButton "DrawnButton"
        owner: self;
        paneName: 'positionButton';
        framingBlock: ( FramingParameters new iDUE: 37 @ 32; lDU: 347 r: #right; rDU: 311 r: #right; tDU: 190 r: #bottom; bDU: 158 r: #bottom);
        when: #clicked send: #setWindowPosition to: self;
        backColor: Color paleGray.
    mainView addSubpane: positionButton.

    instVarCheckBox "CheckBox"
        owner: self;
        paneName: 'instVarCheckBox';
        framingBlock: ( FramingParameters new iDUE: 46 @ 40; lDU: 688 r: #right; rDU: 642 r: #right; tDU: 86 r: #bottom; bDU: 46 r: #bottom);
        when: #clicked: send: #setPaneNameIsInstVar: to: self;
        contents: ''.
    mainView addSubpane: instVarCheckBox.

    styleButton "Button"
        owner: self;
        paneName: 'styleButton';
        framingBlock: ( FramingParameters new iDUE: 57 @ 44; lDU: 688 r: #right; rDU: 631 r: #right; tDU: 142 r: #bottom; bDU: 98 r: #bottom);
        when: #clicked send: #openStyleDialog to: self;
        contents: '...'.
    mainView addSubpane: styleButton.

    staticBox1
        owner: self;
        framingBlock: ( FramingParameters new iDUE: 2 @ 760; lDU: 142 r: #left; rDU: 144 r: #left; tDU: 52 r: #top; bDU: 38 r: #bottom);
        blackFrame;
        startGroup;
        backColor: Color paleGray.
    mainView addSubpane: staticBox1.

    staticBox2
        owner: self;
        framingBlock: ( FramingParameters new iDUE: 1408 @ 2; lDU: 0 r: #left; rDU: 0 r: #right; tDU: 38 r: #bottom; bDU: 36 r: #bottom);
        blackFrame;
        startGroup;
        backColor: Color paleGray.
    mainView addSubpane: staticBox2.

    staticBox3
        owner: self;
        framingBlock: ( FramingParameters new iDUE: 142 @ 2; lDU: 0 r: #left; rDU: 142 r: #left; tDU: 52 r: #top; bDU: 54 r: #top);
        blackFrame;
        startGroup;
        backColor: Color paleGray.
    mainView addSubpane: staticBox3.

    nameText "StaticText"
        owner: self;
        paneName: 'nameText';
        framingBlock: ( FramingParameters new iDUE: 101 @ 32; lDU: 151 r: #left; rDU: 251 r: #left; tDU: 86 r: #bottom; bDU: 54 r: #bottom);
        rightJustified;
        contents: 'Name:';
        backColor: Color paleGray.
    mainView addSubpane: nameText.

    titleText "StaticText"
        owner: self;
        paneName: 'titleText';
        framingBlock: ( FramingParameters new iDUE: 91 @ 32; lDU: 160 r: #left; rDU: 251 r: #left; tDU: 186 r: #bottom; bDU: 154 r: #bottom);
        rightJustified;
        contents: 'Text:';
        backColor: Color paleGray.
    mainView addSubpane: titleText.

    performText "StaticText"
        owner: self;
        paneName: 'performText';
        framingBlock: ( FramingParameters new iDUE: 128 @ 32; rDU: 489 r: #right; bDU: 50 r: #bottom);
        rightJustified;
        contents: 'Perform:';
        backColor: Color paleGray.
    mainView addSubpane: performText.

    whenText "StaticText"
        owner: self;
        paneName: 'whenText';
        framingBlock: ( FramingParameters new iDUE: 128 @ 32; rDU: 489 r: #right; bDU: 102 r: #bottom);
        rightJustified;
        contents: 'When:';
        backColor: Color paleGray.
    mainView addSubpane: whenText.

    wb3DFrame1
        owner: self;
        framingBlock: ( FramingParameters new iDUE: 169 @ 44; lDU: 352 r: #right; rDU: 183 r: #right; tDU: 194 r: #bottom; bDU: 150 r: #bottom);
        blackFrame.
    mainView addSubpane: wb3DFrame1.

    wb3DFrame2
        owner: self;
        framingBlock: ( FramingParameters new iDUE: 169 @ 44; lDU: 178 r: #right; rDU: 9 r: #right; tDU: 194 r: #bottom; bDU: 150 r: #bottom);
        blackFrame.
    mainView addSubpane: wb3DFrame2.! !

"WB Dev Code Gen (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
defaultCodeModuleClasses
        "Private - Answer the default code module classes."
    | answer moduleClass |
    (answer := OrderedCollection new)
        add: self class;
        add: WBVersionCodeModule.
    self class generatePartsMethods ifTrue: [
        answer add: (Smalltalk at: #WBPartsModule) ].
    ^answer! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
dumpErrorToTranscript: exception

    | errorStream |
    errorStream := ReadWriteStream on: (String new: 800).
    Process copyStack walkbackOn: errorStream maxLevels: 20.
    errorStream reset.
    10 timesRepeat: [errorStream nextLine].
    Transcript 
        cr; cr; show: '*** Start Error: [', exception description, '] ***';
        show: (errorStream 
            copyFrom: errorStream position 
            to: (errorStream indexOf: '[] in WindowBuilder') - 1);
        show: '*** End Error ***'.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
editClass: aViewClass
    "The windows are built.  Set this thing up to edit a new class (either at start or in open...)."
    | editedPane temp vMenu |
    editedClass := aViewClass.
    self labelWithoutPrefix: self label.
    editedClass isScratchWindow
        ifTrue: [
            cleanedOutCode := false.
            editedPane := mainPane editClass: editedClass defaultClass.
            self disable: #(editAppCode) inMenu: 'File']
        ifFalse: [
            self setDefaultFonts.
            [temp := [mainPane editClass: editedClass]
                on: Error
                do: [:ex |
                    MessageBox message:
                        'WindowBuilder Pro cannot edit the specified window: [ ',
                        ex description,' ]. Hold the ALT key down when clicking OK to see the full walkback.'.
                    Notifier isAltKeyDown 
                        ifTrue: [ex pass]
                        ifFalse: [self dumpErrorToTranscript: ex].
                    WBScratchWindow resetToDefault.
                    self editClass: WBScratchWindow.
                    ^nil].
            ] ensure: [self sendInputEvent: #resetFonts].
            temp isNil
                ifTrue: [
                    MessageBox message: 'WindowBuilder Pro cannot edit the specified window'.
                    WBScratchWindow resetToDefault.
                    self editClass: WBScratchWindow.
                    ^nil].
            editedPane := temp.
            self enable: #(editAppCode) inMenu: 'File'].
    (vMenu := self menuTitled: 'View') notNil
        ifTrue: [
            vMenu disableAll.
            (editedPane isDialog or: [editedPane isCompositePane])
                ifFalse: [
                    (mainPane views size = 1)
                        ifTrue: [vMenu enableItem: #viewCreate]
                        ifFalse: [vMenu enableAll]]].
    editedPane isDialog
        ifTrue: [self enable: #(exportToResFile) inMenu: 'File']
        ifFalse: [self disable: #(exportToResFile) inMenu: 'File'].
    self reinitWindowBuilder.
    "Check if clipboard is an object pasteable (is that a word?) for us"
    ((mainPane clipboard isArray) not or: [mainPane clipboard size ~= 2])
        ifTrue: [self disable: #(paste) inMenu: 'Edit'].
    self sendInputEvent: #changed: with: false.
    self disable: #(save) inMenu: 'File'.
    self disable: #(createNewComposite ungroupComposite) inMenu: 'Composite Panes'.
    autoSave isNil
        ifTrue: [
            autoSave := false.
            self autoSave].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
fillInPerform

    | selector isTriggered current |
    thePane supportedEvents isEmpty
    & thePane eventsTriggered isEmpty
        ifFalse: [currentWhen := when selectedItem]
        ifTrue: [
            currentWhen := #none.
            perform contents: ''    ].
    perform setPopupMenu: nil.
    current := self currentEvent.
    isTriggered := self currentEventIsTriggered.
    selector := isTriggered
        ifTrue: [thePane eventHandlers at: current ifAbsent: ['']]
        ifFalse: [thePane handlers at: self currentEvent ifAbsent: ['']].
    (self paneNamed: 'performText') contents:
        (isTriggered ifTrue: ['Send:'] ifFalse: ['Perform:']).
    perform contents: (selector isString ifTrue: [selector] ifFalse: ['  *****  '] ).! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
initializePalettes

    | aFont bitmap hackMap |

    hackMap := self initializePalettesMap.
    groupPalette useSystem: true; size: 1@14.
    toolPalette useSystem: true; size: 1@14.
    self toolCollection do: [ :group |
        groupPalette
            add: (self initializePalettesBitmapFor: group key)
            selector: group key.
        toolPalette
            add: (WBBitmapManager system at: 'WBArrowToolSysBitmap' ifAbsent: [ nil ])
            selector: 'ArrowTool'
            on: group key.
        group value do: [ :tool |
            toolPalette
                add: (self initializePalettesBitmapFor: tool)
                selector: tool
                on: group key ] ].
    toolPalette switchTo: 'Text'.

    aFont := Smalltalk platformIsWin32
        ifTrue: [ Font new fromByteArray: #( 244 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 144 1 0 0 0 0 0 0 2 1 2 34 72 101 108 118 101 116 105 99 97 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 ) ]
        ifFalse: [ Font face:  'Helv' size: 5 @ 13 fixedWidth: false attributes: 0 ].
    positionPane font: aFont.
    sizePane font: aFont.
    statusPane font: aFont.

    (self paneNamed: 'sizeButton') contents: (WBSizeSysBitmap handle; yourself).
    (self paneNamed: 'positionButton') contents: (WBPositionSysBitmap handle; yourself).

    editPalette restoreAllBitmaps.
    "toolBar restoreAllBitmaps."
    groupPalette restoreAllBitmaps.
    toolPalette restoreAllBitmaps.
    attributePalette restoreAllBitmaps.
! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
initializePalettesBitmapFor: aString
        "Answer the bitmap for..."
    | key |
    ^WBBitmapManager system
        at: (key := aString, 'SysBitmap')
        ifAbsent: [
            WBBitmapManager system
                at: (key := key select: [ :ch | ch isAlphaNumeric ])
                ifAbsent: [
                    WBBitmapManager system
                        at: 'WB', key
                        ifAbsent: [
                            key := self initializePalettesMap
                                at: aString
                                ifAbsent: [ ^nil ].
                            WBBitmapManager system
        		                at: key
                		        ifAbsent: [ nil ] ] ] ]! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
initializePalettesMap
        "Answer a mapping of names to bitmap names
            for those bitmaps not named in a standard fashion."
    ^self
        propertyAt: #initializePalettesMap
        ifAbsent: [ self initializePalettesMapDefault ].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
initializePalettesMapDefault
        "Answer a mapping of names to bitmap names
            for those bitmaps not named in a standard fashion."
    ^Dictionary new
        at: '3D Button' put: 'WB3DButtonSysBitmap';
        at: 'WBStaticGraphic' put: 'StaticGraphicSysBitmap';
        at: 'CUA ''91' put: 'Cua91SysBitmap';
        yourself! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
initInstVars

    name := self paneNamed: 'instVar'.
    sizePane := self paneNamed: 'size'.
    positionPane := self paneNamed: 'position'.
    statusPane := self paneNamed: 'status'.
! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
initWindow

    | mainMenu |

    CursorManager initializeWBCursors.
    editedClass isNil ifTrue: [editedClass := WBScratchWindow].
    self initInstVars.
    self initializePalettes.
    mainMenu := self mainView menuWindow.
    customSubMenu := mainMenu wbMenuTitled: 'Custom Panes'.
    self updateCustomPanesMenu.
    self updateQuickReferenceMenu.
    self autoSizeMenu.
    self editClass: editedClass.
    self supportsStyleDialog
        ifFalse: [(self paneNamed: 'styleButton') hideWindow].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
newCompositePaneFrom: aWindowBuilder

    editedClass := WBCompositePaneScratchWindow.
    self openWithParent: aWindowBuilder.
    self mainView propertyAt: #parentWB put: aWindowBuilder.
    mainPane placeLoadedPanesAtLeftTop.
    self mainView propertyAt: #creatingNewComposite put: true.
    self sendInputEvent: #changed: with: true.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
openCompositePane: aCompositePaneClass from: aWindowBuilder

    editedClass := aCompositePaneClass.
    self openWithParent: aWindowBuilder.
    self mainView propertyAt: #parentWB put: aWindowBuilder.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
pane: aPane

    | message |

    self disable: #(createNewComposite) inMenu: 'Composite Panes'.
    mainPane selection size > 1 ifTrue: [
        message := 'Multiple panes selected. The first is ',(self subpaneNameString: aPane), '.'.
        self enable: #(createNewComposite) inMenu: 'Composite Panes'.
    ] ifFalse: [ aPane == mainPane editedPane ifTrue: [
        (aPane contents isNil or: [ aPane contents isEmpty ]) ifTrue: [
            aPane isCompositePane ifTrue: [
                message := 'This is an untitled CompositePane.'
            ] ifFalse: [
                message := 'This is an untitled window.'
            ].
        ] ifFalse: [
            aPane isCompositePane ifTrue: [
                message := 'This is a CompositePane titled ',aPane contents asQuotedString,'.'
            ] ifFalse: [
                message := 'This is a window titled ',aPane contents asQuotedString,'.'
            ].
        ]
    ] ifFalse: [
        message := 'This is ', (self subpaneNameString: aPane), '.'
    ]].
    self message: message.

    (aPane == thePane) ifTrue: [
        ^self
    ].

    thePane := aPane.

    "Title"
    self updateTitle: thePane.

    "Name"
    thePane paneName isNil ifFalse: [
        name contents: thePane paneName.
        self paneNameIsInstVar: thePane isInstVar.
        self paneNameIsValidInstVar: thePane paneName.
    ] ifTrue: [
        name contents: ''.
        self paneNameIsInstVar: false.
        self paneNameIsValidInstVar: ''.
    ].

    "Events"
    self updateEvents: false.
    when selection: 1.
    self fillInPerform.

    "Style"
    thePane styles isNil ifTrue: [
        styleEditor
            contents: #(' ');
            selection: ' ';
            disable.
        styleText disable.
    ] ifFalse: [
        styleEditor
            contents: thePane styles;
            selection: thePane style;
            enable.
        styleText enable.
    ].

    "Composite Stuff"
    thePane isCompositePane ifTrue: [
        self enable: #(ungroupComposite) inMenu: 'Composite Panes'.
    ] ifFalse: [
        self disable: #(ungroupComposite) inMenu: 'Composite Panes'.
    ].

    self setStatus: attributePalette.

    self updateSizeAndPosition.

    self resetFocus.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
paneNameIsValidInstVar: aString
        "Determine if aString is a valid inst var name, and enable/disable the i-var check box."
    (self paneNamed: 'instVarCheckBox') perform: (
        (self theEditedClass wbGenerateInstVars
            and: [ (self theEditedClass wbReservedInstVarNames includes: aString) not
                and: [ aString = aString asInstVarToken
        ]]) ifTrue: [ #enable ] ifFalse: [ #disable ] ).
! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
popupEventTarget: anObject

    | targetObject |
    self currentEventIsTriggered ifFalse: [^self].
    perform setPopupMenu: nil.
    targetObject := anObject.
    targetObject == #window: ifTrue: [
        targetObject := (WBEditClassDialog new open selectedClass ifNil: [^self]) symbol].
    targetObject == #global: ifTrue: [
        targetObject := (WBListChooser fromList: (
            Smalltalk keys asSortedCollection reject: [ :each | each beginsWith: ' ' ]
        ) prompt: 'Select a Global') ifNil: [^self]].
    thePane eventHandlerTargets at: self currentEvent put: targetObject.
    self mainPaneChanged.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
popupGridSize: aPane

    | selection labels gridLabel menu |
    labels := #('Grid Off' '2 x 2' '3 x 3' '4 x 4' '5 x 5' '6 x 6' '8 x 8' '10 x 10').
    gridLabel := self gridSize x.
    gridLabel = 1
        ifTrue: [ gridLabel := 'Grid Off']
        ifFalse: [ gridLabel := gridLabel asString,' x ',gridLabel asString ].

    (menu := Menu new
        labels: labels
        lines: #(1)
        selectors: labels)
            checkItem: gridLabel.
    "aPane setPopupMenu: menu."
    Notifier consumeInputUntil: [ :e | e selector = #button2Up: ].
    selection := menu popUpIn: aPane.
    aPane setPopupMenu: nil.
    selection isNil ifTrue: [ ^nil ].
    (gridLabel := selection upTo: 'x') = 'Grid Off'
        ifTrue: [ self drawGrid: false; gridSize: 1@1 ]
        ifFalse: [ self gridSize: gridLabel asInteger @ gridLabel asInteger ]! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
popupPaneMenu: layoutPane

    | selection newSelection menu subMenu list |

    newSelection := layoutPane selection.

    newSelection isEmpty ifTrue: [
        menu := Menu new
            labels: #('Font' 'Color' 'Framing' 'Menubar' 'Window')
            lines: #()
            selectors: #(setFont: setColor: setFraming: setMenu: other:).
    ] ifFalse: [ newSelection size > 1 ifTrue: [
        menu := Menu new
            appendItem: 'Framing' selector: #setFraming:;
            appendSeparator;
            appendItem: 'Create Composite' selector: #createNewComposite;
            appendSeparator;
            appendItem: 'Align Left' selector: #alignLeft;
            appendItem: 'Align Horizontal Center' selector: #alignCenterHorizontal;
            appendItem: 'Align Right' selector: #alignRight;
            appendItem: 'Align Top' selector: #alignTop;
            appendItem: 'Align Vertical Center' selector: #alignCenterVertical;
            appendItem: 'Align Bottom' selector: #alignBottom;
            appendSeparator;
            appendItem: 'Distribute Vertically' selector: #alignDistributeVertical;
            appendItem: 'Distribute Horizontally' selector: #alignDistributeHorizontal.
    ] ifFalse: [ newSelection first isComposite ifTrue: [
        menu := Menu new
            appendItem: 'Color' selector: #setColor:;
            appendItem: 'Framing' selector: #setFraming:;
            appendItem: 'Edit' selector: #other:;
            appendSeparator ;
            appendItem: 'Ungroup' selector: #ungroupComposite;
            appendSeparator ;
            appendSubMenu: (
                subMenu := Menu new
                    title: 'Morph';
                    owner: self owner).
            (list := thePane mutationList) do: [ :item |
                subMenu appendItem: item selector: item ].
            list isEmpty ifFalse: [ subMenu appendSeparator ].
            subMenu appendItem: 'Other...' selector: 'other'.
    ] ifFalse: [
        menu := Menu new
            appendItem: 'Font' selector: #setFont:;
            appendItem: 'Color' selector: #setColor:;
            appendItem: 'Framing' selector: #setFraming:;
            appendItem: 'Menu' selector: #setMenu:;
            appendItem: 'Attributes' selector: #other:;
            appendSeparator ;
            appendSubMenu: (
                subMenu := Menu new
                    title: 'Morph';
                    owner: self owner).
            (list := thePane mutationList) do: [ :item |
                subMenu appendItem: item selector: item ].
            list isEmpty ifFalse: [ subMenu appendSeparator ].
            subMenu appendItem: 'Other...' selector: 'other'.
    ]]].
    self setStatus: menu.
    "layoutPane setPopupMenu: menu."
    Notifier consumeInputUntil: [ :e | e selector = #button2Up: ].
    selection := menu popUpIn: layoutPane mainWindow.
    layoutPane setPopupMenu: nil.
    selection isSymbol ifTrue: [
        ((selection at: selection size) == $:) ifTrue: [
            self sendInputEvent: selection with: nil
        ] ifFalse: [
            self perform: selection.
            self theMainPane invalidateRect: mainPane visibleFrameRect
        ].
    ] ifFalse: [ selection isString ifTrue: [
        self sendInputEvent: #mutate: with: selection asSymbol
    ]].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
popupTargetMenu: sendPane

    | menu panesMenu iVarMenu eventHandlerTarget
    globalName checkItem array answer |

    self currentEventIsTriggered
        ifFalse: [^sendPane setPopupMenu: nil].

    menu := Menu new
        owner: self;
        selector: #popupEventTarget:;
        appendItem: (editedClass isScratchWindow
            ifTrue: ['Self'] ifFalse: ['Self [', editedClass name, ']']) selector: #self;
        yourself.
    mainPane editedPane isCompositePane
        ifFalse: [menu appendItem: 'Top Pane' selector: mainPane editedPane].
    thePane == mainPane editedPane
        ifFalse: [menu appendItem: 'Pane' selector: thePane].
    (mainPane panes notEmpty or: [mainPane validTargets notEmpty])
        ifTrue: [menu appendSeparator].
    mainPane panes notEmpty
        ifTrue: [
            menu appendSubMenu:
                (panesMenu := Menu new
                    title: 'Panes';
                    owner: self;
                    selector: #popupEventTarget:;
                    yourself).
            ((array := mainPane panes asArray) copyFrom: 1 to: (array size min: 24)) do: [:pane |
                panesMenu appendItem: pane printString selector: pane].
            array size > 24
                ifTrue: [
                    panesMenu appendSeparator;
                        appendItem: 'Other Pane...' action:
                            (Message receiver: [
                                (answer := WBListChooser 
                                    fromList: array
                                    prompt: 'Select Pane') isNil
                                    ifFalse: [self popupEventTarget: answer]] selector: #value)]].
    mainPane validTargets notEmpty
        ifTrue: [
            menu appendSubMenu:
                    (iVarMenu := Menu new
                        title: 'Inst Vars';
                        owner: self;
                        selector: #popupEventTarget:;
                        yourself).
            ((array := mainPane validTargets asSortedCollection asArray) 
                copyFrom: 1 to: (array size min: 24)) do: [:iVarName |
                iVarMenu appendItem: iVarName printString selector: iVarName].
            array size > 24
                ifTrue: [
                    iVarMenu appendSeparator;
                        appendItem: 'Other I-Var...' action:
                            (Message receiver: [
                                (answer := WBListChooser 
                                    fromList: array
                                    prompt: 'Select I-Var') isNil
                                    ifFalse: [self popupEventTarget: answer]] selector: #value)]].
    eventHandlerTarget := (thePane eventHandlerTargets
            at: self currentEvent
            ifAbsent: [#self]) ifNil: [#self].

    globalName := (eventHandlerTarget isSymbol and: [
        eventHandlerTarget first isUppercase and: [
        Smalltalk includesKey: eventHandlerTarget]])
        ifTrue: [eventHandlerTarget] ifFalse: [nil].
    menu
        appendSeparator;
        appendItem:     'Window',
            ((globalName notNil and: [(Smalltalk at: globalName) wbCreated])
                ifTrue: [checkItem := #window:. ' [',globalName,']'] ifFalse: ['']),'...' selector: #window:;
        appendItem:     'Global',
            ((globalName notNil and: [(Smalltalk at: globalName) wbCreated not])
                ifTrue: [checkItem := #global:. ' [',globalName,']'] ifFalse: ['']),'...' selector: #global:.

    checkItem isNil
        ifTrue: [
            menu checkItem: eventHandlerTarget.
            panesMenu isNil ifFalse: [panesMenu checkItem: eventHandlerTarget].
            iVarMenu isNil ifFalse: [iVarMenu checkItem: eventHandlerTarget]]
        ifFalse: [menu checkItem: checkItem].

    sendPane setPopupMenu: menu.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
popupTitleMenu: textPane

    | menu subMenu subMenus nlsPool nlsPools checkItem assoc array answer |

    (nlsPools := mainPane editedPane nlsPools asArray) isEmpty
        ifTrue: [^textPane setPopupMenu: nil].

    menu := Menu new
        owner: textPane;
        selector: #contents:;
        yourself.

    nlsPools size == 1
        ifTrue: [
            ((array := (nlsPool := Smalltalk at: nlsPools first) keys asSortedCollection asArray) 
                copyFrom: 1 to: (array size min: 24)) do: [:key |
                assoc := nlsPool associationAt: key.
                menu appendItem: ('#',assoc key, ' - ', assoc value printString) selector: ('#', assoc key) asSymbol].
            array size > 24
                ifTrue: [
                    menu appendSeparator;
                        appendItem: 'Other...' action:
                            (Message receiver: [
                                (answer := WBListChooser 
                                    fromList: (array collect: [:key |
                                        assoc := nlsPool associationAt: key.
                                        ('#',assoc key, ' - ', assoc value printString)])
                                    prompt: 'Select NLS Key') isNil
                                    ifFalse: [textPane contents: (answer upTo: $ )]] selector: #value)]]
        ifFalse: [
            subMenus := OrderedCollection new: nlsPools size.
            nlsPools do: [:sym |
                menu appendSubMenu:
                    (subMenu := Menu new
                        title: sym;
                        owner: textPane;
                        selector: #contents:;
                        yourself).
                subMenus add: subMenu.
                ((array := (nlsPool := Smalltalk at: sym) keys asSortedCollection asArray) 
                    copyFrom: 1 to: (array size min: 24)) do: [:key |
                    assoc := nlsPool associationAt: key.
                    subMenu appendItem: ('#',assoc key, ' - ', assoc value printString) selector: ('#', assoc key) asSymbol].
                array size > 24
                    ifTrue: [
                        subMenu appendSeparator;
                            appendItem: 'Other...' action:
                                (Message receiver: [
                                    (answer := WBListChooser 
                                        fromList: (array collect: [:key |
                                            assoc := nlsPool associationAt: key.
                                            ('#',assoc key, ' - ', assoc value printString)])
                                        prompt: 'Select NLS Key') isNil
                                        ifFalse: [textPane contents: (answer upTo: $ )]] selector: #value)]]].
    checkItem := ((self nlsKeyFor: thePane text) ifNil: ['']) asSymbol.
    subMenus isNil
        ifTrue: [menu checkItem: checkItem]
        ifFalse: [
            subMenus do: [:sub |
                sub checkItem: checkItem]].
    textPane setPopupMenu: menu.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
preInitWindow

    PWindowBuilder licensed ifFalse: [ PWindowBuilder buyACopy ].

    (self paneNamed: 'scrollingPane')
            addSubpane: self mainPane.

    self buildMenus.

    WBBitmapManager validateSystem.

    (self menuTitled: 'Edit')
        accelKey: BackspaceKey  accelBits: AfAlt | AfVirtualkey  for: #undo;
        accelKey: DeleteKey accelBits: AfShift | AfVirtualkey  for: #cut;
        accelKey: InsertKey accelBits:  AfChar | AfControl  for: #copy;
        accelKey: InsertKey accelBits: AfShift | AfVirtualkey  for: #paste.

    self icon: self class wbIcon.

    "Set the default font for all the controls"
    self mainView children do: [ :child | child font: self class wbDefaultFont ].

    "Add parts support if installed."
    PWindowBuilder partsSupportEnabled ifTrue: [
        attributePalette
            dragSource;
            dragSessionClass: (Smalltalk at: #PARTSCatalogDragSession) " PARTSAddPartSession " ;
            when: #dragSourceNeedsObject: send: #dragPart: to: self.
        mainPane
            dragSource;
            dragSessionClass: (Smalltalk at: #PARTSCatalogDragSession) " PARTSAddPartSession " ;
            when: #dragSourceNeedsObject: send: #dragPart: to: self ].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
prepareAppWindowsForSave: viewList

    "Scan through the panes, looking for methods and instance
     variables to predeclare."

    | allSelectors menuPanes methodsToDeclare methodNames panesToScan
     poolDictionaries sharedPools sharedVariableString generateClassDef dict index |

    CursorManager execute change.

    "Since we don't log source, recompiling the class will fail
      when trying to compile the open method.  To avoid this, we
      remove the old method first"

    editedClass isScratchWindow
        ifTrue: [
            PWindowBuilder openMethodType isNil
                ifTrue: [editedClass removeSelector: #open]
                ifFalse: [editedClass removeSelector: PWindowBuilder openMethodType]].

    poolDictionaries := Set new.
    methodsToDeclare := Dictionary new.
    methodNames := editedClass selectors asOrderedCollection.

    editedClass allSuperclasses do: [:aClass |
        methodNames addAll: aClass selectors].

    panesToScan := OrderedCollection new.
    viewList do: [:view |
        poolDictionaries addAll: view nlsPools.
        panesToScan addAll: view children copy].
    panesToScan addAll: mainPane panes.

    menuPanes := OrderedCollection new.

    viewList do: [:view |
        view menu notNil
            ifTrue: [
                (allSelectors := view menu allSelectors) keysDo: [:aSelector |
                    (aSelector isSymbol) & (methodNames includes: aSelector) not
                        ifTrue: [
                            methodsToDeclare
                                at: aSelector
                                put: (self menuCommentNameFor: (allSelectors at: aSelector))]]].

        view handlers do: [:aSelector |
            (aSelector isSymbol) & (methodNames includes: aSelector) not
                ifTrue: [
                    methodsToDeclare
                        at: aSelector
                        put: (self topPaneCommentNameFor: view event: (view handlers keyAtValue: aSelector))]].

        view eventHandlers associationsDo: [:assoc |
            ((assoc value isSymbol) & (methodNames includes: assoc value) not and: [
                (view eventHandlerTargets at: assoc key ifAbsent: [#self]) == #self])
                    ifTrue: [
                        methodsToDeclare
                            at: assoc value
                            put: (Array
                                with: view
                                with: assoc key
                                with: (self topPaneCommentNameFor: view event: assoc key))]]].

    panesToScan do: [:widget |
        widget menu notNil
            ifTrue: [
                (allSelectors := widget menu allSelectors) keysDo: [:aSelector |
                    (aSelector isSymbol) & (methodNames includes: aSelector) not
                        ifTrue: [
                            methodsToDeclare
                                at: aSelector
                                put: (self menuCommentNameFor: (allSelectors at: aSelector))]]].

        widget handlers do: [:aSelector |
            (aSelector isSymbol) & (methodNames includes: aSelector) not
                ifTrue: [
                    methodsToDeclare
                        at: aSelector
                        put: (self subpaneCommentNameFor: widget event: (widget handlers keyAtValue: aSelector))]].

        widget eventHandlers associationsDo: [:assoc |
            ((assoc value isSymbol) & (methodNames includes: assoc value) not and: [
                (widget eventHandlerTargets at: assoc key ifAbsent: [#self]) == #self])
                    ifTrue: [
                        methodsToDeclare
                            at: assoc value
                            put: (Array
                                with: widget
                                with: assoc key
                                with: (self eventCommentNameFor: widget event: assoc key selector: assoc value))]].

        widget extraHandlers do: [:aSelector |
            (aSelector isSymbol) & (methodNames includes: aSelector) not
                ifTrue: [methodsToDeclare at: aSelector put: (self extraCommentNameFor: widget)]].

        poolDictionaries addAll: widget requiredPoolDictionaries].

    (methodsToDeclare notEmpty) & (editedClass isScratchWindow)
        ifTrue: [
        "Do not generate any methods for a scratch window"
        methodsToDeclare := Dictionary new].

    methodsToDeclare keysDo: [:aMethod |
        self declareMethod: aMethod commentString: (methodsToDeclare at: aMethod)].

    "Make sure it has the local Constants pool dictionary"
    sharedPools := editedClass sharedPools.
    editedClass isScratchWindow
        ifTrue: [
            poolDictionaries add: #OperatingSystemConstants; add: #ColorConstants.
            editedClass setSharedPools: poolDictionaries asArray]
        ifFalse: [
            sharedVariableString := editedClass sharedVariableString.
            generateClassDef := false.
            
            "Remove the old pools..."
            #( WBConstants WinConstants PMConstants ) do: [ :dict |
                (index := sharedVariableString indexOfString: dict) > 0 ifTrue: [
                    generateClassDef := true.
                    sharedVariableString :=
                        (sharedVariableString
                            copyFrom: 1
                            to: index - 1),
                        (sharedVariableString
                            copyFrom: index + dict size + 1
                            to: sharedVariableString size) ] ].
            poolDictionaries
                remove: #WBConstants ifAbsent: [];
                remove: #WinConstants ifAbsent: [];
                remove: #PMConstants ifAbsent: [].

            "Add the new pools..."
            poolDictionaries add: #ColorConstants.
            (sharedPools includes: #OperatingSystemConstants)
                ifFalse: [poolDictionaries add: #OperatingSystemConstants].

            poolDictionaries do: [:dict |
                (sharedPools includes: dict)
                    ifFalse: [
                        sharedVariableString := sharedVariableString,' ',dict asString.
                        generateClassDef := true]].
            generateClassDef
                ifTrue: [
                    editedClass superclass
                        subclass: editedClass name asSymbol
                        instanceVariableNames: editedClass instanceVariableString
                        classVariableNames: editedClass classVariableString
                        poolDictionaries: sharedVariableString]].

    CursorManager normal change.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
resetFocus

    titleEditor setFocus; selectAll; setPopupMenu: nil.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
saveInternal

    self setDefaultFonts.
    [
        (self changed or: [editedClass isScratchWindow]) ifFalse: [^self].
        (self prepareAppWindowsForSave: mainPane views) isNil ifTrue: [^nil].
        mainPane editedPane realClass: editedClass.
        [self generateCode] on: Error
            do: [:ex |
                MessageBox message:
                    'There has been a serious code generation error: [ ',
                    ex description,
                    ' ]. Check the Transcript for details. Hold the ALT key down when clicking OK to see the full walkback.'.
                Notifier isAltKeyDown 
                    ifTrue: [ex pass]
                    ifFalse: [self dumpErrorToTranscript: ex].
                ^nil].
    ] ensure: [self sendInputEvent: #resetFonts].

    self changed: false.
    self disable: #(save) inMenu: 'File'.
    (editedClass isScratchWindow)
        ifFalse: [self enable: #(editAppCode) inMenu: 'File'].
    self updateParent.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
scrapbookLoad
    | fileName scrapbook |
    (Smalltalk includesKey: #ObjectFiler) ifFalse: [
        ^MessageBox message:
            'Loading a Scrapbook requires the ObjectFiler from the \EXTRAS\OBJFILER directory.' ].
    fileName := (FileDialog new
                            openTitle: 'Load Scrapbook'
                            fileSpec: '*.SBK'
                            showFileInButton: false) file.
    fileName isNil ifFalse: [
        self class scrapbookLoadFile: fileName.
        self updateQuickReferenceMenu.
    ].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
selectionChanged: newSelection

    | sizeMenu |

    toolBar cacheRedrawOn.
    sizeMenu := self menuTitled: 'Size'.

    (self menuTitled: 'Edit')
        changeItem: #undo label: '\uUndo\tCtrl+Z' replaceEscapeCharacters;
        disableItem: #undo.

    (newSelection size > 1) ifTrue: [
        self selectionMenuItemsPerform: #enableItem:.
        self enable: #(alignLeft alignRight alignTop alignBottom) inMenu: 'Align'.
        (self menuTitled: 'Align')
            enableItem: '~Center';
            enableItem: '~Distribute'.
        ( self menuWindow wbMenuTitled: 'Center') enableAll.
        ( self menuWindow wbMenuTitled: 'Distribute') enableAll.
        toolBar
            enableItem: #alignCenterHorizontal;
            enableItem: #alignCenterVertical;
            enableItem: #alignDistributeHorizontal;
            enableItem: #alignDistributeVertical.

        self pane: newSelection first.

        sizeMenu
            disableItem: #setWindowSize;
            disableItem: #setWindowPosition.

    ] ifFalse: [

        sizeMenu
            enableItem: #setWindowSize;
            enableItem: #setWindowPosition.

        self disable: #(alignLeft alignRight alignTop alignBottom) inMenu: 'Align'.
        (self menuTitled: 'Align')
            disableItem: '~Center';
            disableItem: '~Distribute'.
        ( self menuWindow wbMenuTitled: 'Center') disableAll.
        ( self menuWindow wbMenuTitled: 'Distribute') disableAll.
        toolBar
            disableItem: #alignCenterHorizontal;
            disableItem: #alignCenterVertical;
            disableItem: #alignDistributeHorizontal;
            disableItem: #alignDistributeVertical.
       newSelection isEmpty ifTrue: [
            self selectionMenuItemsPerform: #disableItem:.
            self pane: mainPane editedPane.
            sizeMenu
                changeItem: #setWindowSize label: '\uSet Window Size...' replaceEscapeCharacters;
                changeItem: #setWindowPosition label: 'Set Window \uPosition...' replaceEscapeCharacters.

        ] ifFalse: [
            sizeMenu
                changeItem: #setWindowSize label: '\uSet Pane Size...' replaceEscapeCharacters;
                changeItem: #setWindowPosition label: 'Set Pane \uPosition...' replaceEscapeCharacters.

            self enable: #(cut copy duplicate clear bringToFront sendToBack mutate) inMenu: 'Edit'.
            self enable: #(autosize) inMenu: 'Size'.
           self pane: newSelection first.
        ].
    ].

    toolBar cacheRedrawOff! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
setParts: aPane
        "Open a WB-PARTS Interface Window."
    | editorClass |
    PWindowBuilder partsSupportIsInstalled ifFalse: [
        ^MessageBox message: 'PARTS support not installed' ].
    PWindowBuilder partsSupportEnabled ifFalse: [
        ^MessageBox message: 'PARTS support not enabled' ].
    "self theEditedClass isScratchWindow ifTrue: [
        ^MessageBox message: 'Save window before editing PARTS interface.' ]."
    editorClass := Smalltalk at: #WBPARTSInterfaceEditor.
    (self isOkToOpen: editorClass) ifFalse: [ ^self ].
    editorClass new openOn: self.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
setWindowPosition

    | newOrigin  |
    mainPane selection notEmpty  ifTrue: [
        mainPane hideSelectionDots; disableSelectionDots.
        newOrigin := self getPointPrompting: 'New Pane Position:' defaultPoint: mainPane selectionOrigin.
        newOrigin notNil ifTrue: [mainPane selectionOrigin: newOrigin].
        mainPane enableSelectionDots; showSelectionDots.
        self updateSizeAndPosition.
        ^self].
    Notifier isAltKeyDown
        ifTrue: [
           (newOrigin := self
                getPointPrompting: 'New Window Position:'
                defaultPoint: mainPane editedPane rect origin) isNil ifTrue: [^self]]
        ifFalse: [
            mainPane captureMouseInput.
            newOrigin := Display wbPointFromUser: (0@0 extent: mainPane editedPane rect extent)
                offset: (mainPane editedPane rect extent // 2) executing: [ :loc | self updatePosition: loc ].
            mainPane clearMouseCapture].
    mainPane editedPane rect: (newOrigin extent: mainPane editedPane rect extent).
    (mainPane editedPane framingBlock: FramingParameters new)
        framingBlock
            left: newOrigin x relativeTo: #left;
            top: newOrigin y relativeTo: #top.
    self updateSizeAndPosition.
    self changed: true.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
symbolNameChanged: ignore

    | badName newName |

    thePane isNil ifTrue: [ ^nil ].
    (newName := name contents) = thePane paneName ifTrue: [ ^self ].

    "The names are changing so..."
    thePane isInstVar ifTrue: [ self paneNameIsInstVar: false ].
    self paneNameIsValidInstVar: newName.
    self triggerAboutToChange.

    newName hasContent ifTrue: [
        newName do: [ :c |
            c isAlphaNumeric ifFalse: [  badName := true ].
        ].
        (self instVarNameCheck and: [
            newName first isUpperCase | (badName = true)]) ifTrue: [
            MessageBox messageNote: '''', newName, ''' is an invalid pane name.'.
                name contents: ''.
        ] ifFalse: [
            thePane paneName: newName.
            PWindowBuilder partsSupportIsInstalled ifTrue: [
                mainPane wbPartEvents updatePaneNames: mainPane views.
                mainPane wbPartMessages updatePaneNames: mainPane views ].
        ].
    ] ifFalse: [
        thePane paneName: nil.
        PWindowBuilder partsSupportIsInstalled ifTrue: [
            mainPane wbPartEvents updatePaneNames: mainPane views.
            mainPane wbPartMessages updatePaneNames: mainPane views ].
    ].

    self mainPaneChanged.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
testWindow
    | errorStream  |
    self setDefaultFonts.
    self tryToSaveChanges notNil
        ifTrue: [
        [[editedClass open] on: Error
                do: [:ex | MessageBox warning:
                    'An error was detected while launching this window: [ ',
                    ex description,
                    ' ]. Please try launching the window from the Transcript and correct the error. Hold the ALT key down when clicking OK to see the full walkback.'.
                    Notifier isAltKeyDown 
                        ifTrue: [ex pass]
                        ifFalse: [self dumpErrorToTranscript: ex].
                    ^nil]]
            ensure: [self sendInputEvent: #resetFonts]].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
textChanged: aString

    | nlsString nlsKey nlsPool |
    thePane isNil ifTrue: [^nil].
    titleEditor setPopupMenu: nil.
    nlsString := aString.
    (aString notEmpty and: [aString first == $#])
        ifTrue: [
            nlsKey := aString copyFrom: 2 to: aString size.
            mainPane editedPane nlsPools detect: [:sym |
                (nlsString := (nlsPool := Smalltalk at: sym) at: nlsKey
                    ifAbsent: [nlsString := nlsPool at: nlsKey asSymbol
                    ifAbsent: [aString]]) ~= aString]
                    ifNone: []].
    thePane usesTitle & (thePane text = nlsString) not
        ifTrue: [
            thePane text: nlsString.
            mainPane updateTitle: thePane.
            self mainPaneChanged.
            mainPane checkMnemonicConflicts.
            (self autoSize
                and: [thePane changesSize
                and: [mainPane selection size < 2]])
                    ifTrue: [
                        self autosize.
                        self updateEvents: false]].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
toolCollection
    | menus target tools |
    menus := self class wbMenus.
    target := menus
        detect: [ :m | (m at: 1) stripMnemonic = 'Add' ]
        ifNone: [nil].
    target isNil ifTrue: [ ^nil].
    tools := OrderedCollection new.
    (target at: 3) do: [ :mi |
        mi == #separator ifTrue: [ ^tools ].
        tools add:
            (Association
                key: (mi at: 1) stripMnemonic
                value: ((mi at: 3) collect: [ :msi | msi at: 2 ]))
    ].
    ^tools! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
tryToSaveChanges

    (self changed or: [ editedClass isScratchWindow ]) ifTrue: [
        autoSave ifFalse: [
            (MessageBox
                confirm: 'Your window needs to be saved first.  Save and continue?'
            ) ifFalse: [
                ^nil
            ].
        ].
        CursorManager execute change.

        self saveInternal isNil ifTrue: [
            CursorManager normal change.
            ^nil
        ].
        cleanedOutCode := true.
        CursorManager normal change.
    ].

    (editedClass isScratchWindow) & (cleanedOutCode = false) & (changed not) ifTrue: [
        editedClass resetToDefault.
        cleanedOutCode  := true.
    ].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
undoableOperation

    | aString aSymbol |

    aSymbol := mainPane lastOpSymbol.

    (#( move size sizeWindow clear undo align replicateSize autosize) includes: aSymbol) not |
        ((aSymbol = #undo) and: [ (mainPane previousOpSymbol = #place) ])  ifTrue: [
        ^(self menuTitled: 'Edit')
            changeItem: #undo label: 'Can''t \uUndo' replaceEscapeCharacters, (String with: Tab), 'Ctrl+Z';
            disableItem: #undo
    ].

    aSymbol == #undo ifTrue: [
        aString := '\uRedo' replaceEscapeCharacters, (String with: Tab),'Ctrl+Z'
    ] ifFalse: [
        aString := '\uUndo ' replaceEscapeCharacters, aSymbol asPresentableString, (String with: Tab), 'Ctrl+Z'.
    ].

    (self menuTitled: '~Edit')
        changeItem: #undo label: aString;
        enableItem: #undo.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
updateEvents: refresh

    | oldEvents theEvents triggeredEvents sel used unused |

    oldEvents := when contents.
    triggeredEvents := thePane eventsTriggered.
    theEvents := 
        (Window class compiledMethodAt: #supportedEvents) notNil
            ifTrue: [ thePane supportedEvents ]
            ifFalse: [
                #obsoleteMethod.
                "If obsolete support is not loaded, then only show those
                    old events for which an event is defined so that
                    users can convert them to new triggered events."
                thePane handlers keys ].
    used := OrderedCollection new.
    unused := OrderedCollection new.
    triggeredEvents do: [ :e |
        (thePane eventHandlers at: e ifAbsent: [ nil ]) isSymbol
            ifTrue: [ used add: '*', e, self eventsTriggeredTag ]
            ifFalse: [ unused add: e asString, self eventsTriggeredTag ]
    ].
    theEvents do: [ :e |
        (thePane handlers at: e ifAbsent: [ nil ]) isSymbol
            ifTrue: [ used add: '*', e, self supportedEventsTag ]
            ifFalse: [ unused add: e asString, self supportedEventsTag ]
    ].
    theEvents := used addAll: unused; yourself.

    theEvents = oldEvents ifTrue: [
        ^self
    ].

    refresh ifTrue: [
        sel := when selectedItem.

        (sel notNil and: [ sel notEmpty ]) ifTrue: [
            sel first = $* ifTrue: [
                sel := sel copyFrom: 2 to: sel size.
            ].
            perform contents notEmpty ifTrue: [
                sel := '*', sel.
            ].
        ].

        when
            contents: theEvents;
            selectItem: sel;
            invalidateRect: when rectangle.
    ] ifFalse: [
        when contents: theEvents.
    ].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
updateParent
    | originalRect parentWB |
    (parentWB := self mainView propertyAt: #parentWB) isNil ifFalse: [
        parentWB isMDIChild | parentWB isMDIClient ifTrue: [ ^nil ].
        (self mainView propertyAt: #creatingNewComposite) == true ifTrue: [
            (MessageBox confirm: 'Replace original widgets with new CompositePane?') ifTrue: [
                originalRect := parentWB theMainPane selectedRect.
                parentWB
                    cut;
                    add: self theEditedClass name.
                parentWB theMainPane placeLoadedPanesAt: originalRect leftTop.
            ].
            self mainView propertyAt: #creatingNewComposite put: false.
        ] ifFalse: [
            parentWB isMDIClient ifFalse: [ parentWB refresh ].
        ].
        self mainView setFocus.
    ].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
updatePosition: aPoint

    positionPane contents: aPoint x abs asString,', ',aPoint y abs asString.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
updateQuickReferenceMenu

    | quickReferenceMenu index p stream uCh |

    uCh := '\u' replaceEscapeCharacters first.
    quickReferenceMenu := self quickReferenceMenu.
    quickReferenceMenu removeAllItemsDynamically.
    index := quickReferenceMenu numberOfItems + 1.
    (self class scrapbook at: 'Quick Reference')  keys asSortedCollection do: [ :page |
        (page includes: uCh) ifFalse: [
            p := page
        ] ifTrue: [
            stream := WriteStream on: String new.
            page do: [ :character |
                stream nextPut: character.
                character = uCh  ifTrue: [stream nextPut: character]].
            p := stream contents
        ].
        quickReferenceMenu insertItemDynamically: p selector: p atIndex: index.
        index := index + 1.
    ].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
updateSizeAndPosition

    | point |
    self updateSize: thePane rect.
    mainPane selection notEmpty  ifTrue: [
        point := mainPane selectionOrigin.
     ] ifFalse: [
        point := mainPane editedPane rect origin.
    ].
    self updatePosition: point.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder' osiMethods: 'WindowBuilder' !  
updateTitle: aPane

    "Title"
    | paneText nlsKey |
    aPane usesTitle
        ifTrue: [
            paneText := self nlsKeyFor: aPane text.
            titleEditor
                contents: paneText; 
                enable;
                setPopupMenu: nil.
            titleText enable]
        ifFalse: [
            titleEditor contents: ''; disable.
            titleText disable].! !

"WB Dev Parts (WB2ADPW.SLL)"!
!'WindowBuilder class' osiMethods: 'WBPARTSInterfaceEditor' !  
addInDisablePartsSupport: op
    "Register support for PARTS code generation."
    | addInName incompatible |
    addInName := 'Disable PARTS Support'.
    op == #name ifTrue:[ ^addInName ].
    op == #help ifTrue:[
^'Disable PARTS code generation.'].
    PWindowBuilder
        register: addInName propertyAt: #partsSupportEnabled put: false.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
addInMultipleViewsSupport: op
    "Register support for Multiple Views"
    | addInName incompatible |
    addInName := 'Multiple Views Support'.
    op == #name ifTrue:[ ^addInName ].
    op == #help ifTrue:[
^'WARNING !! Using multiple views
is discouraged and may not be
supported in future releases !!
WindowBuilder will generate
#createViews1, 2, 3... methods.'].
    PWindowBuilder
        register: addInName 
        menu: (Array
            with: '\uView' replaceEscapeCharacters
            with: #nil
            with: (Array 
                with: (Array with: '\uSwitch To...' replaceEscapeCharacters with: #viewSwitchTo with: '')
                with: (Array with: '\uCreate...' replaceEscapeCharacters with: #viewCreate with: '')
                with: (Array with: '\uRemove...' replaceEscapeCharacters with: #viewRemove with: '')))
        after: 'Edit'.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
addInPaneInspector: op
    "Register the additional Inspect menu items"
    | addInName |
    addInName := 'Pane Inspector'.
    op == #name ifTrue:[ ^addInName ].
    op == #help ifTrue:[
^'Pane Inspector'].
    PWindowBuilder extras removeKey: addInName ifAbsent: [ nil ].
    PWindowBuilder
        register: addInName 
        menu: (Array
            with: '\uInspect' replaceEscapeCharacters
            with: #nil
            with: (Array with: (Array
                with: '\uInspect Selection' replaceEscapeCharacters
                with: #inspectSelection
                with: '')))
        after: 'Add'.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
basicVersionNumber
        "Private - Answer the window builder version."
    ^2.02! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
basicVersionNumberString
        "Private - Answer the version number string to place in the global ServiceRegistry."
    ^'2.0.2'! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
buyACopy
        "Display a buy-a-copy message."
    MessageBox message: self buyACopyMessage.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
buyACopyMessage
        "Answer the demo message string."
    ^'This is a demonstration copy.  To purchase WindowBuilder Pro, please contact: 

', self osiMessage! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
companyName
        "Answer the window builder company's name."
    | answer |
    PWindowBuilder licensed ifFalse: [ ^'' ].
    ^self propertyAt: #companyName ifAbsent: [
        answer := (Prompter prompt: 'Please Enter Company Name.' default: '') ifNil: [ '' ].
        (answer notEmpty or: [ (self propertyAt: #userName) notNil ]) ifTrue: [
            self propertyAt: #companyName put: answer ].
        answer ]! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
devBitmapFileName
        "Answer the name of the available development bitmap DLL."

    DevBitmapFileName isNil ifTrue: [
        DevBitmapFileName :=
            self devBitmapFileNames
                detect: [ :each | (File findFileName: each) notNil ]
                ifNone: [ self devBitmapFileNames first ] ].
    ^DevBitmapFileName! !

"WB Dev Base Win32 (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
devBitmapFileNames
        "Answer the possible names of the development bitmap DLL."

    ^#( 'WB2ASYSW.DLL' 'WB20SYSW.DLL' )! !

"WB Dev Code Gen (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
generatePartsMethods
    "Answer true if parts methods should be generated."
  ^self partsSupportEnabled! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
helpDict

    HelpDict isNil ifTrue: [
        HelpDict := Dictionary new.
        HelpDict
            at: 'File' put: 'Create, edit, import, export window definitions; edit app code.';
            at: 'createNew' put: 'Create a new window.';
            at: 'createNewDialog' put: 'Create a new dialog.';
            at: 'openNew' put: 'Open an existing window or dialog.';
            at: 'importFromWindows' put: 'Convert WindowBuilder 1.x generated windows.';
            at: 'importFromResFile' put: 'Convert dialog resources (.res files) to Smalltalk windows.';
            at: 'save' put: 'Save the currently edited window.';
            at: 'saveAs' put: 'Save the currently edited window with a new class name.';
            at: 'saveAsDefault' put: 'Use the current layout of windows as the default for new windows.';
            at: 'exportToResFile' put: 'Save the current dialog layout as a resource (.res) file.';
            at: 'editAppCode' put: 'Bring up CHB on currently edited window.';
            at: 'close' put: 'Close WindowBuilder.';
            at: 'aboutWB' put: 'About WindowBuilder.';
            at: 'installedProducts' put: 'Get a list of installed products.';

            at: 'Edit' put: 'Subpane editing, selection, ordering;  window testing, tab order editing ';
            at: 'undo' put: 'Undo the last command.';
            at: 'cut' put: 'Remove currently selected subpanes from layout, place on clipboard.';
            at: 'copy' put: 'Copy the currently selected subpanes to the clipboard.';
            at: 'paste' put: 'Load the cursor with the subpanes on the clipboard.';
            at: 'clear' put: 'Remove currently selected subpanes from layout.';
            at: 'selectAll'  put: 'Add all subpanes in window to the selection.';
            at: 'bringToFront' put: 'Bring currently selected pane to the front of all overlapping panes.';
            at: 'sendToBack' put: 'Send currently selected pane behind all overlapping panes.';
            at: 'duplicate'  put: 'Duplicate the currently selected subpanes.';
            at: 'mutate'  put: 'Morph the currently selected subpane into a different type.';
            at: 'editCallOuts' put: 'Define call out selectors for subpanes in the window.';
            at: 'setParts' put: 'Add a PARTS Workbench interface to the window.';
            at: 'setNLSPools' put: 'Set the NLS Pool Dictionaries to be used with this window.';
            at: 'eventSummary' put: 'Launch window summarizing event usage in this View.';
            at: 'editTabbing' put: 'Edit subpane tabbing order and grouping of buttons.';
            at: 'pasteWindowBitmapToClipboard' put: 'Copy a bitmap of current view to the Windows clipboard.';
            at: 'testWindow' put: 'Launch an example of currently edited View.';

            at: 'View' put: 'View creation, removal, switching.';
            at: 'viewSwitchTo' put: 'Switch to another view in this ViewManager.';
            at: 'viewCreate' put: 'Create a new view in this ViewManager.';
            at: 'viewRemove' put: 'Remove a view from this ViewManager.';

            at: 'Align' put: 'Alignment commands.';
            at: 'alignLeft' put: 'Align selected panes along left sides.';
            at: 'alignTop' put: 'Align selected panes along tops.';
            at: 'alignRight' put: 'Align selected panes along right sides.';
            at: 'alignBottom' put: 'Align selected panes along bottoms.';
            at: 'alignCenterHorizontal' put: 'Align selected panes along their horizontal centers.';
            at: 'alignCenterVertical' put: 'Align selected panes along their vertical centers.';
            at: 'alignDistributeHorizontal' put: 'Distribute selected panes horizontally.';
            at: 'alignDistributeVertical' put: 'Distribute selected panes vertically.';

            at: 'Center' put: 'Centering selected panes.';
            at: 'Distribute' put: 'Distribute selected panes.';
            at: 'horizontal' put: 'Do horizontally.';
            at: 'vertical' put: 'Do vertically.';

            at: 'Move By Pixel' put: 'Nudge selection around by one pixel increments.';
            at: 'moveSelectionUp' put: 'Nudge selection up one pixel.';
            at: 'moveSelectionDown' put: 'Nudge selection down one pixel.';
            at: 'moveSelectionLeft' put: 'Nudge selection left one  pixel.';
            at: 'moveSelectionRight' put: 'Nudge selection right one pixel.';

            at: 'Size By Pixel' put: 'Size selection by one pixel increments.';
            at: 'sizeSelectionUp' put: 'Shrink selection''s height by one pixel.';
            at: 'sizeSelectionDown' put: 'Grow selection''s height by one pixel.';
            at: 'sizeSelectionLeft' put: 'Shrink selection''s width by one pixel.';
            at: 'sizeSelectionRight' put: 'Grow selection''s width by one pixel.';

            at: 'Size' put: 'Size subpanes or window, set window position.';
            at: 'autosize' put: 'Size selected subpanes according to predefined hints.';
            at: 'replicateWidth' put: 'Set width of selected subpanes to be the same.';
            at: 'replicateHeight' put: 'Set height of selected subpanes to be the same.';
            at: 'setWindowSize' put: 'Specify the size of the selected subpane or window, in pixels.';
            at: 'setWindowPosition' put: 'Specify initial launching position of the window.';

            at: 'Options' put: 'Set grid, window zooming, Add-In Manager.';
            at: 'setGridSize' put: 'Set the size of the snap-to grid, in pixels.';
            at: 'drawGrid' put: 'Toggle display of the grid.';
            at: 'setDrawGrid' put: 'Toggle display of the grid (right mouse click for quick access to grid sizes).';
            at: 'autoSave' put: 'Toggle prompting for saving before Test Window.';
            at: 'autoSizeToggle' put: 'Toggle autosizing of StaticText and Buttons as text is entered.';
            at: 'zoomLayout' put: 'Zoom/unzoom the layout area of WindowBuilder.';
            at: 'addInManager' put: 'Invoke the WindowBuilder Add-In Manager.';

            at: 'Scrapbook' put: 'Scrapbook commands.';
            at: 'scrapbookStore' put: 'Store the currently selected panes as a page in the scrapbook.';
            at: 'scrapbookRetrieve' put: 'Retrieve a page from the scrapbook.';
            at: 'scrapbookNew' put: 'Create a new scrapbook.';
            at: 'scrapbookLoad' put: 'Load a scrapbook from disk.';
            at: 'scrapbookMerge' put: 'Merge a scrapbook from disk with the current one.';
            at: 'scrapbookSave' put: 'Save the current scrapbook to disk.';
            at: 'Quick Reference' put: 'Retrieve a page from the Quick Reference list.';

            at: 'Add' put: 'Load cursor with controls.';
            at: 'Button' put: 'Load cursor with one of the buttons.';
            at: '3D Button' put: 'Load the cursor with one of the 3D buttons.';
            at: 'List' put: 'Load the cursor with one of the listboxes.';
            at: 'Valuator' put: 'Load the cursor with one of the valuators.';
            at: 'Text' put: 'Load the cursor with one of the text editors.';
            at: 'Group' put: 'Load the cursor with one of the groupboxes.';
            at: 'Misc' put: 'Load the cursor with one of the miscellaneous subpanes.';
            at: 'Composite' put: 'Load the cursor with one of the composite subpanes.';
            at: 'Custom Panes' put: 'Load the cursor with one of the user-defined subpanes.';
            at: 'addCustomPane' put: 'Add a new custom pane to the Custom Panes menu.';
            at: 'removeCustomPane' put: 'Remove a custom pane from the Custom Panes menu.';

            at: 'setFont:' put: 'Set the font of the selected pane(s).';
            at: 'setColor:' put: 'Set the color of the selected pane(s).';
            at: 'setFraming:' put: 'Set the framing parameters for the selected pane(s).';
            at: 'setMenu:' put: 'Create a menu for the selected pane(s).';
            at: 'setParts:' put: 'Add a PARTS Workbench interface to the window.';
            at: 'other:' put: 'Invoke the attribute editor for the selected pane.'.
    ].

    ^HelpDict! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
initProperties
    "Set up the Properties dictionary"
    " WindowBuilder initProperties "
    | oldProperties oldValue |

    oldProperties := Properties ifNil: [ IdentityDictionary new ].
    Properties := IdentityDictionary new.

    #( userName companyName serialNumber )
        do: [ :each | 
            ( oldValue := oldProperties at: each ifAbsent: [ nil ]
                ) notNil ifTrue: [
                    self propertyAt: each put: oldValue ] ].

    self propertyAt: #GridSize put: 4@4.
    self propertyAt: #DrawGrid put: false.
    self propertyAt: #AutoSize put: true.
    self propertyAt: #InstVarNameCheck put: false.
    self propertyAt: #OpenMethodType put: #createViews.
    self propertyAt: #OpenMethodArgs put: #('self' 'self').
    self propertyAt: #OpenMethodInitCode put: nil.
    self propertyAt: #CodeGenerationHook put: nil.
    self propertyAt: #RecordCreatorInformation put: false.
    "Subclass WBCreateClassDialog to record additional information about class creation (e.g., ENVY)"
    self propertyAt: #WBCreateClassDialog put: WBCreateClassDialog.

    WBScratchWindow removeSelector: #createViews.
    WBDialogScratchWindow removeSelector: #createViews.
    WBScratchWindow removeSelector: #open.
    WBDialogScratchWindow removeSelector: #open.

    self clearWBClasses.

    "Install extra menus and icons"
    self installExtras.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
initTranscriptMenu
    "Prompt the user to initialize the transcript menu."
  WBAboutDialog initTranscriptAfterClose: true.
  (Message
    receiver: WindowBuilder
    selector: #aboutWB
  ) performDeferred.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
initTranscriptMenuDelayed
    "Prompt the user to initialize the transcript menu."
  WBAboutDialog initTranscriptAfterClose: false.
  (MessageBox confirm:
    'Close all windows and reinitialize so that WindowBuilder menus will be displayed in the Transcript window?'
  ) ifTrue: [ Notifier reinitialize ].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
licensed
        "Answer true if the receiver is licensed."
    ^self propertyAt: #licensed ifAbsent: [ true ]! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
menuName
    ^('\u',self labelName) replaceEscapeCharacters! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
osiMessage
        "Answer the OSI information message string."

    ^'    Objectshare Systems, Inc.
    5 Town & Country Village
    Suite 773
    San Jose, CA 95128-2026

    Order / Support:  (408) 970-7280
    Fax:                     (408) 970-7282
    CompuServe:       72254,2515'! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
osiProductRegistry
        "Answer the OSI Product registry"
    | answer |
    ^ServiceRegistry globalRegistry
        serviceNamed: #OSIProducts
        ifNone: [
            ServiceRegistry globalRegistry
                register: (answer := ServiceRegistry new)
                withName: #OSIProducts
                version: '2.0'.
            answer ]! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
osiProducts
    | osiProducts |
    ^(osiProducts := self osiProductRegistry)
        registeredServices collect: [:serviceName |
            (osiProducts serviceNamed: serviceName),
                ' v', (osiProducts versionOf: serviceName) ].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
partsSupportEnabled
      "Answer true if PARTS code should be generated."
    ^self partsSupportIsInstalled and: [
        self
            propertyAt: #partsSupportEnabled
            ifAbsent: [ true ] ]! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
serialNumber
        "Answer the window builder serial number."
    | answer |
    PWindowBuilder licensed ifFalse: [ ^'' ].
    ^self propertyAt: #serialNumber ifAbsent: [
        answer := Prompter prompt: 'Please Enter Serial Number.' default: ''.
        (answer notNil and: [ answer notEmpty ])
            ifTrue: [ self propertyAt: #serialNumber put: answer ]
            ifFalse: [ answer := '**INVALID**' ].
        answer ]! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
startup
    "Force caches to be set up for path independence"
    self reset.
    self propertyAt: #licensed put: (
        self libraryName isNil or: [
            (File findFileName: self libraryName fileName, '.SML') notNil ] ).! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
userBitmapFileName
        "Answer the name of the available user bitmap DLL."

    UserBitmapFileName isNil ifTrue: [
        UserBitmapFileName :=
            self userBitmapFileNames
                detect: [ :each | (File findFileName: each) notNil ]
                ifNone: [ self userBitmapFileNames first ] ].
    ^UserBitmapFileName! !

"WB Dev Base Win32 (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
userBitmapFileNames
        "Answer the possible names of the user bitmap DLL."

    ^#( 'WB2AUSRW.DLL' 'WB20USRW.DLL' )! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
userName
        "Answer the window builder user's name."
    | answer |
    PWindowBuilder licensed ifFalse: [ ^'demo' ].
    ^self propertyAt: #userName ifAbsent: [
        answer := Prompter prompt: 'Please Enter User Name.' default: ''.
        (answer notNil and: [ answer notEmpty ])
            ifTrue: [ self propertyAt: #userName put: answer ]
            ifFalse: [ answer := '???' ].
        answer ]! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
useWBComboBox
        "Answer true if WBComboBox should be used in place of ComboBox
            when adding a new widget to a WBPro generated window."
    ^self propertyAt: #useWBComboBox ifAbsent: [ true ].! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
useWBComboBox: aBoolean
        "Set true if WBComboBox should be used in place of ComboBox
            when adding a new widget to a WBPro generated window."
    self propertyAt: #useWBComboBox put: aBoolean = true.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
versionNumberString
        "Answer the window builder version number string."
    ^self osiProductRegistry versionOf: #WindowBuilder! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
wbInitializeDevelopment
        "Perform initialization."
    WBBitmapManager loadStandardWBBitmaps.
    self
        scrapbookFindAndLoadFile: self wbScrapbookFileName;
        initTranscriptMenu;
        wbInitializeSystemBitmaps;
        wbInitializeOldBitmapNames;
        wbInitializeOldSystemBitmaps;
        wbInitializeRegistry;
        wbInitializeSessionEvents.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
wbInitializeRegistry
        "Initialize the OSI Product registry"
    self osiProductRegistry
        register: 'WindowBuilder Pro'
   		withName: #WindowBuilder
        version: self basicVersionNumberString.
    ServiceRegistry globalRegistry
        register: self
        withName: #WindowBuilderPro
        version: self basicVersionNumberString.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
wbInitializeSessionEvents
        "Link to events triggered by SessionModel."
    SessionModel current
        removeAllActionsWithReceiver: self;
        when: #startup send: #startup to: self.! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
wbMenuArray

^#(
    ('\uFile' nil
        (
            ('\uNew Window\tCtrl+N' createNew 'Ctrl+N')
            ('New \uDialog' createNewDialog '')
            ('\uOpen...\tCtrl+O' openNew 'Ctrl+O')
            separator
            ('\uComposite Panes' nil
                (
                    ('\uNew' createNewCompositePane '')
                    ('\uOpen...' openNewComposite '')
                    separator
                    ('\uCreate...' createNewComposite '')
                    ('\uUngroup' ungroupComposite '')
                ))
            separator
            ('\uImport From Res File...' importFromResFile '')
            separator
            ('\uSave\tCtrl+S' save 'Ctrl+S')
            ('Save \uAs...' saveAs '')
            ('Save As De\ufault' saveAsDefault '')
            ('Ex\uport To Res File...' exportToResFile '')
            separator
            ('\uEdit Code...\tCtrl+E' editAppCode 'Ctrl+E')
            ('E\uxit\tCtrl+Q' close 'Ctrl+Q')
            separator
            ('A\ubout...' aboutWB '')
            ('Installed \uProducts...' installedProducts '')
        ))
    ('\uEdit' nil
        (
            ('\uUndo\tCtrl+Z' undo 'Ctrl+Z')
             separator
            ('Cu\ut\tCtrl+X' cut 'Ctrl+X')
            ('\uCopy\tCtrl+C' copy 'Ctrl+C')
            ('\uPaste\tCtrl+V' paste 'Ctrl+V')
            ('Cl\uear\tCtrl+Delete' clear 'Ctrl+27')
            ('\uSelect All\tCtrl+/' selectAll 'Ctrl+/')
            separator
            ('\uBring To Front\tCtrl+F' bringToFront 'Ctrl+F')
            ('Send To B\uack\tCtrl+B' sendToBack 'Ctrl+B')
            ('\uDuplicate\tCtrl+D' duplicate 'Ctrl+D')
            ('\uMorph...\tCtrl+M' mutate 'Ctrl+M')
            separator
            ('Edit Call \uOuts...' editCallOuts '')
            ('Edit PARTS \uInterface...' setParts '')
            ('Set \uNLS Pools...' setNLSPools '')
            ('E\uvent Summary...\tCtrl+R' eventSummary 'Ctrl+R')
            ('Edit Tabbing/\uGroups...\tCtrl+G' editTabbing 'Ctrl+G')
            ('Paste W\uindow Bitmap to Clipboard' pasteWindowBitmapToClipboard '')
            ('Test \uWindow\tCtrl+T' testWindow 'Ctrl+T')
        ))
    ('\uAlign' nil
        (
            ('\uLeft\tCtrl+Shift+L' alignLeft 'ShiftCtrl+L')
            ('\uTop\tCtrl+Shift+T' alignTop 'ShiftCtrl+T')
            ('\uRight\tCtrl+Shift+R' alignRight 'ShiftCtrl+R')
            ('\uBottom\tCtrl+Shift+B' alignBottom 'ShiftCtrl+B')
            ('\uCenter' center:
                (
                    ('\uHorizontally\tCtrl+Shift+C' horizontal 'ShiftCtrl+C')
                    ('\uVertically\tCtrl+Alt+Shift+C' vertical 'AltShiftCtrl+C')
                ))
            ('\uDistribute' distribute:
                (
                    ('\uHorizontally\tCtrl+Shift+D' horizontal 'ShiftCtrl+D')
                    ('\uVertically\tCtrl+Alt+Shift+D' vertical 'AltShiftCtrl+D')
                ))
            separator
            ('\uMove By Pixel' doByPixel:
                (
                    ('\uUp\tCtrl+Up' moveSelectionUp 'Ctrl+22')
                    ('\uDown\tCtrl+Down' moveSelectionDown 'Ctrl+24')
                    ('\uLeft\tCtrl+Left' moveSelectionLeft 'Ctrl+21')
                    ('\uRight\tCtrl+Right' moveSelectionRight 'Ctrl+23')
                ))
            ('\uSize By Pixel' doByPixel:
                (
                    ('\uUp\tCtrl+Shift+Up' sizeSelectionUp 'ShiftCtrl+22')
                    ('\uDown\tCtrl+Shift+Down' sizeSelectionDown 'ShiftCtrl+24')
                    ('\uLeft\tCtrl+Shift+Left' sizeSelectionLeft 'ShiftCtrl+21')
                    ('\uRight\tCtrl+Shift+Right' sizeSelectionRight 'ShiftCtrl+23')
                ))
        ))
    ('\uSize' nil
        (
            ('\uAuto Size Selection\tCtrl+Shift+A' autosize 'ShiftCtrl+A')
            separator
            ('Replicate \uWidth\tCtrl+Shift+W' replicateWidth 'ShiftCtrl+W')
            ('Replicate \uHeight\tCtrl+Shift+H' replicateHeight 'ShiftCtrl+H')
            separator
            ('\uSet Window Size...' setWindowSize '')
            ('Set Window \uPosition...' setWindowPosition '')
        ))
    ('\uOptions' nil
        (
            ('\uGrid Size...' setGridSize '')
            ('\uDraw Grid' setDrawGrid '')
            separator
            ('\uAuto Save' autoSave '')
            ('\uAuto Size' autoSizeToggle '')
            ('\uZoom Layout\tAlt+Z' zoomLayout 'Alt+Z')
            separator
            ('Add-\uIn Manager...' addInManager '')
        ))
    ('S\ucrapbook' nil
        (
            ('\uStore...' scrapbookStore '')
            ('\uRetrieve...' scrapbookRetrieve '')
            separator
            ('\uNew' scrapbookNew '')
            ('\uLoad...' scrapbookLoad '')
            ('\uMerge...' scrapbookMerge '')
            ('Sa\uve...' scrapbookSave '')
            separator
            ('\uQuick Reference' scrapbookQuickReference: ())
        ))
    ('A\udd' nil
        (
            ('\uText' add:
                (
                    ('\uStaticText' 'StaticText' '')
                    ('\uEntryField' 'EntryField' '')
                    ('EnhancedEntry\uField' 'EnhancedEntryField' '')
                    ('\uTextEdit' 'TextEdit' '')
                    ('Text\uPane' 'TextPane' '')
                ))
            ('\uButton' add:
                (
                    ('\uButton' 'Button' '')
                    ('\uDrawnButton' 'DrawnButton' '')
                    ('\uRadioButton' 'RadioButton' '')
                    ('\uCheckBox' 'CheckBox' '')
                    ('\uThreeStateButton' 'ThreeStateButton' '')
                ))
            ('\uList' add:
                (
                    ('\uListBox' 'ListBox' '')
                    ('List\uPane' 'ListPane' '')
                    ('\uMultipleSelectListBox' 'MultipleSelectListBox' '')
                    ('\uDropDownList' 'DropDownList' '')
                    ('\uComboBox' 'ComboBox' '')
                ))
            ('\uValuator' add:
                (
                    ('\uHorizontal Scroll Bar' 'WBHorizontalScrollBar' '')
                    ('\uVertical Scroll Bar' 'WBVerticalScrollBar' '')
                ))
            ('\uGroup' add:
                (
                    ('\uGroupBox' 'GroupBox' '')
                    ('\uStaticBox' 'StaticBox' '')
                ))
            ('\uMisc' add:
                (
                    ('\uStaticGraphic' 'WBStaticGraphic' '')
                    ('\uGraphPane' 'GraphPane' '')
                    ('\uAnimationPane' 'AnimationPane' '')
                    ('\uWBToolBar' 'WBToolBar' '')
                    ('Status\uPane' 'StatusPane' '')
                ))
            ('\uComposite' add:
                (
                    ('\uRadioButtonGroup' 'RadioButtonGroup' '')
                    ('\uCheckBoxGroup' 'CheckBoxGroup' '')
                    ('\uEntryFieldGroup' 'EntryFieldGroup' '')
                    ('\uSexPane' 'SexPane' '')
                ))
            separator
            ('\uCustom Panes' add: ())
            ('\uAdd Custom Pane...' addCustomPane '')
            ('\uRemove Custom Pane...' removeCustomPane '')
        ))
    )! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
wbMenus
    | menus |
    menus := self propertyAt: #WBMenus.
    menus isNil
        ifTrue: [
            menus := self wbMenuArray asOrderedCollectionRecursively.
            menus do: [ :m |
                m at: 1 put: (m at: 1) replaceEscapeCharacters.
                (m at: 3) do: [ :mi |
                    mi == #separator ifFalse: [
                        mi at: 1 put: (mi at: 1) replaceEscapeCharacters.
                        (mi at: 3) isString ifFalse: [
                            (mi at: 3) do: [ :msi |
                                msi == #separator ifFalse: [
                                    msi at: 1 put: (msi at: 1) replaceEscapeCharacters]]]]]].
            self propertyAt: #WBMenus put: menus ].
    ^menus! !

"WB Dev Base Win32 (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
wbScrapbookFileName
        "Answer the scrapbook file name."
    ^'wb2Ausrw.sbk'! !

"WB Dev Base Common (WB2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods: 'WindowBuilder' !  
windowBuilderMenu
        "Answer the WindowBuilder menu used in the System Transcript."
    | menu |
    menu := Menu new.
    menu
        owner: PWindowBuilder;
        title: PWindowBuilder menuName;
        appendItem: 'New \uWindow\tAlt+W' replaceEscapeCharacters selector: #newWindowBuilder accelKey: $w accelBits: AfAlt | AfChar;
        appendItem: 'New \uDialog\tAlt+D' replaceEscapeCharacters selector: #newDialogWindowBuilder accelKey: $d accelBits: AfAlt | AfChar;
        appendItem: '\uEdit Window...\tAlt+E' replaceEscapeCharacters selector: #editWindow accelKey: $e accelBits: AfAlt | AfChar;
        appendSeparator;
        appendItem: 'Launch \uBitmapManager\tAlt+B' replaceEscapeCharacters selector: #launchBitmapManager accelKey: $b accelBits: AfAlt | AfChar;
        appendSeparator;
        appendItem: ('\uAbout ',PWindowBuilder labelName,'...') replaceEscapeCharacters selector: #aboutWB.

    ^menu! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'WindowFrameObject' osiMethods: 'WindowBuilder' !  
backColor

    ^self isDialog
        ifTrue: [Color dialogBackground]
        ifFalse: [backColor].! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'WindowFrameObject' osiMethods: 'WindowBuilder' !  
drawTitleWith: aPen in: r

    | titleRect b menuRect xPos yPos space |

     titleRect := r leftTop extentFromLeftTop: r width @ self titleHeight.

    self isDialog ifTrue: [
        titleRect := (titleRect leftTop rightAndDown: 1@1) extentFromLeftTop: titleRect extent - (2@0).
    ].
    self hasTitleBar ifTrue: [
        aPen
            fill: titleRect color: Color activeTitleBar;
            font: SysFont;
            setTextAlign: TaTop;
            foreColor: Color titleBarText;
            setBackgroundModeTransparent;
            centerWinText: contents at: titleRect center;
            setBackgroundModeOpaque;
            foreColor: Color windowBorder;
            lineFrom: titleRect left @ (titleRect bottom up: 1) to: titleRect right @ (titleRect bottom up: 1).
    ].

    (self style includes: #sysmenu) ifTrue: [
        (b := self sysMenuBitmap) displayLeftTopAt: (titleRect leftTop) with: aPen.
        aPen lineFrom: (titleRect left right: b width) @ titleRect top
            to: (titleRect left right: b width) @ titleRect bottom.
    ].

    (self style includes: #maximize) ifTrue: [
        (b := self maximizeBitmap) displayLeftTopAt: (titleRect rightTop left: b width) with: aPen.
    ].

    (self style includes: #minimize) ifTrue: [
        (self style includes: #maximize) ifTrue: [
            (b := self minimizeBitmap) displayLeftTopAt: (titleRect rightTop left: (b width * 2)) with: aPen.
        ] ifFalse: [
            (b := self minimizeBitmap) displayLeftTopAt: (titleRect rightTop left: b width) with: aPen.
        ].
    ].

    menu notNil ifTrue: [
        menuRect := r left @ titleRect bottom extentFromLeftTop: r width @ self menuHeight.
        aPen
            fill: menuRect color: Color menuBackground;
            foreColor: Color windowBorder;
            lineFrom: menuRect left @ (menuRect bottom up: 1) to: menuRect right @ (menuRect bottom up: 1);
            foreColor: Color menuText.
            xPos := menuRect left right: 6.
            yPos := menuRect origin y.
            space := aPen stringWidthOf: '  '.

        aPen
            foreColor: Color menuText;
            setBackgroundModeTransparent.

        menu allTitles do: [ :t |
            aPen winDrawText: t at: xPos@yPos.
            xPos := xPos right: (aPen stringWidthOf: t) + space.
        ].
        aPen setBackgroundModeOpaque.
    ].! !

"WB Dev P Widgets Common (WB2ADEVW.SLL)"!
!'WindowFrameObject' osiMethods: 'WindowBuilder' !  
isDialog

    ^(self realClass inheritsFrom: WindowDialog)
        | (self realClass inheritsFrom: DialogCoordinator)! !

"-------------- purge the bitmaps fromSysId." !

'WBInterfaceObject purgeCache' osiEvaluateIfError: [ ] !
'WindowBuilder wbInitializeSessionEvents' osiEvaluateIfError: [ ] !
'WBDevelopmentBitmaps
    at: ''WBPartsButtonSysBitmap''
    put: (Bitmap fromWBSysModuleID: 212)' osiEvaluateIfError: [ ] !
'WBAboutDialog initTranscriptAfterClose: true.' osiEvaluateIfError: [ ] !

"-------------- Register the update." !

'   WindowBuilder osiProductRegistry
        register: ''WindowBuilder Pro''
        withName: #WindowBuilder
        version: ''2.0.2u''
' osiEvaluateIfError: [ ] !
  
"--------- remove temporary methods"!

String removeSelector: #osiMethods !
String removeSelector: #osiMethods: !
String removeSelector: #osiEvaluateIfError: !
String removeSelector: #osiRemoveSelector: !
String removeSelector: #fileInFrom: !
String removeSelector: #osisubclass:instanceVariableNames:classVariableNames:poolDictionaries: !
String removeSelector: #osisubclass:instanceVariableNames:classVariableNames:poolDictionaries:ifDefined: !

