
    "========================= load ObjectFiler" !

SmalltalkLibraryBinder
    bindTo: 'VOFSC3A.SLL';
    bindTo: 'VOFSP3AW.SLL';
    bindTo: 'VOFLR3A.SLL';
    bindTo: 'VOFLR3AW.SLL'.

    "====== Fix a bug in Digitalk's method so that we can use it here..." !

!ObjectFiler class methods !

removeChangeMapsSatisfying: aOneArgBlock forVersion: aFiledObjectVersion
        " Remove any ObjectChangeMap's registered for loading
        objects stored from <aFiledObjectVersion> which cause
        aOneArgBlock to evaluate to true. "

    | changeMaps |
    changeMaps := ( self standardLoadMapsDictionary at: aFiledObjectVersion
        ifAbsentPut: [ ^self ] )
            asOrderedCollection.
    changeMaps := changeMaps reject: [ :aRegisteredMap |
        aOneArgBlock value: aRegisteredMap ].
    changeMaps isEmpty
        ifTrue: [
        self standardLoadMapsDictionary removeKey: aFiledObjectVersion ]
        ifFalse: [
        self standardLoadMapsDictionary
            at: aFiledObjectVersion
            put: changeMaps asArray ].! !

    "=================== Now do our stuff..." !

!WBBitmapManager class methods !

loadStandardWBBitmaps
        "Load the standard window builder user bitmaps."
    self current
        addBitmapsFromModule: 'WB20USRW.DLL'
        idMap: self standardWBBitmapIDMap.! !

[

(SmalltalkLibraryBinder isBound: 'WB20DEV') ifFalse: [

WBObject subclass: #FramingParameters
  instanceVariableNames:
    ' initialExtent bottom top right left bottomRel topRel rightRel leftRel centerX centerY indent clientRect '
  classVariableNames:
    ' InitializationSelector '
  poolDictionaries:
    ' OperatingSystemConstants '.

ObjectFiler
    registerChangeMap: (
        (ObjectChangeMap forClassName: #FramingParameters)
            put: nil into: 'duHeight';
            put: nil into: 'duWidth';
            yourself )
    forVersion: 10  "Smalltalk/V for Win32 3.0 ObjectFiler".

SmalltalkLibraryBinder
    bindTo: 'WB20DEV'   "WindowBuilder Pro Development v2.0".

ObjectFiler
    removeChangeMapForClass: #FramingParameters
    forVersion: 10  "Smalltalk/V for Win32 3.0 ObjectFiler".

WBObject subclass: #FramingParameters
  instanceVariableNames:
    ' initialExtent bottom top right left bottomRel topRel rightRel leftRel centerX centerY indent clientRect duHeight duWidth '
  classVariableNames:
    ' InitializationSelector '
  poolDictionaries:
    ' OperatingSystemConstants '.

]. "end isBound:"

] on: RecompilationNotification do: [ ].
