
"--- Revision History
2.2.0.1.0.1 fixed CPHLB with fonts in Dialog
2.2.0.1.0.2 fixed CR handling in CPTableEditor/Pane
2.2.0.1.0.4 added CPCLBField 'properties' inst var
2.2.0.1.0.5 fixed accel keys in CPBitmapButton
2.2.0.1.0.6 fixed CPBitmapButton handling of enter key
2.2.0.1.0.7 fixed CPTablePane (in matrix mode) fonts and row headers
2.2.0.1.0.8 fixed CPNumericEditor to prevent #valueChanged: event when enter key pressed
2.2.0.7 drawing fixes
2.2.0.10 fixes to CPTablePane
2.2.1.2 integrate with 3.0.1
--- end of Revision History"  !
  
"--------- add temporary methods"!

!String methods !  
osiMethods
        "Answer self as the class reader so that errors
            like missing classes and methods referencing globals
            not in the image can failed gracefully."
    ^self! !

!String methods !  
osiMethods: aString
        "Answer self as the class reader so that errors
            like missing classes and methods referencing globals
            not in the image can failed gracefully."
    (aString osiEvaluateIfError: [ false ]
        ) ~= false ifTrue: [ ^self osiMethods ].
    "Answer a string that will not evaluate."
    ^'a ', self! !

!String methods !  
osiEvaluateIfError: aBlock
        "Evaluate the receiver and answer the result.
            Answer aBlock evaluated if an error occurs."
    | compiler result answer |
    compiler := CompilerInterface
        forClass: UndefinedObject
        errorHandler: SilentErrorHandler new.
    [   answer := 
            (result := compiler evaluate: self) wasSuccessful
                ifTrue: [ result value ]
                ifFalse: [ aBlock value ].
    ]   on: Error
        do: [ answer := aBlock value ].
    ^answer! !

!String methods !  
osiRemoveSelector: aString
        "Remove the specified selector from the specified class.
            If the class or selector are not defined,
            then fail gracefully and report an error to the Transcript."
    | aClass aSelector |
    aClass := self osiEvaluateIfError: [ nil ].
    aSelector := aString asExistingSymbolOrNil.
    aClass notNil & aSelector notNil
        ifTrue: [ aClass removeSelector: aSelector ]
        ifFalse: [
            Transcript cr;
                nextPutAll: 'Ignored remove ', self, '>>', aString ].! !

!String methods !  
fileInFrom: aStream
        "File in the method definitions.
            If the class is missing or the method does not compile,
            then fail gracefully and report an error to the Transcript."
    | aClass chunk compiler result assoc mth |
    (aClass := self osiEvaluateIfError: [ nil ]
        ) notNil ifTrue: [
            compiler := CompilerInterface
                   forClass: aClass
                errorHandler: SilentErrorHandler new ].
    [(chunk := aStream nextChunk) isEmpty]
        whileFalse: [
            compiler notNil ifTrue: [
                 (result := compiler compile: chunk) wasSuccessful
                    ifTrue: [
                        assoc := result association.
                        ((mth := aClass compiledMethodAt: assoc key) isNil
                            or: [ mth sourceString ~= chunk ]
                        ) ifTrue: [
                            assoc value
                                   classField: aClass;
                                selector: result selector;
                                sourceObject: nil;
                                sourceString: chunk.
                            aClass
                                addSelector: assoc key
                                withMethod: assoc value ] ]
                    ifFalse: [
                        result := nil ] ].
            result isNil ifTrue: [
                Transcript cr;
                    nextPutAll: 'Ignored ', self, ' method' ] ].! !

!String methods !  
osisubclass: className
    instanceVariableNames: instVarString
    classVariableNames: classVarString
    poolDictionaries: poolDictString
        "Create or modify the class named <className> to be a
        subclass of the receiver with the specifed instance variables,
        class variables, pool dictionaries."

    | aClass subClass aSelector instVarNames classVarNames poolDictNames |
    aClass := self osiEvaluateIfError: [ nil ].
    aClass isBehavior ifFalse: [ aClass := nil ].
    subClass := className osiEvaluateIfError: [ nil ].
    aClass isNil ifTrue: [
        Transcript cr;
            nextPutAll: 'Ignored ', self, ' subclass: #', className, '...'.
        ^nil ].
    subClass notNil ifTrue: [
        instVarNames := subClass instanceVariableString asArrayOfSubstrings.
        classVarNames := subClass classVariableString asArrayOfSubstrings asSortedCollection.
        poolDictNames := subClass sharedPools asSortedCollection collect: [ :each | each asString ].
        (instVarString asArrayOfSubstrings = instVarNames and: [
            classVarString asArrayOfSubstrings asSortedCollection = classVarNames and: [
                poolDictString asArrayOfSubstrings asSortedCollection = poolDictNames and: [
                    aClass == subClass superclass ] ] ]
        ) ifTrue: [ ^subClass ] ].
    ^[  aClass
            subclass: className asSymbol
            instanceVariableNames: instVarString
            classVariableNames: classVarString
            poolDictionaries: poolDictString
            ] on: Error do: [
                Transcript cr;
                    nextPutAll: 'Ignored ', self, ' subclass: #', className, '...'.
                nil ].
! !

!String methods !  
osisubclass: className
    instanceVariableNames: instVarString
    classVariableNames: classVarString
    poolDictionaries: poolDictString
    ifDefined: ifDefString
        "Create or modify the class named <className> to be a
        subclass of the receiver with the specifed instance variables,
        class variables, pool dictionaries.  If <ifDefString> evaluates
        false, then ignore the class definition."

    ^(ifDefString osiEvaluateIfError: [ false ]) ~= false
        ifTrue: [
            self
                osisubclass: className
                instanceVariableNames: instVarString
                classVariableNames: classVarString
                poolDictionaries: poolDictString ]
        ifFalse: [
            Transcript cr;
                nextPutAll: 'Ignored ', self, ' subclass: #', className, '...'.
            nil ].! !
  
"--------- end temporary methods"!

'CPChildComboBox' osiRemoveSelector: 'cellList:' !
'CPChildComboBox' osiRemoveSelector: 'displayBar' !
'CPChildComboBox' osiRemoveSelector: 'notifyListHidden:' !
'CPChildComboBox' osiRemoveSelector: 'notifyListVisible:' !
'CPChildComboBox' osiRemoveSelector: 'syncControlEvent:with:' !
'CPChildComboBox class' osiRemoveSelector: 'initializeSynchronousNotifications' !
'CPChildComboBox class' osiRemoveSelector: 'synchronousNotifications' !
'CPChildComboBox class' osiRemoveSelector: 'synchronousNotifications:' !
'CPChildDropDownList' osiRemoveSelector: 'button1DoubleClick:' !
'CPChildDropDownList' osiRemoveSelector: 'button2Up:' !
'CPChildDropDownList' osiRemoveSelector: 'cellList:' !
'CPChildDropDownList' osiRemoveSelector: 'cellValidate' !
'CPChildDropDownList' osiRemoveSelector: 'character:' !
'CPChildDropDownList' osiRemoveSelector: 'characterInput:' !
'CPChildDropDownList' osiRemoveSelector: 'cr' !
'CPChildDropDownList' osiRemoveSelector: 'field:' !
'CPChildDropDownList' osiRemoveSelector: 'getFocus:' !
'CPChildDropDownList' osiRemoveSelector: 'gettingFocus' !
'CPChildDropDownList' osiRemoveSelector: 'isOkToChange' !
'CPChildDropDownList' osiRemoveSelector: 'keyboardInput:' !
'CPChildDropDownList' osiRemoveSelector: 'losingFocus' !
'CPChildDropDownList' osiRemoveSelector: 'notifyListHidden:' !
'CPChildDropDownList' osiRemoveSelector: 'notifyListVisible:' !
'CPChildDropDownList' osiRemoveSelector: 'readOnly' !
'CPChildDropDownList' osiRemoveSelector: 'selectAll' !
'CPChildDropDownList' osiRemoveSelector: 'showWindow' !
'CPChildDropDownList' osiRemoveSelector: 'syncControlEvent:with:' !
'CPChildDropDownList' osiRemoveSelector: 'tabKeyInput:' !
'CPChildDropDownList' osiRemoveSelector: 'triggerChanged' !
'CPChildDropDownList class' osiRemoveSelector: 'constructEventsTriggered' !
'CPChildDropDownList class' osiRemoveSelector: 'initializeSynchronousNotifications' !
'CPChildDropDownList class' osiRemoveSelector: 'supportedEvents' !
'CPChildDropDownList class' osiRemoveSelector: 'synchronousNotifications' !
'CPChildDropDownList class' osiRemoveSelector: 'synchronousNotifications:' !
'CPNumericEditor' osiRemoveSelector: 'controlKeyInput:' !
'CPTableEditor' osiRemoveSelector: 'controlKeyInput:' !

"----------------- Remove extraneous class instance variables" !
CPChildComboBox class instanceVariableNames: '' !
CPChildDropDownList class instanceVariableNames: '' !

"SP Run Table Common"!

'WBComboBox' osisubclass: 'CPChildComboBox'
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: 
    ' CharacterConstants OperatingSystemConstants VirtualKeyConstants ' !

"SP Run Table Common (SP2ARTW.SLL)"!

'Object' osisubclass: 'CPCLBField'
  instanceVariableNames: 
    ' header selector printSelector fieldWidth justification font cachedWidth name foreColor backColor properties '
  classVariableNames: ''
  poolDictionaries: 
    ' CharacterConstants OperatingSystemConstants ' !

"SP Run Table Common"!

'CPChildComboBox' osisubclass: 'CPChildDropDownList'
  instanceVariableNames: ''
  classVariableNames: ''
  poolDictionaries: 
    ' CharacterConstants OperatingSystemConstants VirtualKeyConstants ' !

"SP Run Base Win32 (SP2ARBW.SLL)"!
!'Bitmap class' osiMethods !  
spSysModuleName
        "Answer the subpane system bitmap module name."
    ^'sp22sysw.dll'
! !

"SP Run Bitmap Button Common (SP2ARBBW.SLL)"!
!'CPBitmapButton' osiMethods !  
getMnemonicHandler: char
        "Private - Check if this control handles this mnemonic.
        Answer the receiver if it does, else nil."
    | index |
    ( title isNil or: [ self disabled ] ) ifTrue: [ ^nil ].
    ^( ( index := ( title indexOf: '\u' replaceEscapeCharacters first ) ) ~= 0
        and: [ ( title at: index + 1 ) asLowerCase == char asLowerCase ] )
        ifTrue: [ self ]
        ifFalse: [ nil ]! !

"SP Run Bitmap Button Common (SP2ARBBW.SLL)"!
!'CPBitmapButton' osiMethods !  
givesUpFocusWithMnemonic
        "Answer whether the input focus can be taken away
        from the receiver when a mnemonic command is
        entered for another pane."
    ^true! !

"SP Run Bitmap Button Common"!
!'CPBitmapButton' osiMethods !  
highlight
    "Private"

    | holdPicture region |
    self doGraphics: 
        [self pen
            draw3DRect: self rectToHighlight
            depth: 2
            style: #in.
        ].
    onPicture isNil
        ifFalse:
            [holdPicture := picture.
            picture := onPicture.
            self
                invalidateRect: (self rect insetBy: 3);
                updateWindow.
            picture := holdPicture.
            ].! !

"SP Run Bitmap Button Common (SP2ARBBW.SLL)"!
!'CPBitmapButton' osiMethods !  
isPushButton
        "Answer whether the receiver is an instance of a push button"
    ^true
! !

"SP Run Bitmap Button Common (SP2ARBBW.SLL)"!
!'CPBitmapButton' osiMethods !  
keyboardInput: aKeyboardInputEvent
        "Private - keyboard input was received."
    ( aKeyboardInputEvent character == Cr
        and: [ self isPushButton
        and: [ self mainWindow isDialogTopPane not ]] )
        ifTrue: [ ^self "handled by keyDownInput: and keyUpInput:" ].
    ^super keyboardInput: aKeyboardInputEvent! !

"SP Run Bitmap Button Common (SP2ARBBW.SLL)"!
!'CPBitmapButton' osiMethods !  
keyDownInput: aKeyboardInputEvent
        "Private - key down event was received."
    | ch |
    pressed ifFalse: [
        ch := aKeyboardInputEvent character.
        (ch = Cr) ifTrue: [
            self isPushButton ifFalse: [
                (self mainWindow defaultPushButton notNil
                    and: [ self mainWindow isDialogTopPane not ])
                        ifTrue: [ ^self ] ] ].
        (ch = Cr) | (ch = Space) ifTrue: [
            self press.
            ^self ] ].
    ^super keyDownInput: aKeyboardInputEvent! !

"SP Run Bitmap Button Common (SP2ARBBW.SLL)"!
!'CPBitmapButton' osiMethods !  
mnemonic: char typedIn: aPane
        "The receiver's mnemonic was typed in the
        sibling <aPane>.  Perform a programmatic button click."
    pressed ifFalse: [
        self sendInputEvent: #press.
        aPane givesUpFocusWithMnemonic
            ifTrue: [ self setFocus ]
            ifFalse: [ self sendInputEvent: #releaseButton ] ].! !

"SP Run Bitmap Button Common"!
!'CPBitmapButton' osiMethods !  
unHighlight
    "Private"

    self doGraphics: 
        [self pen
            draw3DRect: self rectToHighlight
            depth: 2
            style: #out.
        ].
    onPicture isNil
        ifFalse:
            [self
                invalidateRect: (self rect insetBy: 3);
                updateWindow.
            ].! !

"SP Run Miscellaneous Win32 (SP2ARMW.SLL)"!
!'CPBitmapPane' osiMethods !  
wmNchittest: wParam
with: lParam
    "Private - allow overlapping panes to get mouse input"

    ^self isDragSource | self isDragTarget
        ifTrue: [super wmNchittest: wParam with: lParam]
        ifFalse: [-1 "HtTransparent"]! !

"SP Run Bitmap Button Common (SP2ARBBW.SLL)"!
!'CPBitmapToggle' osiMethods !  
isPushButton
        "Answer whether the receiver is an instance of a push button"
    ^false
! !

"SP Run Table Win32 (SP2ARTW.SLL)"!
!'CPChildComboBox' osiMethods !  
cellInset
        "Answer the # of pixels to inset the receiver's frame
            when used in a CPTablePane."

    ^1! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPChildComboBox' osiMethods !  
cellList: aCollection

    self contents: aCollection.! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPChildComboBox' osiMethods !  
cr
        "Private - pass to the parent."
    self isDropdownVisible
        ifTrue: [
            self showDropdown: false.
            self event: #textChanged.    " OBSOLETE "
            self triggerEvent: #textChanged: with: self value ]
        ifFalse: [ self superWindow cr ].! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPChildComboBox' osiMethods !  
font
    "Answer the font for the receiver."

    ^super font isNil
        ifTrue: [self defaultFont]
        ifFalse: [super font]! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPChildComboBox' osiMethods !  
gettingFocus
        "Private - Make sure the window is visible."
    self hasFocus ifTrue: [
        self superWindow isCellSelectMode
            ifTrue: [
                self showWindow.
                super gettingFocus ]
            ifFalse: [
                self hideWindow.
                self superWindow setFocus ] ].! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPChildComboBox' osiMethods !  
heightWithoutDropDownList
        "Answer the height of the receiver when the drop down list is hidden."
    ^self font height + 5! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPChildComboBox' osiMethods !  
needsKeyUpInput
        "Private - Answer true if the receiver processes key-up events."
    ^true! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPChildComboBox' osiMethods !  
shouldProcess: wordInteger controlKey: controlKey
        "Private - Answer true if the receiver should process the keystroke."

    (wordInteger = NumLockKey) ifTrue: [ ^false ].

    (wordInteger = UpKey) | (wordInteger = DownKey)
        | (wordInteger = LeftKey) | (wordInteger = RightKey)
        | (wordInteger = PageUpKey) | (wordInteger = PageDownKey)
        | (wordInteger = HomeKey) | (wordInteger = EndKey) ifFalse: [ ^true ].

    (self superWindow cpStyle = #arrowKeysMove
        | controlKey)
        ifTrue: [
            ^self isDropdownVisible = true and: [
                (wordInteger ~= LeftKey) & (wordInteger ~= RightKey) ] ].

    ^true! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPChildComboBox class' osiMethods !  
hasDynamicListSizeStyle
        "Answer the default value for the dynamic list size style."
    ^true! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPChildComboEntryField' osiMethods !  
clearAnchor
        "Private - Pass to parent."
    self superWindow clearAnchor.! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPChildComboEntryField' osiMethods !  
needsKeyUpInput
        "Private - Answer true if the receiver processes key-up events."
    ^true! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPChildDropDownList' osiMethods !  
cellContents

    ^self selectedItem! !

"SP Run Table Win32 (SP2ARTW.SLL)"!
!'CPChildDropDownList' osiMethods !  
cellInset
        "Answer the # of pixels to inset the receiver's frame
            when used in a CPTablePane."

    ^1! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPChildEntryField' osiMethods !  
characterInput: aCharacter
        "Private - Pass to parent."
    aCharacter = Cr ifTrue: [
        self cr.
        ^true ].
    self isReadOnly ifTrue: [
        ^self superWindow characterInput: aCharacter ].
    ^super characterInput: aCharacter! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPChildEntryField' osiMethods !  
cr
        "Send the message to the parent."
    self superWindow cr.! !

"SP Run Input Field Common (SP2ARFW.SLL)"!
!'CPDateEditor' osiMethods !  
initialize
    "Private"

    super initialize.
    dayField := SpinField
        new parent: self;
        width: 2;
        justification: #right;
        showLeadingZeros: true;
        value: 1.
    monthField := SpinField
        new parent: self;
        width: 2;
        showLeadingZeros: true;
        justification: #right;
        value: 1.
    yearField := SpinField
        new parent: self;
        width: 2;
        min: 0;
        justification: #right;
        value: 1.
    separator := '/'.
    self format: #mdy.
    self monthAsNumber.
    self contents: Date today.! !

"SP Run Input Field Common (SP2ARFW.SLL)"!
!'CPDateEditor' osiMethods !  
monthAsNumber
    "Set the month style to be numeric"

    self propertyAt: #cpStyle put: #monthAsNumber.
    monthField
        justification: #right;
        choices: nil;
        width: 2.! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPHierarchicalListBox' osiMethods !  
defaultDrawItem: aDrawStruct
    "Private - Draw the specified control item."

    | item aBitmap box region |
    box := aDrawStruct boundingBox.
    region := self graphicsTool setClipRect: (box intersect: self rectangle).
    self graphicsTool 
        font: self font;
        width: box width;
        height: box height.
    aBitmap isNil
        ifTrue: [
            (list at: self drawIndex) displayWith: graphicsTool inBox: box ]
        ifFalse: [
            graphicsTool
                erase;
                copyBitmap: aBitmap
                    from: aBitmap boundingBox
                    at: box origin ].
    self graphicsTool destroyRegion: region.! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPHierarchicalListBox' osiMethods !  
expandOrCollapse
    "Expand or collapse the selected item."

    | selectedIndex |
    (selectedIndex := self selectedIndex) isNil
        ifTrue: [^self].
    "self disableRedraw."
    (list at: selectedIndex) expandOrCollapse.
    "list := self flatList.  <-- done in #updateListBox:"
    self updateListBox: true.
    self selectIndex: selectedIndex.
    "self enableRedraw."
! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPHierarchicalListBox' osiMethods !  
updateHorizontalExtent

        "Private - if the receiver has a horizontal scrollbar,
         call this method after setting its contents to calculate
         and set the correct horizontal scrollbar range."

        "Faster than superclass method.  Thanks to Wolfgang."
    | maxWidth font |

    (self hasStyle: WsHscroll) ifFalse: [ ^self ].
    list size = 0 ifTrue: [ ^self ].
    (font := self font) isNil ifTrue: [ font := ListFont ].
    maxWidth := list inject: 0 into: [ :max :item |
        max max: (self stringForItem: item) size
    ].
    maxWidth := (font stringWidth: (String new: maxWidth)) + 5.
    self setHorizontalExtent: maxWidth! !

"SP Run Table Win32 (SP2ARTW.SLL)"!
!'CPHierarchicalListBox' osiMethods !  
updateItemSizes
    "Private"

    self isHandleOk
        ifTrue:
            [self itemHeight: (self maxIconHeight max: self font height).
            self setHExtent: self maxDisplayWidth.
            "self insertBlankItems."
            ].! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPHierarchicalListBox' osiMethods !  
updateListBox: retainScrolling
    "Private"

    | firstVis |
    list := self flatList.
    firstVis := self getTopIndex.
    super contents: list.
    self updateItemSizes.
    self isHandleOk
        ifTrue:
            [retainScrolling
                ifTrue:
                    [self setTopIndex: firstVis.
                    ]
                ifFalse:
                    ["self
                        invalidateRect: nil;
                        updateWindow."
                    ].
            ].! !

"SP Run Input Field Common (SP2ARFW.SLL)"!
!'CPNumericEditor' osiMethods !  
characterInput: aChar
    "Private"

    aChar ~= Cr
        ifTrue:
            [currentField characterInput: aChar.
            self contents.
            self triggerEvents
            ].

    aChar = Bs
        ifTrue:
            [currentField backspace.
            self contents.
            self triggerEvents.
            ].! !

"SP Run Miscellaneous Common (SP2ARMW.SLL)"!
!'CPSlider' osiMethods !  
button1Down: aPoint
    "Private"

    | nextTime |
    Smalltalk platformIsWin32 ifTrue: [
        (self subpaneButton1Down: aPoint)
            ifFalse: [^self] ].
    self setFocus.
    (self thumbRect containsPoint: aPoint)
        ifTrue:
            [self
                doGraphics:
                    [thumbButtonOrigin := (self
                            dragForm: thumbBitmap
                            origin: thumbButtonOrigin
                            constrainedBy: (self rect insetBy: 2)).
                    ].
            self internalValue: (self pointToValue: thumbButtonOrigin).
            ]
        ifFalse:
            [self button2StillDown: self mouseLocation.
            nextTime := Time millisecondClockValue + 300.
            self
                whileMouseStillDownPrim:
                    [(Time millisecondClockValue >= nextTime)
                        & (self rect containsPoint: self mouseLocation)
                        ifTrue:
                            [self button2StillDown: self mouseLocation.
                            ].
                    ].
            ].
"
            [self internalValue: (self pointToValue: aPoint - (self thumbSize // 2)).
            self whileMouseStillDown: [].
            ].
"! !

"SP Run Input Field Common (SP2ARFW.SLL)"!
!'CPSpinEditor' osiMethods !  
buttonPushedInRect: inRect
method: methodToSend
    "Private"

    | startTime doneOne |
    startTime := Time millisecondClockValue.
    doneOne := false.
    self
        whileMouseStillDownPrim:
            [(doneOne not | (Time millisecondClockValue > (startTime + 300))) & (inRect containsPoint: self mouseLocation)
                ifTrue:
                    [self
                        perform: methodToSend;
                        clearMouseCapture;
                        triggerEvents;
                        captureMouseInput.
                Smalltalk platformIsOS2 ifTrue: [ self redraw ].
                    doneOne := true.
                    ].
            ].! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPTableEditor' osiMethods !  
clearCurrentCell
    "Private"

    | rect region savedSelection |
    savedSelection := selectedCell.
    selectedCell := -100 @ -100.
    self
        textEditor hideWindow;
        resize: self rect.
    "Redraw the cell that had the text editor in it"
    self
        doGraphics:
            [region := self pen setClipRect: self scrollAreaRectangle.
            self
                pen fill: ((rect := self rectForCell: savedSelection) insetBy: 1) color: self backColor;
                drawRectangle: rect.
            self drawCell: savedSelection clipRect: self scrollAreaRectangle.
            self pen destroyRegion: region.
            ].
    selectedCell := savedSelection.! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPTableEditor' osiMethods !  
columns: numColumns
    "Set the total number of columns"

    | size |
    size := totalCells x.
    totalCells x: numColumns.
    (size = numColumns or: [self usesObjects])
        ifTrue: [^self].
    (self sparseStorage or: [cells isNil or: [cells isEmpty]])
        ifFalse: [cells resizeRows: totalCells y columns: totalCells x].
    self isValid
        ifTrue:
            [self
                reframe;
                display]! !

"SP Run Table Common"!
!'CPTableEditor' osiMethods !  
displayRow: anInteger highlight: aBoolean
    "Private - Display the specified row."

    | t b drawRect range hrfColor fColor hrbColor bColor rowsToHighlight |
    drawRect := self rect.
    b := (self headerExtent y up: topCorner y) down: anInteger * cellSize y.
    t := b up: cellSize y.
    ((b isBelow: drawRect top) and: [t isAbove: drawRect bottom]) ifFalse: [ ^self ].

    drawRect := (drawRect left right: self headerExtent x) @ t
        rightBottom:
            (drawRect right leftMost: (self rectForCell: self columns @ anInteger) right) @ b.
    self
        doGraphics:
            [self pen fill: drawRect color: self backColor.
            range := 1 @ anInteger rightBottom: self columns @ anInteger.
            self drawGridIn: range.
            aBoolean ifTrue: [
                hrfColor := self highlightRowForeColor.
                hrbColor := self highlightRowBackColor ].
            (range top max: 1) to: (range bottom min: self rows)
                do:
                    [:r |
                    aBoolean
                            ifTrue: [
                                fColor := hrfColor.
                                bColor := hrbColor ]
                            ifFalse: [
                                fColor := bColor := nil ].
                    (range left max: 1) to: (range right min: self totalCells x)
                        do:
                            [:c |
                            self
                                drawCell: c @ r
                                clipRect: drawRect
                                foreColor: fColor
                                backColor: bColor.
                            ].
                    ].
            "self sendInputEvent: #deferredhighlightCell: with: self selection."
            ].! !

"SP Run Table Common"!
!'CPTableEditor' osiMethods !  
drawCell: aPoint
clipRect: clipRect
foreColor: aForeColor
backColor: aBackColor
    "Private - draw a given cell.  Clipping will be done
     with the intersection of clipRect and the cell's rect."

    | cellRect region text justOffset color bColor font |
    cellRect := self rectForCell: aPoint.
    tempClipRect notNil
        ifTrue: [cellRect := cellRect intersect: tempClipRect].
    text := self cellAt: aPoint.
    justOffset := self justificationOffsetFor: text at: aPoint.
    (color := aForeColor) isNil ifTrue: [ color := self foreColorAt: aPoint ].
    (bColor := aBackColor) isNil ifTrue: [ bColor := self backColorAt: aPoint ].
    font := self fontForColumn: aPoint x.
    self
        doGraphics: [
            region := self pen setClipRect: (cellRect intersect: clipRect).
            bColor = self backColor ifFalse: [
                self pen
                    fill: (cellRect insetBy: (aBackColor isNil ifTrue: [ 2 ] ifFalse: [ 1 ]))
                    color: bColor ].
            self
                pen setTextAlign: TaTop;
                font: font;
                setBackgroundModeTransparent;
                foreColor: color;
                displayText: text at: (cellRect left right: justOffset) @ (cellRect top + ((cellRect height - self font height) // 2));
                foreColor: self foreColor;
                setBackgroundModeOpaque;
                destroyRegion: region.
            ].! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPTableEditor' osiMethods !  
hasFocus
        "Answer true if the receiver or it's text editor has focus."
    | editor |
    ^super hasFocus or: [
        (editor := self textEditor) notNil and: [
            editor hasFocus ] ]! !

"SP Run Table Common"!
!'CPTableEditor' osiMethods !  
rectForRowHeader: row
    "Private"

    | rect point |
    rect := self rectForCell: 1 @ row.
    ^Rectangle leftTop: 0 @ rect top rightBottom: self headerExtent x @ rect bottom! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPTableEditor' osiMethods !  
rowHeaders: headerList
    "Set the row headers"

    rowHeader := headerList.
    (rowHeader notNil and: [self rows < rowHeader size])
        ifTrue:
            [self rows: rowHeader size.
            ].
    self calcHeaderExtent.! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPTableEditor' osiMethods !  
rows: numRows
    "Set the number of rows"

    | size |
    size := totalCells y.
    totalCells y: numRows.
    (size = numRows or: [self usesObjects])
        ifTrue: [^self].
    (self sparseStorage or: [cells isNil or: [cells isEmpty]])
        ifFalse: [cells resizeRows: totalCells y columns: totalCells x].
    self isValid
        ifTrue:
            [self
                reframe;
                display]! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPTablePane' osiMethods !  
basicCellAt: aPoint
    "Private - answer the cell contents at a given point.  Public method is
     basicAtRow:column:, which allows either strings or integer indices."

    | cell selector |
    (cells isNil or: [cells isEmpty]) ifTrue: [^''].
    selector := (columnHeader at: aPoint x) selector.
    self usesObjects
        ifTrue:
            [(aPoint y <= 0 or: [aPoint y > cells size]) ifTrue: [^''].
            selector isNil ifTrue: [ ^'' ].
            ^(cells at: aPoint y) perform: selector ].
    (cell := cells at: aPoint ifAbsent: [nil]) notNil
        ifTrue:
            [selector isNil
                ifTrue: [^cell ]
                ifFalse: [^cell perform: selector ]]
        ifFalse: [^''].! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPTablePane' osiMethods !  
basicChangeAborted
        "The change was aborted."
    ! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPTablePane' osiMethods !  
basicIsOkToChange
        "Answer true if is ok to change."

    super isOkToChange == false ifTrue: [ ^false ].
    ^true! !

"SP Run Table Win32 (SP2ARTW.SLL)"!
!'CPTablePane' osiMethods !  
calcFieldSizes
    "Private - calculate new field sizes"

    | maxWidth result headerHeight field fieldFont object |
    self columnHeaders isNil
        ifTrue: [^self].
    cells isNil
        ifTrue:
            [self initializeCells.
            ].
    totalFieldWidth := 0.
    headerHeight := 0.
    1 to: self columnHeaders size
        do:
            [:index |
            field := self columnHeaders at: index.
            fieldFont := field font isNil ifTrue: [self font] ifFalse: [field font].
            headerHeight := headerHeight max: field headerLineCount * self font height.
            cellSize y: (cellSize y max: fieldFont height + 2).
            field autoFieldWidth
                ifTrue:
                    [maxWidth := self class stringWidth: field header using: self font.
                    1 to: (cells size min: self class maxRowsToAutoSize)
                        do:
                            [:i |
                            object := cells at: i.
                            (self usesObjects)
                                ifTrue:
                                    [result :=  field selector notNil
                                        ifTrue: [object perform: field selector]
                                        ifFalse: [''].
                                    ]
                                ifFalse:
                                    [(object size < index)
                                        ifFalse: [result := object at: index].
                                    ].
                            result isBitmap
                                ifTrue:
                                    [maxWidth := maxWidth max: result width.
                                    self cellSize: self cellSize x @ (self cellSize y max: result height).
                                    ]
                                ifFalse:
                                    [result isString
                                        ifFalse:
                                            [result := result printString.
                                            ].
                                    maxWidth := maxWidth max: (self class stringWidth: result using: fieldFont).
                                    ].
                            ].
                    field fieldPixelWidth: maxWidth + self fieldMargin.
                    ].
            totalFieldWidth := totalFieldWidth + field fieldPixelWidth.
            ].
    headerHeight := headerHeight + self headerMargin.
    showColumnHeader
        ifTrue: [self headerExtent y: headerHeight].! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPTablePane' osiMethods !  
cellAt: aPoint
    "Private - answer the cell at a given point.  Public method is
     rowAt:column:, which allows either strings or integer indices."

    | cell selector |
    (cells isNil or: [cells isEmpty])
        ifTrue: [^''].
    selector := (columnHeader at: aPoint x) selector.
    self usesObjects
        ifTrue:
            [(aPoint y <= 0 or: [aPoint y > cells size])
                ifTrue: [^''].
            ^((cells at: aPoint y) perform: selector) asString].
    (cell := cells at: aPoint ifAbsent: [nil]) notNil
        ifTrue:
            [selector isNil
                ifTrue: [^cell asString]
                ifFalse: [^(cell perform: selector) asString]]
        ifFalse: [^''].! !

"SP Run Table Common"!
!'CPTablePane' osiMethods !  
cellHeight
    "Private - Answer the height of a cell"

    ^super cellHeight + 3   "Add 3 for combo box height"! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPTablePane' osiMethods !  
clearCurrentCell
    "Private"

    | rect region savedSelection |
    savedSelection := selectedCell.
    selectedCell := -100 @ -100.
    self columnHeaders
        do:
            [:column |
            column
                editor hideWindow;
                resize: self rect.
            ].
    "Redraw the cell that had the text editor in it"
    self
        doGraphics: [
            region := self pen setClipRect: self scrollAreaRectangle.
            self
                pen fill: ((rect := self rectForCell: savedSelection) insetBy: 1) color: self backColor;
                drawRectangle: rect.
            self drawCell: savedSelection clipRect: self scrollAreaRectangle.
            self pen destroyRegion: region.
            ].
    selectedCell := savedSelection.! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPTablePane' osiMethods !  
columnHeaders: anOrderedCollection
    "Private"

    | saveSelection |

    saveSelection := selectedCell.
    super columnHeaders: anOrderedCollection.
    1 to: self columnHeaders size
        do:
            [:i |
                (anOrderedCollection at: i) setFont: self font.
            selectedCell := i @ 1.
            self initializeTextEditor: i.
            ].
    selectedCell := saveSelection.
    self calcFieldSizes.
    self isValid
        ifTrue:
            [self
                reframe;
                display]! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPTablePane' osiMethods !  
drawFocusRectForRow: anInteger
        "Private"
    anInteger notNil & self showRowHeader ifTrue: [
        self doGraphics: [
            self pen
                black;
                setBackgroundModeOpaque;
                drawRectangle: (
                    self focusRectForRow: anInteger ) ] ].! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPTablePane' osiMethods !  
editorFramingBlockFor: anEditor
    "Private"

    | rect left |
    ^[:b |
        ((self inVisibleBounds: self selection) not | self isValid not or: [selection])
            ifTrue:
                [10000 @ 10000 extent: 10 @ 10]
            ifFalse:
                [rect := (self rectForCell: self selection) insetBy: anEditor cellInset.
                (rect left isLeftOf: (left := self scrollAreaRectangle left right: 1))
                    ifTrue: [rect := Rectangle leftTop: (left @ rect top) rightBottom: rect rightBottom].
                rect].
        ]! !

"SP Run Table Common"!
!'CPTablePane' osiMethods !  
focusRectForRow: anInteger
        "Private"
    | answer |
    answer :=
        0 @ ((self headerExtent y up: topCorner y) down: (anInteger - 1) * cellSize y + 1)
        extentFromLeftTop:
            (self showRowHeader
                ifTrue: [ self headerExtent x ]
                ifFalse: [ self fullExtent x ]
            ) @ (cellSize y - 1).
    ^answer insetBy: 2.! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPTablePane' osiMethods !  
initializeTextEditor: column
    "Private"

    | justification colHeader |
    super initializeTextEditor: column.
    colHeader := self columnHeaders at: column.
    self textEditor class == EnhancedChildEntryField ifTrue: [
        justification := colHeader justification.
        justification == #right
            ifTrue:
                [self textEditor addStyle: EsRight.
                ]
            ifFalse:
                [justification == #center
                    ifTrue: [
                        self textEditor addStyle: EsCenter.
                        ]]].
    self textEditor
        font: colHeader font;
        field: colHeader validation;
        character: colHeader character;
        setPopupMenu: colHeader menu;
        getFocus: #yourself.
    colHeader isReadOnly ifTrue: [
        self textEditor readOnly ].! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPTablePane' osiMethods !  
isOkToChange
        "Private"
    | array |
    array := self propertyAt: #selectionChanged ifAbsent: [ nil ].
    array notNil ifTrue: [
        self textEditor notNil ifTrue: [
            self textEditor cellValidate ifFalse: [
                self basicChangeAborted.
                ^false ] ].
        [ self triggerCellAboutToChangeAt: (array at: 1) value: (array at: 3) ]
            on: VetoAction do: [
                self basicChangeAborted.
                ^false ].
        self textEditor notNil ifTrue: [
            self textEditor hideWindow ] ].
    self basicIsOkToChange ifFalse: [
        self basicChangeAborted.
        ^false ].
    self commitChange.
    ^true! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPTablePane' osiMethods !  
losingFocus
        "Hide the heavy cell outline."

    self hasFocus ifTrue: [ ^self ].
    self isOkToChange ifFalse: [ ^self setFocus ].

    self unHighlightCell: selectedCell.
    self rowWithFocus notNil ifTrue: [ self redrawRowHeader: self rowWithFocus ].
    self commitChange.
    super losingFocus.
    self isHandleOk ifTrue: [
        selectedCell notNil ifTrue: [
            self drawGridIn: (selectedCell rightBottom: selectedCell + 1) ] ].! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPTablePane' osiMethods !  
needsKeyUpInput
        "Private - Answer true if the receiver processes key-up events."
    ^true! !

"SP Run Table Common"!
!'CPTablePane' osiMethods !  
rectForHeader: column
    "Private"

    | rect point |
    rect := self rectForCell: (self columnHeaders indexOf: column) @ 1.
    ^Rectangle leftTop: rect left + 1 @ 0 "self rect top" rightBottom: rect right - 1 @ (0 "self rect top" down: self headerExtent y)! !

"SP Run Table Common"!
!'CPTablePane' osiMethods !  
redrawRow: anInteger
        "Invalidate the specified row."
    | t b r |
    r := self rect.
    b := (self headerExtent y up: topCorner y) down: anInteger * cellSize y.
    t := b up: cellSize y.
    ((b isBelow: r top)
        and: [t isAbove: r bottom])
            ifTrue: [
                self invalidateRect: (
                    r left @ t rightBottom: r right @ b)].! !

"SP Run Table Common"!
!'CPTablePane' osiMethods !  
redrawRowHeader: anInteger
        "Invalidate the specified row header."
    | t b r |
    r := self rect.
    b := (self headerExtent y up: topCorner y) down: anInteger * cellSize y.
    t := b up: cellSize y.
    ((b isBelow: r top)
        and: [t isAbove: r bottom])
            ifTrue: [
                self invalidateRect: (
                    r left @ t rightBottom: (r left right: self headerExtent x) @ b)].! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPTablePane' osiMethods !  
selectRows: aCollection
        "Set the collection of selected rows."
    | range old new highlight |
    self isHandleOk ifTrue: [
        selectedRows isNil & aCollection isNil ifFalse: [
            selectedRows isNil ifTrue: [
                "self isOkToChange = false ifTrue: [ ^self ]."
                self hasFocus ifTrue: [
                    self textEditor hideWindow.
                    self unHighlightCell: selectedCell.
                    self setFocus ] ].
            range := self cellsToDraw.
            (old := selectedRows) isNil ifTrue: [ old := #( ) ].
            (new := aCollection) isNil ifTrue: [ new := #( ) ].
            (range top max: 1) to: (range bottom min: self rows) do: [ :rowNum |
                highlight := new includes: rowNum.
                ((old includes: rowNum) xor: highlight)
                    ifTrue: [ self displayRow: rowNum highlight: highlight ] ] ].
            aCollection isNil ifTrue: [
                self hasFocus ifTrue: [
                    self rowWithFocus: nil.
                    self highlightCell: selectedCell.
                    (self isReadOnly: selectedCell) ifFalse: [
                        self textEditor showWindow; setFocus ].
                ] ifFalse: [ self rowWithFocus: nil ] ] ].
    selectedRows := aCollection.! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPTablePane' osiMethods !  
setPopupMenu: aMenu
    "Set the default popup menu of the table"

    self isHandleOk
        ifTrue: [
            super setPopupMenu: aMenu.
            self columnHeaders
                do:
                    [:header |
                    header editor popupMenu isNil
                        ifTrue: [header editor setPopupMenu: self popupMenu]]]
        ifFalse: [self whenValid: #setPopupMenu: with: aMenu].! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'CPTablePane' osiMethods !  
usesObjects: aBoolean
    "Set the table to object mode or not"

    usesObjects := aBoolean.
    self initializeCells.! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'EnhancedChildEntryField' osiMethods !  
button2Up: aPoint
        "Private - pass to the parent."

    ^(self superWindow hasActionForEvent: #rightClicked)
        ifTrue: [self superWindow triggerRightClickedEventFromChild: aPoint]
        ifFalse: [super button2Up: aPoint].! !

"SP Run Table Win32 (SP2ARTW.SLL)"!
!'EnhancedChildEntryField' osiMethods !  
cellInset
        "Answer the # of pixels to inset the receiver's frame
            when used in a CPTablePane."

    ^3! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'EnhancedChildEntryField' osiMethods !  
characterInput: aCharacter
        "Perform row selection if read only."
    aCharacter = Cr ifTrue: [
        self cr.
        ^true ].
    self isReadOnly ifTrue: [
        ^self superWindow characterInput: aCharacter ].
    ^super characterInput: aCharacter! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'EnhancedChildEntryField' osiMethods !  
clearAnchor
        "Private - Pass to parent."
    self superWindow clearAnchor.! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'EnhancedChildEntryField' osiMethods !  
cr
        "Send the message to the parent."
    self superWindow cr.! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'EnhancedChildEntryField' osiMethods !  
gettingFocus
        "Pass to the parent."
    self hasFocus ifTrue: [
        self superWindow isCellSelectMode
            ifTrue: [
                self superWindow highlightSelectedCell.
                self isReadOnly ifFalse: [ self showWindow; selectAll ].
                super gettingFocus ]
            ifFalse: [
                self hideWindow.
                self superWindow setFocus ] ].! !

"SP Run Table Common (SP2ARTW.SLL)"!
!'EnhancedChildEntryField' osiMethods !  
needsKeyUpInput
        "Private - Answer true if the receiver processes key-up events."
    ^true! !

"SP Run Input Field Common (SP2ARFW.SLL)"!
!'SpinField' osiMethods !  
display
    "Private"

    parent isHandleOk ifFalse: [ ^self ].
    parent
        doGraphics:
            [self
                    displayAt: 0 @ 0
                    with: parent pen
                    clipRect: nil].! !
  
"--------- remove temporary methods"!

String removeSelector: #osiMethods !
String removeSelector: #osiMethods: !
String removeSelector: #osiEvaluateIfError: !
String removeSelector: #osiRemoveSelector: !
String removeSelector: #fileInFrom: !
String removeSelector: #osisubclass:instanceVariableNames:classVariableNames:poolDictionaries: !
String removeSelector: #osisubclass:instanceVariableNames:classVariableNames:poolDictionaries:ifDefined: !

