05/04/95 02:04:48 PM

isDisabled: ignore
    "Private"

    ^false!  
selectionChanged: aString pane: aPane
    "Private - the textPane changed, and is notifying us.
        Save the change internally in an Array with 3 items:
        1 - cell coordinates
        2 - original cell contents
        3 - new cell contents"

    | new array |
    aPane == self textEditor ifFalse: [ ^self ].

    new := aPane cellContents.
    array := self propertyAt: #selectionChanged ifAbsent: [
        self propertyAt: #selectionChanged put: (
            array := Array
                with: self selection
                with: (self basicCellAt: self selection)
                with: nil ) ].

    "If the array contains a cell coordinate other than the
        current, then we forgot to commit a change..."
    self selection = array first ifFalse: [
        Smalltalk isRunTime ifFalse: [
            self error: 'change not committed: ', array first asString ] ].

    new = (array at: 2)
        ifTrue: [ self propertyAt: #selectionChanged put: nil ]
        ifFalse: [ array at: 3 put: new ].

    super selectionChanged: aString pane: aPane!
backColor
    "Private"

    ^backColor!   
name: aString

    name := aString.!
textEdit: aBoolean
    "Private"

    textEdit := aBoolean.!   
validation
    "Private"

    ^validation! 
wmKeydown: wordInteger with: longInteger
        "Private - Process the key down message."
    | answer |
    answer := super wmKeydown: wordInteger with: longInteger.
    (self shouldProcess: wordInteger controlKey: Notifier isControlKeyDown) ifTrue: [ ^answer ].
    ^true!  
button1Down: aPoint
    "Private - Handle changing the selection."

    | savedSelection point editor rect savedCorner region |
    "Move the text editor off the screen temporarily so it won't be a
     nuisance during scrolling"
    point := self cellForPoint: aPoint.
    (point = selectedCell)
        ifTrue:
            [self highlightCell: selectedCell.
            ^nil].
    "self propertyAt: #disableRepaint put: true."
    savedSelection := selectedCell.
    savedCorner := topCorner copy.
    (editor := self textEditor) hideWindow.
    selectedCell := -100 @ -100.
    self reframeEditors.
    "Redraw the cell that had the text editor in it"
    self doGraphics: [
        region := self pen setClipRect: self scrollAreaRectangle.
        self pen fill: ((rect := self rectForCell: savedSelection) insetBy: 1) color: self backColor.
        self showGrid
            ifTrue: [self pen foreColor: self foreColor]
            ifFalse: [self pen foreColor: self backColor].
        self pen rectangle: rect.
        self drawCell: savedSelection clipRect: self scrollAreaRectangle.
        self pen destroyRegion: region ].
    selectedCell := savedSelection.
    super button1Down: aPoint.
    self propertyAt: #disableRepaint put: false.
    (savedCorner x ~= topCorner x and: [savedCorner y ~= topCorner y])
        ifTrue: [self display].
    self reframeEditors.
    self isCellSelectMode ifTrue: [
        (self isReadOnly: selectedCell) ifFalse: [
            self
                textEditor showWindow;
                setFocus ] ].
    self triggerClickedEvent.!   
disabled: aBooleanOrSelector
    "Private"

    disabled := aBooleanOrSelector!
contents: aList
    "Set the contents of the listbox"

	"During validation, stuff the list into the OS structure..."
	list == aList ifTrue: [ ^super contents: list ].

    (aList isKindOf: OrderedCollection)
        ifFalse:
            [objectList := OrderedCollection
                with:
                    (self nodeClass new
                        object: aList
                        owner: self
                        parent: nil).
            ]
        ifTrue:
            [objectList := aList
                collect:
                    [:object |
                    self nodeClass new
                            object: object
                            owner: self
                            parent: nil].
            ].
    self updateListBox: false.! 
deferChildren: aBoolean
    "Defer loading a nodes children until it is exposed or not"

    deferChildren := aBoolean!
cellContents: anObject

    | index |
    (index := self indexOf: anObject) = 0 | index isNil
        ifTrue: [ self text: (self stringForItem: anObject) ]
        ifFalse: [ self selectIndex: index ].!   
isCellSelectMode: aBoolean
        "Private"
    self selectionMode = #cell ifFalse: [
        aBoolean
            ifTrue: [ self selectRowsAndTriggerEvent: nil ]
            ifFalse: [
                self basicSelectedRows isNil
                    ifTrue: [ self selectRowsAndTriggerEvent: #( ) ] ] ].! 
headerExtent
    "Private - answer how big the header is"

    self showHeader
        ifTrue: [^0 @ headerHeight]
        ifFalse: [^0 @ 0].!   
arrowKeysEdit
    "Set the style such that the arrow keys move with a cell"

    self propertyAt: #cpStyle put: #arrowKeysEdit.!   
columnHeaderClicked
    "Private"

    ^self fieldToReorderForPoint: self mouseLocation!   
isCompatibleDragObject: aDragObject
    "Private - Is <aDragObject> compatible with the receiver"

	| anObject |
	aDragObject hasObject ifFalse: [ ^false ].
	anObject := aDragObject object.
    self columnHeaders
        do:
            [:column |
            (anObject respondsTo: column selector)
                ifFalse: [^false]].
    ^true!  
needsKeyUpInput
        "Private - Answer true if the receiver processes key-up events."
    ^true! 
rectForCell: cell
    "Private Answer the rectangle that completely encompasses the
     cell. This will include a one pixel border all the way
     around the cell."

    | point |
    point := self pointForCell: cell.
    ^Rectangle leftTop: point extent: (self pixelCellWidth: cell x) @ self cellSize y + 1! 
graphicsTool
        "Private - Answer the receiver's graphics tool."
    graphicsTool isNil ifTrue: [ graphicsTool := self getGraphicsTool ].
    ^graphicsTool!  
button1DoubleClick: aPoint
        "Private - pass to the parent."

    self superWindow button1DoubleClick: aPoint.!  
stringWidth: aString
using: aFont
    "Private"

    | width string |
    width := 0.
    string := ReadStream on: aString.
    [string atEnd]
        whileFalse:
            [width := width max: (aFont wbStringWidth: (string upTo: Lf)).
            ].
    ^width!   
buildWindow: parentWindow
    "Private - Subclassed to avoid the initial MDI display problem if the entry field is a child
     of another subpane.   Changed the origin of the rectangle to be outside the
     visible area"

    | ps parentFont |
    style isNil
        ifTrue: [style := self frameStyle].
    self
            create: self windowClass
            title: self initialText
            style: style
            rectangle: (10000 @ 10000 extent: 0 @ 0)
            parent: self parent.
    handle = NullHandle
        ifTrue: [^nil].
    curFont isNil
        ifTrue:
            [curFont := (parentFont := parent font) isNil
                ifTrue: [self defaultFont]
                ifFalse: [parentFont]].
    self initGraphics.
    self receiveMessages.
    children size ~= 0
        ifTrue:
            [self childrenInBuildOrder
                do:
                    [:each |
                    (each buildWindow: self) isNil
                        ifTrue:
                            [self close.
                            ^nil]]].
    self buildControl: parentWindow.
    self receiveAllWindowMessages!   
bitmapForHeader: aField in: aRectangle
    "Answer the bitmap for the specified header."

    | answer m r |
    m := self fieldMargin @ self headerMargin.
    r := (0 @ 0 rightAndDown: m // 2) extentFromLeftTop: (aRectangle extent - m).
    (answer := Bitmap screenExtent: aRectangle extent)
        pen
            fill: answer boundingBox color: Color white;
            font: self font;
            setTextAlign: TaTop;
			setBackgroundMode: 1; "BackgroundMixTransparent"
            winDrawText: aField header
                in: r format: aField windowsJustification.
    ^answer!  
fieldToResizeForPoint: aPoint
    "Private"

    | x offset |
    offset := topCorner x + aPoint x.
    x := self leftMargin - (self fieldMargin // 2).
    ^fields
        detect:
            [:field |
            x := x + field fieldPixelWidth + self fieldMargin.
            offset between: x - 2 and: x + 2]
        ifNone: [nil].! 
defaultCellWidth
    "Private"

    ^10!   
iconHeight
    "Private"

    | icon |
    (icon := self icon) notNil
        ifTrue: [^icon height]
        ifFalse: [^0].!
listAt: aPoint
        "Private"
    | answer cell |
    aPoint notNil ifTrue: [
        columnHeader notNil ifTrue: [
            answer := (columnHeader at: aPoint x) list ].
        answer isSymbol ifTrue: [
            (aPoint y between: 1 and: self rows) ifTrue: [
                answer := self usesObjects
                    ifTrue: [
                        (aPoint y between: 1 and: cells size)
                            ifTrue: [(cells at: aPoint y) perform: answer]
                            ifFalse: [nil]]
                    ifFalse:
                        [cell := cells at: aPoint ifAbsent: [nil].
                        (cell isNil or: [cell isString])
                            ifFalse: [cell perform: answer]
                            ifTrue: [nil]]
            ] ifFalse: [ answer := nil ]].
        answer isIndexedCollection & answer isString not
            ifFalse: [ answer := nil ]].
    answer isNil ifTrue: [ answer := #( ) ].
    ^answer!  
wmGetdlgcode: wParam
with: lParam
    "Private"

    ^DlgcWantallkeys!
triggerClickedEvent
        "Private"
    self event: #clicked. " OBSOLETE "
    self triggerEvent: #clicked: with: self selection.!   
setTopCell: aCell
    "Private"

    | newTop |
    newTop := (aCell - 1) * self cellSize.
    newTop x: (self rectForCell: aCell) left - self headerExtent x + topCorner x.
    self scrollTopCorner: topCorner - newTop.
    self inWindowBuilder
        ifTrue: [^self].
    self updateVerticalSlider.
    self updateHorizontalSlider.!   
button1Down: aPoint
    "Private"

    | field row reordered |

    (self isPointInHeader: aPoint)
        ifTrue:
            [reordered := false.
          (self canResize and: [(field := self fieldToResizeForPoint: aPoint) notNil])
                ifTrue: [^self resizeField: field start: aPoint].
            (self canReorder and: [(field := self fieldToReorderForPoint: aPoint) notNil])
                ifTrue: [reordered := self reorderField: field start: aPoint].
            reordered
            ifFalse: [self triggerColumnClickedEvent: (self fieldToReorderForPoint: aPoint)]
            ]
        ifFalse:
            [(self isPointInRowHeader: aPoint)
                ifTrue: [
                    (self canReorderRows and: [
                        (row := self rowToReorderForPoint: aPoint) notNil and: [
                            self reorderRow: row start: aPoint
                            ]
                        ])
                    ifFalse: [
                        self selectionMode = #cell ifFalse: [
                            self isOkToChange = false ifTrue: [ ^self ].
                            self isCellSelectMode: false.
                            self button1DownRowSelect: aPoint]].
                    self triggerRowClickedEvent
                    ]
                ifFalse:
                    [
                    (self selectionMode ~= #cell
                    and: [ self isReadOnly: (self cellForPoint: aPoint) ])
                        ifTrue: [
                            self isOkToChange = false ifTrue: [ ^self ].
                            self isCellSelectMode: false.
                            self button1DownRowSelect: aPoint]
                        ifFalse: [
                            self isCellSelectMode: true.
                            super button1Down: aPoint.
                            self triggerCellClickedEvent: aPoint.
                            ]]].! 
usesObjects
    "Private"

    ^false! 
keepCellVisible: aCell
    "Private"

    | savedSelection answer |
    "Prevent the selection from drawing, since we'll be highlighting
     the item after scrolling"
    self isHandleOk ifFalse: [ ^false ].
    answer := false.
    aCell isNil
        ifFalse:
            [savedSelection := selectedCell.
            selectedCell := nil.
            answer := super keepCellVisible: aCell.
            selectedCell := savedSelection.
            ].
    ^answer!   
characterInput: aCharacter
		"Private - Process the character input."
	aCharacter = Cr ifTrue: [ ^self cr ].
	^super characterInput: aCharacter!   
selection: anItem
    "Set the selection of the listbox to anItem"

    | oldCell |
    anItem isNil
        ifTrue:
            [selectedCell notNil & self isValid
                ifTrue:
                    [self invalidateRect: (self rectForCell: selectedCell).
                    self updateRectangle.
                    ].
            ^selectedCell := nil].
    anItem isInteger
        ifTrue:
            [oldCell := selectedCell.
            selectedCell := 1 @ ((anItem max: 0) min: objects size).
            oldCell = selectedCell
                ifTrue: [^self].
            self doGraphics: [
                self isValid
                    ifTrue:
                        [oldCell notNil
                            ifTrue:
                                [self unHighlightCell: oldCell.
                                ].
                        selectedCell notNil
                            ifTrue:
                                [self highlightCell: selectedCell.
                                ].
                        self keepSelectionVisible.
                        ]].
            ]
        ifFalse:
            [self selection: (objects indexOf: anItem).
            ].! 
crShift
    "Private - process a carriage return from the text editor"

    | newSel oldSel |
    (self selection = (1 @ 1))
        ifTrue: [^self].
    newSel := self selection x @ (self selection y - 1 max: 1).
    newSel := self
            nextValidCell: newSel
            upDown: true
            downRight: false.
    newSel = self selection
        ifTrue:
            [oldSel := selectedCell.
            newSel := selectedCell := (self selection x - 1 max: 1) @ self rows.
            newSel := selectedCell := self
                    nextValidCell: newSel
                    upDown: false
                    downRight: false.
            newSel := self
                    nextValidCell: newSel
                    upDown: true
                    downRight: false.
            selectedCell := oldSel.
            selectedCell x = newSel x
                ifTrue: [^self]].
    newSel := newSel min: self columns @ self rows.
    (self isDisabled: newSel)
        ifFalse:
            [self selection: newSel.
			self triggerCrEvent.
            ].!   
dragTargetOperationForSelf: dragSession
		"Answer the operation when source = target = self."
	| index start end |
	(self dragTargetOperations includes: #move) ifFalse: [ ^nil ].
	index := self itemIndexFromPoint: dragSession targetLocation.
	start := self dragSourceSelection.
	end := start + (list at: start) asFlatList size - 1.
	(index between: start and: end) ifTrue: [ ^nil ].
	^#move!   
name

    name isNil ifTrue: [ ^'' ].
    ^name!   
totalLength
    "Private - Answer the height of the receiver's graphics medium."

    ^self fullExtent y!  
wmKeydown: wordInteger with: longInteger
        "Private - Process the key down message."
    | answer |
    answer := super wmKeydown: wordInteger with: longInteger.
    (self superWindow shouldProcess: wordInteger controlKey: Notifier isControlKeyDown) ifTrue: [ ^answer ].
    ^true!  
collapsedString
    "Private"

    (self collapsed & children notNil and: [children notEmpty])
        ifTrue: [^'...']
        ifFalse: [^''].! 
scrollBarHeight
    "Private"

    ^UserLibrary getSystemMetrics: SmCyhscroll! 
needsKeyUpInput
        "Private - Answer true if the receiver processes key-up events."
    ^true! 
flatList
    "Private"

    | flatList |
    flatList := OrderedCollection new.
    objectList
        do:
            [:o |
            flatList addAll: o asFlatList.
            ].
    ^flatList!   
losingFocus
        "Private - Hide the window when losing focus."

    self hasFocus ifFalse: [
        self hideWindow.
        super losingFocus.
        self superWindow losingFocus ].!   
asFlatList
    "Private"

    | list |
    list := OrderedCollection new.
    list add: self.
    self collapsed
        ifTrue: [^list].
    children notNil
        ifTrue:
            [children
                do:
                    [:child |
                    list addAll: child asFlatList].
            ].
    ^list!
initialize: anObject
    "Set all of the elements to anObject"

    self
        iterate:
            [:row :column |
            self
                    atRow: row
                    column: column
                    put: anObject].!
showFocusInCell: aCell
color: ignored
    "Private"

    | y width |
    aCell isNil
        ifTrue: [^self].
    y := (self pointForCell: aCell) y.
    (self isCellVisible: aCell)
        ifFalse: [^self].
    width := self totalCells x * self cellSize x max: self rectangle width.
    self doGraphics: [self pen drawFocusRect: (topCorner x negated @ y rightBottom: width @ (y + self cellSize y))].!   
buildControl: parentWindow
    "Private - Create the control for the receiver."

    super buildControl: parentWindow.
    horizontalExtent notNil
        ifTrue:
            [self setHExtent: horizontalExtent.
            ].! 
supportsDragDropObjects
    "Added by OSI - does the receiver support receiving full
     objects in a drag/drop transfer"

    #obsoleteMethod.
    ^true!  
owner
    "Private"

    ^owner!   
rectForHeader: anInteger
	    "Private"
    | rect point |
    rect := self rectForCell: anInteger @ 1.
    ^Rectangle
		leftTop: rect left + 1 @ 0 "self rect top"
		rightBottom: rect right - 1 @ (0 "self rect top" down: self headerExtent y)!  
sortOn: column
ascending: aBoolean
    "Sort the matrix on the specified column index."

    | selector |

    column = 0 ifTrue: [^self].  "in the row header column"
    self isCellSelectMode ifFalse: [ self selectRowsAndTriggerEvent: #( ) ].

    "The following is the superclass's version,
        with contentsNoResize instead of contents:"
    self sparseStorage
        ifTrue: [^self].
    selector := (columnHeader at: column) selector.
    self usesObjects
        ifTrue:
            [self
                contentsNoResize:
                    (aBoolean
                    ifTrue:
                        [(self contents
                            asSortedCollection:
                                [:a :b |
                                (a perform: selector) asString <= (b perform: selector) asString])]
                    ifFalse:
                        [(self contents
                            asSortedCollection:
                                [:a :b |
                                (a perform: selector) asString >= (b perform: selector) asString])]) asOrderedCollection]
        ifFalse:
            [self contentsNoResize: (self contents sortOn: column ascending: aBoolean)].
    self
        selection:
            (self
                nextValidCell:
                    (self
                    nextValidCell: self selection
                    upDown: true
                    downRight: true)
                upDown: true
                downRight: false)! 
disableMethod
    "Answer aSymbol or nil, the message selector that will be sent to
    each object in the list to determine whether to disable the cell. If nil,
    it is enabled."

    ^disableMethod!   
cellContents: aString

    self contents: aString.! 
toggleSelectRows: aCollection
        "Toggle the selection of the specified rows."
    selectedRows class = Set ifFalse: [
        self selectRows: (
            selectedRows isNil
                ifTrue: [ Set new ]
                ifFalse: [ selectedRows asSet ] ) ].
    aCollection do: [ :each |
        (selectedRows includes: each)
            ifTrue: [ selectedRows remove: each ]
            ifFalse: [ selectedRows add: each ].
        self redrawRow: each ].! 
defaultColumns
    "Private"

    ^3!  
backColorAt: aPoint
        "Private"
    | color |
    (self isDisabled: aPoint) ifTrue: [
        color := self disabledBackColor ].
    color isNil ifTrue: [
        color := self basicBackColorAt: aPoint ].
    color isNil ifTrue: [
        color := self backColor ].
    ^color!  
exposedRectangle
    "Private - Answer the rectangle that needs to be drawn"

    self inWindowBuilder
        ifTrue: [^self wbDisplayRectangle].
    ^self currentClipRect!
scrollHorizontal: scrollAmount
    "Private - Scroll the pane right by anInteger
      number of pixels (if positive) or left by
      the absolute value of anInteger (if negative)."

    self scrollTopCorner: scrollAmount @ 0!  
list: aCollectionOrSelector
    "Private"

    list := aCollectionOrSelector.! 
currentRow
        "Answer the row with focus."
    self isCellSelectMode
        ifTrue: [ ^selectedCell y ]
        ifFalse: [ ^self rowWithFocus ]!
defaultHeaderColor
    "Private"

    ^Color white!
cellList: aCollection
        "Ignored"! 
justificationOffsetFor: aString
    "Private - Answer the offset within the field that the
     text should start displaying at for correct justification"

    | offset width |
    (justification = #left)
        ifTrue:
            [offset := 0.
            ]
        ifFalse:
            [aString isBitmap
                ifTrue: 
                    [width := aString width 
                    ]
                ifFalse: 
                    [width := self font wbStringWidth: aString 
                    ].
            (justification = #right)
                ifTrue:
                    [offset := self fieldPixelWidth - width.
                    ]
                ifFalse:
                    [offset := self fieldPixelWidth - width // 2.
                    ].
            ].
    ^offset!   
usesObjects
    "Answer whether the table pane stores objects or not. The default value is true.
    A false value indicates that the table pane stores a matrix of strings."

    ^usesObjects!  
redrawRow: anInteger
        "Invalidate the specified row."
    | t b r |
    r := self rect.
    b := (self headerExtent y up: topCorner y) down: anInteger * cellSize y.
    t := b up: cellSize y.
    ((b isBelow: r top)
        and: [t isAbove: r bottom])
            ifTrue: [
                self invalidateRect: (
                    r left @ t rightBottom: r right @ b)].! 
isDisabled: item
    "Answer whether the item is disabled"

    item isNil
        ifTrue: [^true].
    self disableMethod notNil
        ifTrue:
            [^item isPoint
                ifTrue:
                    [item y > objects size
                        ifTrue: [^true].
                    (objects at: item y) perform: self disableMethod]
                ifFalse:
                    [item perform: self disableMethod]].
    ^false!
triggerCellClickedEvent: aPoint
    "Private - if aPoint is within a non-header cell, trigger the
    cellClicked: event with the cellCoordinates as an argument."

    | validatedCell |
    validatedCell := self validatedCellForPoint: aPoint.
    (validatedCell x > 0 and: [validatedCell y > 0])
        ifTrue:
            [self event: #cellClicked. " OBSOLETE "
            self triggerEvent: #cellClicked: with: validatedCell]!   
selectedRows
        "Answer the collection of selected rows."
    selectedRows isNil ifTrue: [ ^#( ) ].
    ^selectedRows!
triggerDoubleClickEvent: aPoint
    "Private - Trigger
        #doubleClickSelect:
    and, if the cursor was on a non-header cell, trigger
        #doubleClickedAt: aCellCoordinate with: cellContents"

    | cell |
    super triggerDoubleClickEvent.    "doubleClickSelect:"
    cell := self validatedCellForPoint: aPoint.
    self triggerDoubleClickedAtValueEvent: cell.    "doubleClickedAt:value:"! 
moveColumn: column1
to: target
    "Move the values in column1 to column2. Other columns should
     shift left or right based on their positions"

    | cell column2 |
    column2 := target min: self first size.
    1 to: self size do: [ :row |
        cell := self at: column1 @ row.
        column1 > column2
            ifTrue: [
                column1 to: column2 + 1 by: -1 do: [ :i |
                    self at: i @ row put: (self at: (i - 1) @ row)]]
            ifFalse: [
                column1 to: column2 - 1 do: [ :i |
                    self at: i @ row put: (self at: (i + 1) @ row)]].
        self at: column2 @ row put: cell].!  
calcHeaderExtent
    "Private - Recalculate the headerExtent (based on the font and
     whether we're showing rows/column headers)"

    | max x y string item |
    showRowHeader
        ifTrue:
            [(self usesObjects and: [self labelMethod notNil and: [cells notNil]])
                ifTrue:
                    [max := 0.
                    1 to: (cells size min: self class maxRowsToAutoSize)
                         do:
                            [:i |
                            item := cells at: i.
                            max := (self font wbStringWidth: (item perform: self labelMethod)) max: max.
                            ].
                    x := max.
                    ]
                ifFalse:
                    [rowHeader notNil
                        ifTrue:
                            [max := 0.
                            rowHeader
                                do:
                                    [:s |
                                    max := (self font wbStringWidth: s) max: max.
                                    ].
                            x := max.
                            ]
                        ifFalse:
                            [string := String new: self rows printString size.
                            string atAllPut: $0.
                            x := self font wbStringWidth: string]].
            "Make sure it looks at minimum proportional to columnheader"
            x := x + (self rowHeaderMargin * 2) max: self font height + (self rowHeaderMargin * 2).
            ]
        ifFalse:
            [x := 0.
            ].
    showColumnHeader
        ifTrue:
            [y := self font height + (self columnHeaderMargin * 2).
            ]
        ifFalse:
            [y := 0.
            ].
    headerExtent := x @ y.!  
rows
    "Answer the number of rows in the table pane."

    (self usesObjects and: [self inWindowBuilder not])
        ifTrue: [^cells size].
    ^totalCells y!
losingFocus
    "Private"

    self hideFocus.
    super losingFocus.!
defaultStyle
    "Private - Answer the default style for the receiver."

    ^EsAutohscroll | WsVisible | WsChild! 
scrollableRectangle
    "Private - Answer the rectangular area that can be scrolled
     (i.e. the full area - the visible area)"

    | scrollExtent |
    scrollExtent := (self totalCells * self cellSize) - self scrollAreaRectangle extent max: 0 @ 0.
    scrollExtent := ((scrollExtent x + self cellSize x - 1) truncateTo: self cellSize x) @ ((scrollExtent y + self cellSize y - 1) truncateTo: self cellSize y).
    ^0 @ 0 extent: scrollExtent.! 
basicBackColorAt: aPoint
        "Private"
    | color cell |
    aPoint notNil ifTrue: [
        columnHeader notNil ifTrue: [
            color := (columnHeader at: aPoint x) backColor ].
        color isSymbol ifTrue: [
            color := self cellAt: aPoint perform: color ifFail: [ nil ]]].
    color isNil ifTrue: [
        color := super basicBackColorAt: aPoint ].
    ^color!  
object: anObject
owner: anOwner
parent: aParent
    "Private"

    object := anObject.
    self owner: anOwner.
    self parent: aParent.
    self initialStateMethod notNil
        ifTrue: [self collapsed: (self transact: [object perform: self initialStateMethod])].
    (self deferChildren and: [self parent notNil and: [self parent collapsed]])
        ifFalse:
            [self getChildren.
            ].!   
highlightClipRect
    "Private - Answer the cliprect used in drawing highlights.  If they drew
    a header separator line, we want to prevent it from being drawn
     over. This will be true if headerExtent is non zero"

    ^self scrollAreaRectangle! 
columnHeaderFor: column
    "Private"

    ^self columnHeaders at: column! 
altDownInWmChar: wordInteger with: longInteger
        "Private - Commit the change first..."
    ^self superWindow altDownInWmChar: wordInteger with: longInteger! 
displayItem: anItem
inRect: aRect
highlight: aBoolean
    "Private - display a particular item, using aRect as the
     rectangle in which to draw"

    | startX endX startY displayX result pen region clipRect color saveColor scrollRect exposedRect |
    startX := aRect left right: self leftMargin.
    pen := self pen.
    saveColor := pen foreColor.
    scrollRect := Rectangle leftTop: (self rect leftTop down: self headerExtent y) rightBottom: self rect rightBottom.
    exposedRect := self exposedRectangle.
    fields
        do:
            [:field |
            field setFont: self font.
            endX := startX + field fieldPixelWidth + self fieldMargin.
            (startX isLeftOf: exposedRect right) & (endX isRightOf: exposedRect left)
                ifTrue:
                    [field selector isNil
                        ifTrue:
                            [result := nil]
                        ifFalse:
                            [result := anItem perform: field selector.
                            ].
                    result isNil
                        ifFalse:
                            [result isBitmap
                                ifTrue:
                                    [startY := aRect top down: ((aRect height - result height) // 2).
                                    displayX := startX + (field justificationOffsetFor: result).
                                    clipRect := (startX - (self fieldMargin // 2) @ scrollRect top extentFromLeftTop: (field fieldPixelWidth + (self fieldMargin // 2) @ scrollRect height)).
                                    region := self pen setClipRect: clipRect.
                                    result displayAt: displayX @ startY with: pen.
                                    self pen destroyRegion: region.
                                    ]
                                ifFalse:
                                    [result isString
                                        ifFalse:
                                            [result := result printString.
                                            ].
                                    startY := aRect top down: ((aRect height - self font basePoint y) // 2) - 2.
                                    displayX := startX + (field justificationOffsetFor: result).
                                    clipRect := (startX - (self fieldMargin // 2) @ scrollRect top extentFromLeftTop: (field fieldPixelWidth + (self fieldMargin // 2) @ scrollRect height)).
                                    tempClipRect notNil
                                        ifTrue:
                                            [clipRect := tempClipRect intersect: clipRect.
                                            ].
                                    region := self pen setClipRect: clipRect.
                                    pen font: (field font isNil ifTrue: [self font] ifFalse: [field font]).
                                    (self isDisabled: anItem)
                                        ifTrue:
                                            [pen foreColor: Color darkGray]
                                        ifFalse:
                                            [aBoolean
                                                ifTrue:
                                                    [pen foreColor: (UserLibrary getSysColor: ColorHighlighttext)]
                                                ifFalse:
                                                    [(self colorMethod notNil and: [(color := anItem perform: self colorMethod) notNil])
                                                        ifTrue: [pen foreColor: color]
                                                        ifFalse: [pen foreColor: self foreColor]]].
                                    pen displayText: result at: displayX @ (startY down: self font basePoint y).
                                    self pen destroyRegion: region.
                                    pen foreColor: saveColor.
                                    ].
                            ].
                    ].
            startX := endX.
            self showLines
                ifTrue:
                    [self
                        pen foreColor: self foreColor;
                        lineFrom: startX - (self fieldMargin // 2) @ aRect top to: startX - (self fieldMargin // 2) @ aRect bottom;
                        foreColor: saveColor.
                    ].
            ].!   
bitmapForHeader: aField in: aRectangle
    "Private - answer the bitmap for the specified header."

    | answer m r |
    m := self fieldMargin @ self headerMargin.
    r := (0 @ 0 rightAndDown: m // 2) extentFromLeftTop: (aRectangle extent - m).
    self doGraphics: [
        (answer := Bitmap screenExtent: aRectangle extent)
            pen
                fill: answer boundingBox color: Color white;
                font: self font;
                setBackMode: Transparent;
                setTextAlign: TaTop;
                winDrawText: aField header
                    in: r format: aField windowsJustification ].
    ^answer!
keyboardInput: aKeyboardInputEvent
        "Private"
    aKeyboardInputEvent character = Cr ifTrue: [
        self isOkToExpandOrCollapse == false
            ifFalse: [ self expandOrCollapse ].
        self triggerDoubleClickEvent.
        ^self ].
    ^super keyboardInput: aKeyboardInputEvent!   
triggerColumnResizedEvent

    self event: #columnResized. " OBSOLETE "
    self triggerEvent: #columnResized: with: self columnResized.!  
indexOf: anObject
    "Return the index of anObject"

    1 to: list size
        do:
            [:i |
            (list at: i) object == anObject
                ifTrue: [^i].
            ].
    ^0! 
selection
    "Answer the selected cell as a point"

    ^selectedCell!
nextValidCell: start
upDown: upDown
downRight: downRight
    "Private"

    | newSel |
    newSel := start.
    upDown
        ifTrue:
            [downRight
                ifTrue:
                    [newSel := (newSel y to: self rows)
                        detect:
                            [:i |
                            (self isDisabled: newSel x @ i) not]
                        ifNone: [self selection y].
                    newSel := self selection x @ newSel.
                    ]
                ifFalse:
                    [newSel := (newSel y to: 1 by: -1)
                        detect:
                            [:i |
                            (self isDisabled: newSel x @ i) not]
                        ifNone: [self selection y].
                    newSel := self selection x @ newSel.
                    ].
            ]
        ifFalse:
            [downRight
                ifTrue:
                    [newSel := (newSel x to: self columns)
                        detect:
                            [:i |
                            (self isDisabled: i @ newSel y) not]
                        ifNone: [self selection x].
                    newSel := newSel @ self selection y.
                    ]
                ifFalse:
                    [newSel := (newSel x to: 1 by: -1)
                        detect:
                            [:i |
                            (self isDisabled: i @ newSel y) not]
                        ifNone: [self selection x].
                    newSel := newSel @ self selection y.
                    ].
            ].
    ^newSel!
cellList: aCollection

    self contents: aCollection.! 
usesObjects: aBoolean
    "Set the table to object mode or not"

    usesObjects := aBoolean.
    self initializeCells.!  
selectRowWhereField: anIndexOrName equals: anObject
        "Select the first row where the field at anIndexOrName equals anObject."
    | index row selector |
    (self selectionMode ~= #cell
        & self usesObjects
        & columnHeader notNil
        and: [
            (index := anIndexOrName) isInteger ifFalse: [
                index := (1 to: columnHeader size)
                    detect: [ :each | (columnHeader at: each) name = anIndexOrName ]
                    ifNone: [ 0 ] ].
            (index between: 1 and: columnHeader size)
        and: [ (selector := (columnHeader at: index) selector) notNil
    ]]) ifTrue: [
        self isCellSelectMode: false.
        self isCellSelectMode ifTrue: [ ^self ].
        row := (1 to: cells size)
            detect: [ :each | ((cells at: each) perform: selector) = anObject ]
            ifNone: [ nil ].
        self selectRows: (
            row isNil
                ifTrue: [ #( ) ]
                ifFalse: [ Array with: row ] ) ].!
nameMethod: aSymbol
    "Set the method used to access the name of each item"

    nameMethod := aSymbol!  
cr
    "Private - process a carriage return from the text editor"

    | newSel oldSel |
    Notifier isShiftKeyDown
        ifTrue: [^self crShift].
    (self selection = self totalCells)
        ifTrue: [^self].
    newSel := self selection x @ (self selection y + 1 min: self rows).
    newSel := self
            nextValidCell: newSel
            upDown: true
            downRight: true.
    newSel = self selection
        ifTrue:
            [oldSel := selectedCell.
            newSel := selectedCell := (self selection x + 1 min: self columns) @ 1.
            newSel := selectedCell := self
                    nextValidCell: newSel
                    upDown: false
                    downRight: true.
            newSel := self
                    nextValidCell: newSel
                    upDown: true
                    downRight: true.
            selectedCell := oldSel.
            selectedCell x = newSel x
                ifTrue: [^self]].
    newSel := newSel min: self columns @ self rows.
    (self isDisabled: newSel)
        ifFalse:
            [self selection: newSel.
            self triggerCrEvent.
            ].!
copyRows: row
columns: column
    "Return a new matrix containing the elements of the reciever
     bounded by row and column"

    | aMatrix |
    aMatrix := CPMatrix rows: row columns: column.
    aMatrix copyElements: self.
    ^aMatrix.! 
colorMethod
    "Private"

    ^colorMethod!   
headerHeight
    "Private"

    ^self headerLineCount * self font height!  
dragTargetOperationsDefault
        "Private - answer the operations that the receiver can accept."
	^#( move copy )!   
highlightSelectedRows
        "Private"! 
setReadWrite
    "Make the text editors be read write (unless the TableColumn was readOnly),
    restoring the last arrowKeys cpStyle that was set."

    | lastStyle child |
    self isValid ifFalse: [ ^self whenValid: #setReadWrite ].
    lastStyle := self propertyAt: #oldCpStyle ifAbsent: [#arrowKeysEdit].
    self propertyAt: #cpStyle put: lastStyle.
    1 to: self columnHeaders size
        do:
            [:index |
            (self columnHeaders at: index) isReadOnly
                ifFalse:
                    [ "only restore RW status if the column is not ReadOnly"
                    child := (self columnHeaders at: index) editor.
                    child framingBlock: (self editorFramingBlockFor: child).
                    child isHandleOk
                        ifTrue:
                            [UserLibrary
                                    sendMessage: child handle
                                    msg: 1055
                                    wparam: false asParameter
                                    lparam: 0]]].
    self reframeEditors.
    self
        textEditor
        cellContents: '';
        cellContents: self basicSelectedItem.
    self hasFocus
        ifTrue: [ self textEditor selectAll ].!
collapsed
    "Private"

    ^collapsed!   
highlightCell: aCell
    "Private - highlight a cell"

    | box highlightColor region |
    aCell isNil | self isValid not
        ifTrue: [^self].
    (self isCellVisible: aCell)
        ifFalse: [^self].
    (self isDisabled: aCell)
        ifTrue: [^self showFocusInCell: aCell].
    box := self rectForCell: aCell.
    highlightColor := UserLibrary getSysColor: ColorHighlight.
    self
        doGraphics:
            [region := self pen setClipRect: (self headerExtent rightBottom: self rectangle rightBottom).
            self
                pen fill: box color: highlightColor;
                foreColor: (UserLibrary getSysColor: ColorHighlighttext);
                setBackMode: Transparent.
            self
                    displayItem: (objects at: aCell y)
                    inRect: box
                    highlight: true.
            self
                pen foreColor: self foreColor;
                setBackMode: Opaque.
            (self hasFocus and: [aCell = selectedCell])
                ifTrue:
                    [self showFocusInCell: aCell "color: Color black".
                    ].
            (self inWindowBuilder not and: [self parent isDialogTopPane])
                ifTrue:
                    [self
                        pen foreColor: Color black;
                        drawRectangle: self rect.
                    ].
            self pen destroyRegion: region.
            ].! 
columnHeaderClicked
    "Private"

    ^self fieldToReorderForPoint: self mouseLocation!   
rowReordered
    "Return the row number of the row that was reordered"

    ^self rowClicked!  
initializeTextEditor: column
    "Private"

    | justification colHeader |
    super initializeTextEditor: column.
    colHeader := self columnHeaders at: column.
    self textEditor class == EnhancedChildEntryField ifTrue: [
        justification := colHeader justification.
        justification == #right
            ifTrue:
                [self textEditor addStyle: EsRight.
                ]
            ifFalse:
                [justification == #center
                    ifTrue: [
                        self textEditor addStyle: EsCenter.
                        ]]].
    self textEditor
        font: colHeader font;
        field: colHeader validation;
        character: colHeader character;
        setPopupMenu: colHeader menu;
        getFocus: #yourself.
    colHeader isReadOnly ifTrue: [
        self textEditor readOnly ].!
atRow: row
column: column
    "Answer the element at row and column."

    ^(super at: row) at: column!   
rowToReorderForPoint: aPoint
    "Private"

    | point |
    point := ((0 @ 0 rightAndDown: ((aPoint leftAndUp: self headerExtent) rightAndDown: topCorner)) max: 0 @ 0).
    point := point y // cellSize y + 1 min: self rows.
    point = 0 ifTrue: [ ^nil ].
    ^point!  
resize: aPoint
    "Private"

    super resize: aPoint.
    self reframe.!
childrenMethod
    "Private"

    ^self owner childrenMethod!  
clearAnchor
        "Private - Pass to parent."
    self superWindow clearAnchor.!  
disabledForeColor
        "Answer the disabled foreground color
        OR nil if the default disabled foreground color should be used."

    ^self propertyAt: #disabledForeColor!   
pixelCellWidth: column
    "Private"

    ^self cellSize x!
setColumnHeaders: anOrderedCollection
		"Set the receiver's column headers."
	| oldHeaders |
	(oldHeaders := columnHeader) reverseDo: [ :eachOld |
		anOrderedCollection
			detect: [ :eachNew | eachNew == eachOld ]
			ifNone: [ self basicRemoveColumnHeader: eachOld ] ].
	(columnHeader := anOrderedCollection) do: [ :eachNew |
		oldHeaders
			detect: [ :eachOld | eachNew == eachOld ]
			ifNone: [ self basicAddColumnHeader: eachNew ] ].
	(self usesObjects or: [self sparseStorage or: [cells isNil]])
		ifFalse: [cells resizeRows: totalCells y columns: totalCells x].
	self calcFieldSizes.
	self isValid ifTrue: [
		self
			textEditor;
			setScrollRanges;
			"scrollIfNecessary;"
			updateSliders;
			reframeEditors;
			display]! 
restoreSelected
    "Refresh the list from the owner
     and keep the old selection. "

    | index first |
    index := self selection.
    first := self getTopIndex.
    self disableRedraw.
	self triggerNeedsContentsEvent.
    self setTopIndex: first.
    self selection: index.
    self enableRedraw.
    self invalidateRect: self rectangle! 
scrollVertical: scrollAmount
    "Private - Scroll the pane down by anInteger
      number of pixels (if positive) or up by
      the absolute value of anInteger (if negative)."

    self scrollTopCorner: 0 @ scrollAmount!   
losingFocus
        "Hide the heavy cell outline."

    self hasFocus ifTrue: [ ^self ].
    self isOkToChange ifFalse: [ ^self setFocus ].

    self unHighlightCell: selectedCell.
    self rowWithFocus notNil ifTrue: [ self redrawRowHeader: self rowWithFocus ].
    self commitChange.
    super losingFocus.
	self isHandleOk ifTrue: [
		selectedCell notNil ifTrue: [
			self drawGridIn: (selectedCell rightBottom: selectedCell + 1) ] ].!
labelMethod
    "Private"

    ^nil!   
triggerSelectEvent
		"Private"
    self event: #select. " OBSOLETE "
    self triggerEvent: #select: with: self selectedItem.! 
justificationOffsetFor: text
at: aPoint
    "Private"

    ^self cellTextOffset x!
reorderField: field
start: aPoint
    "Private"

    | currentPoint currentField tempField cursorLocation headerRect bitmap saveBitmap offset lastPoint |
    currentPoint := aPoint.
    CursorManager dragDropMove change.
    cursor := #leftRight.
    headerRect := self rectForHeader: field.
    offset := currentPoint x - headerRect left + topCorner x.
    bitmap := self bitmapForHeader: field in: headerRect.
    saveBitmap := Bitmap screenExtent: headerRect extent.
    self
        whileMouseStillDownPrim:
            [cursorLocation = self mouseLocation
                ifFalse:
                    [cursorLocation := self mouseLocation.
                    tempField := self fieldToReorderForPoint: cursorLocation.
                    tempField isNil
                        ifFalse: [currentField := tempField].
                    lastPoint isNil
                        ifFalse:
                            [self pen
                                    copyBitmap: saveBitmap
                                    from: bitmap boundingBox
                                    at: lastPoint @ 0
                                    rule: Srccopy.
                            ].
                    saveBitmap pen
                            copy: self pen
                            from: ((lastPoint := cursorLocation x - offset) @ 0 extent: headerRect extent)
                            at: 0 @ 0.
                    self pen
                            copyBitmap: bitmap
                            from: bitmap boundingBox
                            at: lastPoint @ 0
                            rule: Notsrccopy.
                    ].
            ].
    CursorManager normal change.
    (currentField isNil or: [field == currentField])
        ifTrue:
            [self
                displayHeader;
                displayLines.
            ^self].
    (fields indexOf: field) > (fields indexOf: currentField)
        ifTrue:
            [fields
                remove: field;
                add: field before: currentField]
        ifFalse:
            [fields
                remove: field;
                add: field after: currentField].
    bitmap release.
    saveBitmap release.
    self redraw.
    self updateRectangle.
    self event: #columnReordered. " OBSOLETE "
    self triggerEvent: #columnReordered: with: self columnReordered.! 
defaultRows
    "Private"

    ^3! 
initialize
    "Private"

    super initialize.
    nameMethod := #printString.
    objectList := OrderedCollection new.
    self itemHeight: 20.
    self foreColor: self defaultForeColor.
    deferChildren := false.
    tranType := #value.!
cellAt: aPoint
    "Private - answer the cell at a given point.  Public method is
     rowAt:column:, which allows either strings or integer indices."

    | cell selector |
    (cells isNil or: [cells isEmpty])
        ifTrue: [^''].
    selector := (columnHeader at: aPoint x) selector.
    self usesObjects
        ifTrue:
            [(aPoint y <= 0 or: [aPoint y > cells size])
                ifTrue: [^''].
            ^((cells at: aPoint y) perform: selector) asString].
    (cell := cells at: aPoint ifAbsent: [nil]) notNil
        ifTrue:
            [selector isNil
                ifTrue: [^cell asString]
                ifFalse: [^(cell perform: selector) asString]]
        ifFalse: [^''].!   
initialStateMethod
    "Private"

    ^self owner initialStateMethod!  
unHighlightSelectedCell
    "Private"

    self unHighlightCell: selectedCell.!
defaultStyle
    "Private"

    ^style := self basicStyle | WsBorder | WsVscroll | WsHscroll | LbsNotify | LbsNointegralheight | LbsOwnerdrawfixed!
defaultCanResize
    "Private"

    ^false!
cursor
    "Private"

    ^cursor! 
redrawRows: aCollection
        "Invalidate the specified rows."
    aCollection do: [ :each | self redrawRow: each ].! 
dragDropReceiver
    "Private"

    #obsoleteMethod.
    super dragDropReceiver.
    self children
        do:
            [:child |
            child
                dragDropReceiver;
                when: #dragDropped:
                    send: #droppedOn:
                    to: self.
            ].! 
basicRemoveColumnHeader: aTableColumn
		"Remove the specified table column."
	| index |
	index := columnHeader
		indexOf: aTableColumn
		ifAbsent: [ ^self ].
	aTableColumn editor notNil ifTrue: [
		aTableColumn editor isValid ifTrue: [
			aTableColumn editor removeDynamically ].
		aTableColumn editor: nil ].
	columnHeader removeIndex: index.
	totalCells x: self columnHeaders size.
	selectedCell :=
		(selectedCell x min: totalCells x)
			@ selectedCell y.! 
selector
    "Private"

    ^selector! 
triggerChangedIndexEvent

    "Private"
    self
        triggerEvent: #changedIndex:
        with:
            (self selectedRows isEmpty
            ifTrue: [nil]
            ifFalse: [self selectedRows asSortedCollection first])!  
amountToScrollLeft
    "Private"

    ^self cellSize x!
gettingFocus
        "Private"

    self hasFocus ifFalse: [ ^self ].

    self rowWithFocus notNil ifTrue: [
        self drawFocusRectForRow: self rowWithFocus ].

    self isCellSelectMode ifTrue: [
        self highlightCell: selectedCell ].

    ^super gettingFocus!
reorderField: field
start: aPoint
    "Private - Button 1 is down. Answer true if it stays down and we reorder the column.
    Answer false otherwise (it was a click instead of a drag)."

    | currentPoint currentField tempField cursorLocation savedColumn headerRect bitmap saveBitmap offset lastPoint fields editor column1 column2 |
    self sparseStorage
        ifTrue: [^false].
    savedColumn := self columnHeaders at: selectedCell x.
    self clearCurrentCell.
    fields := self columnHeaders.
    currentPoint := aPoint.
    CursorManager dragDropMove change.
    cursor := #leftRight.
    headerRect := self rectForHeader: field.
    offset := currentPoint x - headerRect left.
    bitmap := self bitmapForHeader: field in: headerRect.
    saveBitmap := Bitmap screenExtent: headerRect extent.
    self
        whileMouseStillDownPrim:
            [cursorLocation = self mouseLocation
                ifFalse:
                    [cursorLocation := self mouseLocation.
                    tempField := self fieldToReorderForPoint: cursorLocation.
                    tempField isNil
                        ifFalse: [currentField := tempField].
                    self doGraphics: [
                        lastPoint isNil
                            ifFalse:
                                [
                                    self pen
                                        copyBitmap: saveBitmap
                                        from: bitmap boundingBox
                                        at: lastPoint @ 0
                                        rule: Srccopy.
                                ].
                        saveBitmap pen
                                copy: self pen
                                from: ((lastPoint := cursorLocation x - offset) @ 0 extent: headerRect extent)
                                at: 0 @ 0.
                        self pen
                                copyBitmap: bitmap
                                from: bitmap boundingBox
                                at: lastPoint @ 0
                                rule: Notsrccopy.
                        ].
                    ].
            ].
    bitmap release.
    saveBitmap release.
    CursorManager normal change.
    (currentField isNil or: [field == currentField])
        ifTrue:
            [self drawColumnHeaderIn: self totalCells.
            self highlightCell: selectedCell.
            self updateSelection.
            self isCellSelectMode
                ifTrue:
                    [(self isReadOnly: selectedCell)
                        ifFalse:
                            [self
                                textEditor showWindow;
                                setFocus]].
            ^false].
    (column1 := fields indexOf: field) > (column2 := fields indexOf: currentField)
        ifTrue:
            [fields
                remove: field;
                add: field before: currentField]
        ifFalse:
            [fields
                remove: field;
                add: field after: currentField].
    self usesObjects
        ifFalse: [cells moveColumn: column1 to: column2].
    self display.
    self updateRectangle.
    self selection: (self columnHeaders indexOf: savedColumn) @ selectedCell y.
    self highlightCell: selectedCell.
    self updateSelection.
    self isCellSelectMode
        ifTrue:
            [(self isReadOnly: selectedCell)
                ifFalse:
                    [self
                        textEditor showWindow;
                        setFocus]].
    self triggerColumnReorderedEvent: field.
    ^true!   
constructEventsTriggered
    "Private - answer the set of events that instances of the
     receiver can trigger."

    ^super
        constructEventsTriggered addAll: #(doubleClickSelect: select: aboutToChange scrolled);
        yourself! 
fieldWidth: anInteger
    "Private - Set the field width for this field, in characters"

    fieldWidth := anInteger.! 
initialize
    "Private"

    super initialize.
    self singleSelect.
    cellSize := 50 @ self font height + 2.
    showHeader := self defaultShowHeader.
    fields := self defaultFields.
    showLines := self defaultShowLines.
    self contents: #().
    self backColor: self defaultBackColor.
    self foreColor: self defaultForeColor.!   
keyboardInput: aKeyboardInputEvent
		"Private - Process the input message."
	aKeyboardInputEvent virtualKey = TabKey
		ifTrue:
			[self superWindow tabKeyInput: aKeyboardInputEvent.
			^true].
	aKeyboardInputEvent isAltKeyDown ifFalse: [
		(self superWindow
			shouldProcess: aKeyboardInputEvent virtualKey
			controlKey: aKeyboardInputEvent isControlKeyDown)
				ifFalse: [
					self superWindow keyboardInput: aKeyboardInputEvent.
					^true]].
	^nil!
defaultForeColor
    "Private"

    ^Color windowText! 
defaultFont
    "Private"

    ^SysFont!   
justification: aSymbol
    "Private"

    justification := aSymbol!
defaultDisableMethod
    "Private"

    ^nil!  
dragSourceCutDefault: dragSession
		"Private - perform default cut action if no handler is provided."
		"Ignored by default..."
	| index indices |
	index := 0.
	(indices := self dragSourceSelection) ifNil: [ ^self ].
	self contents: (
		self contents reject: [ :each |
			indices includes: (
				index := index + 1 ) ] ).!   
selectedItem
    "Answer the selected item"

    self isCellSelectMode ifTrue: [ ^super selectedItem ].
    self selectedRows isEmpty ifTrue: [ ^nil ].
    self usesObjects ifFalse: [ ^nil ].
    ^cells at: (
        self selectedRows asSortedCollection
            detect: [ :index | index between: 1 and: cells size ]
            ifNone: [ ^nil ] )!  
childrenMethod: aSymbol
    "Set the method used to access the children of each item"

    childrenMethod := aSymbol.
    objectList notNil
        ifTrue:
            [objectList
                do:
                    [:o |
                    o getChildren.
                    ].
            self updateListBox: false.
            ].!
justificationOffsetFor: text
at: aPoint
    "Private"

    ^(columnHeader at: aPoint x) justificationOffsetFor: text! 
arrowKeyInput: anInt
	"Private - process keyboard input sent from texteditor"

	| x y mode anchor oldY min max |

	x := self cellsToDraw left.
	(mode := self selectionMode) = #cell ifTrue: [
		^super arrowKeyInput: anInt ].

	Notifier isControlKeyDown ifTrue: [
		mode ~= #single ifTrue: [
			mode := mode = #multi
				ifTrue: [ #extended ]
				ifFalse: [ #multi ] ] ].

	anInt = UpKey ifTrue: [
		self isCellSelectMode ifFalse: [
			(oldY := self rowWithFocus) isNil
				ifTrue: [ y := oldY := 1 ]
				ifFalse: [ y := oldY - 1 max: 1 ].
			self rowWithFocus: nil.
			self keepCellVisible: x @ y.
			mode = #single
				ifTrue: [
					self selectedRows notEmpty | Notifier isShiftKeyDown ifTrue: [
						self selectRowsAndTriggerEvent: (Array with: y) ] ]
				ifFalse: [
					Notifier isShiftKeyDown ifTrue: [
						(anchor := self propertyAt: #anchor) isNil ifTrue: [
							self propertyAt: #anchor put: (anchor := oldY) ].
						mode = #multi ifTrue: [
							min := y min: oldY.
							max := y max: oldY.
							y >= anchor
								ifTrue: [ oldY >= anchor ifTrue: [ min := min + 1 ] ]
								ifFalse: [ oldY >= anchor ifFalse: [ max := max - 1 ] ].
							self toggleSelectRowsAndTriggerEvent: (min to: max) ]
						ifFalse: [
							self selectRowsAndTriggerEvent: ((anchor min: y) to: (anchor max: y)) ] ] ].
			self rowWithFocus: y.
			^true ] ].

	anInt = DownKey ifTrue: [
		self isCellSelectMode ifFalse: [
			(oldY := self rowWithFocus) isNil
				ifTrue: [ y := oldY := 1 ]
				ifFalse: [ y := oldY + 1 min: self rows ].
			self rowWithFocus: nil.
			self keepCellVisible: x @ y.
			mode = #single
				ifTrue: [
					self selectedRows notEmpty | Notifier isShiftKeyDown ifTrue: [
						self selectRowsAndTriggerEvent: (Array with: y) ] ]
				ifFalse: [
					Notifier isShiftKeyDown ifTrue: [
						(anchor := self propertyAt: #anchor) isNil ifTrue: [
							self propertyAt: #anchor put: (anchor := oldY) ].
						mode = #multi ifTrue: [
							min := y min: oldY.
							max := y max: oldY.
							y >= anchor
								ifTrue: [ oldY >= anchor ifTrue: [ min := min + 1 ] ]
								ifFalse: [ oldY >= anchor ifFalse: [ max := max - 1 ] ].
							self toggleSelectRowsAndTriggerEvent: (min to: max)]
						ifFalse: [
							self selectRowsAndTriggerEvent: ((anchor min: y) to: (anchor max: y)) ] ] ].
			self rowWithFocus: y.
			^true ] ].

	anInt = LeftKey ifTrue: [
		self isCellSelectMode ifTrue: [
            x := self selection x.
            y := self selection y.
            [x > 1 and: [self isDisabled: (x - 1) @ y]] whileTrue: [ x := x - 1 ].
            x = 1 ifTrue: [
				self isCellSelectMode: false.
				self isCellSelectMode ifTrue: [ ^true ].
				y := self selection y.
				self keepCellVisible: x @ y.
				self rowWithFocus: y.
				^true ] ]
		ifFalse: [
			(y := self rowWithFocus ifNil: [ 1 ]) = 1 ifTrue: [ ^true ].
			x := self columns.
			y := y - 1.
			[x >= 1 and: [self isDisabled: x @ y]] whileTrue: [ x := x - 1 ].
			x >= 1
				ifTrue: [
					"Notifier cleanUpAllMessages."
					selectedCell := x @ y.
					self isCellSelectMode: true.
					self highlightCell: selectedCell.
					self keepSelectionVisible.
					self updateSelection.
					(self isReadOnly: selectedCell) ifFalse: [
						self textEditor showWindow; setFocus ].
					self triggerSelectEvent.
					^true ]
				ifFalse: [
					self rowWithFocus: nil.
					self keepCellVisible: 1 @ y.
					self rowWithFocus: y.
					^true ] ] ].

	anInt = RightKey ifTrue: [
		self isCellSelectMode ifTrue: [
            x := self selection x.
            y := self selection y.
            [x < self columns and: [self isDisabled: (x + 1) @ y]] whileTrue: [ x := x + 1 ].
            x = self columns ifTrue: [
				self selection y < self rows ifTrue: [
					self isCellSelectMode: false.
					self isCellSelectMode ifTrue: [ ^true ].
					y := self selection y + 1.
					self keepCellVisible: x @ y.
					self rowWithFocus: y.
					^true ] ] ]
		ifFalse: [
			x := 1.
			y := self rowWithFocus ifNil: [ 1 ].
			[x <= self columns and: [self isDisabled: x @ y]] whileTrue: [ x := x + 1 ].
			x <= self columns
				ifTrue: [
					"Notifier cleanUpAllMessages."
					selectedCell := x @ y.
					self isCellSelectMode: true.
					self highlightCell: selectedCell.
					self keepSelectionVisible.
					self updateSelection.
					(self isReadOnly: selectedCell) ifFalse: [
						self textEditor showWindow; setFocus ].
					self triggerSelectEvent.
					^true ]
				ifFalse: [
					y = self rows ifTrue: [ ^true ].
					y := y + 1.
					self rowWithFocus: nil.
					self keepCellVisible: 1 @ y.
					self rowWithFocus: y.
					^true ] ] ].

	self isCellSelectMode ifTrue: [ ^super arrowKeyInput: anInt ].

	y := nil.
	(oldY := self rowWithFocus) isNil ifTrue: [ oldY := 1 ].

	anInt = PageUpKey ifTrue: [
		y := (oldY up: self fullyVisibleCells y - 1) max: 1 ].

	anInt = PageDownKey ifTrue: [
		y := (oldY down: self fullyVisibleCells y - 1) min: self rows ].

	anInt = HomeKey ifTrue: [
		y := 1 ].

	anInt = EndKey ifTrue: [
		y := self rows ].

	y notNil ifTrue: [
		self rowWithFocus: nil.
		self keepCellVisible: 1 @ y.
		Notifier isShiftKeyDown ifTrue: [
			mode = #single
				ifTrue: [ self selectRowsAndTriggerEvent: (Array with: y) ]
				ifFalse: [
					(anchor := self propertyAt: #anchor) isNil ifTrue: [
						self propertyAt: #anchor put: (anchor := oldY) ].
					mode = #multi ifTrue: [
						min := y min: oldY.
						max := y max: oldY.
						y >= anchor
							ifTrue: [ oldY >= anchor ifTrue: [ min := min + 1 ] ]
							ifFalse: [ oldY >= anchor ifFalse: [ max := max - 1 ] ].
						self toggleSelectRowsAndTriggerEvent: (min to: max)]
					ifFalse: [
						self selectRowsAndTriggerEvent: ((anchor min: y) to: (anchor max: y)) ] ] ].
		self rowWithFocus: y.
		^true ].

	^super arrowKeyInput: anInt! 
iterateByPoint: aBlock
    "Perform aBlock with each combination of x and y coordinates
     in the form of a point"

    1 to: self size
        do:
            [:row |
            1 to: (self at: row) size
                do:
                    [:column |
                    aBlock value: (column @ row)].
            ].!  
validateCharacter: char
    "Private - Validate the character by applying char to
     the character validation function. Returns true if the
     character char is accepted. Returns false if not."

    char = Cr
        ifTrue: [^true].
    ^super validateCharacter: char!  
isReadOnly: aPoint
        "Private"
    ^self isReadOnly!  
icon
    "Private"

    | meth |
    (self collapsed not and: [(meth := self iconExpandMethod) notNil])
        ifTrue:
            [^self transact: [object perform: meth]]
        ifFalse:
            [(meth := self iconMethod) notNil
                ifTrue: [^self transact: [object perform: meth]]
                ifFalse: [^nil]].! 
selectAll
        "Ignored..."!  
tabKeyInput: aKeyboardInputEvent
        "Private - pass to parent."
	self showDropdown: false.
    ^self superWindow tabKeyInput: aKeyboardInputEvent!
basicCellAt: aPoint
    "Private - answer the cell at a given point.  Public method is
     rowAt:column:, which allows either strings or integer indices."

    | cell |
    cells isNil
        ifTrue: [^''].
    (cell := cells at: aPoint ifAbsent: [nil]) notNil
        ifTrue: [^cell]
        ifFalse: [^''].!  
button1Down: aPoint
	"Private"

	| cell point currentSelection lastSelection |
	(self subpaneButton1Down: aPoint)
		ifFalse: [^self].
	self doSetFocus.
	currentSelection := selectedCell.
	self isOkToChange == false ifTrue: [
		self whileMouseStillDown: [ ].
		self updateSelection.
		self unHighlightCell: currentSelection.
		self highlightCell: selectedCell.
		^self ].
	self doGraphics: [
		self whileMouseStillDown:[
			point := self mouseLocation.
			cell := self boundedCellForPoint: point.
			(self cell: currentSelection differsFrom: cell) & (self inBounds: cell)
				ifTrue:
					[(currentSelection isNil or: [(self isDisabled: currentSelection) not])
						ifTrue: [lastSelection := currentSelection].
					self unHighlightCell: currentSelection.
					self dragScrolls
						ifTrue:
							[self keepCellVisible: cell.
							].
					selectedCell := currentSelection := cell.
					self highlightCell: cell.
					].
			].
	].
	(self isDisabled: currentSelection)
		ifTrue:
			[self unHighlightCell: currentSelection.
			lastSelection isNil
				ifFalse: [selectedCell := lastSelection].
			self keepSelectionVisible.
			self highlightCell: selectedCell.
			(Smalltalk at: #Terminal) bell "UserLibrary messageBeep: 0" ]
		ifFalse:
			[selectedCell := currentSelection.
			].
	self updateSelection.
	self triggerSelectEvent.!
collapsed: aBoolean
    "Private"

    collapsed := aBoolean!  
characterInput: aCharacter
		"Private - Pass to parent."
	aCharacter = Cr ifTrue: [
        self cr.
		^true ].
	self isReadOnly ifTrue: [
		^self superWindow characterInput: aCharacter ].
	^super characterInput: aCharacter!   
triggerScrolledEvent
		"Private"
    self event: #scrolled. " OBSOLETE "
    self triggerEvent: #scrolled.!
commitChange
        "Commit the change if there is one."
    | array |
    array := self propertyAt: #selectionChanged ifAbsent: [ ^self ].
    self invalidateRect: (self rectForCell: self selection).
    self triggerCellChangedAt: (array at: 1) value: (array at: 3).
    self propertyAt: #selectionChanged put: nil.!  
clearAnchor
        "Private - Pass to parent."
    self superWindow clearAnchor.!  
getTopIndex
    "Private - Answer the index of the object visible at the top of the
     listbox"

    ^self getTopCell y!
editor: aSubPane
    "Private"

    editor := aSubPane!
selection
    "Answer the index of the selected item"

    selectedCell isNil
        ifTrue: [^nil].
    ^selectedCell y!   
basicAtRow: row
column: column
    "Answer the OBJECT that is at column@row.  If there is no value, an
     empty string will be returned.  If there are labels
     (headers) associated with a given row or column, the argument for
     that coordinate may be a string within the label list rather than a numeric
     index.  Example values:  1@'Name', 'Name'@1,  'Name'@'Year', 1@1  "

    ^self basicCellAt: (self cellForRow: row column: column)!   
type
    "Private"

    ^type! 
showRowHeader: aBoolean
    "Show the row header or not"

    showRowHeader := aBoolean.
    "Uncache"
    headerExtent := nil.! 
amountToScrollUp
    "Private"

    ^self cellSize y!  
font: aFont
    "Set the font"

    super font: aFont.
    headerExtent := nil.
    self cacheCellSize.
    self textEditor isNil
        ifFalse:
            [self textEditor font: aFont.
            ].! 
labelMethod
    "Answer aSymbol or nil, the message selector that will be sent to
    each object in the list to determine its row label.  If nil, the
    default row number labels are used."

    ^labelMethod!   
button2Up: aPoint
    "Private - Right button was clicked.
    If column sorting is on and aPoint is in a column header, sort the rows based on the column contents
    (descending sort if the shift key is down; ascending otherwise).
    Otherwise, if aPoint is in a column that has a non-nil name and an action registered for the event,
    (i.e. a link from the receiver to a menu), trigger #rightClicked<ColumnName>.
    Otherwise, trigger #rightClicked to get the default tablePane menu or
    whatever action may be registered for the event."

    | field fieldIndex |
    field := self fieldToReorderForPoint: aPoint.
    fieldIndex := self columnHeaders indexOf: field.
    (self canSort and: [self isPointInHeader: aPoint])
        ifTrue:
            ["sort"
            Notifier isShiftKeyDown
                ifTrue: [self sortOn: fieldIndex ascending: false]
                ifFalse: [self sortOn: fieldIndex ascending: true].
            self triggerColumnSortedEvent: field]
        ifFalse:
            ["not sorting: trigger the appropriate rightClicked event"
            self triggerRightClickedEvent: aPoint]!  
clearAnchor
        "Private - Clear the row selection anchor."
    self propertyAt: #anchor put: nil.! 
amountToScrollRight
    "Private"

    ^self amountToScrollLeft negated!   
iconMethod
    "Private"

    ^iconMethod! 
showEditor
        "Private"
    self isCellSelectMode ifTrue: [
        self highlightCell: selectedCell.
        (self isReadOnly: selectedCell) ifFalse: [
            self textEditor showWindow; setFocus ] ].! 
keyboardInput: aKeyboardInputEvent
		"Private - keyboard input was received."
	aKeyboardInputEvent isAltKeyDown ifFalse: [
		aKeyboardInputEvent virtualKey = TabKey
			ifTrue: [
				self superWindow tabKeyInput: aKeyboardInputEvent.
				^true ].
		(self
			shouldProcess: aKeyboardInputEvent virtualKey
			controlKey: aKeyboardInputEvent isControlKeyDown)
				ifFalse: [
					self superWindow keyboardInput: aKeyboardInputEvent.
					^true] ].
	^super keyboardInput: aKeyboardInputEvent!  
realRectangle
    "Private - Answer the rectangle representing the fully visible area of the
     window, taking into account any scrollbars that might be on it."

    | range height width |
    self inWindowBuilder
        ifTrue: [^0 @ 0 extent: self wbDisplayRectangle extent].
    width := height := 0.
    range := self getScrollRanges.
    range x ~= 0
        ifTrue:
            [width := self scrollBarWidth.
            ].
    range y ~= 0
        ifTrue:
            [height := self scrollBarHeight.
            ].
    ^0 @ 0 extent: self frameRectangle extent - (width @ height).! 
initialize
    "Private"

    usesObjects := true.
    selection := false.
    super initialize.
    super columnHeaders: self defaultColumnHeaders.!   
atColumn: anInteger
put: anArray
    "Set the column at anInteger."

    1 to: anArray size
        do:
            [:row |
            self
                    atRow: row
                    column: anInteger
                    put: (anArray at: row)].! 
cellShowCaret

   UserLibrary showCaret: self handle.!  
open
    "Private"

    self triggerGetColumnsEvent.
    super open.! 
reorderRow: row
start: aPoint
    "Private - Answer true if reordered, else false."

    | currentPoint tempRow2 tempRow1 cursorLocation savedRow headerRect
    bitmap saveBitmap offset lastPoint rows editor row1 row2 newSel sel sign
    dragging |
    self sparseStorage
        ifTrue: [^false].
    cells size < selectedCell y
        ifTrue: [^false].
    savedRow := cells at: (selectedCell y max: 1).
    dragging := false.
    rows := cells.
    currentPoint := aPoint.
    cursor := #upDown.
    headerRect := self rectForRowHeader: row.
    offset := currentPoint y - headerRect top.
    self
        whileMouseStillDownPrim:
            [dragging
                ifFalse:
                    [dragging := (aPoint y - self mouseLocation y) abs >= self class dragSourceSensitivity y.
                    dragging
                        ifTrue:
                            [CursorManager dragDropMove change.
                            self clearCurrentCell.
                            bitmap := self bitmapForRowHeader: row in: headerRect.
                            saveBitmap := Bitmap screenExtent: headerRect extent.
                            ].
                    ].
            dragging
                ifTrue:
                    [cursorLocation = self mouseLocation
                        ifFalse:
                            [cursorLocation := self mouseLocation.
                            tempRow1 := self rowToReorderForPoint: cursorLocation.
                            tempRow1 isNil
                                ifFalse: [tempRow2 := tempRow1].
                            self doGraphics: [
                                lastPoint isNil
                                    ifFalse:
                                        [self pen
                                                copyBitmap: saveBitmap
                                                from: bitmap boundingBox
                                                at: 0 @ lastPoint
                                                rule: Srccopy.
                                        ].
                                saveBitmap pen
                                        copy: self pen
                                        from: (0 @ (lastPoint := cursorLocation y - offset) extent: headerRect extent)
                                        at: 0 @ 0.
                                self pen
                                        copyBitmap: bitmap
                                        from: bitmap boundingBox
                                        at: 0 @ lastPoint
                                        rule: Notsrccopy.
                                ].
                            ].
                    ].
            ].
    dragging ifFalse: [ ^false ].
    bitmap release.
    saveBitmap release.
    CursorManager normal change.
    (tempRow2 isNil or: [row == tempRow2])
        ifTrue:
            [self drawRowHeaderIn: self cellsToDraw.
            self drawGridIn: self cellsToDraw.
            self highlightCell: selectedCell.
            self isCellSelectMode
                ifTrue: [
                    self updateSelection.
                    (self isReadOnly: selectedCell) ifFalse: [
                        self
                            textEditor showWindow;
                            setFocus ] ]
                ifFalse: [ self reframeEditors ].
            ^true].
    tempRow2 := tempRow2 min: cells size.
    self usesObjects
        ifFalse: [cells moveRow: row to: tempRow2]
        ifTrue:
            [row1 := cells at: row.
            row2 := cells at: tempRow2.
            row > tempRow2
                ifTrue:
                    [cells
                        remove: row1;
                        add: row1 before: row2]
                ifFalse:
                    [cells
                        remove: row1;
                        add: row1 after: row2]].

    self basicSelectedRows notNil ifTrue: [
        newSel := self selectedRows asSet.
        (sel := newSel includes: row) ifTrue: [ newSel remove: row ].
        row = tempRow2 ifFalse: [
            sign := (tempRow2 - row) sign.
            row + sign to: tempRow2 by: sign do: [ :each |
                (newSel includes: each) ifTrue: [
                    newSel remove: each.
                    newSel add: each - sign ] ] ].
        sel ifTrue: [ newSel add: tempRow2 ].
        self selectRows: newSel ].

    self display.
    self updateRectangle.
    self selection: selectedCell x @ (cells indexOf: savedRow).
    self highlightCell: selectedCell.
    self isCellSelectMode
        ifTrue: [
            self updateSelection.
            (self isReadOnly: selectedCell) ifFalse: [
                self
                    textEditor showWindow;
                    setFocus ] ]
        ifFalse: [ self reframeEditors ].
    self triggerRowReorderedEvent.
    ^true! 
updateHorizontalExtent

        "Private - if the receiver has a horizontal scrollbar,
         call this method after setting its contents to calculate
         and set the correct horizontal scrollbar range."

        "Faster than superclass method.  Thanks to Wolfgang."
    | maxWidth font |

    (self hasStyle: WsHscroll) ifFalse: [ ^self ].
    list size = 0 ifTrue: [ ^self ].
    (font := self font) isNil ifTrue: [ font := ListFont ].
    maxWidth := list inject: 0 into: [ :max :item |
        max max: (self stringForItem: item) size
    ].
    maxWidth := (font stringWidth: (String new: maxWidth)) + 5.
    self setHorizontalExtent: maxWidth!  
defaultDrawItem: aDrawStruct
    "Private - Draw the specified control item."

    | item aBitmap box region |
    box := aDrawStruct boundingBox.
	region := self graphicsTool setClipRect: (box intersect: self rectangle).
	self graphicsTool 
        font: self font;
        width: box width;
        height: box height.
    aBitmap isNil
        ifTrue: [
            (list at: self drawIndex) displayWith: graphicsTool inBox: box ]
        ifFalse: [
            graphicsTool
                erase;
                copyBitmap: aBitmap
                    from: aBitmap boundingBox
                    at: box origin ].
	self graphicsTool destroyRegion: region.!
moveRow: row1
to: target
    "Move the values in row1 to row2. Other rows should
     shift up or down based on their positions"

    | row row2 |
    row := self at: row1.
    row2 := target min: self size.
    row1 > row2
        ifTrue: [
            row1 to: row2 + 1 by: -1 do: [ :i |
                self at: i put: (self at: i - 1)]]
         ifFalse: [
            row1 to: row2 - 1 do: [ :i |
                self at: i put: (self at: i + 1)]].
    self at: row2 put: row.! 
headerColor
    "Private"

    ^headerColor!   
cellTextOffset
    "Private - Answer the offset from the left top of a cell for the
     text to be displayed."

    ^3 @ 3!  
cellHideCaret
    "Ignore because no caret in drop down list."!  
indexOfHeader: column
    "Private"

    ^self columnHeaders
        findFirst: [ :c | c name = column ]
        ifAbsent: [
            self columnHeaders
                findFirst: [ :c | c header = column ]
                ifAbsent: [ nil ] ]!
showHeader
    "Private"

    ^showHeader! 
button1DoubleClick: aPoint
    "Private"

    selectedCell = (self boundedCellForPoint: aPoint)
        ifFalse:
            [self button1Down: aPoint.
            ].
    super button1DoubleClick: aPoint.!  
drawCell: aPoint
clipRect: clipRect
foreColor: aForeColor
backColor: aBackColor
    "Private - draw a given cell.  Clipping will be done
     with the intersection of clipRect and the cell's rect."

    | cellRect region text justOffset color bColor font |
    cellRect := self rectForCell: aPoint.
    tempClipRect notNil
        ifTrue: [cellRect := cellRect intersect: tempClipRect].
    text := self cellAt: aPoint.
    justOffset := self justificationOffsetFor: text at: aPoint.
    (color := aForeColor) isNil ifTrue: [ color := self foreColorAt: aPoint ].
    (bColor := aBackColor) isNil ifTrue: [ bColor := self backColorAt: aPoint ].
    font := self fontForColumn: aPoint x.
    self
        doGraphics: [
            region := self pen setClipRect: (cellRect intersect: clipRect).
            bColor = self backColor ifFalse: [
                self pen
                    fill: (cellRect insetBy: (aBackColor isNil ifTrue: [ 2 ] ifFalse: [ 1 ]))
                    color: bColor ].
            self
                pen setTextAlign: TaTop;
                font: font;
                setBackgroundModeTransparent;
                foreColor: color;
                displayText: text at: (cellRect left right: justOffset)
					@ (cellRect origin y + ((cellRect height - self font height) // 2));
                foreColor: self foreColor;
                setBackgroundModeOpaque;
                destroyRegion: region.
            ].!   
basicForeColorAt: aPoint
        "Private"
    | color cell |
    aPoint notNil ifTrue: [
        columnHeader notNil ifTrue: [
            color := (columnHeader at: aPoint x) foreColor ].
        color isSymbol ifTrue: [
            color := self cellAt: aPoint perform: color ifFail: [ nil ]]].
        color isNil ifTrue: [
            color := self colorMethod ].
        color isSymbol ifTrue: [
            color := self cellAt: aPoint perform: color ifFail: [ nil ]].
    color isNil ifTrue: [
        color := super basicForeColorAt: aPoint ].
    ^color!
font: aFont
    "Set the font of the listbox"

    super font: aFont.
    cellSize y: aFont height + 2.
    self calcFieldSizes
    fields
        do:
            [:f |
            f setFont: aFont]!  
selectionMode: aSelector
		"Private - Set the selection mode."
    selectionMode :=
        aSelector = #cell
            ifTrue: [ nil ]
            ifFalse: [ aSelector ].!   
transact: aBlock
    "Private"

    ^aBlock perform: self tranType!
atRow: row
column: column
    "Answer the string that is at column@row.  If there is no value, an
     empty string will be returned.  If there are labels
     (headers) associated with a given row or column, the argument for
     that coordinate may be a string within the label list rather than a numeric
     index.  Example values:  1@'Name', 'Name'@1,  'Name'@'Year', 1@1  "

    ^self cellAt: (self cellForRow: row column: column)! 
drawRowHeaderIn: range
    "Private - draw the row header within range cells.
     If no row header exists, use numbers"

    super drawRowHeaderIn: range.
    self hasFocus & self rowWithFocus notNil ifTrue: [
        (self rowWithFocus between: range top and: range bottom) ifTrue: [
            self drawFocusRectForRow: self rowWithFocus ] ].!
cellInset
		"Answer the # of pixels to inset the receiver's frame
			when used in a CPTablePane."

	^1!   
searchNameForIndex: anIndex
    "Private"

    | name |
    fields isEmpty | anIndex isNil
        ifTrue: [^nil].
    name := (objects at: anIndex) perform: (fields at: 1) selector.
    name isBitmap
        ifTrue: [^nil].
    name isString not
        ifTrue:
            [name := name printString.
            ].
    ^name!  
removeChildMethod
    "Private"

    ^self propertyAt: #removeChildMethod! 
rowWithFocus
        "Private"
    ^nil!
readOnly
    "Set the style such to be read only"

    self propertyAt: #cpStyle put: #readOnly.
    self setReadOnly.!   
updateVerticalSlider
    "Private - Update the vertical slider position."

    "Make the vertical scroll bar represent cell scrolling
        rather than pixel scrolling."

    | pos h |
                                        "added --> + self cellSize y - 1 // self cellSize y"
    (h := self scrollableRectangle height + self cellSize y - 1 // self cellSize y) = 0
        ifTrue:
            [pos := 1.
            ]
        ifFalse:
            [pos := self topCorner y // self cellSize y.
                "self topCorner y / cellSize y / (h / cellSize y / 32767) ceiling."
            ].
    UserLibrary
            setScrollPos: self asParameter
            bar: SbVert
            position: pos truncated
            redraw: true.!   
triggerRowReorderedEvent
        "Private"
    self event: #rowReordered. " OBSOLETE "
    self triggerEvent: #rowReordered: with: self rowReordered.! 
button1Down: aPoint
    "Private"

    | field |
    self doGraphics: [
        (self isPointInHeader: aPoint)
            ifTrue:
                [(self canResize and: [(field := self fieldToResizeForPoint: aPoint) notNil])
                    ifTrue: [self resizeField: field start: aPoint]
                    ifFalse: 
                        [(self canReorder and: [(field := self fieldToReorderForPoint: aPoint) notNil])
                            ifTrue: [self reorderField: field start: aPoint]].
                ]
            ifFalse:
                [self isMultiSelect
                    ifTrue: [self button1DownMultiSelect: aPoint]
                    ifFalse: [super button1Down: aPoint]]].!   
selectorString
    "Private"

    selector isNil
        ifTrue: [^''].
    ^'#' , selector asString!
initialStateMethod: aSymbol
    "Set the method used to determine the initial state of each item"

    initialStateMethod := aSymbol!  
selectRowAt: anInteger
        "Select the specified row."
    (anInteger between: 1 and: self totalCells y)
        ifTrue: [
            self selectRow: anInteger ].!  
highlightSelectedCell
    "Private - highlight the selected cell with an extra border"

    self highlightCell: selectedCell.! 
childEntryFieldClass
    "Private"

    ^EnhancedChildEntryField!  
at: aPoint
put: anObject
    "Set the element at aPoint."

    aPoint isInteger
        ifTrue:
            [super at: aPoint put: anObject]
        ifFalse:
            [self
                    atRow: aPoint y
                    column: aPoint x
                    put: anObject].!  
indentWidth
    "Private"

    indentWidth isNil
        ifTrue: [indentWidth := 3].
    ^indentWidth!   
inWindowBuilder
    "Private"

    self rectangle isNil
        ifTrue: [^true].
    ^super inWindowBuilder! 
altDownInWmChar: wordInteger with: longInteger
        "Private - Commit the change first..."
    ^self superWindow altDownInWmChar: wordInteger with: longInteger! 
iconWidth
    "Private"

    | icon |
    (icon := self icon) notNil
        ifTrue: [^icon width]
        ifFalse: [^0].!  
colorMethod: aSymbol
    "Set the method used to access the foreground color of each item"

    colorMethod := aSymbol!
selection: aCell focus: shouldSetFocus
    "Private - Set the selected cell as a point"

    | readOnly |
    selectedCell = aCell
        ifTrue: [^self].
    (self isValid not or: [rectangle isNil or: [self inWindowBuilder]])
        ifTrue: [^self].
    readOnly := self isReadOnly.
    readOnly
        ifFalse:
            [shouldSetFocus
                ifTrue: [self textEditor cellHideCaret]
            ].
    self unHighlightCell: selectedCell.
    readOnly
        ifFalse:
            [self textEditor isNil
                ifTrue: [^self].
            self textEditor hideWindow.
            self updateWindow.
            ].
    selectedCell := aCell.
    self highlightCell: selectedCell.
    self keepSelectionVisible.
    readOnly
        ifFalse:
            [self updateSelection.
            "self textEditor resize: self rectangle."
            shouldSetFocus & self isCellSelectMode ifTrue:
                [(self isReadOnly: selectedCell) ifFalse:
                    [self textEditor
                        "sendInputEvent: #" showWindow;
                        "sendInputEvent: #" setFocus;
                        cellShowCaret.
                    ].
                ].
            ].!   
validateContents
		"Private - Validate the receiver's contents. Answer true if successful."
	self isReadOnly ifFalse: [
		( self value ~= self previousValue ) ifTrue: [
			self validateField ifFalse: [
				self errorMessage ifTrue: [ ^false ] ].
			( self isOkToChangeTo: self value ) ifFalse: [ ^false ].
			( self hasActionForEvent: #changed: )
				ifTrue: [ self triggerChanged ].
			self previousValue: self value ].
		^true ].
	^true!
object
    "Private"

    ^object! 
showColumnHeader
    "Answer aBoolean indicating whether to display the column labels. The default is true."

    ^showColumnHeader!   
shouldProcess: wordInteger controlKey: controlKey
        "Private - Answer true if the receiver should process the keystroke."

    (wordInteger = NumLockKey) ifTrue: [ ^false ].

    (wordInteger = UpKey) | (wordInteger = DownKey)
        | (wordInteger = LeftKey) | (wordInteger = RightKey)
        | (wordInteger = PageUpKey) | (wordInteger = PageDownKey)
        | (wordInteger = HomeKey) | (wordInteger = EndKey) ifFalse: [ ^true ].

    (self superWindow cpStyle = #arrowKeysMove
        | controlKey)
        ifTrue: [
            ^self isDropdownVisible = true and: [
                (wordInteger ~= LeftKey) & (wordInteger ~= RightKey) ] ].

    ^true!
selectedIndex
    "Answer the index of the selected item"

    ^self selection!
addChildMethod
    "Private"

    ^self propertyAt: #addChildMethod!   
anchorFor: rowNum
        "Answer the anchor.  Assume in row select mode"

    | anchor |

    Notifier isShiftKeyDown ifFalse: [ ^rowNum ].
    self selectedRows isEmpty ifTrue: [ ^rowNum ].

    anchor := self selectedRows detect: [ :a | true ] ifNone: [ rowNum ].
    anchor := self selectedRows inject: anchor into: [ :a :b | a min: b ].
    rowNum < anchor ifTrue: [
        anchor := self selectedRows inject: anchor into: [ :a :b | a max: b ] ].
    ^anchor! 
selectedItem
    "Answer the selected item"

    selectedCell isNil
        ifTrue: [^nil].
    ^objects at: selectedCell y! 
selectRows: aCollection
        "Set the collection of selected rows."
    | range old new highlight |
    self isHandleOk ifTrue: [
        selectedRows isNil & aCollection isNil ifFalse: [
            selectedRows isNil ifTrue: [
                "self isOkToChange = false ifTrue: [ ^self ]."
                self hasFocus ifTrue: [
                    self textEditor hideWindow.
                    self unHighlightCell: selectedCell.
                    self setFocus ] ].
            range := self cellsToDraw.
            (old := selectedRows) isNil ifTrue: [ old := #( ) ].
            (new := aCollection) isNil ifTrue: [ new := #( ) ].
            (range top max: 1) to: (range bottom min: self rows) do: [ :rowNum |
                highlight := new includes: rowNum.
                ((old includes: rowNum) xor: highlight)
                    ifTrue: [ self displayRow: rowNum highlight: highlight ] ] ].
            aCollection isNil ifTrue: [
                self hasFocus ifTrue: [
                    self rowWithFocus: nil.
                    self highlightCell: selectedCell.
                    (self isReadOnly: selectedCell) ifFalse: [
                        self textEditor showWindow; setFocus ].
                ] ifFalse: [ self rowWithFocus: nil ] ] ].
    selectedRows := aCollection.!
cursorOnFieldBoundary: aPoint
    "Private"

    ^(self fieldToResizeForPoint: aPoint) notNil! 
columnResized
    "Return the column number of the column that was resized"

    ^self columnHeaders indexOf: (self fieldToResizeForPoint: self mouseLocation)!
parent
    "Private"

    ^parent! 
parent: anObject
    "Private"

    parent := anObject!
initialize
    "Private"

    self arrowKeysEdit.
    cellWidth := self defaultCellWidth.
    self cacheCellSize.
    showRowHeader := self defaultShowRowHeader.
    showColumnHeader := self defaultShowColumnHeader.
    showGrid := self defaultShowGrid.
    sparseStorage := self defaultSparseStorage.
    totalCells := 0 @ 0.
    self initializeTextEditor.
    "Order dependent - expect the show*  values to be set"
    totalCells := self defaultColumns @ self defaultRows.
    super initialize.
    selectedCell := (1 @ 1) copy.
    self
        initializeSelectedCell;
        disabledForeColor: self disabledForeColorDefault;
        disabledBackColor: self disabledBackColorDefault.!   
characterInput: aCharacter
        "Perform row selection"

    | rowNum anchor mode |

    aCharacter = $ ifTrue: [
        mode := self selectionMode.

        self isCellSelectMode ifTrue: [
            mode ~= #cell ifTrue: [
                (self isReadOnly: selectedCell) ifTrue: [
                    rowNum := selectedCell y.
                    self selectRowsAndTriggerEvent: Array new.
                    self rowWithFocus: rowNum ] ] ].

        self isCellSelectMode ifFalse: [
            rowNum := self rowWithFocus ifNil: [ ^self ].
            (rowNum between: 1 and: self rows) ifTrue: [
                mode = #single ifTrue: [
                    self selectedRows notEmpty ifTrue: [
                        ^self selectRowsAndTriggerEvent: (Array new) ].
                    ^self selectRowsAndTriggerEvent: (Array with: rowNum) ].
                anchor := self anchorFor: rowNum.
                Notifier isControlKeyDown ifTrue: [
                    mode := mode = #multi
                        ifTrue: [ #extended ]
                        ifFalse: [ #multi ] ].
                mode = #multi ifTrue: [
                    self toggleSelectRowsAndTriggerEvent: (
                        (anchor min: rowNum) to: (anchor max: rowNum) ).
                    ^self ].
                self selectRowsAndTriggerEvent: ((anchor min: rowNum) to: (anchor max: rowNum)).
                ^self ] ] ].!   
defaultSparseStorage
    "Private"

    ^false!
showGrid: aBoolean
    "Show the grid or not"

    showGrid := aBoolean!   
displayRow: anInteger highlight: aBoolean
    "Private - Display the specified row."

    | t b drawRect range hrfColor fColor hrbColor bColor rowsToHighlight |
    drawRect := self rect.
    b := (self headerExtent y up: topCorner y) down: anInteger * cellSize y.
    t := b up: cellSize y.
    ((b isBelow: drawRect top) and: [t isAbove: drawRect bottom]) ifFalse: [ ^self ].

    drawRect := (drawRect left right: self headerExtent x) @ t
        rightBottom:
            (drawRect right leftMost: (self rectForCell: self columns @ anInteger) right) @ b.
    self
        doGraphics:
            [self pen fill: drawRect color: self backColor.
            range := 1 @ anInteger rightBottom: self columns @ anInteger.
            self drawGridIn: range.
            aBoolean ifTrue: [
                hrfColor := self highlightRowForeColor.
                hrbColor := self highlightRowBackColor ].
            (range top max: 1) to: (range bottom min: self rows)
                do:
                    [:r |
                    aBoolean
                            ifTrue: [
                                fColor := hrfColor.
                                bColor := hrbColor ]
                            ifFalse: [
                                fColor := bColor := nil ].
                    (range left max: 1) to: (range right min: self totalCells x)
                        do:
                            [:c |
                            self
                                drawCell: c @ r
                                clipRect: drawRect
                                foreColor: fColor
                                backColor: bColor.
                            ].
                    ].
            "self sendInputEvent: #deferredhighlightCell: with: self selection."
            ].! 
fieldToResizeForPoint: aPoint
    "Private"

    | x offset |
    offset := topCorner x + aPoint x.
    x := self headerExtent x.
    ^self columnHeaders
        detect:
            [:field |
            x := x + field fieldPixelWidth.
            offset between: x - 2 and: x + 2]
        ifNone: [nil].!  
open
    "Private"

	self triggerGetFieldsEvent.
    super open.! 
defaultHeaderColor
    "Private"

    ^Color paleGray! 
entryFieldClass
        "Private - answer the class of the entry field part of the receiver."
    ^CPChildComboEntryField!  
isOkToExpandOrCollapse
    "Private - answer whether it is OK to expand or collapse."

    ^(self hasActionForEvent: #aboutToExpandOrCollapse)
        ifTrue: [self triggerEvent: #aboutToExpandOrCollapse]
        ifFalse: [self event: #aboutToExpandOrCollapse]!
triggerTextChangedEvent
        "Private"
    self event: #textChanged. " OBSOLETE "
    self
            triggerEvent: #textChanged:cell:
            with: (self cellAt: self selection)
            with: self selection.!   
resizeField: field
start: aPoint
    "Private"

    | currentPoint lastPoint tooThin offset cursorLocation minimumFieldWidth |
    currentPoint := aPoint.
    minimumFieldWidth := self minimumFieldWidth.
    tooThin := field fieldPixelWidth < minimumFieldWidth.
    self
        whileMouseStillDownPrim:
            [cursorLocation := self mouseLocation.
            offset := cursorLocation x - currentPoint x.
            (offset ~~ 0 and: [(offset < 0 & tooThin) not])
                ifTrue:
                    [(field fieldPixelWidth + offset) < minimumFieldWidth
                        ifTrue:
                            [currentPoint := (currentPoint x - (field fieldPixelWidth - minimumFieldWidth)) @ cursorLocation y.
                            field fieldPixelWidth: minimumFieldWidth.
                            tooThin := true.
                            ]
                        ifFalse:
                            [currentPoint := cursorLocation.
                            field fieldPixelWidth: field fieldPixelWidth + offset.
                            tooThin := false.
                            ].
                    self displayHeader.
                    lastPoint isNil
                        ifFalse: [self drawMovingLine: lastPoint x].
                    self drawMovingLine: currentPoint x.
                    lastPoint := currentPoint.
                    ].
            ].
    self updateTotalFieldWidth.
    self redraw.
    self updateRectangle.
    self updateHorizontalSlider.
	self triggerColumnResizedEvent.! 
triggerMultiSelectEvent

	self triggerSelectEvent.
    self triggerEvent: #multipleSelect: with: self selectedItems.!  
tranType
    "Private"

    ^self owner tranType!  
font: aFont
    "Set the font"

    super font: aFont.
    columnHeader
        do:
            [:col |
            col setFont: aFont.
            col editor isNil
                ifFalse: [ col editor font: col font ]].
    self calcFieldSizes.! 
listString
    "Private"

    ^(self transact: [object perform: self nameMethod]) , self collapsedString!  
rectForRowHeader: row
    "Private"

    | rect point |
    rect := self rectForCell: 1 @ row.
    ^Rectangle leftTop: 0 @ rect top rightBottom: self headerExtent x @ rect bottom!  
defaultShowHeader
    "Private"

    ^true!
verticalScrollAreaRectangle
    "Private - Answer the rectangular are that should be scrolled if we
    scroll vertically (don't scroll the vertical  header)"

    ^self headerExtent x + 1 @ 0 rightBottom: self rectangle rightBottom! 
drawExtraRightArea
    "Private - blank over any excess window size to the right of
     the number of columns"

    | rect cornerPoint visRect region |
    visRect := self visibleRectangle.
    cornerPoint := (self rectForCell: totalCells) rightBottom.
    visRect width < cornerPoint x
        ifTrue: [^self].
    rect := (cornerPoint x @ 0) rightBottom: visRect right @ (cornerPoint y min: visRect height).
    self doGraphics: [
        region := self pen setClipRect: self tempClipRect.
        self pen fill: rect color: self headerColor.
        self pen destroyRegion: region ].! 
triggerColumnResizedEvent: aColumnIndex
        "Private"
    self event: #columnResized. " OBSOLETE "
    self triggerEvent: #columnResized: with: aColumnIndex!  
childEntryFieldFor: column
    "Private"

    ^self childEntryFieldClass new!  
scrollIfNecessary
    "Private - force us to scroll if we just got smaller and are
     scrolled out"

    | newTopCorner fullExtent visibleExtent delta |
    self isHandleOk
        ifFalse: [^self].
    fullExtent := self fullExtent.
    visibleExtent := self realRectangle extent.
    newTopCorner := topCorner deepCopy.
    (fullExtent x < (visibleExtent x + topCorner x))
        ifTrue:
            [newTopCorner x: (fullExtent x - visibleExtent x max: 0).
            ].
    (fullExtent y < (visibleExtent y + topCorner y))
        ifTrue:
            [newTopCorner y: (fullExtent y - visibleExtent y max: 0).
            ].
    (newTopCorner ~= topCorner)
        ifTrue:
            [delta := topCorner - newTopCorner.
            delta := (delta x roundTo: self cellSize x) @ (delta y roundTo: self cellSize y).
            self scrollTopCorner: delta.
            ].! 
cacheCellSize
    "Private"

    cellSize := (self cellWidth * self font width) @ self cellHeight! 
colorMethod
    "Answer aSymbol or nil, the message selector that will be sent to
    each object in the list to determine its foreground color.  If nil, the
    default table pane foreground color is used."

    ^colorMethod!   
triggerCellClickedEvent

    self event: #cellClicked. " OBSOLETE "
    self triggerEvent: #cellClicked: with: self cellClicked.!  
deferredhighlightCell: aCell
    "Private"

    self hasFocus ifTrue: [ super deferredhighlightCell: aCell ].! 
toggleSelectRow: anInteger
        "Select the specified row."
    selectedRows class = Set ifFalse: [
        self selectRows: (
            selectedRows isNil
                ifTrue: [ Set new ]
                ifFalse: [ selectedRows asSet ] ) ].
    (selectedRows includes: anInteger)
        ifTrue: [ selectedRows remove: anInteger ]
        ifFalse: [ selectedRows add: anInteger ].
    self redrawRow: anInteger.!   
cellAt: aPoint perform: aSelector ifFail: aBlock
    "Private - Send aSelector to the specified row/cell.
        Evaluate aBlock if it cannot be done."
    | object cell |
    aPoint isPoint & aSelector isSymbol ifTrue: [
        self usesObjects
            ifTrue: [
                (aPoint y between: 1 and: cells size) ifTrue: [
                    object := cells at: aPoint y ]]
            ifFalse: [
                (aPoint y between: 1 and: self rows) ifTrue: [
                    (object := cells at: aPoint ifAbsent: [ nil ]) isString ifTrue: [
                        object := nil ]]]].
    object notNil ifTrue: [
        ^object perform: aSelector ].
    ^aBlock value! 
backColor: aColor
    "Force the cell texteditor to have the same backcolor as
     the table editor"

    super backColor: aColor.
    self textEditor isNil
        ifFalse:
            [self textEditor backColor: aColor.
            ].!
deferChildren
    "Private"

    ^self owner deferChildren!
currentRow
        "Private"
    ^nil!  
triggerColumnClickedEvent

    self event: #columnClicked. " OBSOLETE "
    self triggerEvent: #columnClicked: with: self columnClicked.!  
canReorder
    "Private"

    ^canReorder & sparseStorage not! 
copyElements: aMatrix
    "Copy the elements of aMatrix into the reciever"

    1 to: aMatrix size
        do:
            [:row |
            (row <= self size)
                ifTrue:
                    [1 to: (aMatrix at: row) size
                        do:
                            [:column |
                            (column <= (self at: row) size)
                                ifTrue:
                                    [self
                                            atRow: row
                                            column: column
                                            put: (aMatrix atRow: row column: column)].
                            ].
                    ].
            ].!
labelMethod: aSymbol
    "Set the method used to determine the row label an item"

    labelMethod := aSymbol! 
isOkToChange
        "Private"
    | array |
    array := self propertyAt: #selectionChanged ifAbsent: [ nil ].
    array notNil ifTrue: [
        self textEditor notNil ifTrue: [
            self textEditor cellValidate ifFalse: [
                self basicChangeAborted.
                ^false ] ].
        [ self triggerCellAboutToChangeAt: (array at: 1) value: (array at: 3) ]
            on: VetoAction do: [
                self basicChangeAborted.
                ^false ].
        self textEditor notNil ifTrue: [
            self textEditor hideWindow ] ].
    self basicIsOkToChange ifFalse: [
        self basicChangeAborted.
        ^false ].
    self commitChange.
    ^true!   
drawExtraBottomArea
    "Private - blank over any excess window size below
     the number of rows"

    | rect visRect cornerPoint region |
    visRect := self visibleRectangle.
    cornerPoint := (self pointForCell: self totalCells + 1) + 1.
    visRect height < cornerPoint y
        ifTrue: [^self].
    rect :=
        0 @ (cornerPoint y lowerOf: self headerExtent y)
            rightBottom: visRect rightBottom.
    self doGraphics: [
        region := self pen setClipRect: self tempClipRect.
        self pen fill: rect color: self headerColor.
        self pen destroyRegion: region ].!   
editorFramingBlock
    "Private"

    ^[:b |
        (self inVisibleBounds: self selection) not | self isValid not
            ifTrue: [10000 @ 10000 extent: 10 @ 10]
            ifFalse: [(self rectForCell: self selection) insetBy: 3].
        ]!
fieldToReorderForPoint: aPoint
    "Private"

    | x offset |
    offset := topCorner x + aPoint x.
    x := self headerExtent x.
    ^self columnHeaders
        detect:
            [:field |
            offset between: x and: (x := x + field fieldPixelWidth)]
        ifNone: [nil].!   
foreColor
    "Private"

    ^foreColor!   
deleteAll
        "Remove all contents from the receiver."
    self isCellSelectMode ifFalse: [ self selectRows: #( ) ].
    cells := OrderedCollection new.
    self rows: cells size.
    selectedCell y: ((selectedCell y min: self rows) max: (1 min: self rows)).
    self isValid
        ifTrue: [self updateSelectedCell: true].
    self rowWithFocus: nil.
    self redraw.!   
header
    "Private"

    header isNil
        ifTrue: [header := ''].
    ^header!  
triggerRowClickedEvent
    "Private"

    self event: #rowClicked. " OBSOLETE "
    self triggerEvent: #rowClicked: with: self rowClicked.
    self triggerSelectEvent.
    self triggerChangedSelectedIndexesEvent!
shouldProcess: wordInteger controlKey: controlKey
        "Private - Answer true if the receiver should process the keystroke."
    self isReadOnly ifTrue: [ ^false ].
    (wordInteger = NumLockKey) ifTrue: [ ^false ].
    (wordInteger = UpKey) | (wordInteger = DownKey)
        | (wordInteger = LeftKey) | (wordInteger = RightKey)
        | (wordInteger = PageUpKey) | (wordInteger = PageDownKey)
        | (wordInteger = HomeKey) | (wordInteger = EndKey) ifFalse: [ ^true ].
    (self superWindow cpStyle = #arrowKeysMove
        | controlKey)
        ifTrue: [ ^false ].
    ^true!   
dragTargetMultipleItem
		"Private - answer whether instances of the receiver can accept
		multiple-item transfers when drag-drop enabled."
    ^true!  
at: aPoint ifAbsent: aBlock
    "Answer the element at aPoint. Evaluate aBlock
     if aPoint is out of bounds."

    | extent |
    extent := self extent.
    (aPoint x > extent x or: [ aPoint y > extent y ])
        ifTrue: [ ^aBlock value ].
    ^self at: aPoint!
currentField
        "Answer the index of the field with focus."
    self isCellSelectMode
        ifTrue: [ ^selectedCell x ]
        ifFalse: [ ^nil ]! 
scrollTopCorner: aPoint
unlimited: ignored
    "Private"

    | oldCorner scrollRect point scrollRanges |
    oldCorner := topCorner deepCopy.
    topCorner := topCorner - aPoint.
    scrollRect := self scrollableRectangle.
    topCorner y: ((topCorner y min: scrollRect height) max: 0).
    scrollRanges := self getScrollRanges.
    topCorner x: ((topCorner x min: scrollRanges x) max: 0).
    oldCorner = topCorner
        ifTrue: [^false].
    oldCorner y = topCorner y
        ifTrue:
            [scrollRect := self verticalScrollAreaRectangle.
            ]
        ifFalse:
            [
            "If they scroll in both directions at once, we'd better not
     try blitting, since both row and column headers will both
     need to be updated."
            oldCorner x = topCorner x
                ifFalse:
                    [self
                        invalidateRect: self rectangle;
                        updateWindow.
                    self event: #scrolled. " OBSOLETE "
                    self triggerEvent: #scrolled.
                    ^oldCorner ~= topCorner].
            scrollRect := self horizontalScrollAreaRectangle.
            ].
    point := oldCorner - topCorner.
    point y < 0
        ifTrue: [point y: (point y max: scrollRect height negated)]
        ifFalse: [point y: (point y min: scrollRect height)].
    parent isDialogTopPane
        ifTrue: [scrollRect := scrollRect insetBy: 1].
    UserLibrary
            scrollWindow: handle
            xAmount: point x
            yAmount: point y
            lpRect: scrollRect asParameter
            clipRect: scrollRect asParameter.
    self updateWindow.
    self event: #scrolled. " OBSOLETE "
    self triggerEvent: #scrolled.
    ^oldCorner ~= topCorner!  
showFocusInCell: aCell
    "Private"

    self showFocusInCell: aCell color: Color black.! 
cellForPoint: aPoint
    "Private"

    ^(aPoint + topCorner - self headerExtent max: 0 @ 0) // self cellSize + 1! 
rectForHeader: field
    "Private"

    | startX |
    startX := self rect left right: self leftMargin - (self fieldMargin // 2) + 1.
    1 to: (fields indexOf: field) - 1
        do:
            [:i |
            startX := startX + (fields at: i) fieldPixelWidth + self fieldMargin].
    ^Rectangle leftTop: startX @ self rect top rightBottom: startX + field fieldPixelWidth + self fieldMargin - 1 @ (self rect top down: headerHeight - 1)! 
rows: rows
columns: columns
    "Create a matrix with the dimension of rows and columns."

    | matrix |
    matrix := self new: rows.
    1 to: rows
        do:
            [:row |
            matrix at: row put: (Array new: columns)].
    ^matrix!  
initializeTextEditor
    "Private"

    self initializeTextEditor: nil!
header: aString
    "Private"

    header := aString!  
cells
    "Private"

    ^cells!   
exposedRectangle
    "Private"

    ^self scrollAreaRectangle! 
colorMethod: aSymbol
    "Set the method used to access the color of each item"

    colorMethod := aSymbol!   
setReadOnly
    "Make the text editors read only."
    "Remember whether we're in arrowKeysEdit or arrowKeysMove mode
    before we trash cpStyle."

    | lastStyle |
    self isValid ifFalse: [ ^self whenValid: #setReadOnly ].
    lastStyle := self propertyAt: #cpStyle ifAbsent: [#arrowKeysEdit].
    "Assert: we're only going to save the arrowKey values for cpStyle in the property."
    (#(arrowKeysEdit arrowKeysMove) includes: lastStyle)
        ifTrue: [self propertyAt: #oldCpStyle put: lastStyle].
    self propertyAt: #cpStyle put: #readOnly.
    super setReadOnly.!  
insertBlankItems
    "Private"

    | strNonST |
    self isHandleOk & list notNil
        ifFalse: [^self].
    self noRedraw: true.
    UserLibrary
            sendMessage: handle
            msg: LbResetcontent
            wparam: 0
            lparam: 0.
    list size
        timesRepeat:
            [strNonST := ExternalAddress copyToNonSmalltalkMemoryZ: '' asParameter.
            UserLibrary
                    sendMessage: handle
                    msg: LbInsertstring
                    wparam: self class listEnd "LitEnd in low word"
                    lparam: strNonST asParameter.
            strNonST free.
            ].
    self noRedraw: false.!
constructNotifications
        "Private - answer the mapping between host control
        notification codes and corresponding Smalltalk event
        notifications."
	^super constructNotifications
        at: CbnCloseup put: #notifyListHidden: ;
        yourself!
foreColorAt: aPoint
        "Private"
    | color |
    (self isDisabled: aPoint) ifTrue: [
        color := self disabledForeColor ].
    color isNil ifTrue: [
        color := self basicForeColorAt: aPoint ].
    color isNil ifTrue: [
        color := self foreColor ].
    ^color!  
dragTargetFormatsDefault
        "Private - answer the formats of drag objects that the receiver will accept."
    ^#( 'object' )!  
defaultShowGrid
    "Private"

    ^true!  
maxRowsToAutoSize
    "Answer the maximum # of rows that calcFieldSizes checks
     to determine an appropriate column width. Decreasing this
     number will yield faster load times. Increasing this number
     will yield a more accurate column width."

    ^32! 
columnReordered
    "Return the column number of the column that was reordered"

    ^self columnClicked!  
canResize
    "Answer aBoolean indicating whether the user can dynamically resize the
    column widths by dragging the divider between the column labels."

    ^canResize!  
sortOn: column
ascending: aBoolean
    "Sort the matrix on the specified column, a column index."

    | cells |
    cells := aBoolean
        ifTrue:
            [self
                asSortedCollection:
                    [:a :b |
                    (a at: column) <= (b at: column)]]
        ifFalse:
            [self
                asSortedCollection:
                    [:a :b |
                    (a at: column) >= (b at: column)]].
    1 to: self size
        do:
            [:row |
            self at: row put: (cells at: row)].!  
wmVScroll: aWordInteger
with: aLongInteger
    "Private - handle vertical scrolling"

    | type maxVert factor pos |
    type := aWordInteger lowWord.
    type = SbLineup
        ifTrue: [self scrollVertical: self amountToScrollUp].
    type = SbLinedown
        ifTrue: [self scrollVertical: self amountToScrollDown].
    type = SbPageup
        ifTrue: [self scrollVertical: self amountToPageUp].
    type = SbPagedown
        ifTrue: [self scrollVertical: self amountToPageDown].
    (type = SbThumbposition) | (type = SbThumbtrack)
        ifTrue:
            [pos := aWordInteger highWord.
            maxVert := self scrollableRectangle height / cellSize y.
            factor := (maxVert / 32767) ceiling.
            pos := pos * factor.
            pos > (maxVert / 2)
                ifTrue: [pos := pos + factor - 1].
            pos := pos * cellSize y.
            self scrollVertical: self topCorner y - pos.
            ^nil].
    self updateVerticalSlider.
    ^nil! 
canResize: aBoolean
   "Set whether the user can dynamically resize the column widths."

    canResize := aBoolean!
scrollVertical: scrollAmount
    "Private - Scroll the pane down by anInteger
     number of pixels (if positive) or up by
     the absolute value of anInteger (if negative)."

    self scrollTopCorner: 0 @ scrollAmount.
    self isCellSelectMode ifTrue: [
        self highlightCell: selectedCell ].!  
unHighlightCell: aCell
    "Private"

    | drawRect region |
    (aCell isNil or: [self isValid not])
        ifTrue: [^self].
    "Clip it in case the cell would draw in the header"
    self
        doGraphics:
            [region := self pen setClipRect: self highlightClipRect.
            drawRect := (self rectForCell: aCell) insetBy: 1.
            self
                pen foreColor: self backColor;
                drawRectangle: drawRect;
                foreColor: self foreColor;
                destroyRegion: region.
            self drawLeftVerticalLine.
            ].!
canReorderRows
    "Private"

    ^(self propertyAt: #canReorderRows) == true & sparseStorage not! 
rightButtonScroll: point
        "Private - Do right button scrolling."
	^self basicRightButtonScroll: point!   
list
    "Private"

    ^list! 
cellValidate
        "Validate the receiver's contents before focus shift."
    ^true!  
wmKeydown: wordInteger with: longInteger
        "Private - Process the key down message."
    | answer |
    answer := super wmKeydown: wordInteger with: longInteger.
    (self shouldProcess: wordInteger controlKey: Notifier isControlKeyDown) ifTrue: [ ^answer ].
    ^true!  
button1DownShift: aPoint
    "Private"

    ^self button1Down: aPoint! 
fieldForPoint: aPoint
    "Answer aTPTableColumnPart if aPoint is within the bounds of a column.
    If it outside a column boundary, answer nil."

    | column |
    column := self fieldToReorderForPoint: aPoint.
    column = 0 ifTrue: [^nil ].

    "If you click BELOW the rows, cellForPoint: returns a row number 1 greater than the number of rows.
    However, if you click to the RIGHT of the last column, cellForPoint: returns the last column number."

    ^(self cellForPoint: aPoint) y > totalCells y
        ifTrue: [nil]
        ifFalse: [column]! 
triggerColumnReorderedEvent: aTableColumn
        "Private"
    self event: #columnReordered. " OBSOLETE "
    self triggerEvent: #columnReordered: with: aTableColumn.!   
updateSliders
    "Private - Update the slider boxes in the scrollbars."

    handle = NullHandle
        ifTrue: [^self].
    self updateVerticalSlider.
    self updateHorizontalSlider!  
maxIconHeight
    "Private"

    | max |
    max := self iconHeight.
    children notNil
        ifTrue:
            [children
                do:
                    [:child |
                    max := max max: child maxIconHeight.
                    ].
            ].
    ^max!
cellShowCaret

   UserLibrary showCaret: self handle.!  
deselectAll
        "Deselect all rows."
    self isCellSelectMode ifFalse: [ self selectRows: #( ) ].! 
new

    ^super new initialize! 
font
	"Answer the font for the receiver."

	^super font isNil
		ifTrue: [self defaultFont]
		ifFalse: [super font]!  
selectionMode
		"Private - Answer the selection mode."
    ^selectionMode ifNil: [ ^#cell ]!
showFocusInCell: aCell
    "Private"

    | point width |
    point := self pointForCell: aCell.
    width := self totalCells x * self cellSize x max: self rectangle width.
    self doGraphics: [self pen drawFocusRect: (point rightBottom: width @ (point y + self cellSize y))].!  
drawGridIn: range
    "Private - draw the grid"

    | x x2 y y2 pixelStart fullExtent region |
    self showGrid
        ifFalse: [^self].
    pixelStart := self pointForCell: range leftTop.
    fullExtent := self fullExtent + 1.
    x := pixelStart x.
    y := 0.
    self
        doGraphics: [
            self pen foreColor: self gridColor.
            region := self pen setClipRect: self tempClipRect.
            self pen lineFrom: (x2 := self scrollAreaRectangle left) @ y to: x2 @ (y2 := y down: (fullExtent y - topCorner y min: self rect height)).
            self pen lineFrom: x @ y to: x @ y2.
            (range left max: 1) to: (range right min: totalCells x)
                do:
                    [:c |
                    x := x right: (self pixelCellWidth: c).
                    self pen lineFrom: x @ y to: x @ (y down: (fullExtent y - topCorner y min: self rect height)).
                    ].
            self pen destroyRegion: region.
            x := 0.
            y := pixelStart y.
            region := self pen setClipRect: ((self tempClipRect leftTop down: self headerExtent y - 2) rightBottom: self tempClipRect rightBottom).
            (range top max: 1) to: (range bottom min: totalCells y + 1)
                do:
                    [:r |
                    self pen lineFrom: x @ y to: (x right: fullExtent x - topCorner x) @ y.
                    y := y down: self cellSize y.
                    ].
            self pen destroyRegion: region.
            self pen foreColor: self foreColor.
            ].!
leftMargin
    "Private"

    ^1!  
deleteRowAt: anInteger
        "Delete the object in the receiver's collection of objects."
    | range |
    self usesObjects ifFalse: [ ^self ].
    (anInteger between: 1 and: cells size) ifFalse: [ ^self ].
    cells removeIndex: anInteger.
    totalCells := totalCells - (0 @ 1).
    self rowWithFocus notNil ifTrue: [
        self rowWithFocus: (
            self rowWithFocus min: totalCells y ) ].
    self isCellSelectMode
        ifTrue: [
            selectedCell y >= anInteger
                ifTrue: [
                    selectedCell := selectedCell x @ (selectedCell y - 1 max: 1).
                    self updateSelection ] ]
        ifFalse: [
            self selectRows: (
                (self selectedRows
                    reject: [ :each | each = anInteger ])
                    collect: [ :each |
                        each < anInteger
                            ifTrue: [ each ]
                            ifFalse: [ each - 1 ] ] ) ].
    range := self cellsToDraw.
    (range top max: anInteger)
        to: range bottom
        do: [ :each | self redrawRow: each ].
    self setScrollRanges.!
triggerColumnSortedEvent: aTableColumn
        "Private"

    self event: #columnSorted. " OBSOLETE "
    self triggerEvent: #columnSorted: with: aTableColumn!   
leftMargin
    "Private - answer the margin from the left side of the
     listbox, in pixels"

    ^self font width! 
display
    "Private - respond to repaint messages"

    self
        doGraphics:
            [self
                pen fill: self scrollAreaRectangle color: self backColor;
                backColor: self backColor.
            self displayHeader.
            (objects isNil or: [objects isEmpty])
                ifFalse:
                    [self displayObjects.
                    self isMultiSelect
                        ifTrue:
                            [self rawSelections
                                do:
                                    [:i |
                                    self highlightCell: 1 @ i].
                            ]
                        ifFalse:
                            [self highlightCell: selectedCell.
                            ].
                    ].
            self hasFocus
                ifTrue: [self showFocus].
            self displayLines.
            (self inWindowBuilder not and: [self parent isDialogTopPane])
                ifTrue:
                    [self
                        pen foreColor: Color darkGray;
                        drawRectangle: self rect.
                    ].
            ].! 
sparseStorage
    "Answer aBoolean indicating whether the table pane has been
    optimized for a more spread out set of objects."

    ^sparseStorage and: [usesObjects not]!
cr
        "Send the message to the parent."
    self superWindow cr.!  
removeColumnHeader: aTableColumnOrInteger
		"Remove a table column to the receiver."
	self setColumnHeaders: (
		self columnHeaders copy
			removeIndex: (
				aTableColumnOrInteger isInteger
					ifTrue: [ aTableColumnOrInteger ]
					ifFalse: [
						self columnHeaders
							indexOf: aTableColumnOrInteger
							ifAbsent: [ ^self ] ] );
			yourself ).!   
defaultColorMethod
    "Private"

    ^nil!
validation: aSymbol
    "Private"

    validation := aSymbol!  
cellValidate
        "Validate the receiver's contents before focus shift."
	^self validateContents!
contents
    "Answer the object list passed in"

    ^objects! 
contents
    "Answer the contents of the table"

    ^self cells.! 
needsKeyUpInput
        "Private - Answer true if the receiver processes key-up events."
    ^true! 
basicAddColumnHeader: aTableColumn
		"Private - add a table column to the receiver."
	| saveSelection index |
	saveSelection := selectedCell.
	index := columnHeader
		indexOf: aTableColumn
		ifAbsent: [
			columnHeader
				addLast: aTableColumn;
				size ].
	aTableColumn autoFieldWidth ifTrue: [
		aTableColumn fieldPixelWidth:
			(self class stringWidth: aTableColumn header using: self font) +
			self fieldMargin ].
	totalCells x: columnHeader size.
	selectedCell := index @ 1.
	self initializeTextEditor: index.
	aTableColumn editor resize: self rectangle.
	selectedCell := saveSelection.!  
isPointInHeader: aPoint
    "Private"

    ^aPoint y between: self rect top and: (self rect top down: self headerExtent y)!
drawFocusRectForRow: anInteger
        "Private - Ignored"!  
scrollBarWidth
    "Private"

    ^UserLibrary getSystemMetrics: SmCxvscroll!  
cellAt: aPoint
put: aString
    "Private - set the cell at aPoint to aString.  Public method is
     rowAt:column:put:, which allows either strings or integer indices."

    aPoint isNil
        ifTrue: [^self].
    cells isNil
        ifTrue:
            [self initializeCells.
            ].
    cells at: aPoint put: aString.!  
atRow: row
column: column
put: aString
    "Set the string that is at column@row to aString.   If there are labels
     (headers) associated with a given row or column, the argument for
     that coordinate may be a string within the label list rather than a numeric
     index.  Example rows/columns:  1@'Name', 'Name'@1,  'Name'@'Year', 1@1.
    Reset a property so that changed messages won't occur as a result of sending
    this message unless the user changes the cell contents afterwards. "

    | result |
    result := super
            atRow: row
            column: column
            put: aString.
    self propertyAt: #selectionChanged put: nil.
    ^result!   
triggerColumnSortedEvent

    self event: #columnSorted. " OBSOLETE "
    self triggerEvent: #columnSorted: with: self columnClicked.! 
initializeSelectedCell
        "Private"
    self sendInputEvent: #updateSelectedCell: with: false.!
triggerDoubleClickedAtValueEvent: cellCoordinate
    "Private - If the cursor was on a non-header cell in the receiver,
    trigger #doubleClickedAt: aCellCoordinate with: anObject, the contents of the cell at that point."

    (cellCoordinate x = 0 or: [cellCoordinate y = 0])
        ifFalse:
            [self
                triggerEvent: #doubleClickedAt:value:
                with: cellCoordinate
                with: (self atRow: cellCoordinate y column: cellCoordinate x)]!  
getBottomCell
    "Private"

    | cell rect scrollRect |
    cell := self cellForPoint: (self scrollAreaRectangle rightBottom leftAndUp: 2).
    rect := self rectForCell: cell.
    ^((scrollRect := self scrollAreaRectangle) containsPoint: rect rightBottom)
        ifTrue:
            [cell]
        ifFalse:
            [(scrollRect containsPoint: rect rightTop)
                ifTrue:
                    [cell up: 1]
                ifFalse:
                    [(scrollRect containsPoint: rect leftBottom)
                        ifTrue: [cell left: 1]
                        ifFalse: [cell - 1]]].!
cellContents

    ^self contents!   
defaultJustification
    "Private"

    ^#left!
doSetFocus
    "Private"

    self
        setFocus;
        showFocus!  
wmKeyup: wordInteger with: longInteger
        "Private - Clear the anchor if the shift key is released."
    wordInteger = ShiftKey ifTrue: [ self superWindow clearAnchor ].
    ^super wmKeyup: wordInteger with: longInteger.! 
selectedItems: aCollection
    "Set the selection of the listbox to aCollection."

    | indices index |
    indices := Set new.
    aCollection do: [ :obj |
        ( index := objects indexOf: obj ) > 0 ifTrue: [
            indices add: index ] ].
    self selections: indices.!  
triggerColumnClickedEvent: aTableColumnOrNil
    "Private - trigger the #columnClicked event if the argument is not nil.
    (a nil argument means the click point was left of column #1 or right of the last column)."

    self event: #columnClicked. " OBSOLETE "
    aTableColumnOrNil isNil
        ifFalse:
            [self event: #columnClicked. " OBSOLETE "
            self triggerEvent: #columnClicked: with: aTableColumnOrNil]! 
copyElements: aMatrix
missing: anObject
    "Copy the elements of aMatrix into the reciever
     using anObject to fill any gaps"

    self
        initialize: anObject;
        copyElements: aMatrix.!  
disabledForeColorDefault

    ^Color darkGray!  
addRow: anObject
        "Add anObject to the end of the receiver's collection of objects."
    self insertRow: anObject at: self totalCells y + 1.!
reframeEditors
    "Private"

    self textEditor.
    self children
        do:
            [:child |
            selection := child ~~ textEditor.
            child resize: self rectangle.
            ].
    selection := false!   
resize: aPoint
    "Private"

    super resize: aPoint.
    self reframeEditors!  
readOnly
        "Ignore"!   
expandOrCollapse
    "Private"

    collapsed := collapsed not.
    (self deferChildren and: [collapsed not and: [children notEmpty]])
        ifTrue:
            [children
                do:
                    [:child |
                    child children == nil
                        ifTrue: [child getChildren]]].!
cellList: aCollection
        "Ignored"! 
canSort
    "Answer aBoolean indicating whether the user can sort the rows
    in a table according to the values in a column by right-clicking on a column label."

    ^canSort & sparseStorage not!
cellClicked
    "OBSOLETE"

    #obsoleteMethod.
    ^self boundedCellForPoint: self mouseLocation!   
commitSelection
    "Private"

    ^(self event: #commitSelection) ~= false!   
indentWidth: anInteger
    "Set the number of characters to indent each level of the hierarchy"

    indentWidth := anInteger! 
inVisibleBounds: aCell
    "Private"

    aCell isNil
        ifTrue: [^false].
    ^(self getTopCell extentFromLeftTop: self visibleCells - 1) containsPoint: aCell!
supportedEvents
    "Private"

    ^super
        supportedEvents add: #getFields;
        add: #columnResized;
        add: #columnReordered;
        yourself!   
characterInput: aCharacter
		"Perform row selection if read only."
	aCharacter = Cr ifTrue: [
        self cr.
		^true ].
	self isReadOnly ifTrue: [
		^self superWindow characterInput: aCharacter ].
	^super characterInput: aCharacter! 
atRow: anInteger
    "Answer the row at anInteger."

    ^super at: anInteger! 
defaultStyle
        "Private - Answer the default style for combo box."
    ^super defaultStyle | CbsAutohscroll!  
setSelector
    "Private"

    ^setSelector!   
sortOn: column
ascending: aBoolean
    "Sort the matrix on the specified column."

    | selector |
    selector := (fields at: column) selector.
    self
        contents:
            (aBoolean
            ifTrue:
                [(self contents
                    asSortedCollection:
                        [:a :b |
                        (a perform: selector) <= (b perform: selector)])]
            ifFalse:
                [(self contents
                    asSortedCollection:
                        [:a :b |
                        (a perform: selector) >= (b perform: selector)])]) asOrderedCollection! 
amountToScrollRight
    "Private"

    | topCell |
    (topCell := self getTopCell) x = self columnHeaders size
        ifTrue: [^0].
    ^(self pixelCellWidth: topCell x) negated!
getBottomCell
    "Private - Answer the lower right visible cell"

    ^self getTopCell + self fullyVisibleCells - (1 @ 1)!
editorFramingBlockFor: anEditor
    "Private"

    | rect left |
    ^[:b |
        ((self inVisibleBounds: self selection) not | self isValid not or: [selection])
            ifTrue:
                [10000 @ 10000 extent: 10 @ 10]
            ifFalse:
                [rect := (self rectForCell: self selection) insetBy: anEditor cellInset.
                (rect left isLeftOf: (left := self scrollAreaRectangle left right: 1))
                    ifTrue: [rect := Rectangle leftTop: (left @ rect top) rightBottom: rect rightBottom].
                rect].
        ]! 
add: aWindow
interestIn: name
    "Private"!
selectedItem
    "Answer the selected item"

    ^self basicCellAt: selectedCell!  
supportsDragDropObjects
    "Does the receiver support receiving full
     objects in a drag/drop transfer"

    #obsoleteMethod.
    ^true! 
defaultShowRowHeader
    "Private"

    ^true! 
selectedObject
    "Answer the selected object"

    ^self usesObjects
        ifTrue:
            [self cells size < selectedCell y
                ifTrue: [^nil].
            self cells at: selectedCell y]
        ifFalse:
            [self basicSelectedItem].!  
wmKeyup: wordInteger with: longInteger
        "Private - Clear the anchor if the shift key is released."
    wordInteger = ShiftKey ifTrue: [ self superWindow clearAnchor ].
    ^super wmKeyup: wordInteger with: longInteger.! 
dragTargetDropDefault: dragSession
        "Private - provide default handling of drop if no handler
        is provided by inserting the item into the list."
    | addList index collection |
    addList := OrderedCollection new.
    dragSession objects do: [ :each |
		(self isCompatibleDragObject: each) ifTrue: [
			(self contents includes: each object) ifFalse: [
				addList add: each object ] ] ].
    addList isEmpty ifTrue: [ ^self ].
    index := ((self cellForPoint: dragSession targetLocation) y min: self contents size + 1) max: 1.
    collection := self contents asOrderedCollection.
    addList
        reverseDo:
            [:each |
            collection add: each beforeIndex: index].
	dragSession source == self ifTrue: [
		self dragSourceSelection notNil ifTrue: [
			self dragSourceSelection: (
				self dragSourceSelection collect: [ :each |
					each < index
						ifTrue: [ each ]
						ifFalse: [ each + addList size ] ] ) ] ].
    self contents: collection asArray.
	self redraw.!
triggerChangedSelectedIndexesEvent
    "Private"

    self triggerEvent: #changedSelectedIndexes: with: self selectedRows.!
triggerRightClickedEventFor: column
    "If aPoint is in a column that has a non-nil name and an action registered for the event,
    (i.e. a link from the receiver to a menu), trigger #rightClicked<ColumnName>.
    Otherwise, trigger #rightClicked to get the default tablePane menu or
    whatever action may be registered for the event."

    | eventName fieldSpecificEvent |
    eventName := #rightClicked. "the default"
    column isNil
        ifFalse:
            [fieldSpecificEvent := self menuEventNameFor: column.
            (fieldSpecificEvent notNil and: [self hasActionForEvent: fieldSpecificEvent])
                ifTrue: [eventName := fieldSpecificEvent]].
    self triggerEvent: eventName!  
needsKeyUpInput
        "Private - Answer true if the receiver processes key-up events."
    ^true! 
pointForCell: aCell
    "Private"

    ^0 @ ((aCell y - 1) * self cellSize y) - topCorner + self headerExtent! 
displayLines
    "Private"

    | startX saveColor |
    self showLines
        ifFalse: [^self].
    startX := self leftMargin - topCorner x.
    saveColor := self pen foreColor.
    self doGraphics: [
        fields
            do:
                [:f |
                startX := startX + f fieldPixelWidth + self fieldMargin.
                self
                    pen foreColor: self foreColor;
                    lineFrom: startX - (self fieldMargin // 2) @ 0 to: startX - (self fieldMargin // 2) @ self rect bottom;
                    foreColor: saveColor.
                ]].!  
columns
    "Answer the total number of columns"

    ^totalCells x!   
getDefaultDragObjects
    "Private"

    | dragObjects |
    #obsoleteMethod.
    (dragObjects := self propertyAt: #defaultDragObjects) isNil
        ifTrue: [^nil].
    self renderAsObjects
        ifFalse:
            [dragObjects := dragObjects
                collect:
                    [:each |
                    each asString]].
    ^dragObjects! 
isCompatible: anObject
    "Is <anObject> compatible with the receiver"

	#obsoleteMethod.
    ^((nameMethod isNil or: [anObject respondsTo: nameMethod]) and: [(childrenMethod isNil or: [anObject respondsTo: childrenMethod]) and: [(colorMethod isNil or: [anObject respondsTo: colorMethod]) and: [(iconMethod isNil or: [anObject respondsTo: iconMethod]) and: [(iconExpandMethod isNil or: [anObject respondsTo: iconExpandMethod]) and: [(initialStateMethod isNil or: [anObject respondsTo: initialStateMethod])]]]]])! 
constructSynchronousNotifications
        "Private - answer the mapping between host control
        notification codes and corresponding Smalltalk event
        notifications."
    ^super constructSynchronousNotifications
        at: CbnDropdown put: #notifyListVisible: ;
        at: CbnCloseup put: #notifyListHidden: ;
        yourself!   
setTopCell: aCell
    "Private"

    | newTop |
    newTop := (0 @ (aCell y - 1)) * self cellSize.
    self scrollTopCorner: topCorner - newTop.
    self updateVerticalSlider.
    self updateHorizontalSlider.!  
defaultStyle
    "Private - Answer an Integer with appropriate styles in it."

    ^WsBorder | WsHscroll | WsVscroll | WsChild | WsVisible!
keyboardInput: aKeyboardInputEvent
        "Private - keyboard input was received."
    | virtualKey newSel down |

    (selectedCell isNil or: [
        aKeyboardInputEvent isControlKeyDown
        | aKeyboardInputEvent isShiftKeyDown
    ]) ifFalse: [
		virtualKey := aKeyboardInputEvent virtualKey.
        virtualKey = UpKey
            ifTrue:
                [self selection = 1
                    ifTrue: [^self].
                down := false.
                newSel := (self selection - 1) max: 1.
                ].
        virtualKey = DownKey
            ifTrue:
                [self selection = objects size
                    ifTrue: [^self].
                newSel := (self selection + 1) min: objects size.
                down := true.
                ].
        virtualKey = HomeKey
            ifTrue:
                [newSel := 1.
                down := true.
                ].
        virtualKey = EndKey
            ifTrue:
                [down := false.
                newSel := objects size].
        virtualKey = PageUpKey
            ifTrue:
                [newSel := (selectedCell y - (self fullyVisibleCells y - 1) max: 1).
                down := newSel = 1.
                ].
        virtualKey = PageDownKey
            ifTrue:
                [newSel := (selectedCell y + (self fullyVisibleCells y - 1) min: objects size).
                down := newSel ~= objects size.
                ].
        virtualKey = LeftKey
            ifTrue:
                [self scrollHorizontal: self amountToScrollLeft.
                ^self updateHorizontalSlider].
        virtualKey = RightKey
            ifTrue:
                [self scrollHorizontal: self amountToScrollRight.
                ^self updateHorizontalSlider].
        down notNil ifTrue: [
            down
                ifTrue:
                    [newSel := (newSel to: objects size)
                        detect:
                            [:i |
                            (self isDisabled: 0 @ i) not]
                        ifNone: [self selection].
                    ]
                ifFalse:
                    [newSel := (newSel to: 1 by: -1)
                        detect:
                            [:i |
                            (self isDisabled: 0 @ i) not]
                        ifNone: [self selection].
                    ].
            (newSel notNil and: [(newSel > 0) & (newSel <= objects size)])
                ifTrue:
                    [self isOkToChange = false
                        ifFalse:
                            [self selection: newSel.
                            self triggerSelectEvent.
                            ].
                    ].
            ^self ].
        ].
    ^super keyboardInput: aKeyboardInputEvent!   
textEdit
    "Private"

    ^textEdit ~= false!
basicHasFocus
        "Answer true if the receiver (not it's children) has focus."
    ^WindowHandle queryFocus = self handle!  
displayWidth: aFont
    "Private"

    | charWidth |
    charWidth := aFont width.
    ^(self leftMargin * charWidth) + (self depthInTree * self indentWidth * charWidth) + self iconWidth + (self iconMargin * charWidth) + (aFont stringWidth: self listString)!   
supportedEvents
    "Private"

    ^Set
        new add: #commitSelection;
        add: #doubleClickSelect;
        add: #getContents;
        add: #getPopupMenu;
        add: #commitSelection;
        add: #select;
        add: #aboutToExpandOrCollapse;
        add: #charInput;
        yourself! 
display
    "Private - display the spreadsheet using the current cliprect as a guide
     to which cells to draw"

    | range drawRect hrfColor fColor hrbColor bColor rowsToHighlight |
    (self propertyAt: #disableRepaint) == true
        ifTrue: [^self].
    self
        doGraphics:
            [drawRect := self exposedRectangle.
            self pen fill: (self headerExtent extent: (self fullExtent x - self headerExtent x - topCorner x @ (self fullExtent y - topCorner y min: self rect height))) color: self backColor.
            range := self cellsToDraw.
            self
                drawRowHeaderIn: range;
                drawColumnHeaderIn: range;
                drawGridIn: range;
                drawExtraBottomArea;
                drawExtraRightArea.
            (rowsToHighlight := self basicSelectedRows) notNil ifTrue: [
                hrfColor := self highlightRowForeColor.
                hrbColor := self highlightRowBackColor ].
            (range top max: 1) to: (range bottom min: self rows)
                do:
                    [:r |
                    (rowsToHighlight notNil
                        and: [ rowsToHighlight includes: r ])
                            ifTrue: [
                                fColor := hrfColor.
                                bColor := hrbColor ]
                            ifFalse: [
                                fColor := bColor := nil ].
                    (range left max: 1) to: (range right min: self totalCells x)
                        do:
                            [:c |
                            self
                                drawCell: c @ r
                                clipRect: drawRect
                                foreColor: fColor
                                backColor: bColor.
                            ].
                    ].
            self sendInputEvent: #deferredhighlightCell: with: self selection.
            ].! 
basicCellAt: aPoint
    "Private - answer the cell contents at a given point.  Public method is
     basicAtRow:column:, which allows either strings or integer indices."

    | cell selector |
    (cells isNil or: [cells isEmpty]) ifTrue: [^''].
    selector := (columnHeader at: aPoint x) selector.
    self usesObjects
        ifTrue:
            [(aPoint y <= 0 or: [aPoint y > cells size]) ifTrue: [^''].
            selector isNil ifTrue: [ ^'' ].
            ^(cells at: aPoint y) perform: selector ].
    (cell := cells at: aPoint ifAbsent: [nil]) notNil
        ifTrue:
            [selector isNil
                ifTrue: [^cell ]
                ifFalse: [^cell perform: selector ]]
        ifFalse: [^''].! 
isCompatibleDragObject: aDragObject
    "Private - Is <aDragObject> compatible with the receiver"

	| anObject |
	aDragObject hasObject ifFalse: [ ^false ].
	anObject := aDragObject object.
    self columnHeaders
        do:
            [:column |
            (anObject respondsTo: column selector)
                ifFalse: [^false]].
    ^true!  
wmKeydown: wordInteger with: longInteger
        "Private - Process the key down message."
    | answer |
    answer := super wmKeydown: wordInteger with: longInteger.
    (self shouldProcess: wordInteger controlKey: Notifier isControlKeyDown) ifTrue: [ ^answer ].
    ^true!  
columnHeaders: anOrderedCollection
    "Private"

    | saveSelection |

    saveSelection := selectedCell.
    super columnHeaders: anOrderedCollection.
    1 to: self columnHeaders size
        do:
            [:i |
                (anOrderedCollection at: i) setFont: self font.
            selectedCell := i @ 1.
            self initializeTextEditor: i.
            ].
    selectedCell := saveSelection.
    self calcFieldSizes.
    self isValid
        ifTrue:
            [self
                reframe;
                display]!   
expandOrCollapse
    "Expand or collapse the selected item."

    | selectedIndex |
    (selectedIndex := self selectedIndex) isNil
        ifTrue: [^self].
    "self disableRedraw."
    (list at: selectedIndex) expandOrCollapse.
    "list := self flatList.  <-- done in #updateListBox:"
    self updateListBox: true.
    self selectIndex: selectedIndex.
    "self enableRedraw."
! 
cellSize: anObject
    "Private"

    cellSize := anObject!
selectedColumn
    "Answer the selected column"

    self selection isNil
        ifTrue: [^1].
    ^self selection x!   
singleSelect
    "Set the listbox to single select mode"

    self rawSelections: nil.
    self propertyAt: #cpStyle put: #singleSelect.! 
cellForRow: row column: column
    "Answer cell coordinates (a Point).  If there are labels
     (headers) associated with a given row or column, the argument for
     that coordinate may be a string within the label list rather than a numeric
     index.  Example values:  1@'Name', 'Name'@1,  'Name'@'Year', 1@1  "

    | cell c r |
    column isString
        ifTrue:
            [self columnHeaders isNil
                ifTrue: [^self error: 'Need column names before indexing'].
            c := self indexOfHeader: column.
            c isNil
                ifTrue: [^self error: 'No column named: ' , column].
            ]
        ifFalse:
            [c := column.
            ].
    row isString
        ifTrue:
            [rowHeader isNil
                ifTrue: [^self error: 'Need row names before indexing'].
            r := (rowHeader indexOf: row).
            ]
        ifFalse:
            [r := row.
            ].
    ^c @ r.! 
contents: objectList
fields: aFieldList
    "Set the contents and fields of the listbox"

    objects := objectList.
    fields := aFieldList.
    self calcFieldSizes.
    selectedCell := nil.
    self isMultiSelect
        ifTrue: [selections := Set new].
    self isValid
        ifTrue:
            [self invalidateRect: nil.
            self updateRectangle.
            ].!  
heightWithoutDropDownList
		"Answer the height of the receiver when the drop down list is hidden."
	^self font height + 5!  
initialize
    "Private"

    justification := self defaultJustification.
    "font := self defaultFont."!
menuEventNameFor: aColumn
    "Answer the name of the event used to trigger the menu for this column,
    #rightClicked<ColumnName> if the column name is not empty or nil.
    Otherwise, answer nil."

    ^(aColumn name isNil or: [aColumn name isEmpty])
            ifTrue: [nil]
            ifFalse: [('rightClicked' , aColumn name) asSymbol]!   
dragSourceNeedsObjectDefault: dragSession
        "Private - provide default for requested drag items if no handler
        is provided by supplying the currently selected item."
    | dragDropObject itemIndex item |
    self selectedItem ifNil: [ ^self ].
    itemIndex := self itemIndexFromPoint: ( dragSession screenLocation mapToWindow: self ).
    item := (list at: itemIndex) object.
    dragDropObject := dragSession objectClass new
        object: item;
        string: ( self stringForItem: item );
        yourself.
    dragSession objects: ( Array with: dragDropObject )
!   
headerLetterStringFor: aNumber
    "Private - answer the spread sheet numbering
     for a given number (i.e. A, B, ..., AA, AB, ...)"

    | num string |
    num := aNumber - 1.
    string := ''.
    [num >= 26]
        whileTrue:
            [string := (String with: ((num \\ 26) + 65) asCharacter) , string.
            num := (num // 26) - 1.
            ].
    string := (String with: ((num \\ 26) + 65) asCharacter) , string.
    ^string! 
defaultDragDropCursor
    "Private - answer the cursor to display for this
     drag-drop operation, since no handler was
     registered to provide one."

    #obsoleteMethod.
    ^self selections size > 1
        ifTrue:
            [Notifier isAltKeyDown
                ifTrue: [CursorManager dragDropMove]
                ifFalse: [CursorManager dragDropCopy]]
        ifFalse:
            [Notifier isAltKeyDown
                ifTrue: [CursorManager dragDropMove]
                ifFalse: [CursorManager dragDropCopy]]!  
triggerColumnReorderedEvent

    self event: #columnReordered. " OBSOLETE "
    self triggerEvent: #columnReordered: with: self columnReordered.!  
editorFramingBlockFor: anEditor
    "Private"

    ^self editorFramingBlock!   
highlightCell: aCell
    "Private - highlight a given cell with an extra border"

    | drawRect region |
    (aCell isNil or: [self isValid not or: [self isCellSelectMode not]])
        ifTrue: [^self].
    "Clip it in case the cell would draw in the header"
    self
        doGraphics:
            [region := self pen setClipRect: self highlightClipRect.
            drawRect := (self rectForCell: aCell) insetBy: 1.
            self
                pen drawRectangle: drawRect;
                destroyRegion: region.
            self drawLeftVerticalLine.
            ].!
character: characterValidationSelector
    "Private - ignore."!  
inBounds: aCell
    "Private - answer whether the cell is within the existing
     number of cells"

    ^(aCell x >= 1) & (aCell y >= 1) & (aCell x <= self totalCells x) & (aCell y <= self totalCells y)!  
basicBackColorAt: aPoint
        "Private"
    ^nil!
amountToPageRight
    "Private"

    | amount totalWidth colWidth |
    amount := 0.
    totalWidth := self scrollAreaRectangle width.
    self getTopCell x to: self columnHeaders size - 1 do: [ :index |
        colWidth := self pixelCellWidth: index.
        (amount := amount + colWidth) > totalWidth ifTrue: [
            amount > colWidth ifTrue: [ amount := amount - colWidth ].
            ^amount negated ] ].
    ^amount negated!  
finalizeMoveOperation: dragDrop
    "Private - clean up after a drag & drop move operation"

    #obsoleteMethod.
    self
        contents:
            (self contents
            reject:
                [:elem |
                dragDrop items includes: elem]).!   
swapColumn: column1
with: column2
    "Swap the values in column1 with the values in column2"

    | row temp |
    1 to: self size
        do:
            [:y |
            row := self atRow: y.
            temp := row at: column1.
            row at: column1 put: (row at: column2).
            row at: column2 put: temp
            ].!
scrollTopCorner: newTopCorner
    "Private"

    self hasFocus
        ifTrue:
            [self hideFocus.
            ].
    super scrollTopCorner: newTopCorner.
    self hasFocus
        ifTrue:
            [self showFocus.
            ].! 
hasFocus
		"Answer true if the receiver or it's text editor has focus."
    | editor |
	^super hasFocus or: [
		(editor := self textEditor) notNil and: [
			editor hasFocus ] ]!
calcFieldSizes
    "Private - calculate new field sizes"

    | maxWidth result headerHeight field fieldFont object |
    self columnHeaders isNil
        ifTrue: [^self].
    cells isNil
        ifTrue:
            [self initializeCells.
            ].
    totalFieldWidth := 0.
    headerHeight := 0.
    1 to: self columnHeaders size
        do:
            [:index |
            field := self columnHeaders at: index.
            fieldFont := field font isNil ifTrue: [self font] ifFalse: [field font].
            headerHeight := headerHeight max: field headerLineCount * self font height.
            cellSize y: (cellSize y max: fieldFont height + 2).
            field autoFieldWidth
                ifTrue:
                    [maxWidth := self class stringWidth: field header using: self font.
                    1 to: (cells size min: self class maxRowsToAutoSize)
                        do:
                            [:i |
                            object := cells at: i.
                            (self usesObjects)
                                ifTrue:
                                    [result :=  field selector notNil
                                        ifTrue: [object perform: field selector]
                                        ifFalse: [''].
                                    ]
                                ifFalse:
                                    [(object size < index)
                                        ifFalse: [result := object at: index].
                                    ].
                            result isBitmap
                                ifTrue:
                                    [maxWidth := maxWidth max: result width.
                                    self cellSize: self cellSize x @ (self cellSize y max: result height).
                                    ]
                                ifFalse:
                                    [result isString
                                        ifFalse:
                                            [result := result printString.
                                            ].
                                    maxWidth := maxWidth max: (self class stringWidth: result using: fieldFont).
                                    ].
                            ].
                    field fieldPixelWidth: maxWidth + self fieldMargin.
                    ].
            totalFieldWidth := totalFieldWidth + field fieldPixelWidth.
            ].
    headerHeight := headerHeight + self headerMargin.
    showColumnHeader
        ifTrue: [self headerExtent y: headerHeight].!
iconMethod: aSymbol
    "Set the method used to access the icon of each item"

    iconMethod := aSymbol!  
amountToPageUp
    "Private"

    ^self rectangle height - self cellSize y roundTo: self cellSize y.!  
basicStyle
        "Private - Answer an Integer with appropriate
         constants combination for basic window style."
    ^super basicStyle | WsClipchildren!   
updateHorizontalSliderTo: integer
    "Private - Set the slider box in the scrollbar to integer."

	self isHandleOk ifFalse: [ ^self ].
    UserLibrary
            setScrollPos: self asParameter
            bar: SbHorz
            position: integer
            redraw: true.!   
iterate: aBlock
    "Perform aBlock with each combination of x and y coordinates"

    1 to: self size
        do:
            [:row |
            1 to: (self at: row) size
                do:
                    [:column |
                    aBlock value: row value: column].
            ].!   
initialize
    "Private"

    collapsed := false.! 
button1DoubleClick: aPoint
        "Private - pass to the parent."

    self showDropdown: false.
    self superWindow triggerDoubleClickEventFromChild: aPoint.! 
isReadOnly: aPoint
        "Private"
    ^(super isReadOnly: aPoint) or: [
        (self isDisabled: aPoint) or: [
            aPoint notNil & columnHeader notNil and: [
                (aPoint x between: 1 and: columnHeader size) and: [
                    (columnHeader at: aPoint x) isReadOnly ] ] ] ]!   
cells: aCollection
    "Private"

    cells := aCollection!
children
    "Private"

    ^children! 
button2Down: aPoint
    "Private"

    (self canSort and: [self isPointInHeader: aPoint])
        ifTrue:
            [Notifier isShiftKeyDown
                ifTrue: [self sortOn: self columnClicked ascending: false]
                ifFalse: [self sortOn: self columnClicked ascending: true].
            ]
        ifFalse:
            [
			#osiHack.
			super button2Down: aPoint.
"
			self propertyAt: #rightButton put: true.
            self button1Down: aPoint.
            self propertyAt: #rightButton put: nil.
"
            ].! 
textEditor
    "Private"

    ^textEditor := (self selectedColumn between: 1 and: self columnHeaders size)
        ifTrue: [(self columnHeaders at: self selectedColumn) editor]
        ifFalse: [nil].!
indexOfHeader: column
    "Private"

    ^self columnHeaders indexOf: column!  
characterInput: aCharacter
        "Private - Process the character input message."
    ( ( self hasActionForEvent: #characterTyped: ) or: [ self handlesEvent: #charInput ] )
        ifTrue: [
            self propertyAt: #characterTyped put: aCharacter.
            self event: #charInput.
            self triggerEvent: #characterTyped: with: aCharacter ]
        ifFalse: [
            self characterInputDefault: aCharacter ].!   
sparseStorage
    "Private"

    ^sparseStorage!   
defaultForeColor
	    "Private"
    ^Color windowText!  
font
    "Private"

    ^font ifNil: [ self defaultFont ]! 
colorMethod
    "Private"

    ^colorMethod!   
triggerSelectEvent

        self event: #select. " OBSOLETE "
        self triggerEvent: #clicked: with: self selectedItem.!   
isReadOnly
    "Private"

    ^self cpStyle == #readOnly.! 
triggerTextChangedEvent: contents

    self event: #textChanged. " OBSOLETE "
    self
            triggerEvent: #textChanged:cell:
            with: contents
            with: self selection.!   
amountToPageDown
    "Private"

    ^self amountToPageUp negated!  
menu: aMenu
    "Private"

    menu := aMenu!  
button1DownMultiSelect: aPoint
    "Private"

    | cell point currentSelection lastSelection |
    (self subpaneButton1Down: aPoint)
        ifFalse: [^self].
    self doSetFocus.
    currentSelection := selectedCell.
    cell := self boundedCellForPoint: self mouseLocation.
    (self inBounds: cell)
        ifFalse: [^nil].
    (self isSelected: cell y)
        ifTrue:
            [self rawSelections remove: cell y ifAbsent: [nil].
            self unHighlightCell: cell.
            currentSelection := selectedCell := cell.
            self showFocusInCell: cell]
        ifFalse:
            [self isOkToChange == false
                ifFalse:
                    [(self isDisabled: cell)
                        ifFalse:
                            [currentSelection := selectedCell := cell.
                            self rawSelections add: cell y.
                            self highlightCell: cell.
							self triggerMultiSelectEvent.
                            ]
                        ifTrue:
                            [self hideFocus.
                            ].
                    ].
            ].
    self
        whileMouseStillDown:
            [point := self mouseLocation.
            cell := self boundedCellForPoint: point.
            (self cell: currentSelection differsFrom: cell) & (self inBounds: cell)
                ifTrue:
                    [self hideFocus.
                    lastSelection := currentSelection.
                    self dragScrolls
                        ifTrue:
                            [self keepCellVisible: cell.
                            ].
                    self showFocusInCell: cell.
                    selectedCell := currentSelection := cell.
                    ].
            ].
    selectedCell := currentSelection.
    (self isDisabled: currentSelection)
        ifTrue:
            [self hideFocus.
            selectedCell := lastSelection.
            self showFocusInCell: lastSelection.
            (Smalltalk at: #Terminal) bell. "UserLibrary messageBeep: 0" ].! 
cr
        "Private - pass to the parent."
    self isDropdownVisible
        ifTrue: [
            self showDropdown: false.
            self event: #textChanged.    " OBSOLETE "
            self triggerEvent: #textChanged: with: self value ]
        ifFalse: [ self superWindow cr ].! 
selectedItems
    "Answer the selected items"

    self isMultiSelect
        ifTrue:
            [self
                selections:
                    (self selections
                    reject:
                        [:index |
                        index > objects size]) asOrderedCollection].
    ^self selections
        collect:
            [:index |
            objects at: index]! 
readOnly
        "Ignore"!   
selections: aCollectionOfIndices
    "Set the selection of the listbox to aCollectionOfIndices."

    | changed newSelections |
    self isMultiSelect ifFalse: [ ^self ].
    changed := false.
    self rawSelections do: [ :index |
        ( aCollectionOfIndices includes: index ) ifFalse: [
            self unHighlightCell: 1 @ index.
            changed := true ] ].
    newSelections := Set new.
    aCollectionOfIndices do: [ :index |
        ( index between: 1 and: objects size ) ifTrue: [
            newSelections add: index.
            ( self rawSelections includes: index ) ifFalse: [
                self highlightCell: 1 @ index.
                changed := true ] ] ].
    changed ifTrue: [
        self rawSelections: newSelections ].!   
characterInput: aCharacter
		"Private - Process the character input."
	aCharacter = Cr ifTrue: [ ^self superWindow cr ].
	^super characterInput: aCharacter!   
cellContents: anObject

    self contents: anObject asString.!  
isCompatible: anObject
    "Is <anObject> compatible with the receiver"

	#obsoleteMethod.
    self columnHeaders
        do:
            [:column |
            (anObject respondsTo: column selector)
                ifFalse: [^false]].
    ^true!   
refreshSelection
    "Private - Cause the selection to redraw"

    self refreshIndex: self selection! 
characterInputDefault: aCharacter
        "Process the character input message."
    | name curIndex selectedIndex |
    (selectedIndex := self selectedIndex) isNil
        ifTrue:
            [curIndex := 0.
            ]
        ifFalse:
            [name := (list at: selectedIndex) listString.
            ((name size > 0) and: [name first asUpperCase = aCharacter])
                ifTrue:
                    [curIndex := selectedIndex.
                    ]
                ifFalse:
                    [curIndex := 0.
                    ].
            ].
    curIndex + 1 to: list size
        do:
            [:i |
            name := (list at: i) listString.
            ((name size > 0) and: [name first asUpperCase = aCharacter])
                ifTrue:
                    [self selectIndex: i.
                    self triggerSelectEvent.
                    ^self].
            ].
    1 to: curIndex
        do:
            [:i |
            name := (list at: i) listString.
            ((name size > 0) and: [name first asUpperCase = aCharacter])
                ifTrue:
                    [self selectIndex: i.
                    self triggerSelectEvent.
                    ^self].
            ].!
scrollTopCorner: newTopCorner
    "Private"

    self isCellSelectMode ifTrue: [
        self unHighlightCell: selectedCell ].
    self textEditor hideWindow.
    (super scrollTopCorner: newTopCorner)
        ifTrue: [self propertyAt: #disableRepaint put: false].
    self textEditor resize: self rectangle.
    self isCellSelectMode ifTrue: [
        (self isReadOnly: selectedCell) ifFalse: [
            self textEditor
                sendInputEvent: #showWindow;
                sendInputEvent: #invalidateRect: with: nil ] ].! 
wmKeyup: wordInteger with: longInteger
        "Private - Clear the anchor if the shift key is released."
    wordInteger = ShiftKey ifTrue: [ self superWindow clearAnchor ].
    ^super wmKeyup: wordInteger with: longInteger.! 
iconMargin
    "Private"

    ^1!  
multipleSelect
    "Set the listbox to multiple select mode"

    self rawSelections: Set new.
    self propertyAt: #cpStyle put: #multipleSelect.!   
getClosestScrollPos: value
within: boundPoint
    "Private - answer a scrolling position that is as 'clean'
     as possible - if greater than one cell away already,
     cause a jump scroll by setting to the middle of the
     bound area"

    | newPos |
    (value >= boundPoint x) & (value <= boundPoint y)
        ifTrue: [^boundPoint x].
    (value = (boundPoint x - 1))
        ifTrue:
            [newPos := value.
            ]
        ifFalse:
            [(value = (boundPoint y + 1))
                ifTrue:
                    [newPos := boundPoint x + 1.
                    ]
                ifFalse:
                    [newPos := value - ((boundPoint y - boundPoint x) // 2).
                    ].
            ].
    ^newPos! 
selectedRow
    "Answer the selected row"

    self selection isNil
        ifTrue: [^1].
    ^self selection y! 
scrollHorizontal: scrollAmount
    "Private - Scroll the pane right by anInteger
     number of pixels (if positive) or left by
     the absolute value of anInteger (if negative)."

    self scrollTopCorner: scrollAmount @ 0.
    self isCellSelectMode ifTrue: [
        self highlightCell: selectedCell ].
    self drawLeftVerticalLine!  
setHExtent: pixelWidth
    "Private - Sets the width in pixels by which a list box can be
     scrolled horizontally."

    self isHandleOk
        ifTrue:
            [UserLibrary
                    sendMessage: self handle
                    msg: LbSethorizontalextent
                    wparam: pixelWidth
                    lparam: 0]
        ifFalse:
            [horizontalExtent := pixelWidth].!
colorMethod: aSymbol
    "Set the method used to access the color of each item"

    colorMethod := aSymbol!   
defaultCanReorder
    "Private"

    ^false!   
nameMethod
    "Private"

    ^self owner nameMethod!  
scrollTopCorner: aPoint
    "Private"

    ^self scrollTopCorner: aPoint unlimited: false.!
buildWindow: parentWindow
    "Subclassed to avoid the initial MDI display problem if the entry field is a child
     of another subpane.   Changed the origin of the rectangle to be outside the
     visible area"

    | ps parentFont |

    #osiHack.
    true ifTrue: [ ^super buildWindow: parentWindow ].

    style isNil
        ifTrue: [style := self frameStyle].
    self
            create: self windowClass
            title: self initialText
            style: style
            rectangle: (10000 @ 10000 extent: 0 @ 0)
            parent: self parent.
    handle = NullHandle
        ifTrue: [^nil].
    curFont isNil
        ifTrue:
            [curFont := (parentFont := parent font) isNil
                ifTrue: [self defaultFont]
                ifFalse: [parentFont]].
    self initGraphics.
    self receiveMessages.
    children size ~= 0
        ifTrue:
            [self childrenInBuildOrder
                do:
                    [:each |
                    (each buildWindow: self) isNil
                        ifTrue:
                            [self close.
                            ^nil]]].
    self buildControl: parentWindow!  
cursorOnFieldHeader: aPoint
    "Private"

    ^(self fieldToResizeForPoint: aPoint) notNil!   
fieldIndexForPoint: aPoint
    "Private - Answer the index of the column that aPoint is within.
    If it's not in any column, answer 0.  The y coordinate is ignored."

    | x offset |
    offset := topCorner x + aPoint x.
    x := self headerExtent x.
    ^(1 to: self columnHeaders size)
        detect:
            [:i |
            offset between: x and: (x := x + (self columnHeaders at: i) fieldPixelWidth)]
        ifNone: [0].!   
contents: objectList
    "Set the contents of the table"

    cells := objectList.
    self calcFieldSizes.
    self calcHeaderExtent.
    self rows: objectList size.
    selectedCell y: ((selectedCell y min: self rows) max: (1 min: self rows)).
    self isValid
        ifTrue: [
            "Old"
            "self updateSelectedCell: true"

            "New"
            self clearCurrentCell.
            self display.
            self updateRectangle.
            self hasFocus ifTrue: [
                self highlightCell: selectedCell ].
            self updateSelection.
            self isCellSelectMode & self hasFocus ifTrue: [
                (self isReadOnly: selectedCell) ifFalse: [
                    self
                        textEditor showWindow;
                        setFocus ] ].
            ].!  
pixelCellWidth: column
    "Private"

    column < 1
        ifTrue: [^super pixelCellWidth: column].
    ^(self columnHeaders at: column) fieldPixelWidth!  
disableMethod
    "Private"

    ^disableMethod!   
columnHeaders
    "Answer the list of column headers being displayed.
        WARNING!!  Do NOT add/remove headers to/from this
        list as it could BREAK the table pane.  Use the
        >>addColumnHeader: >>removeColumnHeader:
		and >>setColumnHeaders: methods."

    ^columnHeader!   
cellWidth: numChars
    "Set the width of a cell, in characters"

    cellWidth := numChars.
    self cacheCellSize.
    self cellSize x: numChars * self font width!
cellContents: anObject

	self selectIndex: ( self indexOf: anObject ).! 
supportedEvents
    "Private"

    ^super
        supportedEvents add: #doubleClickSelect;
        add: #select;
        add: #commitSelection;
        add: #scrolled;
        yourself! 
disableMethod: aSymbol
    "Set the method used to determine whether an item is disabled"

    disableMethod := aSymbol!   
foreColor: aColorOrSelector
    "Private"

    foreColor := aColorOrSelector.! 
cellHideCaret

    UserLibrary hideCaret: self handle.! 
justificationString
    "Private"

    | string |
    string := self justification asString.
    string at: 1 put: (string at: 1) asUpperCase.
    ^string! 
validatedCellForPoint: aPoint
    "Private - If aPoint is outside the bounds of the visible cells, answer 0 for that coordinate. "

    | x y point |
    x := self fieldIndexForPoint: aPoint.
    y := self rowIndexForPoint: aPoint.
    " Transcript show: (x@y) asString; cr. "
    ^x @ y!   
button1DownRowSelect: aPoint
        "Private"
    | anchor cell rowNum mode oldCell min max first |

    self rows < 1 | self isCellSelectMode ifTrue: [ ^self ].
    (mode := self selectionMode) = #cell ifTrue: [ ^self ].

    cell := self cellForPoint: aPoint.
    cell := cell x @ (cell y min: self rows).
    oldCell := cell.
    rowNum := cell y min: self rows.
    anchor := self anchorFor: rowNum.

    mode = #single ifFalse: [
        Notifier isControlKeyDown ifTrue: [
            mode = #multi
                ifTrue: [ mode := #extended ]
                ifFalse: [ mode := #multi ] ].
        mode = #multi
            ifTrue: [
                self toggleSelectRowsAndTriggerEvent: (
                    (anchor min: rowNum) to: (anchor max: rowNum) ) ]
            ifFalse: [
                self selectRowsAndTriggerEvent: (
                    (anchor min: rowNum) to: (anchor max: rowNum) ) ] ].

    first := true.
    self
        rowWithFocus: nil;
        whileMouseStillDownDo: [ :theMouseLocation |
            first ifTrue: [ first := false ] ifFalse: [
                cell := self cellForPoint: theMouseLocation.
                cell := cell x @ (cell y min: self rows).
                oldCell = cell ifFalse: [
                    rowNum = cell y ifFalse: [
                        rowNum := cell y.
                        mode = #single ifFalse: [
                            mode = #multi ifTrue: [
                                min := rowNum min: oldCell y.
                                max := rowNum max: oldCell y.
                                rowNum >= anchor
                                    ifTrue: [ oldCell y >= anchor ifTrue: [ min := min + 1 ] ]
                                    ifFalse: [ oldCell y >= anchor ifFalse: [ max := max - 1 ] ].
                                self toggleSelectRowsAndTriggerEvent: (
                                    (min to: max) asOrderedCollection
                                        remove: anchor ifAbsent: [ ];
                                        yourself ) ]
                            ifFalse: [
                                self selectRowsAndTriggerEvent: ((anchor min: rowNum) to: (anchor max: rowNum)) ] ] ].
                    oldCell := cell.
                    self keepCellVisible: cell ] ] ];
        rowWithFocus: rowNum.

    mode = #single ifTrue: [ "Select the one row and trigger all the row selection events"
        self selectRowsAndTriggerEvent: (Array with: rowNum) ].!  
mouseMove: aPoint
    "Private"

    super mouseMove: aPoint.
    self canResize
        ifFalse: [^self].
    ((self isPointInHeader: aPoint) and: [self cursorOnFieldBoundary: aPoint])
        ifTrue:
            [cursor = #leftRight
                ifFalse:
                    [SizeWe change.
                    cursor := #leftRight.
                    ].
            ^self].
    cursor = #normal
        ifFalse:
            [CursorManager normal change.
            cursor := #normal.
            ].! 
button1DoubleClick: aPoint
		"Private"
	self
		doSetFocus;
		triggerDoubleClickEvent: aPoint! 
defaultShowLines
    "Private"

    ^false!
cellForPoint: aPoint
    "Private"

    | point start |
    point := ((0 @ 0 rightAndDown: ((aPoint leftAndUp: self headerExtent) rightAndDown: topCorner)) max: 0 @ 0).
    start := 0.
    ^((1 to: self columnHeaders size)
        detect:
            [:i |
            (point x between: start and: (start := start + (self pixelCellWidth: i)))]
        ifNone: [self columnHeaders size]) @ (point y // cellSize y + 1)!   
addChild: node
    "Private"

    self children add: node! 
keyboardInput: aKeyboardInputEvent
		"Private - keyboard input was received."
	aKeyboardInputEvent isAltKeyDown ifFalse: [
		aKeyboardInputEvent virtualKey = TabKey
			ifTrue: [
				self superWindow tabKeyInput: aKeyboardInputEvent.
				^true ].
		(self
			shouldProcess: aKeyboardInputEvent virtualKey
			controlKey: aKeyboardInputEvent isControlKeyDown)
				ifFalse: [
					self superWindow keyboardInput: aKeyboardInputEvent.
					^true] ].
	^super keyboardInput: aKeyboardInputEvent!  
commitChange
        "Ignore"!   
fullyVisibleCells
    "Private - Answer the number of cells that are fully visible"

    ^self scrollAreaRectangle extent // self cellSize!
isReadOnly: ignore
    "Private"

    ^false!  
abortChange
        "Veto the change which is about to occur."
    super abortChange.
    self propertyAt: #selectionChanged put: nil.!
childEntryFieldClass
    "Private"

    ^CPChildEntryField!
textEditor
    "Private"

    ^textEditor! 
addColumnHeader: aTableColumn
		"Add a table column to the receiver."
	self setColumnHeaders: (
		self columnHeaders copy
			addLast: aTableColumn;
			yourself ).!  
depthInTree
    "Private"

    self parent isNil
        ifTrue: [^0]
        ifFalse: [^self parent depthInTree + 1].!  
constructEventsTriggered
    "Private - answer the set of events that instances of the
      receiver can trigger."

    ^super
        constructEventsTriggered addAll: #(aboutToExpandOrCollapse);
        remove: #drawItem:;
        remove: #measureItem:;
        yourself! 
basicChangeAborted
        "The change was aborted."
    !  
wmKeyup: wordInteger with: longInteger
        "Private - Clear the anchor if the shift key is released."
    wordInteger = ShiftKey ifTrue: [ self clearAnchor ].
    ^super wmKeyup: wordInteger with: longInteger.! 
selectedRows
        "Private"
    ^nil!
button2Up: aPoint
        "Private - Pass to parent to trigger the right click event."

   self superWindow button2Up: aPoint! 
bitmapForRowHeader: row in: aRectangle
    "Private - answer the bitmap for the specified row."

    | answer header x m r |

    header := self headerForRow: row.
    x := rowHeader notNil
        ifTrue: [self rowHeaderMargin]
        ifFalse: [(self headerExtent x - (self font wbStringWidth: header)) ].
    m := x @ (aRectangle height - self font height // 2).
    r := (0 @ 1 rightAndDown: m // 2) extentFromLeftTop: (aRectangle extent - m).
    self doGraphics: [
        (answer := Bitmap screenExtent: aRectangle extent)
            pen
                fill: answer boundingBox color: Color white;
                font: self font;
                setTextAlign: TaTop;
                setBackMode: Transparent;
                winDrawText: header
                    in: r format: SsCenter ].
    ^answer! 
displayHeader
    "Private - display the header of the listbox"

    | startX startY fieldBeginning hHeight ta |
    self showHeader
        ifTrue:
            [self
                pen font: self font;
                fill: (0 @ 0 extent: self visibleRectangle width @ self headerExtent y) color: self headerColor.
            startY := self headerMargin // 2.
            self
                pen setTextAlign: TaTop;
                setBackMode: Transparent;
                foreColor: self foreColor.
            fieldBeginning := topCorner x negated + self leftMargin.
            fields
                do:
                    [:f |
                    startX := fieldBeginning.
                    self pen
                            winDrawText: f header
                            in: (startX @ startY extentFromLeftTop: f fieldPixelWidth @ self headerExtent y)
                            format: f windowsJustification.
                    fieldBeginning := fieldBeginning + f fieldPixelWidth + self fieldMargin.
                    ].
            hHeight := self headerExtent y - 1.
            self
                pen lineFrom: 0 @ hHeight to: self visibleRectangle right @ hHeight;
                setBackMode: Opaque;
                setTextAlign: TaBaseline.
            ].!  
indentWidth
    "Private"

    ^self owner indentWidth!
triggerSelectEvent
    "Private"
    | index |
    self event: #select. " OBSOLETE "
    self
        triggerEvent: #select:
        with:
            (self isCellSelectMode
            ifTrue: [self basicCellAt: selectedCell]
            ifFalse: [
                (index := self rowWithFocus) isNil
                    ifTrue: [ nil ]
                    ifFalse: [
                        self usesObjects
                            ifTrue: [ cells at: index ]
                            ifFalse: [ index ] ] ] )! 
selectRowsAndTriggerEvent: aCollection
        "Private - Set the collection of selected rows
            then trigger the 'rowsSelected' event."
    | old |
    old := selectedRows.
    self selectRows: aCollection.
    self triggerRowsSelectedEvent: selectedRows old: old.! 
disabledBackColor
        "Answer the disabled background color
        OR nil if the default disabled background color should be used."

    ^self propertyAt: #disabledBackColor!   
contents: aCollection
    "Set the contents of the table"

    self cells: aCollection!
isDisabled: item
    "Is the item disabled?"

    | answer |
    item isPoint ifTrue: [
        columnHeader notNil ifTrue: [
            answer := (columnHeader at: item x) disabled ].
        answer isSymbol ifTrue: [
            answer := self cellAt: item perform: answer ifFail: [ nil ]].
        answer = true ifTrue: [ ^true ]].
    (answer := self disableMethod) isSymbol ifTrue: [
        answer := item isPoint
            ifTrue: [ self cellAt: item perform: answer ifFail: [ false ]]
            ifFalse: [ item perform: answer ].
        answer = true ifTrue: [ ^true ]].
    ^false!   
columnClicked
    "Return the column number of the column that was clicked on"

    ^self columnHeaders indexOf: self columnHeaderClicked! 
triggerChanged
		"Private - trigger the changed: event."
	self event: #textChanged.	" OBSOLETE "
	self triggerEvent: #textChanged: with: self value.!  
indexesSelectedBetween: old
and: new
    "Private - Answer a collection of integers that are in the new collection but not in the old collection,
    possibly empty.
    The arguments, new and old, represent collections of selected rows and can be
    any type of collection containing integers, or nil.    "

    ^new isNil
        ifTrue:
            [#()]
        ifFalse:
            [old isNil
                ifTrue:
                    [new]
                ifFalse:
                    [new reject:
                        [:each | old includes: each]]]

"For testing:
 CPTablePanePart new indexesSelectedBetween: nil and: nil.
 CPTablePanePart new indexesSelectedBetween: nil and: #(1 2 3 4 5).
 CPTablePanePart new indexesSelectedBetween: #(1 2 3 4 5) and: nil.
 CPTablePanePart new indexesSelectedBetween: #(1 2 3 4 5) and: #(1 2 3 4 5).
 CPTablePanePart new indexesSelectedBetween: #(1 2 3 4 5) and: #(1 2 3 4 5 6 7).
 CPTablePanePart new indexesSelectedBetween: #(1 2 3 4 5) and: #(1 2).
 CPTablePanePart new indexesSelectedBetween: #() and: #(1 2).
 CPTablePanePart new indexesSelectedBetween: #(1 2 4 ) and: #().
 CPTablePanePart new indexesSelectedBetween: #(1 2 3 4 5) and: #(6 7).
 CPTablePanePart new indexesSelectedBetween: #(1 2 5) and: #(1 2 3 4).
"! 
disableMethod: aSymbol
    "Set the method used to determine whether an item is disabled"

    disableMethod := aSymbol!   
supportedEvents
    "Private"

    ^super
        supportedEvents add: #getColumns;
        add: #columnResized;
        add: #columnReordered;
        add: #columnSorted;
        add: #columnClicked;
        add: #cellClicked;
        add: #rowReordered;
        add: #rowClicked;
        add: #rowsSelected;
        yourself!  
pointForCell: aCell
    "Private"

    | point |
    point := (self headerExtent leftAndUp: topCorner) down: (aCell y - 1) * self cellSize y.
    1 to: aCell x - 1
        do:
            [:c |
            point := point right: (self pixelCellWidth: c)].
    ^point!   
reframe
    "Private - the window just resized"

    self setScrollRanges.
    self scrollIfNecessary.
    self updateSliders.!  
isCompatibleDragObject: aDragObject
    "Private - Is <aDragObject> compatible with the receiver"

	| anObject |

	aDragObject hasObject ifFalse: [ ^false ].
	anObject := aDragObject object.
    ^((nameMethod isNil or: [anObject respondsTo: nameMethod]) and: [(childrenMethod isNil or: [anObject respondsTo: childrenMethod]) and: [(colorMethod isNil or: [anObject respondsTo: colorMethod]) and: [(iconMethod isNil or: [anObject respondsTo: iconMethod]) and: [(iconExpandMethod isNil or: [anObject respondsTo: iconExpandMethod]) and: [(initialStateMethod isNil or: [anObject respondsTo: initialStateMethod])]]]]])!  
altDownInWmChar: wordInteger with: longInteger
        "Private - Commit the change first..."
    self isOkToChange ifFalse: [ ^true ].
    ^super altDownInWmChar: wordInteger with: longInteger! 
constructEventsTriggered
    "Private - answer the set of events that instances of the
     receiver can trigger."

    ^super
        constructEventsTriggered
            addAll: #( textChanged:cell: clicked: cr toggledArrowKeys: );
        yourself!
triggerCellAboutToChangeAt: aPoint value: anObject
        "Private"
    self
        triggerEvent: #cellAboutToChangeAt:value:
        with: aPoint
        with: anObject.!
wmGetdlgcode: wParam
with: lParam
    "Private"

    ^DlgcWantallkeys!
at: aPoint
    "Answer the element at aPoint."

    ^aPoint isInteger
        ifTrue: [super at: aPoint]
        ifFalse: [self atRow: aPoint y column: aPoint x].!  
disabled
    "Private"

    ^disabled ifNil: [ false ]!
scrollVertical: scrollAmount
    "Private - Scroll the pane down by anInteger
      number of pixels (if positive) or up by
      the absolute value of anInteger (if negative)."

    self scrollTopCorner: 0 @ scrollAmount.!  
colorMethod
    "Private"

    ^self owner colorMethod!
headerColor: color
    "Private"

    headerColor := color!
getTopCell
    "Private - Answer the upper left visible cell"

    ^(topCorner // self cellSize) + 1!  
triggerRowsSelectedEvent: newSelectedRows
old: oldSelectedRows
    "Private - Trigger the following events:
        rowsSelected:
        changedSelectedIndexes:
        deselectedIndexes: (if one or more rows have been deselected)
        selectedIndexes: (if one or more rows have been selected)

            NOTE: newSelectedRows and oldSelectedRows can be
                any type of collection containing integers, or nil.
                If nil, then the arguments to the event should be an empty collection."

    | deselectedIndexes selectedIndexes |
    self event: #rowsSelected. " OBSOLETE "
    self triggerEvent: #rowsSelected: with: self selectedRows.
    self triggerChangedIndexEvent.
    self triggerChangedSelectedIndexesEvent.
    deselectedIndexes := self indexesDeselectedBetween: oldSelectedRows and: newSelectedRows.
    deselectedIndexes isEmpty ifFalse:
        [self triggerEvent: #deselectedIndexes: with: deselectedIndexes].
    selectedIndexes := self indexesSelectedBetween: oldSelectedRows and: newSelectedRows.
    selectedIndexes isEmpty ifFalse:
        [self triggerEvent: #selectedIndexes: with: selectedIndexes].
    self triggerSelectEvent! 
altDownInWmChar: wordInteger with: longInteger
        "Private - Commit the change first..."
    ^self superWindow altDownInWmChar: wordInteger with: longInteger! 
contents: objectList
    "Set the contents of the listbox"

    objects := objectList.
    selectedCell := nil.
    self isMultiSelect
        ifTrue: [selections := Set new].
    self calcFieldSizes.
    selectedCell := nil.
    self isValid
        ifTrue:
            [self invalidateRect: nil.
            self updateRectangle.
            ].!  
amountToPageLeft
    "Private"

    ^(self rectangle width - self scrollBarWidth) roundTo: self cellSize x!
getChildren
    "Private"

    | childrenMethod objectChildren |
    (childrenMethod := self childrenMethod) notNil
        ifTrue:
            [objectChildren := self transact: [object perform: childrenMethod].
            ].
    objectChildren notNil
        ifTrue:
            [children := objectChildren
                collect:
                    [:child |
                    self class new
                            object: child
                            owner: self owner
                            parent: self].
            ].!
cellAt: aPoint
put: aString
    "Private - set the cell at aPoint to aString.  Public method is
     rowAt:column:put:, which allows either strings or integer indices."

    | setSelector |
    aPoint isNil
        ifTrue: [^self].
    cells isNil
        ifTrue:
            [self initializeCells.
            ].
    setSelector := (columnHeader at: aPoint x) setSelector.
    self usesObjects
        ifTrue:
            [aPoint y > cells size
                ifTrue: [^self].
            setSelector isNil
                ifTrue: [^self].
            ^(cells at: aPoint y) perform: setSelector with: aString].
    (setSelector isNil or: [(cells at: aPoint ifAbsent: [nil]) isNil or: [aString isString not]])
        ifTrue: [cells at: aPoint put: aString]
        ifFalse: [(cells at: aPoint) perform: setSelector with: aString].!   
cellHideCaret

    UserLibrary hideCaret: self handle.! 
showHeader: aBoolean
    "Set whether the header should be shown or not"

    showHeader := aBoolean!  
isReadOnly
        "Answer true if the receiver is read only."
    ^self textEdit = false
        and: [
            self list isNil ]!   
calcHeaderExtent
    "Private"

    | headerHeight column |
    super calcHeaderExtent.
    showColumnHeader
        ifFalse: [^self].
    headerHeight := 0.
    1 to: self columnHeaders size
        do:
            [:index |
            column := self columnHeaders at: index.
            headerHeight := headerHeight max: column headerLineCount * self font height.
            ].
    headerHeight := headerHeight + self headerMargin.
    self headerExtent y: headerHeight.!
selection: aCell
    "Set the selected cell as a point"

    | shouldSetFocus readOnly |
    selectedCell = aCell
        ifTrue: [^self].
    (self isValid not or: [rectangle isNil or: [self inWindowBuilder]])
        ifTrue: [^self].
    readOnly := self isReadOnly.
    readOnly
        ifFalse:
            [shouldSetFocus := self hasFocus.
            shouldSetFocus
                ifTrue: [self textEditor cellHideCaret]
            ].
    self unHighlightCell: selectedCell.
    readOnly
        ifFalse:
            [self textEditor isNil
                ifTrue: [^self].
            self textEditor hideWindow.
            self updateWindow.
            ].
    selectedCell := aCell.
    self highlightCell: selectedCell.
    self keepSelectionVisible.
    readOnly
        ifFalse:
            [self updateSelection.
            "self textEditor resize: self rectangle."
            "shouldSetFocus &" self isCellSelectMode ifTrue:
                [(self isReadOnly: selectedCell) ifFalse:
                    [self textEditor
                        "sendInputEvent: #" showWindow;
                        "sendInputEvent: #" setFocus;
                        cellShowCaret.
                    ].
                ].
            ].!
dragScrolls
    "Private"

    ^true!  
resizeRows: row
columns: column
    "Alter the dimensions of the reciever to accommodate a new
     number of rows and columns"

    | aMatrix |
    aMatrix := CPMatrix rows: row columns: column.
    aMatrix copyElements: self.
    self become: aMatrix.!
font
    "Private"

    super font isNil
        ifTrue: [self font: self defaultFont].
    ^super font! 
cellShowCaret
    "Ignore because no caret in drop down list."!  
autoFieldWidth
    "Private"

    ^fieldWidth isNil!   
updateSelection
    "Private - move the texteditor to the new selection point"

    self reframeEditors.
    self textEditor
        foreColor: (self foreColorAt: selectedCell);
        backColor: (self backColorAt: selectedCell);
        cellList: (self listAt: selectedCell);
        cellContents: (self basicCellAt: selectedCell);
        selectAll.
    self updateWindow.!
amountToScrollDown
    "Private"

    ^self amountToScrollUp negated!  
editorFramingBlock
    "Private"

    | rect left |
    ^[:b |
        ((self inVisibleBounds: self selection) not | self isValid not or: [selection])
            ifTrue:
                [10000 @ 10000 extent: 10 @ 10]
            ifFalse:
                [rect := (self rectForCell: self selection) insetBy: 3.
                (rect left isLeftOf: (left := self scrollAreaRectangle left right: 1))
                    ifTrue: [rect := Rectangle leftTop: (left @ rect top) rightBottom: rect rightBottom].
                rect].
        ]!   
drawLeftVerticalLine
    "Private"

    | region rect |
    self doGraphics: [
        region := self pen setClipRect: self rect.
        rect := self scrollAreaRectangle.
        self pen
            lineFrom: rect left @ (self rect top down: 1) to: rect left @ (self fullExtent y - topCorner y min: self rect height);
            lineFrom: self rect left @ rect top to: (self rectForCell: totalCells) right - 1 @ rect top;
            destroyRegion: region ].!  
indexesDeselectedBetween: old
and: new
    "Private - Answer a collection of integers that were in the old collection but not in the new collection,
    possibly empty.
    The arguments, new and old, represent collections of selected rows and can be
    any type of collection containing integers, or nil.    "

    ^old isNil
        ifTrue:
            [#()]
        ifFalse:
            [new isNil
                ifTrue:
                    [old]
                ifFalse:
                    [old reject:
                        [:each | new includes: each]]]

"For testing:
 CPTablePanePart new indexesDeselectedBetween: nil and: nil.
 CPTablePanePart new indexesDeselectedBetween: nil and: #(1 2 3 4 5).
 CPTablePanePart new indexesDeselectedBetween: #(1 2 3 4 5) and: nil.
 CPTablePanePart new indexesDeselectedBetween: #(1 2 3 4 5) and: #(1 2 3 4 5).
 CPTablePanePart new indexesDeselectedBetween: #(1 2 3 4 5) and: #(1 2 3 4 5 6 7).
 CPTablePanePart new indexesDeselectedBetween: #(1 2 3 4 5) and: #(1 2).
 CPTablePanePart new indexesDeselectedBetween: #() and: #(1 2).
 CPTablePanePart new indexesDeselectedBetween: #(1 2 4 ) and: #().
 CPTablePanePart new indexesDeselectedBetween: #(1 2 3 4 5) and: #(6 7).
 CPTablePanePart new indexesDeselectedBetween: #(1 2 5) and: #(1 2 3 4).
"!  
resize: aPoint
    "Private"

    super resize: aPoint.
    self setTopCell: 1 @ self getTopIndex.
    self reframe! 
constructEventsTriggered
    "Private - answer the set of events that instances of the
     receiver can trigger."

    ^super
        constructEventsTriggered addAll: #(getFields columnResized: columnReordered: multipleSelect:);
        yourself! 
drawColumnHeaderIn: range
    "Private - display the header of the listbox"

    | startX startY fieldBeginning hHeight rect aRect charsDrawn region arect |
    rect := self visibleRectangle.
    self showColumnHeader
        ifTrue:
            [self
                doGraphics:
                    [region := self pen setClipRect: (0 @ 0 rightBottom: (self tempClipRect rightTop down: self headerExtent y + 1)).
                    self
                        pen font: self font;
                        fill: (0 @ 0 extentFromLeftTop: rect width @ self headerExtent y) color: self headerColor;
                        destroyRegion: region.
                    region := self pen setClipRect: ((self headerExtent x @ 0) rightBottom: (self tempClipRect rightTop down: self headerExtent y)).
                    startY := self headerMargin // 2.
                    self pen foreColor: self foreColor.
                    fieldBeginning := topCorner x negated + self headerExtent x.
                    self
                        pen backColor: self headerColor;
                        lineFrom: fieldBeginning @ 0 to: fieldBeginning @ headerExtent y;
                        setTextAlign: TaTop.
                    self columnHeaders
                        do:
                            [:f |
                            startX := fieldBeginning + (self fieldMargin // 2).
                            aRect := startX @ startY extentFromLeftTop: (f fieldPixelWidth - self fieldMargin) @ (self headerExtent y - (self headerMargin // 2)).
                            arect := self rectForHeader: f.
                            self
                                pen font: self font;
                                draw3DRect: (arect insetBy: -1);
                                winDrawText: f header
                                    in: aRect
                                    format: f windowsJustification.
                            fieldBeginning := fieldBeginning + f fieldPixelWidth.
                            self pen lineFrom: fieldBeginning @ 0 to: fieldBeginning @ headerExtent y.
                            ].
                    hHeight := self headerExtent y.
                    self pen lineFrom: 0 @ hHeight to: (fieldBeginning min: self rect right) @ hHeight.
                    self pen destroyRegion: region.
                    ].
            ].! 
deferChildren
    "Private"

    ^deferChildren!   
drawRowHeaderIn: range
    "Private - draw the row header within range cells.
     If no row header exists, use numbers"

    | startX startY header headerWidth arect |
    self showRowHeader
        ifFalse: [^self].
    startY := (self pointForCell: range leftTop) y + ((self cellSize y - self font height) // 2).
    self
        doGraphics:
            [self
                pen fill: (0 @ 0 extent: self headerExtent x @ (self fullExtent y min: self rect height)) color: self headerColor;
                setTextAlign: TaTop;
                font: self font;
                foreColor: self foreColor;
                setBackMode: Transparent.
            headerWidth := self headerExtent x.
            (range top max: 1) to: (range bottom min: self rows)
                do:
                    [:r |
                    header := self headerForRow: r.
                    rowHeader notNil
                        ifTrue:
                            [startX := self rowHeaderMargin.
                            ]
                        ifFalse:
                            [startX := (headerWidth - (self font wbStringWidth: header)) // 2.
                            ].

                    "Add 3D look"
                    (arect := self rectForRowHeader: r) notNil
                        ifTrue: [self pen draw3DRect: (arect leftTop extentFromLeftTop: arect extent + (1 @ 0))].

                    self pen displayText: header at: startX @ startY.
                    startY := startY + self cellSize y.
                    ].
            self pen setBackMode: Opaque].!  
field: fieldValidationSelector
    "Private - ignore."!  
amountToScrollLeft
    "Private"

    | topCell |
    (topCell := self getTopCell) x <= 2
        ifTrue: [^topCorner x].
    ^(self pixelCellWidth: topCell x - 1)!
asFullList
    "Private"

    | list |
    list := OrderedCollection new.
    list add: self.
    children notNil
        ifTrue:
            [children
                do:
                    [:child |
                    list addAll: child asFullList]].
    ^list! 
hasDynamicListSizeStyle
		"Answer the default value for the dynamic list size style."
	^true!   
tempClipRect
    "Private"

    ^(tempClipRect := self propertyAt: #tempClipRect) isNil
        ifTrue: [ self rect ]
        ifFalse: [ tempClipRect ]! 
initializeCells
    "Private"

    self usesObjects
        ifTrue: [^cells := OrderedCollection new].
    self sparseStorage
        ifTrue: [^cells := Dictionary new].
    cells := CPMatrix rows: totalCells y columns: totalCells x!  
cellsDo: aBlock
    "Perform aBlock with each element as an argument"

    1 to: self size
        do:
            [:row |
            1 to: (self at: row) size
                do:
                    [:column |
                    aBlock value: (self atRow: row column: column)].
            ].!
fieldToReorderForPoint: aPoint
    "Private"

    | x offset |
    offset := topCorner x + aPoint x.
    x := 0.
    ^fields
        detect:
            [:field |
            offset between: x and: (x := x + field fieldPixelWidth + self fieldMargin)]
        ifNone: [nil].!  
canReorderRows: aBoolean
    "Private"

    self propertyAt: #canReorderRows put: aBoolean!
isCellSelectMode
    "Private"

    ^self basicSelectedRows isNil! 
drawColumnHeaderIn: range
	"Private - draw the column header within range cells.
	 If no column header exists, use spreadsheet numbering
	 (A, B, ... AA, AB, ... )"

	| startX startY pixelCellWidth beginX header arect |
	self showColumnHeader
		ifFalse: [^self].
	pixelCellWidth := self cellSize x.
	beginX := ((range left max: 1) - 1) * pixelCellWidth + self headerExtent x - topCorner x.
	startY := self headerExtent y - self font height // 2.
	self
		doGraphics:
			[self
				pen fill: (0 @ 0 extent: self fullExtent x @ self headerExtent y) color: self headerColor;
				setTextAlign: TaTop;
				font: self font;
				foreColor: self foreColor;
				backColor: self headerColor].
	(range left max: 1) to: (range right min: self columns)
		do:
			[:c |
			columnHeader notNil
				ifTrue:
					[header := columnHeader at: c.
					]
				ifFalse:
					[header := self headerLetterStringFor: c.
					].
			startX := beginX + ((pixelCellWidth - (self font stringWidth: header)) // 2).
			arect := self rectForHeader: c.
			self doGraphics: [
				self pen
					draw3DRect: (arect insetBy: -1);
					displayText: header at: startX @ startY].
			beginX := beginX + pixelCellWidth.
			].!   
atColumn: anInteger
    "Answer the column at anInteger."

    | aList size |
    size := self size.
    aList := Array new: size.
    1 to: size
        do:
            [:r |
            aList at: r put: (self atRow: r column: anInteger)].
    ^aList.!   
defaultBackColor
    "Private"

    ^Color windowBackground!   
cellHeight
    "Private - Answer the height of a cell"

    ^super cellHeight + 3   "Add 3 for combo box height"!  
justification
    "Private"

    ^justification!   
wmKeyup: wordInteger with: longInteger
        "Private - Clear the anchor if the shift key is released."
    wordInteger = ShiftKey ifTrue: [ self superWindow clearAnchor ].
    ^super wmKeyup: wordInteger with: longInteger.! 
cr
        "Send the message to the parent."
    self superWindow cr.!  
defaultStyle
    "Private - Answer the default style for the receiver."

    ^EsAutohscroll!   
wmHScroll: wordInteger
with: longInteger
    "Private - Handle horizontal scrolling."

    | type pos |
    type := wordInteger lowWord.
    type = SbLineup
        ifTrue: [self scrollHorizontal: self amountToScrollLeft].
    type = SbLinedown
        ifTrue: [self scrollHorizontal: self amountToScrollRight].
    type = SbPageup
        ifTrue: [self scrollHorizontal: self amountToPageLeft].
    type = SbPagedown
        ifTrue: [self scrollHorizontal: self amountToPageRight].
    (type = SbThumbposition) | (type = SbThumbtrack)
        ifTrue:
            [pos := wordInteger highWord roundTo: (self pixelCellWidth: 1).
            (self topCorner x - pos) abs > 0
                ifTrue:
                    [self scrollHorizontal: self topCorner x - pos.
                    self updateHorizontalSliderTo: pos.
                    ].
            ^nil].
    self updateHorizontalSlider.
    ^nil! 
copyRows: row
columns: column
missing: anObject
    "Return a new matrix containing the elements of the reciever
     bounded by ow and column using anObject to fill any gaps"

    | aMatrix |
    aMatrix := CPMatrix rows: row columns: column.
    aMatrix copyElements: self missing: anObject.
    ^aMatrix.! 
gettingFocus
    "Private"

    self doSetFocus.
    super gettingFocus.! 
arrowKeyInput: anInt
    "Private - process keyboard input sent from texteditor.
		Answer true if handled, else false."

    | newSel downRight upDown selRange |

    downRight := upDown := true.
    anInt = UpKey
        ifTrue:
            [downRight := false.
            newSel := self selection x @ ((self selection y - 1) max: 1).
            ].
    anInt = DownKey
        ifTrue:
            [newSel := self selection x @ ((self selection y + 1) min: self rows).
            ].
    anInt = PageUpKey
        ifTrue:
            [self setTopCell: (newSel := (self getTopCell up: self fullyVisibleCells y - 1) max: 1 @ 1).
            newSel y = 1
                ifTrue: [downRight := true].
            ].
    anInt = PageDownKey
        ifTrue:
            [self setTopCell: (newSel := self getTopCell x @ (self getBottomCell y min: self rows)).
            newSel y = self rows
                ifTrue: [downRight := false].
            ].
    anInt = HomeKey
        ifTrue: [newSel := 1 @ 1].
    anInt = EndKey
        ifTrue:
            [newSel := self totalCells.
            downRight := false.
            ].
    anInt = LeftKey
        ifTrue:
            [downRight := upDown := false.
            newSel := (self selection x - 1 max: 1) @ self selection y].
    anInt = RightKey
        ifTrue:
            [upDown := false.
            newSel := (self selection x + 1 min: self columns) @ self selection y].
    newSel isNil
        ifTrue: [^false].
    newSel := self
            nextValidCell: newSel
            upDown: upDown
            downRight: downRight.
    (newSel notNil and: [super inBounds: newSel])
        ifTrue:
            [self isOkToChange == false
                ifFalse:
                    [self selection: newSel focus: true.
                    self triggerSelectEvent.
                    ].
            ].
	^true! 
triggerDoubleClickEventFromChild: aPoint
    "Private - Trigger
        #doubleClickSelect:
    and, if the cursor was on a non-header cell in the table pane, trigger
        #doubleClickedAt: aCellCoordinate with: cellContents
    where the arguments are for the currently selected cell. "

    super triggerDoubleClickEvent.    "doubleClickSelect:"
    self triggerDoubleClickedAtValueEvent: selectedCell.    "doubleClickedAt:value:"!  
selector: aSymbol
    "Private"

    selector := aSymbol!  
updateTotalFieldWidth
    "Private"

    fields isNil
        ifTrue: [^self].
    totalFieldWidth := 0.
    fields
        do:
            [:field |
            totalFieldWidth := totalFieldWidth + self fieldMargin + field fieldPixelWidth].
    totalFieldWidth := totalFieldWidth + self fieldMargin.
    totalCells := totalFieldWidth - 1 // self cellSize x + 1 @ objects size.! 
fieldMargin
    "Private - answer the width in pixels on each side of a field"

    ^self font width * 3!  
minimumFieldWidth
    "Private"

    ^self fieldMargin * 2!
setScrollRanges
    "Private - Set the ranges for the horizontal and vertical
     scroll bars."

    "Make the vertical scroll bar represent cell scrolling
        rather than pixel scrolling."

    | rangeRect minHorz maxHorz minVert maxVert rect fullExtent |
    self isHandleOk
        ifFalse: [^self].
    rangeRect := self scrollableRectangle.
    minHorz := 0.
    maxHorz := rangeRect width.
    minVert := 0.
    maxVert := rangeRect height.
    (self style notNil and: [self style bitAnd: WsHscroll]) = 0
        ifTrue: [maxHorz := 0].
    (self style notNil and: [self style bitAnd: WsVscroll]) = 0
        ifTrue: [maxVert := 0].
    rect := self realRectangle.
    fullExtent := self fullExtent.
    (rect width >= fullExtent x)
        ifTrue:
            [maxHorz := 0.
            ].
    maxHorz > 0
        ifTrue:
            [rect height >= (fullExtent y + self scrollBarHeight)
                ifTrue: [maxVert := 0].
            ]
        ifFalse:
            [rect height >= fullExtent y
                ifTrue: [maxVert := 0].
            ].
    maxVert > 0
        ifTrue:
            [maxVert := maxVert + cellSize y - 1 // cellSize y.
            "maxVert := maxVert / cellSize y.
            maxVert := (maxVert / (maxVert / 32767) ceiling) truncated."
            ].
    UserLibrary
            setScrollRange: self asParameter
            bar: SbHorz
            min: minHorz
            max: maxHorz
            redraw: false.
    UserLibrary
            setScrollRange: self asParameter
            bar: SbVert
            min: minVert
            max: maxVert
            redraw: false!   
triggerCrEvent
    "Private"
    "Occurs when user presses the enter key.
    Trigger both the following events:
        #entered
        #entered: aPointOrInteger value: anObject.
    If a cell is selected, then aPointOrInteger is a point and anObject is the contents of the cell.
    Otherwise, aPointOrInteger is the row number and anObject is the row object, both for the row with focus.
    The row with focus is not necessarily selected."

    | arg1 arg2 |
    self triggerEvent: #entered.
    self isCellSelectMode
        ifTrue:
            [arg1 := self selection.    "a point for the cell that is selected"
            arg2 := self selectedItem    "the contents of the selected cell"]
        ifFalse:
            [arg1 := self rowWithFocus.    "row number of the row with focus"
            arg2 := self contents at: arg1    "row object for the row with focus"].
    self
            triggerEvent: #entered:value:
            with: arg1
            with: arg2.!  
defaultForeColor
    "Private"

    ^Color windowText! 
totalCells
    "Private"

    ^totalCells! 
atRow: row
column: column
put: aString
    "Set the string that is at column@row to aString.   If there are labels
     (headers) associated with a given row or column, the argument for
     that coordinate may be a string within the label list rather than a numeric
     index.  Example rows/columns:  1@'Name', 'Name'@1,  'Name'@'Year', 1@1  "

    | cell |
    cell := self cellForRow: row column: column.
    self cellAt: cell put: aString.
    self isValid ifTrue: [
        cell = self selection ifTrue: [
            self textEditor cellContents: aString ].
        self invalidateRect: ((self rectForCell: cell) insetBy: 1 @ 1) ].! 
fontForColumn: anInteger
    "Private"

    ^self font!
fullExtent
    "Private - Answer the logical extent of ourselves, including any
     header and all the cells sizes."

    ^totalCells * cellSize + self headerExtent.!   
amountToPageLeft
    "Private"

    | amount totalWidth colWidth |
    amount := 0.
    totalWidth := self scrollAreaRectangle width.
    self getTopCell x - 1 to: 1 by: -1 do: [ :index |
        colWidth := self pixelCellWidth: index.
        (amount := amount + colWidth) > totalWidth ifTrue: [
            amount > colWidth ifTrue: [ amount := amount - colWidth ].
            ^amount ] ].
    ^amount!  
selectedItems
        "Answer the selected items"
    | answer |
    self isCellSelectMode ifTrue: [ ^nil ].
    self selectedRows isEmpty ifTrue: [ ^nil ].
    self usesObjects ifFalse: [ ^nil ].
    answer := OrderedCollection new: self selectedRows size.
    self selectedRows do: [ :each |
        (each between: 1 and: cells size) ifTrue: [
            answer add: (cells at: each) ] ].
    ^answer!
gettingFocus
        "Private - Make sure the window is visible."
    self hasFocus ifTrue: [
		self superWindow isCellSelectMode
			ifTrue: [
		        self showWindow.
        		super gettingFocus ]
			ifFalse: [
				self hideWindow.
				self superWindow setFocus ] ].!  
constructEventsTriggered
	"Private - answer the set of events that instances of the
	 receiver can trigger."

	^super constructEventsTriggered
		addAll: #(
			aboutToChange cellAboutToChangeAt:value: cellChangedAt:value:
			cellClicked: changed: changedIndex: changedSelectedIndexes:
			columnClicked: columnReordered: columnResized: columnSorted:
			deselectedIndexes: doubleClickedAt:value: doubleClickSelect:
			entered entered:value: rightClicked rowClicked: rowReordered:
			rowsSelected: select: selectedIndexes: tabbed );
		yourself
!
headerForRow: anInteger
    "Private"

    ^(self usesObjects and: [self labelMethod notNil and: [anInteger <= cells size]])
        ifTrue:
            [(cells at: anInteger) perform: self labelMethod.
            ]
        ifFalse:
            [(rowHeader notNil and: [anInteger <= rowHeader size])
                ifTrue:
                    [rowHeader at: anInteger.
                    ]
                ifFalse:
                    [anInteger printString.
                    ]]!   
button2Up: aPoint
        "Private - pass to the parent."

    ^(self superWindow hasActionForEvent: #rightClicked)
        ifTrue: [self superWindow triggerRightClickedEventFromChild: aPoint]
        ifFalse: [super button2Up: aPoint].!
shouldProcess: wordInteger controlKey: controlKey
        "Private - Answer true if the receiver should process the keystroke."

    (wordInteger = NumLockKey)
        | (wordInteger = LeftKey) | (wordInteger = RightKey) ifTrue: [ ^false ].

    (wordInteger = UpKey) | (wordInteger = DownKey)
        | (wordInteger = PageUpKey) | (wordInteger = PageDownKey)
        | (wordInteger = HomeKey) | (wordInteger = EndKey) ifFalse: [ ^true ].

    (self superWindow cpStyle = #arrowKeysMove
        | controlKey)
        ifTrue: [
            ^isListVisible = true ].

    ^true!
setPopupMenu: aMenu
    "Set the default popup menu of the table"

    self isHandleOk
        ifTrue: [
            super setPopupMenu: aMenu.
            self columnHeaders
                do:
                    [:header |
                    header editor popupMenu isNil
                        ifTrue: [header editor setPopupMenu: self popupMenu]]]
        ifFalse: [self whenValid: #setPopupMenu: with: aMenu].! 
getTopCell
    "Private"

    ^self cellForPoint: (self scrollAreaRectangle leftTop rightAndDown: 2)!  
cell: cell1
differsFrom: cell2
    "Private - answer whether one cell differs from another"

    cell1 isNil
        ifTrue: [^cell2 notNil].
    ^cell1 y ~= cell2 y!  
deleteSelectedRows
        "Delete all selected rows."
    | toBeRemoved range |
    self isCellSelectMode ifTrue: [
        ^self deleteRowAt: selectedCell y ].
    self selectedRows isEmpty ifTrue: [ ^self ].
    toBeRemoved := self selectedRows asSortedCollection.
    toBeRemoved reverseDo: [ :each |
        (each between: 1 and: cells size) ifTrue: [
            cells removeIndex: each ] ].
    self selectRows: #( ).
    totalCells := totalCells x @ (totalCells y - toBeRemoved size).
    self rowWithFocus notNil ifTrue: [
        self rowWithFocus: (
            self rowWithFocus min: totalCells y ) ].
    range := self cellsToDraw.
    (range top max: toBeRemoved first)
        to: range bottom
        do: [ :each | self redrawRow: each ].
    self setScrollRanges.!  
defaultFields
    "Private - set up the fields for a blank listbox"

    ^OrderedCollection
            with: (CPCLBField new header: 'Field 1')
            with: (CPCLBField new header: 'Field 2')
            with: (CPCLBField new header: 'Field 3').!
insertRow: anObject at: anInteger
        "Insert anObject in the receiver's collection of objects."
    | range index |
    self usesObjects ifFalse: [ ^self ].
    index := (anInteger min: self rows + 1) max: 1.
    cells add: anObject beforeIndex: index.
    totalCells := totalCells + (0 @ 1).
    self isCellSelectMode
        ifTrue: [
            selectedCell y >= index
                ifTrue: [
                    selectedCell := selectedCell x @ (selectedCell y + 1).
                    self reframeEditors ] ]
        ifFalse: [
            self selectRows: (
                self selectedRows
                    collect: [ :each |
                        each < index
                            ifTrue: [ each ]
                            ifFalse: [ each + 1 ] ] ) ].
    range := self cellsToDraw.
    (range top max: index)
        to: range bottom
        do: [ :each | self redrawRow: each ].
    self setScrollRanges.!  
wmHScroll: wordInteger
with: longInteger
    "Private - Process a WM_HSCROLL message."

    | type pos |
    type := wordInteger lowWord.
    type = SbLineup
        ifTrue: [self scrollHorizontal: self amountToScrollLeft].
    type = SbLinedown
        ifTrue: [self scrollHorizontal: self amountToScrollRight].
    type = SbPageup
        ifTrue: [self scrollHorizontal: self amountToPageLeft].
    type = SbPagedown
        ifTrue: [self scrollHorizontal: self amountToPageRight].
    (type = SbThumbposition) | (type = SbThumbtrack)
        ifTrue:
            [pos := wordInteger highWord.
            self updateHorizontalSliderTo: pos.
            self scrollHorizontal: self topCorner x - pos.
            ^nil].
    self updateHorizontalSlider.
    ^nil!  
justificationOffsetFor: aString
    "Private - Answer the offset within the field that the
     text should start displaying at for correct justification"

    | offset |
    (justification = #left)
        ifTrue:
            [offset := self cellTextOffset x.
            ]
        ifFalse:
            [(justification = #right)
                ifTrue:
                    [offset := self fieldPixelWidth - (self font wbStringWidth: aString) - self cellTextOffset x + 1.
                    ]
                ifFalse:
                    [offset := (self fieldPixelWidth - (self font wbStringWidth: aString)) // 2 + 1.
                    ].
            ].
    ^offset!  
triggerRightClickedEvent: aPoint
    "Right mouse button was clicked, sorting not on, or aPoint not in column header.
    If aPoint is in a column that has a non-nil name and an action registered for the event,
    (i.e. a link from the receiver to a menu), trigger #rightClicked<ColumnName>.
    Otherwise, trigger #rightClicked to get the default tablePane menu or
    whatever action may be registered for the event."

    self triggerRightClickedEventFor: (self fieldForPoint: aPoint)!  
dragTargetDropDefault: dragSession
        "Private - provide default handling of drop if no handler
        is provided by inserting the item into the list."

    | addList index addMethod node parentNode parentList collapsed |
    ( self dragTargetOperations includes: dragSession operation ) ifFalse: [ ^nil ].

    addList := dragSession objects.
	dragSession source == self
		ifTrue: [
			collapsed := (list at: self dragSourceSelection) collapsed ]
		ifFalse: [
			addList := addList select: [ :each |
				(objectList
					detect: [ :item | item object = each object ]
	            	ifNone: [ nil ]
				) isNil and: [ self isCompatibleDragObject: each ] ].
			collapsed := false ].

    ((addMethod := self addChildMethod) isNil or: [
		index := self itemIndexFromPoint: dragSession targetLocation.
		index > list size
	])	
		ifTrue: [
			addList do: [ :each |
				objectList add: (
					self nodeClass new
						collapsed: collapsed;
                        object: each object
                        owner: self
                        parent: nil ) ] ]
        ifFalse: [
			node := list at: index.
            addList do: [ :each |
				parentNode := node.
				parentList := Set new.
				parentList add: parentNode object.
				[(parentNode := parentNode parent) notNil]
					whileTrue: [parentList add: parentNode object].
				(parentList includes: each object) ifFalse: [
					node object perform: addMethod with: each object.
					node addChild: (
						self nodeClass new
							collapsed: collapsed;
							object: each object
							owner: self
							parent: node) ] ] ].

	dragSession source == self ifFalse: [ self updateListBox: true ].!  
defaultCanSort
    "Private"

    ^false!  
cellWidth
    "Answer the default width of a cell in characters."

    ^cellWidth! 
columnHeaders
    "Answer the list of column headers being displayed."

    ^self fields!  
iconExpandMethod
    "Private"

    ^self owner iconExpandMethod!  
canTriggerEvent: eventName
    "Answer <true> if the receiver can trigger an event
    named <eventName>. Check first with the class side to see if the eventName is
    in the standard list of events.  If it isn't, see if it's one of the rightClicked<ColumnName> events
    specific to this instance."

    | menuEvent |
    (super canTriggerEvent: eventName) ifTrue: [^true].
    self columnHeaders
        do:
            [:aColumn |
            eventName == (self menuEventNameFor: aColumn)
                ifTrue: [^true]].
    ^false!  
setDefaultDragObjects: aCollection
    "Set the default drag & drop objects for the receiver"

    #obsoleteMethod.
    self propertyAt: #defaultDragObjects put: aCollection!
fullExtent
    "Private - answer the total extent of the objects + the header"

    totalFieldWidth isNil
        ifTrue: [^super fullExtent].
    ^(totalFieldWidth @ (self totalCells y * self cellSize y)) + self headerExtent.!  
wmPaint: wordInteger with: longInteger
        "Private - Process the paint message."
	#obsoleteMethod.
    "self sendInputEvent: #displayBar."
    ^super wmPaint: wordInteger with: longInteger!
headerExtent
    "Private - answer the header extent, caching if nil"

    headerExtent isNil
        ifTrue: [self calcHeaderExtent].
    ^headerExtent!
gettingFocus
        "Private"
    self superWindow gettingFocus.!  
initialize
    "Private"

    super initialize.
    disabled := false.!   
dragSourceNeedsObjectDefault: dragSession
        "Private - provide default for requested drag items if no handler
        is provided by supplying the currently selected item."
    | indices dragObjects |

	indices := self selections reject: [ :index | index > objects size ].
	indices isEmpty ifTrue: [ ^self ].
	self dragSourceSelection: indices.

    dragObjects := self selectedItems asArray collect: [ :each |
		dragSession objectClass new
			object: each;
			string: each asString;
			yourself ].
    dragSession objects: dragObjects.! 
columnHeaderMargin
    "Private - answer pixel margin above and below column headers"

    ^4! 
highlightRowBackColor
        "Answer the background color used for highlighting rows."
    | answer |
    answer := self propertyAt: #highlightRowBackColor.
    answer notNil ifTrue: [ ^answer ].
    ^Color highlightBackground! 
rowHeaderMargin
    "Private"
    "Room for 3D effect and border."
    ^4! 
contentsNoResize: objectList
    "Private - Set the contents of the table"
    "Same as contents: except that field sizes are not recalculated."

    cells := objectList.
    "self calcFieldSizes."            "The field sizes are just fine. No need to recalculate them."
    self calcHeaderExtent.
    self rows: objectList size.
    selectedCell y: ((selectedCell y min: self rows) max: (1 min: self rows)).
    self isValid
        ifTrue: [self updateSelectedCell: true].! 
crShift
    "Private - process a carriage return from the text editor"

    | oldY y |

    self isCellSelectMode ifTrue: [ ^super crShift ].

    (oldY := self rowWithFocus) isNil
        ifTrue: [ y := oldY := 1 ]
        ifFalse: [ y := oldY - 1 max: 1 ].
    self rowWithFocus: nil.
    self keepCellVisible: 1 @ y.
    self rowWithFocus: y.!
notifyDoubleClicked: aParameter
        "Private - the host signaled that the receiver was double-clicked."

    self isOkToExpandOrCollapse == false
        ifFalse: [self expandOrCollapse].
	self triggerDoubleClickEvent.!  
setDragDropObjects
    "Set the drag & drop objects. This is the default handler for
      the #needsDragDropObjects event."

    #obsoleteMethod.
    self setDragDropObjects: self defaultDragDropObjects! 
rawSelections: aCollection
    "Private"

    selections := aCollection!   
type: aSymbol
    "Private"

    type := aSymbol!  
showWindow
        "Ignore if readOnly."
    self isReadOnly | self superWindow disabled
        ifFalse: [ super showWindow ].!   
canSort: aBoolean
    "Set whether the user can sort the entire list by right clicking
    on a column heading. (Shift right-click sorts in reverse order.)"

    canSort := aBoolean!
refreshIndex: anIndex
    "Private - Redisplay the object at index anIndex"

    (selectedCell notNil and: [anIndex = selectedCell y])
        ifTrue:
            [self highlightCell: 1 @ anIndex.
            ]
        ifFalse:
            [anIndex notNil
                ifTrue:
                    [self unHighlightCell: 1 @ anIndex.
                    ]].!   
dragTargetOperationForSelf: dragSession
		"Answer the operation when source = target = self."
	(self dragTargetOperations includes: #move) ifFalse: [ ^nil ].
	^#move! 
resizeField: field
start: aPoint
    "Private"

    | currentPoint lastPoint tooThin offset cursorLocation minimumFieldWidth |
    self textEditor hideWindow.
    currentPoint := aPoint.
    minimumFieldWidth := 10 "self minimumFieldWidth".
    tooThin := field fieldPixelWidth < minimumFieldWidth.
    self
        whileMouseStillDownPrim:
            [cursorLocation := self mouseLocation.
            offset := cursorLocation x - currentPoint x.
            (offset ~~ 0 and: [(offset < 0 & tooThin) not])
                ifTrue:
                    [(field fieldPixelWidth + offset) < minimumFieldWidth
                        ifTrue:
                            [currentPoint := (currentPoint x - (field fieldPixelWidth - minimumFieldWidth)) @ cursorLocation y.
                            field fieldPixelWidth: minimumFieldWidth.
                            tooThin := true.
                            ]
                        ifFalse:
                            [currentPoint := cursorLocation.
                            field fieldPixelWidth: field fieldPixelWidth + offset.
                            tooThin := false.
                            ].
                    self drawColumnHeaderIn: self totalCells.
                    lastPoint isNil
                        ifFalse: [self drawMovingLine: lastPoint x].
                    self drawMovingLine: currentPoint x.
                    lastPoint := currentPoint.
                    ].
            ].
    self updateTotalFieldWidth.
    self updateSelectedCell: true.
    self updateHorizontalSlider.
    self triggerColumnResizedEvent: field! 
updateTotalFieldWidth
    "Private"

    self columnHeaders isNil
        ifTrue: [^self].
    totalFieldWidth := 0.
    self columnHeaders
        do:
            [:field |
            totalFieldWidth := totalFieldWidth + "(self cellTextOffset x * 2) +" field fieldPixelWidth.
            ].!   
disabledBackColor: aColorOrNil
        "Set the disabled background color
        OR nil if the default disabled background color should be used."

    self propertyAt: #disabledBackColor put: aColorOrNil.!
selectedItem
    "Answer the selected item"

    list isNil | self selectedIndex isNil
        ifTrue: [^nil].
    ^(list at: self selectedIndex) object!
losingFocus
		"Private - The receiver is losing focus. "
	self hasFocus ifFalse: [
		self validateContents ifTrue: [
			self superWindow unHighlightSelectedCell.
			super losingFocus.
			self superWindow losingFocus ] ].!   
defaultBackColor
	    "Private"
    ^Color windowBackground!
scrollableRectangle
    "Private - Answer the rectangular area that can be scrolled
     (i.e. the full area - the visible area)"

    | scrollExtent |
    scrollExtent := (((self rectForCell: self totalCells) left - headerExtent x) @ (self totalCells y - 1 * self cellSize y)) max: 0 @ 0.
    scrollExtent := scrollExtent x @ ((scrollExtent y + self cellSize y - 1) truncateTo: self cellSize y).
    ^0 @ 0 rightBottom: scrollExtent! 
headerMargin
    "Private - answer the height (beyond the font height) of the
     header in pixels"

    ^7! 
rowIndexForPoint: aPoint
    "Private - Answer the index of the row that aPoint is within.
    If it's not in any row, answer 0.  The x coordinate is ignored."

    | y offset |
    offset := topCorner y + aPoint y.
    y := self headerExtent y.
    ^(1 to: self contents size)
        detect:
            [:i |
            offset between: y and: (y := y + cellSize y)]
        ifNone: [0].!
hideFocus
    "Private - Do Nothing"!
cellContents

    ^self text!   
dragTargetOperationFor: dragSession
        "Private - answer the operation that the reciever would perform
        for the current drag-drop transfer at the current location, or nil
        if invalid."
    | dragFormats dragOperations dragObject operation nodesToCut index start end |
    self isDragTarget ifFalse: [ ^nil ].
    ( dragFormats := self dragTargetFormats ) isNil ifTrue: [ ^nil ].
    ( dragOperations := self dragTargetOperations ) isNil ifTrue: [ ^nil ].
    ( dragSession objects size > 1 and: [ self dragTargetMultipleItem not ] ) ifTrue: [ ^nil ].

	dragSession source == self ifTrue: [
		^self dragTargetOperationForSelf: dragSession ].

    dragObject := dragSession objects
		detect: [ :each | self isCompatibleDragObject: each ]
		ifNone: [ ^nil ].

	operation := dragSession impliedOperation
		ifNil: [ dragSession defaultOperation ].
	(dragOperations includes: operation)
		ifFalse: [ operation := dragOperations first ].

	"If a move operation, then check to see that all objects can be
		accepted so that no objects are 'lost' when moved."
	operation = #move ifTrue: [
		dragSession objects do: [ :each |
			(self isCompatibleDragObject: each) ifFalse: [ ^nil ] ] ].
	^operation!  
basicSelectedRows
        "Private - Answer the collection of selected rows.
        Answer nil if not in row selection mode."
    ^selectedRows!  
childrenMethod
    "Private"

    ^childrenMethod! 
highlightRowForeColor
        "Answer the foreground color used for highlighting rows."
    | answer |
    answer := self propertyAt: #highlightRowForeColor.
    answer notNil ifTrue: [ ^answer ].
    ^Color highlightText!   
defaultDragDropObjects
    "Answer the list of items that should be
     passed during drag-drop"

    | dragObjects |
    #obsoleteMethod.
    (dragObjects := self getDefaultDragObjects) notNil
        ifTrue: [^dragObjects].
    (self propertyAt: #rightButton) == true
        ifTrue:
            [dragObjects := Array with: self selectedItem.
            ]
        ifFalse:
            [dragObjects := Array with: self selectedObject.
            ].
    dragObjects first isNil
        ifTrue: [^nil].
    self renderAsObjects
        ifFalse:
            [dragObjects := dragObjects
                collect:
                    [:each |
                    each asString]].
    ^dragObjects!
toggleArrowKeyMode
    "Toggle the arrow key mode  between move and edit"

    self cpStyle == #arrowKeysMove
        ifTrue: [self arrowKeysEdit]
        ifFalse: [self arrowKeysMove].
    self triggerToggleArrowKeyModeEvent.! 
defaultDroppedOn: aDragDropList
    "Accept the drag and drop."

    | addList cell index collection |
    #obsoleteMethod.
    addList := OrderedCollection new.
    aDragDropList items
        do:
            [:each |
            ((self contents includes: each) not and: [self isCompatible: each])
                ifTrue: [addList add: each].
            ].
    (self usesObjects not or: [addList isEmpty and: [(self isCompatible: aDragDropList items first) not]])
        ifTrue:
            [cell := self cellForPoint: aDragDropList location.
            self
                    atRow: cell y
                    column: cell x
                    put: aDragDropList items first asString.
            ^cell.]
        ifFalse:
            [index := ((self cellForPoint: aDragDropList location) y min: cells size + 1) max: 1.
            collection := self contents asOrderedCollection.
            addList
                reverseDo:
                    [:each |
                    collection add: each beforeIndex: index].
            self contents: collection asArray.
            ].! 
font: aFont
    "Private"

    font := aFont.
    self autoFieldWidth
        ifFalse:
            [cachedWidth := fieldWidth * self font width.
            ].!   
character: aSymbol
    "Private"

    character := aSymbol!
initialStateMethod
    "Private"

    ^initialStateMethod! 
updateRectangle
    "Private"

    rectangle := self rectangle.
    graphicsTool notNil
        ifTrue:
            [graphicsTool
                width: rectangle width;
                height: rectangle height].
    (rectangle height = 0) | (rectangle width = 0)
        ifFalse:
            [self reframe.
            ].!   
button2Up: aPoint
        "Private - pass to the parent."

    self superWindow triggerRightClickedEventFromChild: aPoint! 
displayObjects
    "Private - loop through the objects, displaying each one in turn"

    | range startPos |
    range := self cellsToDraw.
    startPos := self pointForCell: 1 @ range top.
    self pen backColor: self backColor.
    (range top max: 1) to: (range bottom min: objects size)
        do:
            [:i |
            self
                    displayItem: (objects at: i)
                    inRect: (Rectangle leftTop: startPos extent: self scrollAreaRectangle width @ self cellSize y)
                    highlight: false.
            startPos y: (startPos y down: self cellSize y).
            ].! 
isSelected: index
    "Answer whether the item is selected"

    self isMultiSelect
        ifTrue: [^self rawSelections includes: index].
    ^index == selectedCell y! 
showLines: aBoolean
    "Set whether the vertical divider lines should be shown or not"

    showLines := aBoolean!
losingFocus
        "Private"
    self superWindow losingFocus.!
showFocus
    "Private"

    selectedCell isNil
        ifTrue: [^self].
    self showFocusInCell: selectedCell color: Color black!  
iconExpandMethod: aSymbol
    "Set the method used to access the expanded icon of each item"

    iconExpandMethod := aSymbol! 
setReadOnly
    "Make the text editors read only"

    self children isNil ifTrue: [ ^self ].
    self children
        do:
            [:child |
            child
                "readOnly;"
                framingBlock: [ :box | 10000 @ 10000 extent: 10 @ 10].
            child isHandleOk
                ifTrue:
                    [UserLibrary
                        sendMessage: child handle
                        msg: 1055
                        wparam: true asParameter
                        lparam: 0]
            ].
    self isHandleOk
        ifTrue: [ self reframeEditors ].!  
cellInset
		"Answer the # of pixels to inset the receiver's frame
			when used in a CPTablePane."

	^3!   
basicSelectedRows
        "Private - Answer the collection of selected rows.
        Answer nil if not in row selection mode."
    ^nil!   
selectedRow
    "Answer the selected row"

    self isCellSelectMode ifTrue: [ ^super selectedRow ].
    self selectedRows isEmpty ifTrue: [ ^nil ].
    ^self selectedRows asSortedCollection first!
validate
    "Private - Validate the receiver."

    super validate.
    self updateListBox: false.
    value notNil ifTrue: [self selectIndex: value].! 
selections
    "Answer the indeces of the selected items"

    self isMultiSelect
        ifFalse:
            [self selection isNil
                ifTrue: [^#()].
            ^Array with: self selection].
    ^selections asSortedCollection asArray!
clearCurrentCell
    "Private"

    | rect region savedSelection |
    savedSelection := selectedCell.
    selectedCell := -100 @ -100.
    self columnHeaders
        do:
            [:column |
            column
                editor hideWindow;
                resize: self rect.
            ].
    "Redraw the cell that had the text editor in it"
    self
        doGraphics: [
            region := self pen setClipRect: self scrollAreaRectangle.
            self
                pen fill: ((rect := self rectForCell: savedSelection) insetBy: 1) color: self backColor;
                drawRectangle: rect.
            self drawCell: savedSelection clipRect: self scrollAreaRectangle.
            self pen destroyRegion: region.
            ].
    selectedCell := savedSelection.!   
maxDisplayWidth: aFont
    "Private"

    | maxDisplayWidth |
    maxDisplayWidth := self displayWidth: aFont.
    self collapsed
        ifTrue: [^maxDisplayWidth].
    children notNil
        ifTrue:
            [children
                do:
                    [:child |
                    maxDisplayWidth := (child maxDisplayWidth: aFont) max: maxDisplayWidth.
                    ].
            ].
    ^maxDisplayWidth!  
horizontalScrollAreaRectangle
    "Private - Answer the rectangular are that should be scrolled if we
    scroll horizontally (don't scroll the horizontal header)"

    ^0 @ self headerExtent y rightBottom: self rectangle rightBottom!
fieldPixelWidth: anObject
    "Private - Set the field width for this field, in pixels
    (used for autofieldWidth)"

    cachedWidth := anObject!   
rectForCell: cell
    "Private"

    | point |
    point := self pointForCell: cell.
    ^point rightBottom: self rectangle right @ (point y + self cellSize y)! 
constructSynchronousNotifications
        "Private - answer the mapping between host control
        notification codes and corresponding Smalltalk event
        notifications."
    ^super constructSynchronousNotifications
        at: CbnDropdown put: #notifyListVisible: ;
        at: CbnCloseup put: #notifyListHidden: ;
        yourself!   
columns: numColumns
    "Set the total number of columns"

    | size |
    size := totalCells x.
    totalCells x: numColumns.
    (size = numColumns or: [self usesObjects])
        ifTrue: [^self].
    (self sparseStorage or: [cells isNil or: [cells isEmpty]])
        ifFalse: [cells resizeRows: totalCells y columns: totalCells x].
    self isValid
        ifTrue:
            [self
                reframe;
                display]!   
initialize
    "Private"

    super initialize.
    headerColor := self defaultHeaderColor.
    topCorner := 0 @ 0.
    canResize := self defaultCanResize.
    canReorder := self defaultCanReorder.
    canSort := self defaultCanSort.!
childEntryFieldFor: column
    "Private"

    | field answer |
    field := columnHeader at: column.
    field list notNil
        ifTrue: [
            answer := field textEdit
                ifTrue: [ CPChildComboBox new ]
                ifFalse: [ CPChildDropDownList new ] ]
        ifFalse: [
            answer := EnhancedChildEntryField new.
            field textEdit ifFalse: [ answer readOnly ] ].
    ^answer!   
asParameter
    "Private"

    ^self printString asParameter!  
triggerCrEvent
        "Private"
    self event: #cr. " OBSOLETE "
    self triggerEvent: #cr.!
triggerToggleArrowKeyModeEvent
        "Private"
    self event: #toggledArrowKeys.  "OBSOLETE"
    self triggerEvent: #toggledArrowKeys: with: self cpStyle.! 
columnHeaderFor: column
    "Private"

    ^(self columnHeaders at: column) header!
cellContents

    ^self selectedItem!   
showColumnHeader: aBoolean
    "Show the column header or not"

    showColumnHeader := aBoolean.
    "Uncache"
    headerExtent := nil.!
restoreSelected: anObject
    "Private"

    | topIndex |
    self disableRedraw.
    topIndex := self getTopIndex.
	self triggerNeedsContentsEvent.
    self setTopIndex: topIndex.
    self selection: anObject.
    self enableRedraw.
    self invalidateRect: self rectangle!  
iconExpandMethod
    "Private"

    ^iconExpandMethod! 
iconMethod
    "Private"

    ^self owner iconMethod!  
rowHeaders
    "Answer a collection of strings that are displayed for the row labels to the left of each row."

    ^rowHeader!
cellShowCaret

   UserLibrary showCaret: self handle.!  
cursorOnFieldBoundary: aPoint
    "Private"

    ^(self fieldToResizeForPoint: aPoint) notNil! 
displayWith: aPen
inRect: aRect
clipRect: clipRect
    "Private - handle display event"

    | offset region inWindowBuilder |
    "Out of WindowBuilder, this component will have a border that causes it to
     display one pixel differently - we're emulating that here with the inset"
    rectangle := aRect leftTop extentFromLeftTop: aRect extent - 1.
    graphicsTool := aPen.
    aPen rectangle: aRect.
    offset := 1.
    tempClipRect := clipRect.
    inWindowBuilder := self inWindowBuilder.
    inWindowBuilder
        ifTrue:
            [self propertyAt: #tempClipRect put: tempClipRect
            ].
    GDILibrary
            offsetViewportOrgEx: graphicsTool handle
            x: aRect left + offset
            y: aRect top + offset
            oldPosition: nil.
    self display.
    GDILibrary
            offsetViewportOrgEx: graphicsTool handle
            x: (aRect left + offset) negated
            y: (aRect top + offset) negated
          oldPosition: nil.
    "We blow away the previous cliprect down in the display routine"
    inWindowBuilder
        ifTrue:
            [region := aPen setClipRect: tempClipRect.
            ].
    aPen
        foreColor: Color black;
        drawRectangle: aRect.
    inWindowBuilder
        ifTrue:
            [aPen destroyRegion: region.
            self propertyAt: #tempClipRect put: nil].
    tempClipRect := nil.!  
button1DoubleClick: aPoint
        "Private - pass to the parent."

    self superWindow triggerDoubleClickEventFromChild: aPoint! 
drawFocusRectForRow: anInteger
        "Private"
    anInteger notNil & self showRowHeader ifTrue: [
        self doGraphics: [
            self pen
                black;
                setBackgroundModeOpaque;
                drawRectangle: (
                    self focusRectForRow: anInteger ) ] ].! 
selectItem: anObject
    "Select the item anObject. anObject can
         be an index or an object. If anObject is an index,
         the current displayed list is used. If anObject is
         an object, anObject is searched for in the
         hierarchy. If found the list will be automatically
         expanded"

    | node |
    anObject isInteger
        ifTrue:
            [self selectIndex: anObject]
        ifFalse:
            [node := list
                detect:
                    [:item |
                    item object = anObject]
                ifNone: [nil].
            node isNil
                ifFalse: [^self selectIndex: (list indexOf: node)].
            objectList
                detect:
                    [:object |
                    (node := object asFullList
                        detect:
                            [:item |
                            item object = anObject]
                        ifNone: [nil]) notNil]
                ifNone: [nil].
            node isNil
                ifFalse:
                    [node expandTo.
                    self updateListBox: false.
                    self selectIndex: (self indexOf: anObject)].
            ].! 
triggerGetFieldsEvent

    self event: #getFields. " OBSOLETE "
    self triggerEvent: #getFields.!
owner: aCPHierarchicalListbox
    "Private"

    owner := aCPHierarchicalListbox!  
visibleCells
    "Private - Answer the number of cells that are full or partially visible"

    ^((self scrollAreaRectangle extent - 1) // self cellSize) + 1! 
expandTo
    "Private"

    self parent isNil
        ifTrue:
            [nil]
        ifFalse:
            [self parent collapsed: false.
            self parent expandTo.
            self parent children
                do:
                    [:child |
                    child children == nil
                        ifTrue: [child getChildren]]].!   
mouseMove: aPoint
    "Private"

    super mouseMove: aPoint.
    self canResize
        ifFalse: [^self].
    ((self isPointInHeader: aPoint) and: [self cursorOnFieldBoundary: aPoint])
        ifTrue:
            [cursor = #leftRight
                ifFalse:
                    [SizeWe change.
                    cursor := #leftRight.
                    ].
            ^self].
    cursor = #normal
        ifFalse:
            [CursorManager normal change.
            cursor := #normal.
            ].! 
drawMovingLine: x
    "Private - Do nothing"!
rectForHeader: column
    "Private"

    | rect point |
    rect := self rectForCell: (self columnHeaders indexOf: column) @ 1.
    ^Rectangle
		leftTop: rect left + 1 @ 0 "self rect top"
		rightBottom: rect right - 1 @ (0 "self rect top" down: self headerExtent y)
!   
clearAnchor
        "Private - Pass to parent."
    self superWindow clearAnchor.!  
getFocus: getFocusSelector
    "Private - ignore."!  
supportedEvents
    "Private"

    ^super
        supportedEvents add: #textChanged;
        add: #clicked;
        add: #cr;
        add: #toggledArrowKeys;
        yourself!   
menu
    "Private"

    ^menu! 
dragTargetOperationsDefault
        "Private - answer the operations that the receiver can accept."
	^#( move copy )!   
initializeTextEditor: column
    "Private"

    self textEditor: (self childEntryFieldFor: column).
    (self handle isNil or: [self isValid not])
        ifTrue: [self addSubpane: self textEditor]
        ifFalse: [self addSubpaneDynamically: self textEditor].
    self
        textEditor framingBlock: (self editorFramingBlockFor: self textEditor);
        removeStyle: WsBorder;
        owner: self;
        when: #textChanged: send: #selectionChanged:pane: to: self withArgument: self textEditor;
        backColor: self defaultBackColor;
        foreColor: self defaultForeColor.!
keepSelectionVisible
    "Private"

    self isHandleOk
        ifFalse: [^false].
    ^self keepCellVisible: selectedCell.! 
isOkToChange
        "Private"
    ^true!   
amountToPageRight
    "Private"

    ^self amountToPageLeft negated!   
columnClicked
    "Return the column number of the column that was clicked on"

    ^self columnHeaders indexOf: self columnHeaderClicked! 
character
    "Private"

    ^character!   
calcFieldSizes
    "Private - calculate new field sizes"

    | maxWidth result o |
    objects isNil | fields isNil
        ifTrue: [^self].
    totalFieldWidth := 0.
    headerHeight := 0.
    fields
        do:
            [:f |
            cellSize y: (cellSize y max: (f font isNil ifTrue: [self font] ifFalse: [f font]) height + 2).
            headerHeight := headerHeight max: f headerLineCount * self font height.
            f autoFieldWidth
                ifTrue:
                    [maxWidth := self class stringWidth: f header using: self font.
                    1 to: (objects size min: self class maxRowsToAutoSize)
                        do:
                            [:i |
                            o := objects at: i.
                            f selector notNil
                                ifTrue:
                                    [result := o perform: f selector.
                                    result isBitmap
                                        ifTrue:
                                            [maxWidth := maxWidth max: result width.
                                            self cellSize: self cellSize x @ (self cellSize y max: result height).
                                            ]
                                        ifFalse:
                                            [result isString
                                                ifFalse:
                                                    [result := result printString.
                                                    ].
                                            maxWidth := maxWidth max: (self class stringWidth: result using: (f font isNil ifTrue: [self font] ifFalse: [f font])).
                                            ].
                                    ].
                            ].
                    f fieldPixelWidth: maxWidth.
                    ].
            totalFieldWidth := totalFieldWidth + self fieldMargin + f fieldPixelWidth.
            ].
    totalFieldWidth := totalFieldWidth + self fieldMargin.
    totalCells := ((totalFieldWidth - 1) // self cellSize x + 1) @ objects size.
    headerHeight := headerHeight + self headerMargin.!  
dragTargetFormatsDefault
        "Private - answer the formats of drag objects that the receiver will accept."
    ^#( 'object' )!  
toggleSelectRowsAndTriggerEvent: aCollection
        "Toggle the selection of the specified rows."
    | old |
    old := selectedRows copy.
    self toggleSelectRows: aCollection.
    self triggerRowsSelectedEvent: selectedRows old: old.!  
gettingFocus
        "Pass to the parent."
    self hasFocus ifTrue: [
		self superWindow isCellSelectMode
			ifTrue: [
		        self superWindow highlightSelectedCell.
        		self isReadOnly ifFalse: [ self showWindow; selectAll ].
		        super gettingFocus ]
			ifFalse: [
				self hideWindow.
				self superWindow setFocus ] ].!  
columnResized
    "Return the column number of the column that was resized"

    ^self columnHeaders indexOf: (self fieldToResizeForPoint: self mouseLocation)!
hideFocus
    "Private"

    selectedCell isNil
        ifTrue: [^self].
    self showFocus.
    self displayLines.!
defaultDragDropObjects
    "Answer the list of items that should be
     passed during drag-drop"

    | dragObjects |
    #obsoleteMethod.
    (dragObjects := self getDefaultDragObjects) notNil
        ifTrue: [^dragObjects].
    dragObjects := self selectedItems asArray.
    dragObjects isEmpty
        ifTrue: [^nil].
    self renderAsObjects
        ifFalse:
            [dragObjects := dragObjects
                collect:
                    [:each |
                    each asString]].
    ^dragObjects! 
cellHeight
    "Private - Answer the height of a cell"

    ^self font height + (2 * self cellTextOffset y).!  
rows: numRows
    "Set the number of rows"

    | size |
    size := totalCells y.
    totalCells y: numRows.
    (size = numRows or: [self usesObjects])
        ifTrue: [^self].
    (self sparseStorage or: [cells isNil or: [cells isEmpty]])
        ifFalse: [cells resizeRows: totalCells y columns: totalCells x].
    self isValid
        ifTrue:
            [self
                reframe;
                display]!
canSort
    "Private"

    ^canSort!   
rowWithFocus
        "Private"
    ^rowWithFocus!   
rowHeaders: headerList
    "Set the row headers"

    rowHeader := headerList.
    (rowHeader notNil and: [self rows < rowHeader size])
        ifTrue:
            [self rows: rowHeader size.
            ].
    self calcHeaderExtent.!
triggerGetColumnsEvent
        "Private"
    self event: #getColumns. " OBSOLETE "
    self triggerEvent: #getColumns.!
cursor: aSymbol
    "Private"

    cursor := aSymbol!  
headerLineCount
    "Private"

    ^(self header occurrencesOf: Lf) + 1!   
cellMargin
    "Private"

    ^5 @ 2!  
displayWith: aPen
inBox: aRectangle

    | icon startX startY charWidth color |
    aPen fill: aRectangle color: self owner backColor.
    icon := self icon.
    charWidth := aPen font width.
    startX := aRectangle origin x + (self leftMargin * charWidth) + (self depthInTree * self indentWidth * charWidth).
    icon notNil
        ifTrue:
            [startY := aRectangle origin y + ((aRectangle height - icon height) // 2).
            icon displayAt: startX @ startY with: aPen.
            startX := startX + icon width + (self iconMargin * charWidth).
            ].
    startY := aRectangle origin y + ((aRectangle height - aPen font height) // 2).
    (self colorMethod notNil and: [(color := self transact: [object perform: self colorMethod]) notNil])
        ifTrue: [aPen foreColor: color]
        ifFalse: [aPen foreColor: owner foreColor].
    aPen
        setTextAlign: TaTop;
        displayText: self listString at: startX @ startY.!  
unHighlightCell: aCell
    "Private"

    | box region |
    (aCell isNil | self isValid not or: [aCell y > objects size])
        ifTrue: [^self].
    (self isCellVisible: aCell)
        ifFalse: [^self].
    box := self rectForCell: aCell.
    region := self pen setClipRect: ((self rect leftTop rightAndDown: self headerExtent) rightBottom: self rect rightBottom).
    self
        doGraphics:
            [self
                pen fill: box color: self backColor;
                foreColor: self foreColor.
            self
                    displayItem: (objects at: aCell y)
                    inRect: box
                    highlight: false.
            (self inWindowBuilder not and: [self parent isDialogTopPane])
                ifTrue:
                    [self
                        pen foreColor: Color black;
                        drawRectangle: self rect.
                    ].
            self pen destroyRegion: region.
            ].!   
textEditor: aSubPane
    "Private"

    (self columnHeaders at: self selectedColumn) editor: aSubPane! 
basicSelectedItem
    "Answer the selected item"

    ^self cellAt: selectedCell!  
drawCell: aPoint
clipRect: clipRect
    "Private - draw a given cell.  Clipping will be done
     with the intersection of clipRect and the cell's rect."

    | fColor bColor rowsToHighlight |
    (rowsToHighlight := self basicSelectedRows) notNil ifTrue: [
        (rowsToHighlight includes: aPoint y) ifTrue: [
            fColor := self highlightRowForeColor.
            bColor := self highlightRowBackColor ] ].
    self
        drawCell: aPoint
        clipRect: clipRect
        foreColor: fColor
        backColor: bColor.! 
basicForeColorAt: aPoint
        "Private"
    ^nil!
isMultiSelect
    "Private"

    ^self rawSelections notNil!   
keyboardInput: aKeyboardInputEvent
		"Private - keyboard input was received."
	| virtualKey newSel downRight upDown |
	virtualKey := aKeyboardInputEvent virtualKey.
	virtualKey = NumLockKey & Notifier isShiftKeyDown not
		ifTrue: [ ^self toggleArrowKeyMode ].
	virtualKey = TabKey
		ifTrue: [ ^self tabKeyInput: aKeyboardInputEvent ].
	(self arrowKeyInput: virtualKey)
		ifFalse: [ ^super keyboardInput: aKeyboardInputEvent ].!  
pointForCell: aCell
    "Private"

    ^(aCell - 1) * self cellSize - topCorner + self headerExtent!   
disabledForeColor: aColorOrNil
        "Set the disabled foreground color
        OR nil if the default disabled foreground color should be used."

    self propertyAt: #disabledForeColor put: aColorOrNil.!
defaultStyle
        "Private - Answer the default style for combo box."
    ^super defaultStyle | CbsAutohscroll!  
showLines
    "Private"

    ^showLines!   
measureControl: aStruct
    "Private - Establish the list item height for Windows."

    aStruct itemHeight: (self font height max: self maxIconHeight)!   
headerMargin
    "Private - answer the height (beyond the font height) of the
     header in pixels"

    ^5! 
listAt: aPoint
        "Private"
    ^#( )! 
cellSize
    "Private"

    ^cellSize! 
cr
    "Private - process a carriage return from the text editor"

    | oldY y |

    self isOkToChange ifFalse: [ ^self ].
    (self hasActionForEvent: #entered) ifTrue: [ ^self triggerCrEvent ].
    (self hasActionForEvent: #cr) ifTrue: [ ^self triggerCrEvent ].
    self isCellSelectMode ifTrue: [ ^super cr ].
    Notifier isShiftKeyDown ifTrue: [ ^self crShift ].

    (oldY := self rowWithFocus) isNil
        ifTrue: [ y := oldY := 1 ]
        ifFalse: [ y := oldY + 1 min: self rows ].
    self rowWithFocus: nil.
    self keepCellVisible: 1 @ y.
    self rowWithFocus: y.!
dragScrolls
    "Private"

    ^true!  
fullExtent
    "Private - answer the total extent of the objects + the header"

    ^(totalFieldWidth @ (self totalCells y * self cellSize y)) + self headerExtent.!   
editor
    "Private"

    ^editor! 
boundedCellForPoint: aPoint
    "Private - make sure cell is no more than one cell outside the
     visible area (for the sake of smoother drag-scrolling)"

    | cell topCell bottomCell |
    cell := self cellForPoint: aPoint.
    (self scrollAreaRectangle containsPoint: (self pointForCell: cell) abs)
        ifTrue: [^cell].
    topCell := self getTopCell - 1.
    bottomCell := topCell + self fullyVisibleCells + 1.
    ^(cell max: topCell) min: bottomCell!  
cellAt: aPoint
    "Private - answer the cell contents AS A STRING at a given point.  Public method is
     rowAt:column:, which allows either strings or integer indices."

    ^(self basicCellAt: aPoint) asString!
defaultFont
        "Answer the default font for the receiver."
    ^SysFont!   
triggerDoubleClickEvent

    self event: #doubleClickSelect. " OBSOLETE "
    self triggerEvent: #doubleClicked: with: self selectedItem.! 
windowsJustification
    "Private"

    justification = #left
        ifTrue: [^SsLeft].
    justification = #right
        ifTrue: [^SsRight].
    justification = #center
        ifTrue: [^SsCenter].
    self error: 'Invalid Justification'.!   
isOkToChange
    "Private - answer whether it is OK to change the selection."

    ^(self hasActionForEvent: #aboutToChange)
        ifTrue: [^super isOkToChange]
        ifFalse: [(self event: #commitSelection) ~= false]!   
dontNeedControlKey
    "Private"

    ^self cpStyle == #arrowKeysMove or: [
        self cpStyle == #readOnly].!  
fieldPixelWidth
    "Private"

    cachedWidth isNil
        ifTrue:
            [cachedWidth := self fieldWidth * 
                (font isNil ifTrue: [SysFont] ifFalse: [font]) width.
            ].
    ^cachedWidth!
updateSelection
    "Private - Selection just changed. Do nothing by default"!   
redrawRowHeader: anInteger
        "Invalidate the specified row header."
    | t b r |
    r := self rect.
    b := (self headerExtent y up: topCorner y) down: anInteger * cellSize y.
    t := b up: cellSize y.
    ((b isBelow: r top)
        and: [t isAbove: r bottom])
            ifTrue: [
                self invalidateRect: (
                    r left @ t rightBottom: (r left right: self headerExtent x) @ b)].!
setScrollRanges
    "Private - Set the ranges for the horizontal and vertical
     scroll bars."

    "Make the vertical scroll bar represent cell scrolling
        rather than pixel scrolling."

    | rangeRect minHorz maxHorz minVert maxVert rect fullExtent |
    self isHandleOk
        ifFalse: [^self].
    rangeRect := self scrollableRectangle.
    minHorz := 0.
    maxHorz := rangeRect width.
    minVert := 0.
    maxVert := rangeRect height.
    (self style notNil and: [self style bitAnd: WsHscroll]) = 0
        ifTrue: [maxHorz := 0].
    (self style notNil and: [self style bitAnd: WsVscroll]) = 0
        ifTrue: [maxVert := 0].
    rect := self realRectangle.
    fullExtent := self fullExtent.
    maxVert > 0
        ifTrue:
            [maxVert := maxVert + cellSize y - 1 // cellSize y.
            "maxVert := maxVert / cellSize y.
            maxVert := (maxVert / (maxVert / 32767) ceiling) truncated."
            ].
    UserLibrary
            setScrollRange: self asParameter
            bar: SbHorz
            min: minHorz
            max: maxHorz
            redraw: false.
    UserLibrary
            setScrollRange: self asParameter
            bar: SbVert
            min: minVert
            max: maxVert
            redraw: false!
arrowKeysMove
    "Set the style such that the arrow keys move between cells"

    self propertyAt: #cpStyle put: #arrowKeysMove.! 
showWindow
        "Show the receiver only if the parent is not disabled."
    self superWindow disabled ifFalse: [ super showWindow ].!
defaultDroppedOn: aDragDropList
    "Accept the drag and drop."

    | addList index collection |
    #obsoleteMethod.
    addList := OrderedCollection new.
    aDragDropList items
        do:
            [:each |
            ((self contents includes: each) not and: [self isCompatible: each])
                ifTrue: [addList add: each].
            ].
    addList isEmpty
        ifTrue: [^self].
    index := ((self cellForPoint: aDragDropList location) y min: objects size + 1) max: 1.
    collection := self contents asOrderedCollection.
    addList
        reverseDo:
            [:each |
            collection add: each beforeIndex: index].
    self contents: collection asArray.!  
maxIconHeight
    "Private"

    | maxHeight |
    maxHeight := 0.
    objectList
        do:
            [:o |
            maxHeight := maxHeight max: o maxIconHeight.
            ].
    ^maxHeight! 
atRow: row
column: column
put: element
    "Set the content at row and column to element."

    ^(super at: row) at: column put: element!
gridColor
    "Private"

    ^self foreColor!  
cellTextOffset
    "Private - Answer the offset from the left top of a cell for the
     text to be displayed."

    ^3 @ 3!  
canReorder: aBoolean
    "Private"

    canReorder := aBoolean!
printOn: aStream
    "Private"

    aStream nextPutAll: '<' , self listString , '> '.
    self icon notNil
        ifTrue: [aStream nextPutAll: '[has icon]'].!  
rowWithFocus: anIntegerOrNil
        "Private"
    rowWithFocus = anIntegerOrNil ifFalse: [
        rowWithFocus notNil ifTrue: [ self redrawRowHeader: rowWithFocus ].
        rowWithFocus := anIntegerOrNil.
        rowWithFocus notNil ifTrue: [ self drawFocusRectForRow: rowWithFocus ] ].!   
setTopIndex: anIndex
    "Scroll listbox so that the item at anIndex is at the top of
     the listbox"

    self setTopCell: 1 @ anIndex!
deferredhighlightCell: aCell
    "Private"

    aCell = selectedCell
        ifFalse: [^self].
    self highlightCell: aCell.!   
showRowHeader
  "Answer aBoolean indicating whether to display the row labels.  The default is true."

    ^showRowHeader! 
restore
    "Private - Refresh the list from the owner
      and maintain the position in the list
      without selecting it."

    | first |
    first := self getTopIndex.
	self triggerNeedsContentsEvent.
    self setTopIndex: first!   
cellInset
		"Answer the # of pixels to inset the receiver's frame
			when used in a CPTablePane."

	^1!   
tensegrity
    "Set the listbox to use Tensegrity atomic transactions"

    self tranType: #atomic!
colorMethod
    "Private"

    ^nil!   
cellContents

    ^self contents!   
cell: cell1
differsFrom: cell2
    "Private"

    ^cell1 ~= cell2!
triggerCellChangedAt: aPoint value: anObject
        "Private"
    self
        triggerEvent: #cellChangedAt:value:
        with: aPoint
        with: anObject.
    self
        triggerEvent: #changed:
        with: anObject.!
keyboardInput: aKeyboardInputEvent
		"Private - Process the input message."
	aKeyboardInputEvent virtualKey = TabKey
		ifTrue:
			[self tabKeyInput: aKeyboardInputEvent.
			^true].
	aKeyboardInputEvent isAltKeyDown ifFalse: [
		(self
			shouldProcess: aKeyboardInputEvent virtualKey
			controlKey: aKeyboardInputEvent isControlKeyDown)
				ifFalse: [
					self showDropdown: false.
					self superWindow keyboardInput: aKeyboardInputEvent.
					^true]].
	^nil!
triggerDoubleClickEvent
		"Private"
    self event: #doubleClickSelect. " OBSOLETE "
    self triggerEvent: #doubleClickSelect: with: self selectedItem.!  
getScrollRanges
    "Private - answer the scroll ranges of the window"

    "Make the vertical scroll bar represent cell scrolling
        rather than pixel scrolling."

    | h v minPtr maxPtr |
    minPtr := ExternalBuffer new: 2.
    maxPtr := ExternalBuffer new: 2.
    UserLibrary
            getScrollRange: self asParameter
            bar: SbHorz
            lpMinPos: minPtr asParameter
            lpMaxPos: maxPtr asParameter.
    h := maxPtr uShortAtOffset: 0.
    UserLibrary
            getScrollRange: self asParameter
            bar: SbVert
            lpMinPos: minPtr asParameter
            lpMaxPos: maxPtr asParameter.
    v := maxPtr uShortAtOffset: 0.
    "Added this line to convert cell max to pixel max."
    v := v * self cellSize y.
    ^h @ v!  
extent
    "Answer dimension in rows and columns."

    ^(self at: 1) size @ self size!
focusRectForRow: anInteger
        "Private"
    | answer |
    answer :=
        0 @ ((self headerExtent y up: topCorner y) down: (anInteger - 1) * cellSize y + 1)
        extentFromLeftTop:
            (self showRowHeader
                ifTrue: [ self headerExtent x ]
                ifFalse: [ self fullExtent x ]
            ) @ (cellSize y - 1).
    ^answer insetBy: 2.!   
dragSourceCutDefault: dragSession
		"Private - perform default cut action if no handler is provided."

    | removeMethod node |
	self clearSelection.
    removeMethod := self removeChildMethod.
	node := list at: self dragSourceSelection.
    node parent notNil & removeMethod notNil
		ifTrue: [
			node parent object perform: removeMethod with: node object.
            node parent removeChild: node ]
		ifFalse: [
			objectList remove: node ifAbsent: [nil] ].
    self updateListBox: true!  
cellHideCaret

    UserLibrary hideCaret: self handle.! 
tranType
    "Private"

    ^tranType! 
updateListBox: retainScrolling
    "Private"

    | firstVis |
    list := self flatList.
    firstVis := self getTopIndex.
    super contents: list.
    self updateItemSizes.
    self isHandleOk
        ifTrue:
            [retainScrolling
                ifTrue:
                    [self setTopIndex: firstVis.
                    ]
                ifFalse:
                    ["self
                        invalidateRect: nil;
                        updateWindow."
                    ].
            ].! 
triggerRightClickedEventFromChild: aPoint
    "Right mouse button was clicked while a child editor had control.
       Trigger the appropriate rightClicked event."

    self triggerRightClickedEventFor: (self columnHeaders at: self currentField).!   
printOn: aStream
    "Private"

    aStream nextPutAll: '(' , self header printString , ',' , self selectorString , ',' , self fieldWidthString , ',' , self justification , ')'.! 
shouldProcess: wordInteger controlKey: controlKey
        "Private - Answer true if the receiver should process the keystroke."
    self isReadOnly ifTrue: [ ^false ].
    (wordInteger = NumLockKey) ifTrue: [ ^false ].
    (wordInteger = UpKey) | (wordInteger = DownKey)
        | (wordInteger = LeftKey) | (wordInteger = RightKey)
        | (wordInteger = PageUpKey) | (wordInteger = PageDownKey)
        | (wordInteger = HomeKey) | (wordInteger = EndKey) ifFalse: [ ^true ].
    (self superWindow cpStyle = #arrowKeysMove
        | controlKey)
        ifTrue: [ ^false ].
    ^true!   
dragSourceNeedsObjectDefault: dragSession
        "Private - provide default for requested drag items if no handler
        is provided by supplying the currently selected item."
    | dragDropObject |

	#osiHack.
	"If in the currently selected cell, then drag the text..."

	self dragSourceSelection: (
		self usesObjects & self selectedObject notNil
			ifTrue: [ Array with: selectedCell y ]
			ifFalse: [ nil ] ).

	(dragDropObject := dragSession objectClass new)
		object: self selectedObject;
		string: dragDropObject object asString.
	dragDropObject object isNil ifTrue: [ ^self ].
    dragSession objects: ( Array with: dragDropObject ).!
isCellVisible: aCell
    "Private"

    | topCell bottomCell |
    topCell := self getTopCell y.
    aCell y < topCell
        ifTrue: [^false].
    bottomCell := topCell + self fullyVisibleCells y.
    aCell y > bottomCell
        ifTrue: [^false].
    ^true!
droppedOn: dragDrop
    "Private"

    #obsoleteMethod.
    dragDrop location: (Cursor offset mapToWindow: self).
    self dragDropped: dragDrop.!   
initializeTextEditor
    "Private"!  
atRow: anInteger
put: anArray
    "Set the row at anInteger."

    super at: anInteger put: anArray!  
isPointInRowHeader: aPoint
    "Private"

    ^aPoint x between: 0 and: self headerExtent x!   
drawMovingLine: x
    "Private"

    self doGraphics: [
        self pen
            setForegroundMode: MixRuleNotXor;
            place: x @ 0;
            goto: x @ self rect height;
            setForegroundMode: MixRuleDefault ].!
defaultDragDropObjects
    "Answer the list of items that should be
     passed during drag-drop"

    | dragObjects |
    #obsoleteMethod.
    (dragObjects := self getDefaultDragObjects) notNil
        ifTrue: [^dragObjects].
    self contents isNil
        ifTrue: [^nil].
    dragObjects := Array with: self selectedItem.
    dragObjects first isNil
        ifTrue: [^nil].
    self renderAsObjects
        ifFalse:
            [dragObjects := dragObjects
                collect:
                    [:each |
                    each asString]].
    ^dragObjects!
tranType: aSymbol
    "Private"

    ([] respondsTo: aSymbol)
        ifTrue: [tranType := aSymbol]!  
addChildMethod: aSymbol
    "Set the method used to add children to a parent node"

    ^self propertyAt: #addChildMethod put: aSymbol!
setSelector: aSymbol
    "Private"

    setSelector := aSymbol!
children: aCollection
    "Private"

    children := aCollection!  
fields: aFieldList
    "Set the fields for this listbox"

    fields := aFieldList.
    self calcFieldSizes.
    self isHandleOk
        ifTrue:
            [self invalidateRect: nil.
            self updateRectangle.
            ].!
fullyVisibleCells
    "Private - answer the number of cells that will display
     fully visible within the window "

    ^totalCells x @ super fullyVisibleCells y!  
keepSelectionVisible
    "Private"

    ^super keepSelectionVisible
        ifTrue: [ self refreshSelection ].!   
renderAsObjects
    "Private - should the receiver deliver objects in a drag & drop
     transfer or the string representations of the objects"

    #obsoleteMethod.
    ^(self propertyAt: #renderAsObjects) ~~ nil!   
wmHScroll: wordInteger
with: longInteger
    "Private - Handle horizontal scrolling."

    | type pos min borderPos distance move |
    type := wordInteger lowWord.
    type = SbLineup
        ifTrue: [self scrollHorizontal: self amountToScrollLeft].
    type = SbLinedown
        ifTrue: [self scrollHorizontal: self amountToScrollRight].
    type = SbPageup
        ifTrue: [self scrollHorizontal: self amountToPageLeft].
    type = SbPagedown
        ifTrue: [self scrollHorizontal: self amountToPageRight].
    (type = SbThumbposition) | (type = SbThumbtrack)
        ifTrue:
            [pos := wordInteger highWord.
            borderPos := 0.
            min := 10000.
            1 to: self columnHeaders size
                do:
                    [:i |
                    distance := (borderPos - pos) abs.
                    distance < min
                        ifTrue:
                            [min := distance.
                            move := borderPos - pos.
                            ].
                    borderPos := borderPos + (self pixelCellWidth: i).
                    ].
            pos := pos + move.
            (self topCorner x - pos) abs > 0
                ifTrue:
                    [self scrollHorizontal: self topCorner x - pos.
                    self updateHorizontalSliderTo: pos.
                    ].
            ^nil].
    self updateHorizontalSlider.
    ^nil!  
selectAll
        "Select the receiver's contents."
    self superWindow hasFocus ifTrue: [
        "selectFirst prevents the entry field from
            auto scrolling when it should not."
        self selectFirst.
        super selectAll ].!
scrollAreaRectangle
    "Private"

    ^self headerExtent rightBottom: self rectangle rightBottom! 
columnReordered
    "Return the column number of the column that was reordered"

    ^self columnClicked!  
columnHeaders: anOrderedCollection
    "Set the column headers to anOrderedCollection of strings"

    columnHeader := anOrderedCollection.
    columnHeader notNil
        ifTrue: [self columns: columnHeader size].!  
showFocus
    "Private"
    "self showFocusInCell: selectedCell"!   
fontForColumn: anInteger
    "Private"

    | font |
    ^(font := (columnHeader at: anInteger) font) isNil
        ifTrue: [ self font ]
        ifFalse: [ font ].!   
sortOn: column
ascending: aBoolean
    "Sort the matrix on the specified column index."

    | selector |
    self sparseStorage
        ifTrue: [^self].
    selector := (columnHeader at: column) selector.
    self usesObjects
        ifTrue:
            [self
                contents:
                    (aBoolean
                    ifTrue:
                        [(self contents
                            asSortedCollection:
                                [:a :b |
                                (a perform: selector) <= (b perform: selector)])]
                    ifFalse:
                        [(self contents
                            asSortedCollection:
                                [:a :b |
                                (a perform: selector) >= (b perform: selector)])]) asOrderedCollection]
        ifFalse:
            [self contents: (self contents sortOn: column ascending: aBoolean)].
    self
        selection:
            (self
                nextValidCell:
                    (self
                    nextValidCell: self selection
                    upDown: true
                    downRight: true)
                upDown: true
                downRight: false)!  
button1DoubleClick: aPoint
    "Private"

    self doSetFocus.
	self triggerDoubleClickEvent.!
nameMethod
    "Private"

    ^nameMethod! 
backColor: aColorOrSelector
    "Private"

    backColor := aColorOrSelector.! 
rawSelections
    "Private"

    ^selections!  
removeChildMethod: aSymbol
    "Set the method used to remove children from a parent node"

    ^self propertyAt: #removeChildMethod put: aSymbol! 
defaultColumnHeaders
    "Private - set up the columns for a blank tablepane"

    ^OrderedCollection
            with: (CPTableColumn new header: 'Column 1')
            with: (CPTableColumn new header: 'Column 2')
            with: (CPTableColumn new header: 'Column 3').!  
isCompatible: anObject
    "Is <anObject> compatible with the receiver"

	#obsoleteMethod.
    self columnHeaders
        do:
            [:column |
            (anObject respondsTo: column selector)
                ifFalse: [^false]].
    ^true!   
flip
    "Return a new matrix containg the elements of the reciever
     with x and y coordinates interchanged"

    | aMatrix |
    aMatrix := CPMatrix rows: self extent y columns: self extent x.
    self
        iterate:
            [:row :column |
            aMatrix
                    atRow: column
                    column: row
                    put: (self atRow: row column: column)].
    ^aMatrix.!  
setFont: aFont
    "Private"

    font isNil
        ifTrue: [font := aFont].
    self autoFieldWidth
        ifFalse:
            [cachedWidth := fieldWidth * self font width.
            ].!  
fieldWidthString
    "Private"

    self autoFieldWidth
        ifTrue: [^'Auto']
        ifFalse: [^fieldWidth printString].!   
updateItemSizes
    "Private"

    self isHandleOk
        ifTrue:
            [self itemHeight: (self maxIconHeight max: self font height).
            self setHExtent: self maxDisplayWidth.
            "self insertBlankItems."
            ].!  
removeChild: node
    "Private"

    ^self children remove: node ifAbsent: [nil]!  
fields
    "Answer the fields for this listbox"

    ^fields!  
defaultHeaderColor
    "Private"

    ^Color windowBackground! 
basicIsOkToChange
		"Answer true if is ok to change."

    super isOkToChange == false ifTrue: [ ^false ].
	^true!
textEditor: aSubPane
    "Private"

    textEditor := aSubPane!
disabledBackColorDefault

    ^nil! 
finalizeMoveOperation: dragDrop
    "Private - clean up after a drag & drop move operation"

    | node removeMethod |
    #obsoleteMethod.
    removeMethod := self removeChildMethod.
    dragDrop items
        do:
            [:each |
            node := list
                detect:
                    [:item |
                    item object = each]
                ifNone: [nil].
            node parent notNil & removeMethod notNil
                ifTrue:
                    [node parent object perform: removeMethod with: each.
                    node parent removeChild: node.
                    ]
                ifFalse:
                    [objectList remove: node ifAbsent: [nil]].
            ].
    self updateListBox: true!   
fieldWidth
    "Private"

    ^fieldWidth! 
selectionChanged: aString pane: aPane
    "Private - the textPane changed, and is notifying us"

    | newContents |
    newContents := aPane cellContents.
    (self cellAt: self selection) = newContents
        ifTrue: [^self].
    self cellAt: self selection put: newContents.
    self triggerTextChangedEvent.! 
defaultDroppedOn: aDragDropList
    "Accept the drag and drop. This is the default handler for
      the #dragDropped: event."

    | addList index addMethod node parentNode parentList |
    #obsoleteMethod.
    addList := OrderedCollection new.
    aDragDropList items
        do:
            [:each |
            ((objectList
                detect:
                    [:item |
                    item object = each]
                ifNone: [nil]) isNil and: [self isCompatible: each])
                ifTrue: [addList add: each].
            ].
    addList isEmpty
        ifTrue: [^self].
    (addMethod := self addChildMethod) isNil
        ifTrue:
            [addList
                do:
                    [:each |
                    objectList
                        add:
                            (self nodeClass new
                                object: each
                                owner: self
                                parent: nil).
                    ]]
        ifFalse:
            [index := self getTopIndex + (aDragDropList location y / self itemHeight) rounded.
            index > list size
                ifTrue:
                    [addList
                        do:
                            [:each |
                            objectList
                                add:
                                    (self nodeClass new
                                        object: each
                                        owner: self
                                        parent: nil).
                            ].
                    ]
                ifFalse:
                    [node := list at: index.
                    addList
                        do:
                            [:each |
                            parentNode := node.
                            parentList := Set new.
                            parentList add: parentNode object.
                            [(parentNode := parentNode parent) notNil]
                                whileTrue: [parentList add: parentNode object].
                            (parentList includes: each)
                                ifFalse:
                                    [node object perform: addMethod with: each.
                                    node
                                        addChild:
                                            (self nodeClass new
                                                object: each
                                                owner: self
                                                parent: node).
                                    ].
                            ].
                    ].
            ].
    self updateListBox: true!
selectRow: anInteger
        "Select the specified row."
    self selectRows: (Array with: anInteger).! 
maxDisplayWidth
    "Private"

    | maxDisplayWidth |
    maxDisplayWidth := 0.
    objectList
        do:
            [:o |
            maxDisplayWidth := maxDisplayWidth max: (o maxDisplayWidth: self font).
            ].
    ^maxDisplayWidth!  
nodeClass
    "Private"

    ^CPTreeNode!  
setReadWrite
    "Make the text editors read and write"

    self children
        do:
            [:child |
            child
                framingBlock: (self editorFramingBlockFor: child).
            child isHandleOk
                ifTrue:
                    [UserLibrary
                        sendMessage: child handle
                        msg: 1055
                        wparam: false asParameter
                        lparam: 0]
            ].
    self reframeEditors.
    self textEditor
        cellContents: '';
        cellContents: self basicSelectedItem;
        selectAll.!  
rowClicked
    "Return the row number of the row that was clicked on"

    ^self rowToReorderForPoint: self mouseLocation! 
canReorder
    "Private"

    ^canReorder! 
foreColor: aColor
    "Set the forecolor"

    super foreColor: aColor.
    self textEditor isNil
        ifFalse:
            [self textEditor foreColor: aColor.
            ].! 
doSetFocus
    "Private - Hand the focus off to the text editor whenever we
     get it.  Avoid doubledraw by checking if it has focus first."

    | editor |
    self isCellSelectMode & self disabled not ifTrue: [
        (editor := self textEditor) notNil ifTrue: [
            (self isReadOnly: selectedCell) ifFalse: [
                editor showWindow; selectAll.
                editor hasFocus ifFalse: [ editor setFocus ] ] ] ].!
defaultShowColumnHeader
    "Private"

    ^true!  
rect
    "Private"

    ^self inWindowBuilder
        ifTrue: [rectangle]
        ifFalse: [super rect].!
altDownInWmChar: wordInteger with: longInteger
        "Private - Commit the change first..."
    ^self superWindow altDownInWmChar: wordInteger with: longInteger! 
updateSelectedCell: aBoolean
    "Private"

    self isValid
        ifTrue:
            [self clearCurrentCell.
            aBoolean
                ifTrue: [self display].
            self updateRectangle.
            self highlightCell: selectedCell.
            self updateSelection.
            self isCellSelectMode ifTrue: [
                (self isReadOnly: selectedCell) ifFalse: [
                    self
                        textEditor showWindow;
                        setFocus ] ].
            ].!  
sparseStorage: aBoolean
    "Use sparse storage or not"

    sparseStorage := aBoolean!
contents
    "Answer the contents of the table"

    ^self cells!  
showGrid
    "Answer aBoolean indicating whether to show the grid. The default is true."

    ^showGrid!   
keepCellVisible: aCell
    "Private - scroll the window to make the cell visible if
     necessary"

    | bottomCell topCell newX newY newTopCell |
    self isHandleOk ifFalse: [ ^false ].
    topCell := self getTopCell.
    bottomCell := self getBottomCell.
    (((topCell rightBottom: bottomCell) containsPoint: aCell) and: [topCell x ~= aCell x])
        ifTrue: [^false].
    newX := self getClosestScrollPos: aCell x within: topCell x @ bottomCell x.
    newY := self getClosestScrollPos: aCell y within: topCell y @ bottomCell y.
    newTopCell := newX @ newY min: totalCells.
    topCell = newTopCell ifTrue: [ ^false ].
    self setTopCell: newTopCell.
    ^true!   
clearCurrentCell
    "Private"

    | rect region savedSelection |
    savedSelection := selectedCell.
    selectedCell := -100 @ -100.
    self
        textEditor hideWindow;
        resize: self rect.
    "Redraw the cell that had the text editor in it"
    self
        doGraphics:
            [region := self pen setClipRect: self scrollAreaRectangle.
            self
                pen fill: ((rect := self rectForCell: savedSelection) insetBy: 1) color: self backColor;
                drawRectangle: rect.
            self drawCell: savedSelection clipRect: self scrollAreaRectangle.
            self pen destroyRegion: region.
            ].
    selectedCell := savedSelection.!   
visibleRectangle
    "Private"

    | extent |
    "overloaded for use within WindowBuilder"
    self inWindowBuilder
        ifTrue:
            [extent := self wbDisplayRectangle extent]
        ifFalse:
            [extent := self rectangle extent.
            ].
    ^0 @ 0 extent: extent!  
wbDisplayRectangle
    "Private - WindowBuilder drawing sets up rectangle for us"

    ^rectangle! 
cellsToDraw
    "Private - Answer a rectangle describing the range of cells to draw"

    | drawRect |
    drawRect := self exposedRectangle.
    self inWindowBuilder
        ifFalse: [drawRect := drawRect intersect: self currentClipRect].
    "Take into account that rectangle origin may be non-zero for
     WB based drawing"
    drawRect := (drawRect leftTop leftAndUp: rectangle leftTop) extentFromLeftTop: drawRect extent.
    drawRect := (drawRect leftTop max: self headerExtent) rightBottom: drawRect rightBottom.
    ^(self cellForPoint: drawRect leftTop) rightBottom: (self cellForPoint: drawRect rightBottom).!   
updateHorizontalSlider
    "Private"

    self updateHorizontalSliderTo: self topCorner x.!