05/04/95 02:04:16 PM

cellAt: cell
    "Answer the cell at the point"

    ^(cells at: cell x) at: cell y!   
cellForPoint: aPoint
    "Private"

    ^(aPoint // self cellExtent) + 1!  
backColor: color
    "Private"

    super backColor: color.
    thumbBitmap notNil
        ifTrue:
            [self reframe.
            ].!  
rows: row
columns: column
    "Set the number of rows and columns"

    columnsRows := column @ row.
    selection := 1 @ 1.
    cells := Array new: column.
    1 to: column
        do:
            [:index |
            cells at: index put: (Array new: row).
            ].! 
invalidRect
    "Private"

    ^self rect! 
close
    "Private"

    super close.
    thumbBitmap notNil
        ifTrue:
            [thumbBitmap release.
            ].! 
contents: aString
    "Set the label of the reciever"

    | aRect |
    contents := aString.
    self isHandleOk
        ifTrue:
            [aRect := self rectangle.
            self invalidateRect: (Rectangle leftTop: aRect leftTop extent: aRect extent x @ (self font height + 10)).
            ].!
wmGettext: wparam
with: lparam
    "Private - Added to provide support for keyboard mnemonics"

    | address string struct |
    address := ExternalAddress
        new highHalf: (lparam // 65536);
        lowHalf: (lparam \\ 65536);
        yourself.
    self contents notNil
        ifTrue:
            [string := self contents copyFrom: 1 to: (wparam min: self contents size + 1) - 1.
            ]
        ifFalse:
            [string := ''].
    struct := ExternalBuffer new: wparam.
    struct contents: string asAsciiZ.
    struct copyToAddress: address.
    ^string size! 
wmGetdlgcode: wParam
with: lParam
    "Private - Added to support keyboard mnemonic doing set selection to next field."

    ^DlgcStatic! 
button2Down: aPoint
    "Private"

	self propertyAt: #dragCell put: (self cellForPoint: aPoint).
	^super button2Down: aPoint! 
button1Down: aPoint
    "Private"

    | cell point currentSelection |
    (self subpaneButton1Down: aPoint)
        ifFalse: [^self].
    self setFocus.
    currentSelection := selection.
    self
        whileMouseStillDown:
            [point := self mouseLocation.
            cell := self cellForPoint: point.
            (self inBounds: cell)
                ifFalse:
                    [
                    "was within the palette on last pass through the loop."
                    currentSelection = (0 @ 0)
                        ifFalse:
                            [self unHighlightCell: currentSelection.
                            currentSelection := 0 @ 0.
                            ].
                    ]
                ifTrue:
                    [(currentSelection = cell)
                        ifFalse:
                            [currentSelection = (0 @ 0)
                                ifFalse:
                                    [self unHighlightCell: currentSelection.
                                    ].
                            self highlightCell: cell.
                            currentSelection := cell.
                            ].
                    ].
            self propertyAt: #dragCell put: currentSelection.
            ].
    currentSelection ~= (0 @ 0)
        ifTrue:
            [selection := currentSelection.
            self triggerSelectEvent.
            ]
        ifFalse:
            [self highlightCell: selection.
            ].!
displayWith: pen
inRect: inRect
    "Private"

    contents ifNil: [
		contents :=
			(Smalltalk at: #WBBitmapManager ifAbsent: [ ^self ])
				current anyBitmap ifNil: [ ^self ] ].
    parent notNil
        ifTrue:
            [pen fill: self rect color: parent backColor.
            ].
    pen
        foreColor: self foreColor;
        backColor: self backColor.
    cpStyle == #stretchToFit
        ifTrue:
            [pen
                    copyBitmap: contents
                    from: contents boundingBox
                    to: inRect.
            ]
        ifFalse:
            [pen
                    copyBitmap: contents
                    from: contents boundingBox
                    at: inRect leftTop.
            ].!
showPercentage

    ^showPercentage!
wmNchittest: wParam
with: lParam
    "Private - allow overlapping panes to get mouse input"

    ^self isDragSource | self isDragTarget
        ifTrue: [super wmNchittest: wParam with: lParam]
        ifFalse: [-1 "HtTransparent"]! 
triggerSelectEvent
    "Private"

    self event: #select. " OBSOLETE "
    self triggerEvent: #selectCell: with: self selection.
    self triggerEvent: #selectItem: with: self selectedItem.!  
keyboardInput: aKeyboardInputEvent
        "Private - keyboard input was received."
    | virtualKey newSel |

    virtualKey := aKeyboardInputEvent virtualKey.
    virtualKey = VkUp ifTrue: [newSel := selection + (0 @ -1)].
    virtualKey = VkDown ifTrue: [newSel := selection + (0 @ 1)].
    virtualKey = VkHome ifTrue: [newSel := 1 @ 1].
    virtualKey = VkEnd ifTrue: [newSel := columnsRows].
    virtualKey = VkLeft ifTrue: [newSel := selection + (-1 @ 0)].
    virtualKey = VkRight ifTrue: [newSel := selection + (1 @ 0)].
    newSel notNil
        ifTrue: [
            (self inBounds: newSel)
                ifTrue:
                    [self selection: newSel.
                    self triggerSelectEvent.
                    ].
        ]
        ifFalse: [
            super keyboardInput: aKeyboardInputEvent ].!   
contents
    "Answer the label of the reciever"

    ^contents!
increment
    "Increment current value"

    self internalValue: self value + 1.!  
invalidRect
    "Private"

    ^(self rect insetBy: 2)!
dragTargetFormatsDefault
        "Private - answer the formats of drag objects that the receiver will accept."
    ^#( 'bitmap' )!  
selection
    "Answer the selected cell"

    ^selection!  
displayPercentageWith: pen
inRect: inRect
clipRect: cRect
    "Private"

    | color region |
    showPercentage
        ifTrue:
            [color := Color black.
            (self foreColor == Color black) | (self backColor == Color black)
                ifTrue:
                    [(self foreColor == Color white) | (self backColor == Color white)
                        ifTrue:
                            [color := self middleColor.
                            ]
                        ifFalse:
                            [color := Color white.
                            ].
                    ].
            region := pen setClipRect: ((self invalidRect translateBy: inRect leftTop) intersect: cRect).
            pen
                place: inRect center;
                foreColor: color;
                setTextAlign: TaTop;
                setBackMode: Transparent;
                font: self font;
                centerText: (self value - self min / (self max - self min) * 100) rounded asString , '%';
                destroyRegion: region.
            ].!   
cacheBitmap
    "Private"

    | pixelLoc cellExtent e aRect cellContents region |
    true
        ifTrue: [^self].
    cellExtent := self cellExtent.
    e := columnsRows * cellExtent.
    bitmap := Bitmap new ownDCScreenWidth: e x height: e y.
    pixelLoc := 0 @ 0.
    1 to: columnsRows x
        do:
            [:c |
            1 to: columnsRows y
                do:
                    [:r |
                    cellContents := self cellAt: c @ r.
                    aRect := pixelLoc extent: cellExtent.
                    bitmap
                        pen foreColor: self foreColor;
                        backColor: self backColor;
                        drawRectangle: aRect;
                        fill: (aRect insetBy: 3) color: self backColor;
                        draw3DRect: aRect
                            depth: 2
                            style: #out;
                        foreColor: self foreColor;
                        backColor: self backColor.
                    region := bitmap pen setClipRect: (aRect insetBy: 3).
                    cellContents notNil
                        ifTrue:
                            [cellContents isBitmap
                                ifTrue:
                                    [cellContents displayAt: aRect leftTop + (aRect extent - cellContents extent // 2) with: bitmap pen.
                                    ]
                                ifFalse:
                                    [cellContents isInteger | (cellContents isColor & cellContents isBitmap not)
                                        ifTrue:
                                            [bitmap pen fill: (aRect insetBy: 3) color: cellContents.
                                            ]
                                        ifFalse:
                                            [bitmap
                                                pen setTextAlign: TaTop;
                                                displayText: cellContents at: aRect leftTop + (aRect extent - (self font stringExtent: cellContents) // 2).
                                            ].
                                    ].
                            ].
                    bitmap pen destroyRegion: region.
                    pixelLoc y: (pixelLoc y + cellExtent y).
                    ].
            pixelLoc y: 0.
            pixelLoc x: (pixelLoc x + cellExtent x).
            ].!   
wbAddToBack
    "Private - Answer true if the receiver should be added to the back."

    ^true!   
thumbSize
    "Private"

    ^21!  
reframe
    "Private"

    (bitmap isNil or: [bitmap extent ~= (self cellExtent * columnsRows)])
        ifTrue:
            [self cacheBitmap.
            ].! 
supportedEvents
    "Private"

    ^super
        supportedEvents add: #select;
        add: #doubleClickSelect;
        yourself!  
fixedSize
    "Set the style to #fixedSize"

    cpStyle := #fixedSize!
button2Down: aPoint
    "Private"

    | doneOne startTime |

	#osiHack.
	true ifTrue: [ ^super button2Down: aPoint ].

    (self subpaneButton1Down: aPoint)
        ifFalse: [^self].
    self setFocus.
    doneOne := false.
    startTime := Time millisecondClockValue.
    (self thumbRect containsPoint: aPoint)
        ifTrue:
            [self whileMouseStillDown: []]
        ifFalse:
            [self
                whileMouseStillDownPrim:
                    [(doneOne not | (Time millisecondClockValue > (startTime + 300))) & (self rect containsPoint: self mouseLocation)
                        ifTrue:
                            [self button2StillDown: self mouseLocation.
                            doneOne := true.
                            ].
                    ].
            ].! 
cellAt: cell
put: item
    "Set the cell at the point to item"

    ^(cells at: cell x) at: cell y put: item! 
cpStyle
    "Private"

    ^style3D!   
thumbOrigin
    "Private"

    ^2 @ 2! 
min: value1
    "Set the minimum value"

    min := value1.
    self internalValue: self value.!  
bounded: aValue
    "Private"

    | newValue |
    newValue := aValue.
    min notNil & newValue notNil
        ifTrue:
            [newValue := newValue max: min.
            ].
    max notNil & newValue notNil
        ifTrue:
            [newValue := newValue min: max.
            ].
    ^newValue!   
in
    "Set the style of the reciever to #in"

    style3D := #in.!
wmErasebkgnd: wordInteger
with: longInteger
    "Private"

    ^nil!  
dragTargetFormatsDefault
        "Private - answer the formats of drag objects that the receiver will accept."
		"Answer in the order of preference..."
    ^#( 'bitmap' 'color' 'integer' 'string' )! 
triggerEvents
    "Private"

    self event: #valueChanged. " OBSOLETE "
    self triggerEvent: #valueChanged: with: self contents.!  
triggerDoubleClickSelectEvent

    self event: #doubleClickSelect.    "OBSOLETE"
    self triggerEvent: #doubleClickSelectCell: with: self selection.
    self triggerEvent: #doubleClickSelectItem: with: self selectedItem.!
dragTargetOperationForSelf: dragSession
		"Answer the operation when source = target = self."
	| sourceCell targetCell |
	(self dragTargetOperations includes: #copy) ifFalse: [ ^nil ].
	sourceCell := self propertyAt: #dragCell ifAbsent: [ ^nil ].
	targetCell := self cellForPoint: dragSession targetLocation.
	sourceCell = targetCell ifTrue: [ ^nil ].
	^#copy!   
textItem: anItem
row: row
column: column
    "Set the cell at column@row to be anItem"

    self cellAt: column @ row put: anItem.!  
bitmapItem: anItem
row: row
column: column
    "Set the cell at column@row to be anItem"

    self cellAt: column @ row put: anItem.!
contents: aBitmap
    "Set the bitmap displayed in the reciever"

    contents := aBitmap.
    rectangle notNil
        ifTrue: [self invalidateRect: nil].! 
value
    "Answer the current value"

    value isNil
        ifTrue: [value := 3].
    ^value!  
isCompatible: anObject
    "Is <anObject> compatible with the receiver"

	#obsoleteMethod.
    ^anObject isString or: [anObject isBitmap or: [anObject isInteger]]!   
initialize
    "Private"

    super initialize.
    showPercentage := true.!  
wmNchittest: wParam
with: lParam
    "Private - allow overlapping panes to get mouse input"

    ^-1 "HtTransparent"! 
dragTargetDropDefault: dragSession
        "Private - provide default handling of drop if no handler
        is provided by inserting the item into the list."
	| formats |
	formats := self dragTargetFormats.
	dragSession objects do: [ :each |
		formats do: [ :eachFormat |
			(each hasFormat: eachFormat) ifTrue: [
				self
                	cellAt: (self cellForPoint: dragSession targetLocation)
					put: (each format: eachFormat).
				^self redraw ] ] ].
	^nil!  
gettingFocus
    "Private"

    self drawFocusRect: ((self thumbOrigin extent: thumbBitmap extent) insetBy: 2).
    super gettingFocus.!  
min: value1 max: value2
    "Set the minimum and maximum value"

	value1 <= value2 ifTrue: [
		self min: value1.
		self max: value2.
	].!   
reframe
    "Private"

    | center rect |
    thumbBitmap notNil
        ifTrue:
            [thumbBitmap release.
            ].
    thumbBitmap := Bitmap screenExtent: (self width - 4) @ self thumbSize.
    rect := thumbBitmap boundingBox.
    thumbBitmap
        pen drawRectangle: rect;
        fill: (rect insetBy: 1) color: self backColor;
        foreColor: self darkerColor;
        lineFrom: (3 @ (center := rect center y)) to: (thumbBitmap width - 3) @ center;
        foreColor: self lighterColor.
    center := center + 1.
    thumbBitmap
        pen lineFrom: (3 @ center) to: (thumbBitmap width - 3) @ center;
        draw3DRect: rect
            depth: 1
            style: #out.! 
selection: cell
    "Set the selected cell"

    rectangle notNil
        ifTrue:
            [self unHighlightCell: selection.
            ].
    selection := cell.
    rectangle notNil
        ifTrue:
            [self highlightCell: cell.
            ].!  
min

    min isNil
        ifTrue: [min := 1].
    ^min!  
value: aValue
    "Set the current value"

    | newValue |
    newValue := self bounded: aValue.
    value = newValue
        ifFalse:
            [value := newValue.
            ]
        ifTrue:
            [^false].
    rectangle notNil
        ifTrue:
            [self invalidateRect: self invalidRect.
            ].!
highlightCell: aPoint
        "Private"
    | elem |
    self
        doGraphics:
            [(elem := self cellAt: aPoint) isInteger | (elem isColor & elem isBitmap not)
                ifTrue:
                    [self pen drawRectangle: ((self rectForCell: aPoint) insetBy: 4).
                    ]
                ifFalse:
                    [self pen reverse: ((self rectForCell: aPoint) insetBy: 1).
                    ].
            self drawFocusOn: aPoint checkFocus: true].!  
constructEventsTriggered
    "Private - answer the set of events that instances of the
     receiver can trigger."

    ^super
        constructEventsTriggered addAll: #(selectCell: selectItem: doubleClickSelectCell: doubleClickSelectItem:);
        yourself! 
dragSourceNeedsObjectDefault: dragSession
        "Private - provide default for requested drag items if no handler
        is provided by supplying the currently selected item."
    | obj dragDropObject data |
	(obj := self contents) ifNil: [ ^self ].
	dragDropObject := dragSession objectClass new
		object: obj;
		bitmap: obj;
		string: obj asString;
		yourself.
    dragSession objects: ( Array with: dragDropObject ).! 
rgbItem: anItem
row: row
column: column
    "Set the cell at column@row to be anItem"

    self cellAt: column @ row put: anItem.!   
pointToValue: aPoint
    "Private"

    | val |
    val := ((aPoint y - 2) * (self max - self min) // (self height - 4 - thumbBitmap height) + self min).
    ^self max - (val - self min)!  
contents
    "Answer the current value"

    ^self value!  
button2DoubleClick: aPoint
    "Private"

    ^self button2Down: aPoint!   
isCompatible: anObject
    "Is <anObject> compatible with the receiver"

	#obsoleteMethod.
    ^anObject isBitmap!
displayWith: pen
inRect: inRect
clipRect: cRect
    "Private"

    parent notNil
        ifTrue:
            [pen fill: self rect color: parent backColor.
            ].
    bitmap isNil
        ifTrue:
            [self
                    drawOn: pen
                    at: inRect leftTop
                    clipRect: cRect.
            ].
    (selection ~= (0 @ 0)) & graphicsTool notNil
        ifTrue:
            [self highlightCell: selection.
            ].!   
displayWith: pen
inRect: inRect
clipRect: cRect
    "Private"

    | y rect insideRect |
    rect := self rect translateBy: inRect leftTop.
    insideRect := rect insetBy: 2.
    y := (self value - self min) * insideRect height // (self max - self min).
    pen
        foreColor: Color black;
        drawRectangle: rect;
        draw3DRect: rect
            depth: 1
            style: #in;
        fill: (insideRect leftBottom extentFromLeftBottom: insideRect width @ y) color: self foreColor;
        fill: ((insideRect leftBottom up: y) rightTop: insideRect rightTop) color: self backColor.
    self
            displayPercentageWith: pen
            inRect: rect
            clipRect: cRect.!
initialize
    "Private"

    super initialize.
    selection := 1 @ 1.
    self rows: 2 columns: 2.!
enable
    "Enable the control"

	self disabled ifFalse: [ ^self ].
    self backColor: (self propertyAt: #holdBackColor).
    super enable.!
button1DoubleClick: aPoint
    "Private"

    self setFocus.
    self selection: (self cellForPoint: aPoint).
	self triggerDoubleClickSelectEvent.!  
columnsRows: aPoint
    "Private"

    | newCells |
    newCells := Array new: aPoint x.
    1 to: aPoint x
        do:
            [:i |
            newCells at: i put: (Array new: aPoint y).
            ].
    1 to: (columnsRows x min: aPoint x)
        do:
            [:column |
            1 to: (columnsRows y min: aPoint y)
                do:
                    [:row |
                    (newCells at: column) at: row put: (self cellAt: column @ row).
                    ].
            ].
    columnsRows := aPoint.
    selection := 1 @ 1.
    cells := newCells.!  
drawOn: aPen
at: aPoint
    "Private"

    | pixelLoc cellExtent aRect cellContents region |
    cellExtent := self cellExtent.
    pixelLoc := aPoint deepCopy.
    1 to: columnsRows x
        do:
            [:c |
            1 to: columnsRows y
                do:
                    [:r |
                    cellContents := self cellAt: c @ r.
                    aRect := pixelLoc extent: cellExtent.
                    aPen
                        foreColor: self foreColor;
                        backColor: self backColor;
                        drawRectangle: aRect;
                        fill: (aRect insetBy: 3) color: self backColor;
                        draw3DRect: aRect
                            depth: 2
                            style: #out;
                        foreColor: self foreColor;
                        backColor: self backColor.
                    region := aPen setClipRect: (aRect insetBy: 3).
                    cellContents notNil
                        ifTrue:
                            [cellContents isBitmap
                                ifTrue:
                                    [cellContents displayAt: aRect leftTop + (aRect extent - cellContents extent // 2) with: aPen.
                                    ]
                                ifFalse:
                                    [cellContents isInteger | (cellContents isColor & cellContents isBitmap not)
                                        ifTrue:
                                            [aPen fill: (aRect insetBy: 3) color: cellContents.
                                            ]
                                        ifFalse:
                                            [aPen
                                                setTextAlign: TaTop;
                                                displayText: cellContents at: aRect leftTop + (aRect extent - (self font stringExtent: cellContents) // 2).
                                            ].
                                    ].
                            ].
                    aPen destroyRegion: region.
                    pixelLoc y: (pixelLoc y + cellExtent y).
                    ].
            pixelLoc y: aPoint y.
            pixelLoc x: (pixelLoc x + cellExtent x).
            ].!
foreColor: color
    "Private"

    super foreColor: color.
    bitmap notNil
        ifTrue:
            [self cacheBitmap.
            ].!   
cells: aCollection
    "Private"

    cells := aCollection.!   
contents
    "Answer the bitmap displayed in the reciever"

    ^contents! 
showPercentage: aBoolean
    "Show the percentage number or not"

    showPercentage := aBoolean!  
out
    "Set the style of the reciever to #out"

    style3D := #out.! 
pointToValue: aPoint
    "Private"

    ^(((aPoint x - 2)) * (self max - self min) // (self width - 4 - thumbBitmap width) + self min).!   
contents: anObject
    "Set the current value"

    | anInteger |
    [ anInteger := anObject asInteger ] on: Error do: [ ^self ].
    self value: anInteger.!   
defaultBackColor
    "Private - Answer the default background color 
         for the receiver."

    "In the ST/V 3.0 beta release 2, Color windowBackground
        returned an RGBColor and would cause a stack
        overflow... so return an IndexedColor instead."

    ^Color windowBackground asIndexedColor!   
drawBorder: aBoolean
    "Private"

    drawBorder := aBoolean!
defaultForeColor
    "Private"

    ^Color staticText! 
drawOn: aPen
at: aPoint
clipRect: cRect
    "Private"

    | pixelLoc cellExtent aRect cellContents region |
    cellExtent := self cellExtent.
    pixelLoc := aPoint deepCopy.
    1 to: columnsRows x
        do:
            [:c |
            1 to: columnsRows y
                do:
                    [:r |
                    cellContents := self cellAt: c @ r.
                    aRect := pixelLoc extent: cellExtent.
                    region := aPen setClipRect: cRect.
                    aPen
                        foreColor: self foreColor;
                        backColor: self backColor;
                        drawRectangle: aRect;
                        fill: (aRect insetBy: 3) color: self backColor;
                        draw3DRect: aRect
                            depth: 2
                            style: #out;
                        foreColor: self foreColor;
                        backColor: self backColor;
                        destroyRegion: region.
                    (cellContents notNil and: [cellContents isBitmap not])
                        ifTrue:
                            [region := aPen setClipRect: ((aRect insetBy: 3) intersect: cRect).
                            cellContents isInteger | (cellContents isColor & cellContents isBitmap not)
                                ifTrue:
                                    [aPen fill: (aRect insetBy: 3) color: cellContents.
                                    ]
                                ifFalse:
                                    [aPen
                                        setTextAlign: TaTop;
                                        displayText: cellContents at: aRect leftTop + (aRect extent - (self font stringExtent: cellContents) // 2).
                                    ].
                            aPen destroyRegion: region.
                            ].
                    pixelLoc y: (pixelLoc y + cellExtent y).
                    ].
            pixelLoc y: aPoint y.
            pixelLoc x: (pixelLoc x + cellExtent x).
            ].
    "Moved drawing of bitmaps to end, so they wouldn't
     prevent drawing of other aspects to an offscreen bitmap"
    pixelLoc := aPoint deepCopy.
    1 to: columnsRows x
        do:
            [:c |
            1 to: columnsRows y
                do:
                    [:r |
                    cellContents := self cellAt: c @ r.
                    (cellContents notNil and: [cellContents isBitmap])
                        ifTrue:
                            [aRect := pixelLoc extent: cellExtent.
                            region := aPen setClipRect: ((aRect insetBy: 3) intersect: cRect).
                            cellContents displayAt: aRect leftTop + (aRect extent - cellContents extent // 2) with: aPen.
                            aPen destroyRegion: region.
                            ].
                    pixelLoc y: (pixelLoc y + cellExtent y).
                    ].
            pixelLoc y: aPoint y.
            pixelLoc x: (pixelLoc x + cellExtent x).
            ].!   
button1Down: point
    "Private - Support Drag & Drop"

    (self subpaneButton1Down: point)
        ifFalse: [^self].
    self whileMouseStillDown: []! 
backColor: color
    "Set the backcolor"

    super backColor: color.
    bitmap notNil
        ifTrue:
            [self cacheBitmap.
            ].! 
unHighlightCell: aPoint
    "Private"

    | color |
    self
        doGraphics:
            [self drawFocusOn: aPoint checkFocus: true.
            (color := self cellAt: aPoint) isInteger | (color isColor & color isBitmap not)
                ifTrue:
                    [self pen fill: ((self rectForCell: aPoint) insetBy: 3) color: color.
                    ]
                ifFalse:
                    [self pen reverse: ((self rectForCell: aPoint) insetBy: 1).
                    ].
            ].!   
dragTargetFormatsDefault
        "Private - answer the formats of drag objects that the receiver will accept."
    ^#( 'integer' )! 
outline
    "Set the style of the reciever to #outline"

    style3D := #outline.! 
max: value1
    "Set the maximum value"

    max := value1.
    self internalValue: self value.!  
drawFocusOn: cell
checkFocus: aBoolean
color: ignore
    "Private"

    aBoolean & self hasFocus not
        ifTrue: [^self].
    self drawFocusRect: ((self rectForCell: cell) insetBy: 4).!  
supportedEvents
    "Private"

    ^super
        supportedEvents add: #valueChanged;
        yourself!  
button1Down: point
    "Private - Support Drag & Drop"

    (self subpaneButton1Down: point)
        ifFalse: [^self].
    self whileMouseStillDown: []! 
displayWith: pen
inRect: inRect
    "Private"

    parent notNil
        ifTrue:
            [pen fill: self rect color: parent backColor.
            ].
    bitmap isNil
        ifTrue:
            [self drawOn: pen at: inRect leftTop.
            ].
    (selection ~= (0 @ 0)) & graphicsTool notNil
        ifTrue:
            [self highlightCell: selection.
            ].!   
thumbOrigin
    "Private"

    | origin |
    self max = self min
        ifTrue:
            [origin := 2]
        ifFalse:
            [origin := ((self value - self min) * (self height - 4 - thumbBitmap height) // (self max - self min)).
            ].
    ^2 @ (self height - 2 - origin - thumbBitmap height)!   
triggerValueChangedEvent

    self event: #valueChanged. " OBSOLETE "
    self triggerEvent: #valueChanged: with: self contents.!  
cpStyle: aSymbol
    "Private"

    cpStyle := aSymbol!
initialize
    "Private"

    super initialize.
    min := 1.
    max := 10.
    value := 3.!   
columnsRows
    "Private"

    ^columnsRows!   
drawFocusOn: cell
checkFocus: aBoolean
    "Private"

    self
            drawFocusOn: cell
            checkFocus: aBoolean
            color: Color black!  
isCompatible: anObject
    "Is <anObject> compatible with the receiver"

	#obsoleteMethod.
    ^anObject respondsTo: #asInteger!  
keyboardInput: aKeyboardInputEvent
        "Private - keyboard input was received."
    | virtualKey changed |

    virtualKey := aKeyboardInputEvent virtualKey.
    virtualKey = VkUp ifTrue: [ ^self increment ].
    virtualKey = VkDown ifTrue: [ ^self decrement ].
    virtualKey = VkHome ifTrue: [ ^self internalValue: min ].
    virtualKey = VkEnd ifTrue: [ ^self internalValue: max ].
    virtualKey = VkLeft ifTrue: [ ^self decrement ].
    virtualKey = VkRight ifTrue: [ ^self increment ].
    ^super keyboardInput: aKeyboardInputEvent! 
decrement
    "Decrement current value"

    self internalValue: self value - 1.!  
button1Down: aPoint
    "Private"

	| nextTime |
	Smalltalk platformIsWin32 ifTrue: [
	    (self subpaneButton1Down: aPoint)
    	    ifFalse: [^self] ].
    self setFocus.
    (self thumbRect containsPoint: aPoint)
        ifTrue:
            [self
                doGraphics:
                    [thumbButtonOrigin := (self
                            dragForm: thumbBitmap
                            origin: thumbButtonOrigin
                            constrainedBy: (self rect insetBy: 2)).
                    ].
            self internalValue: (self pointToValue: thumbButtonOrigin).
            ]
        ifFalse:
            [self button2StillDown: self mouseLocation.
			nextTime := Time millisecondClockValue + 300.
			self
                whileMouseStillDownPrim:
                    [(Time millisecondClockValue >= nextTime)
						& (self rect containsPoint: self mouseLocation)
                        ifTrue:
                            [self button2StillDown: self mouseLocation.
                            ].
                    ].
            ].
"
            [self internalValue: (self pointToValue: aPoint - (self thumbSize // 2)).
            self whileMouseStillDown: [].
            ].
"! 
disable
    "Disable the control"

    self disabled
        ifTrue: [^self].
    self propertyAt: #holdBackColor put: self backColor.
    self backColor: Color darkGray.
    super disable.! 
cellExtent
    "Private"

    ^self extent // columnsRows! 
button2StillDown: aPoint
    "Private"

    aPoint y < thumbButtonOrigin y
        ifTrue: [self increment].
    aPoint y > self thumbRect bottom
        ifTrue: [self decrement].!
inBounds: cell
    "Private"

    ^(cell x > 0) & (cell y > 0) & (cell x <= columnsRows x) & (cell y <= columnsRows y)!
reframe
    "Private"

    | center |
    thumbBitmap notNil
        ifTrue:
            [thumbBitmap release.
            ].
    thumbBitmap := Bitmap screenExtent: self thumbSize @ (rectangle height - 4).
    thumbBitmap
        pen foreColor: self middleColor;
        drawRectangle: thumbBitmap boundingBox;
        fill: (thumbBitmap boundingBox insetBy: 1) color: self backColor;
        foreColor: self darkerColor;
        lineFrom: ((center := thumbBitmap boundingBox center x) @ 3) to: center @ (thumbBitmap height - 3);
        foreColor: self lighterColor.
    center := center + 1.
    thumbBitmap
        pen lineFrom: (center @ 3) to: center @ (thumbBitmap height - 3);
        draw3DRect: thumbBitmap boundingBox
            depth: 1
            style: #out.!  
displayWith: pen
inRect: inRect
    "Private"

    | rect |
    rect := self rect translateBy: inRect leftTop.
    thumbButtonOrigin := self thumbOrigin + rect leftTop.
    pen
        foreColor: self middleColor;
        drawRectangle: rect;
        draw3DRect: rect
            depth: 1
            style: #in;
        fill: (rect insetBy: 2) color: self backColor.
    thumbBitmap displayAt: thumbButtonOrigin with: pen.
    (self hasFocus and: [ self isValid ])
        ifTrue:
            [self gettingFocus.
            ].!   
displayWith: pen
inRect: aRect
    "Private"

    | rect inRect |
    rect := aRect leftTop extent: self extent.
    style3D == #outline
        ifFalse:
            [pen
                draw3DRect: (rect expandBy: 1)
                    depth: 2
                    style: style3D;
                foreColor: self foreColor.
            drawBorder = true
                ifTrue:
                    [pen drawRectangle: rect.
                    ].
            ]
        ifTrue:
            [contents isNil | (contents = '')
                ifTrue:
                    [pen
                        fill: (rect leftTop extent: rect width @ self font height) color: self backColor;
                        draw3DRect: rect
                            depth: 2
                            style: style3D.
                    ]
                ifFalse:
                    [pen
                        fill: (rect leftTop extent: rect width @ self font height) color: self backColor;
                        draw3DRect: (inRect := rect leftTop + (0 @ (self font height // 2)) corner: rect corner)
                            depth: 2
                            style: style3D;
                        fill: (rect leftTop + (8 @ 0) extent: ((self font stringExtent: contents stripMnemonic) x + 4) @ self font height) color: self backColor;
                        setBackMode: Transparent;
                        setTextAlign: TaTop;
                        foreColor: self foreColor;
                        winDrawText: contents at: rect leftTop + (10 @ 0).
                    ].
            ].!
thumbOrigin
    "Private"

    self max = self min
        ifTrue: [^2 @ 2].
    ^(2 + ((self value - self min) * (self width - 4 - thumbBitmap width) // (self max - self min))) @ 2.!  
defaultForeColor
    "Private - Answer the default background color 
         for the receiver."

    ^Color black!   
displayWith: pen
inRect: inRect
clipRect: cRect
    "Private"

    | x rect insideRect |
    rect := self rect translateBy: inRect leftTop.
    insideRect := rect insetBy: 2.
    x := (self value - self min) * insideRect width // (self max - self min).
    pen
        foreColor: Color black;
        drawRectangle: rect;
        draw3DRect: rect
            depth: 1
            style: #in;
        fill: (insideRect leftTop extent: x @ insideRect height) color: self foreColor;
        fill: (insideRect leftTop + (x @ 0) corner: insideRect corner) color: self backColor.
    self
            displayPercentageWith: pen
            inRect: rect
            clipRect: cRect.!  
constructEventsTriggered
    "Private - answer the set of events that instances of the
     receiver can trigger."

    ^super
        constructEventsTriggered addAll: #(valueChanged: valueChanging:);
        yourself!  
defaultDroppedOn: aDragDropList
    "Accept the drag and drop."

    #obsoleteMethod.
    aDragDropList items notEmpty
        ifTrue:
            [self
                cellAt: (self cellForPoint: aDragDropList location)
                put:
                    (aDragDropList items
                    detect:
                        [:item |
                        self isCompatible: item]
                    ifNone: [aDragDropList items first asString]).
            self display].! 
initialize
    "Private"

    super initialize.
    style3D := #outline.! 
defaultDragDropObjects
    "Answer the list of items that should be
     passed during drag-drop"

    | dragObjects |
    #obsoleteMethod.
    (dragObjects := self getDefaultDragObjects) notNil
        ifTrue: [^dragObjects].
    dragObjects := Array with: (self cellAt: (self propertyAt: #dragCell)).
    dragObjects first isNil
        ifTrue: [^nil].
    self renderAsObjects
        ifFalse:
            [dragObjects := dragObjects
                collect:
                    [:each |
                    each asString]].
    ^dragObjects!
constructEventsTriggered
    "Private - answer the set of events that instances of the
     receiver can trigger."

    ^super
        constructEventsTriggered addAll: #(valueChanged:);
        yourself! 
thumbRect
    "Private"

    ^thumbButtonOrigin extent: thumbBitmap extent!
rectForCell: cell
    "Private"

    | cellExtent |
    cellExtent := self cellExtent.
    ^(cell - 1) * (self cellExtent) extent: self cellExtent!  
supportedEvents
    "Private"

    ^super
        supportedEvents add: #valueChanged;
        add: #valueChanging;
        yourself!
gettingFocus
    "Private"

    self drawFocusOn: selection checkFocus: false.
    super gettingFocus.!   
max

    max isNil
        ifTrue: [max := 3].
    ^max!  
triggerEvents
    "Private"

	self triggerValueChangingEvent: self contents.
	self triggerValueChangedEvent.! 
dragSourceNeedsObjectDefault: dragSession
        "Private - provide default for requested drag items if no handler
        is provided by supplying the currently selected item."
    | obj dragDropObject |
    (obj := self cellAt: (self propertyAt: #dragCell ifAbsent: [ ^self ])) ifNil: [ ^self ].
    (dragDropObject := dragSession objectClass new) object: obj.
    obj isString ifTrue: [ dragDropObject string: obj ].
    obj isBitmap ifTrue: [ dragDropObject bitmap: obj ].
    obj isColor & obj isBitmap not ifTrue: [
        dragDropObject format: 'color' data: obj.
        obj isIndexedColor ifTrue: [
            dragDropObject format: 'integer' data: obj index ] ].
    obj isInteger ifTrue: [
        dragDropObject format: 'integer' data: obj.
        dragDropObject format: 'color' data: obj asColor.
        dragDropObject string: obj asString ].
    dragSession objects: ( Array with: dragDropObject ).!
colorItem: anItem
row: row
column: column
    "Set the cell at column@row to be anItem"

    self cellAt: column @ row put: anItem.! 
stretchToFit
    "Set the style to #stretchToFit"

    cpStyle := #stretchToFit!   
displayWith: pen
inRect: inRect
clipRect: cRect
    "Private"

    | angle rect major minor bitmap maskBitmap region |
    rect := self rect.
    angle := (self value - self min) * 360 // (self max - self min).
    major := rect width // 2.
    minor := rect height // 2.
    bitmap := Bitmap screenExtent: self extent.
    bitmap pen fill: bitmap boundingBox color: self backColor.
    bitmap
        pen place: rect center;
        foreColor: self foreColor;
        backColor: self foreColor;
        pieFilled: major
            minor: minor
            angles: 270 @ angle;
        foreColor: self backColor;
        backColor: self backColor.
    angle = 360
        ifFalse:
            [bitmap
                pen place: rect center;
                pieFilled: major
                    minor: minor
                    angles: (270 + angle) @ (360 - angle).
            ].
    bitmap
        pen foreColor: Color black;
        ellipse: major minor: minor.
    self
            displayPercentageWith: bitmap pen
            inRect: (0 @ 0 extent: rect extent)
            clipRect: (0 @ 0 extent: cRect extent).
    bitmap displayAt: inRect leftTop with: pen.
    bitmap release.!
selectedItem
    "Answer the item at the selected cell"

    ^self cellAt: selection!  
losingFocus
    "Private"

    self drawFocusOn: selection checkFocus: false.
    super losingFocus.! 
cpStyle
    "Private"

    ^cpStyle!   
style3D: aSymbol
    "Private"

    style3D := aSymbol!
dragForm: bitmap
origin: origin
constrainedBy: constrainRect
    "Private"

    | mouseLoc moveRect newPoint delta |
    moveRect := origin extent: bitmap extent.
    delta := self mouseLocation - moveRect leftTop.
    self
        whileMouseStillDownPrim:
            [mouseLoc := self mouseLocation.
            newPoint := mouseLoc - delta.
            newPoint x: ((newPoint x rightMost: constrainRect left) leftMost: (constrainRect right left: moveRect width)).
            newPoint y: ((newPoint y lowerOf: constrainRect top) higherOf: (constrainRect bottom up: moveRect height)).
            (newPoint = moveRect leftTop)
                ifFalse:
                    [(moveRect nonIntersections: (newPoint extent: bitmap extent))
                        do:
                            [:r |
                            self pen fill: r color: self backColor.
                            ].
                    bitmap displayAt: newPoint with: self pen.
                    moveRect moveTo: newPoint.
                    value := (self pointToValue: moveRect leftTop).
                    self event: #valueChanging. " OBSOLETE "
                    self triggerEvent: #valueChanging: with: value.
                    ].
            ].
    value := nil.
    ^moveRect leftTop!  
losingFocus
    "Private"

    self gettingFocus.
    super losingFocus.! 
button2StillDown: aPoint
    "Private"

    aPoint x < thumbButtonOrigin x
        ifTrue: [self decrement].
    aPoint x > self thumbRect right
        ifTrue: [self increment].! 
internalValue: aValue
    "Private"

    (self value: aValue) = false
        ifFalse: [self triggerEvents].! 
triggerValueChangingEvent: aValue

    self event: #valueChanging. " OBSOLETE "
    self triggerEvent: #valueChanging: with: aValue.!