05/04/95 02:03:44 PM

choices: aList
    "Private"

    choices := aList.
    value := 1.!  
min: anInteger
    "Private"

    min := anInteger!
leftJustified
    "Use left justification"

    currentField justification: #left! 
contents
    "Answer the contents of the reciever"

    ^currentField value.!  
width
    "Private"

    ^width!   
min: anInteger1
max: anInteger2
    "Private"

    min := anInteger1.
    max := anInteger2.!
separator: aString
    "Set the separator used between the hour and minute"

    separator := aString.
    (fields after: hourField) value: aString.! 
defaultForeColor
    "Private"

    ^Color windowText! 
rect: aRect
    "Private"

    rect := aRect!  
inputState: aSymbol
    "Private"

    inputState := aSymbol.
    (inputState ~= #editing) & (value = '-')
        ifTrue: [self value: 0].! 
defaultDragDropObjects
    "Answer the list of items that should be
     passed during drag-drop"

    | dragObjects |
    #obsoleteMethod.
    (dragObjects := self getDefaultDragObjects) notNil
        ifTrue: [^dragObjects].
    dragObjects := Array with: self selectedItem.
    dragObjects first isNil
        ifTrue: [^nil].
    ^dragObjects! 
normalizeValue
    "Private"

    max notNil
        ifTrue:
            [value > max
                ifTrue:
                    [value := max.
                    ].
            ].
    min notNil
        ifTrue:
            [value < min
                ifTrue:
                    [value := min.
                    ].
            ].!  
contents
    "Answer the contents of the reciever"

    | anInteger |
    (anInteger := super contents) = '-'
        ifTrue:
            [^(0
                min:
                    (currentField max isNil
                    ifTrue: [0]
                    ifFalse: [currentField max]))
                max:
                    (currentField min isNil
                    ifTrue: [0]
                    ifFalse: [currentField min])]
        ifFalse:
            [^anInteger].!  
characterInput: aChar
    "Private"

    currentField characterInput: aChar.
    currentField inEdit
        ifFalse:
            [self contents.
            self triggerEvents.
            ].! 
inputState
    "Private"

    ^inputState! 
initialize
    "Private"

    super initialize.
    fields := OrderedCollection
        with:
            (currentField := SpinField
            new parent: self;
            width: 0.99;
            choices: #(); "choices: #('Monday' 'Tuesday' 'Wednesday' 'Thursday' 'Friday');"
            justification: #center).!   
min: newValue
    "Set the minimum value the reciever"

    currentField min: newValue!
incrementMinute
    "Private"

    (minuteField value = 59)
        ifTrue:
            [minuteField value: 0.
            self incrementHour.
            ]
        ifFalse:
            [minuteField increment].!  
characterInput: aChar
    "Private"

    currentField characterInput: aChar.
    (fields
        select:
            [:f |
            f inEdit]) isEmpty
        ifTrue:
            [self contents.
            self triggerEvents.
            ].!  
rightJustified
    "Use right justification"

    currentField justification: #right!  
justification: aSymbol
    "Private"

    justification := aSymbol!
displayWith: pen
inRect: inRect
clipRect: cRect
    "Private"

    | incRect decRect aBitmap rect region |
    rect := self rect translateBy: inRect leftTop.
    incRect := self incrementRect translateBy: inRect leftTop.
    decRect := self decrementRect translateBy: inRect leftTop.
    pen
        fill: rect color: self backColor;
        foreColor: self middleColor;
        drawRectangle: rect.
    rect := rect leftTop extent: self extent - ((incRect width - 1) @ 0).
    pen
        drawRectangle: rect;
        draw3DRect: rect
            depth: 1
            style: #in;
        fill: incRect color: self middleColor;
        fill: decRect color: self middleColor;
        draw3DRect: incRect
            depth: 1
            style: #out;
        draw3DRect: decRect
            depth: 1
            style: #out;
        backColor: self middleColor;
        foreColor: self foreColor.
    "Added test whether we're drawing within WB or not to
      determine whether to draw the fields before or after the bitmaps.  It turns out
      that drawing them before caused bitmap display problems in dialogs (?!!)"
    self inWindowBuilder
        ifTrue:
            [fields
                do:
                    [:field |
                    field
                            displayAt: rect leftTop
                            with: pen
                            clipRect: cRect].
            ].
    aBitmap := CPLittleUpArrowSysBitmap.
    pen
            copyBitmap: aBitmap
            from: aBitmap boundingBox
            at: incRect leftTop + (incRect extent - aBitmap extent // 2)
            rule: Srcand.
    aBitmap := CPLittleDownArrowSysBitmap.
    pen
            copyBitmap: aBitmap
            from: aBitmap boundingBox
            at: decRect leftTop + (decRect extent - aBitmap extent // 2)
            rule: Srcand.
    self inWindowBuilder
        ifFalse:
            [fields
                do:
                    [:field |
                    field
                            displayAt: rect leftTop
                            with: pen
                            clipRect: cRect].
            ].! 
display
    "Private"

    parent isHandleOk ifFalse: [ ^self ].
    parent
        doGraphics:
            [self
                    displayAt: 0 @ 0
                    with: parent pen
                    clipRect: nil].! 
separator: aString
    "Set the separator used between the day, month and year"

    separator := aString.
    fields notNil
        ifTrue:
            [fields
                do:
                    [:field |
                    field isStatic
                        ifTrue: [field value: aString]].
            ].! 
value: aValue
    "Private"

    (value = aValue)
        ifTrue: [^self].
    value := aValue.
    aValue isInteger
        ifFalse:
            [inputState := #static.
            width := aValue size.
            ].
    self display.!  
keyboardInput: aKeyboardInputEvent
        "Private - keyboard input was received."
    | virtualKey changed |

    virtualKey := aKeyboardInputEvent virtualKey.
    changed := false.
    virtualKey = VkLeft
        ifTrue: [^self shiftLeft].
    virtualKey = VkRight
        ifTrue: [^self shiftRight].
    virtualKey = VkUp
        ifTrue:
            [self increment.
            changed := true].
    virtualKey = VkDown
        ifTrue:
            [self decrement.
            changed := true].
    (virtualKey = VkHome) & currentField min notNil
        ifTrue:
            [currentField
                value: currentField min;
                display.
            changed := true.
            ].
    (virtualKey = VkEnd) & currentField max notNil
        ifTrue:
            [currentField
                value: currentField max;
                display.
            changed := true.
            ].
    changed
        ifTrue: [ self triggerEvents ]
        ifFalse: [ super keyboardInput: aKeyboardInputEvent ].!   
contents: anObject
    "Set the selected date to aDate"

    | aDate |

    [ aDate := anObject asDate ] on: Error do: [ ^self ].
    monthField value: aDate monthIndex.
    dayField value: aDate dayOfMonth.
    yearField value: aDate year.! 
fieldRect
    "Private"

    ^(0 @ 0 extent: (self extent x - self buttonWidth) @ (self extent y + 1)) insetBy: 4 @ 6! 
hour
    "Answer the selected hour"

    format == #hour12
        ifTrue:
            [hourField value: ((hourField value max: 1) min: 12).
            ]
        ifFalse:
            [hourField value: ((hourField value max: 1) min: 24).
            ].
    ^hourField value!  
format
    "Answer the format string: one of #mdy, #dmy, or #ymd."

    ^format!   
leadingZero: aBoolean
    "Show the leading zero or not"

    hourField showLeadingZeros: aBoolean!
decrementYear
    "Private"

    (yearField value = 0)
        ifTrue:
            [yearField value: 99.
            ]
        ifFalse:
            [yearField decrement.
            ].!
incrementYear
    "Private"

    (yearField value = 99)
        ifTrue:
            [yearField value: 0.
            ]
        ifFalse:
            [yearField increment.
            ].!
max

    ^currentField max! 
dragSourceNeedsObjectDefault: dragSession
        "Private - provide default for requested drag items if no handler
        is provided by supplying the currently selected item."
    | dragDropObject |
	(dragDropObject := dragSession objectClass new)
		object: self selectedItem;
		string: dragDropObject object asString.
	dragDropObject object isNil ifTrue: [ ^self ].
    dragSession objects: ( Array with: dragDropObject ).!   
decrement
    "Private"

    | newValue |
    newValue := value.
    choices notNil
        ifTrue:
            [newValue := newValue - 1.
            newValue < 1
                ifTrue:
                    [newValue := choices size.
                    ].
            ]
        ifFalse:
            [(min isNil or: [newValue > min])
                ifTrue:
                    [newValue := newValue - 1.
                    ].
            ].
    self value: newValue!  
buttonWidth
    "Private"

    ^17!
century
    "Private"

    ^yearField width = 4!   
incrementHour
    "Private"

    format == #hour24
        ifTrue:
            [(self hour = 24)
                ifTrue: [^hourField value: 1].
            hourField increment.
            ]
        ifFalse:
            [(self hour = 12)
                ifTrue: [^hourField value: 1].
            (self hour = 11)
                ifTrue:
                    [hourField value: 12.
                    meridianField increment.
                    ]
                ifFalse:
                    [hourField increment].
            ].! 
characterInput: aChar
    "Private"

    | int oldValue |
    parent disabled
        ifTrue: [^self].
    choices notNil
        ifTrue:
            [int := value.
            [int := int + 1.
                int > choices size
                    ifTrue: [int := 1].
                (((choices at: int) asString at: 1) asUpperCase = aChar asUpperCase) | (int = value)]
                whileFalse: [].
            self value: int.
            ]
        ifFalse:
            [aChar isDigit | (aChar = $-)
                ifFalse:
                    [(Smalltalk at: #Terminal) bell.
                    ]
                ifTrue:
                    [inputState == #editing
                        ifFalse:
                            [aChar = $-
                                ifTrue:
                                    [inputState := #editing.
                                    value := '-'.
                                    ]
                                ifFalse:
                                    [value := (String with: aChar) asInteger.
                                    inputState := #editing.
                                    ].
                            charactersTyped := 1.
                            ]
                        ifTrue:
                            [value := (value asString , (String with: aChar)) asInteger.
                            charactersTyped := charactersTyped + 1.
                            ].
                    oldValue := value.
                    self display.
                    (oldValue ~= value) | (charactersTyped = width)
                        ifTrue:
                            [self inputState: #focus.
                            self display.
                            parent shiftRight.
                            ].
                    ].
            ]! 
decrement
    "Private"

    (currentField == hourField)
        ifTrue:
            [self decrementHour]
        ifFalse:
            [(currentField == minuteField)
                ifTrue:
                    [self decrementMinute]
                ifFalse:
                    [meridianField decrement.
                    ].
            ].
    self contents!
isCompatible: anObject
    "Is <anObject> compatible with the receiver"

	#obsoleteMethod.
    ^anObject respondsTo: #asTime! 
fields: listOfSpinFields
    "Private"

    fields := listOfSpinFields.
    currentField := fields first.!
losingFocus
    "Private"

    currentField losingFocus.
    super losingFocus.!  
monthAsText
    "Set the month style to be unabbreviated text"

    self propertyAt: #cpStyle put: #monthAsText.
    monthField
        justification: #center;
        choices: #('January' 'February' 'March' 'April' 'May' 'June' 'July' 'August' 'September' 'October' 'November' 'December');
        width: 9!   
gettingFocus
    "Private"

    self inputState: #focus.
    self display.!   
max
    "Private"

    ^max!   
backspace
    "Private"

    | newValue |
    self inEdit
        ifFalse: [^self].
    newValue := value asString.
    newValue := newValue copyFrom: 1 to: newValue size - 1.
    newValue = ''
        ifTrue:
            [inputState := #nothing.
            ^self value: 0].
    self value: newValue asInteger.!  
contents
    "Answer the selected date"

    | year century cutoff |
    year := yearField value.
    self century
        ifFalse:
            [year < 100
                ifTrue:
                    [century := Date today year // 100 * 100.
                    cutoff := Date today year \\ 100 - 40 "Adjust to change the cutoff".
                    cutoff < 0
                        ifTrue: [cutoff := cutoff + 100].
                    year < cutoff
                        ifTrue: [year := year + century + 100]
                        ifFalse: [year := year + century].
                    ].
            ].
    ^Date
            newDay: self day
            month: (Date nameOfMonth: self month)
            year: year!   
valueChanged
    "Private"!  
leadingZero

    ^hourField showLeadingZeros!   
contents: anObject
    "Set the selected time to newTime"

    | hours newTime |
    [ newTime := anObject asTime ] on: Error do: [ ^self ].
    (self contents = newTime or: [newTime isNil])
        ifTrue: [^self].
    hours := newTime hours.
    format == #hour24
        ifTrue:
            [hours = 0
                ifTrue:
                    [hours := 24.
                    ].
            ]
        ifFalse:
            [(hours >= 12)
                ifTrue:
                    [meridianField value: 2.
                    (hours > 12)
                        ifTrue:
                            [hours := hours - 12.
                            ].
                    ]
                ifFalse:
                    [meridianField value: 1.
                    (hours = 0)
                        ifTrue:
                            [hours := 12.
                            ].
                    ].
            ].
    hourField value: hours.
    minuteField value: newTime minutes.!   
reframe
    "Private"

    | totalFixed totalVariable charWidth fieldRect x w widths |
    totalFixed := 0.
    charWidth := self font charWidth: $0.
    widths := Dictionary new.
    fields
        do:
            [:f |
            f width >= 1
                ifTrue:
                    [f isStatic
                        ifTrue:
                            [w := (self font stringExtent: f value) x.
                            ]
                        ifFalse:
                            [f choices notNil
                                ifTrue:
                                    [w := 0.
                                    f choices
                                        do:
                                            [:choice |
                                            w := w max: (self font stringExtent: choice) x].
                                    ]
                                ifFalse:
                                    [w := f width * charWidth.
                                    ].
                            ].
                    widths at: f put: w + 2.
                    totalFixed := totalFixed + w + 2.
                    ].
            ].
    fieldRect := self fieldRect.
    totalVariable := fieldRect width - totalFixed.
    x := fieldRect left.
    fields
        do:
            [:f |
            f width >= 1
                ifTrue:
                    [f rect: ((x @ fieldRect top) extent: (widths at: f) @ fieldRect height).
                    ]
                ifFalse:
                    [f rect: ((x @ fieldRect top) extent: (f width * totalVariable) rounded @ fieldRect height).
                    ].
            x := x + f rect width.
            ].!   
constructEventsTriggered
    "Private - answer the set of events that instances of the
     receiver can trigger."

    ^super
        constructEventsTriggered addAll: #(valueChanged:);
        yourself! 
valueString
    "Private"

    | string |
    (choices isNil or: [choices isEmpty])
        ifFalse:
            [string := (choices at: value) asString.
            ]
        ifTrue:
            [value isInteger
                ifTrue:
                    [inputState = #nothing
                        ifTrue: [^''].
                    self normalizeValue.
                    string := value asString.
                    self showLeadingZeros
                        ifTrue:
                            [string := ((String new: (width - string size max: 0)) atAllPut: $0) , string.
                            ].
                    (width >= 1) & (string size > width)
                        ifTrue:
                            [string := string copyFrom: (string size - width + 1) to: string size.
                            ].
                    ]
                ifFalse:
                    [string := value asString.
                    ].
            ].
    ^string! 
dayLeadingZero: aBoolean
    "Show the leading zero on a day or not"

    dayField showLeadingZeros: aBoolean.!
decrement
    "Private"

    (currentField == dayField)
        ifTrue:
            [self decrementDay]
        ifFalse:
            [(currentField == monthField)
                ifTrue:
                    [self decrementMonth.
                    ]
                ifFalse:
                    [self decrementYear.
                    ].
            ].
    self contents.! 
choices
    "Private"

    ^choices!   
amString
    "Private"

    ^meridianField choices first!  
max: newValue
    "Set the maximum value the reciever"

    ^currentField max: newValue!   
dragTargetFormatsDefault
        "Private - answer the formats of drag objects that the receiver will accept."
    ^#( 'integer' )! 
format

    ^format!
increment
    "Increment the reciever"

    currentField increment!
lastDayInMonth
    "Private"

    ^Date daysInMonth: (Date nameOfMonth: self month) forYear: yearField value!  
separator
	"Answer the separator string (1 character long) used to separate the DMY fields."

    ^separator!  
contents: newValue
    "Set the contents of the reciever"

    currentField value: newValue!   
decrement
    "Set the selection to the next item in the list"

    ^super increment!  
initialize
    "Private"

    super initialize.
    fields := OrderedCollection
        with:
            (currentField := SpinField
            new parent: self;
            width: 0.99;
            justification: #right;
            value: 0;
            min: nil max: nil).!  
showLeadingZeros
    "Private"

    ^showLeadingZeros = true!  
shiftLeft
    "Private"

    | field |
    (currentField == fields first) | ((fields
        select:
            [:field |
            field isStatic not]) size <= 1)
        ifTrue: [^self].
    field := currentField.
    [field := fields before: field.
        (field isStatic not) | (field == fields first)]
        whileFalse: [].
    field == currentField
        ifFalse:
            [currentField losingFocus.
            currentField := field.
            currentField gettingFocus.
            ].!  
minute
    "Answer the selected minute"

    minuteField value: ((minuteField value max: 0) min: 59).
    ^minuteField value! 
button1DoubleClick: aPoint
    "Private"

    ^self button1Down: aPoint!   
contents
    "Answer the contents of the reciever"

    ^currentField choices! 
constructEventsTriggered
    "Private - answer the set of events that instances of the
     receiver can trigger."

    ^super
        constructEventsTriggered remove: #valueChanged:;
        add: #select:;
        yourself!   
isCompatible: anObject
    "Is <anObject> compatible with the receiver"

	#obsoleteMethod.
    ^anObject respondsTo: #asDate! 
selection: anItem
    "Set selected item to anItem"

    anItem isInteger
        ifTrue:
            [currentField value: anItem]
        ifFalse:
            [currentField value: (currentField choices indexOf: anItem).
            ].!  
initialize
    "Private"

    super initialize.
    fields := OrderedCollection new.! 
month
    "Answer the current month"

    monthField value: ((monthField value max: 1) min: 12).
    ^monthField value!   
event: theEvent
    "Private"

    theEvent == #valueChanged
        ifTrue: [^self triggerEvents].
    ^super event: theEvent!  
increment
    "Private"

    | newValue |
    newValue := value.
    choices notNil
        ifTrue:
            [newValue := newValue + 1.
            newValue > choices size
                ifTrue:
                    [newValue := 1.
                    ].
            ]
        ifFalse:
            [(max isNil or: [newValue < max])
                ifTrue:
                    [newValue := newValue + 1.
                    ].
            ].
    self value: newValue!  
characterInput: aChar
    "Private"

    aChar ~= Cr
        ifTrue:
            [currentField characterInput: aChar.
            self contents.
            self triggerEvents
            ].

    aChar = Bs
        ifTrue:
            [currentField backspace.
            self contents.
			self triggerEvents.
            ].!  
isStatic
    "Private"

    ^inputState == #static.!   
button1Down: point
    "Private"

    | rect |
    self disabled
        ifTrue: [^self].
    (self subpaneButton1Down: point)
        ifFalse: [^self].
    fields
        do:
            [:f |
            f isStatic not & (f rect containsPoint: point)
                ifTrue:
                    [(f == currentField)
                        ifFalse:
                            [currentField losingFocus.
                            ].
                    currentField := f.
                    ].
            ].
    self hasFocus & (currentField inputState == #focus) not
        ifTrue:
            [currentField gettingFocus.
            ].
    self setFocus.
    self
        doGraphics:
            [((rect := self decrementRect) containsPoint: point)
                ifTrue:
                    [self pen reverse: (self decrementRect insetBy: 1).
                    self buttonPushedInRect: self decrementRect method: #decrement.
                    self pen reverse: (self decrementRect insetBy: 1)].
            ((rect := self incrementRect) containsPoint: point)
                ifTrue:
                    [self pen reverse: (self incrementRect insetBy: 1).
                    self buttonPushedInRect: self incrementRect method: #increment.
                    self pen reverse: (self incrementRect insetBy: 1).
                    ]].
    self whileMouseStillDown: [].! 
supportedEvents
    "Private - Answer the events supported by this subpane."

    ^super
        supportedEvents add: #valueChanged;
        yourself!   
century: aBoolean
    "Show the century or not"

    yearField
        width:
            (aBoolean
            ifTrue: [4]
            ifFalse: [2]).!
losingFocus
    "Private"

    self inputState: #normal.
    self display.!   
gettingFocus
    "Private"

    self disabled
        ifTrue: [^self].
    currentField gettingFocus.
    super gettingFocus.!  
displayAt: offset
with: pen
clipRect: cRect
    "Private"

    | startX v displayRect fore back region clip |
    (rect isNil or: [pen isNil])
        ifTrue: [^self].
    displayRect := (rect translateBy: offset) insetBy: (1 @ 0).
    startX := displayRect left.
    v := self valueString.
    justification isNil | (justification == #left)
        ifFalse:
            [justification == #right
                ifTrue:
                    [startX := displayRect right - (parent font stringExtent: v) x.
                    ]
                ifFalse:
                    [startX := displayRect center x - ((parent font stringExtent: v) x // 2).
                    ]].
    inputState == #focus
        ifTrue:
            [fore := parent backColor ifNil: [ Color windowBackground ].
            back := parent foreColor ifNil: [ Color windowText ].
            ]
        ifFalse:
            [back := parent backColor.
            fore := parent foreColor.
            ].
    clip := ((parent fieldRect translateBy: offset) expandBy: (1 @ 2)).
    cRect isNil
        ifFalse:
            [clip := cRect intersect: clip.
            ].
    region := pen setClipRect: clip.
    displayRect := displayRect leftTop - (1 @ 2) rightBottom: displayRect rightBottom + 1.
    pen
        foreColor: fore;
        backColor: back;
        fill: displayRect color: back;
        setTextAlign: TaTop;
        setBackMode: Transparent;
        displayText: v at: startX @ displayRect top.
    pen destroyRegion: region.!   
min

    ^currentField min! 
centered
    "Use center justification"

    currentField justification: #center!  
max: anInteger
    "Private"

    max := anInteger!
decrementHour
    "Private"

    format == #hour24
        ifTrue:
            [(self hour = 1)
                ifTrue: [^hourField value: 24].
            hourField decrement.
            ]
        ifFalse:
            [(self hour = 1)
                ifTrue: [^hourField value: 12].
            (self hour = 12)
                ifTrue:
                    [hourField value: 11.
                    meridianField decrement.
                    ]
                ifFalse:
                    [hourField decrement].
            ].! 
initialize
    "Private"

    super initialize.
    dayField := SpinField
        new parent: self;
        width: 2;
        justification: #right;
        showLeadingZeros: true;
        value: 1.
    monthField := SpinField
        new parent: self;
        width: 2;
        showLeadingZeros: true;
        justification: #right;
        value: 1.
    yearField := SpinField
        new parent: self;
        width: 2;
        min: 0;
        justification: #right;
        value: 1.
    separator := '/'.
    self format: #mdy.
    self monthAsNumber.
    self contents: Date today.! 
monthAsNumber
    "Set the month style to be numeric"

    self propertyAt: #cpStyle put: #monthAsNumber.
    monthField
        justification: #right;
        choices: nil;
        width: 2.!   
dragTargetFormatsDefault
        "Private - answer the formats of drag objects that the receiver will accept."
    ^#( 'time' )!
selectedItem
    "Answer the selected item"

    currentField choices isEmpty
        ifTrue: [^nil].
    ^currentField choices at: currentField value!  
initialize
    "Private"

    super initialize.
    hourField := SpinField
        new parent: self;
        width: 2;
        justification: #right;
        value: 1.
    minuteField := SpinField
        new parent: self;
        width: 2;
        showLeadingZeros: true;
        justification: #right;
        value: 1.
    meridianField := SpinField
        new parent: self;
        width: 2;
        choices: #('AM' 'PM');
        justification: #center.
    separator := ':'.
    fields := OrderedCollection
        new add: hourField;
        add:
            (SpinField
            new parent: self;
            value: separator;
            justification: #center);
        add: minuteField;
        add:
            (SpinField
            new parent: self;
            value: ' ');
        add: meridianField;
        yourself.
    currentField := hourField.
    format := #hour12.
    self contents: Time now.!
day
    "Answer the current day"

    dayField value: (1 max: (dayField value min: self lastDayInMonth)).
    ^dayField value.!   
selection
    "Answer the index of the selected item"

    ^currentField value!
parent: aCPSpinEditor
    "Private"

    parent := aCPSpinEditor!  
addFields: aSymbol
    "Private"

    | editFields |
    aSymbol == #dmy
        ifTrue:
            [editFields := Array
                    with: dayField
                    with: monthField
                    with: yearField.
            ]
        ifFalse:
            [aSymbol == #mdy
                ifTrue:
                    [editFields := Array
                            with: monthField
                            with: dayField
                            with: yearField.
                    ]
                ifFalse:
                    [editFields := Array
                            with: yearField
                            with: monthField
                            with: dayField.
                    ].
            ].
    fields := OrderedCollection
        new add: (editFields at: 1);
        add:
            (SpinField
            new parent: self;
            value: separator);
        add: (editFields at: 2);
        add:
            (SpinField
            new parent: self;
            value: separator);
        add: (editFields at: 3);
        yourself.
    currentField := fields first.!  
decrementRect
    "Private"

    | extent |
    extent := self extent.
    ^(extent x - self buttonWidth) @ (extent y // 2 - 1) corner: extent!  
min
    "Private"

    ^min!   
triggerEvents
    "Private"

    self event: #valueChanged. " OBSOLETE "
    self triggerEvent: #valueChanged: with: self contents!   
format: aSymbol
    "Set the format of the field. Valid values are #hour12 and #hour24"

    format := aSymbol.
    format == #hour24
        ifTrue:
            [fields remove: meridianField ifAbsent: [nil].
            ]
        ifFalse:
            [(fields includes: meridianField)
                ifFalse:
                    [fields add: meridianField.
                    ].
            ].
    self isHandleOk
        ifTrue:
            [self reframe.
            self invalidateRect: nil.
            ].!   
monthLeadingZero: aBoolean
    "Show the leading zero on a month or not"

    monthField showLeadingZeros: aBoolean!   
isCompatible: anObject
    "Is <anObject> compatible with the receiver"

	#obsoleteMethod.
    ^anObject respondsTo: #asInteger!  
rect
    "Private"

    ^rect! 
increment
    "Set the selection to the previous item in the list"

    ^super decrement!  
pmString
    "Private"

    ^meridianField choices last!   
supportedEvents
    "Private - Answer the events supported by this subpane."

    ^super
        supportedEvents remove: #valueChanged;
        add: #select;
        yourself! 
decrementDay
    "Private"

    (dayField value = 1)
        ifTrue:
            [self decrementMonth.
            dayField value: self lastDayInMonth.
            ]
        ifFalse:
            [dayField decrement.
            ].! 
buttonPushedInRect: inRect
method: methodToSend
    "Private"

    | startTime doneOne |
    startTime := Time millisecondClockValue.
    doneOne := false.
    self
        whileMouseStillDownPrim:
            [(doneOne not | (Time millisecondClockValue > (startTime + 300))) & (inRect containsPoint: self mouseLocation)
                ifTrue:
                    [self
						perform: methodToSend;
						clearMouseCapture;
						triggerEvents;
						captureMouseInput.
				Smalltalk platformIsOS2 ifTrue: [ self redraw ].
                    doneOne := true.
                    ].
            ].!
incrementDay
    "Private"

    (dayField value = self lastDayInMonth)
        ifTrue:
            [dayField value: 1.
            self incrementMonth.
            ]
        ifFalse:
            [dayField increment.
            ].! 
format: aSymbol
    "Set the format of the control. Valid values are #ymd and #dmy"

    format := aSymbol asLowerCase asSymbol.
    self addFields: format.
    self isHandleOk
        ifTrue:
            [self reframe.
            self invalidateRect: nil.
            ].!
monthLeadingZero
	"Answer a boolean - whether leading zeros are showed for months."

    ^monthField showLeadingZeros! 
incrementMonth
    "Private"

    (monthField value = 12)
        ifTrue:
            [monthField value: 1.
            self incrementYear.
            ]
        ifFalse:
            [monthField increment].!  
shiftRight
    "Private"

    | field |
    (currentField == fields last) | ((fields
        select:
            [:field |
            field isStatic not]) size <= 1)
        ifTrue: [^self].
    field := currentField.
    [field := fields after: field.
        (field isStatic not) | (field == fields last)]
        whileFalse: [].
    field == currentField
        ifFalse:
            [currentField losingFocus.
            currentField := field.
            currentField gettingFocus.
            ].!
value: anInteger
    "Set the contents of the reciever"

    self contents: anInteger! 
monthAsAbbrev
    "Set the month style to be text abbreviation"

    self propertyAt: #cpStyle put: #monthAsAbbrev.
    monthField
        justification: #center;
        choices: #('JAN' 'FEB' 'MAR' 'APR' 'MAY' 'JUN' 'JUL' 'AUG' 'SEP' 'OCT' 'NOV' 'DEC');
        width: 3!  
isCompatible: anObject
    "Is <anObject> compatible with the receiver"

	#obsoleteMethod.
    ^anObject isString!
separator

    ^separator!  
justification
    "Private"

    ^justification!   
contents: listOfStrings
    "Set the contents of the reciever"

    currentField choices: listOfStrings!   
decrement
    "Decrement the reciever"

    currentField decrement.!   
increment
    "Private"

    (currentField == hourField)
        ifTrue:
            [self incrementHour]
        ifFalse:
            [(currentField == minuteField)
                ifTrue:
                    [self incrementMinute]
                ifFalse:
                    [meridianField increment.
                    ].
            ].
    self contents!
dragTargetFormatsDefault
        "Private - answer the formats of drag objects that the receiver will accept."
    ^#( 'date' )!
amString: a
pmString: p
    "Set the AM and PM designation strings"

    meridianField
        choices: (Array with: a with: p);
        width: (a size max: p size).!  
valueChanged
    "Private"

    self triggerEvents!
decrementMonth
    "Private"

    (monthField value = 1)
        ifTrue:
            [monthField value: 12.
            self decrementYear.
            ]
        ifFalse:
            [monthField decrement].!  
value
    "Private"

    ^value!   
contents: anObject
    "Set the contents of the reciever"

    | newValue |
    [ newValue := anObject asInteger ] on: Error do: [ ^self ].
    ^super contents: newValue!   
contents
    "Answer the selected time"

    | hours |
    hours := self hour.
    format == #hour24
        ifTrue:
            [hours = 24
                ifTrue:
                    [hours := 0.
                    ].
            ]
        ifFalse:
            [(meridianField value = 2)
                ifTrue:
                    [hours < 12
                        ifTrue:
                            [hours := hours + 12.
                            ].
                    ]
                ifFalse:
                    [hours = 12
                        ifTrue: [hours := 0].
                    ].
            ].
    ^Time
            hours: hours
            minutes: self minute
            seconds: 0.!   
showLeadingZeros: aBoolean
    "Private"

    showLeadingZeros := aBoolean!
inEdit
    "Private"

    ^inputState == #editing! 
dayLeadingZero
	"Answer a boolean - whether leading zeros are showed for days."

    ^dayField showLeadingZeros!   
decrementMinute
    "Private"

    (minuteField value = 0)
        ifTrue:
            [minuteField value: 59.
            self decrementHour.
            ]
        ifFalse:
            [minuteField decrement].!  
modified
    "This entire subclass was created to get around the
      automatic 'Save changes?' dialog that pops up when
      you attempt to close a window containing a modified
      EntryField.  You cannot use #clearTextModified, as that
      is only sent to TextEdit/TextPanes, NOT EntryFields."

    ^false! 
incrementRect
    "Private"

    | extent |
    extent := self extent.
    ^(extent x - self buttonWidth) @ 0 corner: extent x @ (extent y // 2 + 1)!
increment
    "Private"

    (currentField == dayField)
        ifTrue:
            [self incrementDay]
        ifFalse:
            [(currentField == monthField)
                ifTrue:
                    [self incrementMonth.
                    ]
                ifFalse:
                    [self incrementYear.
                    ].
            ].
    self contents.! 
width: anInteger
    "Private"

    width := anInteger!
cpStyle
    "Private"

    | styleDict |
    styleDict := Dictionary new.
    styleDict
        at: #left put: #leftJustified;
        at: #right put: #rightJustified;
        at: #center put: #centered.
    ^styleDict at: currentField justification!   
justification: aSymbol
    "Private"

    currentField justification: aSymbol! 
setContents: aString

    "Prevent the textChanged message from
     happening when the contents is set and
     fix the case"

    self contents = aString ifTrue: [ ^self ].
    super contents: aString.
	self removeTextChangedEvent.!
value
    "Answer the contents of the reciever"

    ^self contents!   
triggerEvents
    "Private"

    self event: #select. " OBSOLETE "
    self triggerEvent: #select: with: self selectedItem!