05/04/95 02:13:53 PM

dragTargetFormats
        "Private - answer the formats of drag objects that the receiver will accept."
    ^super dragTargetFormats ifNil: [ self dragTargetFormatsDefault ].! 
darkerColor
    "Private"

    ^Color black!   
triggerClickedEvent

    self event: #clicked. " OBSOLETE "
    self triggerEvent: #clicked: with: self selection.!
isCompatibleDragObject: aDragObject
    "Private - Is <aDragObject> compatible with the receiver"

	(self dragTargetFormats ifNil: [ ^false ])
		do: [ :each |
			(aDragObject hasFormat: each) ifTrue: [ ^true ] ].
	^false!   
getDefaultDragObjects
    "Private"

    | dragObjects |
    #obsoleteMethod.
    (dragObjects := self propertyAt: #defaultDragObjects) isNil
        ifTrue: [^nil].
    self renderAsObjects
        ifFalse:
            [dragObjects := dragObjects
                collect:
                    [:each |
                    each asString]].
    ^dragObjects! 
defaultDroppedOn: aDragDropList
    "Accept the drag and drop. This is the default handler for
      the #dragDropped: event."

    #obsoleteMethod.
    aDragDropList items notEmpty
        ifTrue:
            [self
                contents:
                    (aDragDropList items
                    detect:
                        [:item |
                        self isCompatible: item]
                    ifNone: [^nil])]!   
updateRectangle
    "Private"

    | aRect |
    super updateRectangle.
    aRect := self rectangle.
    (aRect height = 0) | (aRect width = 0)
        ifFalse:
            [self reframe.
            ].!  
enable
    "Since Digitalk doesn't save the state of whether we're
      disabled before we're built, the test above could have failed, yielding
      no way to enable a cp subpane"
    "Added test to avoid blinkiness."

    self disabled
        ifFalse: [^self].
    self propertyAt: #disabled put: nil.
    self foreColor: (self propertyAt: #holdForeColor).
    super enable.
    self invalidateRect: nil.!  
disabled
    "Since Digitalk doesn't save the state of whether we're
      disabled before we're built, the test above could have failed, yielding
      no way to enable a cp subpane"

    ^(self propertyAt: #disabled) notNil!   
Bitmap fromSPSysModuleID: 105!
whileMouseStillDownDo: aBlock
    "Private - Evaluate aBlock while the mouse button is down.
        aBlock must take exactly one argument: the mouse location."

    | mouseUp |

    Notifier isButton1Down not & Notifier isButton2Down not ifTrue: [
        [ (CurrentEvents
            detect: [ :e |
                (e receiver == self) and: [
                    (e selector = #button1Up:) | (e selector = #button2Up:) ] ]
            ifNone: [ nil ]) isNil
        ] evaluateWithoutInterrupts ifTrue: [ ^self ] ].

    self captureMouseInput.
    UserLibrary
            setTimer: self handle
            idEvent: nil
            elapsedTime: 50
            timerFunc: nil.

    mouseUp := false.
    Notifier
        consumeInputUntil:
            [:event |
                 (event selector = #button1Up:) | (event selector = #button2Up:)
                    ifTrue: [
                        aBlock value: event arguments first.
                        mouseUp := true ]
                    ifFalse: [
                        (event selector = #button1Move:) | (event selector = #button2Move:)
                            ifTrue: [
                                aBlock value: event arguments first.
                                mouseUp := false ]
                            ifFalse: [
									"event receiver
                                	perform: event selector
										withArguments: event arguments" ] ].
            mouseUp and: [
                Notifier isButton1Down not & Notifier isButton2Down not ] ].
    UserLibrary killTimer: self handle idEvent: nil.
    self clearMouseCapture.!   
dragTargetFormatsDefault
        "Private - answer the formats of drag objects that the receiver will accept."
    ^#( 'string' )!  
button2Up: aPoint
        "Private - signal the right clicked event."
		"Parts expect to see rightClicked events."

    self triggerEvent: #rightClicked
        ifNotHandled: [ super button2Up: aPoint ].
    self clearMouseCapture.!
displayWith: aPen
inRect: inRect
clipRect: cr
    "Private"

    self displayWith: aPen inRect: inRect!  
mouseLocation
    "Private"

    ^Cursor offset mapToWindow: self.!
rightButtonScroll: point
        "Private - Do right button scrolling."! 
defaultBackColor
    "Private"

    ^Color gray!   
defaultForeColor
    "Private"

    ^Color windowBorder!   
wmLbuttondown: wParam
with: longInteger
    "Private - Process left button down message."

    self disabled
        ifTrue: [^nil].
    self setFocus.
    ^super wmLbuttondown: wParam with: longInteger!
finalizeMoveOperation: dragDrop
    "Private - Do Nothing"

    #obsoleteMethod.!  
Bitmap fromSPSysModuleID: 101!
spSysModuleName
        "Answer the subpane system bitmap module name."
    ^'sp22sysw.dll'
!  
middleColor
    "Private"

    ^Color paleGray!
windowClass
    "Private - Answer the window class of CPSubPane."

    | className wndClass address answer |
    className := 'CPSub'.
    wndClass := WinWindowClass new.
    answer := UserLibrary
            getClassInfo: OperatingSystem hInstanceExe
            className: className asParameter
            wndClass: wndClass asParameter.
    answer
        ifTrue: [^className].
    UserLibrary
            getClassInfo: OperatingSystem hInstanceExe
            className: Window windowClass asParameter
            wndClass: wndClass asParameter.
    address := ExternalAddress copyToNonSmalltalkMemoryZ: className.
    wndClass
        style: CsDblclks | CsVredraw | CsHredraw;
        className: address asParameter;
        hIcon: 0;
        hBrush: 0.
    (UserLibrary registerClass: wndClass asParameter) = 0
        ifTrue: [^self osError].
    address free.
    ^className! 
Bitmap fromSPSysModuleID: 108!
dragSourceCutDefault: dragSession
		"Private - perform default cut action if no handler is provided."
		"Ignored by default..."!
dragTargetOperationForSelf: dragSession
		"Answer the operation when source = target = self."
	^nil!
defaultStyle
    "Private - Answer an Integer with appropriate styles in it."

    ^WsChild | WsVisible!   
losingFocus
    "Private"

    self triggerLosingFocus!
wmGetdlgcode: wparam
with: lparam
    "Private - process WM_GETDLGCODE message."

    ^DlgcWantarrows | DlgcWantchars!
isCompatible: anObject
    "Is <anObject> compatible with the receiver"

	#obsoleteMethod.
    ^false!
font
    "Private"

    ^super font ifNil: [ self defaultFont ]!   
lighterColor
    "Private"

    ^Color white!  
supportsDragDropObjects
    "Does the receiver support receiving full
     objects in a drag/drop transfer"

    #obsoleteMethod.
    ^true! 
fromSPSysModuleID: anInteger
		"Answer a new instance loaded from the subpanes system bitmap module."
	^self fromModule: self spSysModuleName id: anInteger!
Bitmap fromSPSysModuleID: 106!
displayWith: aPen
inRect: aRect
    "Private"

    aPen
        rectangle: aRect;
        place: aRect center;
        centerText: self class name.!   
cursorWindowPosition
    "Private - Answer the current position of the cursor
         in window coordinates."

    ^CursorManager new sense mapScreenToClient: self.!
inWindowBuilder
    "Private"

    ^rectangle leftTop ~= (0 @ 0)!  
defaultDragDropObjects
    "Answer the list of items that should be
     passed during drag-drop"

    | dragObjects |
    #obsoleteMethod.
    (dragObjects := self getDefaultDragObjects) notNil
        ifTrue: [^dragObjects].
    self contents isNil
        ifTrue: [^nil].
    dragObjects := Array with: self contents.
    self renderAsObjects
        ifFalse:
            [dragObjects := dragObjects
                collect:
                    [:each |
                    each asString]].
    ^dragObjects!  
foreColor: aColor
	"Set the forecolor and force a repaint."

	super foreColor: aColor.
	self redraw.! 
dragSourceNeedsObjectDefault: dragSession
        "Private - provide default for requested drag items if no handler
        is provided by supplying the currently selected item."
    | obj dragDropObject data |
	(obj := self contents) ifNil: [ ^self ].
	dragDropObject := dragSession objectClass new
		object: obj;
		string: obj asString;
		yourself.

	data := [ obj asDate ] on: Error do: [ nil ].
	data notNil ifTrue: [ dragDropObject format: 'date' data: data ].
	data := [ obj asTime ] on: Error do: [ nil ].
	data notNil ifTrue: [ dragDropObject format: 'time' data: data ].
	data := [ obj asInteger ] on: Error do: [ nil ].
	data notNil ifTrue: [
		(data = 0 and: [
			obj isString and: [
				(obj trimBlanks beginsWith: '0') not ] ]
		) ifFalse: [
			dragDropObject format: 'integer' data: data ] ].

    dragSession objects: ( Array with: dragDropObject ).!   
disable

    self disabled
        ifTrue: [^self].
    "Since Digitalk doesn't save the state of whether we're
      disabled before we're built, the test above could have failed, yielding
      no way to enable a cp subpane"
    self propertyAt: #disabled put: true.
    self propertyAt: #holdForeColor put: self foreColor.
    self foreColor: Color darkGray.
    super disable.
    self isHandleOk
        ifTrue: [self invalidateRect: nil].! 
triggerNeedsContentsEvent

    self event: #getContents. " OBSOLETE "
    self triggerEvent: #needsContents.!  
backColor: aColor
	"Set the backcolor and force a repaint."

	super backColor: aColor.
	self redraw.! 
currentClipRect
    "Private"

    | clipbox |
    clipbox := WinRectangle new.
    self doGraphics: [
        (GDILibrary getClipBox: self pen handle rectangle: clipbox asParameter) ].
    clipbox := clipbox asRectangle.
    ^clipbox!   
constructEventsTriggered
    "Private - answer the set of events that instances of the
     receiver can trigger."

    ^super
        constructEventsTriggered addAll: #(rightClicked);
        yourself!  
defaultFont
    "Private"

    ^SysFont!   
supportedEvents
    "Private"

    ^Set with: #getContents with: #getPopupMenu!
Bitmap fromSPSysModuleID: 102!
whileMouseStillDown: aBlock
    "Private"

    self isDragSource
        ifTrue:
            [aBlock value.
            self
                whileMouseStillDownPrim:
                    [(self dragOnMove and: [ self isDragSourceInitiation: self cursorWindowPosition ])
                        ifTrue:
                            [self dragOnMove: nil location: nil.
					        self doDragDropAt: self cursorWindowPosition]].
            ]
        ifFalse:
            [self whileMouseStillDownPrim: aBlock].!  
renderAsObjects
    "Private - should the receiver deliver objects in a drag & drop
     transfer or the string representations of the objects"

    #obsoleteMethod.
    ^(self propertyAt: #renderAsObjects) ~~ nil!   
keyboardInput: aKeyboardInputEvent
        "Private - keyboard input was received.  Process cursor keys."
    | virtualKey |
    ( virtualKey := aKeyboardInputEvent virtualKey ) notNil ifTrue: [
        ( virtualKey == UpKey or: [ virtualKey == LeftKey ] )
            ifTrue: [ ^( self tabScope previousInGroup: self ) setFocus ].
        ( virtualKey == DownKey  or: [ virtualKey == RightKey ] )
            ifTrue: [ ^( self tabScope nextInGroup: self ) setFocus ].
        ( virtualKey == TabKey or: [ virtualKey == BacktabKey ] )
            ifTrue: [ ^self tabKeyInput: aKeyboardInputEvent ] ].
    ^super keyboardInput: aKeyboardInputEvent! 
cpStyle
    "Private"

    ^self propertyAt: #cpStyle! 
subpaneButton1Down: aPoint
    "Private"

    ^(super button1Down: aPoint) ~= false!   
contents
    "Private"

    ^nil!  
rect
    "Private"

    ^0 @ 0 extent: self extent!
whileMouseStillDownPrim: aBlock
    "Private"

    self captureMouseInput.
    UserLibrary
            setTimer: self handle
            idEvent: nil
            elapsedTime: 50
            timerFunc: nil.
    Notifier
        consumeInputUntil:
            [:event |
            aBlock value.
            (Notifier isKeyDown: VkLbutton) not & (Notifier isKeyDown: VkRbutton) not.
            ].
    UserLibrary killTimer: self handle idEvent: nil.
    self clearMouseCapture.! 
drawFocusRect: aRect
    "Private"

    self pen notNil
        ifTrue:
            [self
                doGraphics:
                    [self
                        pen foreColor: Color black;
                        drawFocusRect: aRect].
            ].!  
scrollTopCorner: aPoint
    "Private - Ignored by default."! 
reframeIfNeeded: aRect
    "Private"

    rectangle = aRect
        ifFalse:
            [rectangle := aRect.
            self reframe.
            ].
    rectangle := aRect.!   
dragTargetDropDefault: dragSession
        "Private - provide default handling of drop if no handler
        is provided by inserting the item into the list."
	| formats |
	formats := self dragTargetFormats.
	dragSession objects do: [ :each |
		formats do: [ :eachFormat |
			(each hasFormat: eachFormat) ifTrue: [
				self contents: (each format: eachFormat).
				^self redraw ] ] ].
	^nil! 
Bitmap fromSPSysModuleID: 103!
setDefaultDragObjects: aCollection
    "Set the default drag & drop objects for the receiver"

    #obsoleteMethod.
    self propertyAt: #defaultDragObjects put: aCollection!
basicRightButtonScroll: point
        "Private - Do right button scrolling."
	^super rightButtonScroll: point!  
reframe
    "Private"!   
display
    "Private"

    self
        doGraphics:
            [self
                    displayWith: self pen
                    inRect: self rect
                    clipRect: self rect].!  
contents: ignore
    "Private"!  
Bitmap fromSPSysModuleID: 104!
Bitmap fromSPSysModuleID: 107!
dragTargetOperationsDefault
        "Private - answer the operations that the receiver can accept."
	^#( copy )!
wmTimer: wordInteger
with: longInteger
    "Private - Process the timer message."

    self sendMouseMoveInputEvent: #button1Move: with: self cursorWindowPosition.
    ^nil!
gettingFocus
    "Private - The receiver is getting the input focus."

    self subPaneWithFocus: self.
    self triggerGettingFocus! 
wmErasebkgnd: wordInteger
with: longInteger
    "Private"

    ^1!
dragTargetOperationFor: dragSession
        "Private - answer the operation that the reciever would perform
        for the current drag-drop transfer at the current location, or nil
        if invalid."
    | dragFormats dragOperations dragObject operation |
    self isDragTarget ifFalse: [ ^nil ].
    ( dragFormats := self dragTargetFormats ) isNil ifTrue: [ ^nil ].
    ( dragOperations := self dragTargetOperations ) isNil ifTrue: [ ^nil ].
    ( dragSession objects size > 1 and: [ self dragTargetMultipleItem not ] ) ifTrue: [ ^nil ].

	"There are some complications when
		(source == target) & (target == self)
		so don't allow it for now.
		See 'dragTargetDropDefault:' "
	#osiHack.
	dragSession source == self ifTrue: [ ^self dragTargetOperationForSelf: dragSession ].

    dragObject := dragSession objects
		detect: [ :each | self isCompatibleDragObject: each ]
		ifNone: [ ^nil ].

	operation := dragSession impliedOperation
		ifNil: [ dragSession defaultOperation ].
	(dragOperations includes: operation)
		ifFalse: [ operation := dragOperations first ].

	"If a move operation, then check to see that all objects can be
		accepted so that no objects are 'lost' when moved."
	operation = #move ifTrue: [
		dragSession objects do: [ :each |
			(self isCompatibleDragObject: each) ifFalse: [ ^nil ] ] ].
	^operation!  
deactivate
    "Private - The receiver has been deactivated."!   
initialize

	super initialize.
	self 
		backColor: self defaultBackColor;
		foreColor: self defaultForeColor.
! 
setDragDropObjects
    "Set the drag & drop objects. This is the default handler for
      the #needsDragDropObjects event."

    #obsoleteMethod.
    self setDragDropObjects: self defaultDragDropObjects! 
rectanglePrivate: aRect
    "Private"

    rectangle := aRect.!
updateSliders
    "Private"!