05/04/95 02:03:20 PM

dragTargetDropDefault: dragSession
        "Private - provide default handling of drop if no handler
        is provided by inserting the item into the list."
	super dragTargetDropDefault: dragSession.
	(self dragTargetFormats includes: 'bitmap') ifTrue: [
		dragSession objects do: [ :each |
			each hasBitmap ifTrue: [
				self bitmap: each bitmap.
				^self ] ] ].
	^nil!   
isPushButton
        "Answer whether the receiver is an instance of a push button"
    ^true
! 
displayPicture: pen
inRect: inRect
    "Private"

    picture isNil
        ifTrue: [^self].
    value
        ifTrue:
            [onPicture displayAt: inRect left @ (self height - onPicture height // 2 + inRect top) with: pen.
            ]
        ifFalse:
            [picture displayAt: inRect left @ (self height - picture height // 2 + inRect top) with: pen.
            ].! 
mnemonic: char typedIn: aPane
        "The receiver's mnemonic was typed in the
		sibling <aPane>.  Perform a programmatic button click."
	pressed ifFalse: [
		self sendInputEvent: #press.
		aPane givesUpFocusWithMnemonic
			ifTrue: [ self setFocus ]
			ifFalse: [ self sendInputEvent: #releaseButton ] ].! 
receiveAllWindowMessages
    "Private - Do Nothing"! 
selection: aBoolean
    "Set the selection of the reciever"

    value = aBoolean
        ifTrue: [^self].
    value := aBoolean.
    self isHandleOk & self pen notNil
        ifFalse: [^self].
    self hasFocus
        ifTrue:
            [self display.
            ]
        ifFalse:
            [self doGraphics: [self display].
            ].! 
highlight
    "Private"

    | holdPicture region |
    self doGraphics: 
        [self pen
            draw3DRect: self rectToHighlight
            depth: 2
            style: #in.
        ].
    onPicture isNil
        ifFalse:
            [holdPicture := picture.
            picture := onPicture.
            self
                invalidateRect: (self rect insetBy: 3);
                updateWindow.
            picture := holdPicture.
            ].! 
defaultDroppedOn: aDragDropList
    "Accept the drag and drop."

    #obsoleteMethod.
    aDragDropList items notEmpty
        ifTrue:
            [aDragDropList items
                do:
                    [:item |
                    item isBitmap
                        ifTrue: [self bitmap: item]
                        ifFalse: [
                            (self isCompatible: item)
                                ifTrue: [self contents: item]]].
            self display]! 
bitmap
	 "Answer the 'off' button bitmap."

    ^picture!  
onBitmap: aBitmap
    "Set the bitmap displayed in the reciever
     when the button is pressed"

    onPicture := aBitmap.!  
drawFocusRectColor: ignore
    "Private"

    | aRect titleExtent space pictureHeight |
    title isNil
        ifTrue:
            [picture isNil
                ifTrue:
                    [aRect := self rect insetBy: 6.
                    ]
                ifFalse:
                    [aRect := (self extent - picture extent) // 2 + self rect leftTop extent: picture extent.
                    ].
            ]
        ifFalse:
            [titleExtent := self font stringExtent: title.
            picture isNil
                ifTrue:
                    [pictureHeight := space := 0.
                    ]
                ifFalse:
                    [pictureHeight := picture height.
                    space := self space.
                    ].
            aRect := ((self width - titleExtent x // 2) @ ((self height - (pictureHeight + space + titleExtent y) // 2) + pictureHeight + space)) + self rect leftTop extent: titleExtent.
            ].
    self drawFocusRect: (aRect expandBy: 1).!   
contents: anObject
    "Set the label of the reciever"

	"Ignore bitmaps sent by CPSubPane>>dragTargetDropDefault:"
	anObject isBitmap ifTrue: [ ^self ].

    [ title := anObject asString ] on: Error do: [ ^self ].
    title = '' ifTrue: [ title := nil ].!   
defaultFont
    "Private - Answer the default font for the control."

    ^ButtonFont! 
supportedEvents
    "Private"

    ^super
        supportedEvents add: #clicked;
        yourself!   
keyboardInput: aKeyboardInputEvent
        "Private - keyboard input was received."
    ( aKeyboardInputEvent character == Cr
        and: [ self isPushButton
        and: [ self mainWindow isDialogTopPane not ]] )
        ifTrue: [ ^self "handled by keyDownInput: and keyUpInput:" ].
    ^super keyboardInput: aKeyboardInputEvent! 
initialize
    "Private"

    super initialize.
    value := false.!  
wmGetdlgcode: wParam
with: lParam
    "Private"

    ^DlgcButton! 
pictureWidth
    "Private"

    picture notNil
        ifTrue: [^picture width].
    ^0! 
drawFocusRect
    "Private"

    self drawFocusRectColor: Color darkGray.! 
selection: aBoolean
    "Set the selection on or off"

    value = aBoolean
        ifTrue: [^self].
    value := aBoolean.
    self isHandleOk & self pen notNil
        ifFalse: [^self].
    self
        doGraphics:
            [self displayPicture: self pen inRect: self rect.
            ].! 
displayWith: pen
inRect: inRect
clipRect: cRect
    "Private"

    | startY titleExtent space rect region |
    rect := self rect translateBy: inRect leftTop.
    pen
        foreColor: self foreColor;
        drawRectangle: rect;
        draw3DRect: rect
            depth: 2
            style: #out;
        fill: (rect insetBy: 3) color: self backColor;
        foreColor: self foreColor;
        backColor: self backColor.
    region := pen setClipRect: ((rect insetBy: 3) intersect: cRect).
    title isNil
        ifTrue:
            [picture isNil
                ifFalse:
                    [picture displayAt: (self extent - picture extent) // 2 + rect leftTop with: pen.
                    ].
            ]
        ifFalse:
            [titleExtent := self font stringExtent: title.
            titleExtent x: (self font wbStringWidth: title).
            pen setTextAlign: TaTop.
            picture isNil
                ifTrue:
                    [self
                            drawTitle: title
                            at: (self extent - titleExtent) // 2 + rect leftTop
                            with: pen]
                ifFalse:
                    [space := self space.
                    startY := (((self height - (picture height + space + titleExtent y)) // 2) max: 2) + rect top.
                    self
                            drawTitle: title
                            at: (self width - titleExtent x // 2 + rect left) @ (startY + picture height + space)
                            with: pen.
                    picture displayAt: (self width - picture width // 2 + rect left) @ startY with: pen.
                    ].
            ].
    self hasFocus & self pen notNil
        ifTrue:
            [self drawFocusRect.
            ].
    pen destroyRegion: region.!  
button1DoubleClick: point
    "Private"

    self button1Down: point.! 
drawTitle: aString
at: aPoint
with: pen
    "Private"

    pen
        font: self font;
        winDrawText: aString at: aPoint.!  
defaultDragDropObjects
    "Answer the list of items that should be
     passed during drag-drop"

    | dragObjects |
    #obsoleteMethod.
    (dragObjects := self getDefaultDragObjects) notNil
        ifTrue: [^dragObjects].
    dragObjects := Array with: self contents with: self bitmap.
    self renderAsObjects
        ifFalse:
            [dragObjects := dragObjects
                collect:
                    [:each |
                    each asString]].
    ^dragObjects!  
focusRect
	"Private - Answer the focus rectangle. 
	(Stolen from CPHorizontalPictureButton>>drawFocusRectColor:)"

	| stringOrigin |
	stringOrigin := (self rect left + self pictureWidth + self space) @ (self rect bottom + (self height - self font height // 2)).
	^(Rectangle leftBottom: stringOrigin extent: (self font stringExtent: title)) expandBy: (2 @ 1)! 
initialize
    "Private"

    pressed := false.
    super initialize.!
drawFocusRect
    "Private"

    | holdPicture |
    holdPicture := picture.
    onPicture notNil & value
        ifTrue:
            [picture := onPicture.
            ].
    super drawFocusRect.
    picture := holdPicture.!   
initialize
		"Private - Initialize the receiver"
	super initialize.
	highlighted := false.
	picture := CPCheckBoxSysBitmap.
	onPicture := CPCheckBoxOnSysBitmap.!
releaseButton
    "Private"

    value := value not.
    self display.
    super releaseButton.! 
displayWith: pen
inRect: inRect
clipRect: clipRect
    "Private"

    | holdPicture |
    onPicture notNil
        ifTrue:
            [holdPicture := picture.
            value
                ifTrue:
                    [picture := onPicture.
                    ].
            super
                    displayWith: pen
                    inRect: inRect
                    clipRect: clipRect.
            picture := holdPicture.
            ]
        ifFalse:
            [super
                    displayWith: pen
                    inRect: inRect
                    clipRect: clipRect.
            value
                ifTrue:
                    [pen reverse: ((self rect translateBy: inRect leftTop) insetBy: 3).
                    ].
            ].!  
highlight
    "Private"

    | buttonRect |
    highlighted
        ifFalse:
            [highlighted := true.
            buttonRect := (0 @ (self height - picture height // 2) extent: picture extent).
            self doGraphics: [self pen reverse: (buttonRect insetBy: 1)].
            ].! 
dragSourceNeedsObjectDefault: dragSession
        "Private - provide default for requested drag items if no handler
        is provided by supplying the currently selected item."
	self contents ifNil: [ ^self ].
	super dragSourceNeedsObjectDefault: dragSession.
	self bitmap notNil ifTrue: [
		dragSession objects first bitmap: self bitmap ].! 
unHighlight
    "Private"

    highlighted := false.
    self doGraphics: [self displayPicture: self pen inRect: self rect].! 
keyDownInput: aKeyboardInputEvent
        "Private - key down event was received."
    | ch |
    pressed ifFalse: [
        ch := aKeyboardInputEvent character.
        (ch = Cr) ifTrue: [
            self isPushButton ifFalse: [
                (self mainWindow defaultPushButton notNil
                    and: [ self mainWindow isDialogTopPane not ])
                        ifTrue: [ ^self ] ] ].
        (ch = Cr) | (ch = Space) ifTrue: [
            self press.
            ^self ] ].
    ^super keyDownInput: aKeyboardInputEvent!
isPushButton
        "Answer whether the receiver is an instance of a push button"
    ^false
!
defaultBackColor
    "Private - Answer the default background color 
         for the receiver."

    ^Color windowBackground!
bitmap: aBitmap
    "Set the bitmap displayed in the reciever"

    picture := aBitmap.!   
getMnemonicHandler: char
        "Private - Check if this control handles this mnemonic.
        Answer the receiver if it does, else nil."
    | index |
    ( title isNil or: [ self disabled ] ) ifTrue: [ ^nil ].
    ^( ( index := ( title indexOf: '\u' replaceEscapeCharacters first ) ) ~= 0
        and: [ ( title at: index + 1 ) asLowerCase == char asLowerCase ] )
        ifTrue: [ self ]
        ifFalse: [ nil ]!
selection: aBoolean
    "Set the selection of the reciever"

    super selection: aBoolean.
    aBoolean
        ifTrue:
            [self isHandleOk
                ifTrue:
                    [self turnOffSiblings.
                    ].
            ].! 
dragTargetFormatsDefault
        "Private - answer the formats of drag objects that the receiver will accept."
    ^#( 'string' )!  
constructEventsTriggered
    "Private - answer the set of events that instances of the
        receiver can trigger."

    ^super
        constructEventsTriggered remove: #clicked;
        add: #clicked:;
        yourself! 
isRadioButton
    "Private"

    ^true!
isATabStop
    "Private - Answer true if the receiver is a tabstop"

    ^self selection & super isATabStop!   
turnOffSiblings
    "Private"

    self tabGroupMembers do: [ :aPane |
        ( aPane ~= self and: [ aPane isRadioButton ] )
            ifTrue: [ aPane turnOff ] ].!  
givesUpFocusWithMnemonic
        "Answer whether the input focus can be taken away
        from the receiver when a mnemonic command is
        entered for another pane."
    ^true! 
drawFocusRect
    "Private"

    self drawFocusRectColor: Color darkGray.! 
displayWith: pen
inRect: inRect
clipRect: clipRect
    "Private"

    | stringOrigin |
    (self backColor = self defaultBackColor) & parent notNil
        ifTrue:
            [pen fill: inRect color: parent backColor.
            ]
        ifFalse:
            [pen fill: inRect color: self backColor.
            ].
    title notNil
        ifTrue:
            [stringOrigin := (inRect left + self pictureWidth + self space) @ (inRect top + (self height - self font height // 2)).
            pen
                setTextAlign: TaTop;
                foreColor: self foreColor;
                backColor: self backColor;
                setBackMode: Transparent;
                winDrawText: title at: stringOrigin.
            ].
    self displayPicture: pen inRect: inRect.
    self hasFocus
        ifTrue:
            [self drawFocusRect.
            ].!
turnOff
    "Private"

    super selection: false.!
onBitmap
	"Answer the bitmap displayed while the button is being pressed:
	 the 'on' bitmap."

    ^onPicture!
cancelPushButton
    "Set the style to a cancel button"

    self propertyAt: #cpStyle put: #cancelPushButton! 
rectToHighlight

	^self rect!   
needsKeyDownInput
		"Private - Answer true if the receiver processes key-down events."
	#addedByOSI.
	^true!   
validate
    "Private - The host window for the receiver was
     just created or recreated."

    self cpStyle == #defaultPushButton
        ifTrue: [self mainWindow defaultPushButton: self].
    self cpStyle == #cancelPushButton
        ifTrue: [self mainWindow cancelPushButton: self].
    super validate!  
isButton
    "Private"

    ^true! 
triggerEvents
    "Private"

    self event: #clicked. " OBSOLETE "
    self triggerEvent: #clicked!  
losingFocus
    "Private"

    self drawFocusRectColor: self backColor.
    super losingFocus.!   
button1Down: point
    "Private"

    | highlighted |
    (self subpaneButton1Down: point)
        ifFalse: [^self].
    self setFocus.
    self press.
    highlighted := true.
    self
        whileMouseStillDown:
            [(self rect containsPoint: self mouseLocation)
                ifTrue:
                    [highlighted
                        ifFalse:
                            [self highlight.
                            highlighted := true.
                            ]]
                ifFalse:
                    [highlighted
                        ifTrue:
                            [self unHighlight.
                            highlighted := false.
                            ]]].
    highlighted
        ifTrue: [self releaseButton].!  
contents
    "Answer the label of the reciever"

    ^title!   
highlight
    "Private"

    self doGraphics: 
        [self pen
            draw3DRect: self rectToHighlight
            depth: 2
            style: #in
        ].! 
drawFocusRectColor: ignored
    "Private"

    | stringOrigin |
    title isNil
        ifTrue:
            [self drawFocusRect: self rect.
            ]
        ifFalse:
            [stringOrigin := self rect leftTop + ((self pictureWidth + self space) @ (self height - self font height // 2)).
            self drawFocusRect: ((stringOrigin extent: (self font stringExtent: title)) expandBy: 1).
            ].!  
gettingFocus
    "Private"

    self drawFocusRect.
    super gettingFocus.!  
keyUpInput: aKeyboardInputEvent
        "Private - key up event was received."

    pressed ifTrue: [
        self releaseButton.
        ^self ].
    ^super keyUpInput: aKeyboardInputEvent!  
wmGetdlgcode: wParam
with: lParam
    "Private"

    ^DlgcRadiobutton!
validate
    "Private"

    super validate.
    self selection
        ifTrue:
            [self turnOffSiblings.
            ].!  
releaseButton
    "Private"

    pressed := false.
    self unHighlight.
    value := true.
    self turnOffSiblings.
    self
        doGraphics:
            [self displayPicture: self pen inRect: self rect.
            ].
    self triggerEvents!
unHighlight
    "Private"

    self doGraphics: 
        [self pen
            draw3DRect: self rectToHighlight
            depth: 2
            style: #out.
        ].! 
triggerEvents
    "Private"

    self event: #clicked. " OBSOLETE "
    self triggerEvent: #clicked: with: value! 
gettingFocus
    "Private"

    self selection: true.
    super gettingFocus.!
initialize
	"Private"

	super initialize.
	picture := CPRadioButtonSysBitmap.
	onPicture := CPRadioButtonOnSysBitmap.!   
dragTargetFormatsDefault
        "Private - answer the formats of drag objects that the receiver will accept."
    ^#( 'string' )!  
needsKeyUpInput
		"Private - Answer true if the receiver processes key-up events."
	#addedByOSI.
	^true!   
click
    "Private"

    self
        press;
        releaseButton.! 
constructEventsTriggered
    "Private - answer the set of events that instances of the
     receiver can trigger."

    ^super
        constructEventsTriggered addAll: #(clicked);
        yourself!   
space
    "Private"

    ^5!   
selection
    "Answer the selection of the reciever"

    ^value!  
dragTargetFormatsDefault
        "Private - answer the formats of drag objects that the receiver will accept."
    ^#( 'string' 'bitmap' )! 
wmUser99: wparam
with: lparam
    "Private"

    self
        press;
        releaseButton.
    ^nil!  
releaseButton
    "Private"

    pressed := false.
    self unHighlight.
    value := value not.
    self
        doGraphics:
            [self displayPicture: self pen inRect: self rect.
            ].
    self triggerEvents!  
isCompatible: anObject
    "Is <anObject> compatible with the receiver"

	#obsoleteMethod.
    ^anObject respondsTo: #asString!   
initialize
		"Private - Initialize the receiver."
	super initialize.
	picture := CPCheckBoxSysBitmap.
	onPicture := CPCheckBoxOnSysBitmap.!   
defaultForeColor
    "Private"

    ^Color windowText! 
unHighlight
    "Private"

    self doGraphics: 
        [self pen
            draw3DRect: self rectToHighlight
            depth: 2
            style: #out.
        ].
    onPicture isNil
        ifFalse:
            [self
                invalidateRect: (self rect insetBy: 3);
                updateWindow.
            ].!   
releaseButton
    "Private"

    pressed := false.
    self unHighlight.
    self triggerEvents! 
characterInput: aChar
    "Private"

	#osiHack.
	true ifTrue: [ ^super characterInput: aChar ].

    aChar = $ 
        ifTrue:
            [self press.
            ].! 
pushIt
    "Private"

    self
        setFocus;
        press;
        releaseButton.! 
wmGettext: wparam
with: lparam
    "Private"

    | address string struct |
    address := ExternalAddress
        new highHalf: (lparam // 65536);
        lowHalf: (lparam \\ 65536);
        yourself.
    self contents notNil
        ifTrue:
            [string := self contents copyFrom: 1 to: (wparam min: self contents size + 1) - 1.
            ]
        ifFalse:
            [string := ''].
    struct := ExternalBuffer new: wparam.
    struct contents: string asAsciiZ.
    struct copyToAddress: address.
    ^string size!   
defaultPushButton
    "Set the style to a default button"

    self propertyAt: #cpStyle put: #defaultPushButton!  
press
    "Private"

    pressed := true.
    self highlight.!