
"--------- add temporary methods"!

!String methods !  
osiMethods
        "Answer self as the class reader so that errors
            like missing classes and methods referencing globals
            not in the image can failed gracefully."
    ^self! !

!String methods !  
osiMethods: aString
        "Answer self as the class reader so that errors
            like missing classes and methods referencing globals
            not in the image can failed gracefully."
    (aString osiEvaluateIfError: [ false ]
        ) ~= false ifTrue: [ ^self osiMethods ].
    "Answer a string that will not evaluate."
    ^'a ', self! !

!String methods !  
osiEvaluateIfError: aBlock
        "Evaluate the receiver and answer the result.
            Answer aBlock evaluated if an error occurs."
    | compiler result answer |
    compiler := CompilerInterface
        forClass: UndefinedObject
        errorHandler: SilentErrorHandler new.
    [   answer := 
            (result := compiler evaluate: self) wasSuccessful
                ifTrue: [ result value ]
                ifFalse: [ aBlock value ].
    ]   on: Error
        do: [ answer := aBlock value ].
    ^answer! !

!String methods !  
osiRemoveSelector: aString
        "Remove the specified selector from the specified class.
            If the class or selector are not defined,
            then fail gracefully and report an error to the Transcript."
    | aClass aSelector |
    aClass := self osiEvaluateIfError: [ nil ].
    aSelector := aString asExistingSymbolOrNil.
    aClass notNil & aSelector notNil
        ifTrue: [ aClass removeSelector: aSelector ]
        ifFalse: [
            Transcript cr;
                nextPutAll: 'Ignored remove ', self, '>>', aString ].! !

!String methods !  
fileInFrom: aStream
        "File in the method definitions.
            If the class is missing or the method does not compile,
            then fail gracefully and report an error to the Transcript."
    | aClass chunk compiler result assoc mth |
    (aClass := self osiEvaluateIfError: [ nil ]
        ) notNil ifTrue: [
            compiler := CompilerInterface
                   forClass: aClass
                errorHandler: SilentErrorHandler new ].
    [(chunk := aStream nextChunk) isEmpty]
        whileFalse: [
            compiler notNil ifTrue: [
                 (result := compiler compile: chunk) wasSuccessful
                    ifTrue: [
                        assoc := result association.
                        ((mth := aClass compiledMethodAt: assoc key) isNil
                            or: [ mth sourceString ~= chunk ]
                        ) ifTrue: [
                            assoc value
      	                         classField: aClass;
                                selector: result selector;
                                sourceObject: nil;
                                sourceString: chunk.
                            aClass
                                addSelector: assoc key
                                withMethod: assoc value ] ]
                    ifFalse: [
                        result := nil ] ].
            result isNil ifTrue: [
                Transcript cr;
                    nextPutAll: 'Ignored ', self, ' method' ] ].! !

!String methods !  
osisubclass: className
    instanceVariableNames: instVarString
    classVariableNames: classVarString
    poolDictionaries: poolDictString
        "Create or modify the class named <className> to be a
        subclass of the receiver with the specifed instance variables,
        class variables, pool dictionaries."

    | aClass subClass aSelector instVarNames classVarNames poolDictNames |
    aClass := self osiEvaluateIfError: [ nil ].
    aClass isBehavior ifFalse: [ aClass := nil ].
    subClass := className osiEvaluateIfError: [ nil ].
    aClass isNil ifTrue: [
        Transcript cr;
            nextPutAll: 'Ignored ', self, ' subclass: #', className, '...'.
        ^nil ].
    subClass notNil ifTrue: [
        instVarNames := subClass instanceVariableString asArrayOfSubstrings.
        classVarNames := subClass classVariableString asArrayOfSubstrings asSortedCollection.
        poolDictNames := subClass sharedPools asSortedCollection collect: [ :each | each asString ].
        (instVarString asArrayOfSubstrings = instVarNames and: [
            classVarString asArrayOfSubstrings asSortedCollection = classVarNames and: [
                poolDictString asArrayOfSubstrings asSortedCollection = poolDictNames and: [
                    aClass == subClass superclass ] ] ]
        ) ifTrue: [ ^subClass ] ].
    ^[  aClass
            subclass: className asSymbol
            instanceVariableNames: instVarString
            classVariableNames: classVarString
            poolDictionaries: poolDictString
            ] on: Error do: [
                Transcript cr;
                    nextPutAll: 'Ignored ', self, ' subclass: #', className, '...'.
                nil ].
! !

!String methods !  
osisubclass: className
    instanceVariableNames: instVarString
    classVariableNames: classVarString
    poolDictionaries: poolDictString
    ifDefined: ifDefString
        "Create or modify the class named <className> to be a
        subclass of the receiver with the specifed instance variables,
        class variables, pool dictionaries.  If <ifDefString> evaluates
        false, then ignore the class definition."

    ^(ifDefString osiEvaluateIfError: [ false ]) ~= false
        ifTrue: [
            self
                osisubclass: className
                instanceVariableNames: instVarString
                classVariableNames: classVarString
                poolDictionaries: poolDictString ]
        ifFalse: [
            Transcript cr;
                nextPutAll: 'Ignored ', self, ' subclass: #', className, '...'.
            nil ].! !
  
"--------- end temporary methods"!


"SP Dev Base Common (SP2ADEVW.SLL)"!
!'CPSubPane' osiMethods !  
extent
        "Answer the receiver's extent."
    self isHandleOk ifTrue: [ ^super extent ].
    ^self rectangleAttribute extent! !

"SP Dev Base Common (SP2ADEVW.SLL)"!
!'CPSubPane' osiMethods !  
height
        "Answer the receiver's height."
    self isHandleOk ifTrue: [ ^super height ].
    ^self rectangleAttribute height! !

"SP Dev Base Common (SP2ADEVW.SLL)"!
!'CPSubPane' osiMethods !  
width
        "Answer the receiver's width."
    self isHandleOk ifTrue: [ ^super width ].
    ^self rectangleAttribute width! !

"SP Dev Base Common (SP2ADEVW.SLL)"!
!'WB2BitmapPicker' osiMethods !  
createViews

        " WARNING!! This method was automatically generated by 
        WindowBuilder. Code you add here which does not conform to 
        the WindowBuilder API will probably be lost the next time 
        you save your layout definition."

    | cancel editView mainView ok pictureCheck pictureSelect 
    pushedCheck pushedSelect |
    
    mainView := self topPaneClass new.
    
        " Temporary Variables"
    cancel := Button new.
    editView := Button new.
    ok := Button new.
    pictureCheck := CheckBox new.
    pictureSelect := WBComboBox new.
    pushedCheck := CheckBox new.
    pushedSelect := WBComboBox new.
    
    mainView "WB2BitmapPicker"
        owner: self;
        paneName: 'mainView';
        labelWithoutPrefix:  'CPBitmapButton Attributes';
        noSmalltalkMenuBar;
        framingBlock: ( FramingParameters new iDUE: 823 @ 216; xC; yC; cRDU: (0 @ 0 rightBottom: 823 @ 216));
        pStyle: #(sysmenu modal titlebar);
        when: #activated send: #activated to: self.
    self addView: mainView.
    
    pictureCheck "CheckBox"
        owner: self;
        paneName: 'pictureCheck';
        framingBlock: ( FramingParameters new iDUE: 283 @ 36; lDU: 18 r: #left; tDU: 24 r: #top);
        startGroup;
        tabStop;
        when: #clicked: send: #pictureClicked: to: self;
        contents: 'Picture:'.
    mainView addSubpane: pictureCheck.
    
    pictureSelect "WBComboBox"
        owner: self;
        paneName: 'pictureSelect';
        framingBlock: ( FramingParameters new iDUE: 503 @ 416; lDU: 302 r: #left; rDU: 805 r: #left; tDU: 16 r: #top; bDU: 432 r: #top);
        dropDownList;
        startGroup;
        tabStop;
        when: #changed: send: #pictureSelected: to: self;
        when: #needsContents send: #keys: to: self withArgument: pictureSelect.
    mainView addSubpane: pictureSelect.
    
    pushedCheck "CheckBox"
        owner: self;
        paneName: 'pushedCheck';
        framingBlock: ( FramingParameters new iDUE: 283 @ 36; lDU: 18 r: #left; tDU: 88 r: #top);
        startGroup;
        tabStop;
        when: #clicked: send: #pushedClicked: to: self;
        contents: 'Pushed Picture:'.
    mainView addSubpane: pushedCheck.
    
    pushedSelect "WBComboBox"
        owner: self;
        paneName: 'pushedSelect';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 503 @ 358; lDU: 302 r: #left; rDU: 805 r: #left; tDU: 80 r: #top; bDU: 438 r: #top);
        dropDownList;
        startGroup;
        tabStop;
        when: #changed: send: #pushedSelected: to: self;
        when: #needsContents send: #keys: to: self withArgument: pushedSelect.
    mainView addSubpane: pushedSelect.
    
    editView "Button"
        owner: self;
        paneName: 'editView';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 421 @ 56; lDU: 384 r: #left; rDU: 805 r: #left; tDU: 144 r: #top; bDU: 200 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #editBitmaps to: self;
        contents: 'Edit/View Bitmaps...'.
    mainView addSubpane: editView.
    
    ok "Button"
        owner: self;
        paneName: 'ok';
        framingBlock: ( FramingParameters new iDUE: 155 @ 58; lDU: 18 r: #left; rDU: 174 r: #left; tDU: 144 r: #top; bDU: 202 r: #top);
        defaultPushButton;
        defaultPushButton;
        startGroup;
        tabStop;
        when: #clicked send: #ok to: self;
        contents: '&OK'.
    mainView addSubpane: ok.
    
    cancel "Button"
        owner: self;
        paneName: 'cancel';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 155 @ 56; lDU: 192 r: #left; rDU: 347 r: #left; tDU: 144 r: #top; bDU: 200 r: #top);
        cancelPushButton;
        cancelPushButton;
        startGroup;
        tabStop;
        when: #clicked send: #cancel to: self;
        contents: '&Cancel'.
    mainView addSubpane: cancel! !

"SP Dev Base Common (SP2ADEVW.SLL)"!
!'WBBitmapPicker' osiMethods !  
createViews

        " WARNING!! This method was automatically generated by 
        WindowBuilder. Code you add here which does not conform to 
        the WindowBuilder API will probably be lost the next time 
        you save your layout definition."

    | bitmapLabel cancel editView mainView name ok |
    
    mainView := self topPaneClass new.
    
        " Temporary Variables"
    bitmapLabel := StaticText new.
    cancel := Button new.
    editView := Button new.
    name := WBComboBox new.
    ok := Button new.
    
    mainView "WBBitmapPicker"
        owner: self;
        paneName: 'mainView';
        labelWithoutPrefix:  'CPBitmapPane Attributes';
        noSmalltalkMenuBar;
        framingBlock: ( FramingParameters new iDUE: 777 @ 152; xC; yC; cRDU: (0 @ 0 rightBottom: 777 @ 152));
        pStyle: #(sysmenu modal titlebar);
        when: #activated send: #activated to: self.
    self addView: mainView.
    
    name "WBComboBox"
        owner: self;
        paneName: 'name';
        framingBlock: ( FramingParameters new iDUE: 613 @ 424; lDU: 146 r: #left; rDU: 759 r: #left; tDU: 16 r: #top; bDU: 440 r: #top);
        dropDownList;
        startGroup;
        tabStop;
        when: #needsContents send: #keys: to: self withArgument: name.
    mainView addSubpane: name.
    
    editView "Button"
        owner: self;
        paneName: 'editView';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 338 @ 56; lDU: 421 r: #left; rDU: 759 r: #left; tDU: 80 r: #top; bDU: 136 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #editBitmaps to: self;
        contents: '&Edit/View Bitmaps...'.
    mainView addSubpane: editView.
    
    ok "Button"
        owner: self;
        paneName: 'ok';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 174 @ 58; lDU: 18 r: #left; rDU: 192 r: #left; tDU: 80 r: #top; bDU: 138 r: #top);
        defaultPushButton;
        defaultPushButton;
        startGroup;
        tabStop;
        when: #clicked send: #ok to: self;
        contents: '&OK'.
    mainView addSubpane: ok.
    
    cancel "Button"
        owner: self;
        paneName: 'cancel';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 174 @ 56; lDU: 219 r: #left; rDU: 393 r: #left; tDU: 80 r: #top; bDU: 136 r: #top);
        cancelPushButton;
        startGroup;
        tabStop;
        when: #clicked send: #cancel to: self;
        contents: '&Cancel'.
    mainView addSubpane: cancel.
    
    bitmapLabel "StaticText"
        owner: self;
        paneName: 'bitmapLabel';
        framingBlock: ( FramingParameters new iDUE: 119 @ 32; lDU: 18 r: #left; rDU: 137 r: #left; tDU: 24 r: #top; bDU: 56 r: #top);
        rightJustified;
        startGroup;
        contents: 'Bitmap:'.
    mainView addSubpane: bitmapLabel! !

"SP Dev Base Common (SP2ADEVW.SLL)"!
!'WBColumnarListBoxEditor' osiMethods !  
createViews

        " WARNING!! This method was automatically generated by 
        WindowBuilder. Code you add here which does not conform to 
        the WindowBuilder API will probably be lost the next time 
        you save your layout definition."

    | attributesGroup autoFieldWidth cancel canReorder 
    canResize canSort centerJustified colorLabel colorMethod 
    columnWidthGroup delete disabledLabel disableMethod 
    fieldWidth font headerColor headerColorLabel insert 
    itemsList justificationGroup label labelLabel leftJustified 
    mainView method methodGroup methodLabel moveDown moveUp 
    noAutoFieldWidth ok optionsGroup rightJustified showLines 
    showTitles |
    
    mainView := self topPaneClass new.
    
        " Temporary Variables"
    attributesGroup := GroupBox new.
    autoFieldWidth := RadioButton new.
    cancel := Button new.
    canReorder := CheckBox new.
    canResize := CheckBox new.
    canSort := CheckBox new.
    centerJustified := RadioButton new.
    colorLabel := StaticText new.
    colorMethod := EntryField new.
    columnWidthGroup := GroupBox new.
    delete := Button new.
    disabledLabel := StaticText new.
    disableMethod := EntryField new.
    fieldWidth := CPNumericEditor new.
    font := Button new.
    headerColor := WBComboBox new.
    headerColorLabel := StaticText new.
    insert := Button new.
    itemsList := ListBox new.
    justificationGroup := GroupBox new.
    label := TextEdit new.
    labelLabel := StaticText new.
    leftJustified := RadioButton new.
    method := WBEntryField new.
    methodGroup := GroupBox new.
    methodLabel := StaticText new.
    moveDown := Button new.
    moveUp := Button new.
    noAutoFieldWidth := RadioButton new.
    ok := Button new.
    optionsGroup := GroupBox new.
    rightJustified := RadioButton new.
    showLines := CheckBox new.
    showTitles := CheckBox new.
    
    mainView "WBColumnarListBoxEditor"
        owner: self;
        paneName: 'mainView';
        labelWithoutPrefix:  'CPColumnarListBoxEditor';
        noSmalltalkMenuBar;
        framingBlock: ( FramingParameters new iDUE: 1381 @ 528; xC; yC; cRDU: (0 @ 0 rightBottom: 1381 @ 528));
        pStyle: #(sysmenu modal titlebar).
    self addView: mainView.
    
    itemsList "ListBox"
        owner: self;
        paneName: 'itemsList';
        framingBlock: ( FramingParameters new iDUE: 411 @ 248; lDU: 18 r: #left; tDU: 24 r: #top);
        startGroup;
        tabStop;
        when: #needsContents send: #loadListContents to: self;
        when: #changedIndex: send: #selectedField: to: self.
    mainView addSubpane: itemsList.
    
    insert "Button"
        owner: self;
        paneName: 'insert';
        framingBlock: ( FramingParameters new iDUE: 295 @ 56; lDU: 448 r: #left; rDU: 743 r: #left; tDU: 24 r: #top; bDU: 80 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #insertItem to: self;
        contents: '&Insert'.
    mainView addSubpane: insert.
    
    delete "Button"
        owner: self;
        paneName: 'delete';
        framingBlock: ( FramingParameters new iDUE: 295 @ 56; lDU: 448 r: #left; rDU: 743 r: #left; tDU: 88 r: #top; bDU: 144 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #deleteItem to: self;
        contents: 'D&elete'.
    mainView addSubpane: delete.
    
    moveUp "Button"
        owner: self;
        paneName: 'moveUp';
        framingBlock: ( FramingParameters new iDUE: 295 @ 56; lDU: 448 r: #left; rDU: 743 r: #left; tDU: 152 r: #top; bDU: 208 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #moveUp to: self;
        contents: 'Move &Up'.
    mainView addSubpane: moveUp.
    
    moveDown "Button"
        owner: self;
        paneName: 'moveDown';
        framingBlock: ( FramingParameters new iDUE: 295 @ 56; lDU: 448 r: #left; rDU: 743 r: #left; tDU: 216 r: #top; bDU: 272 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #moveDown to: self;
        contents: 'Move &Down'.
    mainView addSubpane: moveDown.
    
    colorMethod "EntryField"
        owner: self;
        paneName: 'colorMethod';
        framingBlock: ( FramingParameters new iDUE: 210 @ 48; lDU: 201 r: #left; rDU: 411 r: #left; tDU: 320 r: #top; bDU: 368 r: #top; indent: 3 @ 4);
        startGroup;
        tabStop.
    mainView addSubpane: colorMethod.
    
    disableMethod "EntryField"
        owner: self;
        paneName: 'disableMethod';
        framingBlock: ( FramingParameters new iDUE: 210 @ 48; lDU: 201 r: #left; rDU: 411 r: #left; tDU: 376 r: #top; bDU: 424 r: #top; indent: 3 @ 4);
        startGroup;
        tabStop.
    mainView addSubpane: disableMethod.
    
    canResize "CheckBox"
        owner: self;
        paneName: 'canResize';
        framingBlock: ( FramingParameters new iDUE: 219 @ 40; lDU: 475 r: #left; rDU: 695 r: #left; tDU: 320 r: #top; bDU: 360 r: #top);
        startGroup;
        tabStop;
        contents: 'Can Re&size'.
    mainView addSubpane: canResize.
    
    canReorder "CheckBox"
        owner: self;
        paneName: 'canReorder';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 229 @ 40; lDU: 475 r: #left; rDU: 704 r: #left; tDU: 356 r: #top; bDU: 396 r: #top);
        startGroup;
        tabStop;
        contents: 'Can Re&order'.
    mainView addSubpane: canReorder.
    
    canSort "CheckBox"
        owner: self;
        paneName: 'canSort';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 174 @ 40; lDU: 475 r: #left; rDU: 649 r: #left; tDU: 392 r: #top; bDU: 432 r: #top);
        startGroup;
        tabStop;
        contents: 'Can Sort'.
    mainView addSubpane: canSort.
    
    showLines "CheckBox"
        owner: self;
        paneName: 'showLines';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 219 @ 40; lDU: 475 r: #left; rDU: 695 r: #left; tDU: 428 r: #top; bDU: 468 r: #top);
        startGroup;
        tabStop;
        contents: 'Show &Lines'.
    mainView addSubpane: showLines.
    
    showTitles "CheckBox"
        owner: self;
        paneName: 'showTitles';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 219 @ 40; lDU: 475 r: #left; rDU: 695 r: #left; tDU: 464 r: #top; bDU: 504 r: #top);
        startGroup;
        tabStop;
        contents: 'Show &Titles'.
    mainView addSubpane: showTitles.
    
    method "WBEntryField"
        owner: self;
        paneName: 'method';
        framingBlock: ( FramingParameters new iDUE: 402 @ 48; lDU: 933 r: #left; rDU: 1335 r: #left; tDU: 184 r: #top; bDU: 232 r: #top; indent: 3 @ 4);
        startGroup;
        tabStop;
        when: #textChanged: send: #columnChanged: to: self.
    mainView addSubpane: method.
    
    leftJustified "RadioButton"
        owner: self;
        paneName: 'leftJustified';
        framingBlock: ( FramingParameters new iDUE: 119 @ 40; lDU: 823 r: #left; rDU: 942 r: #left; tDU: 272 r: #top; bDU: 312 r: #top);
        startGroup;
        when: #clicked: send: #columnChanged: to: self;
        contents: '&Left'.
    mainView addSubpane: leftJustified.
    
    rightJustified "RadioButton"
        owner: self;
        paneName: 'rightJustified';
        framingBlock: ( FramingParameters new iDUE: 139 @ 40; lDU: 823 r: #left; rDU: 962 r: #left; tDU: 320 r: #top; bDU: 360 r: #top);
        when: #clicked: send: #columnChanged: to: self;
        contents: '&Right'.
    mainView addSubpane: rightJustified.
    
    centerJustified "RadioButton"
        owner: self;
        paneName: 'centerJustified';
        framingBlock: ( FramingParameters new iDUE: 160 @ 40; lDU: 823 r: #left; rDU: 983 r: #left; tDU: 368 r: #top; bDU: 408 r: #top);
        when: #clicked: send: #columnChanged: to: self;
        contents: 'Ce&nter'.
    mainView addSubpane: centerJustified.
    
    autoFieldWidth "RadioButton"
        owner: self;
        paneName: 'autoFieldWidth';
        framingBlock: ( FramingParameters new iDUE: 128 @ 40; lDU: 1042 r: #left; rDU: 1170 r: #left; tDU: 272 r: #top; bDU: 312 r: #top);
        startGroup;
        when: #clicked: send: #autoFieldWidth: to: self;
        contents: '&Auto'.
    mainView addSubpane: autoFieldWidth.
    
    noAutoFieldWidth "RadioButton"
        owner: self;
        paneName: 'noAutoFieldWidth';
        framingBlock: ( FramingParameters new iDUE: 146 @ 40; lDU: 1042 r: #left; rDU: 1189 r: #left; tDU: 312 r: #top; bDU: 352 r: #top);
        when: #clicked: send: #noAutoFieldWidth: to: self;
        contents: 'Chars:'.
    mainView addSubpane: noAutoFieldWidth.
    
    fieldWidth "CPNumericEditor"
        owner: self;
        paneName: 'fieldWidth';
        framingBlock: ( FramingParameters new iDUE: 119 @ 48; lDU: 1198 r: #left; tDU: 312 r: #top);
        startGroup;
        tabStop;
        when: #valueChanged: send: #columnChanged: to: self.
    mainView addSubpane: fieldWidth.
    
    font "Button"
        owner: self;
        paneName: 'font';
        framingBlock: ( FramingParameters new iDUE: 313 @ 48; lDU: 1024 r: #left; rDU: 1337 r: #left; tDU: 384 r: #top; bDU: 432 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #setFont to: self;
        contents: 'Set &Font...'.
    mainView addSubpane: font.
    
    headerColor "WBComboBox"
        owner: self;
        paneName: 'headerColor';
        framingBlock: ( FramingParameters new iDUE: 352 @ 192; lDU: 1006 r: #left; rDU: 1358 r: #left; tDU: 464 r: #top; bDU: 656 r: #top);
        dropDownList;
        startGroup;
        tabStop.
    mainView addSubpane: headerColor.
    
    ok "Button"
        owner: self;
        paneName: 'ok';
        framingBlock: ( FramingParameters new iDUE: 201 @ 56; lDU: 18 r: #left; rDU: 219 r: #left; tDU: 456 r: #top; bDU: 512 r: #top);
        defaultPushButton;
        defaultPushButton;
        startGroup;
        tabStop;
        when: #clicked send: #ok to: self;
        contents: '&OK'.
    mainView addSubpane: ok.
    
    cancel "Button"
        owner: self;
        paneName: 'cancel';
        framingBlock: ( FramingParameters new iDUE: 199 @ 56; lDU: 229 r: #left; rDU: 427 r: #left; tDU: 456 r: #top; bDU: 512 r: #top);
        cancelPushButton;
        cancelPushButton;
        startGroup;
        tabStop;
        when: #clicked send: #cancel to: self;
        contents: '&Cancel'.
    mainView addSubpane: cancel.
    
    label "TextEdit"
        owner: self;
        paneName: 'label';
        framingBlock: ( FramingParameters new iDUE: 402 @ 128; lDU: 933 r: #left; rDU: 1335 r: #left; tDU: 48 r: #top; bDU: 176 r: #top);
        removeHorizontalScrollbarStyle;
       addVerticalScrollbarStyle;
       addBorderStyle;
        startGroup;
        when: #textChanged: send: #labelChanged: to: self.
    mainView addSubpane: label.
    
    disabledLabel "StaticText"
        owner: self;
        paneName: 'disabledLabel';
        framingBlock: ( FramingParameters new iDUE: 160 @ 32; lDU: 27 r: #left; rDU: 187 r: #left; tDU: 384 r: #top; bDU: 416 r: #top);
        rightJustified;
        startGroup;
        contents: 'Disabled:'.
    mainView addSubpane: disabledLabel.
    
    colorLabel "StaticText"
        owner: self;
        paneName: 'colorLabel';
        framingBlock: ( FramingParameters new iDUE: 160 @ 32; lDU: 27 r: #left; rDU: 187 r: #left; tDU: 328 r: #top; bDU: 360 r: #top);
        rightJustified;
        startGroup;
        contents: 'Color:'.
    mainView addSubpane: colorLabel.
    
    headerColorLabel "StaticText"
        owner: self;
        paneName: 'headerColorLabel';
        framingBlock: ( FramingParameters new iDUE: 235 @ 32; lDU: 759 r: #left; rDU: 994 r: #left; tDU: 472 r: #top; bDU: 504 r: #top);
        rightJustified;
        startGroup;
        contents: 'Header Color:'.
    mainView addSubpane: headerColorLabel.
    
    methodLabel "StaticText"
        owner: self;
        paneName: 'methodLabel';
        framingBlock: ( FramingParameters new iDUE: 133 @ 32; lDU: 795 r: #left; rDU: 928 r: #left; tDU: 192 r: #top; bDU: 224 r: #top);
        rightJustified;
        startGroup;
        contents: 'Method:'.
    mainView addSubpane: methodLabel.
    
    labelLabel "StaticText"
        owner: self;
        paneName: 'labelLabel';
        framingBlock: ( FramingParameters new iDUE: 133 @ 32; lDU: 793 r: #left; rDU: 926 r: #left; tDU: 56 r: #top; bDU: 88 r: #top);
        rightJustified;
        startGroup;
        contents: 'Label:'.
    mainView addSubpane: labelLabel.
    
    methodGroup "GroupBox"
        owner: self;
        paneName: 'methodGroup';
        framingBlock: ( FramingParameters new iDUE: 411 @ 160; lDU: 18 r: #left; rDU: 430 r: #left; tDU: 280 r: #top; bDU: 440 r: #top);
        startGroup;
        contents: 'Object Methods'.
    mainView addSubpane: methodGroup.
    
    optionsGroup "GroupBox"
        owner: self;
        paneName: 'optionsGroup';
        framingBlock: ( FramingParameters new iDUE: 293 @ 232; lDU: 448 r: #left; rDU: 741 r: #left; tDU: 280 r: #top; bDU: 512 r: #top);
        startGroup;
        contents: 'Options'.
    mainView addSubpane: optionsGroup.
    
    justificationGroup "GroupBox"
        owner: self;
        paneName: 'justificationGroup';
        framingBlock: ( FramingParameters new iDUE: 219 @ 200; lDU: 786 r: #left; rDU: 1006 r: #left; tDU: 232 r: #top; bDU: 432 r: #top);
        startGroup;
        contents: 'Justification'.
    mainView addSubpane: justificationGroup.
    
    columnWidthGroup "GroupBox"
        owner: self;
        paneName: 'columnWidthGroup';
        framingBlock: ( FramingParameters new iDUE: 311 @ 136; lDU: 1024 r: #left; rDU: 1335 r: #left; tDU: 232 r: #top; bDU: 368 r: #top);
        startGroup;
        contents: 'Column Width'.
    mainView addSubpane: columnWidthGroup.
    
    attributesGroup "GroupBox"
        owner: self;
        paneName: 'attributesGroup';
        framingBlock: ( FramingParameters new iDUE: 587 @ 440; lDU: 768 r: #left; rDU: 1355 r: #left; tDU: 8 r: #top; bDU: 448 r: #top);
        startGroup;
        contents: 'Column Attributes'.
    mainView addSubpane: attributesGroup! !

"SP Dev Base Common (SP2ADEVW.SLL)"!
!'WBColumnarListBoxEditor' osiMethods !  
updateList

    | selection list |
    selection := (list := self paneNamed: 'itemsList') selection.
    self loadListContents.
    list selection: selection.! !

"SP Dev Base Common (SP2ADEVW.SLL)"!
!'WBCPTimeEditorEditor' osiMethods !  
createViews

        "WARNING!! This method was automatically generated by 
        WindowBuilder. Code you add here which does not conform to 
        the WindowBuilder API will probably be lost the next time 
        you save your layout definition."

    | amString cancel hour12 hour24 leadingZero mainView ok 
    pmString separator separatorLabel |
    
    mainView := self topPaneClass new.
    
        "Temporary Variables"
    amString := EntryField new.
    cancel := Button new.
    hour12 := RadioButton new.
    hour24 := RadioButton new.
    leadingZero := CheckBox new.
    ok := Button new.
    pmString := EntryField new.
    separator := EntryField new.
    separatorLabel := StaticText new.
    
    mainView
        owner: self;
        paneName: 'mainView';
        labelWithoutPrefix: 'CPTimeEditor Attributes';
        noSmalltalkMenuBar;
        pStyle: #(sysmenu modal titlebar);
        framingBlock:
            (FramingParameters new
                iDUE: 631 @ 312;
                xC; yC; cRDU: (0 @ 312 rightBottom: 631 @ 0)).
    self addView: mainView.
    
    hour12 "RadioButton"
        owner: self;
        paneName: 'hour12';
        framingBlock:
            (FramingParameters new
                iDUE: 411 @ 40;
                lDU: 18 r: #left; rDU: 430 r: #left;
                tDU: 20 r: #top; bDU: 60 r: #top);
        contents: '12 Hour (00:00 - 11:59)';
        startGroup;
        tabStop.
    mainView addSubpane: hour12.
    
    hour24 "RadioButton"
        owner: self;
        paneName: 'hour24';
        framingBlock:
            (FramingParameters new
                iDUE: 411 @ 40;
                lDU: 18 r: #left; rDU: 430 r: #left;
                tDU: 76 r: #top; bDU: 116 r: #top);
        contents: '24 Hour (12:00 - 23:59)'.
    mainView addSubpane: hour24.
    
    amString "EntryField"
        owner: self;
        paneName: 'amString';
        framingBlock:
            (FramingParameters new
                iDUE: 174 @ 48;
                lDU: 439 r: #left; rDU: 613 r: #left;
                tDU: 16 r: #top; bDU: 64 r: #top; 
                indent: 3 @ 4);
        startGroup;
        tabStop.
    mainView addSubpane: amString.
    
    pmString "EntryField"
        owner: self;
        paneName: 'pmString';
        framingBlock:
            (FramingParameters new
                iDUE: 174 @ 48;
                lDU: 439 r: #left; rDU: 613 r: #left;
                tDU: 72 r: #top; bDU: 120 r: #top; 
                indent: 3 @ 4);
        startGroup;
        tabStop.
    mainView addSubpane: pmString.
    
    separator "EntryField"
        owner: self;
        paneName: 'separator';
        framingBlock:
            (FramingParameters new
                iDUE: 55 @ 48;
                lDU: 183 r: #left; rDU: 238 r: #left;
                tDU: 128 r: #top; bDU: 176 r: #top; 
                indent: 3 @ 4);
        startGroup;
        tabStop.
    mainView addSubpane: separator.
    
    leadingZero "CheckBox"
        owner: self;
        paneName: 'leadingZero';
        framingBlock:
            (FramingParameters new
                iDUE: 480 @ 40;
                lDU: 18 r: #left; rDU: 498 r: #left;
                tDU: 184 r: #top; bDU: 224 r: #top);
        contents: 'Leading Zero (09:15 vs. 9:15)';
        startGroup;
        tabStop.
    mainView addSubpane: leadingZero.
    
    ok "Button"
        owner: self;
        paneName: 'ok';
        when: #clicked send: #ok to: self;
        framingBlock:
            (FramingParameters new
                iDUE: 155 @ 58;
                lDU: 18 r: #left; rDU: 174 r: #left;
                tDU: 240 r: #top; bDU: 298 r: #top);
        defaultPushButton;
        contents: '~OK';
        startGroup;
        tabStop.
    mainView addSubpane: ok.
    
    cancel "Button"
        owner: self;
        paneName: 'cancel';
        when: #clicked send: #cancel to: self;
        framingBlock:
            (FramingParameters new
                iDUE: 155 @ 58;
                lDU: 183 r: #left; rDU: 338 r: #left;
                tDU: 240 r: #top; bDU: 298 r: #top);
        cancelPushButton;
        contents: '~Cancel';
        startGroup;
        tabStop.
    mainView addSubpane: cancel.
    
    separatorLabel "StaticText"
        owner: self;
        paneName: 'separatorLabel';
        framingBlock:
            (FramingParameters new
                iDUE: 165 @ 32;
                lDU: 9 r: #left; rDU: 174 r: #left;
                tDU: 136 r: #top; bDU: 168 r: #top);
        rightJustified;
        contents: 'Separator:';
        startGroup.
    mainView addSubpane: separatorLabel! !

"SP Dev Base Common (SP2ADEVW.SLL)"!
!'WBCPTimeEditorEditor' osiMethods !  
initWindow

    | pane |
    pane := thePane realPane.
    (self paneNamed: pane format)
        sendInputEvent: #selection:
        with: true.
    (self paneNamed: 'amString')
        setTextLimit: 8;
        contents: pane amString.
    (self paneNamed: 'pmString')
        setTextLimit: 8;
        contents: pane pmString.
    (self paneNamed: 'separator')
        setTextLimit: 1;
        contents: pane separator.
    (self paneNamed: 'leadingZero') selection: pane leadingZero.! !

"SP Dev Base Common (SP2ADEVW.SLL)"!
!'WBCPTimeEditorEditor class' osiMethods !  
wbBasicVersion
        "Private - Answer the window builder version."
    ^2.0! !

"SP Dev Base Common (SP2ADEVW.SLL)"!
!'WBCPValueSetEditor' osiMethods !  
createViews

        " WARNING!! This method was automatically generated by 
        WindowBuilder. Code you add here which does not conform to 
        the WindowBuilder API will probably be lost the next time 
        you save your layout definition."

    | bitmapLabel cancel colorLabel columns columnsLabel 
    editView mainView ok palette rows rowsLabel sizeGroup 
    textLabel |
    
    mainView := self topPaneClass new.
    
        " Instance Variables"
    bitmap := WBComboBox new.
    color := WBComboBox new.
    text := WBEntryField new.
    
        " Temporary Variables"
    bitmapLabel := StaticText new.
    cancel := Button new.
    colorLabel := StaticText new.
    columns := CPNumericEditor new.
    columnsLabel := StaticText new.
    editView := Button new.
    ok := Button new.
    palette := CPValueSet new.
    rows := CPNumericEditor new.
    rowsLabel := StaticText new.
    sizeGroup := GroupBox new.
    textLabel := StaticText new.
    
    mainView "WBCPValueSetEditor"
        owner: self;
        paneName: 'mainView';
        labelWithoutPrefix:  'Palette Attributes';
        noSmalltalkMenuBar;
        framingBlock: ( FramingParameters new iDUE: 997 @ 648; xC; yC; cRDU: (0 @ 0 rightBottom: 997 @ 648));
        pStyle: #(sysmenu modal titlebar);
        when: #activated send: #activated to: self.
    self addView: mainView.
    
    rows "CPNumericEditor"
        owner: self;
        paneName: 'rows';
        framingBlock: ( FramingParameters new iDUE: 155 @ 48; lDU: 192 r: #left; tDU: 48 r: #top);
        min: 1;
        contents: 1;
        startGroup;
        tabStop;
        when: #valueChanged: send: #rowsColumnsChanged: to: self.
    mainView addSubpane: rows.
    
    columns "CPNumericEditor"
        owner: self;
        paneName: 'columns';
        framingBlock: ( FramingParameters new iDUE: 155 @ 48; lDU: 192 r: #left; tDU: 112 r: #top);
        min: 1;
        contents: 1;
        startGroup;
        tabStop;
        when: #valueChanged: send: #rowsColumnsChanged: to: self.
    mainView addSubpane: columns.
    
    text "WBEntryField"
        owner: self;
        paneName: 'text';
        framingBlock: ( FramingParameters new iDUE: 466 @ 48; lDU: 512 r: #left; rDU: 978 r: #left; tDU: 16 r: #top; bDU: 64 r: #top; indent: 3 @ 4);
        startGroup;
        tabStop;
        when: #textChanged: send: #textChanged: to: self.
    mainView addSubpane: text.
    
    bitmap "WBComboBox"
        owner: self;
        paneName: 'bitmap';
        framingBlock: ( FramingParameters new iDUE: 469 @ 276; lDU: 512 r: #left; rDU: 981 r: #left; tDU: 72 r: #top; bDU: 348 r: #top);
        dropDownList;
        startGroup;
        tabStop;
        when: #changed: send: #bitmapSelected: to: self;
        when: #needsContents send: #keys: to: self withArgument: bitmap.
    mainView addSubpane: bitmap.
    
    color "WBComboBox"
        owner: self;
        paneName: 'color';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 469 @ 276; lDU: 512 r: #left; rDU: 981 r: #left; tDU: 128 r: #top; bDU: 404 r: #top);
        dropDownList;
        startGroup;
        tabStop;
        when: #changed: send: #colorSelected: to: self;
        when: #needsContents send: #colors: to: self withArgument: color.
    mainView addSubpane: color.
    
    palette "CPValueSet"
        owner: self;
        paneName: 'palette';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 960 @ 384; lDU: 18 r: #left; tDU: 184 r: #top);
        rows: 2 columns: 2;
        startGroup;
        tabStop;
        when: #selectItem: send: #cellSelected: to: self.
    mainView addSubpane: palette.
    
    editView "Button"
        owner: self;
        paneName: 'editView';
        framingBlock: ( FramingParameters new iDUE: 357 @ 54; lDU: 622 r: #left; rDU: 978 r: #left; tDU: 576 r: #top; bDU: 630 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #editBitmaps to: self;
        contents: '&Edit/View Bitmaps...'.
    mainView addSubpane: editView.
    
    ok "Button"
        owner: self;
        paneName: 'ok';
        framingBlock: ( FramingParameters new iDUE: 142 @ 54; lDU: 18 r: #left; rDU: 160 r: #left; tDU: 576 r: #top; bDU: 630 r: #top);
        defaultPushButton;
        defaultPushButton;
        startGroup;
        tabStop;
        when: #clicked send: #ok to: self;
        contents: '&OK'.
    mainView addSubpane: ok.
    
    cancel "Button"
        owner: self;
        paneName: 'cancel';
        framingBlock: ( FramingParameters new iDUE: 142 @ 54; lDU: 174 r: #left; rDU: 315 r: #left; tDU: 576 r: #top; bDU: 630 r: #top);
        cancelPushButton;
        startGroup;
        tabStop;
        when: #clicked send: #cancel to: self;
        contents: '&Cancel'.
    mainView addSubpane: cancel.
    
    colorLabel "StaticText"
        owner: self;
        paneName: 'colorLabel';
        framingBlock: ( FramingParameters new iDUE: 91 @ 32; lDU: 411 r: #left; rDU: 503 r: #left; tDU: 136 r: #top; bDU: 168 r: #top);
        rightJustified;
        startGroup;
        contents: 'Color:'.
    mainView addSubpane: colorLabel.
    
    bitmapLabel "StaticText"
        owner: self;
        paneName: 'bitmapLabel';
        framingBlock: ( FramingParameters new iDUE: 119 @ 32; lDU: 384 r: #left; rDU: 503 r: #left; tDU: 80 r: #top; bDU: 112 r: #top);
        rightJustified;
        startGroup;
        contents: 'Bitmap:'.
    mainView addSubpane: bitmapLabel.
    
    textLabel "StaticText"
        owner: self;
        paneName: 'textLabel';
        framingBlock: ( FramingParameters new iDUE: 82 @ 32; lDU: 421 r: #left; rDU: 503 r: #left; tDU: 24 r: #top; bDU: 56 r: #top);
        rightJustified;
        startGroup;
        contents: 'Text:'.
    mainView addSubpane: textLabel.
    
    columnsLabel "StaticText"
        owner: self;
        paneName: 'columnsLabel';
        framingBlock: ( FramingParameters new iDUE: 155 @ 32; lDU: 27 r: #left; rDU: 183 r: #left; tDU: 120 r: #top; bDU: 152 r: #top);
        rightJustified;
        startGroup;
        contents: 'Columns:'.
    mainView addSubpane: columnsLabel.
    
    rowsLabel "StaticText"
        owner: self;
        paneName: 'rowsLabel';
        framingBlock: ( FramingParameters new iDUE: 155 @ 32; lDU: 27 r: #left; rDU: 183 r: #left; tDU: 56 r: #top; bDU: 88 r: #top);
        rightJustified;
        startGroup;
        contents: 'Rows:'.
    mainView addSubpane: rowsLabel.
    
    sizeGroup "GroupBox"
        owner: self;
        paneName: 'sizeGroup';
        framingBlock: ( FramingParameters new iDUE: 347 @ 168; lDU: 18 r: #left; rDU: 366 r: #left; tDU: 8 r: #top; bDU: 176 r: #top);
        startGroup;
        contents: 'Size'.
    mainView addSubpane: sizeGroup! !

"SP Dev Base Common (SP2ADEVW.SLL)"!
!'WBCPValueSetEditor' osiMethods !  
saveItemDetails

    | pane |
    (pane := self paneNamed: 'palette')
        cellAt: pane selection put: contents;
        cacheBitmap;
        invalidateRect: (
            (pane rectForCell: pane selection)
                insetBy: 3 ).! !

"SP Dev Base Common (SP2ADEVW.SLL)"!
!'WBTableColumnEditor' osiMethods !  
createViews

        " WARNING!! This method was automatically generated by 
        WindowBuilder. Code you add here which does not conform to 
        the WindowBuilder API will probably be lost the next time 
        you save your layout definition."

    | autoFieldWidth backColor backColorLabel cancel 
    cellTypeGroup centerJustified character characterLabel 
    colorGroup columnWidthLabel comboBoxCellType disabled 
    disabledLabel dropDownCellType fieldWidth font foreColor 
    foreColorLabel get headerLabel justificationGroup label 
    labelLabel leftJustified listLabel listMethod mainView menu 
    method name nameLabel next noAutoFieldWidth objectAccessors 
    ok previous readOnlyCellType rightJustified set setMethod 
    textEditCellType validation validationGroup validationLabel |
    
    mainView := self topPaneClass new.
    
        " Temporary Variables"
    autoFieldWidth := RadioButton new.
    backColor := WBComboBox new.
    backColorLabel := StaticText new.
    cancel := Button new.
    cellTypeGroup := GroupBox new.
    centerJustified := RadioButton new.
    character := WBComboBox new.
    characterLabel := StaticText new.
    colorGroup := GroupBox new.
    columnWidthLabel := GroupBox new.
    comboBoxCellType := RadioButton new.
    disabled := WBComboBox new.
    disabledLabel := StaticText new.
    dropDownCellType := RadioButton new.
    fieldWidth := CPNumericEditor new.
    font := Button new.
    foreColor := WBComboBox new.
    foreColorLabel := StaticText new.
    get := StaticText new.
    headerLabel := GroupBox new.
    justificationGroup := GroupBox new.
    label := TextEdit new.
    labelLabel := StaticText new.
    leftJustified := RadioButton new.
    listLabel := StaticText new.
    listMethod := WBEntryField new.
    menu := Button new.
    method := WBEntryField new.
    name := WBEntryField new.
    nameLabel := StaticText new.
    next := Button new.
    noAutoFieldWidth := RadioButton new.
    objectAccessors := GroupBox new.
    ok := Button new.
    previous := Button new.
    readOnlyCellType := RadioButton new.
    rightJustified := RadioButton new.
    set := StaticText new.
    setMethod := WBEntryField new.
    textEditCellType := RadioButton new.
    validation := WBComboBox new.
    validationGroup := GroupBox new.
    validationLabel := StaticText new.
    
    mainView "WBTableColumnEditor"
        owner: self;
        paneName: 'mainView';
        labelWithoutPrefix:  'Column Editor';
        noSmalltalkMenuBar;
        framingBlock: ( FramingParameters new iDUE: 1253 @ 728; xC; yC; cRDU: (0 @ 0 rightBottom: 1253 @ 728));
        pStyle: #(sysmenu modal titlebar).
    self addView: mainView.
    
    character "WBComboBox"
        owner: self;
        paneName: 'character';
        framingBlock: ( FramingParameters new iDUE: 393 @ 280; lDU: 201 r: #left; rDU: 594 r: #left; tDU: 48 r: #top; bDU: 328 r: #top);
        dropDownList;
        startGroup;
        tabStop;
        when: #clicked: send: #columnChanged: to: self.
    mainView addSubpane: character.
    
    validation "WBComboBox"
        owner: self;
        paneName: 'validation';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 393 @ 208; lDU: 201 r: #left; rDU: 594 r: #left; tDU: 104 r: #top; bDU: 312 r: #top);
        dropDownList;
        startGroup;
        tabStop;
        when: #clicked: send: #columnChanged: to: self.
    mainView addSubpane: validation.
    
    method "WBEntryField"
        owner: self;
        paneName: 'method';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 393 @ 48; lDU: 201 r: #left; rDU: 594 r: #left; tDU: 216 r: #top; bDU: 264 r: #top; indent: 3 @ 4);
        startGroup;
        tabStop;
        when: #textChanged: send: #columnChanged: to: self.
    mainView addSubpane: method.
    
    setMethod "WBEntryField"
        owner: self;
        paneName: 'setMethod';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 393 @ 48; lDU: 201 r: #left; rDU: 594 r: #left; tDU: 272 r: #top; bDU: 320 r: #top; indent: 3 @ 4);
        startGroup;
        tabStop;
        when: #textChanged: send: #columnChanged: to: self.
    mainView addSubpane: setMethod.
    
    disabled "WBComboBox"
        owner: self;
        paneName: 'disabled';
        framingBlock: ( FramingParameters new iDUE: 393 @ 272; lDU: 201 r: #left; rDU: 594 r: #left; tDU: 328 r: #top; bDU: 600 r: #top);
        dropDown;
        startGroup;
        tabStop;
        when: #textChanged: send: #columnChanged: to: self;
        when: #needsContents send: #loadDisabled: to: self withArgument: disabled.
    mainView addSubpane: disabled.
    
    foreColor "WBComboBox"
        owner: self;
        paneName: 'foreColor';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 393 @ 264; lDU: 183 r: #left; rDU: 576 r: #left; tDU: 416 r: #top; bDU: 680 r: #top);
        dropDown;
        startGroup;
        tabStop;
        when: #textChanged: send: #columnChanged: to: self.
    mainView addSubpane: foreColor.
    
    backColor "WBComboBox"
        owner: self;
        paneName: 'backColor';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 393 @ 272; lDU: 183 r: #left; rDU: 576 r: #left; tDU: 472 r: #top; bDU: 744 r: #top);
        dropDown;
        startGroup;
        tabStop;
        when: #textChanged: send: #columnChanged: to: self.
    mainView addSubpane: backColor.
    
    name "WBEntryField"
        owner: self;
        paneName: 'name';
        framingBlock: ( FramingParameters new iDUE: 402 @ 48; lDU: 805 r: #left; rDU: 1207 r: #left; tDU: 40 r: #top; bDU: 88 r: #top; indent: 3 @ 4);
        startGroup;
        tabStop;
        when: #textChanged: send: #columnChanged: to: self.
    mainView addSubpane: name.
    
    readOnlyCellType "RadioButton"
        owner: self;
        paneName: 'readOnlyCellType';
        framingBlock: ( FramingParameters new iDUE: 201 @ 40; lDU: 704 r: #left; rDU: 905 r: #left; tDU: 264 r: #top; bDU: 304 r: #top);
        startGroup;
        when: #clicked: send: #cellType:pane: to: self withArgument: readOnlyCellType;
        contents: 'Read Only'.
    mainView addSubpane: readOnlyCellType.
    
    textEditCellType "RadioButton"
        owner: self;
        paneName: 'textEditCellType';
        framingBlock: ( FramingParameters new iDUE: 174 @ 40; lDU: 704 r: #left; rDU: 878 r: #left; tDU: 304 r: #top; bDU: 344 r: #top);
        when: #clicked: send: #cellType:pane: to: self withArgument: textEditCellType;
        contents: 'Text Edit'.
    mainView addSubpane: textEditCellType.
    
    dropDownCellType "RadioButton"
        owner: self;
        paneName: 'dropDownCellType';
        framingBlock: ( FramingParameters new iDUE: 210 @ 40; lDU: 951 r: #left; rDU: 1161 r: #left; tDU: 264 r: #top; bDU: 304 r: #top);
        when: #clicked: send: #cellType:pane: to: self withArgument: dropDownCellType;
        contents: 'Drop Down'.
    mainView addSubpane: dropDownCellType.
    
    comboBoxCellType "RadioButton"
        owner: self;
        paneName: 'comboBoxCellType';
        framingBlock: ( FramingParameters new iDUE: 219 @ 40; lDU: 951 r: #left; rDU: 1170 r: #left; tDU: 304 r: #top; bDU: 344 r: #top);
        when: #clicked: send: #cellType:pane: to: self withArgument: comboBoxCellType;
        contents: 'Combo Box'.
    mainView addSubpane: comboBoxCellType.
    
    leftJustified "RadioButton"
        owner: self;
        paneName: 'leftJustified';
        framingBlock: ( FramingParameters new iDUE: 117 @ 40; lDU: 704 r: #left; rDU: 821 r: #left; tDU: 472 r: #top; bDU: 512 r: #top);
        startGroup;
        when: #clicked: send: #columnChanged: to: self;
        contents: '&Left'.
    mainView addSubpane: leftJustified.
    
    centerJustified "RadioButton"
        owner: self;
        paneName: 'centerJustified';
        framingBlock: ( FramingParameters new iDUE: 160 @ 40; lDU: 704 r: #left; rDU: 864 r: #left; tDU: 520 r: #top; bDU: 560 r: #top);
        when: #clicked: send: #columnChanged: to: self;
        contents: 'Ce&nter'.
    mainView addSubpane: centerJustified.
    
    rightJustified "RadioButton"
        owner: self;
        paneName: 'rightJustified';
        framingBlock: ( FramingParameters new iDUE: 139 @ 40; lDU: 704 r: #left; rDU: 843 r: #left; tDU: 568 r: #top; bDU: 608 r: #top);
        when: #clicked: send: #columnChanged: to: self;
        contents: '&Right'.
    mainView addSubpane: rightJustified.
    
    autoFieldWidth "RadioButton"
        owner: self;
        paneName: 'autoFieldWidth';
        framingBlock: ( FramingParameters new iDUE: 128 @ 40; lDU: 1006 r: #left; rDU: 1134 r: #left; tDU: 472 r: #top; bDU: 512 r: #top);
        startGroup;
        when: #clicked: send: #autoFieldWidth: to: self;
        contents: '&Auto'.
    mainView addSubpane: autoFieldWidth.
    
    noAutoFieldWidth "RadioButton"
        owner: self;
        paneName: 'noAutoFieldWidth';
        framingBlock: ( FramingParameters new iDUE: 146 @ 40; lDU: 1006 r: #left; rDU: 1152 r: #left; tDU: 520 r: #top; bDU: 560 r: #top);
        when: #clicked: send: #noAutoFieldWidth: to: self;
        contents: 'Chars:'.
    mainView addSubpane: noAutoFieldWidth.
    
    fieldWidth "CPNumericEditor"
        owner: self;
        paneName: 'fieldWidth';
        framingBlock: ( FramingParameters new iDUE: 155 @ 48; lDU: 1051 r: #left; tDU: 568 r: #top);
        startGroup;
        tabStop;
        when: #valueChanged: send: #columnChanged: to: self.
    mainView addSubpane: fieldWidth.
    
    font "Button"
        owner: self;
        paneName: 'font';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 283 @ 64; lDU: 27 r: #left; rDU: 311 r: #left; tDU: 568 r: #top; bDU: 632 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #setFont to: self;
        contents: '&Font...'.
    mainView addSubpane: font.
    
    menu "Button"
        owner: self;
        paneName: 'menu';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 283 @ 64; lDU: 329 r: #left; rDU: 613 r: #left; tDU: 568 r: #top; bDU: 632 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #setMenu to: self;
        contents: '&Menu...'.
    mainView addSubpane: menu.
    
    previous "Button"
        owner: self;
        paneName: 'previous';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 283 @ 64; lDU: 27 r: #left; rDU: 311 r: #left; tDU: 648 r: #top; bDU: 712 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #previousField to: self;
        contents: 'Previous'.
    mainView addSubpane: previous.
    
    next "Button"
        owner: self;
        paneName: 'next';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 283 @ 64; lDU: 329 r: #left; rDU: 613 r: #left; tDU: 648 r: #top; bDU: 712 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #nextField to: self;
        contents: 'Next'.
    mainView addSubpane: next.
    
    ok "Button"
        owner: self;
        paneName: 'ok';
        framingBlock: ( FramingParameters new iDUE: 274 @ 64; lDU: 649 r: #left; rDU: 923 r: #left; tDU: 648 r: #top; bDU: 712 r: #top);
        defaultPushButton;
        startGroup;
        tabStop;
        when: #clicked send: #ok to: self;
        contents: 'OK'.
    mainView addSubpane: ok.
    
    cancel "Button"
        owner: self;
        paneName: 'cancel';
        framingBlock: ( FramingParameters new iDUE: 274 @ 64; lDU: 960 r: #left; rDU: 1234 r: #left; tDU: 648 r: #top; bDU: 712 r: #top);
        cancelPushButton;
        startGroup;
        tabStop;
        when: #clicked send: #cancel to: self;
        contents: 'Cancel'.
    mainView addSubpane: cancel.
    
    get "StaticText"
        owner: self;
        paneName: 'get';
        framingBlock: ( FramingParameters new iDUE: 73 @ 32; lDU: 119 r: #left; rDU: 192 r: #left; tDU: 224 r: #top; bDU: 256 r: #top);
        rightJustified;
        startGroup;
        contents: 'Get:'.
    mainView addSubpane: get.
    
    set "StaticText"
        owner: self;
        paneName: 'set';
        framingBlock: ( FramingParameters new iDUE: 73 @ 32; lDU: 119 r: #left; rDU: 192 r: #left; tDU: 280 r: #top; bDU: 312 r: #top);
        rightJustified;
        startGroup;
        contents: 'Set:'.
    mainView addSubpane: set.
    
    validationLabel "StaticText"
        owner: self;
        paneName: 'validationLabel';
        framingBlock: ( FramingParameters new iDUE: 91 @ 32; lDU: 101 r: #left; rDU: 192 r: #left; tDU: 112 r: #top; bDU: 144 r: #top);
        rightJustified;
        startGroup;
        contents: 'Field:'.
    mainView addSubpane: validationLabel.
    
    characterLabel "StaticText"
        owner: self;
        paneName: 'characterLabel';
        framingBlock: ( FramingParameters new iDUE: 91 @ 32; lDU: 101 r: #left; rDU: 192 r: #left; tDU: 56 r: #top; bDU: 88 r: #top);
        rightJustified;
        startGroup;
        contents: 'Char:'.
    mainView addSubpane: characterLabel.
    
    backColorLabel "StaticText"
        owner: self;
        paneName: 'backColorLabel';
        framingBlock: ( FramingParameters new iDUE: 91 @ 32; lDU: 82 r: #left; rDU: 174 r: #left; tDU: 480 r: #top; bDU: 512 r: #top);
        rightJustified;
        startGroup;
        contents: 'Back:'.
    mainView addSubpane: backColorLabel.
    
    foreColorLabel "StaticText"
        owner: self;
        paneName: 'foreColorLabel';
        framingBlock: ( FramingParameters new iDUE: 91 @ 32; lDU: 82 r: #left; rDU: 174 r: #left; tDU: 424 r: #top; bDU: 456 r: #top);
        rightJustified;
        startGroup;
        contents: 'Fore:'.
    mainView addSubpane: foreColorLabel.
    
    disabledLabel "StaticText"
        owner: self;
        paneName: 'disabledLabel';
        framingBlock: ( FramingParameters new iDUE: 155 @ 32; lDU: 37 r: #left; rDU: 192 r: #left; tDU: 336 r: #top; bDU: 368 r: #top);
        rightJustified;
        startGroup;
        contents: 'Disabled:'.
    mainView addSubpane: disabledLabel.
    
    label "TextEdit"
        owner: self;
        paneName: 'label';
        framingBlock: ( FramingParameters new iDUE: 402 @ 96; lDU: 805 r: #left; rDU: 1207 r: #left; tDU: 104 r: #top; bDU: 200 r: #top);
        removeHorizontalScrollbarStyle;
       addVerticalScrollbarStyle;
       addBorderStyle;
        startGroup.
    mainView addSubpane: label.
    
    labelLabel "StaticText"
        owner: self;
        paneName: 'labelLabel';
        framingBlock: ( FramingParameters new iDUE: 105 @ 32; lDU: 686 r: #left; rDU: 791 r: #left; tDU: 104 r: #top; bDU: 136 r: #top);
        rightJustified;
        startGroup;
        contents: 'Label:'.
    mainView addSubpane: labelLabel.
    
    nameLabel "StaticText"
        owner: self;
        paneName: 'nameLabel';
        framingBlock: ( FramingParameters new iDUE: 105 @ 32; lDU: 686 r: #left; rDU: 791 r: #left; tDU: 48 r: #top; bDU: 80 r: #top);
        rightJustified;
        startGroup;
        contents: 'Name:'.
    mainView addSubpane: nameLabel.
    
    listLabel "StaticText"
        owner: self;
        paneName: 'listLabel';
        framingBlock: ( FramingParameters new iDUE: 73 @ 32; lDU: 677 r: #left; rDU: 750 r: #left; tDU: 368 r: #top; bDU: 400 r: #top);
        startGroup;
        contents: 'List:'.
    mainView addSubpane: listLabel.
    
    listMethod "WBEntryField"
        owner: self;
        paneName: 'listMethod';
        framingBlock: ( FramingParameters new iDUE: 457 @ 48; lDU: 759 r: #left; rDU: 1216 r: #left; tDU: 360 r: #top; bDU: 408 r: #top; indent: 3 @ 4);
        startGroup;
        when: #textChanged: send: #columnChanged: to: self.
    mainView addSubpane: listMethod.
    
    validationGroup "GroupBox"
        owner: self;
        paneName: 'validationGroup';
        framingBlock: ( FramingParameters new iDUE: 585 @ 160; lDU: 27 r: #left; rDU: 613 r: #left; tDU: 8 r: #top; bDU: 168 r: #top);
        startGroup;
        contents: 'Validations'.
    mainView addSubpane: validationGroup.
    
    colorGroup "GroupBox"
        owner: self;
        paneName: 'colorGroup';
        framingBlock: ( FramingParameters new iDUE: 549 @ 160; lDU: 46 r: #left; rDU: 594 r: #left; tDU: 376 r: #top; bDU: 536 r: #top);
        startGroup;
        contents: 'Color'.
    mainView addSubpane: colorGroup.
    
    objectAccessors "GroupBox"
        owner: self;
        paneName: 'objectAccessors';
        framingBlock: ( FramingParameters new iDUE: 585 @ 376; lDU: 27 r: #left; rDU: 613 r: #left; tDU: 176 r: #top; bDU: 552 r: #top);
        startGroup;
        contents: 'Object Methods'.
    mainView addSubpane: objectAccessors.
    
    headerLabel "GroupBox"
        owner: self;
        paneName: 'headerLabel';
        framingBlock: ( FramingParameters new iDUE: 585 @ 208; lDU: 649 r: #left; rDU: 1234 r: #left; tDU: 8 r: #top; bDU: 216 r: #top);
        startGroup;
        contents: 'Header'.
    mainView addSubpane: headerLabel.
    
    cellTypeGroup "GroupBox"
        owner: self;
        paneName: 'cellTypeGroup';
        framingBlock: ( FramingParameters new iDUE: 585 @ 200; lDU: 649 r: #left; rDU: 1234 r: #left; tDU: 224 r: #top; bDU: 424 r: #top);
        startGroup;
        contents: 'Cell Type'.
    mainView addSubpane: cellTypeGroup.
    
    justificationGroup "GroupBox"
        owner: self;
        paneName: 'justificationGroup';
        framingBlock: ( FramingParameters new iDUE: 274 @ 200; lDU: 649 r: #left; rDU: 923 r: #left; tDU: 432 r: #top; bDU: 632 r: #top);
        startGroup;
        contents: 'Justification'.
    mainView addSubpane: justificationGroup.
    
    columnWidthLabel "GroupBox"
        owner: self;
        paneName: 'columnWidthLabel';
        framingBlock: ( FramingParameters new iDUE: 274 @ 200; lDU: 960 r: #left; rDU: 1234 r: #left; tDU: 432 r: #top; bDU: 632 r: #top);
        startGroup;
        contents: 'Column Width'.
    mainView addSubpane: columnWidthLabel! !

"SP Dev Base Common (SP2ADEVW.SLL)"!
!'WBTableColumnEditor' osiMethods !  
updateSelectedItem

    | value selector justification function |

    value := (self paneNamed: 'name') contents.
    value = '' ifTrue: [ value := nil ].
    selectedField name: value.

    value := (self paneNamed: 'disabled') text asString.
    value isEmpty ifTrue: [ value := nil ].
    value =  'true' ifTrue: [ value := true ].
    value = 'false' ifTrue: [ value := false ].
    value isString ifTrue: [
        (self isLegitimateSymbol: value) ifFalse: [
            MessageBox message: value , ' is not a valid method name'.
            ^false].
        value := value asSymbol ].
    selectedField disabled: value.

    (self paneNamed: 'readOnlyCellType') selection
        ifTrue: [
            value := false.
            selector := nil ].
    (self paneNamed: 'textEditCellType') selection
        ifTrue: [
            value := true.
            selector := nil ].
    (self paneNamed: 'dropDownCellType') selection
        ifTrue: [
            value := false.
            selector := (self paneNamed: 'listMethod') contents ].
    (self paneNamed: 'comboBoxCellType') selection
        ifTrue: [
            value := true.
            selector := (self paneNamed: 'listMethod') contents ].
    selector notNil
        ifTrue: [
            (self isLegitimateSymbol: selector)
                ifFalse: [
                    MessageBox message: selector , ' is not a valid method name'.
                    ^false ].
            selector := selector isEmpty
                ifTrue: [ nil ]
                ifFalse: [ selector asSymbol ]].
    selectedField
        textEdit: value;
        list: selector.

    selector := (self paneNamed: 'setMethod') contents.
    (self isLegitimateSymbol: selector)
        ifFalse:
            [MessageBox message: selector , ' is not a valid method name'.
            ^false].
    selector isEmpty
        ifTrue:
            [selector := nil.
            ].
    selectedField setSelector: selector.

    function := (self paneNamed: 'character') selectedItem.
    (function isNil or: [function = self noneString])
        ifTrue: [selectedField character: nil]
        ifFalse: [selectedField character: ('ok' , function , ':') asSymbol].

    function := (self paneNamed: 'validation') selectedItem.
    (function isNil or: [function = self noneString])
        ifTrue: [selectedField validation: nil]
        ifFalse: [selectedField validation: ('ok' , function) asSymbol].

    value := (self paneNamed: 'foreColor') text asString.
    value := value isEmpty
        ifTrue: [ nil ]
        ifFalse: [
            Color defaultColorClass defaultColors at: value asSymbol ifAbsent: [
                Color defaultColorClass defaultColors at:
                    (value copy at: 1 put: value first asLowercase; yourself) asSymbol ifAbsent: [
                    (self isLegitimateSymbol: value) ifFalse: [
                        MessageBox message: value , ' is not a valid color or method name'.
                        ^false].
                    value asSymbol ]]].
    selectedField foreColor: value.

    value := (self paneNamed: 'backColor') text asString.
    value := value isEmpty
        ifTrue: [ nil ]
        ifFalse: [
            Color defaultColorClass defaultColors at: value asSymbol ifAbsent: [
                Color defaultColorClass defaultColors at:
                    (value copy at: 1 put: value first asLowercase; yourself) asSymbol ifAbsent: [
                    (self isLegitimateSymbol: value) ifFalse: [
                        MessageBox message: value , ' is not a valid color or method name'.
                        ^false].
                    value asSymbol ]]].
    selectedField backColor: value.

    ^super updateSelectedItem! !

"SP Dev Base Common (SP2ADEVW.SLL)"!
!'WBTableEditorEditor' osiMethods !  
createViews

        " WARNING!! This method was automatically generated by 
        WindowBuilder. Code you add here which does not conform to 
        the WindowBuilder API will probably be lost the next time 
        you save your layout definition."

    | cancel cellWidth cellWidthLabel colors colorsLabel 
    columns columnsLabel mainView ok optionsGroup rows 
    rowsLabel showColumnHeader showGrid showRowHeader 
    sizesGroup sparseStorage |
    
    mainView := self topPaneClass new.
    
        " Temporary Variables"
    cancel := Button new.
    cellWidth := CPNumericEditor new.
    cellWidthLabel := StaticText new.
    colors := WBComboBox new.
    colorsLabel := StaticText new.
    columns := CPNumericEditor new.
    columnsLabel := StaticText new.
    ok := Button new.
    optionsGroup := GroupBox new.
    rows := CPNumericEditor new.
    rowsLabel := StaticText new.
    showColumnHeader := CheckBox new.
    showGrid := CheckBox new.
    showRowHeader := CheckBox new.
    sizesGroup := GroupBox new.
    sparseStorage := CheckBox new.
    
    mainView "WBTableEditorEditor"
        owner: self;
        paneName: 'mainView';
        labelWithoutPrefix:  'CPTableEditor Editor';
        noSmalltalkMenuBar;
        framingBlock: ( FramingParameters new iDUE: 814 @ 296; xC; yC; cRDU: (0 @ 0 rightBottom: 814 @ 296));
        pStyle: #(sysmenu modal titlebar).
    self addView: mainView.
    
    rows "CPNumericEditor"
        owner: self;
        paneName: 'rows';
        framingBlock: ( FramingParameters new iDUE: 135 @ 48; lDU: 219 r: #left; tDU: 48 r: #top);
        min: 1;
        max: 1000;
        contents: 1;
        startGroup;
        tabStop.
    mainView addSubpane: rows.
    
    columns "CPNumericEditor"
        owner: self;
        paneName: 'columns';
        framingBlock: ( FramingParameters new iDUE: 135 @ 48; lDU: 219 r: #left; tDU: 104 r: #top);
        min: 1;
        max: 600;
        contents: 1;
        startGroup;
        tabStop.
    mainView addSubpane: columns.
    
    cellWidth "CPNumericEditor"
        owner: self;
        paneName: 'cellWidth';
        framingBlock: ( FramingParameters new iDUE: 135 @ 48; lDU: 219 r: #left; tDU: 160 r: #top);
        max: 8000;
        startGroup;
        tabStop.
    mainView addSubpane: cellWidth.
    
    showRowHeader "CheckBox"
        owner: self;
        paneName: 'showRowHeader';
        framingBlock: ( FramingParameters new iDUE: 315 @ 40; lDU: 411 r: #left; rDU: 727 r: #left; tDU: 48 r: #top; bDU: 88 r: #top);
        startGroup;
        tabStop;
        contents: 'Show Row Header'.
    mainView addSubpane: showRowHeader.
    
    showColumnHeader "CheckBox"
        owner: self;
        paneName: 'showColumnHeader';
        framingBlock: ( FramingParameters new iDUE: 363 @ 40; lDU: 411 r: #left; rDU: 775 r: #left; tDU: 88 r: #top; bDU: 128 r: #top);
        startGroup;
        tabStop;
        contents: 'Show Column Header'.
    mainView addSubpane: showColumnHeader.
    
    showGrid "CheckBox"
        owner: self;
        paneName: 'showGrid';
        framingBlock: ( FramingParameters new iDUE: 197 @ 40; lDU: 411 r: #left; rDU: 608 r: #left; tDU: 128 r: #top; bDU: 168 r: #top);
        startGroup;
        tabStop;
        contents: 'Show Grid'.
    mainView addSubpane: showGrid.
    
    sparseStorage "CheckBox"
        owner: self;
        paneName: 'sparseStorage';
        framingBlock: ( FramingParameters new iDUE: 274 @ 40; lDU: 411 r: #left; rDU: 686 r: #left; tDU: 168 r: #top; bDU: 208 r: #top);
        startGroup;
        tabStop;
        contents: 'Sparse Storage'.
    mainView addSubpane: sparseStorage.
    
    colors "WBComboBox"
        owner: self;
        paneName: 'colors';
        framingBlock: ( FramingParameters new iDUE: 240 @ 190; lDU: 558 r: #left; rDU: 798 r: #left; tDU: 232 r: #top; bDU: 422 r: #top);
        dropDownList;
        startGroup;
        tabStop.
    mainView addSubpane: colors.
    
    ok "Button"
        owner: self;
        paneName: 'ok';
        framingBlock: ( FramingParameters new iDUE: 146 @ 56; lDU: 18 r: #left; rDU: 165 r: #left; tDU: 232 r: #top; bDU: 288 r: #top);
        defaultPushButton;
        defaultPushButton;
        startGroup;
        tabStop;
        when: #clicked send: #ok to: self;
        contents: '&OK'.
    mainView addSubpane: ok.
    
    cancel "Button"
        owner: self;
        paneName: 'cancel';
        framingBlock: ( FramingParameters new iDUE: 146 @ 56; lDU: 174 r: #left; rDU: 320 r: #left; tDU: 232 r: #top; bDU: 288 r: #top);
        cancelPushButton;
        startGroup;
        tabStop;
        when: #clicked send: #cancel to: self;
        contents: '&Cancel'.
    mainView addSubpane: cancel.
    
    rowsLabel "StaticText"
        owner: self;
        paneName: 'rowsLabel';
        framingBlock: ( FramingParameters new iDUE: 174 @ 32; lDU: 37 r: #left; rDU: 210 r: #left; tDU: 56 r: #top; bDU: 88 r: #top);
        rightJustified;
        startGroup;
        contents: 'Rows:'.
    mainView addSubpane: rowsLabel.
    
    columnsLabel "StaticText"
        owner: self;
        paneName: 'columnsLabel';
        framingBlock: ( FramingParameters new iDUE: 174 @ 32; lDU: 37 r: #left; rDU: 210 r: #left; tDU: 112 r: #top; bDU: 144 r: #top);
        rightJustified;
        startGroup;
        contents: 'Columns:'.
    mainView addSubpane: columnsLabel.
    
    colorsLabel "StaticText"
        owner: self;
        paneName: 'colorsLabel';
        framingBlock: ( FramingParameters new iDUE: 210 @ 32; lDU: 338 r: #left; rDU: 549 r: #left; tDU: 240 r: #top; bDU: 272 r: #top);
        rightJustified;
        startGroup;
        contents: 'Header Color:'.
    mainView addSubpane: colorsLabel.
    
    cellWidthLabel "StaticText"
        owner: self;
        paneName: 'cellWidthLabel';
        framingBlock: ( FramingParameters new iDUE: 174 @ 32; lDU: 37 r: #left; rDU: 210 r: #left; tDU: 168 r: #top; bDU: 200 r: #top);
        rightJustified;
        startGroup;
        contents: 'Cell Width:'.
    mainView addSubpane: cellWidthLabel.
    
    sizesGroup "GroupBox"
        owner: self;
        paneName: 'sizesGroup';
        framingBlock: ( FramingParameters new iDUE: 357 @ 216; lDU: 18 r: #left; rDU: 375 r: #left; tDU: 8 r: #top; bDU: 224 r: #top);
        startGroup;
        contents: 'Sizes'.
    mainView addSubpane: sizesGroup.
    
    optionsGroup "GroupBox"
        owner: self;
        paneName: 'optionsGroup';
        framingBlock: ( FramingParameters new iDUE: 402 @ 216; lDU: 393 r: #left; rDU: 795 r: #left; tDU: 8 r: #top; bDU: 224 r: #top);
        startGroup;
        contents: 'Options'.
    mainView addSubpane: optionsGroup! !

"SP Dev Base Common (SP2ADEVW.SLL)"!
!'WBTablePaneEditor' osiMethods !  
createViews

        " WARNING!! This method was automatically generated by 
        WindowBuilder. Code you add here which does not conform to 
        the WindowBuilder API will probably be lost the next time 
        you save your layout definition."

    | backLabel cancel canReorder canReorderRows canResize 
    canSort cellSelectMode color colorGroup colorMethod 
    contentsGroup delete disabled disabledBackColor 
    disabledForeColor disabledGroup disableMethod down edit 
    extendedSelectMode foreLabel headerColor headerColorLabel 
    insert itemsList labelMeth labelMethod labelsGroup mainView 
    matrix multiSelectMode numRows objectMethods objects ok 
    optionsGroup reorderGroup rows selectionGroup separator 
    showColumnHeaders showGrid showRowHeaders singleSelectMode 
    sparseStorage up |
    
    mainView := self topPaneClass new.
    
        " Temporary Variables"
    backLabel := StaticText new.
    cancel := Button new.
    canReorder := CheckBox new.
    canReorderRows := CheckBox new.
    canResize := CheckBox new.
    canSort := CheckBox new.
    cellSelectMode := RadioButton new.
    color := StaticText new.
    colorGroup := GroupBox new.
    colorMethod := WBEntryField new.
    contentsGroup := GroupBox new.
    delete := Button new.
    disabled := StaticText new.
    disabledBackColor := WBComboBox new.
    disabledForeColor := WBComboBox new.
    disabledGroup := GroupBox new.
    disableMethod := WBEntryField new.
    down := Button new.
    edit := Button new.
    extendedSelectMode := RadioButton new.
    foreLabel := StaticText new.
    headerColor := WBComboBox new.
    headerColorLabel := StaticText new.
    insert := Button new.
    itemsList := ListBox new.
    labelMeth := StaticText new.
    labelMethod := WBEntryField new.
    labelsGroup := GroupBox new.
    matrix := RadioButton new.
    multiSelectMode := RadioButton new.
    numRows := StaticText new.
    objectMethods := GroupBox new.
    objects := RadioButton new.
    ok := Button new.
    optionsGroup := GroupBox new.
    reorderGroup := GroupBox new.
    rows := CPNumericEditor new.
    selectionGroup := GroupBox new.
    separator := StaticBox new.
    showColumnHeaders := CheckBox new.
    showGrid := CheckBox new.
    showRowHeaders := CheckBox new.
    singleSelectMode := RadioButton new.
    sparseStorage := RadioButton new.
    up := Button new.
    
    mainView "WBTablePaneEditor"
        owner: self;
        paneName: 'mainView';
        labelWithoutPrefix:  'CPTablePane Editor';
        noSmalltalkMenuBar;
        framingBlock: ( FramingParameters new iDUE: 1335 @ 684; xC; yC; cRDU: (0 @ 0 rightBottom: 1335 @ 684));
        pStyle: #(sysmenu modal titlebar).
    self addView: mainView.
    
    separator "StaticBox"
        owner: self;
        paneName: 'separator';
        framingBlock: ( FramingParameters new iDUE: 265 @ 4; lDU: 503 r: #left; rDU: 768 r: #left; tDU: 480 r: #top; bDU: 484 r: #top);
        blackRectangle;
        startGroup.
    mainView addSubpane: separator.
    
    objects "RadioButton"
        owner: self;
        paneName: 'objects';
        framingBlock: ( FramingParameters new iDUE: 158 @ 40; lDU: 55 r: #left; rDU: 213 r: #left; tDU: 48 r: #top; bDU: 88 r: #top);
        startGroup;
        when: #clicked: send: #setObjectType: to: self;
        contents: 'Objects'.
    mainView addSubpane: objects.
    
    matrix "RadioButton"
        owner: self;
        paneName: 'matrix';
        framingBlock: ( FramingParameters new iDUE: 144 @ 40; lDU: 265 r: #left; rDU: 409 r: #left; tDU: 48 r: #top; bDU: 88 r: #top);
        when: #clicked: send: #setContentType: to: self;
        contents: 'Matrix'.
    mainView addSubpane: matrix.
    
    sparseStorage "RadioButton"
        owner: self;
        paneName: 'sparseStorage';
        framingBlock: ( FramingParameters new iDUE: 272 @ 40; lDU: 457 r: #left; rDU: 729 r: #left; tDU: 48 r: #top; bDU: 88 r: #top);
        when: #clicked: send: #setContentType: to: self;
        contents: 'Sparse Storage'.
    mainView addSubpane: sparseStorage.
    
    itemsList "ListBox"
        owner: self;
        paneName: 'itemsList';
        framingBlock: ( FramingParameters new iDUE: 457 @ 256; lDU: 18 r: #left; tDU: 128 r: #top);
        startGroup;
        tabStop;
        when: #needsContents send: #loadListContents to: self;
        when: #changedIndex: send: #selectedField: to: self.
    mainView addSubpane: itemsList.
    
    rows "CPNumericEditor"
        owner: self;
        paneName: 'rows';
        framingBlock: ( FramingParameters new iDUE: 265 @ 48; lDU: 210 r: #left; tDU: 400 r: #top);
        min: 1;
        max: 1000;
        contents: 1;
        startGroup;
        tabStop.
    mainView addSubpane: rows.
    
    colorMethod "WBEntryField"
        owner: self;
        paneName: 'colorMethod';
        framingBlock: ( FramingParameters new iDUE: 256 @ 48; lDU: 201 r: #left; rDU: 457 r: #left; tDU: 488 r: #top; bDU: 536 r: #top; indent: 3 @ 4);
        startGroup;
        tabStop.
    mainView addSubpane: colorMethod.
    
    disableMethod "WBEntryField"
        owner: self;
        paneName: 'disableMethod';
        framingBlock: ( FramingParameters new iDUE: 256 @ 48; lDU: 201 r: #left; rDU: 457 r: #left; tDU: 544 r: #top; bDU: 592 r: #top; indent: 3 @ 4);
        startGroup;
        tabStop.
    mainView addSubpane: disableMethod.
    
    labelMethod "WBEntryField"
        owner: self;
        paneName: 'labelMethod';
        framingBlock: ( FramingParameters new iDUE: 256 @ 48; lDU: 201 r: #left; rDU: 457 r: #left; tDU: 600 r: #top; bDU: 648 r: #top; indent: 3 @ 4);
        startGroup;
        tabStop.
    mainView addSubpane: labelMethod.
    
    insert "Button"
        owner: self;
        paneName: 'insert';
        framingBlock: ( FramingParameters new iDUE: 265 @ 72; lDU: 503 r: #left; rDU: 768 r: #left; tDU: 128 r: #top; bDU: 200 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #insertItem to: self;
        contents: '&Insert'.
    mainView addSubpane: insert.
    
    delete "Button"
        owner: self;
        paneName: 'delete';
        framingBlock: ( FramingParameters new iDUE: 267 @ 72; lDU: 503 r: #left; rDU: 770 r: #left; tDU: 216 r: #top; bDU: 288 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #deleteItem to: self;
        contents: 'D&elete'.
    mainView addSubpane: delete.
    
    up "Button"
        owner: self;
        paneName: 'up';
        framingBlock: ( FramingParameters new iDUE: 123 @ 72; lDU: 503 r: #left; rDU: 626 r: #left; tDU: 304 r: #top; bDU: 376 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #moveUp to: self;
        contents: '&Up'.
    mainView addSubpane: up.
    
    down "Button"
        owner: self;
        paneName: 'down';
        framingBlock: ( FramingParameters new iDUE: 123 @ 72; lDU: 649 r: #left; rDU: 773 r: #left; tDU: 304 r: #top; bDU: 376 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #moveDown to: self;
        contents: '&Down'.
    mainView addSubpane: down.
    
    edit "Button"
        owner: self;
        paneName: 'edit';
        framingBlock: ( FramingParameters new iDUE: 265 @ 72; lDU: 503 r: #left; rDU: 768 r: #left; tDU: 392 r: #top; bDU: 464 r: #top);
        startGroup;
        tabStop;
        when: #clicked send: #editItem to: self;
        contents: 'Edit...'.
    mainView addSubpane: edit.
    
    showGrid "CheckBox"
        owner: self;
        paneName: 'showGrid';
        framingBlock: ( FramingParameters new iDUE: 208 @ 40; lDU: 832 r: #left; rDU: 1040 r: #left; tDU: 56 r: #top; bDU: 96 r: #top);
        startGroup;
        tabStop;
        contents: 'Show &Grid'.
    mainView addSubpane: showGrid.
    
    canSort "CheckBox"
        owner: self;
        paneName: 'canSort';
        framingBlock: ( FramingParameters new iDUE: 174 @ 40; lDU: 1079 r: #left; rDU: 1253 r: #left; tDU: 32 r: #top; bDU: 72 r: #top);
        startGroup;
        tabStop;
        contents: 'Can Sort'.
    mainView addSubpane: canSort.
    
    canResize "CheckBox"
        owner: self;
        paneName: 'canResize';
        framingBlock: ( FramingParameters new iDUE: 217 @ 40; lDU: 1079 r: #left; rDU: 1296 r: #left; tDU: 72 r: #top; bDU: 112 r: #top);
        startGroup;
        tabStop;
        contents: 'Can Re&size'.
    mainView addSubpane: canResize.
    
    canReorder "CheckBox"
        owner: self;
        paneName: 'canReorder';
        framingBlock: ( FramingParameters new iDUE: 155 @ 40; lDU: 850 r: #left; rDU: 1006 r: #left; tDU: 152 r: #top; bDU: 192 r: #top);
        startGroup;
        tabStop;
        contents: 'Column'.
    mainView addSubpane: canReorder.
    
    canReorderRows "CheckBox"
        owner: self;
        paneName: 'canReorderRows';
        framingBlock: ( FramingParameters new iDUE: 110 @ 40; lDU: 850 r: #left; rDU: 960 r: #left; tDU: 192 r: #top; bDU: 232 r: #top);
        startGroup;
        tabStop;
        contents: 'Row'.
    mainView addSubpane: canReorderRows.
    
    showColumnHeaders "CheckBox"
        owner: self;
        paneName: 'showColumnHeaders';
        framingBlock: ( FramingParameters new iDUE: 171 @ 40; lDU: 1097 r: #left; rDU: 1269 r: #left; tDU: 152 r: #top; bDU: 192 r: #top);
        startGroup;
        tabStop;
        contents: '&Column'.
    mainView addSubpane: showColumnHeaders.
    
    showRowHeaders "CheckBox"
        owner: self;
        paneName: 'showRowHeaders';
        framingBlock: ( FramingParameters new iDUE: 128 @ 40; lDU: 1097 r: #left; rDU: 1225 r: #left; tDU: 192 r: #top; bDU: 232 r: #top);
        startGroup;
        tabStop;
        contents: '&Row'.
    mainView addSubpane: showRowHeaders.
    
    cellSelectMode "RadioButton"
        owner: self;
        paneName: 'cellSelectMode';
        framingBlock: ( FramingParameters new iDUE: 101 @ 40; lDU: 878 r: #left; rDU: 978 r: #left; tDU: 284 r: #top; bDU: 324 r: #top);
        startGroup;
        contents: 'Cell'.
    mainView addSubpane: cellSelectMode.
    
    singleSelectMode "RadioButton"
        owner: self;
        paneName: 'singleSelectMode';
        framingBlock: ( FramingParameters new iDUE: 137 @ 40; lDU: 878 r: #left; rDU: 1015 r: #left; tDU: 324 r: #top; bDU: 364 r: #top);
        contents: 'Single'.
    mainView addSubpane: singleSelectMode.
    
    multiSelectMode "RadioButton"
        owner: self;
        paneName: 'multiSelectMode';
        framingBlock: ( FramingParameters new iDUE: 119 @ 40; lDU: 1061 r: #left; rDU: 1179 r: #left; tDU: 284 r: #top; bDU: 324 r: #top);
        contents: 'Multi'.
    mainView addSubpane: multiSelectMode.
    
    extendedSelectMode "RadioButton"
        owner: self;
        paneName: 'extendedSelectMode';
        framingBlock: ( FramingParameters new iDUE: 183 @ 40; lDU: 1061 r: #left; rDU: 1243 r: #left; tDU: 324 r: #top; bDU: 364 r: #top);
        contents: 'Extended'.
    mainView addSubpane: extendedSelectMode.
    
    headerColor "WBComboBox"
        owner: self;
        paneName: 'headerColor';
        framingBlock: ( FramingParameters new iDUE: 338 @ 336; lDU: 960 r: #left; rDU: 1298 r: #left; tDU: 440 r: #top; bDU: 776 r: #top);
        dropDownList;
        startGroup;
        tabStop.
    mainView addSubpane: headerColor.
    
    disabledForeColor "WBComboBox"
        owner: self;
        paneName: 'disabledForeColor';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 338 @ 336; lDU: 942 r: #left; rDU: 1280 r: #left; tDU: 528 r: #top; bDU: 864 r: #top);
        dropDownList;
        startGroup;
        tabStop.
    mainView addSubpane: disabledForeColor.
    
    disabledBackColor "WBComboBox"
        owner: self;
        paneName: 'disabledBackColor';
        addClipsiblingsStyle;
        framingBlock: ( FramingParameters new iDUE: 338 @ 336; lDU: 942 r: #left; rDU: 1280 r: #left; tDU: 584 r: #top; bDU: 920 r: #top);
        dropDownList;
        startGroup;
        tabStop.
    mainView addSubpane: disabledBackColor.
    
    ok "Button"
        owner: self;
        paneName: 'ok';
        framingBlock: ( FramingParameters new iDUE: 265 @ 72; lDU: 503 r: #left; rDU: 768 r: #left; tDU: 504 r: #top; bDU: 576 r: #top);
        defaultPushButton;
        defaultPushButton;
        startGroup;
        tabStop;
        when: #clicked send: #ok to: self;
        contents: '&OK'.
    mainView addSubpane: ok.
    
    cancel "Button"
        owner: self;
        paneName: 'cancel';
        framingBlock: ( FramingParameters new iDUE: 265 @ 72; lDU: 503 r: #left; rDU: 768 r: #left; tDU: 592 r: #top; bDU: 664 r: #top);
        cancelPushButton;
        cancelPushButton;
        startGroup;
        tabStop;
        when: #clicked send: #cancel to: self;
        contents: '&Cancel'.
    mainView addSubpane: cancel.
    
    color "StaticText"
        owner: self;
        paneName: 'color';
        framingBlock: ( FramingParameters new iDUE: 107 @ 32; lDU: 82 r: #left; rDU: 190 r: #left; tDU: 496 r: #top; bDU: 528 r: #top);
        rightJustified;
        startGroup;
        contents: 'Color:'.
    mainView addSubpane: color.
    
    disabled "StaticText"
        owner: self;
        paneName: 'disabled';
        framingBlock: ( FramingParameters new iDUE: 160 @ 32; lDU: 27 r: #left; rDU: 187 r: #left; tDU: 552 r: #top; bDU: 584 r: #top);
        rightJustified;
        startGroup;
        contents: 'Disabled:'.
    mainView addSubpane: disabled.
    
    labelMeth "StaticText"
        owner: self;
        paneName: 'labelMeth';
        framingBlock: ( FramingParameters new iDUE: 117 @ 32; lDU: 73 r: #left; rDU: 190 r: #left; tDU: 608 r: #top; bDU: 640 r: #top);
        rightJustified;
        startGroup;
        contents: 'Label:'.
    mainView addSubpane: labelMeth.
    
    numRows "StaticText"
        owner: self;
        paneName: 'numRows';
        framingBlock: ( FramingParameters new iDUE: 183 @ 32; lDU: 18 r: #left; rDU: 201 r: #left; tDU: 408 r: #top; bDU: 440 r: #top);
        rightJustified;
        startGroup;
        contents: 'Num Rows:'.
    mainView addSubpane: numRows.
    
    headerColorLabel "StaticText"
        owner: self;
        paneName: 'headerColorLabel';
        framingBlock: ( FramingParameters new iDUE: 128 @ 32; lDU: 823 r: #left; rDU: 951 r: #left; tDU: 448 r: #top; bDU: 480 r: #top);
        rightJustified;
        startGroup;
        contents: 'Header:'.
    mainView addSubpane: headerColorLabel.
    
    foreLabel "StaticText"
        owner: self;
        paneName: 'foreLabel';
        framingBlock: ( FramingParameters new iDUE: 91 @ 32; lDU: 841 r: #left; rDU: 933 r: #left; tDU: 536 r: #top; bDU: 568 r: #top);
        rightJustified;
        startGroup;
        contents: 'Fore:'.
    mainView addSubpane: foreLabel.
    
    backLabel "StaticText"
        owner: self;
        paneName: 'backLabel';
        framingBlock: ( FramingParameters new iDUE: 91 @ 32; lDU: 841 r: #left; rDU: 933 r: #left; tDU: 592 r: #top; bDU: 624 r: #top);
        rightJustified;
        startGroup;
        contents: 'Back:'.
    mainView addSubpane: backLabel.
    
    contentsGroup "GroupBox"
        owner: self;
        paneName: 'contentsGroup';
        framingBlock: ( FramingParameters new iDUE: 750 @ 104; lDU: 18 r: #left; rDU: 768 r: #left; tDU: 8 r: #top; bDU: 112 r: #top);
        startGroup;
        contents: 'Contents'.
    mainView addSubpane: contentsGroup.
    
    objectMethods "GroupBox"
        owner: self;
        paneName: 'objectMethods';
        framingBlock: ( FramingParameters new iDUE: 457 @ 216; lDU: 18 r: #left; rDU: 475 r: #left; tDU: 448 r: #top; bDU: 664 r: #top);
        startGroup;
        contents: 'Object Methods'.
    mainView addSubpane: objectMethods.
    
    reorderGroup "GroupBox"
        owner: self;
        paneName: 'reorderGroup';
        framingBlock: ( FramingParameters new iDUE: 229 @ 136; lDU: 823 r: #left; rDU: 1051 r: #left; tDU: 112 r: #top; bDU: 248 r: #top);
        startGroup;
        contents: 'Reorder'.
    mainView addSubpane: reorderGroup.
    
    labelsGroup "GroupBox"
        owner: self;
        paneName: 'labelsGroup';
        framingBlock: ( FramingParameters new iDUE: 229 @ 136; lDU: 1070 r: #left; rDU: 1298 r: #left; tDU: 112 r: #top; bDU: 248 r: #top);
        startGroup;
        contents: 'Labels'.
    mainView addSubpane: labelsGroup.
    
    selectionGroup "GroupBox"
        owner: self;
        paneName: 'selectionGroup';
        framingBlock: ( FramingParameters new iDUE: 475 @ 128; lDU: 823 r: #left; rDU: 1298 r: #left; tDU: 248 r: #top; bDU: 376 r: #top);
        startGroup;
        contents: 'Selection'.
    mainView addSubpane: selectionGroup.
    
    optionsGroup "GroupBox"
        owner: self;
        paneName: 'optionsGroup';
        framingBlock: ( FramingParameters new iDUE: 512 @ 384; lDU: 805 r: #left; rDU: 1317 r: #left; tDU: 8 r: #top; bDU: 392 r: #top);
        startGroup;
        contents: 'Options'.
    mainView addSubpane: optionsGroup.
    
    disabledGroup "GroupBox"
        owner: self;
        paneName: 'disabledGroup';
        framingBlock: ( FramingParameters new iDUE: 475 @ 160; lDU: 823 r: #left; rDU: 1298 r: #left; tDU: 488 r: #top; bDU: 648 r: #top);
        startGroup;
        contents: 'Disabled'.
    mainView addSubpane: disabledGroup.
    
    colorGroup "GroupBox"
        owner: self;
        paneName: 'colorGroup';
        framingBlock: ( FramingParameters new iDUE: 512 @ 264; lDU: 805 r: #left; rDU: 1317 r: #left; tDU: 400 r: #top; bDU: 664 r: #top);
        startGroup;
        contents: 'Color'.
    mainView addSubpane: colorGroup! !

"SP Dev Base Common (SP2ADEVW.SLL)"!
!'WindowBuilder class' osiMethods !  
spInitializeDevelopment
        "Perform initialization."
    self
        spInitializeSystemBitmaps;
        addInSubPanesV: nil.
    WBAddInManager basicNew updateProperties.
    self osiProductRegistry
        register: 'Subpanes/V'
        withName: #SubpanesV
        version: '2.2.2'.! !
  
"--------- remove temporary methods"!

String removeSelector: #osiMethods !
String removeSelector: #osiMethods: !
String removeSelector: #osiEvaluateIfError: !
String removeSelector: #osiRemoveSelector: !
String removeSelector: #fileInFrom: !
String removeSelector: #osisubclass:instanceVariableNames:classVariableNames:poolDictionaries: !
String removeSelector: #osisubclass:instanceVariableNames:classVariableNames:poolDictionaries:ifDefined: !

