
" Use this install script if you are installing Subpanes/V 2.2.2
    overtop of Subpanes/V 2.2.  This script loads
    both the new Subpanes/V 2.2.2 runtime update file
    and the new Subpanes/V 2.2.2 development update file."

| obsoletes examples wb fileMap files relatedFiles |

(SmalltalkLibraryBinder isBound: 'SP22RBW') ifFalse: [
    MessageBox warning:
        'To install Subpanes/V 2.2.2 into a clean image, ',
        'please run the first install script (INSTALL1.SP).  ',
        'Installation aborted.  A walkback follows.'.
    self error: 'Use other script' ].

obsoletes     := false.
examples      := false.
wb            := Smalltalk includesKey: #WindowBuilder.

files        := OrderedCollection new.
relatedFiles := OrderedCollection new.
(fileMap     := Dictionary new)

    " Subpanes/V 2.2.2 Runtime for Win32 "
    at: 'SP2ARBW'  put: 'Subpanes/V 2.2.2 Base for Win32';
    at: 'SP2ARBBW' put: 'Subpanes/V 2.2.2 Bitmap Buttons for Win32';
    at: 'SP2ARFW'  put: 'Subpanes/V 2.2.2 Input Fields for Win32';
    at: 'SP2ARMW'  put: 'Subpanes/V 2.2.2 Miscellaneous for Win32';
    at: 'SP2ARTW'  put: 'Subpanes/V 2.2.2 Tables for Win32';
    at: 'SP2AROBW' put: 'Subpanes/V 2.2.2 Obsolete for Win32';
    at: 'SP2ARUPW.ST'  put: 'Subpanes/V 2.2.2 Runtime Update';

    " Subpanes/V 2.2.2 Development "
    at: 'SP22DEVW.ST'  put: 'Subpanes/V 2.2.2 Development';
    at: 'SP2ADUPW.ST'  put: 'Subpanes/V 2.2.2 Development Update';

    " Subpanes/V 2.2.2 Examples "
    at: 'SP2AEXMW'  put: 'Subpanes/V 2.2.2 Examples';

    " Subpanes/V 2.2.2 Support Files "
    at: 'SP22SYSW.DLL' put: 'Subpanes/V 2.2 System Bitmaps';

    yourself.

files        add: 'SP2ARUPW.ST'.
wb           ifTrue: [ files add: 'SP2ADUPW.ST' ].

(files collect: [ :eachFileName |
    eachFileName fileExtension trimBlanks = ''
        ifTrue: [ eachFileName, '.SLL' ]
        ifFalse: [ eachFileName ]]),
(files collect: [ :eachFileName | 
    eachFileName fileExtension trimBlanks = ''
        ifTrue: [ eachFileName, '.SML' ]
        ifFalse: [ eachFileName ]]),
relatedFiles
    detect: [ :eachFileName |
        (File findFileName: eachFileName) isNil ifTrue: [
            MessageBox message:
                (fileMap at: eachFileName ifAbsent: [ 'A file' ]),
                ' (', eachFileName,
                ') is not on the PATH or in the working directory.',
                ' Installation aborted.'.
            true
        ] ifFalse: [ false ] ]
    ifNone: [
        files do: [ :eachFileName |
            eachFileName fileExtension trimBlanks = ''
                ifTrue: [
                    Transcript cr; show: 'Binding ', eachFileName, '...'.
                    SmalltalkLibraryBinder bindTo: eachFileName ]
                ifFalse: [
                    Transcript cr; show: 'Installing ', eachFileName, '...'.
                    [ :stream | [ stream fileIn ] ensure: [ stream close ] ]
                        value: (File pathName: (File findFileName: eachFileName)) ] ] ].
!
" Last minute fix "
WBAddInManager basicNew updateProperties.

WindowBuilder osiProductRegistry
    register: 'Subpanes/V'
    withName: #SubpanesV
    version: '2.2.2u'.
!
Transcript cr; show: 'Done'.
