
" Use this install script if you are installing Subpanes/V 2.2.2
    into a clean image.  This script loads the new Subpanes/V 2.2.2
    runtime SLLs and the old Subpanes/V 2.2 development SLLs
    plus the new Subpanes/V 2.2.2 development update file."

| obsoletes examples wb fileMap files relatedFiles |

(SmalltalkLibraryBinder isBound: 'SP22RBW') ifTrue: [
    MessageBox warning:
        'Subpanes/V 2.2 is already installed.  ',
        'Please run the second install script (INSTALL2.SP).  ',
        'Installation aborted.  A walkback follows.'.
    self error: 'Use other script' ].

obsoletes     := (Smalltalk at: #CPBitmapDict ifAbsent: [ nil ]) notNil
    and: [ MessageBox confirm: 'Install Subpanes/V 2.2.2 obsoletes?' ].
examples      := MessageBox confirm: 'Install Subpanes/V 2.2.2 examples?'.
wb            := Smalltalk includesKey: #WindowBuilder.

files        := OrderedCollection new.
relatedFiles := OrderedCollection new.
(fileMap     := Dictionary new)

    " Subpanes/V 2.2.2 Runtime for Win32 "
    at: 'SP2ARBW'  put: 'Subpanes/V 2.2.2 Base for Win32';
    at: 'SP2ARBBW' put: 'Subpanes/V 2.2.2 Bitmap Buttons for Win32';
    at: 'SP2ARFW'  put: 'Subpanes/V 2.2.2 Input Fields for Win32';
    at: 'SP2ARMW'  put: 'Subpanes/V 2.2.2 Miscellaneous for Win32';
    at: 'SP2ARTW'  put: 'Subpanes/V 2.2.2 Tables for Win32';
    at: 'SP2AROBW' put: 'Subpanes/V 2.2.2 Obsolete for Win32';
    at: 'SP2ARUPW'  put: 'Subpanes/V 2.2.2 Runtime Update';

    " Subpanes/V 2.2.2 Development "
    at: 'SP22DEVW.ST'  put: 'Subpanes/V 2.2.2 Development';
    at: 'SP2ADUPW.ST'  put: 'Subpanes/V 2.2.2 Development Update';

    " Subpanes/V 2.2.2 Examples "
    at: 'SP2AEXMW'  put: 'Subpanes/V 2.2.2 Examples';

    " Subpanes/V 2.2.2 Support Files "
    at: 'SP22SYSW.DLL' put: 'Subpanes/V 2.2 System Bitmaps';

    yourself.

files        addAll: #( 'SP2ARBW' 'SP2ARBBW' 'SP2ARFW' 'SP2ARMW' 'SP2ARTW' ).
obsoletes    ifTrue: [ files add: 'SP2AROBW' ].
wb           ifTrue: [ files addAll: #( 'SP22DEVW.ST' 'SP2ADUPW.ST' ) ].
examples     ifTrue: [ files add: 'SP2AEXMW' ].
relatedFiles add: 'SP22SYSW.DLL'.

(files collect: [ :eachFileName |
    eachFileName fileExtension trimBlanks = ''
        ifTrue: [ eachFileName, '.SLL' ]
        ifFalse: [ eachFileName ]]),
(files collect: [ :eachFileName | 
    eachFileName fileExtension trimBlanks = ''
        ifTrue: [ eachFileName, '.SML' ]
        ifFalse: [ eachFileName ]]),
relatedFiles
    detect: [ :eachFileName |
        (File findFileName: eachFileName) isNil ifTrue: [
            MessageBox message:
                (fileMap at: eachFileName ifAbsent: [ 'A file' ]),
                ' (', eachFileName,
                ') is not on the PATH or in the working directory.',
                ' Installation aborted.'.
            true
        ] ifFalse: [ false ] ]
    ifNone: [
        files do: [ :eachFileName |
            eachFileName fileExtension trimBlanks = ''
                ifTrue: [
                    Transcript cr; show: 'Binding ', eachFileName, '...'.
                    SmalltalkLibraryBinder bindTo: eachFileName ]
                ifFalse: [
                    Transcript cr; show: 'Installing ', eachFileName, '...'.
                    [ :stream | [ stream fileIn ] ensure: [ stream close ] ]
                        value: (File pathName: (File findFileName: eachFileName)) ] ] ].
!
" Last minute fix "
WBAddInManager basicNew updateProperties.

WindowBuilder osiProductRegistry
    register: 'Subpanes/V'
    withName: #SubpanesV
    version: '2.2.2u'.
!
Transcript cr; show: 'Done'.
