TextDocs.NewDoc      #   Syntax10.Scn.Fnt  m   m  MODULE Stacks;

	TYPE
		Element* = POINTER TO ElementDesc;
		ElementDesc* = RECORD END;
		
		Stack* = POINTER TO StackDesc;
		
		StackDesc* = RECORD
			nElements- : INTEGER;
			elements : POINTER TO ARRAY OF Element;
		END;
		
		StackProc* = PROCEDURE(stackElement : Element);
				
	PROCEDURE (thisStack : Stack) Top* ():Element;
	BEGIN
		RETURN thisStack.elements[thisStack.nElements-1];
	END Top;
	
	PROCEDURE (thisStack : Stack) Full*():BOOLEAN;
	BEGIN
		RETURN thisStack.nElements = LEN(thisStack.elements^);
	END Full;
	
	PROCEDURE (thisStack : Stack) Push* (newElement : Element);
	BEGIN
		ASSERT(~thisStack.Full());
		thisStack.elements[thisStack.nElements] := newElement;
		INC(thisStack.nElements);
	END Push;
	
	PROCEDURE (thisStack : Stack) Empty* ():BOOLEAN;
	BEGIN
		RETURN thisStack.nElements = 0;
	END Empty;
	
	PROCEDURE (thisStack : Stack) Pop* ();
	BEGIN
		ASSERT(~thisStack.Empty());
		DEC(thisStack.nElements);
	END Pop;
	
	PROCEDURE (thisStack : Stack) Init* (size : INTEGER);
	BEGIN
		NEW(thisStack.elements, size);
	END Init;
	
	PROCEDURE (thisStack : Stack) ApplyAll* (proc : StackProc);
	VAR
		i : INTEGER;
	BEGIN
		FOR i := 0 TO thisStack.nElements - 1 DO;
			proc(thisStack.elements[i]);
		END;
	END ApplyAll;
	
	PROCEDURE (thisStack : Stack) Clear* ();
	BEGIN
		thisStack.nElements := 0;
	END Clear;
	
	PROCEDURE (thisStack : Stack) Copy* (oldStack : Stack);
	VAR
		i : INTEGER;
		
	BEGIN
		ASSERT(LEN(thisStack.elements^) >= oldStack.nElements);
		FOR i := 0 TO oldStack.nElements - 1 DO;
			thisStack.elements[i] := oldStack.elements[i];
		END;
		thisStack.nElements := oldStack.nElements;
	END Copy;
END Stacks.
		