TextDocs.NewDoc     %#   Syntax10.Scn.Fnt       MODULE Sprites;

	IMPORT Display3, Pictures,Out;
	
	TYPE
		ImageCell = RECORD
			x, y, w, h: INTEGER;
			mask : Display3.Mask;
		END;

		SpriteDesc* = RECORD
			x*, y* : INTEGER;
			image : Pictures.Picture;
			cells* : POINTER TO ARRAY OF ImageCell;
			cell* : INTEGER;
		END;
		
		Sprite* = POINTER TO SpriteDesc;
	
	PROCEDURE (s : Sprite) Draw* (M : Display3.Mask; mode : INTEGER);
	VAR
		cell : ImageCell;
		
	BEGIN
		cell := s.cells^[s.cell];
		cell.mask.x := s.x;
		cell.mask.y := s.y;
		Display3.Pict(M, s.image, cell.x, cell.y, cell.w, cell.h, s.x, s.y, mode);
	END Draw;
	
  PROCEDURE (s : Sprite) DrawAlias* (s2 : Sprite; cellnumber : INTEGER; M : Display3.Mask; mode : INTEGER);
	VAR
		cell : ImageCell;
		
	BEGIN
		cell := s2.cells^[cellnumber];
		cell.mask.x := s2.x;
		cell.mask.y := s2.y;
		Display3.Pict(M, s2.image, cell.x, cell.y, cell.w, cell.h, s.x, s.y, mode);
	END DrawAlias; 
	
	PROCEDURE (s : Sprite) Init*(PictName : ARRAY OF CHAR; startx, starty, ncells, cellw, cellh : INTEGER);
	VAR
		i, x, y, xj, yi, color : INTEGER;
		
	BEGIN
		NEW(s.image); 
		Pictures.Open(s.image, PictName, TRUE); 
		y := s.image.height - starty - cellh;
		x := startx;
		NEW(s.cells, ncells);
		FOR i := 0 TO ncells - 1 DO;
			s.cells[i].x := x;
			s.cells[i].y := y;
			s.cells[i].w := cellw;
			s.cells[i].h := cellh;
			NEW(s.cells[i].mask);
			Display3.Open(s.cells[i].mask);
			Display3.AdjustMask(s.cells[i].mask, 0, 0, cellw, cellh);
			FOR yi := 0 TO cellh DO;
				FOR xj := 0 TO cellw DO;
					color := Pictures.Get(s.image, xj+x, yi + y);
					IF color = Display3.BG THEN
						Display3.Subtract(s.cells[i].mask, xj, yi, 1, 1);
					END;
				END;
			END;
			INC(x, cellw);
		END;
	END Init;
END Sprites.