(**************************************************************************

Name:           Num1
Purpose:        Numerics: 1-dimensional, discrete functions
Version:	1.1
Predecessor:    1.0
Changes:        ReadFunc debugged
Target platform:PC>=386
Compiler:	Oberon 3
Date:           December  1995
Author:		Frank Hrebabetzky

***************************************************************************)

MODULE Num1;

IMPORT
  Files, NumAeq1;

CONST
  (* function types including file format version *)
  FUNCAEQ = 1;   FUNCGEN = 2;	(* types for read/write *)
  (* file i/o results *)
  OK		= 0;
  EMPTY	= 1;
  FUNCTYPE	= 2;	(* actual and stored function type differ	*)
  FORMAT	= 3;	(* wrong file format/version	*)
  MISSING	= 4;	(* missing values in file	*)

TYPE
  Func*	= POINTER TO NumAeq1.Func;
  FuncGen*	= POINTER TO FuncGenDesc;
  FuncGenDesc*	= RECORD (NumAeq1.Func)
                      x*: NumAeq1.VAL
                    END;


PROCEDURE WriteFunc* (f:Func; file:Files.File);
VAR i, type	: INTEGER;
    r		: Files.Rider;
BEGIN
  IF f IS FuncGen THEN type:=FUNCGEN ELSE type:=FUNCAEQ END;
  Files.Set (r, file, 0);
  Files.WriteInt (r, type);
  Files.WriteInt (r, f.NP);
  Files.WriteReal (r, f.ymin);
  Files.WriteReal (r, f.ymax);
  Files.WriteReal (r, f.x0);
  Files.WriteReal (r, f.dx);
  FOR i:=0 TO f.NP-1 DO Files.WriteReal (r, f.y[i]) END;
  IF type=FUNCGEN THEN
    FOR i:=0 TO f.NP-1 DO Files.WriteReal (r, f(FuncGen).x[i]) END;
  END;
  Files.Register (file);
END WriteFunc;


PROCEDURE ReadFunc* (f:Func; file:Files.File; VAR res:INTEGER);
VAR i, type	: INTEGER;
    r		: Files.Rider;
BEGIN
  Files.Set (r, file, 0);
  IF r.eof THEN
    res:= EMPTY;
    Files.Close (file);
    RETURN;
  END;
  Files.ReadInt (r, type);
  CASE type OF
    FUNCAEQ:	IF f IS FuncGen THEN
				  res:=FUNCTYPE;   Files.Close(file);   RETURN;
				END;
  | FUNCGEN:	IF ~(f IS FuncGen) THEN
				  res:=FUNCTYPE;   Files.Close(file);   RETURN;
				END;
  ELSE		res:=FORMAT;   Files.Close(file);   RETURN;
  END;
  Files.ReadInt (r, f.NP);
  Files.ReadReal (r, f.ymin);
  Files.ReadReal (r, f.ymax);
  Files.ReadReal (r, f.x0);
  Files.ReadReal (r, f.dx);
  FOR i:=0 TO f.NP-2 DO Files.ReadReal (r, f.y[i]) END;
  IF r.eof THEN
    res:= MISSING;   Files.Close(file);   RETURN;
  END;
  Files.ReadReal (r, f.y[f.NP-1]);
  IF type=FUNCGEN THEN
    FOR i:=0 TO f.NP-2 DO Files.ReadReal (r, f(FuncGen).x[i]) END;
    IF r.eof THEN res:= MISSING
    ELSE
      Files.ReadReal (r, f(FuncGen).x[f.NP-1]);
      res:= OK;
    END;
  END;
  Files.Close(file);
END ReadFunc;


PROCEDURE LinReg* (f:Func; ia,ib:INTEGER; VAR n,m:REAL);
(* Linear regression: fit of m*x+n to f in [ia,ib]. *)
VAR i, N		: INTEGER;
    x, X1, X2, Y0, Y1, den	: REAL;
BEGIN
  x:= f.x0 + ia*f.dx;
  X1:= 0.0;   X2:= 0.0;   Y0:=0.0;   Y1:= 0.0;
  IF (f IS FuncGen) THEN
    FOR i:=ia TO ib DO
      x:= f(FuncGen).x[i];
      X1:= X1 + x;   X2:= X2 + x*x;   Y0:= Y0 + f.y[i];   Y1:= Y1 + x*f.y[i];
    END;
  ELSE
    FOR i:=ia TO ib DO
      X1:= X1 + x;   X2:= X2 + x*x;   Y0:= Y0 + f.y[i];   Y1:= Y1 + x*f.y[i];
      x:= x + f.dx;
    END;
  END;
  N:= ib - ia + 1;
  den:= N*X2 - X1*X1;
  n:= (Y0*X2 - X1*Y1) / den;
  m:= (N*Y1 - Y0*X1) / den;
END LinReg;  


END Num1.
