TextDocs.NewDoc     F   CColor    Flat  Locked  Controls  Org      BIER`   b        3   Oberon10.Scn.Fnt             '    l    	    
   '       Oberon10b.Scn.Fnt          	    i   	        	    S              e   $    P                C    	           y           	            +               I    %            $                 	    .   	    5       r          Oberon12.Scn.Fnt     i,  (* ETH Oberon, Copyright 2001 ETH Zuerich Institut fuer Computersysteme, ETH Zentrum, CH-8092 Zuerich.
Refer to the "General ETH Oberon System Source License" contract available at: http://www.oberon.ethz.ch/ *)

MODULE FMRadio;	(* afi - Jan 13, 1999 *)
	(* Supports the Wizard radio by Gemtek, Taiwan - "http://www.gemtek.com.tw/wizard.htm"
		and the Lenco PC Radio-Box MXR 9571 by Lenco, Germany - "http://www.lenco.de" ( MM-Zubehoer) *)

	(* High quality FM stereo radio with noise-shielding technology.
		Easy installation through DB-25 connector on any RS-232C port (COM1 - COM4) of a PC.
		Connects to speakers, headphones or to the Line-In bus of the audio card.
		Covers European/USA (87-108MHz) or Japanese (79-91MHz) frequency bands.
		High sensitivity antenna. No external power required.
		Versatile graphical user interface allowing tuning by scanning downward or upward or
		fine tuning in single steps, and providing a number of user defined preset radio stations.	*)

	IMPORT Attributes, Gadgets, Input, Oberon, Objects, Strings, Texts, V24, Out;

	TYPE
		Task = POINTER TO TaskDesc;
		TaskDesc = RECORD (Oberon.TaskDesc)
			stop: BOOLEAN;
			port: LONGINT	(*	-1 = no COM port assigned *)
		END;

	CONST	debug = FALSE;
		(* European/USA FM frequency band 87 - 108MHz, divided in 420 steps of 0.05 MHz *)
			min = 8700; max = 10800;	(* Frequencies x 100 *)
				(* The corresponding internal limits are: 220 and 640, that is 420 unit steps. *)

		(* Japanese FM frequency band 79 - 91MHz, divided in 440 steps of 0.05 MHz *)
		(*	min = 7900; max = 9100;	*)	(* Frequencies x 100 *)

	VAR val: LONGINT; task: Task; fineTune, scanDown, scanUp, StoreVal: BOOLEAN;
			context: Objects.Object;

	PROCEDURE SendVal;
		VAR str: ARRAY 8 OF CHAR; istr: ARRAY 4 OF CHAR; res: LONGINT; ival: LONGINT;
	BEGIN
		ival := (val - min) DIV 5 + 220;
		IF debug THEN	(* Display the internal channel number in the log. *)
			Out.Int(ival, 4); Out.Char(" ")
		END;
		Strings.IntToStr(ival, istr);
		str[0] := CHR(29);	(* [GS] *)
		str[1] := "#";
		str[2] := CHR(5);	  (* [ENQ] *)
		str[3] := "#";
		str[4] := istr[0];
		str[5] := istr[1];
		str[6] := istr[2];
		V24.SendBytes(task.port, str, 7, res)
	END SendVal;

	PROCEDURE SendCurVal;
		VAR obj: Objects.Object;
	BEGIN
		obj := Gadgets.FindObj(context, "Frequency");
		IF obj # NIL THEN
			Attributes.GetInt(obj, "Value", val);
			SendVal
		END
	END SendCurVal;

	PROCEDURE SendTune;
		VAR str: ARRAY 8 OF CHAR; res: LONGINT;
	BEGIN
		str[0] := CHR(29);	(* [GS] *)
		str[1] := "#";
		str[2] := CHR(8);	  (* [BS] *)
		str[3] := "#";
		V24.SendBytes(task.port, str, 4, res)
	END SendTune;

	(** The commands and procedures are destined to operate in the context of an FMRadio.Panel
			described in FMRadio.Desc (LayLa description). *)
	(** Fine tune the radio station upward. *)
	PROCEDURE StepUp*;
		VAR obj: Objects.Object; status: LONGINT;
	BEGIN
		obj := Gadgets.FindObj(context, "Act");
		IF obj # NIL THEN
			Attributes.GetInt(obj, "Value", status);
			obj := Gadgets.FindObj(context, "Frequency");
			IF (status = 1) & (obj # NIL) & (task # NIL) & (task.port # -1) THEN
				Attributes.GetInt(obj, "Value", val);
				val := val + 5;
				IF val > max THEN val := min END;
				Attributes.SetInt(obj, "Value", val);
				Gadgets.Update(obj);
				SendVal;
				fineTune := TRUE
			END
		END
	END StepUp;

	(** Fine tune the radio station downward. *)
	PROCEDURE StepDown*;
		VAR obj: Objects.Object; status: LONGINT;
	BEGIN
		obj := Gadgets.FindObj(context, "Act");
		IF obj # NIL THEN
			Attributes.GetInt(obj, "Value", status);
			obj := Gadgets.FindObj(context, "Frequency");
			IF (status = 1) & (obj # NIL) & (task # NIL) & (task.port # -1) THEN
				Attributes.GetInt(obj, "Value", val);
				val := val - 5;
				IF val < min THEN val := max END;
				Attributes.SetInt(obj, "Value", val);
				Gadgets.Update(obj);
				SendVal;
				fineTune := TRUE
			END
		END
	END StepDown;

	(* For testing purpose only!	*)
	PROCEDURE Receive (ch: CHAR);
		VAR unit: INTEGER;
	BEGIN
		IF debug THEN
			ch := CHR(ORD(ch) MOD 128);
			IF ch < " " THEN
				Out.Char("[");
				IF ch < 0AX THEN Out.Char("0"); unit := ORD(ch)
				ELSIF ch < 14X THEN Out.Char("1"); unit := ORD(ch) - 10
				ELSIF ch < 1EX THEN Out.Char("2"); unit := ORD(ch) - 20
				ELSE Out.Char("3"); unit := ORD(ch) - 30
				END;
				Out.Char(CHR(ORD("0") + unit));
				Out.Char("]")
			ELSE
				Out.Char(ch)
			END
		END
	END Receive;

	PROCEDURE Receiver (me: Oberon.Task);
		VAR ch: CHAR; l, t: LONGINT; tuned: BOOLEAN; obj: Objects.Object; tunedStr: ARRAY 10 OF CHAR;
	BEGIN
		WITH me: Task DO
			IF me.stop THEN
				Out.String("Closed"); Out.Ln;
				V24.ClearMC(0, {0, 1, 2});
				V24.Stop(me.port); me.port := -1; me.stop := FALSE;
				Oberon.Remove(me)
			ELSE
				l := V24.Available(me.port);
				IF l = 1 THEN V24.Receive(me.port, ch, t); Receive(ch)
				ELSIF l > 0 THEN
					REPEAT V24.Receive(me.port, ch, t); DEC(l);
						Receive(ch);	(* Send the character received from the radio to the log. *)
						IF (l = 1) & (ch = 04X) THEN	(* [EOT] *)
							IF scanUp THEN scanUp := FALSE END;
							IF scanDown THEN scanDown := FALSE END;
							tuned := TRUE
						ELSIF (l = 1) & (ch = 07X) THEN tuned := FALSE	(* [BEL] *)
						END;
					UNTIL l <= 0;
					IF tuned THEN COPY("   Tuned", tunedStr)
					ELSE COPY("Not tuned", tunedStr)
					END;
					obj := Gadgets.FindObj(context, "Tuned");
					IF obj # NIL THEN Attributes.SetString(obj, "Value", tunedStr); Gadgets.Update(obj) END;
					IF debug THEN Out.String(tunedStr); Out.Ln END;
					IF scanDown OR scanUp THEN
						IF scanUp THEN StepUp
						ELSIF scanDown THEN StepDown
						END
					ELSIF fineTune THEN fineTune := FALSE; scanUp := FALSE; scanDown := FALSE
					ELSE IF ~tuned THEN SendTune END
					END
				END;
				me.time := Oberon.Time() + Input.TimeUnit DIV 8
			END
		END
	END Receiver;

	(** Mute the radio - Mute/Activate *)
	PROCEDURE Mute*;
		VAR str: ARRAY 8 OF CHAR; res: LONGINT;
	BEGIN
		IF (task # NIL) & (task.port # -1) THEN
			str[0] := CHR(29);	(* [GS] *)
			str[1] := "#";
			str[2] := CHR(2);	  (* [STX] *)
			str[3] := "#";
			V24.SendBytes(task.port, str, 4, res)
		END
	END Mute;

	(** Activate the radio - Mute/Activate *)
	PROCEDURE Activate*;
		VAR str: ARRAY 8 OF CHAR; res: LONGINT; obj: Objects.Object;
	BEGIN
		IF (task # NIL) & (task.port # -1) THEN
			str[0] := CHR(29);	(* [GS] *)
			str[1] := "#";
			str[2] := CHR(1);	  (* [SOH] *)
			str[3] := "#";
			(* No reply expected from the next transmission *)
			V24.SendBytes(task.port, str, 4, res);
			SendCurVal
		ELSE
			obj := Gadgets.FindObj(context, "Act");
			IF obj # NIL THEN
				Attributes.SetInt(obj, "Value", 0);
				Gadgets.Update(obj)
			END
		END
	END Activate;

	(** Open the connection with a serial port.
			Usage: Open [ COM1 | COM2 | COM3 | COM4 ]	*)
	PROCEDURE Open*;
		VAR S: Texts.Scanner; port, t: LONGINT;
	BEGIN
		context := Gadgets.context;
		Texts.OpenScanner(S,Oberon.Par.text,Oberon.Par.pos); Texts.Scan(S);
		IF S.class IN {Texts.Name, Texts.String} THEN	(* Port specification *)
			port := ORD(S.s[3])-ORD("0");
			IF (port >= 1) & (port <= 4) THEN
				port := (port-1) + V24.COM1;
				IF task = NIL THEN
					NEW(task); task.safe := FALSE; task.handle := Receiver
				END;
				V24.Start(port, 9600, 8, V24.ParNo, V24.Stop1, t);	(* These are fixed values for proper radio operation. *)
				IF t # 0 THEN
					IF t = 1 THEN Out.String("Port in use")
					ELSIF t = 2 THEN Out.String("No such port")
					ELSE Out.String("  See V24 module definition - return code ="); Out.Int(t, 3)
					END
				ELSE
					V24.SetMC(port, {V24.DTR, V24.RTS});
					task.port := port;
					Oberon.Install(task);
					task.time := Oberon.Time() + Input.TimeUnit DIV 8;
					Out.String("Opened ...")
				END;
				Out.Ln
			END
		END
	END Open;

	(** Close the connection with a serial port, thereby freeing it. The background task is removed. *)
	PROCEDURE Close*;
		VAR obj: Objects.Object;
	BEGIN
		IF (task # NIL) & (task.port # -1) THEN
			obj := Gadgets.FindObj(context, "Act");
			IF obj # NIL THEN
				Attributes.SetInt(obj, "Value", 0);
				Gadgets.Update(obj)
			END;
			obj := Gadgets.FindObj(context, "Tuned");
			IF obj # NIL THEN
				Attributes.SetString(obj, "Value", " ");
				Gadgets.Update(obj)
			END;
			task.stop := TRUE;
			scanUp := FALSE;
			scanDown := FALSE
		END
	END Close;

	(** Scan the radio stations downward or upward. Scanning stops when a tuned station is found. *)
	PROCEDURE Scan*;
		VAR S: Texts.Scanner; obj: Objects.Object; status: LONGINT;
	BEGIN
		obj := Gadgets.FindObj(context, "Act");
		IF obj # NIL THEN
			Attributes.GetInt(obj, "Value", status);
			IF status = 1 THEN
				Texts.OpenScanner(S,Oberon.Par.text,Oberon.Par.pos); Texts.Scan(S);
				IF S.s[0] =  "U" THEN scanUp := TRUE; StepUp
				ELSIF S.s[0] =  "D" THEN scanDown := TRUE; StepDown
				END
			END
		END
	END Scan;

	(** Select the preset radio station assigned to a "Preset" CheckBox. *)
	PROCEDURE Select*;
		VAR excobj, obj: Objects.Object; str: ARRAY 8 OF CHAR;
	BEGIN
		excobj := Gadgets.executorObj;
		Attributes.GetString(Gadgets.executorObj, "Name", str);
		str[0] := CAP(str[0]);	(* Name of the Caption next to the CheckBox *)
		obj := Gadgets.FindObj(Gadgets.context, str);
		IF (obj # NIL) & (task # NIL) & (task.port # -1) THEN
			IF ~StoreVal THEN
				Attributes.GetInt(obj, "Value", val);
				obj := Gadgets.FindObj(context, "Frequency");
				IF obj # NIL THEN
					Attributes.SetInt(obj, "Value", val);
					Gadgets.Update(obj);
					SendVal
				END
			ELSE
				Attributes.SetInt(excobj, "SetVal", val);
				Gadgets.Update(excobj);
				Attributes.SetInt(obj, "Value", val);
				Gadgets.Update(obj);
				obj := Gadgets.FindObj(context, "Frequency");
				IF obj # NIL THEN
					Attributes.SetInt(obj, "Value", val);
					Gadgets.Update(obj)
				END;
				(* Clear the informative Caption and reset the Store Button. *)
				obj := Gadgets.FindObj(Gadgets.context, "CapName");
				Attributes.SetString(obj, "Value", " ");
				Gadgets.Update(obj);
				obj := Gadgets.FindObj(Gadgets.context, "ButName");
				Attributes.SetBool(obj, "Value", FALSE);
				Gadgets.Update(obj);
				StoreVal := FALSE
			END
		END
	END Select;

	(** Assign the current frequency to a "Preset" CheckBox to be activated next. *)
	PROCEDURE Preset*;
		VAR obj: Objects.Object;
	BEGIN
		obj := Gadgets.FindObj(Gadgets.context, "CapName");
		IF (obj # NIL) & (task # NIL) & (task.port # -1) THEN
			StoreVal := TRUE;
			Attributes.SetString(obj, "Value", "Check a box");
			Gadgets.Update(obj);
			scanDown := FALSE; scanUp := FALSE;
			StoreVal := TRUE
		END
	END Preset;

BEGIN
	scanDown := FALSE; scanUp := FALSE
END FMRadio.

(**
	SendVal sends a character sequence [GS]#[ENQ]#xyz destined to position the reception
	on an internal frequency value xyz corresponding to the frequency (Europe/USA)
		87 + (xyz - 220) * 0.05 MHz
	A positive or a negative reply is returned:
		a)	[GS]#[ACK]#[GS]#[EOT]#	tuned
		b)	[GS]#[ACK]#[GS]#[BEL]#	not tuned

	SendTune sends a character sequence [GS]#[BS]# destined to tune the reception
	on the current position. The radio device takes some time to position accurately.
	A positive or a negative reply is returned:
		a)	[GS]#[EOT]#	tuned
		b)	[GS]#[BEL]#	not tuned

	Reply expected on connecting to the port
				[00]

	No reply is given to the sending of [GS]#[SOH]#

*)