OrderedCollection
	subclass: #ColonDefinition
	instanceVariableNames: 'immediacy '
	classVariableNames: ''
	poolDictionaries: ''    !


!ColonDefinition class methods ! !



!ColonDefinition methods !
 
compileToken: aToken
        "Compile a ForthPrimitive or ColonDefinition"
         self add: aToken!
 
execute: aTask
        "Execution method for colon defs. Walk thru list, executing.
          THROW if anything returns non-zero throw code. On successful
          completion THROW 0."
    | throw |
   aTask returnStack push: aTask instructionPointer.    "Nest caller."
    aTask instructionPointer: 1.    "set iP to head of a ColonDefinition"
    throw = -9.
"Invalid memory address THROW is our default if we have an empty definition."
 "Now walk through definition."
    [ aTask instructionPointer <= self size ] whileTrue:
        [ (( throw := (self at: aTask instructionPointer) execute: aTask) = 0)
            ifTrue:  [ aTask instructionPointer: (aTask instructionPointer) + 1.     "Post-increment instruction pointer." ]
            ifFalse: [ ^throw]].   "THROW whatever was last result."
	aTask instructionPointer: aTask returnStack removeLast.
	^throw "Should be zero (0)."!
 
immediacy
    ^immediacy!
  
immediacy: anObject
    immediacy := anObject!
 
immediate
        "make immediate"
    self immediacy: true!
  
isImmediate
	"return Boolean true if IMMEDIATE"
	^self immediacy! !
