/*
 * menus.c
 *
 *  Sistema de mens inspirado en "barramnu.c" pero escrito especialmente para
 * el onHand/ruputer.
 *
 * Historia:
 *       5/11/01 Creacin. Hago las estructuras. Pongo los prototipos de
 *               las funciones. Hago un main() de prueba. Hago la parte
 *               de pintar los mens, para ver que tal queda. Falta
 *               el adecentar la parte de pintar y hacer la lgica.
 *       6/11/01 Termino con MenuVert(), incluyendo la lgica. Por ahora
 *               hago que ignore todas las opciones que no le caben en la
 *               pantalla (vamos, que no hace scroll). Termino MenuInit().
 *               Ya hace lo que se supona que deba hacer; para salvaguardar
 *               el fondo mientras se mueve uno por los mens la copio
 *               a una parte de la memoria de vdeo que no se est viendo.
 *               Resulta que cuando se usa el mini-filer se limpia *toda*
 *               la gvram; para que no me importe hago que los submens
 *               se abran en la parte que no se ve, lo que unido a que el
 *               mini-filer hace un gv_place(0,0), hace que no importe
 *               que se borre el contenido (se ver el men "principal").
 *       5/12/01 Hago que los mens de tamao 0 (Space=0) se traten igual que
 *               los de tamao<0.
 *      24/12/01 Hago que el segundo campo del men (Space) contenga informacin
 *               diferente para el terminador que para el resto de los
 *               registros. Los terminadores de mens tienen informacin
 *               "especial" sobre cmo se calcula el valor de retorno.
 *      25/12/01 Decidido, el terminador contendr en el campo Space el valor a
 *               devolver si se selecciona la primera opcin de men (si se
 *               selecciona la segunda ser eso +1, etc). Se reservan las
 *               opciones que van de 0xFF00 a 0xFFFF para el uso del propio
 *               sistema de mens. Hago que MenuVert haga caso de (sMenu).fn
 *               si se da (TECLA_DER|TECLA_ENTER) y devuelva lo mismo
 *               que haya devuelto (sMenu).fn.
 *
 * Autor: Dario Rodriguez dario@softhome.net
 * This program is licensed under the terms of the GNU LGPL
 */


#ifndef __MENUS_C
#define __MENUS_C

/*#define NO_SIGALRM */
#ifdef LINUX
#include <lcdbios.h>
#include <rupsys.h>
#include <psdos.h>
#include <wbios.h>
#endif
#include "tinyfont.h"
#include "teclado.h"

/* #define PRUEBAS_ACTIVADAS */

#ifndef ABS
#define ABS(x) (((x)<0)?(-(x)):(x))
#endif

typedef struct TipoMenu {
        char *String;
        int Space;
        int (*fn)(int PosX, void *Data);
        void *Data;
} sMenu;

int MenuInit(sMenu *Menu);
int MenuVert(int x, int y, sMenu *Menu);
int fnSubMenu(int PosX, void *Data);
void sombrea(int x1,int y1, int x2);
void procesafondo(int Guardar);

#ifdef PRUEBAS_ACTIVADAS
#include "fondo-pantalla.h"
int FileMenuFunc(int PosX, void *Data);

int
main(void)
{
        sMenu MenuEdit[]={{"Cut",3,NULL,NULL},{"Copy",4,NULL,NULL},
                         {"Paste",5,NULL,NULL},{"Select",6,NULL,NULL},
                         {NULL,0x100,NULL,NULL}};
        sMenu MenuInfo[]={{"About...",8,NULL,NULL},
                         {NULL,0x200,NULL,NULL}};
        sMenu MenuPrinc[]={{"File",4,FileMenuFunc,NULL},{"Edit",4,fnSubMenu,MenuEdit},
                        {"Help",-4,NULL,NULL},
                        {"    ",-4,NULL,NULL},
                        {"Info",4,fnSubMenu,MenuInfo},
                        {NULL,0,NULL,NULL}};
        screen(1);
        cls(4);
        TinyfontInit();
        gv_put(0,0,fondo_pantalla,COPY_PUT);
        MenuInit(MenuPrinc);
        while(!(EsperaTecla(0)&TECLA_MENU))
                ;
        return(0);
}

int
FileMenuFunc(int PosX, void *Data)
{
        sMenu MenuFile[]={{"Open...",7,NULL,NULL},{"Save",-4,NULL,NULL},
                        {"Save as...",10,NULL,NULL},{"----------",-10,NULL,NULL},
                        {"Exit",4,NULL,NULL},
                        {NULL,0,NULL,NULL}};
        return(MenuVert(PosX,6,MenuFile));
}

#endif

int
MenuInit(sMenu *Menu)
{
        int Num,x,NumElem,xant,NumAnt,Tecla,SigTecla;
        gv_clear(0,0,101,5);
        gv_line(0,6,101,6,COPY_PUT,0xff);
        for(Num=0,x=0;Menu[Num].String!=NULL && x<=101;x+=((ABS(Menu[Num].Space)+1)<<2)+1,Num++) {
                PonCadPeq(x+1,0,Menu[Num].String);
                if(Menu[Num].Space<0)
                        sombrea(x,0,x+(ABS(Menu[Num].Space)<<2)-1);

        }
        NumElem=Num;
        Num=x=0;
        for(NumAnt=Num=0;Num<NumElem && Menu[Num].Space<=0;x+=((ABS(Menu[Num].Space)+1)<<2)+1,Num++)
                ;
        if(Num>=NumElem) {
                Num=0;
                x=0;
        } else
                gv_reverse(x,0,x+(ABS(Menu[Num].Space)<<2),5);
        SigTecla=0;
        while(1) {
                Tecla=(SigTecla==0)?EsperaTecla(TECLA_DER|TECLA_IZQ):SigTecla;
                SigTecla=0;
                if((Tecla&TECLA_IZQ) && Num>0) {
                        gv_reverse(x,0,x+(ABS(Menu[Num].Space)<<2),5);
                        for(NumAnt=Num,xant=x,Num--,x-=((ABS(Menu[Num].Space)+1)<<2)+1;Num>=0 && Menu[Num].Space<=0;Num--,x-=((ABS(Menu[Num].Space)+1)<<2)+1)
                                ;
                        if(Num<0) {
                                Num=NumAnt;
                                x=xant;
                        }
                        gv_reverse(x,0,x+(ABS(Menu[Num].Space)<<2),5);
                } else if((Tecla&TECLA_DER) && Num<(NumElem-1)) {
                        gv_reverse(x,0,x+(ABS(Menu[Num].Space)<<2),5);
                        for(NumAnt=Num,xant=x,x+=((ABS(Menu[Num].Space)+1)<<2)+1,Num++;Num<NumElem && Menu[Num].Space<=0;x+=((ABS(Menu[Num].Space)+1)<<2)+1,Num++)
                                ;
                        if(Num>=NumElem) {
                                Num=NumAnt;
                                x=xant;
                        }
                        gv_reverse(x,0,x+(ABS(Menu[Num].Space)<<2),5);
                } else if(((Tecla&TECLA_ABJ) && Menu[Num].fn!=NULL) || (Tecla&TECLA_ENTER)) {
                        if(Menu[Num].fn!=NULL) {
                                procesafondo(1);
                                gv_place(102,0);
                                SigTecla=Menu[Num].fn(x+102,Menu[Num].Data);
                                gv_place(0,0);
                        } else
                                return(Menu[NumElem].Space+Num);
                        if((SigTecla&0xFF00)==0xFF00)
                                SigTecla&=0xFF;
                        else
                                return(SigTecla);
                } else if(Tecla&TECLA_MENU)
                        return(-1);
        }
        return(0);
}

int
MenuVert(int x, int y, sMenu *Menu)
{
        int MaxTam,Num,NumElem,NumAnt,Inc;
        int Tecla;
        for(Num=0,MaxTam=0;Menu[Num].String!=NULL;Num++) {
                if(ABS(Menu[Num].Space)>MaxTam)
                        MaxTam=ABS(Menu[Num].Space);
        }
        MaxTam<<=2;
        MaxTam+=3;
        Inc=(x/102)*102;
        x%=102;
        if((x+MaxTam)>101)
                x=101-MaxTam;
        if(x<0)
                x=0;
        if(Num>((63-y-2)/6))
                NumElem=((63-y-2)/6);
        else
                NumElem=Num;
        x+=Inc;
        gv_clear(x+1,y+1,x+MaxTam-1,y+NumElem*6+3-1);
        gv_square(x,y,x+MaxTam,y+NumElem*6+3,COPY_PUT,0xffffffff);
        x+=2;
        for(Num=0;Menu[Num].String!=NULL && Num<NumElem;Num++) {
                PonCadPeq(x,y+2+Num*6,Menu[Num].String);
                if(Menu[Num].Space<0)
                        sombrea(x-1,y+2+Num*6,x+MaxTam-3);
        }
        for(NumAnt=Num=0;Num<NumElem && Menu[Num].Space<=0;Num++)
                ;
        if(Num>=NumElem)
                Num=0;
        else
                gv_reverse(x-1,y+2+Num*6,x+MaxTam-3,y+2+5+Num*6);
        while(1) {
                Tecla=EsperaTecla(TECLA_ARR|TECLA_ABJ);
                if((Tecla&TECLA_ARR) && Num>0) {
                        gv_reverse(x-1,y+2+Num*6,x+MaxTam-3,y+2+5+Num*6);
                        for(NumAnt=Num,Num--;Num>=0 && Menu[Num].Space<=0;Num--)
                                ;
                        if(Num<0)
                                Num=NumAnt;
                        gv_reverse(x-1,y+2+Num*6,x+MaxTam-3,y+2+5+Num*6);
                } else if((Tecla&TECLA_ABJ) && Num<(NumElem-1)) {
                        gv_reverse(x-1,y+2+Num*6,x+MaxTam-3,y+2+5+Num*6);
                        for(NumAnt=Num,Num++;Num<NumElem && Menu[Num].Space<=0;Num++)
                                ;
                        if(Num>=NumElem)
                                Num=NumAnt;
                        gv_reverse(x-1,y+2+Num*6,x+MaxTam-3,y+2+5+Num*6);
                } else if(Menu[Num].fn!=NULL && Tecla&(TECLA_DER|TECLA_ENTER)) {
                        return(Menu[Num].fn(x+MaxTam-2,Menu[Num].Data));
                } else  if(Tecla&(TECLA_DER|TECLA_IZQ|TECLA_MENU)) {
                        return((0xFF00 | (Tecla&0xFF)));
                } else if(Tecla&TECLA_ENTER)
                        return(Menu[NumElem].Space+Num);
        }
        return(0);
}

int
fnSubMenu(int PosX, void *Data)
{
        return(MenuVert(PosX,6,(sMenu *) Data));
}

void
sombrea(int x1,int y1, int x2)
{
        int i;
        char Buf[102+4+1];
        gv_get(x1,y1,x2,y1+5,Buf);
        for(i=0;i<Buf[0];i+=2) {
                Buf[4+i]&=0xAA;
                Buf[4+i+1]&=0x55;
        }
        gv_put(x1,y1,Buf,COPY_PUT);
}

void
procesafondo(int Guardar)
{
        int i;
        char Buf[102+4+1];
        if(Guardar) {
                for(i=0;i<8;i++) {
                        gv_get(0,8*i,101,8*i+7,Buf);
                        gv_put(102,8*i,Buf,COPY_PUT);
                }
        } else {
                for(i=0;i<8;i++) {
                        gv_get(102,8*i,102+101,8*i+7,Buf);
                        gv_put(0,8*i,Buf,COPY_PUT);
                }
        }
}


#endif
