/*
 * tinyfont.h
 *
 * Funciones de utilidad para el uso de tinyfont.
 *
 * Historia:
 *      15/02/01 Pongo todo esto es un fichero aparte.
 *      22/04/01 Cambio de nombre a PonIntPeq() a PonIntPeqInfo(), le hago que
 *               devuelva el nmero de carcteres escritos y hago una macro
 *               con el nombre de PonIntPeq para no perder la compatibilidad.
 *       5/12/01 Cambios cosmticos para que compile sin avisos con -Wall.
 *
 * Autor: Dario Rodriguez dario@softhome.net
 * This program is licensed under the terms of the GNU LGPL
 */

#ifndef TINYFONT_H
#define TINYFONT_H

/* Definicin de constantes */

#ifndef COPY_PUT
#define COPY_PUT 0
#define XOR_PUT  1
#define OR_PUT   2
#define AND_PUT  3
#endif

#ifndef KCOPY_PUT
#define KCOPY_PUT 0
#define KOR_PUT   1
#endif

#ifndef PCOPY_PUT
#define PCOPY_PUT (COPY_PUT | 4)
#define PXOR_PUT  (XOR_PUT | 4)
#define POR_PUT   (OR_PUT | 4)
#define PAND_PUT  (AND_PUT | 4)
#endif


/* Definicin de estructuras y datos globales */

static char Fuente[128*8+4];

/* Definicin de macros */

#ifndef LINUX
#define TinyfontInit() mpread(Fuente,"\\system\\mmp\\tinyfont.mmp")
#define PonLetraPeq(x,y,Letra) gv_aput(x,y,4,6,\
        (unsigned long) (Fuente+((unsigned short) Letra)*4),COPY_PUT)
#else
#define TinyfontInit() mpread(Fuente,"tinyfont.mmp");
int gv_aput_inv(int op,long dir,int ty,int tx,int y,int x) { return(gv_aput(x,y,tx,ty,dir,op));}
#define PonLetraPeq(x,y,Letra) gv_aput_inv(COPY_PUT, \
        (unsigned long) (Fuente+((unsigned short) Letra)*4), 6,4,y,x)
#endif
#define PonIntPeq(a,b,c) PonIntPeqInfo(a,b,c,NULL);

/* Prototipos de funciones */

void PonCadPeq(int x,int y, char *Cad);
void PonIntPeqInfo(int x,int y, unsigned long Num,int *NumCar);
int IntPeqInfo(unsigned long Num);

/* Cuerpo de las funciones */

void
PonCadPeq(int x,int y, char *Cad)
{
        for(;*Cad!='\0';Cad++,x+=4)
                PonLetraPeq(x,y,*Cad);
}

#ifndef NULL
#define NULL ((void *) 0L)
#endif

void
PonIntPeqInfo(int x,int y,unsigned long Num,int *NumCar)
{
        int Desp=0;
        Desp=IntPeqInfo(Num);
        if(NumCar!=NULL)
                *NumCar=Desp;
        Desp--;
        do {
                PonLetraPeq(x+Desp*4,y,(Num%10)+'0');
                Num/=10;
                Desp--;
        } while(Num>0);
}

int
IntPeqInfo(unsigned long Num)
{
        int Desp=0;
        do {
                Desp++;
                Num/=10;
        } while(Num>0);
        return(Desp);
}
#endif

