/*
 * filesel.c
 *
 * Un dilogo de seleccin de ficheros para el onhand/ruputer.
 *
 * Historia:
 *      25/10/01 Creacin. He hecho toda la parte de dibujar la interfaz. Ahora
 *               queda el darle "vida" y toda la parte de leer directorios.
 *      26/10/01 Empiezo con la parte de leer el directorio para la lista de
 *               ficheros de dentro del directorio.
 *      27/10/01 Termino de implementar la parte de leer el directorio para la
 *               lista de ficheros del directorio seleccionado. Hago que el
 *               escribir el contenido del recuadro de nombre tarde menos.
 *               Modifico DibujaNombreDir() para que no escriba el "*.*" del
 *               final (bueno, realmente todo lo que hay despus del ltimo
 *               '\\'). Ya est hecho el navegador de directorios.
 *      28/10/01 Hago que al retroceder en el navegador de directorios se quede
 *               seleccionado el directorio del que se acaba de salir, y que
 *               la funcin FileSelDirRellena() sea capaz de gestionar el
 *               ir "pgina arriba" cuando arriba hay un nmero de entradas
 *               menor que NUMFICHSEL (usando la variable "Prescindibles" y
 *               generalizando un poco el cdigo, aunque la verdad es que
 *               habra que reordenarlo un poco) y que acepte el caso
 *               dirCompleta, que es un dirRellena pero sin borrar los
 *               que hubiera. Hago la parte de moverse por el gui y la editar
 *               el nombre (NombreProcesa()). Ya est terminado y funciona a
 *               la pereccin :-). Lo nico es que es un poco "pesado" en
 *               tamao del cdigo... quizs algn da me ponga a optimizarlo
 *               un poco para tamao O:-). HORROR: Cacharreando con l me he
 *               encontrado que ha tenido un desbordamiento de pila o algo
 *               similar en algn momento... habr que investigar :-/.
 *               NOTA: FileSelDirProcesa() aade cosas al parmetro Path y
 *               no sabe su tamao para intentar no desbordarlo, por
 *               lo que no comprueba si se desborda (!).
 *      28/10/01 Investigado lo del "horror". Resulta que FileSelDirRellena()
 *               hace algo mal en el caso de dirAnterior cuando el bloque
 *               queda con algn "Prescindible". Arreglo un bug en dicha funcin
 *               pero no era el que provocaba ese error :-/.
 *       5/11/01 Arreglado el bug (AKA "HORROR") que no encontraba. Resulta que
 *               no comprobaba en FileSelDirRellena() si estaba intentando
 *               insertar un elemento detrs de NUMFICHSEL elementos (pisando
 *               lo que hubiera en la pila en esa posicin). Con esto doy
 *               estas rutinas por terminadas (ya tienen *toda* la funcionalidad
 *               que quera, e incluso un poco ms ;-). Le pongo los lcdfreeze()
 *               necesarios para que parezca un poco ms "slido". Hago que los
 *               textos sean en ingls por defecto (y en espaol si est
 *               definida la constante SPANISH).
 *       8/11/01 Hago que respete como seleccin inicial lo que hubiera en
 *               BufferResultado, y que use B:\\NONAME.TXT slo si
 *               BufferResultado[0]=='\0'. Esto obliga a que BufferResultado
 *               tenga algo lgico al llamar a la funcin, y ya no es slo de
 *               resultado, por lo que le cambio nombre a BufferSeleccion.
 *       9/11/01 Hago que al seleccionar un nombre en la lista de ficheros
 *               vaya al botn de "ok" en vez de ir al recuadro de edicin
 *               de nombre.
 *       2/12/01 Cambio la apariencia del recuadro de filesel (ahora no intenta
 *               imitar la barra de ttulo de una ventana, sino pone el
 *               ttulo de forma normal encima del formulario). Hago la funcin
 *               DialogBox() para "mensajes de alerta".
 *       3/12/01 Hago que los mensajes de alerta (DialogBox()) usen fuentes
 *               proporcionales (para que quepa un poco ms de texto ;-).
 *
 * Autor: Dario Rodriguez dario@softhome.net
 * This program is licensed under the terms of the GNU LGPL
 */

/* #define NO_SIGALRM */

#ifndef __FILESEL_C
#define __FILESEL_C

#ifdef LINUX
#include <lcdbios.h>
#include <rupsys.h>
#include <ruptool.h>
#include <psdos.h>
#include <wbios.h>
#endif
#include "tinyfont.h"
#include "teclado.h"

/* #define PRUEBAS_ACTIVADAS */

#ifndef DTADESP
#define DTADESP(x,desp) (((char *)x)+(desp))

#define DTARESERVED(x) (*((char **)DTADESP(x,dtaReserved)))
#define DTATIME(x) (*((short *)DTADESP(x,dtaTime)))
#define DTADATE(x) (*((short *)DTADESP(x,dtaDate)))
#define DTASIZE(x) (*((long *)DTADESP(x,dtaSize)))
#define DTAATRIB(x) (*((char *)DTADESP(x,dtaAtrib)))
#define DTANAME(x) ((char *)DTADESP(x,dtaName))

enum EnumDespDta {
        dtaReserved=0,
        dtaTime=22,
        dtaDate=24,
        dtaSize=26,
        dtaAtrib=30,
        dtaName=31,
};
#endif

static char NumEnano[10][6]={
        {2,0,4,0,15,15},  /* 0 */
        {2,0,4,0,0,15},   /* 1 */
        {2,0,4,0,13,11},  /* 2 */
        {2,0,4,0,9,15},   /* 3 */
        {2,0,4,0,7,12},   /* 4 */
        {2,0,4,0,11,13},  /* 5 */
        {2,0,4,0,15,14},  /* 6 */
        {2,0,4,0,1,15},   /* 7 */
        {2,0,4,0,13,13},  /* 8 */
        {2,0,4,0,7,15},   /* 9 */
};

#define PonNumEnano(x,y,Num) gv_put(x,y,&(NumEnano[Num][0]),COPY_PUT)
#define A_MAYUSCULAS(x) (((x)>='a' && (x)<='z')?((x)&0xDF):(x))
#define A_MINUSCULAS(x) (((x)>='A' && (x)<='Z')?((x)|0x20):(x))
#define MAYMINSEGUNTIPO(x,t) ((t=='D')?A_MAYUSCULAS(x):A_MINUSCULAS(x))
#define ABS(a) (((a)<0)?-(a):(a))

#define NUMFICHSEL 5

enum EnumBanderasFichSel {
        fichDirectorio=1,
        fichSeleccionado=2
};

typedef struct TipoFileSelElem {
        char Tipo;
        char Nombre[8+1+3+1];
        unsigned char Dia;
        unsigned char Mes;
        unsigned char Anio;
} sFileSelElem;

typedef struct TipoFileSelDir {
        int NumElemSel;
        int Ocupados;
        sFileSelElem Elem[5];
} sFileSelDir;

enum EnumAccionFileSelDir {
        dirInit=0,
        dirSiguiente,
        dirAnterior,
        dirCompleta,
        dirRepinta,
};

enum EnumGuiActivo {
        guiNombre=0,
        guiBotones,
        guiLista
};

typedef enum EnumDialogBox {
        boxOk=0,
        boxOkCancel,
        boxYesNo,
} eDialogBox;

char *FileSel(char *Titulo, char *BufferSeleccion, int TamBuffer);
void DibujaVentana(char *Texto);
void DibujaFileSel(char *Texto);
void DibujaBotones(int NumSel);
void DibujaBoton(int x1, int y1, int x2, int y2, char *Texto, char BanderaSel);
void DibujaNombre(char *Nombre, char BanderaCursor);
void DibujaFichSel(int Pos,sFileSelElem *Elem);
void DibujaFichSelCursor(int Pos, char BanderaEstado);
void DibujaNombreDir(char *Texto);
void FileSelDirRellena(int Accion,sFileSelDir *Dir, char *Path);
void FileSelDirPinta(sFileSelDir *Dir, char *Path);
int FileSelDirProcesa(sFileSelDir *Dir, char *Path);
void NombreProcesa(char *Nombre, sTeclado *Teclado);

int DialogBox(char *Titulo,char *Mensaje, eDialogBox Tipo);
void DibujaBotonesDialogBox(int NumSel,char **Textos);

/* Funciones auxiliares */
char *fs_copiacad(char *Dest, char*Orig, int TamDest);
char *fs_copiamem(char *Dest, char*Orig, int NumBytes);
char *fs_initmem(char *Dest, int c, int NumBytes);
char *fs_strrchr(char *Cad, int c);
int fs_cmpcadmay(char *a, char *b);
void DTA2SelElem(char *DTA, sFileSelElem *Elem);
int cmpSelElem(sFileSelElem *a,sFileSelElem *b);



#ifdef PRUEBAS_ACTIVADAS
/* Programa de prueba */
int
main2(void)
{
        char Buf[128];
        char *Ptr;
        screen(1);
        cls(4);
        TinyfontInit();
        Buf[0]='\0';
#ifdef SPANISH
        Ptr=FileSel("Salvar como...",Buf,sizeof(Buf));
#else
        Ptr=FileSel("Save as...",Buf,sizeof(Buf));
#endif
#ifdef LINUX
        if(Ptr!=NULL)
                printf("Fichero seleccionado: \"%s\"\n",Ptr);
        else
                printf("Se cancel la seleccin.\n",Ptr);
#endif
        return(0);
}

int
main(void)
{
#if 0
        char Texto1[]={"Esto es\n  un texto curioso, porque como ya se sabe, no debera caber en tan pequeo espacio."};
        char Texto2[]={"1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0\nTECLADO\nEditor de textos\nDario Rodriguez\ndario@softhome.net"};
#endif
        char Texto[]={"Salvar fichero cancelado por orden del usuario"};
        int Sel;
        screen(1);
        cls(4);
        TinyfontInit();
#ifdef SPANISH
        Sel=DialogBox("Informacin",Texto,boxYesNo);
#else
        Sel=DialogBox("Error",Texto,boxYesNo);
#endif
#ifdef LINUX
        printf("Se seleccion: %li\n",(long) Sel);
#endif
        return(0);
}
#endif

/* Cuerpo de las funciones */

char *
FileSel(char *Titulo, char *BufferSeleccion, int TamBuffer)
{
        int GuiActual;
        char BufferNombre[8+1+3+1];
        int Tecla;
        int EstadoBotones;
        sTeclado Teclado;
        sFileSelDir Directorio;
        TecladoInit(&Teclado,PANEL_ALFA|PANEL_SYM|PANEL_NUM,PANEL_ALFA);
        DibujaFileSel(Titulo);
        lcdfreeze(1);
        {
                char *Ptr;
                if((Ptr=fs_strrchr(BufferSeleccion,'\\'))!=NULL) {
                        Ptr++;
                        if(*Ptr!='\0' && fs_strrchr(Ptr,'*')==NULL)
                                fs_copiacad(BufferNombre,Ptr,sizeof(BufferNombre));
                        else
#ifdef SPANISH
                                fs_copiacad(BufferNombre,"ANONIMO.TXT",sizeof(BufferNombre));
#else
                                fs_copiacad(BufferNombre,"NONAME.TXT",sizeof(BufferNombre));
#endif
                        *(Ptr++)='*';
                        *(Ptr++)='.';
                        *(Ptr++)='*';
                        *(Ptr++)='\0';
                } else {
#ifdef SPANISH
                        fs_copiacad(BufferNombre,"ANONIMO.TXT",sizeof(BufferNombre));
#else
                        fs_copiacad(BufferNombre,"NONAME.TXT",sizeof(BufferNombre));
#endif
                        fs_copiacad(BufferSeleccion,"B:\\*.*",TamBuffer);
                }
        }
        DibujaNombre(BufferNombre,1);
        DibujaNombreDir(BufferSeleccion);
        FileSelDirRellena(dirInit,&Directorio,BufferSeleccion);
        DibujaFichSelCursor(Directorio.NumElemSel,0);
        lcdfreeze(0);
        for(GuiActual=guiNombre,EstadoBotones=1,Tecla=0;;) {
                switch(GuiActual) {
                case guiNombre:
                        if((Tecla=EsperaTecla(0))&TECLA_ENTER) {
                                NombreProcesa(BufferNombre,&Teclado);
                                lcdfreeze(1);
                                DibujaFileSel(Titulo);
                                DibujaNombre(BufferNombre,1);
                                DibujaNombreDir(BufferSeleccion);
                                FileSelDirPinta(&Directorio,BufferSeleccion);
                                DibujaFichSelCursor(Directorio.NumElemSel,0);
                                lcdfreeze(0);
                        } else if(Tecla&(TECLA_ARR|TECLA_ABJ)) {
                                lcdfreeze(1);
                                DibujaNombre(BufferNombre,0);
                                EstadoBotones=((Tecla&TECLA_ARR)?2:1);
                                DibujaBotones(EstadoBotones);
                                lcdfreeze(0);
                                GuiActual=guiBotones;
                        }
                        break;
                case guiBotones:
                        if((Tecla=EsperaTecla(0))&TECLA_ENTER) {
                                if(EstadoBotones==1 && BufferNombre[0]!='\0') {
                                        char *Ptr;
                                        if((Ptr=fs_strrchr(BufferSeleccion,'\\'))==NULL)
                                                Ptr=BufferSeleccion;
                                        else
                                                Ptr++;
                                        fs_copiacad(Ptr,BufferNombre,TamBuffer-(Ptr-BufferSeleccion));
                                        return(BufferSeleccion);
                                } else if(EstadoBotones==2)
                                        return(NULL);
                        } else if(Tecla&(TECLA_ARR|TECLA_ABJ)) {
                                lcdfreeze(1);
                                if((EstadoBotones==1 && (Tecla&TECLA_ARR)) || (EstadoBotones==2 && (Tecla&TECLA_ABJ))) {
                                        DibujaBotones(0);
                                        DibujaNombre(BufferNombre,1);
                                        GuiActual=guiNombre;
                                } else {
                                        EstadoBotones=1+(1-(EstadoBotones-1));
                                        DibujaBotones(EstadoBotones);
                                }
                                lcdfreeze(0);
                        }
                        break;
                case guiLista:
                        Tecla=FileSelDirProcesa(&Directorio,BufferSeleccion);
                        if(Tecla==TECLA_ENTER && Directorio.NumElemSel>=0 && Directorio.NumElemSel<Directorio.Ocupados) {
                                fs_copiacad(BufferNombre,Directorio.Elem[Directorio.NumElemSel].Nombre,sizeof(BufferNombre));
                                lcdfreeze(1);
                                DibujaFichSelCursor(Directorio.NumElemSel,0);
                                DibujaNombre(BufferNombre,0);
                                EstadoBotones=1;
                                DibujaBotones(EstadoBotones);
                                lcdfreeze(0);
                                GuiActual=guiBotones;
                        }
                        break;
                }
                if(Tecla&TECLA_MENU) {
                        if(GuiActual==guiLista) {
                                lcdfreeze(1);
                                DibujaFichSelCursor(Directorio.NumElemSel,0);
                                DibujaNombre(BufferNombre,1);
                                lcdfreeze(0);
                                GuiActual=guiNombre;
                        } else {
                                lcdfreeze(1);
                                if(GuiActual==guiNombre) {
                                        DibujaNombre(BufferNombre,0);
                                } else
                                        DibujaBotones(0);
                                lcdfreeze(0);
                                DibujaFichSelCursor(Directorio.NumElemSel,1);
                                GuiActual=guiLista;
                        }
                }
        }
        return(NULL);
}


void
DibujaFileSel(char *Texto)
{
        DibujaVentana(Texto);
        gv_square(26,11,99,21,COPY_PUT,0xffffffff);
        gv_square(2,29,74,61,COPY_PUT,0xffffffff);
#ifdef SPANISH
        PonCadPeq(2,11,"Nombre");
#else
        PonCadPeq(2,11,"Name  ");
#endif
        DibujaBotones(0);
}

void
DibujaVentana(char *Texto)
{
#if 0
        gv_clear(0,0,101,63);
        gv_kput(2,0,Texto,7,1,1);
        gv_reverse(0,0,101,9);
        gv_square(0,0,101,63,COPY_PUT,0xffffffff);
#else
        gv_clear(0,0,101,63);
        gv_kput(2,0,Texto,7,2,1);
        gv_kput(3,0,Texto,7,2,1);
        gv_square(0,9,101,63,COPY_PUT,0xffffffff);
#endif
}

void
DibujaBotones(int NumSel)
{
        DibujaBoton(76,32,99,45,"O.K.",NumSel&1);
        DibujaBoton(76,46,99,58,"Cncl",NumSel&2);
}


void
DibujaBoton(int x1, int y1, int x2, int y2, char *Texto, char BanderaSel)
{
        int i;
        int x,y;
#if 0
        signed char Normal[][2]={{1,3},
                                 {3,1},
                                 {-3,1},
                                 {-1,3},
                                 {-1,-3},
                                 {-3,-1},
                                 {3,-1},
                                 {1,-3},
                                 {1,3},
                                 {0,0}};
        gv_clear(x1,y1,x2,y2);
        for(i=0;Normal[i+1][0]!=0;i++)
                gv_line(((Normal[i][0]>=0)?x1:x2)+Normal[i][0],
                        ((Normal[i][1]>=0)?y1:y2)+Normal[i][1],
                        ((Normal[i+1][0]>=0)?x1:x2)+Normal[i+1][0],
                        ((Normal[i+1][1]>=0)?y1:y2)+Normal[i+1][1],
                        0,0xff);
        if(BanderaSel) {
        for(i=0;Normal[i+1][0]!=0;i++)
                gv_line(((Normal[i][0]>=0)?x1-1:x2+1)+Normal[i][0],
                        ((Normal[i][1]>=0)?y1-1:y2+1)+Normal[i][1],
                        ((Normal[i+1][0]>=0)?x1-1:x2+1)+Normal[i+1][0],
                        ((Normal[i+1][1]>=0)?y1-1:y2+1)+Normal[i+1][1],0,0xff);
        }
#else
        gv_clear(x1,y1,x2,y2);
        gv_line(x1+1,y1+3,x1+3,y1+1,0,0xff);
        gv_line(x1+3,y1+1,x2-3,y1+1,0,0xff);
        gv_line(x2-3,y1+1,x2-1,y1+3,0,0xff);
        gv_line(x2-1,y1+3,x2-1,y2-3,0,0xff);
        gv_line(x2-1,y2-3,x2-3,y2-1,0,0xff);
        gv_line(x2-3,y2-1,x1+3,y2-1,0,0xff);
        gv_line(x1+3,y2-1,x1+1,y2-3,0,0xff);
        gv_line(x1+1,y2-3,x1+1,y1+3,0,0xff);
        if(BanderaSel) {
                gv_line(x1,y1+2,x1+2,y1,0,0xff);
                gv_line(x1+2,y1,x2-2,y1,0,0xff);
                gv_line(x2-2,y1,x2,y1+2,0,0xff);
                gv_line(x2,y1+2,x2,y2-2,0,0xff);
                gv_line(x2,y2-2,x2-2,y2,0,0xff);
                gv_line(x2-2,y2,x1+2,y2,0,0xff);
                gv_line(x1+2,y2,x1,y2-2,0,0xff);
                gv_line(x1,y2-2,x1,y1+2,0,0xff);
        }
#endif
        for(i=0;Texto[i]!='\0';i++)
                ;
        i--;
        x=(x1+x2)/2-i*2;
        y=(y1+y2)/2-2;
        PonCadPeq(x,y,Texto);
}

void
DibujaNombre(char *Nombre, char BanderaCursor)
{
        int i;
        int x;
        char *Ptr;
        x=28;
        gv_clear(27,12,98,20);
        if((Ptr=fs_strrchr(Nombre,'.'))!=NULL) {
                *Ptr='\0';
        }
        gv_kput(x,12,Nombre,2,0,KCOPY_PUT);
        for(i=0;Nombre[i]!='\0';i++)
                x+=6;
        if(Ptr!=NULL) {
                *Ptr='.';
                gv_kput(x,12,".",2,0,KCOPY_PUT);
                x+=4,i++;
                gv_kput(x,12,Nombre+i,2,0,KCOPY_PUT);
                for(;Nombre[i]!='\0';i++)
                        x+=6;
        }
        if(BanderaCursor) {
                gv_line(x-1,19,x,18,0,0xff);
                gv_line(x,18,x+1,19,0,0xff);
        }

}

void
DibujaFichSel(int Pos,sFileSelElem *Elem)
{
        int x,y;
        int i;
        x=4;
        y=31+Pos*6;
        gv_clear(3,y,73,y+5);
        if(Elem->Tipo=='D' && Elem->Nombre[0]=='.' && (Elem->Nombre[1]=='\0' || (Elem->Nombre[1]=='.' && Elem->Nombre[2]=='\0'))) {
                PonCadPeq(x,y,Elem->Nombre);
        } else {
                for(i=0;i<8 && Elem->Nombre[i]!='.' && Elem->Nombre[i]!='\0';i++,x+=4)
                        PonLetraPeq(x,y,MAYMINSEGUNTIPO(Elem->Nombre[i],Elem->Tipo));
                if(Elem->Nombre[i]=='.')
                        i++;
                gv_pset(36,y+4,4);
                for(x=38;Elem->Nombre[i]!='\0' && x<50;i++,x+=4)
                        PonLetraPeq(x,y,MAYMINSEGUNTIPO(Elem->Nombre[i],Elem->Tipo));
                if(Elem->Tipo!='D') {
                        y++;
                        PonNumEnano(52,y,Elem->Dia/10);
                        PonNumEnano(55,y,Elem->Dia%10);
                        gv_pset(58,y+2,4);
                        PonNumEnano(60,y,Elem->Mes/10);
                        PonNumEnano(63,y,Elem->Mes%10);
                        gv_pset(66,y+2,4);
                        PonNumEnano(68,y,Elem->Anio/10);
                        PonNumEnano(71,y,Elem->Anio%10);
                }
        }
}

void
DibujaFichSelCursor(int Pos, char BanderaEstado)
{
        int y;
        y=31+Pos*6;
        if(Pos<0 || Pos>=NUMFICHSEL)
                return;
        if(BanderaEstado)
                BanderaEstado=1;
        if((BanderaEstado^gv_point(3,y))!=0)
                gv_reverse(3,y,73,y+5);
}


void
DibujaNombreDir(char *Texto)
{
        char *Ptr;
        char Letra=0;
        gv_clear(2,23,100,28);
        if((Ptr=fs_strrchr(Texto,'\\'))!=NULL) {
                Letra=Ptr[1];
                Ptr[1]='\0';
        }
        PonCadPeq(2,23,Texto);
        if(Ptr!=NULL)
                Ptr[1]=Letra;
}

void
FileSelDirRellena(int Accion,sFileSelDir *Dir, char *Path)
{
        int i,j,res;
        int InsertaEn,Res;
        int OcupadosAnt;
        sFileSelElem Nuevo;
        sFileSelElem Referencia;
        unsigned char MiDTA[44];
        char BanderaInsertarPost;
        char BanderaInsertarPre;
        int Prescindibles;
        void *Ptr;
        fs_initmem((char *) (&Referencia),0,sizeof(sFileSelElem));
        if(Accion==dirAnterior) {
                if(Dir->Ocupados>0)
                        fs_copiamem((char *) (&Referencia),(char *) (Dir->Elem),sizeof(sFileSelElem));
        } else if(Accion==dirSiguiente || Accion==dirCompleta) {
                if(Dir->Ocupados>0)
                        fs_copiamem((char *) (&Referencia),(char *) (Dir->Elem+Dir->Ocupados-1), sizeof(sFileSelElem));
        } else { /* Accion==dirInit */
                for(i=0;i<(sizeof(Dir->Elem)/sizeof(Dir->Elem[0]));i++)
                        fs_initmem((char *) (Dir->Elem+i),0,sizeof(sFileSelElem));
        }
        Dir->NumElemSel=0;
        OcupadosAnt=Dir->Ocupados;
        if(Accion!=dirCompleta)
                Dir->Ocupados=0;
        else
                Accion=dirSiguiente;
        Dir->NumElemSel=0;
        Ptr=dos_getdta();
        dos_setdta(MiDTA);
        for(res=dos_fnd_first(Path,0x10),Prescindibles=0;res==0;res=dos_fnd_next()) {
                DTA2SelElem(MiDTA,&Nuevo);
                for(i=0,InsertaEn=Dir->Ocupados,Res=1;i<Dir->Ocupados;i++) {
                        if((Res=cmpSelElem(&Nuevo,Dir->Elem+i))<=0) {
                                InsertaEn=i;
                                break;
                        }
                }
                if(Res==0 || i>=NUMFICHSEL) {
                        continue;
                }
                BanderaInsertarPost=BanderaInsertarPre=0;
                if(Accion==dirInit || Accion==dirSiguiente) {
                        if(InsertaEn<NUMFICHSEL && cmpSelElem(&Referencia,&Nuevo)<0)
                                BanderaInsertarPost=1;
                }
                else if(cmpSelElem(&Referencia,&Nuevo)>0) { /* Accion==dirAnterior */
                        if(Dir->Ocupados<NUMFICHSEL || Prescindibles) {
                                if(Dir->Ocupados==NUMFICHSEL) {
                                        Prescindibles--;
                                        Dir->Ocupados--;
                                }
                                BanderaInsertarPost=1;
                        } else if((--InsertaEn)>=0)
                                BanderaInsertarPre=1;
                } else if(Dir->Ocupados<NUMFICHSEL || Prescindibles) {
                        if(Dir->Ocupados<NUMFICHSEL)
                                Prescindibles++;
                        BanderaInsertarPost=1;
                }
                if(BanderaInsertarPost) {
                        for(j=NUMFICHSEL-2;j>=InsertaEn;j--)
                                fs_copiamem((char *) (Dir->Elem+j+1),(char *) (Dir->Elem+j),sizeof(sFileSelElem));
                        fs_copiamem((char *) (Dir->Elem+InsertaEn),(char *) (&Nuevo),sizeof(sFileSelElem));
                        if(Dir->Ocupados<NUMFICHSEL)
                                Dir->Ocupados++;
                } else if(BanderaInsertarPre) {
                        for(j=1;j<=InsertaEn;j++)
                                fs_copiamem((char *) (Dir->Elem+j-1),(char *) (Dir->Elem+j),sizeof(sFileSelElem));
                        fs_copiamem((char *) (Dir->Elem+InsertaEn),(char *) (&Nuevo),sizeof(sFileSelElem));
                }
        }
        dos_setdta(Ptr);
        if(Accion!=dirInit && (Dir->Ocupados==0 || Prescindibles==Dir->Ocupados)) {
                DibujaFichSelCursor(Dir->NumElemSel,0);
                Dir->Ocupados=OcupadosAnt;
                if(Accion!=dirAnterior)
                        Dir->NumElemSel=Dir->Ocupados-1;
                DibujaFichSelCursor(Dir->NumElemSel,1);
        } else {
                if(Accion==dirAnterior)
                        Dir->NumElemSel=Dir->Ocupados-1-Prescindibles;
                FileSelDirPinta(Dir,Path);
        }
}

void
FileSelDirPinta(sFileSelDir *Dir, char *Path)
{
        int i;
        for(i=0;i<Dir->Ocupados;i++) {
                DibujaFichSel(i,Dir->Elem+i);
                if(Dir->NumElemSel==i)
                        DibujaFichSelCursor(i,1);
        }
        if(i<NUMFICHSEL)
                gv_clear(3,31+i*6,73,31+4*6+5);
}


int
FileSelDirProcesa(sFileSelDir *Dir, char *Path)
{
        int Tecla;
        char BanderaAtras;
        do {
                BanderaAtras=0;
                Tecla=EsperaTecla(TECLA_ARR | TECLA_ABJ);
                if(Tecla&TECLA_ABJ) {
                        if((Dir->NumElemSel+1)<Dir->Ocupados) {
                                DibujaFichSelCursor(Dir->NumElemSel++,0);
                                DibujaFichSelCursor(Dir->NumElemSel,1);
                        } else {
                                FileSelDirRellena( dirSiguiente, Dir, Path);
                        }
                } else if(Tecla&TECLA_ARR) {
                        if(Dir->NumElemSel>0) {
                                DibujaFichSelCursor(Dir->NumElemSel--,0);
                                DibujaFichSelCursor(Dir->NumElemSel,1);
                        } else {
                                FileSelDirRellena( dirAnterior, Dir, Path);
                        }
                } else if(Tecla&TECLA_IZQ)
                        BanderaAtras=1;
                else if(Tecla&(TECLA_ENTER|TECLA_DER) && Dir->NumElemSel>=0 && Dir->NumElemSel<Dir->Ocupados) {
                        if(Dir->Elem[Dir->NumElemSel].Tipo=='D') {
                                sFileSelElem *Elem;
                                char *Ptr;
                                Elem=Dir->Elem+Dir->NumElemSel;
                                if(Elem->Nombre[0]=='.' && Elem->Nombre[1]=='.' && Elem->Nombre[2]=='\0') {
                                        BanderaAtras=1;
                                } else if(!(Elem->Nombre[0]=='.' && Elem->Nombre[1]=='\0')) {
                                        int EspacioNombre,TamMascara,i;
                                        for(EspacioNombre=0;Elem->Nombre[EspacioNombre]!='\0';EspacioNombre++)
                                                ;
                                        if((Ptr=fs_strrchr(Path,'\\'))!=NULL) {
                                                for(TamMascara=0;Ptr[TamMascara]!='\0';TamMascara++)
                                                        ;
                                                for(i=TamMascara;i>=0;i--)
                                                        Ptr[EspacioNombre+1+i]=Ptr[i];
                                                for(i=0;Elem->Nombre[i]!='\0';i++)
                                                        Ptr[i+1]=Elem->Nombre[i];
                                                Ptr[i+1+TamMascara]='\0';
                                                DibujaNombreDir(Path);
                                                FileSelDirRellena( dirInit, Dir, Path);
                                        }
                                }
                        } else if(Tecla&TECLA_ENTER)
                                return(TECLA_ENTER);
                }
                if(BanderaAtras) {
                        char *Ptr,*Ptr2;
                        if((Ptr=fs_strrchr(Path,'\\'))!=NULL && Ptr>Path) {
                                *Ptr=' ';
                                if((Ptr2=fs_strrchr(Path,'\\'))!=NULL) {
                                        int i;
                                        *Ptr='\\';
                                        Dir->NumElemSel=0;
                                        Dir->Ocupados=1;
                                        Dir->Elem->Tipo='D';
                                        for(i=0;Ptr2[1+i]!='\\';i++)
                                                Dir->Elem->Nombre[i]=A_MAYUSCULAS(Ptr2[1+i]);
                                        Dir->Elem->Nombre[i]='\0';
                                        for(i=0;Ptr[i]!='\0';i++)
                                                Ptr2[i]=Ptr[i];
                                        Ptr2[i]='\0';
                                        DibujaNombreDir(Path);
                                        FileSelDirRellena( dirCompleta, Dir, Path);
                                } else {
                                        *Ptr='\\';
                                        FileSelDirRellena( dirInit, Dir, Path);
                                }
                        }
                }
        } while(!(Tecla&TECLA_MENU));
        return(Tecla);
}

void
NombreProcesa(char *Nombre, sTeclado *Teclado)
{
        char BanderaExtension;
        int LetrasNombre;
        int LetrasExtension;
        int t,i;
        BanderaExtension=0,LetrasNombre=LetrasExtension=0;
        for(i=0;Nombre[i]!='\0';i++) {
                if(Nombre[i]=='.') {
                        BanderaExtension=1;
                        continue;
                }
                if(!BanderaExtension)
                        LetrasNombre++;
                else
                        LetrasExtension++;

        }
        while(1) {
                t=TecladoLee(Teclado);
                if(t==(TECLA_ENTER<<8)) {
                        break;
                } else if(t==TECLADO_BORRAR && (LetrasNombre>0 || LetrasExtension>0 || BanderaExtension)) {
                        if(LetrasExtension)
                                LetrasExtension--;
                        else if(BanderaExtension)
                                BanderaExtension=0;
                        else
                                LetrasNombre--;
                        Nombre[LetrasNombre+LetrasExtension+BanderaExtension]='\0';
                        DibujaNombre(Nombre,1);
                } else if(t!=TECLADO_BORRAR && t>0 && t<256) {
                        if(t!='.' && ((!BanderaExtension && LetrasNombre<8) || (BanderaExtension && LetrasExtension<3))) {
                                Nombre[LetrasNombre+LetrasExtension+BanderaExtension]=A_MAYUSCULAS(t);
                                if(BanderaExtension)
                                        LetrasExtension++;
                                else
                                        LetrasNombre++;
                                Nombre[LetrasNombre+LetrasExtension+BanderaExtension]='\0';
                                DibujaNombre(Nombre,1);
                        } else if(t=='.' && !BanderaExtension) {
                                Nombre[LetrasNombre+LetrasExtension+BanderaExtension]=t;
                                BanderaExtension=1;
                                Nombre[LetrasNombre+LetrasExtension+BanderaExtension]='\0';
                                DibujaNombre(Nombre,1);
                        }
                }
        }
}



/* Cuerpo de las funciones auxiliares */

char *
fs_copiacad(char *Dest, char*Orig, int TamDest)
{
        int i;
        if(TamDest<=0)
                return(Dest);
        for(i=0,TamDest--;i<TamDest && Orig[i]!='\0';i++)
                Dest[i]=Orig[i];
        Dest[i]='\0';
        return(Dest);
}

char *
fs_copiamem(char *Dest, char*Orig, int NumBytes)
{
        int i;
        for(i=0;i<NumBytes;i++)
                Dest[i]=Orig[i];
        return(Dest);
}

char *
fs_initmem(char *Dest, int c, int NumBytes)
{
        int i;
        for(i=0;i<NumBytes;i++)
                Dest[i]=c;
        return(Dest);
}

char *
fs_strrchr(char *Cad, int c)
{
        char *Ptr;
        for(Ptr=NULL;*Cad!='\0';Cad++) {
                if(*Cad==c)
                        Ptr=Cad;
        }
        return(Ptr);
}

int
fs_cmpcadmay(char *a, char *b)
{
        while(*a==A_MAYUSCULAS(*b) && *a!='\0')
                a++,b++;
        return(*a-A_MAYUSCULAS(*b));
}


void
DTA2SelElem(char *DTA, sFileSelElem *Elem)
{
        Elem->Tipo=((DTAATRIB(DTA)&0x10)?'D':'F');
        fs_copiacad(Elem->Nombre,DTANAME(DTA),sizeof(Elem->Nombre));
        Elem->Dia=(DTADATE(DTA) & 31);
        Elem->Mes=((DTADATE(DTA)>>5) & 15);
        Elem->Anio=(((DTADATE(DTA)>>9) & 127)+80)%100;
}

int
cmpSelElem(sFileSelElem *a,sFileSelElem *b)
{
        int i,Res;
        for(i=0;i<((sizeof(a->Tipo)+sizeof(a->Nombre))-1) && ((char *)a)[i]!='\0';i++) {
                if((Res=(((char *)a)[i]-((char *)b)[i]))!=0)
                        return(Res);
        }
        return(((char *)a)[i]-((char *)b)[i]);
}

/************* Dialog Box *************/
int
DialogBox(char *Titulo,char *Mensaje, eDialogBox Tipo)
{
        char Ok[]={"O.K."};
        char Cancel[]={"Cncl"};
        char No[]={"No"};
#ifdef SPANISH
        char Yes[]={"S"};
#else
        char Yes[]={"Yes"};
#endif
        char *Textos[3];
        int Actual,NumBot,Tecla;
        int i,px,py;
        /* Dibujamos la ventana de dilogo */
        DibujaVentana(Titulo);
        /* Seleccionamos el texto de los botones */
        switch(Tipo) {
                case boxOkCancel:
                        Textos[0]=Cancel;
                        Textos[1]=Ok;
                        Textos[2]=NULL;
                        NumBot=2;
                        break;
                case boxYesNo:
                        Textos[0]=No;
                        Textos[1]=Yes;
                        Textos[2]=NULL;
                        NumBot=2;
                        break;
                case boxOk:
                default:
                        Textos[0]=Ok;
                        Textos[1]=NULL;
                        NumBot=1;
                        break;
        }
        /* Pintamos el contenido */
        {
                char Letra[2]={" "};
                char Letra2[2]={" "};
                int j,pxtemp;
                int SigTam;
                for(i=0,px=2,py=11,Letra[0]=Mensaje[0],SigTam=getUsWdot(7,Letra);Mensaje[i]!='\0' && py<40;i++) {
                        Letra[0]=Mensaje[i];
                        gv_kput(px,py,Letra,7,0,0);
                        if(Letra[0]==' ') {
                                for(j=i+1,pxtemp=px;Mensaje[j]!='\0' && Mensaje[j]!='\n' && Mensaje[j]!=' ' && pxtemp<99;Letra2[0]=Mensaje[j],pxtemp+=getUsWdot(7,Letra2),j++)
                                        ;
                                if(pxtemp>=99)
                                        Letra[0]='\n';
                        }
                        px+=SigTam;
                        Letra2[0]=Mensaje[i+1];
                        SigTam=getUsWdot(7,Letra2);
                        if((px+SigTam)>99 || Letra[0]=='\n') {
                                px=2;
                                py+=8;
                        }
                }
        }
        /* Bucle principal */
        Actual=0;
        lcdfreeze(1);
        DibujaBotonesDialogBox(Actual,Textos);
        lcdfreeze(0);
        while(1) {
                if((Tecla=EsperaTecla(0))&TECLA_ENTER)
                        break;
                else if(Tecla&(TECLA_DER|TECLA_IZQ)) {
                        lcdfreeze(1);
                        if(Tecla&TECLA_DER)
                                Actual++;
                        else
                                Actual+=NumBot-1;
                        Actual%=NumBot;
                        DibujaBotonesDialogBox(Actual,Textos);
                        lcdfreeze(0);
                }
        }
        return(NumBot-1-Actual);
}

#define TAMBOTONX 23
#define TAMBOTONY 13
#define ESPACIOBOTONX 4
#define ESPACIOBOTONY 4
#define IBOTONX (TAMBOTONX+ESPACIOBOTONX)
#define IBOTONY (TAMBOTONY+ESPACIOBOTONY)

void
DibujaBotonesDialogBox(int NumSel,char **Textos)
{
        int i;
        for(i=0;Textos[i]!=NULL;i++)
                DibujaBoton(98-TAMBOTONX-IBOTONX*i,61-TAMBOTONY,98-IBOTONX*i,61,Textos[i],(NumSel==i)?1:0);
}


#endif
