/*
 * ohothello.c
 *
 *  El juego de Othello basado en el algoritmo del Othello del libro de
 * Tim Hartnell "El libro gigante de los juegos para ZX Spectrum"
 *
 * Historia:
 *      06/05/01 Creacin.
 *      11/05/01 Paso lo que llevaba a generapos.c y empiezo el programa
 *               propiamente dicho.
 *      20/05/01 Hago que pinte el tablero y el nombre del juego. Hago el
 *               dibujo de las fichas. Hago que ponga las puntuaciones.
 *               Hago una matriz con las fichas del tablero y que vuelque a
 *               pantalla su contenido.
 *      22/05/01 Hago que pinte el cursor (el seleccionado). Hago que mire si
 *               una posicin es vlida o no y que pueda mover el cursor.
 *      23/05/01 Generalizo la funcin de mirar si es casilla vlida para que
 *               tambin haga lo de comer fichas. Hago que el jugador pueda
 *               poner una ficha.
 *      27/05/01 Le pongo una portada, hago que diga el ganador cuando termina
 *               la partida, pongo el contador de tiempo y.... Ya est! Doy el
 *               programa por finalizado; ya hace todo lo que pretenda ;-).
 *      26/07/01 Pongo las pantallas de fin de juego para jugador y onhand.
 *
 */

#include <lcdbios.h>
#include <rupsys.h>
#include <wbios.h>
#include <ruptool.h>
#include <psdos.h>
#include "posiciones.h"
#include "pensador.h"
#include "portada.h"
#include "finjugador.h"
#include "finonhand.h"
#include "tinyfont.h"
#include "teclado.h"

static char Fichas[4][11]= {
        {7,0,7,0,0, 0, 0, 0, 0, 0,0}, /* vaco */
        {7,0,7,0,0,28,34,34,34,28,0}, /* blanca */
        {7,0,7,0,0,28,62,62,62,28,0}, /* negra */
        {7,0,7,0,99,65,0,0,0,65,99}, /* seleccionada */
};

static char Tablero[8][8];

enum eOpCasillas { opValida, opComeFichas };

enum eResJuego { gananBlancas, gananNegras, gananEmpate };

#define FICHA_VACIO   0
#define FICHA_BLANCA  1
#define FICHA_NEGRA   2
#define FICHA_MARCADA 3
#define PonFicha(x,y,Num) gv_put(x,y,&(Fichas[((int) (Num))][0]),COPY_PUT)
#define casilla_valida(x,y,f) casilla_manipula(x,y,f,opValida)
#define casilla_come(x,y,f) casilla_manipula(x,y,f,opComeFichas)



void pinta_tablero(void);
void pinta_fichas(void);
void pinta_puntuaciones(int puntosbl,int puntosne);
void pinta_tiempo(int hora, int min, int seg);
void pensando(int Activo);
void selecciona_casilla(int x, int y, int Ficha);
int casilla_manipula(int x, int y, int Ficha, int Op);

int
main(void)
{
        int i, x, y, xaux, yaux, Tecla;
        int PuntNegro, PuntBlanco, PuntInc;
        int hora,min,seg,iniseg,uhora,uinchora,useg,Contando;
        int EstadoJuego;
        unsigned char Hora,Min,Seg;
        char BanderaActualiza,BanderaValida,BanderaSalir,BanderaFin;
        screen(1);
        cls(4);
        TinyfontInit();
        gv_put(0,0,portada,COPY_PUT);
        while((Tecla=(EsperaTecla(0)&0xff))!=TECLA_MENU && Tecla!=TECLA_ENTER)
                ;
        cls(4);
        pinta_tablero();
        PonCadPeq(68,1,"Othello");
        for(i=0;i<(8*8);i++)
                ((char *)Tablero)[i]=0;
        Tablero[3][3]=Tablero[4][4]=FICHA_NEGRA;
        Tablero[3][4]=Tablero[4][3]=FICHA_BLANCA;
        pinta_fichas();
        PuntNegro=PuntBlanco=2;
        pinta_puntuaciones(PuntNegro,PuntBlanco);
        x=3,y=2,Tecla=0,BanderaValida=0;
        if(casilla_valida(x,y,FICHA_BLANCA)) {
                selecciona_casilla(x,y,FICHA_BLANCA);
                BanderaValida=1;
        } else
                selecciona_casilla(x,y,FICHA_VACIO);
        hora=0,min=0,seg=0;
        uhora=-1,uinchora=useg=iniseg=0;
        pinta_tiempo(hora,min,seg);
        pSystemCtl->EventManager->eventReq |= EVENT_SEC;
        for(EstadoJuego=-1,Contando=0,BanderaActualiza=0,BanderaFin=0; (Tecla=(EsperaTecla(0)&0xff))!=TECLA_MENU; BanderaActualiza=0) {
                if(Tecla==TECLA_IZQ && x>0) {
                        x--;
                        BanderaActualiza++;
                } else if(Tecla==TECLA_DER && x<7) {
                        x++;
                        BanderaActualiza++;
                } else if(Tecla==TECLA_ARR && y>0) {
                        y--;
                        BanderaActualiza++;
                } else if(Tecla==TECLA_ABJ && y<7) {
                        y++;
                        BanderaActualiza++;
                } else if(Tecla==TECLA_ENTER && BanderaValida) {
                        Contando=1;
                        Tablero[x][y]=FICHA_BLANCA;
                        PuntInc=casilla_come(x,y,FICHA_BLANCA);
                        PuntBlanco=PuntBlanco+1+PuntInc;
                        PuntNegro-=PuntInc;
                        pinta_puntuaciones(PuntNegro,PuntBlanco);
                        selecciona_casilla(x,y,-1);
                        pinta_fichas();
                        BanderaActualiza=1;
                        pensando(1);
                        for(BanderaSalir=0;!BanderaSalir;) {
                                if(PuntNegro==0) {
                                        BanderaFin=1;
                                        break; /* Fin del juego, no hay casillas negras*/
                                }
                                for(i=0;ListaPosiciones[i].x!=-1;i++) {
                                        if(casilla_valida(ListaPosiciones[i].x, ListaPosiciones[i].y, FICHA_NEGRA)) {
                                                Tablero[ListaPosiciones[i].x][ListaPosiciones[i].y]=FICHA_NEGRA;
                                                PuntInc=casilla_come(ListaPosiciones[i].x, ListaPosiciones[i].y,FICHA_NEGRA);
                                                PuntNegro=PuntNegro+1+PuntInc;
                                                PuntBlanco-=PuntInc;
                                                pinta_puntuaciones(PuntNegro,PuntBlanco);
                                                pinta_fichas();
                                                break;
                                        }
                                }
                                if(PuntNegro+PuntBlanco==64 || PuntBlanco==0) {
                                        BanderaFin=1;
                                        break; /* Fin del juego, no hay casillas vacas y no hay blancas */
                                }
                                /* comprobamos si el jugador tiene que pasar turno */
                                for(i=0;i<(8*8);i++) {
                                        xaux=i/8;
                                        yaux=i%8;
                                        if(casilla_valida(xaux,yaux,FICHA_BLANCA)) {
                                                BanderaSalir++; /* Puede jugar */
                                                break;
                                        }
                                }
                        }
                        pensando(0);
                }
                if(BanderaActualiza) {
                        if(casilla_valida(x,y,FICHA_BLANCA)) {
                                selecciona_casilla(x,y,FICHA_BLANCA);
                                BanderaValida=1;
                        } else {
                                selecciona_casilla(x,y,FICHA_VACIO);
                                BanderaValida=0;
                        }
                }
                if(Contando) {
                        bi_tmread(&Hora,&Min,&Seg);
                        Hora=(((Hora>>4)&0xf)*10+(Hora&0xf));
                        Min=(((Min>>4)&0xf)*10+(Min&0xf));
                        Seg=(((Seg>>4)&0xf)*10+(Seg&0xf));
                        if(uhora==-1) {
                                uhora=Hora;
                                uinchora=0;
                                iniseg=(((int)Hora)*3600)+((int)Min)*60+((int)Seg);
                        } else {
                                if(uhora>Hora)
                                        uinchora+=24;
                                uhora=Hora;
                                useg=((uhora+uinchora)*3600)+((int)Min)*60+((int)Seg)-iniseg;
                                hora=((signed int)(((unsigned int)useg)/3600));
                                min=((signed int)((((unsigned int)useg)/60)%60));
                                seg=((signed int)(((unsigned int)useg)%60));
                        }
                        pinta_tiempo(hora,min,seg);
                }
                if(BanderaFin==1) {
                        Contando=0;
                        BanderaFin=2;
                        gv_clear(67,7,99,22);
                        gv_square(67,7,99,22,COPY_PUT,0xffffffff);
                        if(PuntBlanco>PuntNegro) {
                                PonCadPeq(70,9,"GANAN:");
                                PonCadPeq(70,16,"BLANCAS");
                                EstadoJuego=gananBlancas;
                        } else if(PuntNegro>PuntBlanco) {
                                PonCadPeq(70,9,"GANAN:");
                                PonCadPeq(73,16,"NEGRAS");
                                EstadoJuego=gananNegras;
                        } else {
                                PonCadPeq(72,12,"EMPATE");
                                EstadoJuego=gananEmpate;
                        }
                }
        }
        selecciona_casilla(2,2,-1);
        if(EstadoJuego==gananNegras || EstadoJuego==gananBlancas) {
                gv_put(0,0,((EstadoJuego==gananNegras)?finonhand:finjugador),COPY_PUT);
                while((Tecla=(EsperaTecla(0)&0xff))!=TECLA_MENU && Tecla!=TECLA_ENTER)
                        ;
        }
        return(0);
}

void
pinta_tablero(void)
{
        int i;
        lcdfreeze(1);
        gv_clear(0,0,8*8-1,8*8-1);
        for(i=1;i<8;i++) {
                gv_line((i<<3)-1,0,(i<<3)-1,8*8-2,COPY_PUT,0xff);
                gv_line(0,(i<<3)-1,8*8-2,(i<<3)-1,COPY_PUT,0xff);
        }
        lcdfreeze(0);
}

void
pinta_fichas(void)
{
        int i,j;
        lcdfreeze(1);
        for(i=0;i<8;i++) {
                for(j=0;j<8;j++)
                        PonFicha(i<<3,j<<3,Tablero[i][j]);
        }
        lcdfreeze(0);
}

void
pinta_puntuaciones(int puntosbl,int puntosne)
{
        int pos;
        lcdfreeze(1);
        gv_clear(76,22,92,36);
        PonFicha(86,23,FICHA_NEGRA);
        PonFicha(86,31,FICHA_BLANCA);
        pos=81-((puntosbl>=10)?4:0);
        PonIntPeq(pos,24,puntosbl);
        pos=81-((puntosne>=10)?4:0);
        PonIntPeq(pos,32,puntosne);
        lcdfreeze(0);
}

void
pinta_tiempo(int hora, int min, int seg)
{
        int pos;
        lcdfreeze(1);
        gv_clear(66,45,101,63);
        PonCadPeq(67,46,"Tiempo");
        pos=75-((hora>=10)?4:0);
        PonIntPeq(pos,55,hora);
        gv_pset(79,56,1<<2 | COPY_PUT);
        gv_pset(79,58,1<<2 | COPY_PUT);
        PonLetraPeq(81,55,(((unsigned int)min)/10)+'0');
        PonLetraPeq(85,55,(((unsigned int)min)%10)+'0');
        PonLetraPeq(91,55,(((unsigned int)seg)/10)+'0');
        PonLetraPeq(95,55,(((unsigned int)seg)%10)+'0');
        gv_reverse(66,45,101,63);
        lcdfreeze(0);
}


void
pensando(int Activo)
{
        if(Activo)
                gv_put(72,8,Pensador,COPY_PUT);
        else
                gv_clear(72,8,91,20);
}

void
selecciona_casilla(int x, int y, int Ficha)
{
        static int Manejador=-1;
        static int BufferCogido=0;
        static char Buffer[11];
        static int px,py;
        if(Manejador!=-1) {
                blend(Manejador);
                Manejador=-1;
        }
        if(BufferCogido) {
                gv_put(px,py,Buffer,COPY_PUT);
                BufferCogido=0;
        }
        if(Ficha!=FICHA_VACIO && Ficha!=FICHA_BLANCA && Ficha!=FICHA_NEGRA)
                return;
        px=(x<<3);
        py=(y<<3);
        gv_get(px,py,px+6,py+6,Buffer);
        BufferCogido=1;
        if(Ficha!=FICHA_VACIO) {
                PonFicha(px,py,Ficha);
                Manejador=blink(px+1,py+1,px+6-1,py+6-1,0x60);
        }
        gv_put(px,py,&(Fichas[FICHA_MARCADA][0]),OR_PUT);
}


int
casilla_manipula(int x, int y, int Ficha, int Op)
{
        int incx,incy,px,py;
        int complem;
        int comidas=0;
        char BanderaSalirBucle=0;
        complem=(2-(Ficha-1));
        if(Op==opValida && Tablero[x][y]!=FICHA_VACIO)
                return(0);
        for(incx=-1;incx<=1;incx++) {
            for(incy=-1;incy<=1;incy++) {
                if(!incx && !incy)
                    continue;
                px=x+incx;
                py=y+incy;
                if(px>=0 && px<8 && py>=0 && py<8) {
                    if(Tablero[px][py]==complem) {
                        for(BanderaSalirBucle=0;!BanderaSalirBucle;) {
                            px+=incx;
                            py+=incy;
                            if(!(px>=0 && px<8 && py>=0 && py<8) || Tablero[px][py]==FICHA_VACIO)
                                break;
                            if(Tablero[px][py]==Ficha) {
                                if(Op==opComeFichas) {
                                    while(1) {
                                        px-=incx;
                                        py-=incy;
                                        Tablero[px][py]=Ficha;
                                        comidas++;
                                        if(px==(x+incx) && py==(y+incy)) {
                                            BanderaSalirBucle++;
                                            break;
                                        }
                                    }
                                } else
                                    return(1);
                            }
                        }
                    }
                }
            }
        }
        return(comidas);
}

