make small
echo "This script tests various algorithms over numerous"
echo "small random matrices."
echo "It should provide unrealistic, but reliable comparisons."
echo
NUMBER_OF_ROWS=4
NUMBER_OF_COLS=4
NUMBER_OF_TRIALS=1000 
echo "First, we test with a dense cube (50%)."
NUMBER_OF_ALLOCATED_CELLS=8 # 8/(4*4) = 1/2 
eval ./small $NUMBER_OF_ROWS $NUMBER_OF_COLS $NUMBER_OF_ALLOCATED_CELLS $NUMBER_OF_TRIALS 
echo
echo "Then we test with a sparse one (25%)."
NUMBER_OF_ALLOCATED_CELLS=4 # 4/(4*4) = 1/4
eval ./small $NUMBER_OF_ROWS $NUMBER_OF_COLS $NUMBER_OF_ALLOCATED_CELLS $NUMBER_OF_TRIALS  
echo
echo "Now we test a relatively parse case, but with a much larger matrix."
NUMBER_OF_ROWS=32
NUMBER_OF_COLS=32
NUMBER_OF_ALLOCATED_CELLS=8 
eval ./small $NUMBER_OF_ROWS $NUMBER_OF_COLS $NUMBER_OF_ALLOCATED_CELLS $NUMBER_OF_TRIALS  
echo "Now we test a relatively parse case, but with a much, much larger matrix."
NUMBER_OF_ROWS=100
NUMBER_OF_COLS=100
NUMBER_OF_ALLOCATED_CELLS=8 
eval ./small $NUMBER_OF_ROWS $NUMBER_OF_COLS $NUMBER_OF_ALLOCATED_CELLS $NUMBER_OF_TRIALS  
echo "Thanks for using this script. Have a good day."
