// Lemur OLAP library (c) 2003 National Research Council of Canada by Daniel Lemire, and Owen Kaser
/* 
 * Inspired by something on the web. Was posted on
 * http://www.massey.ac.nz/~mgwalker/misc/create-images.html
 * by someone who doesn't give himself credit.
 * Modified by D. Lemire.
 *
 *
 * This assumes you have pnglib on you machine with 
 * the developer package
 */

/* An attempt to write a PNG file that can be read be the likes of 
   Mozilla/IE/the GIMP.  It will only uses a very small portion of the
   available functionality of PNG.  All I want is to be able to create
   images.
*/

 /**
 *  This program is free software; you can
 *  redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation (version 2). This
 *  program is distributed in the hope that it will be useful, but WITHOUT ANY
 *  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 *  FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 *  details. You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#define PNG_DEBUG 3

#include <string>
#include <iostream>
//#include <setjmp.h> // removed by D.Lemire
#include <png.h> // if this fails and you have libpng, check
// to see if you have the developer package

using namespace std;// added by D. Lemire

class PNGImage {
public:
  PNGImage() : fp(NULL) {}
  PNGImage(string _filename, int _width, int _height) 
    : filename(_filename), 
      fp(NULL),
      png_ptr(NULL), info_ptr(NULL),
      width(_width), height(_height) {}
  ~PNGImage();
  
  bool openFileRead();
  bool openFileWrite();
  bool isPNG(int bytesToCheck);
  bool initReadStructs();
  bool initWriteStructs();
  bool writeHeader();
  bool writeImage(png_byte * RGB);
  bool writeEnd();

private:
  string filename;
  FILE* fp;
  png_structp png_ptr;
  png_infop info_ptr;
  int width, height;	
};


