// Lemur OLAP library (c) 2003 National Research Council of Canada by Daniel Lemire, and Owen Kaser
 /**
 *  This program is free software; you can
 *  redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation (version 2). This
 *  program is distributed in the hope that it will be useful, but WITHOUT ANY
 *  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 *  FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 *  details. You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef FUNCTIONAL_H
#define FUNCTIONAL_H

#include <functional>

// binary_function function object to do compare
template <class T>
class LessComparator : binary_function<T,T,bool>  {
public:
    LessComparator() {}
    bool operator()( const T & x, const T & y) const {
        return x < y;
    }
    static const string getDescription(void)  {return "Less-than ordering";}
};

// binary_function function object to do compare
template <class T>
class GreaterComparator : binary_function<T,T,bool>  {
public:
    GreaterComparator() {}
    bool operator()( const T& x, const T& y) const {
        return x > y;
    }
    static const string getDescription(void) {return "Greater-than ordering";}
};

// swaps the components of a pair, so I can sort maps by mapped-to value

template <class T1, class T2>
class PairFlipper : unary_function< pair<T1,T2>, pair<T2,T1> > {
public:
    PairFlipper() {}
    pair<T2,T1> operator() (const pair<T1,T2> & inp) {
        return pair<T1,T2>(inp.second, inp.first);
    }
};




#endif 
