/**
 *  (c) National Research Council of Canada, 2002-2003 by Daniel Lemire, Ph.D.
 *  Email lemire at ondelette dot com for support and details.
 */
 /**
 *  This program is free software; you can
 *  redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation (version 2). This
 *  program is distributed in the hope that it will be useful, but WITHOUT ANY
 *  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 *  FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 *  details. You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
package cofi.algorithms.util;


import JSci.maths.*;


/**
 *  Borrowing LU-Based solver from JSci 
 *  $Id$ $Date$ $Revision$ $Log$
 */
class JSciSolver {
      public static double[] solve(double[][] A, double[] B) { 
        DoubleSquareMatrix DSQ = new DoubleSquareMatrix(A);
        DoubleVector DV = new DoubleVector(B);
        DoubleVector Answer = LinearMath.solve(DSQ,DV);
        return JSci.util.VectorToolkit.toArray(Answer);
        
       }
}
