package jacob.tool;

import java.io.File;

import ccl.util.*;

import jacob.tool.JacobInterface;

import psp.timelog.*;

/**
 * 
 * @author  <a href="http://mats.gmd.de/clemens/">Chr. Clemens Lahme</a> (<a href="mailto:clemens.lahme@mailexcite.com"><i>Clemens.Lahme@mailexcite.com</i></a>)
 * @version $Id: TimelogWrapper.java,v 1.1 1998/02/28 22:48:32 clemens Exp clemens $
 */
public class TimelogWrapper implements JacobRunnable {
	private JacobInterface _pJacobInterface = null;
	private String _sToolName = "";

	public void set(JacobInterface pJacobInterface_) {
		Util.panicIf(pJacobInterface_ == null);
		_pJacobInterface = pJacobInterface_;
	}

	public TimelogWrapper() {
		super();
	}

	public void run() {
		Util.debug("TimelogWrapper.run().START");
		String[] asArg = new String[1];
		_sToolName = _pJacobInterface.getInit().getFileName();
		asArg[0] = _pJacobInterface.getInit().getFilePath();
		asArg[0] = FileUtil.concatPath(asArg[0], "psp") + 
				 File.separator;
		asArg[0] += _sToolName.toLowerCase() + ".timelog";
		_sToolName = "Timelog: " + _sToolName;
      Controller pController = new Controller(asArg,
															 Main.S_RCS_HEADER);
      pController.start();
		Util.debug("TimelogWrapper.run().END");
		_pJacobInterface.stopped(this);
   }

	public String toString() {
		return _sToolName;
	}
}
